/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.applet.Applet;
import java.awt.Font;
import java.awt.Frame;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import jv.object.PsDebug;
import jv.object.PsResource;
import jv.object.PsViewerIf;

public final class PsConfig {
    protected static final String PROGRAM = "JavaView";
    protected static final String PROJECT = "Visual Geometry Pages";
    protected static final String VERSION = "2.12.001";
    protected static final String TOPIC = "Reduce number of dialogs.";
    protected static final String COPYRIGHT = "Copyright 1999-2001";
    public static final String[] AUTHOR = new String[]{"Konrad Polthier", "Samy Khadem", "Eike Preu\u00df", "Ulrich Reitebuch"};
    public static String[] CONTRIBUTOR;
    public static final String HOMEPAGE = "http://www.javaview.de/";
    public static final String EMAIL = "support@javaview.de";
    public static final String HELP_HTML = "jars/help.html";
    public static final String FONTS_HTML = "jars/systemFonts.html";
    protected static ResourceBundle m_messages;
    protected static String m_codeBase;
    protected static char m_fileSeparator;
    protected static boolean m_bStandAlone;
    protected static Applet m_applet;
    protected static Frame m_frame;
    protected static PsViewerIf m_viewer;
    public static final int OS_WIN = 0;
    public static final int OS_IRIX = 1;
    public static final int OS_SOLARIS = 2;
    public static final int OS_LINUX = 3;
    public static final int OS_OTHER = 4;
    public static int m_osId;
    protected static String m_osName;
    protected static final int m_numFonts = 5;
    public static final int FONT_TEXT = 0;
    public static final int FONT_FIXED = 1;
    public static final int FONT_MENU = 2;
    public static final int FONT_HEADER2 = 3;
    public static final int FONT_HEADER4 = 4;
    protected static Font[] m_font;
    protected static String[][] m_fontName;
    protected static int[][] m_fontStyle;
    protected static int[][] m_fontSize;

    public static int getOSId() {
        return m_osId;
    }

    public static String getHomepage() {
        return HOMEPAGE;
    }

    public static String getProject() {
        return PROJECT;
    }

    public static String getTopic() {
        return TOPIC;
    }

    public static String getProgram() {
        return PROGRAM;
    }

    public static String[] getContributors() {
        CONTRIBUTOR = new String[]{"Klaus Hildebrandt <klaush@physik.tu-berlin.de> " + PsConfig.getMessage("UnfoldingOfSurfaces"), "Steve Dugaro / CECM <sdugaro@sfu.ca, www.cecm.sfu.ca> " + PsConfig.getMessage("CoordinateAxes") + ", " + PsConfig.getMessage("Ruler") + ", Maple", "Sergey Koval <512kse@mail.ru> " + PsConfig.getMessage("ClippingOfSurfaces") + ", " + PsConfig.getMessage("Booknot"), "Nick Kvasov <cernos@land6.nsu.ru> " + PsConfig.getMessage("ClippingOfSurfaces") + ", " + PsConfig.getMessage("Booknot"), "Axel Friedrich <axel@sfb288.math.tu-berlin.de> " + PsConfig.getMessage("AdaptiveRefinement"), "Tom Dudziak <tomdz@cs.tu-berlin.de> " + PsConfig.getMessage("VRMLFilter"), "Ernest Friedman-Hill / Sandia National Labs < > " + PsConfig.getMessage("PSGrPostScriptGraphics"), "Darius Bacon <djello@well.com> " + PsConfig.getMessage("ExpressionParsing"), "Bruce R. Miller <bruce.miller@nist.gov> " + PsConfig.getMessage("GuiStackLayoutManager"), "Jef Poskanzer <jef@acme.com, www.acme.com/java> " + PsConfig.getMessage("ImageExport") + ", " + PsConfig.getMessage("MessageBoxes"), "Marty Hall <hall@apl.jhu.edu, www.apl.jhu.edu/~hall> " + PsConfig.getMessage("ImageLabel") + ", " + PsConfig.getMessage("ThickEdges")};
        return CONTRIBUTOR;
    }

    public static Applet getApplet() {
        return m_applet;
    }

    public static PsViewerIf getViewer() {
        return m_viewer;
    }

    private static void parseSystemProperties(String aCodeBase) {
        if (!(aCodeBase == null || m_codeBase != null && m_codeBase.equals(aCodeBase))) {
            PsConfig.setCodeBase(aCodeBase);
        }
        try {
            m_osName = System.getProperty("os.name");
            if (m_osName != null) {
                if ((m_osName = m_osName.toLowerCase()).startsWith("win")) {
                    m_osId = 0;
                } else if (m_osName.startsWith("irix")) {
                    m_osId = 1;
                } else if (m_osName.startsWith("sun")) {
                    m_osId = 2;
                } else if (m_osName.startsWith("linux")) {
                    m_osId = 3;
                }
            }
            if (m_codeBase == null && System.getProperty("user.dir") != null) {
                PsConfig.setCodeBase(System.getProperty("user.dir"));
            }
        }
        catch (SecurityException se) {
            System.out.println("... not succeeded to access OS.NAME !!!");
            PsDebug.notify("cannot access a system property");
        }
    }

    public static Frame getFrame() {
        if (m_frame == null) {
            m_frame = new Frame(PsConfig.getProgram() + " v" + PsConfig.getVersion());
        }
        return m_frame;
    }

    public static String getMessage(String key) {
        String message = null;
        if (m_messages != null) {
            try {
                message = m_messages.getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (message == null) {
            message = PsResource.getString(key);
        }
        return message;
    }

    public static String getVersion() {
        int ind = VERSION.lastIndexOf(".000");
        if (ind == -1) {
            return VERSION;
        }
        return VERSION.substring(0, ind);
    }

    public static String getCodeBase() {
        return m_codeBase;
    }

    public static void setCodeBase(String aCodeBase) {
        m_codeBase = aCodeBase;
        if (m_codeBase != null) {
            char[] sep;
            if ((m_codeBase = m_codeBase.replace('\\', '/')).startsWith("file:")) {
                String cb = "";
                int last = 0;
                int next = 0;
                while ((next = m_codeBase.indexOf("%20", last)) > last) {
                    cb = cb + m_codeBase.substring(last, next) + " ";
                    last = next + 3;
                }
                if (last > 0 && last < m_codeBase.length()) {
                    cb = cb + m_codeBase.substring(last, m_codeBase.length());
                }
                if (!"".equals(cb)) {
                    m_codeBase = cb;
                }
            }
            if (PsConfig.isApplication() && m_codeBase != null && !m_codeBase.endsWith(new String(sep = new char[]{m_fileSeparator}))) {
                m_codeBase = m_codeBase + m_fileSeparator;
            }
        }
        PsDebug.append("codeBase = " + m_codeBase);
    }

    public static String getLanguage() {
        if (m_messages == null) {
            return "en";
        }
        return m_messages.getString("_language");
    }

    public static void setLanguage(String language) {
        Locale locale = Locale.ENGLISH;
        try {
            if (language.equalsIgnoreCase("de")) {
                locale = Locale.GERMAN;
                m_messages = ResourceBundle.getBundle("rsrc/Messages", locale);
            } else if (language.equalsIgnoreCase("fr")) {
                locale = Locale.FRENCH;
                m_messages = ResourceBundle.getBundle("rsrc/Messages", locale);
            } else if (language.equalsIgnoreCase("pt")) {
                locale = new Locale("pt", "");
                m_messages = ResourceBundle.getBundle("rsrc/Messages", locale);
            } else if (language.equalsIgnoreCase("ru")) {
                locale = new Locale("ru", "");
                m_messages = ResourceBundle.getBundle("rsrc/Messages", locale);
            } else if (language.equalsIgnoreCase("en")) {
                locale = null;
                m_messages = null;
            }
        }
        catch (Exception e) {
            m_messages = null;
        }
        if (!(m_messages == null || locale.getLanguage().equals(m_messages.getString("_language")) && locale.getCountry().equals(m_messages.getString("_country")))) {
            m_messages = null;
        }
    }

    public static Font getFont(int type) {
        if (type < 0 || type >= 5) {
            PsDebug.warning("type = " + type + " out of bounds.");
            type = 0;
        }
        if (m_font == null) {
            m_font = new Font[5];
        }
        if (m_font[type] == null) {
            PsConfig.m_font[type] = new Font(m_fontName[m_osId][type], m_fontStyle[m_osId][type], m_fontSize[m_osId][type]);
        }
        return m_font[type];
    }

    public static boolean setFont(int os, int type, String name, int style, int size) {
        if (type < 0 || type >= 5) {
            PsDebug.warning("type = " + type + " out of bounds.");
            return false;
        }
        if (os == -1) {
            os = m_osId;
        }
        if (os < 0 || os >= m_fontName.length) {
            PsDebug.warning("os = " + os + " out of bounds.");
            return false;
        }
        if (name != null) {
            PsConfig.m_fontName[os][type] = name;
        }
        if (style != -1) {
            PsConfig.m_fontStyle[os][type] = style;
        }
        if (size != -1) {
            PsConfig.m_fontSize[os][type] = size;
        }
        return true;
    }

    static {
        m_codeBase = null;
        m_fileSeparator = (char)47;
        m_bStandAlone = false;
        m_osId = 0;
        m_osName = null;
        m_fontName = new String[][]{{"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}, {"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}, {"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}, {"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}, {"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}};
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[5];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[5];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[5];
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[5];
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArrayArray[4] = nArray5;
        m_fontStyle = nArrayArray;
        m_fontSize = new int[][]{{12, 12, 14, 14, 12}, {8, 8, 10, 10, 8}, {10, 10, 12, 12, 10}, {10, 10, 12, 12, 10}, {8, 8, 10, 10, 8}};
    }

    public static Hashtable getProperties() {
        Hashtable<String, String> prop = new Hashtable<String, String>();
        String propName = null;
        try {
            Properties sysProp = System.getProperties();
            Enumeration keys = ((Hashtable)sysProp).keys();
            while (keys.hasMoreElements()) {
                propName = (String)keys.nextElement();
                prop.put(propName.toLowerCase(), System.getProperty(propName));
            }
        }
        catch (SecurityException se) {
            PsDebug.notify("cannot access a system property = " + propName);
        }
        prop.put("is_application", String.valueOf(PsConfig.isApplication()));
        if (!prop.containsKey("codebase")) {
            prop.put("codebase", PsConfig.getCodeBase());
        }
        return prop;
    }

    public static boolean isApplication() {
        return m_bStandAlone;
    }

    public static String getCopyright() {
        return COPYRIGHT;
    }

    public static String getOSName() {
        return m_osName;
    }

    public static void init(Applet applet, PsViewerIf viewer, Frame frame) {
        m_viewer = viewer;
        PsConfig.init(applet, frame);
    }

    public static void init(Applet applet, Frame frame) {
        m_applet = applet;
        m_frame = frame;
        String language = null;
        if (m_frame == null && applet != null) {
            m_bStandAlone = false;
            String tmp = m_applet.getAppletInfo();
            if (tmp != null) {
                tmp = tmp.replace('\n', '\t');
                tmp = tmp.replace('\r', '\n');
                PsDebug.append("*** Info of Current Applet ***\n\t" + tmp);
            }
            StringBuffer strBuf = new StringBuffer("");
            URL cbURL = m_applet.getCodeBase();
            PsConfig.setCodeBase(cbURL.toString());
            strBuf.append("codeBase = " + m_codeBase + "\n");
            strBuf.append("codeBase.getFile() = " + cbURL.getFile() + "\n");
            strBuf.append("codeBase.getHost() = " + cbURL.getHost() + "\n");
            strBuf.append("codeBase.getProtocol() = " + cbURL.getProtocol() + "\n");
            strBuf.append("docBase = " + m_applet.getDocumentBase() + "\n");
            PsDebug.notify(strBuf.toString());
            PsConfig.parseSystemProperties(m_codeBase.toString());
            PsDebug.notify("found codeBase = " + m_codeBase);
            language = applet.getParameter("language");
        } else {
            m_bStandAlone = true;
            PsConfig.parseSystemProperties(null);
            PsDebug.notify("use user.dir as codeBase = " + m_codeBase);
            try {
                language = System.getProperty("language");
            }
            catch (SecurityException se) {
                PsDebug.notify("cannot access JavaView language.");
            }
        }
        if (language != null) {
            PsDebug.append("User defined language = " + language);
        } else {
            language = "en";
        }
        PsConfig.setLanguage(language);
    }

    public static String getAuthors() {
        String tmp = AUTHOR[0];
        int i = 1;
        while (i < AUTHOR.length) {
            tmp = tmp + ", " + AUTHOR[i];
            ++i;
        }
        return tmp;
    }

    public static String getEmail() {
        return EMAIL;
    }

    public static char getFileSeparator() {
        return m_fileSeparator;
    }
}

