/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsTabPanel;

class PsTabsHeader
extends Panel {
    protected Font normalFont;
    protected Font boldFont;
    protected FontMetrics fmBoldFont;
    protected static int selUpper = 2;
    protected static int lineWidth = 1;
    protected static int horRound = 1;
    protected static int verRound = 1;
    protected static int XTitle = 4;
    protected static int YTitle = 2;
    protected int X;
    protected int Y;
    protected int Z;
    protected String[] arrName;
    protected int[] arrEnd;
    protected int[] arrBeg;
    protected int selected = 0;
    protected Dimension m_size;
    protected int m_oldWidth = 0;
    protected int m_oldHeight = 0;
    protected int m_numTabs;
    protected int m_maxNumTabs = 9;
    protected PsTabPanel m_tabPanel;
    protected boolean m_modified = false;

    public Dimension minimumLayoutSize() {
        return this.getPreferredSize();
    }

    protected void addPanel(String tabName, Panel aPanel) {
        if (this.m_numTabs >= this.m_maxNumTabs) {
            PsDebug.warning("too many tabs, numTabs = " + this.m_numTabs);
            return;
        }
        int i = 0;
        while (i < this.m_numTabs) {
            if (this.arrName[i].equals(tabName)) {
                PsDebug.notify("panel already included = " + tabName);
                return;
            }
            ++i;
        }
        this.arrName[this.m_numTabs] = tabName;
        ++this.m_numTabs;
        this.m_modified = true;
    }

    PsTabsHeader(PsTabPanel tabPanel) {
        this.addMouseListener(new PsTabsHeader_MA());
        this.m_tabPanel = tabPanel;
        this.normalFont = PsConfig.getFont(0);
        this.boldFont = PsConfig.getFont(3);
        this.fmBoldFont = super.getFontMetrics(this.boldFont);
        this.Z = this.fmBoldFont.getHeight() + 9;
        this.arrName = new String[this.m_maxNumTabs];
        this.arrEnd = new int[this.m_maxNumTabs];
        this.arrBeg = new int[this.m_maxNumTabs];
        super.setLayout(null);
    }

    public void paint(Graphics g) {
        Dimension m_size = this.getSize();
        if (m_size.width == 0 || m_size.height == 0 || this.m_numTabs == 0) {
            return;
        }
        if (m_size.width != this.m_oldWidth || m_size.height != this.m_oldHeight || this.m_modified) {
            this.m_modified = false;
            this.m_oldWidth = m_size.width;
            this.m_oldHeight = m_size.height;
            this.X = m_size.width;
            this.Y = m_size.height;
            int maxTextSize = m_size.width / this.m_numTabs;
            this.arrBeg[0] = 0;
            this.arrEnd[0] = maxTextSize + 2;
            int i = 1;
            while (i < this.m_numTabs) {
                this.arrBeg[i] = this.arrEnd[i - 1];
                this.arrEnd[i] = this.arrBeg[i] + maxTextSize;
                ++i;
            }
        }
        g.setColor(super.getBackground());
        g.fillRect(0, 0, this.X, this.Z + 1);
        int j = 0;
        while (j < this.m_numTabs) {
            int i2;
            if (j == this.selected) {
                g.setFont(this.boldFont);
                i2 = 0;
            } else {
                g.setFont(this.normalFont);
                i2 = 2;
            }
            g.setColor(Color.darkGray);
            g.drawLine(this.arrEnd[j] - 2, i2 + 2, this.arrEnd[j] - 2, this.Z - 2);
            g.setColor(Color.black);
            g.drawLine(this.arrEnd[j] - 1, i2 + 2, this.arrEnd[j] - 1, this.Z - 2);
            g.drawString(this.arrName[j], this.arrBeg[j] + 6, i2 + 4 + this.fmBoldFont.getAscent());
            g.setColor(Color.white);
            g.drawLine(this.arrBeg[j], i2 + 2, this.arrBeg[j], this.Z);
            g.drawLine(this.arrBeg[j] + 1, i2 + 1, this.arrEnd[j] - 3, i2 + 1);
            g.setColor(Color.lightGray);
            g.drawLine(this.arrBeg[j] + 1, i2 + 2, this.arrBeg[j] + 1, this.Z);
            g.drawLine(this.arrBeg[j] + 2, i2 + 2, this.arrEnd[j] - 3, i2 + 2);
            ++j;
        }
        g.setColor(Color.darkGray);
        int i = 0;
        while (i < 2) {
            if (this.selected != 0) {
                g.drawLine(0, this.Z - 2 + i, this.arrBeg[this.selected], this.Z - 2 + i);
            }
            if (this.selected != this.m_numTabs - 1) {
                g.drawLine(this.arrEnd[this.selected], this.Z - 2 + i, this.X, this.Z - 2 + i);
            }
            g.setColor(Color.white);
            ++i;
        }
    }

    public String getCurrentPanel() {
        return this.arrName[this.selected];
    }

    protected void show(String aName) {
        int tabInd = -1;
        int i = 0;
        while (i < this.m_numTabs) {
            if (this.arrName[i].equals(aName)) {
                tabInd = i;
                break;
            }
            ++i;
        }
        if (tabInd < 0 || tabInd > this.m_numTabs) {
            PsDebug.warning("panel not found = " + aName);
            return;
        }
        int n = this.selected;
        this.arrBeg[n] = this.arrBeg[n] + 2;
        int n2 = this.selected;
        this.arrEnd[n2] = this.arrEnd[n2] - 2;
        int n3 = this.selected = tabInd;
        this.arrBeg[n3] = this.arrBeg[n3] - 2;
        int n4 = this.selected;
        this.arrEnd[n4] = this.arrEnd[n4] + 2;
        Graphics g = super.getGraphics();
        if (g != null) {
            this.paint(g);
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getParent().getInsets();
        int w = 100;
        int h = 20;
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    public void init() {
        this.m_numTabs = 0;
    }

    protected void removePanel(String tabName) {
        int pos = -1;
        int i = 0;
        while (i < this.m_numTabs) {
            if (this.arrName[i].equals(tabName)) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            PsDebug.notify("panel does not exist = " + tabName);
            return;
        }
        i = pos;
        while (i < this.m_numTabs - 1) {
            this.arrName[i] = this.arrName[i + 1];
            ++i;
        }
        this.m_numTabs += -1;
        this.m_modified = true;
    }

    class PsTabsHeader_MA
    extends MouseAdapter {
        public void mousePressed(MouseEvent event) {
            if (event.getY() >= PsTabsHeader.this.Z) {
                return;
            }
            int i = 0;
            while (i < PsTabsHeader.this.m_numTabs) {
                if (PsTabsHeader.this.arrBeg[i] < event.getX() && event.getX() < PsTabsHeader.this.arrEnd[i]) {
                    if (i == PsTabsHeader.this.selected) {
                        return;
                    }
                    int n = PsTabsHeader.this.selected;
                    PsTabsHeader.this.arrBeg[n] = PsTabsHeader.this.arrBeg[n] + 2;
                    int n2 = PsTabsHeader.this.selected;
                    PsTabsHeader.this.arrEnd[n2] = PsTabsHeader.this.arrEnd[n2] - 2;
                    PsTabsHeader.this.selected = i;
                    PsTabsHeader.this.m_tabPanel.showFromHeader(PsTabsHeader.this.arrName[PsTabsHeader.this.selected]);
                    int n3 = PsTabsHeader.this.selected;
                    PsTabsHeader.this.arrBeg[n3] = PsTabsHeader.this.arrBeg[n3] - 2;
                    int n4 = PsTabsHeader.this.selected;
                    PsTabsHeader.this.arrEnd[n4] = PsTabsHeader.this.arrEnd[n4] + 2;
                    PsTabsHeader.this.paint(PsTabsHeader.this.getGraphics());
                    return;
                }
                ++i;
            }
        }

        PsTabsHeader_MA() {
            PsTabsHeader.this.getClass();
        }
    }
}

