/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;

public class PjProject
extends PsObject
implements PsTimeListenerIf,
PvPickListenerIf,
PsUpdateIf {
    protected PvDisplayIf m_display = null;
    protected Vector m_displayList = null;
    protected Vector m_rootGeometry = null;
    protected PgGeometryIf m_geometry = null;
    protected PsAnimation m_anim = null;
    protected String[][] m_parm = null;
    private PvViewerIf m_viewer = null;
    protected boolean m_bAutoFit = true;
    private static /* synthetic */ Class class$jv$project$PjProject;

    public void stop() {
        if (this.m_anim != null) {
            this.m_anim.stop();
            if (this.m_anim.hasAnimationPanel()) {
                ((Component)this.m_anim.getAnimationPanel()).setVisible(false);
            }
        }
        if (this.m_displayList != null) {
            Enumeration e = this.getDisplays();
            while (e.hasMoreElements()) {
                PvDisplayIf disp = (PvDisplayIf)e.nextElement();
                if (disp.hasPickListener(this)) {
                    disp.removePickListener(this);
                }
                disp.stop();
            }
        }
    }

    public int getNumGeometries() {
        return this.m_rootGeometry.size();
    }

    public void setEnabledAutoFit(boolean flag) {
        this.m_bAutoFit = flag;
    }

    public boolean setTime(PsTimeEvent time) {
        PsDebug.warning("method must be overwritten");
        return false;
    }

    public PvViewerIf getViewer() {
        return this.m_viewer;
    }

    public void setViewer(PvViewerIf viewer) {
        this.m_viewer = viewer;
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public void setAnimation(PsAnimation anAnimation) {
        this.m_anim = anAnimation;
    }

    public boolean hasDisplay(PvDisplayIf display) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.contains(display);
    }

    public boolean removeDisplay(PvDisplayIf display) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.removeElement(display);
    }

    public void dragInitial(PvPickEvent pos) {
        this.pickInitial(pos);
    }

    public void start() {
        if (this.m_anim != null && this.m_anim.hasAnimationPanel()) {
            ((Component)this.m_anim.getAnimationPanel()).setVisible(true);
        }
        if (this.isEnabledAutoFit()) {
            this.fitDisplays();
        }
    }

    public void dragVertex(PgGeometryIf geom, int vertexIndex, PdVector vertex) {
        this.pickVertex(geom, vertexIndex, vertex);
    }

    public String getParameter(String parmLabel) {
        if (this.m_parm != null) {
            int i = 0;
            while (i < this.m_parm.length) {
                if (this.m_parm[i][0].equals(parmLabel.toLowerCase())) {
                    return this.m_parm[i][2].trim();
                }
                ++i;
            }
        }
        PsDebug.warning("label = " + parmLabel + " not found.");
        return null;
    }

    public void setParameter(String[][] parm) {
        this.m_parm = parm;
    }

    public void unmarkVertices(PvPickEvent markBox) {
        PgGeometryIf geom = markBox.getGeometry();
        if (geom != null) {
            geom.update(null);
        }
    }

    public void pickInitial(PvPickEvent pos) {
        PsDebug.notify("method should be overwritten");
    }

    public boolean addGeometry(PgGeometryIf aGeometry) {
        return this.addGeometry(aGeometry, true);
    }

    public boolean addGeometry(PgGeometryIf aGeometry, boolean bUpdateDisplay) {
        if (aGeometry == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (!this.m_rootGeometry.contains(aGeometry)) {
            this.m_rootGeometry.addElement(aGeometry);
        }
        if (this.m_display != null && !this.m_display.containsGeometry(aGeometry)) {
            this.m_display.addGeometry(aGeometry);
            if (bUpdateDisplay) {
                this.m_display.update(this.m_display);
            }
        }
        if (this.m_geometry == null) {
            this.m_geometry = aGeometry;
        }
        return true;
    }

    public void markVertices(PvPickEvent markBox) {
        PgGeometryIf geom = markBox.getGeometry();
        if (geom != null) {
            geom.update(null);
        }
    }

    public void setDisplay(PvDisplayIf disp) {
        if (disp == null) {
            PsDebug.warning("missing argument");
            return;
        }
        this.m_display = disp;
        if (!this.hasDisplay(disp)) {
            this.addDisplay(disp);
        }
        Enumeration e = this.m_rootGeometry.elements();
        while (e.hasMoreElements()) {
            PgGeometryIf geom = (PgGeometryIf)e.nextElement();
            if (this.m_display.containsGeometry(geom)) continue;
            this.m_display.addGeometry(geom);
        }
        if (this.m_geometry != null) {
            this.m_display.selectGeometry(this.m_geometry);
        }
        this.m_display.addPickListener(this);
        this.m_display.update(this.m_display);
    }

    public PvDisplayIf getDisplay() {
        return this.m_display;
    }

    public boolean selectDisplay(PvDisplayIf disp) {
        if (!this.hasDisplay(disp)) {
            return false;
        }
        this.m_display = disp;
        return true;
    }

    public void fitDisplays() {
        if (this.m_displayList == null) {
            return;
        }
        Enumeration e = this.m_displayList.elements();
        while (e.hasMoreElements()) {
            PvDisplayIf disp = (PvDisplayIf)e.nextElement();
            disp.fit();
            disp.update(null);
        }
    }

    public Enumeration getDisplays() {
        if (this.m_displayList == null) {
            return null;
        }
        return this.m_displayList.elements();
    }

    public PjProject(String aName) {
        this.setTag(4);
        this.setName(aName);
        this.m_rootGeometry = new Vector(1);
        if (this.getClass() == (class$jv$project$PjProject != null ? class$jv$project$PjProject : (class$jv$project$PjProject = PjProject.class$("jv.project.PjProject")))) {
            this.init();
        }
    }

    public boolean isEnabledAutoFit() {
        return this.m_bAutoFit;
    }

    public void selectGeometry(PgGeometryIf aGeometry) {
        if (aGeometry == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (!this.m_rootGeometry.contains(aGeometry)) {
            return;
        }
        this.m_geometry = aGeometry;
        if (this.m_display != null) {
            this.m_display.selectGeometry(this.m_geometry);
            this.m_display.update(this.m_display);
        }
    }

    public PgGeometryIf getGeometry(int anInd) {
        return (PgGeometryIf)this.m_rootGeometry.elementAt(anInd);
    }

    public PgGeometryIf getGeometry() {
        return this.m_geometry;
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void removeGeometries() {
        if (this.m_displayList == null || this.m_displayList.size() == 0) {
            return;
        }
        Enumeration ed = this.m_displayList.elements();
        while (ed.hasMoreElements()) {
            PvDisplayIf disp = (PvDisplayIf)ed.nextElement();
            Enumeration e = this.m_rootGeometry.elements();
            while (e.hasMoreElements()) {
                PgGeometryIf geom = (PgGeometryIf)e.nextElement();
                if (!disp.containsGeometry(geom)) continue;
                disp.removeGeometry(geom);
            }
            disp.update(disp);
        }
        this.m_rootGeometry.removeAllElements();
        this.m_geometry = null;
    }

    public boolean hasAnimation() {
        return this.m_anim != null;
    }

    public void dragDisplay(PvPickEvent pos) {
        this.pickDisplay(pos);
    }

    public void dispose() {
        this.stop();
        if (this.m_anim != null && this.m_anim.hasAnimationPanel()) {
            this.m_anim.getAnimationPanel().dispose();
        }
        this.removeGeometries();
        this.m_rootGeometry = null;
        this.m_display = null;
        this.m_displayList = null;
        this.m_anim = null;
    }

    public boolean addDisplay(PvDisplayIf display) {
        if (this.m_displayList == null) {
            this.m_displayList = new Vector();
        } else if (this.hasDisplay(display)) {
            PsDebug.warning("display = " + display.getName() + " of display already registered.");
            return false;
        }
        this.m_displayList.addElement(display);
        return true;
    }

    public void pickDisplay(PvPickEvent pos) {
        PsDebug.notify("method should be overwritten");
    }

    public void init() {
        super.init();
        if (this.m_anim != null) {
            this.m_anim.stop();
        }
    }

    public void removeGeometry(PgGeometryIf aGeometry) {
        if (aGeometry == null) {
            PsDebug.warning("missing argument");
            return;
        }
        this.m_rootGeometry.removeElement(aGeometry);
        if (this.m_display != null) {
            this.m_display.removeGeometry(aGeometry);
        }
        if (this.m_geometry == aGeometry) {
            if (this.m_rootGeometry.elements().hasMoreElements()) {
                this.m_geometry = (PgGeometryIf)this.m_rootGeometry.firstElement();
                this.selectGeometry(this.m_geometry);
            } else {
                this.m_geometry = null;
            }
        }
        if (this.m_display != null) {
            this.m_display.update(this.m_display);
        }
    }

    public void pickVertex(PgGeometryIf geom, int vertexIndex, PdVector vertex) {
        PsDebug.notify("method should be overwritten");
    }
}

