/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;

public final class PsGeometryInfo
extends PsObject {
    protected String m_abstract;
    protected String m_detail;
    protected String m_primary;
    protected String[] m_secondary;
    protected String[] m_keyword;
    protected String m_zentralblatt;
    protected String m_software;

    public void setAbstract(String abstr) {
        this.m_abstract = abstr;
    }

    public String getZentralblatt() {
        return this.m_zentralblatt;
    }

    public void setZentralblatt(String zentralblatt) {
        this.m_zentralblatt = zentralblatt;
    }

    public PsGeometryInfo() {
        this.init();
    }

    public String getSoftware() {
        return this.m_software;
    }

    public void setSoftware(String software) {
        this.m_software = software;
    }

    public String[] getKeywords() {
        return this.m_keyword;
    }

    public void setKeywords(String[] keywords) {
        this.m_keyword = keywords;
    }

    public String getDetail() {
        return this.m_detail;
    }

    public void setDetail(String detail) {
        this.m_detail = detail;
    }

    public String getPrimary() {
        return this.m_primary;
    }

    public void setPrimary(String primary) {
        this.m_primary = primary;
    }

    public PsXmlNode getXmlNode() {
        PsXmlNode description = new PsXmlNode("description");
        description.addChild("abstract", this.m_abstract);
        PsXmlNode detail = null;
        if (this.m_detail == null) {
            return description;
        }
        String detailTrim = this.m_detail.trim();
        if (!detailTrim.startsWith("<p>")) {
            detail = description.addChild("detail", "<p>\n" + detailTrim + "\n</p>");
        }
        if (detail == null) {
            description.addChild("detail", this.m_detail);
        }
        PsXmlNode msc2000 = description.addChild("msc2000");
        msc2000.addChild("primary", this.m_primary);
        if (this.m_secondary != null && this.m_secondary.length > 0) {
            int i = 0;
            while (i < this.m_secondary.length) {
                if (this.m_secondary[i] != null && !this.m_secondary[i].equals("")) {
                    msc2000.addChild("secondary", this.m_secondary[i]);
                }
                ++i;
            }
        } else {
            msc2000.addChild("secondary", "");
        }
        PsXmlNode keywords = description.addChild("keywords");
        if (this.m_keyword != null && this.m_keyword.length > 0) {
            int i = 0;
            while (i < this.m_keyword.length) {
                if (this.m_keyword[i] != null && !this.m_keyword[i].equals("")) {
                    keywords.addChild("keyword", this.m_keyword[i]);
                }
                ++i;
            }
        } else {
            keywords.addChild("keyword", "");
        }
        if (this.m_zentralblatt != null) {
            description.addChild("zentralblatt", this.m_zentralblatt);
        }
        description.addChild("software", this.m_software);
        return description;
    }

    public void setXmlNode(PsXmlNode description, PsXmlNode classification) {
        this.init();
        if (description == null) {
            PsDebug.warning("missing method argument.");
            return;
        }
        boolean bOldStyle = false;
        if (classification != null) {
            bOldStyle = true;
        }
        if (bOldStyle) {
            PsXmlNode keywords;
            int i;
            this.m_primary = PsXmlSrc.getRsrc(classification, "primary");
            PsXmlNode[] secondary = PsXmlSrc.getRsrcNodes(classification, "secondary");
            if (secondary != null && secondary.length > 0) {
                this.m_secondary = new String[secondary.length];
                i = 0;
                while (i < secondary.length) {
                    this.m_secondary[i] = secondary[i].getContent();
                    if (this.m_secondary[i] == null) {
                        this.m_secondary[i] = "";
                    }
                    ++i;
                }
            }
            if ((keywords = PsXmlSrc.getRsrcNode(classification, "keywords")) != null) {
                PsXmlNode[] keyword = PsXmlSrc.getRsrcNodes(keywords, "keyword");
                if (keyword != null && keyword.length > 0) {
                    this.m_keyword = new String[keyword.length];
                    i = 0;
                    while (i < keyword.length) {
                        this.m_keyword[i] = PsXmlSrc.getRsrc(keyword[i], "keyword");
                        if (this.m_keyword[i] == null) {
                            this.m_keyword[i] = "";
                        }
                        ++i;
                    }
                }
            } else {
                PsDebug.warning("missing keywords node.");
            }
            this.m_abstract = PsXmlSrc.getRsrc(description, "abstract");
            PsXmlNode detail = PsXmlSrc.getRsrcNode(description, "detail");
            if (detail != null) {
                PsXmlNode[] p;
                this.m_detail = "";
                if (detail.getContent() != null) {
                    PsDebug.warning("Detail content not enclosed with <p> tags: <p>paragraph</p>.");
                    this.m_detail = detail.getContent();
                }
                if ((p = PsXmlSrc.getRsrcNodes(detail, "p")) != null && p.length > 0) {
                    i = 0;
                    while (i < p.length) {
                        if (!p[i].isMixedMode()) {
                            this.m_detail = this.m_detail + "<p>" + p[i].getContent() + "</p>\n";
                        } else {
                            StringBuffer xml = new StringBuffer("");
                            if ((xml = PsXmlNode.writeNode(xml, p[i], "")) != null) {
                                this.m_detail = this.m_detail + xml.toString() + "\n";
                            }
                        }
                        ++i;
                    }
                }
            }
        } else {
            PsXmlNode keywords;
            PsXmlNode msc2000;
            int i;
            PsXmlNode[] p;
            this.m_abstract = PsXmlSrc.getRsrc(description, "abstract");
            PsXmlNode detail = PsXmlSrc.getRsrcNode(description, "detail");
            if (detail == null) {
                return;
            }
            this.m_detail = "";
            if (detail.getContent() != null) {
                this.m_detail = detail.getContent();
            }
            if ((p = PsXmlSrc.getRsrcNodes(detail, "p")) != null && p.length > 0) {
                i = 0;
                while (i < p.length) {
                    if (!p[i].isMixedMode()) {
                        this.m_detail = p[i].getContent() == null ? this.m_detail + "<p></p>\n" : this.m_detail + "<p>" + p[i].getContent() + "</p>\n";
                    } else {
                        StringBuffer xml = new StringBuffer("");
                        if ((xml = PsXmlNode.writeNode(xml, p[i], "")) != null) {
                            this.m_detail = this.m_detail + xml.toString();
                        }
                    }
                    ++i;
                }
            }
            if ((msc2000 = PsXmlSrc.getRsrcNode(description, "msc2000")) == null) {
                PsDebug.warning("missing element: msc2000.");
                return;
            }
            this.m_primary = PsXmlSrc.getRsrc(msc2000, "primary");
            PsXmlNode[] secondary = PsXmlSrc.getRsrcNodes(msc2000, "secondary");
            if (secondary != null && secondary.length > 0) {
                this.m_secondary = new String[secondary.length];
                i = 0;
                while (i < secondary.length) {
                    this.m_secondary[i] = secondary[i].getContent();
                    if (this.m_secondary[i] == null) {
                        this.m_secondary[i] = "";
                    }
                    ++i;
                }
            }
            if ((keywords = PsXmlSrc.getRsrcNode(description, "keywords")) == null) {
                PsDebug.warning("missing element: keywords.");
                return;
            }
            PsXmlNode[] keyword = PsXmlSrc.getRsrcNodes(keywords, "keyword");
            if (keyword == null || keyword.length == 0) {
                PsDebug.warning("missing element: keyword.");
                return;
            }
            this.m_keyword = new String[keyword.length];
            i = 0;
            while (i < keyword.length) {
                this.m_keyword[i] = keyword[i].getContent();
                if (this.m_keyword[i] == null) {
                    this.m_keyword[i] = "";
                }
                ++i;
            }
            this.m_zentralblatt = PsXmlSrc.getRsrc(description, "zentralblatt");
            this.m_software = PsXmlSrc.getRsrc(description, "software");
        }
    }

    public String getKeyword(int ind) {
        return this.m_keyword[ind];
    }

    public void setSecondaries(String[] secondary) {
        this.m_secondary = secondary;
    }

    public void init() {
        super.init();
        this.m_abstract = null;
        this.m_detail = null;
        this.m_primary = null;
        this.m_secondary = null;
        this.m_keyword = null;
        this.m_zentralblatt = null;
        this.m_software = null;
    }

    public Object clone() {
        PsGeometryInfo clone = (PsGeometryInfo)super.clone();
        if (clone == null) {
            return null;
        }
        if (this.m_keyword != null) {
            clone.m_keyword = (String[])this.m_keyword.clone();
        }
        if (this.m_secondary != null) {
            clone.m_secondary = (String[])this.m_secondary.clone();
        }
        return clone;
    }

    public String[] getSecondary() {
        return this.m_secondary;
    }

    public String getSecondary(int ind) {
        return this.m_secondary[ind];
    }

    public String getAbstract() {
        return this.m_abstract;
    }
}

