/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.acmeEncoders;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import jv.thirdParty.acmeEncoders.ImageEncoder;

public class PpmEncoder
extends ImageEncoder {
    public PpmEncoder(Image img, OutputStream out) throws IOException {
        super(img, out);
    }

    public PpmEncoder(ImageProducer prod, OutputStream out) throws IOException {
        super(prod, out);
    }

    void encodeDone() throws IOException {
    }

    void encodeStart(int width, int height) throws IOException {
        PpmEncoder.writeString(this.out, "P6\n");
        PpmEncoder.writeString(this.out, width + " " + height + "\n");
        PpmEncoder.writeString(this.out, "255\n");
    }

    static void writeString(OutputStream out, String str) throws IOException {
        byte[] buf = str.getBytes();
        out.write(buf);
    }

    void encodePixels(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        byte[] ppmPixels = new byte[w * 3];
        int rowOff = off;
        int row = 0;
        while (row < h) {
            int j = 0;
            int col = 0;
            while (col < w) {
                ppmPixels[j++] = (byte)(rgbPixels[rowOff] >> 16 & 0xFF);
                ppmPixels[j++] = (byte)(rgbPixels[rowOff] >> 8 & 0xFF);
                ppmPixels[j++] = (byte)(rgbPixels[rowOff] & 0xFF);
                ++rowOff;
                ++col;
            }
            this.out.write(ppmPixels);
            rowOff += scansize;
            ++row;
        }
    }
}

