/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.number.PuComplex;
import jv.number.PuString;
import jv.object.PsDebug;

public class PcMatrix
implements Serializable {
    protected int m_iSize = 0;
    protected int m_jSize = 0;
    public PuComplex[][] m_data;

    public void rightMult(PcMatrix m) {
        int j;
        if (m == null || m.m_iSize != m.m_jSize || m.m_iSize != this.m_jSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int jSize = m.m_jSize;
        PuComplex[][] tmp = new PuComplex[this.m_iSize][jSize];
        int i = 0;
        while (i < this.m_iSize) {
            j = 0;
            while (j < jSize) {
                tmp[i][j] = new PuComplex(0.0, 0.0);
                int k = 0;
                while (k < this.m_jSize) {
                    tmp[i][j].add(PuComplex.mult(this.m_data[i][k], m.m_data[k][j]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_iSize) {
            j = 0;
            while (j < jSize) {
                this.m_data[i][j] = tmp[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void multScalar(PuComplex scalar) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j].mult(scalar);
                ++j;
            }
            ++i;
        }
    }

    public void multScalar(PcMatrix m, PuComplex scalar) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j].copy(m.m_data[i][j]);
                this.m_data[i][j].mult(scalar);
                ++j;
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append("PcMatrix \n");
        strBuf.append("\t m_iSize = " + this.m_iSize);
        strBuf.append(", m_jSize = " + this.m_jSize);
        if (this.m_data == null) {
            strBuf.append("\t m_data = null\n");
        } else {
            int i = 0;
            while (i < this.m_iSize) {
                strBuf.append("\t [" + PuString.intToString(i, 3) + "] = {");
                strBuf.append(" " + this.m_data[i][0].toString());
                ++i;
            }
            strBuf.append("}\n");
        }
        return strBuf.toString();
    }

    public PcMatrix() {
    }

    public PcMatrix(int aSize) {
        this.setSize(aSize, aSize);
    }

    public PcMatrix(int iSize, int jSize) {
        this.setSize(iSize, jSize);
    }

    public void add(PcMatrix m) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j].add(m.m_data[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void add(PcMatrix m1, PcMatrix m2) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j].copy(m1.m_data[i][j]);
                this.m_data[i][j].add(m2.m_data[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public String toShortString() {
        StringBuffer strBuf = new StringBuffer("");
        if (this.m_data == null) {
            strBuf.append("\t m_data = null\n");
        } else {
            int i = 0;
            while (i < this.m_iSize) {
                strBuf.append("\t [" + PuString.intToString(i, 3) + "] = {");
                int j = 0;
                while (j < this.m_jSize) {
                    strBuf.append(" " + this.m_data[i][j].toString());
                    ++j;
                }
                strBuf.append("\n");
                ++i;
            }
            strBuf.append("}\n");
        }
        return strBuf.toString();
    }

    public PuComplex[] eigenvalues() {
        if (this.m_jSize != this.m_iSize || this.m_iSize != 2) {
            PsDebug.warning("only implemented for 2x2");
            return null;
        }
        PuComplex[] ret = new PuComplex[2];
        PuComplex one = new PuComplex(this.m_data[0][0]);
        one.sqr();
        one.add(PuComplex.sqr(this.m_data[1][1]));
        one.sub(PuComplex.mult(PuComplex.mult(this.m_data[0][0], this.m_data[1][1]), 2.0));
        one.div(4.0);
        one.add(PuComplex.mult(this.m_data[1][0], this.m_data[0][1]));
        one.sqrt();
        PuComplex part1 = new PuComplex();
        part1.copy(this.m_data[0][0]);
        part1.add(this.m_data[1][1]);
        part1.div(2.0);
        ret[0] = PuComplex.add(part1, one);
        ret[1] = PuComplex.sub(part1, one);
        return ret;
    }

    public void transpose() {
        PuComplex tmp = new PuComplex();
        int i = 0;
        while (i < this.m_iSize) {
            int j = i + 1;
            while (j < this.m_jSize) {
                tmp.copy(this.m_data[i][j]);
                this.m_data[i][j].copy(this.m_data[j][i]);
                this.m_data[j][i].copy(tmp);
                ++j;
            }
            ++i;
        }
    }

    public void sub(PcMatrix m) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j].sub(m.m_data[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void sub(PcMatrix m1, PcMatrix m2) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j].copy(m1.m_data[i][j]);
                this.m_data[i][j].sub(m2.m_data[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public static PcMatrix copyNew(PcMatrix mat) {
        if (mat == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        if (mat.m_data == null) {
            PsDebug.warning("missing argument data mat.m_data", mat);
            return null;
        }
        PcMatrix newMatrix = new PcMatrix(mat.m_iSize, mat.m_jSize);
        newMatrix.copy(mat);
        return newMatrix;
    }

    public void copy(PcMatrix m) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j].copy(m.m_data[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public PuComplex[] aEigenvector(PuComplex l) {
        PuComplex[] ret = new PuComplex[2];
        PcMatrix MlE = new PcMatrix(2);
        MlE.m_data[0][0].copy(PuComplex.sub(this.m_data[0][0], l));
        MlE.m_data[0][1].copy(this.m_data[0][1]);
        MlE.m_data[1][0].copy(this.m_data[1][0]);
        MlE.m_data[1][1].copy(PuComplex.sub(this.m_data[1][1], l));
        boolean[][] zero = new boolean[2][2];
        boolean allzero = true;
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                if (MlE.m_data[i][j].abs() < 1.0E-10) {
                    zero[i][j] = true;
                } else {
                    allzero = false;
                    zero[i][j] = false;
                }
                ++j;
            }
            ++i;
        }
        if (allzero) {
            PsDebug.warning("eigenspace=CxC, eigenvalue=" + l.toString());
            ret[0] = new PuComplex(1.0, 0.0);
            ret[1] = new PuComplex(0.0, 0.0);
            return ret;
        }
        if (zero[0][0] && zero[1][0]) {
            PsDebug.warning("eigenspace=Cx{0}, eigenvalue=" + l.toString());
            ret[0] = new PuComplex(1.0, 0.0);
            ret[1] = new PuComplex(0.0, 0.0);
            return ret;
        }
        if (zero[0][0]) {
            MlE.m_data[0][0].copy(MlE.m_data[1][0]);
            MlE.m_data[1][0].set(0.0, 0.0);
            PuComplex buf = new PuComplex(MlE.m_data[0][1]);
            MlE.m_data[0][1].copy(MlE.m_data[1][1]);
            MlE.m_data[1][1].copy(buf);
        }
        PuComplex gauss11 = new PuComplex();
        gauss11.copy(MlE.m_data[0][1]);
        gauss11.mult(MlE.m_data[1][0]);
        gauss11.div(MlE.m_data[0][0]);
        gauss11.mult(-1.0);
        gauss11.add(MlE.m_data[1][1]);
        if (gauss11.abs() > 0.001) {
            PsDebug.warning("eigenspace degenerated, eigenvalue=" + l.toString() + "; botrig=" + gauss11.toString() + "\n\t" + MlE.toShortString());
            return null;
        }
        ret[0] = new PuComplex(1.0, 0.0);
        ret[1] = PuComplex.div(MlE.m_data[0][0], MlE.m_data[0][1]);
        ret[1].mult(-1.0);
        return ret;
    }

    public void mult(PcMatrix m1, PcMatrix m2) {
        if (this == m1 || this == m2) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        int iSize = m1.m_iSize;
        int jSize = m2.m_jSize;
        int kSize = m1.m_jSize;
        if (this.m_iSize != iSize || this.m_jSize != jSize) {
            this.setSize(iSize, jSize);
        }
        int i = 0;
        while (i < iSize) {
            int j = 0;
            while (j < jSize) {
                this.m_data[i][j].set(0.0, 0.0);
                int k = 0;
                while (k < kSize) {
                    this.m_data[i][j].add(PuComplex.mult(m1.m_data[i][k], m2.m_data[k][j]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public int getISize() {
        return this.m_iSize;
    }

    public int getJSize() {
        return this.m_jSize;
    }

    public int getSize() {
        if (this.m_iSize == this.m_jSize) {
            return this.m_iSize;
        }
        return -1;
    }

    public void setSize(int aSize) {
        this.setSize(aSize, aSize);
    }

    public void setSize(int iSize, int jSize) {
        if (this.m_iSize == iSize && this.m_jSize == jSize) {
            return;
        }
        this.m_iSize = iSize;
        this.m_jSize = jSize;
        this.m_data = new PuComplex[this.m_iSize][this.m_jSize];
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j] = new PuComplex(0.0, 0.0);
                ++j;
            }
            ++i;
        }
    }

    public Object clone() {
        return PcMatrix.copyNew(this);
    }

    public void setIdentity() {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j].set(0.0, 0.0);
                ++j;
            }
            ++i;
        }
        int k = Math.min(this.m_iSize, this.m_jSize);
        int i2 = 0;
        while (i2 < k) {
            this.m_data[i2][i2].set(1.0, 0.0);
            ++i2;
        }
    }

    public void setConstant(PuComplex aValue) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j].copy(aValue);
                ++j;
            }
            ++i;
        }
    }

    public boolean isSquare() {
        return this.m_iSize == this.m_jSize;
    }

    public void leftMult(PcMatrix m) {
        int j;
        if (m == null || m.m_iSize != m.m_jSize || m.m_iSize != this.m_iSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int iSize = m.m_iSize;
        PuComplex[][] tmp = new PuComplex[iSize][this.m_jSize];
        int i = 0;
        while (i < iSize) {
            j = 0;
            while (j < this.m_jSize) {
                tmp[i][j] = new PuComplex(0.0, 0.0);
                int k = 0;
                while (k < this.m_iSize) {
                    tmp[i][j].add(PuComplex.mult(m.m_data[i][k], this.m_data[k][j]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < iSize) {
            j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j] = tmp[i][j];
                ++j;
            }
            ++i;
        }
    }
}

