/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PuLorentz {
    public static void normalize(PdVector p, PdVector sign) {
        PuLorentz.setLength(p, 1.0, sign);
    }

    public static double dot(PdVector p, PdVector q, PdVector sign) {
        double sum = 0.0;
        int i = 0;
        while (i < p.m_data.length) {
            sum += p.m_data[i] * q.m_data[i] * sign.m_data[i];
            ++i;
        }
        return sum;
    }

    public static double distMinkowski(PdVector p, PdVector q, PdVector sign) {
        return Math.sqrt(PuLorentz.sqrDistMinkowski(p, q, sign));
    }

    public static void getTangentAtOrigin(PdVector tangent, PdVector p, PdVector sign) {
        int ind = PuLorentz.indexOfTime(sign);
        tangent.copy(p);
        tangent.m_data[ind] = 0.0;
        PuLorentz.setLength(tangent, 1.0, sign);
    }

    public static void rotateAtOrigin(PdMatrix mat, PdVector p, double angle, PdVector sign) {
        double s = PuLorentz.distToOrigin(p, sign);
        if (s < 1.0E-10) {
            mat.setIdentity();
            return;
        }
        PdVector tangent = new PdVector(p.getSize());
        PuLorentz.getTangentAtOrigin(tangent, p, sign);
        double ca = Math.cos(angle *= Math.PI / 180);
        double sa = Math.sin(angle);
        double omca = 1.0 - ca;
        double[][] matData = mat.m_data;
        double[] t = tangent.m_data;
        matData[0][0] = 1.0;
        matData[0][3] = 0.0;
        matData[0][2] = 0.0;
        matData[0][1] = 0.0;
        matData[3][0] = 0.0;
        matData[2][0] = 0.0;
        matData[1][0] = 0.0;
        matData[1][1] = ca + t[1] * t[1] * omca;
        matData[1][2] = t[3] * sa + t[1] * t[2] * omca;
        matData[1][3] = -t[2] * sa + t[1] * t[3] * omca;
        matData[2][1] = -t[3] * sa + t[1] * t[2] * omca;
        matData[2][2] = ca + t[2] * t[2] * omca;
        matData[2][3] = t[1] * sa + t[2] * t[3] * omca;
        matData[3][1] = t[2] * sa + t[1] * t[3] * omca;
        matData[3][2] = -t[1] * sa + t[2] * t[3] * omca;
        matData[3][3] = ca + t[3] * t[3] * omca;
    }

    public static void reflectAtOrigin(PdMatrix mat, PdVector q, PdVector r, PdVector sign) {
        if (PuLorentz.distToOrigin(q, sign) < 1.0E-10 || PuLorentz.distToOrigin(r, sign) < 1.0E-10) {
            mat.setIdentity();
            return;
        }
        int dim = q.getSize();
        PdVector tq = new PdVector(dim);
        PdVector tr = new PdVector(dim);
        PuLorentz.getTangentAtOrigin(tq, q, sign);
        PuLorentz.getTangentAtOrigin(tr, r, sign);
        PdVector tq3 = new PdVector(dim - 1);
        PdVector tr3 = new PdVector(dim - 1);
        int i = 0;
        while (i < dim - 1) {
            tq3.m_data[i] = tq.m_data[i + 1];
            tr3.m_data[i] = tr.m_data[i + 1];
            ++i;
        }
        PdVector n3 = PdVector.crossNew(tq3, tr3);
        n3.normalize();
        PdVector normal = new PdVector(dim);
        double[] n = normal.m_data;
        n[0] = 0.0;
        i = 0;
        while (i < dim - 1) {
            n[i + 1] = n3.m_data[i];
            ++i;
        }
        double[][] matData = mat.m_data;
        matData[0][0] = 1.0 + 2.0 * n[0] * n[0];
        matData[0][1] = -2.0 * n[1] * n[0];
        matData[0][2] = -2.0 * n[2] * n[0];
        matData[0][3] = -2.0 * n[3] * n[0];
        matData[1][0] = -matData[0][1];
        matData[1][1] = 1.0 - 2.0 * n[1] * n[1];
        matData[1][2] = -2.0 * n[2] * n[1];
        matData[1][3] = -2.0 * n[3] * n[1];
        matData[2][0] = -matData[0][2];
        matData[2][1] = matData[1][2];
        matData[2][2] = 1.0 - 2.0 * n[2] * n[2];
        matData[2][3] = -2.0 * n[3] * n[2];
        matData[3][0] = -matData[0][3];
        matData[3][1] = matData[1][3];
        matData[3][2] = matData[2][3];
        matData[3][3] = 1.0 - 2.0 * n[3] * n[3];
    }

    public static void reflectAtPlane(PdMatrix mat, PdVector p, PdVector q, PdVector r, PdVector sign) {
        if (PuLorentz.dist(p, q, sign) < 1.0E-10 || PuLorentz.dist(p, r, sign) < 1.0E-10 || PuLorentz.dist(q, r, sign) < 1.0E-10) {
            mat.setIdentity();
            return;
        }
        int dim = p.getSize();
        PdMatrix matOrig = new PdMatrix(dim);
        PdMatrix matOrigInv = new PdMatrix(dim);
        PdMatrix store = new PdMatrix(dim);
        PuLorentz.translate2Origin(matOrig, p, sign);
        PuLorentz.translate2Point(matOrigInv, p, sign);
        q.leftMultMatrix(matOrig);
        r.leftMultMatrix(matOrig);
        PuLorentz.reflectAtOrigin(mat, q, r, sign);
        store.mult(mat, matOrig);
        mat.mult(matOrigInv, store);
    }

    public static double distToOrigin(PdVector p, PdVector sign) {
        int ind = PuLorentz.indexOfTime(sign);
        double s = Math.abs(p.m_data[ind]);
        s = s <= 1.0 ? Math.acos(s) : PuMath.acosh(s);
        return s;
    }

    public static void getTangent(PdVector tangent, PdVector p, PdVector q, PdVector sign) {
        double skp = PuLorentz.dot(p, q, sign);
        tangent.blendBase(q, skp, p);
        PuLorentz.setLength(tangent, 1.0, sign);
    }

    public static void translate2Origin(PdMatrix mat, PdVector p, PdVector sign) {
        double s = PuLorentz.distToOrigin(p, sign);
        if (s < 1.0E-10) {
            mat.setIdentity();
            return;
        }
        PdVector tangent = new PdVector(p.getSize());
        PuLorentz.getTangentAtOrigin(tangent, p, sign);
        double cs = PuMath.cosh(-s);
        double ss = PuMath.sinh(-s);
        double csmo = cs - 1.0;
        double[][] matData = mat.m_data;
        double[] t = tangent.m_data;
        matData[0][0] = cs;
        matData[0][1] = t[1] * ss;
        matData[0][2] = t[2] * ss;
        matData[0][3] = t[3] * ss;
        matData[1][0] = matData[0][1];
        matData[1][1] = t[1] * t[1] * csmo + 1.0;
        matData[1][2] = t[1] * t[2] * csmo;
        matData[1][3] = t[1] * t[3] * csmo;
        matData[2][0] = matData[0][2];
        matData[2][1] = matData[1][2];
        matData[2][2] = t[2] * t[2] * csmo + 1.0;
        matData[2][3] = t[2] * t[3] * csmo;
        matData[3][0] = matData[0][3];
        matData[3][1] = matData[1][3];
        matData[3][2] = matData[2][3];
        matData[3][3] = t[3] * t[3] * csmo + 1.0;
    }

    public static void translate(PdMatrix mat, PdVector p, PdVector q, PdVector sign) {
        double s = PuLorentz.dist(p, q, sign);
        if (s < 1.0E-10) {
            mat.setIdentity();
            return;
        }
        int dim = p.getSize();
        PdMatrix matOrig = new PdMatrix(dim);
        PdMatrix matOrigInv = new PdMatrix(dim);
        PdMatrix store = new PdMatrix(dim);
        PuLorentz.translate2Origin(matOrig, p, sign);
        PuLorentz.translate2Point(matOrigInv, p, sign);
        q.leftMultMatrix(matOrig);
        PuLorentz.translate2Point(mat, q, sign);
        store.mult(mat, matOrig);
        mat.mult(matOrigInv, store);
    }

    public static void rotateAroundLine(PdMatrix mat, PdVector p, PdVector q, double angle, PdVector sign) {
        double s = PuLorentz.dist(p, q, sign);
        if (s < 1.0E-10) {
            mat.setIdentity();
            return;
        }
        int dim = p.getSize();
        PdMatrix matOrig = new PdMatrix(dim);
        PdMatrix matOrigInv = new PdMatrix(dim);
        PdMatrix store = new PdMatrix(dim);
        PuLorentz.translate2Origin(matOrig, p, sign);
        PuLorentz.translate2Point(matOrigInv, p, sign);
        q.leftMultMatrix(matOrig);
        PuLorentz.rotateAtOrigin(mat, q, angle, sign);
        store.mult(mat, matOrig);
        mat.mult(matOrigInv, store);
    }

    public static void invertAtPoint(PdMatrix mat, PdVector p, PdVector sign) {
        mat.setIdentity();
        mat.multScalar(-1.0);
        double s = PuLorentz.distToOrigin(p, sign);
        if (s < 1.0E-10) {
            return;
        }
        int dim = p.getSize();
        PdMatrix matOrig = new PdMatrix(dim);
        PdMatrix matOrigInv = new PdMatrix(dim);
        PdMatrix store = new PdMatrix(dim);
        PuLorentz.translate2Origin(matOrig, p, sign);
        PuLorentz.translate2Point(matOrigInv, p, sign);
        store.mult(mat, matOrig);
        mat.mult(matOrigInv, store);
    }

    public static double dist(PdVector p, PdVector q, PdVector sign) {
        double s = Math.abs(PuLorentz.dot(p, q, sign));
        s = s <= 1.0 ? Math.acos(s) : PuMath.acosh(s);
        return s;
    }

    public static double sqrDistMinkowski(PdVector p, PdVector q, PdVector sign) {
        double sum = 0.0;
        int k = 0;
        while (k < p.m_data.length) {
            sum += sign.m_data[k] * (p.m_data[k] - q.m_data[k]);
            ++k;
        }
        return sum;
    }

    public static void translate2Point(PdMatrix mat, PdVector p, PdVector sign) {
        double s = PuLorentz.distToOrigin(p, sign);
        if (s < 1.0E-10) {
            mat.setIdentity();
            return;
        }
        PdVector tangent = new PdVector(p.getSize());
        PuLorentz.getTangentAtOrigin(tangent, p, sign);
        double cs = PuMath.cosh(s);
        double ss = PuMath.sinh(s);
        double csmo = cs - 1.0;
        double[][] matData = mat.m_data;
        double[] t = tangent.m_data;
        matData[0][0] = cs;
        matData[0][1] = t[1] * ss;
        matData[0][2] = t[2] * ss;
        matData[0][3] = t[3] * ss;
        matData[1][0] = matData[0][1];
        matData[1][1] = t[1] * t[1] * csmo + 1.0;
        matData[1][2] = t[1] * t[2] * csmo;
        matData[1][3] = t[1] * t[3] * csmo;
        matData[2][0] = matData[0][2];
        matData[2][1] = matData[1][2];
        matData[2][2] = t[2] * t[2] * csmo + 1.0;
        matData[2][3] = t[2] * t[3] * csmo;
        matData[3][0] = matData[0][3];
        matData[3][1] = matData[1][3];
        matData[3][2] = matData[2][3];
        matData[3][3] = t[3] * t[3] * csmo + 1.0;
    }

    public static double abs(PdVector p, PdVector sign) {
        return Math.sqrt(PuLorentz.sqrAbs(p, sign));
    }

    public static double sqrAbs(PdVector p, PdVector sign) {
        double sum = 0.0;
        int k = 0;
        while (k < p.m_data.length) {
            sum += sign.m_data[k] * p.m_data[k] * p.m_data[k];
            ++k;
        }
        return sum;
    }

    public static void setLength(PdVector p, double length, PdVector sign) {
        double norm = PuLorentz.abs(p, sign);
        if (norm < 1.0E-10) {
            PsDebug.warning("vector has length zero.");
            return;
        }
        int k = 0;
        while (k < p.m_data.length) {
            int n = k++;
            p.m_data[n] = p.m_data[n] * (length / norm);
        }
    }

    private static int indexOfTime(PdVector sign) {
        int ind = -1;
        int i = 0;
        while (i < sign.m_data.length) {
            if (sign.m_data[i] < 0.0) {
                ind = i;
                break;
            }
            ++i;
        }
        if (ind == -1) {
            PsDebug.warning("missing time axis in signature.\n\tSignature = \n" + sign.toString());
            return 0;
        }
        return ind;
    }
}

