/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PuProj {
    public static void poincare2Lorentz(PdVector pl, PdVector p) {
        int lDim = pl.getSize();
        double t = p.sqrLength();
        if (t > 0.9999999999) {
            t = 0.9999999999;
            p.setLength(t);
        }
        t = 2.0 / (1.0 - t);
        int k = 0;
        while (k < lDim - 1) {
            pl.m_data[k] = p.m_data[k] * t;
            ++k;
        }
        pl.m_data[lDim - 1] = t - 1.0;
    }

    public static void uhm2Lorentz(PdVector pl, PdVector p) {
        int lDim = pl.getSize();
        if (p.m_data[lDim - 2] < 1.0E-10) {
            p.m_data[lDim - 2] = 1.0E-10;
        }
        double t = p.sqrLength();
        double d = 2.0 * p.m_data[lDim - 2];
        int k = 0;
        while (k < lDim - 2) {
            pl.m_data[k] = p.m_data[k];
            ++k;
        }
        pl.m_data[lDim - 1] = t + 1.0;
        pl.m_data[lDim - 2] = t - 1.0;
        k = 0;
        while (k < lDim) {
            int n = k++;
            pl.m_data[n] = pl.m_data[n] / d;
        }
    }

    public static void stereographic(PdVector p, PdVector pl) {
        int dim = pl.getSize();
        double h = 1.0 - pl.m_data[dim - 1];
        if (Math.abs(h) < 1.0E-10) {
            h = h > 0.0 ? 1.0E-10 : -1.0E-10;
        }
        int i = 0;
        while (i < dim - 1) {
            p.m_data[i] = pl.m_data[i] / h;
            ++i;
        }
    }

    public static void lorentz2Klein(PdVector p, PdVector pl) {
        int lDim = pl.getSize();
        if (pl.m_data[lDim - 1] < 0.9999999999) {
            PsDebug.warning("point pl is not in H3, " + pl.toString());
            p.setConstant(0.0);
            return;
        }
        int k = 0;
        while (k < lDim - 1) {
            p.m_data[k] = pl.m_data[k] / pl.m_data[lDim - 1];
            ++k;
        }
    }

    public static void stereoS3_to_R3(PdVector p, PdVector pl) {
        PuProj.stereographic(p, pl);
    }

    public static void stereoInvR3_to_S3(PdVector pl, PdVector p) {
        int dim = pl.getSize();
        double d = 2.0 / (1.0 + p.sqrLength());
        int i = 0;
        while (i < dim - 1) {
            pl.m_data[i] = p.m_data[i] * d;
            ++i;
        }
        pl.m_data[dim - 1] = 1.0 - d;
    }

    public static void uhm2Poincare(PdVector p, PdVector pu) {
        int dim = pu.getSize();
        if (pu.m_data[dim - 1] < 1.0E-10) {
            pu.m_data[dim - 1] = 1.0E-10;
        }
        double t = p.sqrLength();
        double d = t + 2.0 * pu.m_data[dim - 1] + 1.0;
        int k = 0;
        while (k < dim - 1) {
            p.m_data[k] = 2.0 * pu.m_data[k];
            ++k;
        }
        p.m_data[dim - 1] = t - 1.0;
        p.multScalar(1.0 / d);
    }

    public static void klein2Lorentz(PdVector pl, PdVector p) {
        int lDim = pl.getSize();
        double t = p.sqrLength();
        if (t > 0.9999999999) {
            t = 0.9999999999;
            p.setLength(t);
        }
        int k = 0;
        while (k < lDim) {
            pl.m_data[k] = p.m_data[k] * t;
            ++k;
        }
        pl.m_data[lDim - 1] = t = 1.0 / Math.sqrt(1.0 - t);
    }

    public static void poincare2Uhm(PdVector pu, PdVector p) {
        double t = p.sqrLength();
        if (t > 0.9999999999) {
            t = 0.9999999999;
            p.setLength(t);
        }
        int dim = pu.getSize();
        double d = t - 2.0 * p.m_data[dim - 1] + 1.0;
        int k = 0;
        while (k < dim - 1) {
            pu.m_data[k] = 2.0 * p.m_data[k];
            ++k;
        }
        pu.m_data[dim - 1] = 1.0 - t;
        pu.multScalar(1.0 / d);
    }

    public static void poincare2Klein(PdVector pk, PdVector p) {
        double t = p.sqrLength();
        if (t > 0.9999999999) {
            t = 0.9999999999;
            p.setLength(t);
        }
        t = 2.0 / (1.0 + t);
        pk.copy(p);
        pk.multScalar(t);
    }

    public static void lorentz2Poincare(PdVector p, PdVector pl) {
        int lDim = pl.getSize();
        if (pl.m_data[lDim - 1] < 0.9999999999) {
            PsDebug.warning("point pl is not in H3; " + pl.toString());
            p.setConstant(0.0);
            return;
        }
        int k = 0;
        while (k < lDim - 1) {
            p.m_data[k] = pl.m_data[k] / (pl.m_data[lDim - 1] + 1.0);
            ++k;
        }
    }

    public static void klein2Poincare(PdVector p, PdVector pk) {
        double t = pk.sqrLength();
        if (t > 0.9999999999) {
            t = 0.9999999999;
            pk.setLength(t);
        }
        t = 1.0 / (1.0 + Math.sqrt(1.0 - t));
        p.copy(pk);
        p.multScalar(t);
    }

    public static void diffKlein2Lorentz(PdMatrix diffMat, PdVector p) {
        if (diffMat.getISize() != 4 || diffMat.getJSize() != 3) {
            PsDebug.warning("matrix has invalid size.");
            diffMat.setSize(4, 3);
        }
        PdVector dt = new PdVector(p.getSize());
        double[][] diffData = diffMat.m_data;
        double t = p.sqrLength();
        if (t > 0.9999999999) {
            int k;
            int i = 0;
            while (i < 3) {
                k = 0;
                while (k < 3) {
                    diffData[i + 1][k] = p.m_data[i] * dt.m_data[k];
                    ++k;
                }
                ++i;
            }
            k = 0;
            while (k < 3) {
                diffData[0][k] = 1.0;
                ++k;
            }
            diffData[k + 1][k] = 1.0;
            return;
        }
        t = 1.0 / Math.sqrt(1.0 - t);
        int k = 0;
        while (k < 3) {
            diffData[0][k] = dt.m_data[k] = p.m_data[k] * t * t * t;
            ++k;
        }
        int i = 0;
        while (i < 3) {
            k = 0;
            while (k < 3) {
                diffData[i + 1][k] = p.m_data[i] * dt.m_data[k];
                ++k;
            }
            ++i;
        }
        k = 0;
        while (k < 3) {
            double[] dArray = diffData[k + 1];
            int n = k++;
            dArray[n] = dArray[n] + t;
        }
    }

    public static void diffPoincare2Lorentz(PdMatrix diffMat, PdVector p) {
        if (diffMat.getISize() != 4 || diffMat.getJSize() != 3) {
            PsDebug.warning("matrix has invalid size.");
            diffMat.setSize(4, 3);
        }
        PdVector dt = new PdVector(p.getSize());
        double[][] diffData = diffMat.m_data;
        double t = p.sqrLength();
        if (t > 0.9999999999) {
            int k;
            int i = 0;
            while (i < 3) {
                k = 0;
                while (k < 3) {
                    diffData[i + 1][k] = p.m_data[i] * dt.m_data[k];
                    ++k;
                }
                ++i;
            }
            k = 0;
            while (k < 3) {
                diffData[0][k] = 1.0;
                ++k;
            }
            diffData[k + 1][k] = 2.0;
            return;
        }
        t = 2.0 / (1.0 - t);
        int k = 0;
        while (k < 3) {
            diffData[0][k] = dt.m_data[k] = p.m_data[k] * t * t;
            ++k;
        }
        int i = 0;
        while (i < 3) {
            k = 0;
            while (k < 3) {
                diffData[i + 1][k] = p.m_data[i] * dt.m_data[k];
                ++k;
            }
            ++i;
        }
        k = 0;
        while (k < 3) {
            double[] dArray = diffData[k + 1];
            int n = k++;
            dArray[n] = dArray[n] + t;
        }
    }

    public static void lorentz2Uhm(PdVector p, PdVector pl) {
        int lDim = pl.getSize();
        if (pl.m_data[lDim - 1] < 0.9999999999) {
            PsDebug.warning("point pl is not in H3; " + pl.toString());
            p.setConstant(0.0);
            p.setEntry(lDim - 1, 1.0);
            return;
        }
        double tz = pl.m_data[lDim - 1] - pl.m_data[lDim - 2];
        int k = 0;
        while (k < lDim - 2) {
            p.m_data[k] = pl.m_data[k];
            ++k;
        }
        p.m_data[lDim - 2] = 1.0;
        k = 0;
        while (k < lDim - 1) {
            int n = k++;
            p.m_data[n] = p.m_data[n] / tz;
        }
    }

    public static void klein2Uhm(PdVector pu, PdVector p) {
        double t = p.sqrLength();
        if (t > 0.9999999999) {
            t = 0.9999999999;
            p.setLength(t);
        }
        int dim = p.getSize();
        double d = 1.0 - p.m_data[dim - 1];
        int k = 0;
        while (k < dim - 1) {
            pu.m_data[k] = p.m_data[k];
            ++k;
        }
        pu.m_data[dim - 1] = 1.0 - t / (1.0 + Math.sqrt(1.0 - t));
        pu.multScalar(1.0 / d);
    }

    public static void uhm2Klein(PdVector p, PdVector pu) {
        int dim = pu.getSize();
        if (pu.m_data[dim - 1] < 1.0E-10) {
            pu.m_data[dim - 1] = 1.0E-10;
        }
        double t = p.sqrLength();
        double d = 1.0 + t;
        int k = 0;
        while (k < dim - 1) {
            p.m_data[k] = 2.0 * pu.m_data[k];
            ++k;
        }
        pu.m_data[dim - 1] = t - 1.0;
        p.multScalar(1.0 / d);
    }

    public static void diffStereoS3_to_R3(PdMatrix diffMat, PdVector p) {
        double h;
        if (diffMat.getISize() != 3 || diffMat.getJSize() != 4) {
            PsDebug.warning("matrix has invalid size.");
            diffMat.setSize(3, 4);
        }
        if (Math.abs(h = p.m_data[0] + 1.0) < 1.0E-10) {
            PsDebug.warning("argument vertex lies at projection center");
            h = Math.sqrt(1.0E-10);
        }
        h = 1.0 / h;
        double[][] diffData = diffMat.m_data;
        int i = 0;
        while (i < 3) {
            diffData[i][i + 1] = h;
            ++i;
        }
        h *= h;
        i = 0;
        while (i < 3) {
            diffData[i][0] = -p.m_data[i + 1] * h;
            ++i;
        }
        diffData[1][1] = 0.0;
        diffData[0][3] = 0.0;
        diffData[0][2] = 0.0;
        diffData[2][2] = 0.0;
        diffData[2][1] = 0.0;
        diffData[1][3] = 0.0;
    }

    public static void diffStereoInvR3_to_S3(PdMatrix diffMat, PdVector p) {
        if (diffMat.getISize() != 4 || diffMat.getJSize() != 3) {
            PsDebug.warning("matrix has invalid size.");
            diffMat.setSize(4, 3);
        }
        double h = 2.0 / (1.0 + p.sqrLength());
        double hh = h * h;
        double[][] diffData = diffMat.m_data;
        int j = 0;
        while (j < 3) {
            diffData[0][j] = -p.m_data[j] * hh;
            ++j;
        }
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                diffData[i + 1][j] = p.m_data[i] * diffData[0][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            double[] dArray = diffData[i + 1];
            int n = i++;
            dArray[n] = dArray[n] + h;
        }
    }
}

