/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PuVectorGeom {
    public static boolean intersectionOfPlaneAndPlane(PdVector lineBase, PdVector lineDir, PdVector base1, PdVector normal1, PdVector base2, PdVector normal2) {
        double skp3 = PdVector.dot(normal1, normal2);
        double div = 1.0 - skp3 * skp3;
        if (Math.abs(div) < 1.0E-10) {
            PsDebug.notify("parallel planes");
            return false;
        }
        lineDir.cross(normal1, normal2);
        lineDir.normalize();
        double skp1 = PdVector.dot(normal1, base1);
        double skp2 = PdVector.dot(normal2, base2);
        double s = (skp1 - skp2 * skp3) / div;
        double t = (skp2 - skp1 * skp3) / div;
        lineBase.blend(s, normal1, t, normal2);
        return true;
    }

    public static void distVectorOfPointToLine(PdVector lot, PdVector p, PdVector base, PdVector dir) {
        PuVectorGeom.projectPointToLine(lot, p, base, dir);
        lot.sub(p);
    }

    public static void projectOntoPlane(PdVector v, PdVector normal) {
        PuVectorGeom.projectOntoPlane(v, v, normal);
    }

    public static void projectOntoPlane(PdVector vProj, PdVector v, PdVector normal) {
        if (Math.abs(normal.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("plane normal not normalized", normal);
            return;
        }
        double skp = PdVector.dot(v, normal);
        int i = 0;
        while (i < v.m_data.length) {
            vProj.m_data[i] = v.m_data[i] - skp * normal.m_data[i];
            ++i;
        }
    }

    public static void distVectorOfPointToPlane(PdVector lot, PdVector p, PdVector base, PdVector normal) {
        PuVectorGeom.projectPointToPlane(lot, p, base, normal);
        lot.sub(p);
    }

    public static double distOfPointToLine(PdVector p, PdVector base, PdVector dir) {
        double s;
        if (Math.abs(dir.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("line dir not normalized");
            return Double.MAX_VALUE;
        }
        PdVector v = PdVector.subNew(p, base);
        double r = v.length();
        double dist = r * r - (s = PdVector.dot(v, dir)) * s;
        if (dist < 0.0) {
            PsDebug.warning("maybe line dir not normalized");
            return 0.0;
        }
        return Math.sqrt(dist);
    }

    public static double sphericalAngle(PdVector p, PdVector q1, PdVector q2) {
        PdVector v = PdVector.blendNew(1.0, q1, -PdVector.dot(q1, p), p);
        PdVector w = PdVector.blendNew(1.0, q2, -PdVector.dot(q2, p), p);
        return PdVector.angle(v, w);
    }

    public static double sphericalArea(PdVector p, PdVector q, PdVector r) {
        double a = PuVectorGeom.sphericalAngle(p, q, r);
        double b = PuVectorGeom.sphericalAngle(q, p, r);
        double c = PuVectorGeom.sphericalAngle(r, q, p);
        return a + b + c - Math.PI;
    }

    public static double intersectionOfLineAndLine(PdVector p, PdVector base1, PdVector dir1, PdVector base2, PdVector dir2) {
        double skp = PdVector.dot(dir1, dir2);
        double div = 1.0 - skp * skp;
        if (Math.abs(div) < 1.0E-10) {
            return Double.MAX_VALUE;
        }
        double s = 0.0;
        int i = p.getSize() - 1;
        while (i >= 0) {
            s += (base2.m_data[i] - base1.m_data[i]) * (dir1.m_data[i] - skp * dir2.m_data[i]);
            --i;
        }
        p.blendBase(base1, s /= div, dir1);
        return s;
    }

    public static double distVectorOfLineToLine(PdVector lot, PdVector base1, PdVector dir1, PdVector base2, PdVector dir2) {
        double dist = PuVectorGeom.distOfLineToLine(base1, dir1, base2, dir2);
        lot.cross(dir1, dir2);
        lot.setLength(dist);
        return dist;
    }

    public static double distOfPointToPlane(PdVector p, PdVector base, PdVector normal) {
        if (Math.abs(normal.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("normal to plane not normalized");
            return Double.MAX_VALUE;
        }
        PdVector v = PdVector.subNew(p, base);
        double dist = PdVector.dot(v, normal);
        return Math.abs(dist);
    }

    public static void projectPointToLine(PdVector proj, PdVector p, PdVector base, PdVector dir) {
        if (Math.abs(dir.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("line dir not normalized");
            return;
        }
        double skp = 0.0;
        int i = proj.getSize() - 1;
        while (i >= 0) {
            skp += (p.m_data[i] - base.m_data[i]) * dir.m_data[i];
            --i;
        }
        proj.blendBase(base, skp, dir);
    }

    public static double ctg(PdVector p, PdVector q1, PdVector q2) {
        double wl;
        PdVector v = PdVector.subNew(q1, p);
        PdVector w = PdVector.subNew(q2, p);
        double vl = v.sqrLength();
        double vlwl = vl * (wl = w.sqrLength());
        if (vlwl <= 0.0) {
            PsDebug.warning("triangle length=0", p);
            return 1.0E90;
        }
        double c = PdVector.dot(v, w) / Math.sqrt(vlwl);
        if (c >= 1.0) {
            PsDebug.warning("cos >= 1.", p);
            return 1.0E90;
        }
        double s = Math.sqrt(1.0 - c * c);
        if (s <= 0.0) {
            PsDebug.warning("sin <= 0.", p);
            return 1.0E90;
        }
        return c / s;
    }

    public static void ctg(double[] ctg, PdVector p, PdVector q, PdVector r) {
        double a = PdVector.dist(q, r);
        double b = PdVector.dist(r, p);
        double c = PdVector.dist(p, q);
        PuMath.ctg(ctg, a, b, c);
    }

    public static boolean evalHelix(PdVector p, PdVector axisBot, PdVector axisDir, PdVector start, PdVector end, double t) {
        if (Math.abs(1.0 - t) < 1.0E-10) {
            p.copy(end);
            return true;
        }
        if (Math.abs(t) < 1.0E-10) {
            p.copy(start);
            return true;
        }
        if (PdVector.sqrDist(start, end) < 1.0E-10) {
            PsDebug.warning("axis has zero length");
            return false;
        }
        int dim = p.getSize();
        PdVector vec1 = new PdVector(dim);
        PdVector vec2 = new PdVector(dim);
        PuVectorGeom.distVectorOfPointToLine(vec1, start, axisBot, axisDir);
        PuVectorGeom.distVectorOfPointToLine(vec2, end, axisBot, axisDir);
        if (vec1.sqrLength() < 1.0E-10 || vec2.sqrLength() < 1.0E-10) {
            PsDebug.warning("wings of zero length occurred");
            return false;
        }
        if (Math.abs(vec1.sqrLength() - vec2.sqrLength()) > vec2.sqrLength() / 100.0) {
            PsDebug.warning("wings have different length");
        }
        axisDir.normalize();
        double angle = PdVector.angleWithOrientation(vec1, vec2, axisDir);
        if (!PuVectorGeom.rotatePointAroundLine(p, start, axisBot, axisDir, angle *= t)) {
            return false;
        }
        PdVector diff = PdVector.subNew(end, start);
        double diffPart = PdVector.dot(diff, axisDir);
        int k = 0;
        while (k < dim) {
            int n = k;
            p.m_data[n] = p.m_data[n] + t * (diffPart * axisDir.m_data[k]);
            ++k;
        }
        return true;
    }

    public static boolean circleThruPoints(PdVector center, double radius, PdVector p, PdVector q, PdVector r) {
        double skp;
        double lsw;
        PdVector v = PdVector.subNew(q, p);
        PdVector w = PdVector.subNew(r, p);
        double lsv = v.sqrLength();
        double div = 2.0 * (lsv * (lsw = w.sqrLength()) - (skp = PdVector.dot(v, w)) * skp);
        if (div < 1.0E-10) {
            int i = 0;
            while (i < 3) {
                center.m_data[i] = (p.m_data[i] + q.m_data[i] + r.m_data[i]) / 3.0;
                ++i;
            }
            return false;
        }
        int i = 0;
        while (i < 3) {
            center.m_data[i] = ((v.m_data[i] + w.m_data[i]) * lsv * lsw - (v.m_data[i] * lsw + w.m_data[i] * lsv) * skp) / div;
            ++i;
        }
        radius = center.length();
        center.add(p);
        return true;
    }

    public static double intersectionOfLineAndPlane(PdVector p, PdVector base1, PdVector dir, PdVector base2, PdVector normal) {
        double skp = PdVector.dot(normal, dir);
        if (Math.abs(skp) < 1.0E-10) {
            return Double.MAX_VALUE;
        }
        double s = 0.0;
        int i = p.getSize() - 1;
        while (i >= 0) {
            s += (base2.m_data[i] - base1.m_data[i]) * normal.m_data[i];
            --i;
        }
        p.blendBase(base1, s /= skp, dir);
        return s;
    }

    public static double distOfLineToLine(PdVector base1, PdVector dir1, PdVector base2, PdVector dir2) {
        PdVector v = PdVector.subNew(base1, base2);
        PdVector w = PdVector.crossNew(dir1, dir2);
        double dist = w.length();
        if (dist < 1.0E-10) {
            double len1 = dir1.sqrLength();
            double len2 = dir2.sqrLength();
            if (len1 < 1.0E-10 && len2 < 1.0E-10) {
                dist = PdVector.dist(base1, base2);
            } else if (len2 > 1.0E-10) {
                PdVector normDir;
                if (Math.abs(len2 - 1.0) > 1.0E-10) {
                    normDir = PdVector.copyNew(dir2);
                    normDir.normalize();
                } else {
                    normDir = dir2;
                }
                dist = PuVectorGeom.distOfPointToLine(base1, base2, normDir);
            } else if (len1 > 1.0E-10) {
                PdVector normDir;
                if (Math.abs(len1 - 1.0) > 1.0E-10) {
                    normDir = PdVector.copyNew(dir1);
                    normDir.normalize();
                } else {
                    normDir = dir2;
                }
                dist = PuVectorGeom.distOfPointToLine(base1, base2, normDir);
            }
        } else {
            dist = Math.abs(PdVector.dot(v, w)) / dist;
        }
        return dist;
    }

    public static void projectPointToPlane(PdVector proj, PdVector p, PdVector base, PdVector normal) {
        if (Math.abs(normal.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("plane normal not normalized");
            return;
        }
        double skp = 0.0;
        int i = proj.getSize() - 1;
        while (i >= 0) {
            skp += (p.m_data[i] - base.m_data[i]) * normal.m_data[i];
            --i;
        }
        proj.blendBase(p, -skp, normal);
    }

    public static void projectOntoLine(PdVector v, PdVector dir) {
        PuVectorGeom.projectOntoLine(v, v, dir);
    }

    public static void projectOntoLine(PdVector vProj, PdVector v, PdVector dir) {
        if (Math.abs(dir.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("line dir not normalized", dir);
            return;
        }
        double skp = PdVector.dot(v, dir);
        int i = 0;
        while (i < v.m_data.length) {
            vProj.m_data[i] = skp * dir.m_data[i];
            ++i;
        }
    }

    public static boolean rotatePointAroundLine(PdVector pRot, PdVector p, PdVector axisBase, PdVector axisDir, double alpha) {
        PdVector vm = PdVector.subNew(p, axisBase);
        if (!PuVectorGeom.rotatePointAroundVector(pRot, vm, axisDir, alpha)) {
            pRot.copy(p);
            return false;
        }
        pRot.add(axisBase);
        return true;
    }

    public static boolean rotatePointAroundVector(PdVector pRot, PdVector p, PdVector axisDir, double alpha) {
        if (Math.abs(axisDir.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("axis dir not normalized");
            pRot.copy(p);
            return false;
        }
        PdVector vo = p.orthogonalPart(null, axisDir);
        PdVector e2 = PdVector.crossNew(axisDir, p);
        int i = 0;
        while (i < p.m_data.length) {
            pRot.m_data[i] = p.m_data[i] - vo.m_data[i] + Math.cos(alpha) * vo.m_data[i] + Math.sin(alpha) * e2.m_data[i];
            ++i;
        }
        return true;
    }

    public static boolean evalCircle(PdVector p, PdVector mid, PdVector orient, PdVector start, PdVector end, double t) {
        double angle;
        if (Math.abs(1.0 - t) < 1.0E-10) {
            p.copy(end);
            return true;
        }
        if (Math.abs(t) < 1.0E-10) {
            p.copy(start);
            return true;
        }
        if (PdVector.sqrDist(start, end) < 1.0E-10) {
            angle = Math.PI * 2;
        } else {
            PdVector vec1 = PdVector.subNew(start, mid);
            PdVector vec2 = PdVector.subNew(end, mid);
            angle = PdVector.angleWithOrientation(vec1, vec2, orient);
        }
        return PuVectorGeom.rotatePointAroundLine(p, start, mid, orient, t * angle);
    }

    public static void projectPointToCircle(PdVector proj, PdVector p, PdVector mid, PdVector normal, double radius) {
        if (Math.abs(normal.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("plane normal not normalized");
            return;
        }
        PuVectorGeom.projectPointToPlane(proj, p, mid, normal);
        PdVector dir = PdVector.subNew(proj, mid);
        dir.setLength(radius);
        proj.add(mid, dir);
    }
}

