/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import jv.number.PuDouble;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;

public final class PvGrid
extends PgJvxSrc {
    protected PuDouble m_uMin;
    protected PuDouble m_vMin;
    protected PuDouble m_uMax;
    protected PuDouble m_vMax;
    private double m_defUMin = -20.0;
    private double m_defVMin = -20.0;
    private double m_defUMax = 20.0;
    private double m_defVMax = 20.0;
    protected int m_numULines;
    protected int m_numVLines;
    protected int m_numUSub;
    protected int m_numVSub;
    private int m_numUDiscr;
    private int m_numVDiscr;
    private int m_defNumULines = 9;
    private int m_defNumVLines = 9;
    private int m_defNumUSub = 0;
    private int m_defNumVSub = 0;
    protected PdVector m_origin;
    protected PdVector m_uDir;
    protected PdVector m_vDir;
    protected PdVector m_normal;
    protected PdVector m_defOrigin = new PdVector(0.0, 0.0, 0.0);
    protected PdVector m_defUDir = new PdVector(1.0, 0.0, 0.0);
    protected PdVector m_defVDir = new PdVector(0.0, 1.0, 0.0);

    public void setOrientation(PdVector origin, PdVector uDir, PdVector vDir) {
        this.m_origin.copy(origin);
        this.m_uDir.copy(uDir);
        this.m_vDir.copy(vDir);
        this.m_normal.cross(this.m_uDir, this.m_vDir);
    }

    public PvGrid(int dim) {
        super(dim);
        this.m_origin = new PdVector(dim);
        this.m_uDir = new PdVector(dim);
        this.m_vDir = new PdVector(dim);
        this.m_normal = new PdVector(dim);
        this.m_uMin = new PuDouble("uMin", this);
        this.m_vMin = new PuDouble("vMin", this);
        this.m_uMax = new PuDouble("uMax", this);
        this.m_vMax = new PuDouble("vMax", this);
        this.init();
    }

    public void setDefSize(double uMin, double vMin, double uMax, double vMax) {
        this.m_defUMin = uMin;
        this.m_defVMin = vMin;
        this.m_defUMax = uMax;
        this.m_defVMax = vMax;
    }

    public void setUMin(double uMin) {
        this.m_uMin.setValue(uMin);
    }

    public void setVMin(double vMin) {
        this.m_vMin.setValue(vMin);
    }

    public void setDiscr(int uLines, int vLines, int uSub, int vSub) {
        this.m_numUSub = uSub;
        this.m_numVSub = vSub;
        this.setNumULines(uLines);
        this.setNumVLines(vLines);
    }

    public double getUMin() {
        return this.m_uMin.getValue();
    }

    public double getVMin() {
        return this.m_vMin.getValue();
    }

    protected void setNumULinesFromPanel(int aNum) {
        this.m_numULines = aNum;
        this.m_numUDiscr = (this.m_numULines - 1) * (this.m_numUSub + 1) + 1;
    }

    protected void setNumVLinesFromPanel(int aNum) {
        this.m_numVLines = aNum;
        this.m_numVDiscr = (this.m_numVLines - 1) * (this.m_numVSub + 1) + 1;
    }

    public void setNumULines(int aNum) {
        this.m_numULines = aNum;
        this.m_numUDiscr = (this.m_numULines - 1) * (this.m_numUSub + 1) + 1;
    }

    public int getNumULines() {
        return this.m_numULines;
    }

    public void setSize(double uMin, double vMin, double uMax, double vMax) {
        this.m_uMin.setBounds(uMin - 2.0 * (uMax - uMin), uMin + 2.0 * (uMax - uMin), 0.1, 1.0);
        this.m_uMin.setValue(uMin);
        this.m_vMin.setBounds(vMin - 2.0 * (vMax - vMin), vMin + 2.0 * (vMax - vMin), 0.1, 1.0);
        this.m_vMin.setValue(vMin);
        this.m_uMax.setBounds(uMax - 2.0 * (uMax - uMin), uMax + 2.0 * (uMax - uMin), 0.1, 1.0);
        this.m_uMax.setValue(uMax);
        this.m_vMax.setBounds(vMax - 2.0 * (vMax - vMin), vMax + 2.0 * (vMax - vMin), 0.1, 1.0);
        this.m_vMax.setValue(vMax);
    }

    public void setNumVLines(int aNum) {
        this.m_numVLines = aNum;
        this.m_numVDiscr = (this.m_numVLines - 1) * (this.m_numVSub + 1) + 1;
    }

    public int getNumVLines() {
        return this.m_numVLines;
    }

    public void init() {
        super.init();
        this.m_uMin.setDefBounds(this.m_defUMin - 2.0 * (this.m_defUMax - this.m_defUMin), this.m_defUMin + 2.0 * (this.m_defUMax - this.m_defUMin), 0.1, 1.0);
        this.m_uMin.setDefValue(this.m_defUMin);
        this.m_uMin.init();
        this.m_vMin.setDefBounds(this.m_defVMin - 2.0 * (this.m_defVMax - this.m_defVMin), this.m_defVMin + 2.0 * (this.m_defVMax - this.m_defVMin), 0.1, 1.0);
        this.m_vMin.setDefValue(this.m_defVMin);
        this.m_uMin.init();
        this.m_uMax.setDefBounds(this.m_defUMax - 2.0 * (this.m_defUMax - this.m_defUMin), this.m_defUMax + 2.0 * (this.m_defUMax - this.m_defUMin), 0.1, 1.0);
        this.m_uMax.setDefValue(this.m_defUMax);
        this.m_uMax.init();
        this.m_vMax.setDefBounds(this.m_defVMax - 2.0 * (this.m_defVMax - this.m_defVMin), this.m_defVMax + 2.0 * (this.m_defVMax - this.m_defVMin), 0.1, 1.0);
        this.m_vMax.setDefValue(this.m_defVMax);
        this.m_vMax.init();
        this.setSize(this.m_defUMin, this.m_defVMin, this.m_defUMax, this.m_defVMax);
        this.setDiscr(this.m_defNumULines, this.m_defNumVLines, this.m_defNumUSub, this.m_defNumVSub);
        this.m_origin.copy(this.m_defOrigin);
        this.m_uDir.copy(this.m_defUDir);
        this.m_vDir.copy(this.m_defVDir);
        this.m_normal.cross(this.m_uDir, this.m_vDir);
        this.setGlobalVertexColor(Color.blue);
        this.setGlobalEdgeColor(Color.gray);
        this.setGlobalElementColor(Color.white);
        this.compute();
    }

    public void compute() {
        this.setNumVertices(this.m_numULines * this.m_numVLines);
        double uMin = this.m_uMin.getValue();
        double vMin = this.m_vMin.getValue();
        double uFac = (this.m_uMax.getValue() - uMin) / (-1.0 + (double)this.m_numULines);
        double vFac = (this.m_vMax.getValue() - vMin) / (-1.0 + (double)this.m_numVLines);
        int ind = 0;
        int i = 0;
        while (i < this.m_numULines) {
            double u = uMin + uFac * (double)i;
            int j = 0;
            while (j < this.m_numVLines) {
                double v = vMin + vFac * (double)j;
                int k = 0;
                while (k < this.m_dim) {
                    this.m_vertex[ind].m_data[k] = this.m_origin.m_data[k] + u * this.m_uDir.m_data[k] + v * this.m_vDir.m_data[k];
                    ++k;
                }
                ++ind;
                ++j;
            }
            ++i;
        }
        this.makeQuadrConn(this.m_numULines, this.m_numVLines, false, false);
        this.assureVertexNormals();
        PdVector.setConstant(this.m_vertexNormal, this.m_normal);
    }

    public void setDefDiscr(int uLines, int vLines, int uSub, int vSub) {
        this.m_defNumUSub = uSub;
        this.m_defNumVSub = vSub;
        this.m_defNumULines = uLines;
        this.m_defNumVLines = vLines;
    }

    public void setUMax(double uMax) {
        this.m_uMax.setValue(uMax);
    }

    public void setVMax(double vMax) {
        this.m_vMax.setValue(vMax);
    }

    public double getUMax() {
        return this.m_uMax.getValue();
    }

    public double getVMax() {
        return this.m_vMax.getValue();
    }
}

