/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuMath;
import jv.viewer.PvDisplay;
import jv.viewer.PvGeometry;

public final class PvScene
extends PsObject {
    protected int m_maxNumGeometries = 20;
    protected int m_numGeometries = 0;
    protected PvGeometry[] m_geometry;
    protected Vector m_special;
    protected PvGeometry m_currentGeom;
    protected int m_numItems;
    protected int[][] m_itemInd;
    protected double[] m_itemHeight;
    protected int[] m_itemSort;
    protected int m_dim;
    protected PdVector[] m_bndBox;
    protected PdVector m_center;
    protected int m_pickedVertex;
    protected int m_pickedGeometry;
    private int m_geomInd;
    private PiVector[] m_faceDestBnd;
    private PdMatrix transMatrix = new PdMatrix(4);
    protected int m_dimWithZBuffer = 4;
    protected static int t_itemInd = 0;
    protected static int m_zMin;
    protected static int m_zMax;
    protected static PdVector m_lightDir;
    protected static PdVector m_lightDirTrans;
    protected boolean m_bUseTexture = false;
    private transient Image m_destImage;
    private int imgHeight;
    private int imgWidth;
    private transient MemoryImageSource mis;
    private PiVector m_pix = new PiVector();
    private PiVector m_pixZero = new PiVector();
    private static /* synthetic */ Class class$jv$viewer$PvGeometry;

    public void setState(int aKey, boolean aState) {
        switch (aKey) {
            case 69: {
                break;
            }
            case 70: {
                break;
            }
            default: {
                PsDebug.warning("invalid key = " + aKey);
            }
        }
    }

    private int getGeometryIndOfItem(int itemInd) {
        int i = 0;
        while (i < this.m_numGeometries) {
            if (this.m_itemInd[i][0] <= itemInd && itemInd <= this.m_itemInd[i][1]) {
                return i;
            }
            ++i;
        }
        PsDebug.warning("missing geometry of item = " + itemInd);
        return -1;
    }

    protected int assureMIS_new(int width, int height) {
        if (this.mis == null || this.imgHeight != height || this.imgWidth != width) {
            this.imgWidth = width;
            this.imgHeight = height;
            this.m_pix.setSize(this.imgWidth * this.imgHeight);
            this.m_pixZero.setSize(this.imgWidth * this.imgHeight);
            this.mis = new MemoryImageSource(this.imgWidth, this.imgHeight, this.m_pix.m_data, 0, this.imgWidth);
            this.mis.setAnimated(true);
            return PvGeometry.MIS_IMAGE_REQUIRED;
        }
        return PvGeometry.MIS_IMAGE_REDRAW;
    }

    public PvScene() {
        this.m_geometry = new PvGeometry[this.m_maxNumGeometries];
        this.m_itemInd = new int[this.m_maxNumGeometries][3];
        this.m_bndBox = new PdVector[2];
        this.m_special = new Vector();
        this.init();
    }

    public boolean containsGeometry(PgGeometryIf aGeometry) {
        if (aGeometry == null) {
            return false;
        }
        return this.getGeometry(aGeometry) != null;
    }

    public void paint(Graphics g, PvDisplayIf disp) {
        int itemInd;
        int i;
        int numAll = this.getNumAllGeometries();
        if (numAll == 0 || numAll == this.m_numGeometries && this.m_numItems == 0) {
            return;
        }
        double minHeight = 0.0;
        double maxHeight = 0.0;
        double heightFac = 0.0;
        boolean bShowDepthcue = disp.isShowingDepthcue();
        PdMatrix viewMat = disp.getTransMatrix(4);
        PdMatrix projMat = disp.getTransMatrix(2);
        PdMatrix projViewMat = disp.getTransMatrix(1);
        PvGeometry[] allGeom = this.getGeometries();
        Dimension dim = disp.getSize();
        this.m_bUseTexture = false;
        m_zMin = Integer.MAX_VALUE;
        m_zMax = Integer.MIN_VALUE;
        boolean bUseZBuffer = ((PvDisplay)disp).isEnabledZBuffer();
        boolean bEnableNewZBuffer = ((PvDisplay)disp).m_bEnableNewZBuffer;
        m_lightDirTrans.leftMultMatrix(viewMat, m_lightDir);
        int i2 = 0;
        while (i2 < numAll) {
            if (allGeom[i2].isVisible()) {
                allGeom[i2].m_lightDir.copyArray(m_lightDirTrans);
                allGeom[i2].m_lightDir.normalize();
                allGeom[i2].m_backColor = disp.getBackgroundColor();
                allGeom[i2].m_bShowEdgeAura = disp.isShowingEdgeAura();
                allGeom[i2].showBndBox(disp.isShowingBndBox());
                allGeom[i2].m_bShowEdgeOnce = disp.isShowingEdgesOnce();
                allGeom[i2].m_bShowDepthcue = disp.isShowingDepthcue();
                allGeom[i2].m_bEnableClip = disp.isEnabledClip();
                allGeom[i2].m_clipFar = 1000.0 * disp.getFarClip();
                allGeom[i2].m_clipNear = 1000.0 * disp.getNearClip();
                allGeom[i2].m_scene = this;
                allGeom[i2].m_dispSize = dim;
                allGeom[i2].m_bEnableZBuffer = bUseZBuffer;
                if (allGeom[i2].isShowingVertexTexture() || allGeom[i2].isShowingElementTexture()) {
                    this.m_bUseTexture = true;
                }
                PdMatrix modelMatrix = null;
                if (allGeom[i2].hasModelMatrix()) {
                    modelMatrix = allGeom[i2].getModelMatrix();
                }
                allGeom[i2].projectItems(projViewMat, projMat, viewMat, modelMatrix);
                m_zMin = Math.min(m_zMin, allGeom[i2].getZMin());
                m_zMax = Math.max(m_zMax, allGeom[i2].getZMax());
            }
            ++i2;
        }
        int misReturn = PvGeometry.MIS_IMAGE_REDRAW;
        if (this.m_bUseTexture || bUseZBuffer) {
            this.m_faceDestBnd = PiVector.realloc(this.m_faceDestBnd, (dim.height + dim.width) * 2, this.m_dimWithZBuffer);
            if (bEnableNewZBuffer) {
                misReturn = this.assureMIS_new(dim.width, dim.height);
            }
            int i3 = 0;
            while (i3 < numAll) {
                allGeom[i3].m_dispSize = dim;
                if (allGeom[i3].m_bNewZBuffer != bEnableNewZBuffer || bEnableNewZBuffer && misReturn == PvGeometry.MIS_IMAGE_REQUIRED) {
                    allGeom[i3].clearMIS();
                    if (bEnableNewZBuffer) {
                        allGeom[i3].setMIS(this.imgWidth, this.imgHeight, this.m_pix.m_data, this.m_pixZero.m_data);
                    }
                    allGeom[i3].m_bNewZBuffer = bEnableNewZBuffer;
                }
                if (allGeom[i3].isShowingVertexTexture() || allGeom[i3].isShowingElementTexture() || bUseZBuffer) {
                    allGeom[i3].m_faceDestBnd = this.m_faceDestBnd;
                    allGeom[i3].m_faceTextureBnd = PdVector.realloc(allGeom[i3].m_faceTextureBnd, (dim.height + dim.width) * 2, 3);
                }
                ++i3;
            }
        } else {
            this.m_faceDestBnd = null;
        }
        this.copyItemHeight();
        if (disp.isEnabledPainters() && this.m_numItems > 0) {
            PuMath.heapsort(this.m_numItems, this.m_itemHeight, this.m_itemSort);
            minHeight = this.m_itemHeight[this.m_itemSort[0]];
            maxHeight = this.m_itemHeight[this.m_itemSort[this.m_numItems - 1]];
        } else {
            maxHeight = -1.7976931348623157E308;
            minHeight = Double.MAX_VALUE;
            int i4 = 0;
            while (i4 < this.m_numItems) {
                if (this.m_itemHeight[i4] > maxHeight) {
                    maxHeight = this.m_itemHeight[i4];
                } else if (this.m_itemHeight[i4] < minHeight) {
                    minHeight = this.m_itemHeight[i4];
                }
                this.m_itemSort[i4] = i4;
                ++i4;
            }
        }
        Enumeration e = this.m_special.elements();
        while (e.hasMoreElements()) {
            PvGeometry geom = (PvGeometry)e.nextElement();
            if (geom.getDrawingOrder() != -1 || !geom.isVisible()) continue;
            geom.m_bShowEdgeOnce = false;
            geom.m_bShowDepthcue = false;
            int num = geom.getNumItems();
            i = 0;
            while (i < num) {
                geom.drawItem(g, i, heightFac, 0.0);
                ++i;
            }
        }
        boolean bConstantHeight = false;
        double heightDist = maxHeight - minHeight;
        if (heightDist < 1.0E-10) {
            bConstantHeight = true;
            heightFac = 1.0;
        }
        if (this.m_numGeometries == 1) {
            this.m_geomInd = 0;
            if (this.m_geometry[this.m_geomInd].isVisible()) {
                i = 0;
                while (i < this.m_numItems) {
                    itemInd = bUseZBuffer && bEnableNewZBuffer ? this.m_numItems - this.m_itemSort[i] - 1 : this.m_itemSort[i];
                    if (bShowDepthcue && !bConstantHeight) {
                        heightFac = (this.m_itemHeight[itemInd] - minHeight) / heightDist;
                    }
                    t_itemInd = i++;
                    this.m_geometry[this.m_geomInd].drawItem(g, itemInd - this.m_itemInd[this.m_geomInd][0], heightFac, this.m_itemHeight[itemInd]);
                }
            }
        } else {
            i = 0;
            while (i < this.m_numItems) {
                itemInd = bUseZBuffer && bEnableNewZBuffer ? this.m_numItems - this.m_itemSort[i] - 1 : this.m_itemSort[i];
                this.m_geomInd = this.getGeometryIndOfItem(itemInd);
                if (this.m_geometry[this.m_geomInd].isVisible()) {
                    if (bShowDepthcue && !bConstantHeight) {
                        heightFac = (this.m_itemHeight[itemInd] - minHeight) / heightDist;
                    }
                    t_itemInd = i;
                    this.m_geometry[this.m_geomInd].drawItem(g, itemInd - this.m_itemInd[this.m_geomInd][0], heightFac, this.m_itemHeight[itemInd]);
                }
                ++i;
            }
        }
        i = 0;
        while (i < numAll) {
            if (allGeom[i].isShowingTitle()) {
                allGeom[i].drawTitle(g);
            }
            ++i;
        }
        Enumeration e2 = this.m_special.elements();
        while (e2.hasMoreElements()) {
            PvGeometry geom = (PvGeometry)e2.nextElement();
            if (geom.getDrawingOrder() != 1 || !geom.isVisible()) continue;
            geom.m_bShowEdgeOnce = false;
            geom.m_bShowDepthcue = false;
            int num = geom.getNumItems();
            int i5 = 0;
            while (i5 < num) {
                geom.drawItem(g, i5, heightFac, 0.0);
                ++i5;
            }
        }
        if (bEnableNewZBuffer && (this.m_bUseTexture || bUseZBuffer)) {
            this.drawMIS_new(g, misReturn, disp);
        }
    }

    protected void drawMIS_new(Graphics g, int misImage, PvDisplayIf disp) {
        if (misImage == PvGeometry.MIS_IMAGE_REQUIRED) {
            this.m_destImage = ((Component)((Object)disp)).createImage(this.mis);
        } else {
            this.mis.newPixels(0, 0, this.imgWidth, this.imgHeight);
        }
        if (this.m_destImage != null) {
            g.drawImage(this.m_destImage, 0, 0, null);
        }
        System.arraycopy(this.m_pixZero.m_data, 0, this.m_pix.m_data, 0, this.imgWidth * this.imgHeight);
    }

    protected PvGeometry[] getGeometries() {
        int numAllGeom = this.getNumAllGeometries();
        PvGeometry[] geom = new PvGeometry[numAllGeom];
        if (numAllGeom == 0) {
            return geom;
        }
        int i = 0;
        while (i < this.m_numGeometries) {
            geom[i] = this.m_geometry[i];
            ++i;
        }
        Enumeration e = this.m_special.elements();
        while (e.hasMoreElements()) {
            geom[i++] = (PvGeometry)e.nextElement();
        }
        return geom;
    }

    private void assureIndexList() {
        if (this.m_numGeometries == 0) {
            return;
        }
        this.m_itemInd[0][0] = 0;
        int i = 0;
        while (i < this.m_numGeometries) {
            this.m_itemInd[i][1] = this.m_itemInd[i][0] + this.m_itemInd[i][2] - 1;
            if (i + 1 < this.m_numGeometries) {
                this.m_itemInd[i + 1][0] = this.m_itemInd[i][1] + 1;
            }
            ++i;
        }
        this.m_numItems = this.m_itemInd[this.m_numGeometries - 1][1] + 1;
        PsDebug.notify("num of items = " + this.m_numItems);
        if (this.m_itemHeight == null || this.m_itemHeight.length != this.m_numItems) {
            this.m_itemHeight = new double[this.m_numItems];
            this.m_itemSort = new int[this.m_numItems];
        }
    }

    public boolean update(Object event) {
        Enumeration e = this.m_special.elements();
        while (e.hasMoreElements()) {
            if (event != e.nextElement()) continue;
            return true;
        }
        int i = 0;
        while (i < this.m_numGeometries) {
            if (this.m_geometry[i] == event) {
                PsDebug.notify("updating geometry");
                this.m_itemInd[i][2] = this.m_geometry[i].getNumItems();
                this.assureIndexList();
                return super.update(null);
            }
            ++i;
        }
        PsDebug.warning("missing geometry");
        return super.update(event);
    }

    static {
        m_lightDir = new PdVector(0.0, 0.7071, 0.7071, 0.0);
        m_lightDirTrans = new PdVector(0.0, 0.7071, 0.7071, 0.0);
    }

    public void selectGeometry(PvGeometry aGeometry) {
        if (aGeometry == null) {
            return;
        }
        if (this.m_special.contains(aGeometry)) {
            this.m_currentGeom = aGeometry;
            return;
        }
        int i = 0;
        while (i < this.m_numGeometries) {
            if (this.m_geometry[i] == aGeometry) {
                this.m_currentGeom = this.m_geometry[i];
                return;
            }
            ++i;
        }
        PsDebug.warning("geometry not found, name = " + aGeometry.getGeometry().getName());
    }

    protected PvGeometry getGeometry(PgGeometryIf aGeometry) {
        if (aGeometry == null) {
            return null;
        }
        Enumeration e = this.m_special.elements();
        while (e.hasMoreElements()) {
            PvGeometry geom = (PvGeometry)e.nextElement();
            if (geom.getGeometry() != aGeometry) continue;
            return geom;
        }
        int i = 0;
        while (i < this.m_numGeometries) {
            if (this.m_geometry[i].getGeometry() == aGeometry) {
                return this.m_geometry[i];
            }
            ++i;
        }
        PsDebug.notify("geometry not found, name = " + aGeometry.getName());
        return null;
    }

    public double getDiameter() {
        if (this.m_numItems == 0) {
            return 0.0;
        }
        PdVector[] bndBox = this.getBounds();
        double diameter = PdVector.dist(bndBox[0], bndBox[1]);
        return diameter;
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private void copyItemHeight() {
        int i = 0;
        while (i < this.m_numGeometries) {
            int k;
            double height;
            int[] elemData;
            int[] unusedVertex;
            int j;
            int offset = 0;
            PvGeometry geom = this.m_geometry[i];
            if (geom.m_useVertices) {
                int nov = geom.getNumVertices();
                j = 0;
                while (j < nov) {
                    this.m_itemHeight[this.m_itemInd[i][0] + j] = geom.m_vertexTrans[j].m_data[2];
                    ++j;
                }
                offset = nov;
            } else if (geom.m_useUnusedVertices && (unusedVertex = geom.getUnusedVertices()) != null) {
                int nouv = geom.getNumUnusedVertices();
                j = 0;
                while (j < nouv) {
                    this.m_itemHeight[this.m_itemInd[i][0] + j] = geom.m_vertexTrans[unusedVertex[j]].m_data[2];
                    ++j;
                }
                offset = nouv;
            }
            if (geom.m_useElements) {
                int noe = geom.getNumElements();
                PiVector[] element = geom.getElements();
                j = 0;
                while (j < noe) {
                    elemData = element[j].m_data;
                    height = 0.0;
                    k = 0;
                    while (k < elemData.length) {
                        height += (double)geom.m_vertexTrans[elemData[k]].m_data[2];
                        ++k;
                    }
                    this.m_itemHeight[this.m_itemInd[i][0] + offset + j] = height /= (double)elemData.length;
                    ++j;
                }
                offset += noe;
            }
            if (geom.m_usePolygons) {
                int nop = geom.getNumPolygons();
                PiVector[] polygon = geom.getPolygons();
                j = 0;
                while (j < nop) {
                    elemData = polygon[j].m_data;
                    if (elemData != null) {
                        k = 0;
                        while (k < elemData.length - 1) {
                            height = (double)(geom.m_vertexTrans[elemData[k]].m_data[2] + geom.m_vertexTrans[elemData[k + 1]].m_data[2]) / 2.0;
                            this.m_itemHeight[this.m_itemInd[i][0] + offset++] = height;
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private int getNumAllGeometries() {
        return this.m_numGeometries + this.m_special.size();
    }

    public PdVector[] getBounds() {
        PdVector[] minBndBoxList = new PdVector[this.m_maxNumGeometries];
        PdVector[] maxBndBoxList = new PdVector[this.m_maxNumGeometries];
        int cnt = 0;
        int i = 0;
        while (i < this.m_numGeometries) {
            PdVector[] bndBox;
            if (this.m_geometry[i].isVisible() && (bndBox = this.m_geometry[i].getBounds()) != null) {
                minBndBoxList[cnt] = bndBox[0];
                maxBndBoxList[cnt] = bndBox[1];
                ++cnt;
            }
            ++i;
        }
        if (cnt != 0) {
            PdVector.min(this.m_bndBox[0], minBndBoxList, cnt);
            PdVector.max(this.m_bndBox[1], maxBndBoxList, cnt);
        }
        if (cnt == 0 || PdVector.dist(this.m_bndBox[0], this.m_bndBox[1]) < 1.0E-10) {
            this.m_bndBox[0].setConstant(-10.0);
            this.m_bndBox[1].setConstant(10.0);
        }
        return this.m_bndBox;
    }

    public void init() {
        super.init();
        this.m_dim = 3;
        this.m_numItems = 0;
        this.m_itemHeight = null;
        this.m_itemSort = null;
        this.m_bndBox[0] = new PdVector(this.m_dim);
        this.m_bndBox[1] = new PdVector(this.m_dim);
        this.m_center = new PdVector(this.m_dim);
        this.m_bndBox[0].setConstant(-10.0);
        this.m_bndBox[1].setConstant(10.0);
        this.m_center.setConstant(0.0);
    }

    public PvGeometry removeGeometry(PvGeometry aGeometry) {
        if (aGeometry == null) {
            return null;
        }
        if (this.m_special.contains(aGeometry)) {
            this.m_special.removeElement(aGeometry);
            if (aGeometry == this.m_currentGeom) {
                if (this.m_numGeometries > 0) {
                    this.selectGeometry(this.m_geometry[0]);
                } else {
                    this.m_numItems = 0;
                    this.m_currentGeom = null;
                }
            }
            return this.m_currentGeom;
        }
        PsDebug.notify("remove geometry, name = " + aGeometry.getGeometry().getName());
        int i = 0;
        while (i < this.m_numGeometries) {
            if (this.m_geometry[i] == aGeometry) {
                this.m_numGeometries += -1;
                if (i < this.m_numGeometries) {
                    this.m_geometry[i] = this.m_geometry[this.m_numGeometries];
                    this.m_itemInd[i][2] = this.m_itemInd[this.m_numGeometries][2];
                    if (this.m_geometry[this.m_numGeometries] == this.m_currentGeom) {
                        this.selectGeometry(this.m_geometry[i]);
                    }
                }
                this.m_geometry[this.m_numGeometries] = null;
                if (this.m_numGeometries > 0) {
                    this.assureIndexList();
                    if (aGeometry == this.m_currentGeom) {
                        this.selectGeometry(this.m_geometry[0]);
                    }
                } else {
                    this.m_numItems = 0;
                    this.m_currentGeom = null;
                }
                return this.m_currentGeom;
            }
            ++i;
        }
        PsDebug.notify("geometry not found, name = " + aGeometry.getGeometry().getName());
        return this.m_currentGeom;
    }

    public void addGeometry(PvGeometry aGeometry) {
        if (aGeometry == null) {
            return;
        }
        if (aGeometry.getDrawingOrder() == -1 || aGeometry.getDrawingOrder() == 1) {
            this.m_special.addElement(aGeometry);
        } else {
            int i = 0;
            while (i < this.m_numGeometries) {
                if (this.m_geometry[i] == aGeometry) {
                    this.update(aGeometry);
                    return;
                }
                ++i;
            }
            if (this.m_numGeometries == this.m_maxNumGeometries) {
                PsDebug.notify("resizing internal array.");
                int[][] prevItem = this.m_itemInd;
                this.m_geometry = (PvGeometry[])PuData.realloc(class$jv$viewer$PvGeometry != null ? class$jv$viewer$PvGeometry : (class$jv$viewer$PvGeometry = PvScene.class$("jv.viewer.PvGeometry")), this.m_geometry, 2 * this.m_maxNumGeometries);
                this.m_itemInd = new int[2 * this.m_maxNumGeometries][3];
                int i2 = 0;
                while (i2 < this.m_maxNumGeometries) {
                    int k = 0;
                    while (k < 3) {
                        this.m_itemInd[i2][k] = prevItem[i2][k];
                        ++k;
                    }
                    ++i2;
                }
                this.m_maxNumGeometries = 2 * this.m_maxNumGeometries;
            }
            this.m_geometry[this.m_numGeometries++] = aGeometry;
            if (this.m_numGeometries == 1) {
                this.selectGeometry(aGeometry);
            }
        }
        this.update(aGeometry);
    }

    protected double getHeightOfElementInCurrentGeometry(int itemInd) {
        if (itemInd > this.m_itemInd[this.m_geomInd][2]) {
            return Double.NEGATIVE_INFINITY;
        }
        int absItemInd = itemInd + this.m_itemInd[this.m_geomInd][0];
        return this.m_itemHeight[absItemInd];
    }
}

