/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import jv.geom.PgElementSet;
import jv.loader.PgJvxLoader;
import jv.loader.PgLoader;
import jv.project.PgGeometry;
import jv.project.PvCameraIf;
import jv.vecmath.PdVector;
import jv.viewer.PvDisplay;

public class jv4surfex {
    private boolean inAnApplet = false;
    double lastScale;
    double factor;
    Vector lamps = new Vector();
    double scale = 1.0;
    public double scaleMin = 0.0;
    public double scaleMax = 10.0;
    JSlider scaleSlider = null;
    JLabel scaleLabel = null;
    JTextField scaleLabelMin = null;
    JTextField scaleLabelMax = null;
    JTextField scaleLabelCur = null;
    LampAdminUpdater lampAdminUpdater;
    private Frame frame = null;
    Panel pScale = null;
    int xPos = 824;
    boolean lastb = false;
    Frame jv4sxFrame;
    public PvDisplay disp = null;
    surfex surfex_;

    public void setScaleMinMax(double d, double d2) {
        this.scaleMin = d;
        this.scaleMax = d2;
        this.lampAdminUpdater.setScaleMinMax(this.scaleMin, this.scaleMax);
        this.scaleSlider.setValue((int)((this.scale - this.scaleMin) / (this.scaleMax - this.scaleMin) * 1000.0 + 0.5));
        this.scaleLabelMin.setText("" + (double)((int)(1.0 + this.scaleMin * 1000.0)) / 1000.0);
        this.scaleLabelMax.setText("" + (double)((int)(this.scaleMax * 1000.0)) / 1000.0);
        this.pScale.repaint();
    }

    public void setScale(double d) {
        this.scale = d;
        try {
            this.surfex_.getCurrentProject().setScale(this.scale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disp.getCamera().setScale(this.scale);
        this.scaleSlider.setValue((int)((this.scale - this.scaleMin) / (this.scaleMax - this.scaleMin) * 1000.0 + 0.5));
        this.scaleLabelCur.setText("" + (this.scaleMin + (double)this.scaleSlider.getValue() / 1000.0 * (this.scaleMax - this.scaleMin)));
        this.updateDisp();
    }

    public double getScale() {
        return this.scale;
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public jv4surfex(boolean bl, Applet applet, surfex surfex2, int n, JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        this.xPos = n;
        this.init(bl, applet, surfex2, jTextField, jTextField2, jTextField3, 1.0);
    }

    public jv4surfex(boolean bl, Applet applet, surfex surfex2, int n, double d) {
        this.xPos = n;
        this.init(bl, applet, surfex2, new JTextField(), new JTextField(), new JTextField(), d);
    }

    public jv4surfex(boolean bl, Applet applet, surfex surfex2, JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        this.init(bl, applet, surfex2, jTextField, jTextField2, jTextField3, 1.0);
    }

    public jv4surfex(boolean bl, Applet applet, surfex surfex2, JTextField jTextField, JTextField jTextField2, JTextField jTextField3, double d) {
        this.init(bl, applet, surfex2, jTextField, jTextField2, jTextField3, d);
    }

    public void init(boolean bl, Applet applet, surfex surfex2, JTextField jTextField, JTextField jTextField2, JTextField jTextField3, double d) {
        this.inAnApplet = bl;
        this.surfex_ = surfex2;
        this.lampAdminUpdater = new LampAdminUpdater(d, this.scaleMin, this.scaleMax);
        this.factor = d;
        this.frame = new Frame("triangulated view - surfex (uses JavaView)");
        this.frame.setLayout(new BorderLayout());
        this.frame.setVisible(false);
        if (this.inAnApplet) {
            // empty if block
        }
        this.disp = new PvDisplay();
        PvCameraIf pvCameraIf = this.disp.getCamera();
        this.frame.add("Center", this.disp);
        this.scaleSlider = new JSlider(1, 1000);
        this.scale = 1.0;
        this.scaleLabel = new JLabel("1.0");
        this.scaleSlider.setValue(100);
        this.scaleSlider.setMinorTickSpacing(10);
        this.scaleSlider.setMajorTickSpacing(100);
        this.scaleSlider.setPaintTicks(true);
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new GridLayout(1, 6));
        Panel panel3 = new Panel(new BorderLayout());
        this.scaleLabelMin = new JTextField("" + (double)((int)(1.0 + this.scaleMin * 1000.0)) / 1000.0);
        this.scaleLabelMax = new JTextField("" + (double)((int)(this.scaleMax * 1000.0)) / 1000.0);
        this.scaleLabelCur = new JTextField("0.0");
        this.scaleLabelMin.setEditable(true);
        this.scaleLabelMax.setEditable(true);
        this.scaleLabelCur.setEditable(false);
        this.scaleLabelMin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.parseDouble(jv4surfex.this.scaleLabelMin.getText());
                    if (d <= jv4surfex.this.scaleMax && d <= jv4surfex.this.getScale()) {
                        d = (double)Math.round(d * 1000.0) / 1000.0;
                        jv4surfex.this.setScaleMinMax(d, jv4surfex.this.scaleMax);
                    } else {
                        jv4surfex.this.scaleLabelMin.setText("" + jv4surfex.this.scaleMin);
                    }
                }
                catch (Exception exception) {
                    jv4surfex.this.scaleLabelMin.setText("" + jv4surfex.this.scaleMin);
                }
            }
        });
        this.scaleLabelMax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.parseDouble(jv4surfex.this.scaleLabelMax.getText());
                    if (d >= jv4surfex.this.scaleMin && d >= jv4surfex.this.getScale()) {
                        d = (double)Math.round(d * 1000.0) / 1000.0;
                        jv4surfex.this.setScaleMinMax(jv4surfex.this.scaleMin, d);
                    } else {
                        jv4surfex.this.scaleLabelMax.setText("" + jv4surfex.this.scaleMax);
                    }
                }
                catch (Exception exception) {
                    jv4surfex.this.scaleLabelMax.setText("" + jv4surfex.this.scaleMax);
                }
            }
        });
        panel3.add("West", this.scaleLabelMin);
        panel3.add("East", this.scaleLabelMax);
        panel3.add("Center", this.scaleLabelCur);
        this.pScale = new Panel(new BorderLayout());
        this.pScale.add("North", panel);
        this.pScale.add("South", panel3);
        this.frame.add("South", this.pScale);
        panel.add("South", this.scaleSlider);
        panel2.add(new JLabel(" x:"));
        panel2.add(jTextField);
        panel2.add(new JLabel(" y:"));
        panel2.add(jTextField2);
        panel2.add(new JLabel(" z:"));
        panel2.add(jTextField3);
        this.frame.pack();
        this.frame.setBounds(new Rectangle(this.xPos, 0, 200, 200));
        this.frame.setVisible(false);
        this.lampAdminUpdater.setJv4sx(this);
        this.lampAdminUpdater.setSlider(this.scaleSlider);
        this.lampAdminUpdater.setPosTextFields(jTextField, jTextField2, jTextField3);
        this.lampAdminUpdater.start();
    }

    public void setPosTextFields2(JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        this.lampAdminUpdater.setPosTextFields2(jTextField, jTextField2, jTextField3);
    }

    public void setPosTextFields(JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        this.lampAdminUpdater.setPosTextFields(jTextField, jTextField2, jTextField3);
    }

    public void changeFrameTitle(String string) {
        this.frame.setTitle(string);
    }

    public void show() {
        double d = this.disp.getCamera().getScale();
        this.frame.setVisible(true);
        this.setScale(this.scale);
        this.frame.toFront();
    }

    public void setParameterWarning(boolean bl) {
        if (bl != this.lastb) {
            if (bl) {
                this.jv4sxFrame = this.frame;
                this.frame = new Frame();
                this.frame.add(new Label("You can use jv4sx only without parameters"));
            } else {
                this.frame = this.jv4sxFrame;
            }
        }
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    public void setLamps(Vector vector) {
        this.lamps = vector;
    }

    public boolean showDefault() {
        PgElementSet pgElementSet = new PgElementSet();
        PgElementSet pgElementSet2 = new PgElementSet();
        PgElementSet[] pgElementSetArray = new PgElementSet[9];
        pgElementSet.setName("Sphere");
        pgElementSet.computeSphere(10, 10, this.factor / 3.0);
        this.disp.removeGeometries();
        int n = this.lamps.size() - 1;
        for (n = 0; n < this.lamps.size(); ++n) {
            Lamp lamp = (Lamp)this.lamps.elementAt(n);
            PdVector[] pdVectorArray = new PdVector[]{new PdVector(lamp.getXpos() - 1.0, lamp.getYpos() + 0.0, lamp.getZpos() + 1.0), new PdVector(lamp.getXpos() - 1.0, lamp.getYpos() + 0.0, lamp.getZpos() - 1.0), new PdVector(lamp.getXpos() - 1.0, lamp.getYpos() - 1.0, lamp.getZpos()), new PdVector(lamp.getXpos() - 1.0, lamp.getYpos() + 1.0, lamp.getZpos())};
            pgElementSetArray[n] = new PgElementSet();
            pgElementSetArray[n].computeSphere(10, 10, this.factor / 30.0);
            pgElementSetArray[n].translate(new PdVector(lamp.getXpos(), lamp.getYpos(), lamp.getZpos()));
            this.disp.addGeometry(pgElementSetArray[n]);
        }
        this.disp.addGeometry(pgElementSet);
        this.addCentr(1000000000, 0, 0);
        this.addCentr(-1000000000, 0, 0);
        this.addCentr(0, -100000000, 0);
        this.addCentr(0, 100000000, 0);
        this.addCentr(0, 0, -1000000000);
        this.addCentr(0, 0, 1000000000);
        this.disp.fit();
        this.disp.update(this.disp);
        return true;
    }

    private void addCentr(int n, int n2, int n3) {
        PgElementSet pgElementSet = new PgElementSet();
        pgElementSet.computeSphere(2, 2, 1.0);
        pgElementSet.translate(new PdVector(n, n2, n3));
        this.disp.addGeometry(pgElementSet);
    }

    public void updateDisp() {
        this.disp.update(this.disp);
    }

    public boolean loadAndDisplay(String string) {
        try {
            PgJvxLoader pgJvxLoader = new PgJvxLoader();
            PgLoader pgLoader = new PgLoader();
            PgGeometry[] pgGeometryArray = this.inAnApplet ? PgLoader.load(this.surfex_.webPrgs.surfPath.getText() + string) : PgLoader.load(string);
            this.disp.removeGeometries();
            this.disp.addGeometry(pgGeometryArray[0]);
            this.disp.update(this.disp);
            return true;
        }
        catch (Exception exception) {
            System.out.println("PgJvxLoader:" + exception.toString());
            return false;
        }
    }

    public double[] getViewDir() {
        PvCameraIf pvCameraIf = this.disp.getCamera();
        PdVector pdVector = PdVector.copyNew(pvCameraIf.getViewDir());
        pdVector.normalize();
        return pdVector.m_data;
    }

    public double[] getUpVector() {
        PvCameraIf pvCameraIf = this.disp.getCamera();
        PdVector pdVector = PdVector.copyNew(pvCameraIf.getUpVector());
        pdVector.normalize();
        return pdVector.m_data;
    }

    public double[] getRightVector() {
        PvCameraIf pvCameraIf = this.disp.getCamera();
        PdVector pdVector = PdVector.copyNew(pvCameraIf.getViewDir());
        pdVector.multScalar(-1.0);
        pdVector.normalize();
        PdVector pdVector2 = PdVector.copyNew(pvCameraIf.getUpVector());
        pdVector2.normalize();
        PdVector pdVector3 = PdVector.crossNew(pdVector2, pdVector);
        pdVector3.normalize();
        return pdVector3.m_data;
    }

    public double[] getCamPos() {
        PvCameraIf pvCameraIf = this.disp.getCamera();
        PdVector pdVector = PdVector.copyNew(pvCameraIf.getPosition());
        return pdVector.m_data;
    }

    public void setCamPos2(double d, double d2, double d3) {
        PvCameraIf pvCameraIf = this.disp.getCamera();
        pvCameraIf.setPosition(new PdVector(d, d2, d3));
    }

    public double[] getCameraRotationYXZ() {
        PvCameraIf pvCameraIf = this.disp.getCamera();
        PdVector pdVector = PdVector.copyNew(pvCameraIf.getViewDir());
        pdVector.multScalar(-1.0);
        pdVector.normalize();
        PdVector pdVector2 = PdVector.copyNew(pvCameraIf.getUpVector());
        pdVector2.normalize();
        PdVector pdVector3 = PdVector.crossNew(pdVector2, pdVector);
        double[] dArray = PdVector.frameToStandardFrame(pdVector3, pdVector2, pdVector);
        dArray[0] = -dArray[0];
        return dArray;
    }
}

