package Spidy::Database::Mysql;

use Spidy::Database;
use DBD::mysql;

@ISA = qw( Spidy::Database );

use strict;

# sub autoload_methods {
#   return shift->SUPER::autoload_methods();
# }

sub get_dbh {
  my $self = shift;
  return $self->{'dbh'} 
    if $self->{'dbh'} && $self->{'dbh'}->ping;
  my @opts;
  push @opts, "database=$self->{'database'}" if $self->{'database'};
  push @opts, "hostname=$self->{'server'}"   if $self->{'server'};
  push @opts, "port=$self->{'port'}"         if $self->{'port'};
  my $opts = join ";", @opts;
  $self->{'dbh'} = DBI->connect( 
    "dbi:mysql:$opts", 
    $self->{'user'},
    $self->{'password'},
  ) or die( "Login Failed: $DBI::errstr");
  return $self->{'dbh'};
}

sub format_column_value {
  my $self = shift;
  my $col = shift;
  if( $col->{'value'} eq 'auto' ) {
    return (
      undef, 
      $self->format_null_value($col). " AUTO_INCREMENT",
      undef
    );
  } else {
    return $self->SUPER::format_column_value($col);
  }
}

1;
