package Spidy::GraphicsBuilder::imagemagick;

use Spidy::GraphicsBuilder;
@ISA = qw( Spidy::GraphicsBuilder );

use strict;

sub convert {
  my $self = shift;
  my $image = shift;
  my $size = shift;
  
  $self->{'im_convert'} = $ENV{"IM_CONVERT"}
    unless $self->{'im_convert'};
  $self->{'im_composite'} = $ENV{"IM_COMPOSITE"}
    unless $self->{'im_composite'};
    
  unless( -f $self->{'im_convert'} ) {
    my @paths = File::Spec->path();
    foreach my $path (@paths) {
      my $convert = $^O eq 'MSWin32' ? "$path/convert.exe" : "$path/convert";
      if( -e "$convert" ) {
        $self->{'im_convert'} = $convert;
        last;
      }
    }
    foreach my $path (@paths) {
      my $composite = $^O eq 'MSWin32' ? "$path/composite.exe" : "$path/composite";
      if( -e "$composite" ) {
        $self->{'im_composite'} = "$composite";
        last;
      }
    }
  }

  unless( -f $self->{'im_convert'} ) {
    die <<EOF;
I could not find the Image Magick 'convert' program which is necessary to
create all the various size images.  You can specify where the program is
by setting the IM_CONVERT environment variable or by using the 
--convert option if you are using the 'spider' program.

If you do not have Image Magick installed, then you can get it from
http://www.imagemagick.org
EOF
  }
  
  $self->SUPER::convert($image,$size);
  return;
}

sub resize_image {
  my $self = shift;
  my %args = @_;

  my $x = $args{'width'} || $args{size}->{'max_width'};
  my $y = $args{'height'} || $args{size}->{'max_height'};
  my $geom = "${x}x$y";
  my $qual = $args{size}->{'quality'};

  my @system = ( 
    $self->{'im_convert'}, 
    "-geometry", $geom,
    "-quality", $qual,
    $args{input_image},
    $args{output_image}
  );
  print "@system\n"  unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
  system(@system) == 0
    or die "error invoking '@system': $!";
}

sub resize_padded_image {
  my $self = shift;
  my %args = @_;
  
#   print "creating temporary file $dir/$output_image\n" unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
  $self->resize_image(%args);
  
  my $w = $args{'width'} || $args{size}->{'max_width'};
  my $h = $args{'height'} || $args{size}->{'max_height'};

  require Image::Size;
  my ($x, $y) = Image::Size::imgsize($args{output_image});
  $x = ($w  - $x)/2;
  $y = ($h  - $y)/2;
  #
  # force $x and $y into ints (padding with leading 0's)
  #
  $x = sprintf("%#02d", $x);
  $y = sprintf("%#02d", $y);
  $x = "01" if $x eq '00';
  $y = "01" if $y eq '00';
  my @system = (
    $self->{'im_convert'},
    "-bordercolor",  "#$args{color}", 
    "-border",  "${x}x$y",
    $args{output_image},
    $args{output_image}
  );
  print "@system\n"  unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
  system(@system) == 0
    or die "error invoking '@system': $!";
  return;
}        

sub watermark {
  my $self = shift;
  my %args = shift;
  
  if( defined($args{size}->{'watermark'}) 
      && $args{size}->{'watermark'} =~ /$Spidy::GraphicsBuilder::rxTrue/
      && $self->{'watermark'} ) {
    unless( -f $self->{'im_composite'} ) {
      die <<EOF;
I could not find the Image Magick 'composite' program which is necessary 
to create the 'watermark' images.  You can specify where the program is
by setting the IM_COMPOSITE environment variable.

If you do not have Image Magick installed, then you can get it from
http://www.imagemagick.org
EOF
    }
    my @system = (
      $self->{'im_composite'},
      '-gravity', $self->{'gravity'},
      '-compose', 'over', $self->{'watermark'},
      $args{output_image},
      $args{output_image}
    );
    print "@system\n"  unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
    system(@system) == 0
      or die "error invoking '@system': $!";
  }
}  
1;
