package Spidy::HtmlBuilder;

use Spidy::Object;
@ISA = ('Spidy::Object');

use strict;
use Carp;
use HTML::Template;
use File::Basename;

sub autoload_members {
  return {
    'default_size'        => 'scalar=small',
    'templates'           => 'hash',
  }
}

{
  my %templates;

  sub get_template {
    my $self = shift;
    my $group = shift;
    my $file;
    if( substr($group->{'template'}, 0, 1) eq "/" ) {
      $file = $group->{'template'};
    } else {
      #
      # if the filename has a '/' in it, then test to see it
      # exists as it.
      #
      # else check to see if prepending the template_path makes
      # it a real file
      #
      # else check to see if it in the current directory
      #
      # else check to see if it is in the directory under where
      # the current Spidy is being used from.
      #
      # else just die a miserable death.
      #
      my $t = $group->template_file();
      if( $t =~ m:/: && -f $t ) {
        $file = $t;
      } elsif( -f "$group->{'template_path'}/$t" ) {
        $file = "$group->{'template_path'}/$t";
      } elsif ( -f "./$t" ) {
        $file = $t;
        $file = "./$file" unless substr($file, 0, 2) eq './';
      } elsif( -f dirname(__FILE__)."/Templates/$t" ) {
        $file = dirname(__FILE__)."/Templates/$t";
      } else {
        die "Template $t not found!\n";
      }
    }

    #
    # if we have already loaded this template, don't parse it again.
    # Just return the previous template object.
    #
    return $templates{$file}
      if $templates{$file};

    print "Loading template $file\n" unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;

    #
    # Create the template object and store it in the current 
    # HtmlBuilder object templates hash.
    #
    return $templates{$file} = HTML::Template->new(
      filename          => $file, 
      die_on_bad_params => 0,
      global_vars       => 1,
      loop_context_vars => 1,
    );
  }
}

sub get_html {
  my $self = shift;
  my $group = shift;
  my $size = shift;

  my $template = $self->get_template($group);
  my %params;
  my @names = $template->query();
  for my $param ( @names ) {
    $params{ $param } = $group->set_param_data( $param, $size );
  }
  $template->clear_params();
  $template->param( \%params );
  return $template->output();
}

BEGIN{
    #
    # in Version 1.8 'global_vars' was added.  We need this feature.
    #
    if( $HTML::Template::VERSION < 1.8 ) {
        warn( "#"x50, "\n") ;
        warn( "HTML::Template Version ($HTML::Template::VERSION) is too old.\n1.8 or greater is required", "\n" );
        warn( "#"x50, "\n") ;
        exit -1;
    }
};

1;    
