package Spidy::Image;

use Spidy::Group;
@ISA = qw( Spidy::Group );

use strict;
use Image::Size;

sub autoload_members {
    my $self = shift;
    return {
        %{$self->SUPER::autoload_members()},
        'output_image'       => 'scalar',
        'input_image'        => 'scalar',
        'max_height'         => 'scalar',
        'max_width'          => 'scalar',
        'left_output_html'   => 'scalar',
        'left_output_image'  => 'scalar',
        'right_output_html'  => 'scalar',
        'right_output_image' => 'scalar',
        'mouse_over'         => 'scalar;xml=attr',
        'output_mouse_over'  => 'scalar',

        'template'                 => "scalar",
    };
}

sub set_defaults { 
  my $self = shift;
  my %defaults;
  if( ref($_[0]) ) {
    %defaults = %{$_[0]};
  } else {
    %defaults = @_;
  }
  
  for my $key ( keys %defaults ) {
    $self->{$key} = $defaults{$key}
      unless defined $self->{$key};
  }
  
  #
  # Data here is for html file generation
  # of image generation.  Also html data
  # that is recursive in nature (directory paths)
  # is set here for efficiency's sake.
  # 
  #

  if( my $parent = $self->{'parent'} ) {

    $self->{'output_image_path'}
      = $parent->{'output_image_path'}
      unless $self->{'output_image_path'};

    $self->{'input_image_path'}
      = $parent->{'input_image_path'}
      unless $self->{'input_image_path'};

    $self->{'file_path'}
      = $parent->{'file_path'}
      unless $self->{'file_path'};

    $self->{'html_path'}
      = $parent->{'html_path'}
      unless $self->{'html_path'};
      
    $self->{'top_html_path'} 
      =  $parent->{'top_html_path'}
      unless $self->{'top_html_path'};
      
    $self->{'image_url'}
      = $parent->{'image_url'}
      unless $self->{'image_url'};

    $self->SUPER::set_defaults(%defaults);
 
  }
  return;
}  

sub set_param_data {
  my $self = shift;
  my $p = shift;
  my $size = shift;
  my $caller = shift || $self;
  if( $p eq 'title' ) {
    return $self->{$p} || "Picture ".$self->pos()." of ".$self->count();
  } elsif( $p eq 'short_title' ) {
    return $self->{$p} || $self->{'title'} || "Picture ".$self->pos()." of ".$self->count();
  } elsif( $p eq 'href' ) {
    return "$caller->{'top_html_path'}/$self->{'html_path'}/$size->{'name'}_$self->{'output_html'}";
  } elsif( $p eq 'src' ) {
    unless( $caller->isa("Spidy::Image") ) {
      $size = $size->first();
    }
    my $output_image = $self->get_output_image($size);
    if( $size->{'padded'} ) {
      return "$caller->{'top_image_path'}/$self->{'image_url'}/$size->{'name'}/".$caller->set_param_data('bg_color', $size, $caller)."/$output_image";
    } else {
      if( $size->{'symlink'} ) {
        my $input_image = $self->{'input_image'};
        return "$caller->{'top_image_path'}/$self->{'image_url'}/$size->{'name'}/$input_image";
      }
      return "$caller->{'top_image_path'}/$self->{'image_url'}/$size->{'name'}/$output_image";
    }
  } elsif( $p eq 'mouse_over_src' ) {
    return "$caller->{'top_image_path'}/$self->{'image_url'}/$size->{'name'}/$self->{'output_mouse_over'}";
  } elsif( $p eq 'mouse_over' ) {
    return $self->{'output_mouse_over'} ? 1 : 0;
  } elsif( $p eq 'max_width' ) {
    unless( $caller->isa("Spidy::Image") ) {
      $size = $size->first();
    }
    return ($size->{'max_width'} || $self->set_param_data( "width", $size, $caller ) ) + 5;
  } elsif( $p eq 'max_height' ) {
    unless( $caller->isa("Spidy::Image") ) {
      $size = $size->first();
    }
    return ($size->{'max_height'} || $self->set_param_data( "height", $size, $caller ) ) + 5;
  } elsif( $p eq 'width') {
    unless( $caller->isa("Spidy::Image") ) {
      $size = $size->first();
    }
    my $output_image = $self->get_output_image($size);
    my $path;
    if( $size->{'padded'} ) {
      $path = "$self->{'output_image_path'}/$size->{'name'}/".$caller->set_param_data('bg_color', $size, $caller);
    } else {
      $path = "$self->{'output_image_path'}/$size->{'name'}";
    }
    my @data = Image::Size::imgsize("$path/$output_image");
    if( !$data[0] && !$data[1] && $data[2] =~ /\S/ ) {
      warn "Could not read size $path/$output_image: $data[2]\n";
    }
    return $data[0];
#    return (Image::Size::imgsize("$self->{'output_image_path'}/$size->{'name'}/$output_image"))[0];
  } elsif( $p eq  'height' ) {
    unless( $caller->isa("Spidy::Image") ) {
      $size = $size->first();
    }
    my $output_image = $self->get_output_image($size);
    my $path;
    if( $size->{'padded'} ) {
      $path = "$self->{'output_image_path'}/$size->{'name'}/".$caller->set_param_data('bg_color', $size, $caller);
    } else {
      $path = "$self->{'output_image_path'}/$size->{'name'}";
    }
    my @data = Image::Size::imgsize("$path/$output_image");
    if( !$data[0] && !$data[1] && $data[2] =~ /\S/ ) {
      warn "Could not read size $path/$output_image: $data[2]\n";
    }
    return $data[1];
  } elsif( $p eq 'left_href' ) {
    return $self->{'previous'}->set_param_data( 'href', $size, $caller )
      if $self->{'previous'};
    my $prev = $self->previous_group();
    
    return "" if $self->isolated( $prev, $self->{'parent'} );
    my $image = $prev->last_image()
      if $prev;
    return "" if $self->{'isolate'};  
    return "" if $image && $image->{'parent'} ne $caller->{'parent'} && $image->{'isolate'};
    return $image->set_param_data( 'href', $size, $caller )
      if $image;
    return "";
  } elsif( $p eq 'left_src' ) {
    return $self->{'previous'}->set_param_data( 'src', $size->first(), $caller )
      if $self->{'previous'};
    my $prev = $self->previous_group();
    return if $self->isolated( $prev, $self->{'parent'} );
    my $image = $prev->last_image()
      if $prev;
#    return if $self->{'isolate'};  
    return if $image && $image->{'parent'} ne $caller->{'parent'} && $image->{'isolate'};
    return $image->set_param_data( 'src', $size->first(), $caller )
      if $image;
    return;
  } elsif( $p eq 'right_href' ) {
    return $self->{'next'}->set_param_data( 'href', $size, $caller )
      if $self->{'next'};
    my $next = $self->next_group();
    return if $self->isolated( $next, $self->{'parent'} );
    my $image = $next->first_image()
      if $next;
# moved to Group::isolate
#    return if $self->{'isolate'};  
    return if $image && $image->{'parent'} ne $caller->{'parent'} && $image->{'isolate'};
    return $image->set_param_data( 'href', $size, $caller )
      if $image;
    return;
  } elsif( $p eq 'right_src' ) {
    return $self->{'next'}->set_param_data( 'src', $size->first(), $caller )
      if $self->{'next'};
    my $next = $self->next_group();
    return if $self->isolated( $next, $self->{'parent'} );
    my $image = $next->first_image()
      if $next;
    return if $self->{'isolate'};  
    return if $image && $image->{'parent'} ne $caller->{'parent'} && $image->{'isolate'};
    return $image->set_param_data( 'src', $size->first(), $caller )
      if $image;
    return;
  } elsif( $p eq 'left_group_href' ) {
    my $prev = $self->previous_group();
    return $prev->first_image()->set_param_data( 'href', $size, $caller )
      if $prev;
    return;
  } elsif( $p eq 'right_group_href' ) {
    my $next = $self->next_group();
    return $next->first_image()->set_param_data( 'href', $size, $caller )
      if $next;
    return;
  } elsif( $p eq 'sizes' ) {
    my $cur = $size->first();
    my @data;
    while( $cur ) {
      if( $cur->{'name'} eq 'thumb' ) {
        $cur = $cur->{'next'};
        next;
      }
      push @data, {
        'href' => $self->set_param_data( 'href', $cur, $caller ),
        'name' => $cur->{'name'},
        'src'  => $self->set_param_data( 'src', $cur, $caller ),
        'selected' => $size->{'name'} eq $cur->{'name'} ? 1 : 0,
        'original' => $cur->{'name'} eq 'original' ? 1 : 0,
      };
      $cur = $cur->{'next'};
    }
    return \@data;
  } elsif( $p eq 'parent_title' ) {
    return $self->{'parent'}->set_param_data( 'title', $size, $caller );
  }
    
  return $self->SUPER::set_param_data( $p, $size, $caller );
}

sub template_file {
  my $self = shift;
  return $self->{'template'} || $self->default->{'image_template_file'};
}


1;


