#!/usr/bin/perl -w

use strict;
use lib qw( t t/lib );
use Test::More tests => 2; #'no_plan';

use Cwd;
my $path = cwd();

is( `/usr/bin/perl -I$path ./spider --sizes 2>&1`,<<EOF, "testing --sizes" );
+--------+-----+------+-------+------+---------+------+
|name    |width|height|quality|padded|watermark|custom|
+--------+-----+------+-------+------+---------+------+
|thumb   |   60|    60|     80|yes   |no       |no    |
|teeny   |  250|   200|     80|no    |yes      |no    |
|small   |  400|   300|     80|no    |yes      |no    |
|medium  |  500|   400|     80|no    |yes      |no    |
|large   |  800|   600|     90|no    |yes      |no    |
|xlarge  | 1300|  1000|     97|no    |yes      |no    |
|original|    *|     *|     80|no    |no       |no    |
+--------+-----+------+-------+------+---------+------+
EOF

#/usr/bin/perl -I`pwd` ./spider --file t/xml/sizes.xml --sizes 2>&1

is( `/usr/bin/perl -I$path ./spider --file t/xml/sizes.xml --sizes 2>&1`,<<EOF, "testing xml <size>" );
+--------+-----+------+-------+------+---------+------+
|name    |width|height|quality|padded|watermark|custom|
+--------+-----+------+-------+------+---------+------+
|thumb   |  100|   100|     80|yes   |no       |yes   |
|teeny   |  250|   200|     80|no    |yes      |no    |
|small   |  400|   300|     80|no    |yes      |no    |
|medium  |  500|   400|     80|no    |yes      |no    |
|large   |  800|   600|     90|no    |yes      |no    |
|xlarge  | 1300|  1000|     97|no    |yes      |no    |
|original|    *|     *|     80|no    |no       |no    |
|huge    | 4000|  3000|     99|no    |no       |yes   |
+--------+-----+------+-------+------+---------+------+
EOF
