#!/usr/bin/perl -w

use strict;
use lib qw( t t/lib );
use vars '$path';
use Test::More tests => 3;

use File::Path;
use File::Copy;
use Cwd;

BEGIN {
  $path = cwd();
}

BEGIN {
  use lib ($path);
  use Spidy::Tree;
}

mkpath( "$path/t/pattern", 0, 0777 );
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/001.gif")
  or die "Could not create $path/t/pattern/001.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/002.gif")
  or die "Could not create $path/t/pattern/002.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003.gif")
  or die "Could not create $path/t/pattern/003.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003*.gif")
  or die "Could not create $path/t/pattern/003*.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003-1.gif")
  or die "Could not create $path/t/pattern/003-1.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003+.gif")
  or die "Could not create $path/t/pattern/003\+.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003[123].gif")
  or die "Could not create $path/t/pattern/003[123].gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003(123).gif")
  or die "Could not create $path/t/pattern/003(123).gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003(123.gif")
  or die "Could not create $path/t/pattern/003(123.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003[123.gif")
  or die "Could not create $path/t/pattern/003[123.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003--123).gif")
  or die "Could not create $path/t/pattern/003--123).gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/003--123].gif")
  or die "Could not create $path/t/pattern/003--123].gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/i001.gif")
  or die "Could not create $path/t/pattern/i001.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/i002.gif")
  or die "Could not create $path/t/pattern/i002.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/i003.gif")
  or die "Could not create $path/t/pattern/i003.gif: $!";
copy( "$path/Spidy/Icons/nothing.gif", "$path/t/pattern/i010.gif")
  or die "Could not create $path/t/pattern/i010.gif: $!";

my $pattern = '^[000-003]\.gif';

my @files = sort { $a cmp $b } Spidy::Tree->find_pattern_files( "$path/t/pattern", $pattern );

is_deeply( \@files, [
  '001.gif',
  '002.gif',
  '003.gif'
], 'pattern: ^[000-003]\.gif');

$pattern = '^i[001-010]\.gif';
@files = sort { $a cmp $b } Spidy::Tree->find_pattern_files( "$path/t/pattern", $pattern );

is_deeply( \@files, [
  'i001.gif',
  'i002.gif',
  'i003.gif',
  'i010.gif'
], 'pattern: ^i[001-010]\.gif');

$pattern = '0[00-10].*$';
@files = sort { $a cmp $b } Spidy::Tree->find_pattern_files( "$path/t/pattern", $pattern );
is_deeply( \@files, files(), 'pattern: 0[00-10].*$');

for my $file ( @{files()} ) {
  if( -f "$path/t/pattern/$file" ) {
    unlink( "$path/t/pattern/$file" )
      or die "Could not remove $path/t/pattern/$file: $!";
  }
}

if( -d "$path/t/pattern" ) {
  rmdir( "$path/t/pattern" )
    or die "Could not remove $path/t/pattern: $!";
}

sub files {
  return [ sort { $a cmp $b } 
    'i001.gif',
    'i002.gif',
    'i003.gif',
    'i010.gif',
    '001.gif',
    '002.gif',
    '003.gif',
    '003*.gif',
    '003-1.gif',
    '003+.gif',
    '003[123].gif',
    '003(123).gif',
    '003(123.gif',
    '003[123.gif',
    '003--123).gif',
    '003--123].gif'
  ];
}



