/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.springframework.core.Conventions;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.form.AbstractFormTag;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.util.HtmlUtils;

public class FormTag
extends AbstractHtmlElementTag {
    private static final String DEFAULT_METHOD = "post";
    public static final String DEFAULT_COMMAND_NAME = "command";
    private static final String MODEL_ATTRIBUTE = "modelAttribute";
    public static final String MODEL_ATTRIBUTE_VARIABLE_NAME = Conventions.getQualifiedAttributeName((Class)AbstractFormTag.class, (String)"modelAttribute");
    private static final String ACTION_ATTRIBUTE = "action";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String TARGET_ATTRIBUTE = "target";
    private static final String ENCTYPE_ATTRIBUTE = "enctype";
    private static final String ACCEPT_CHARSET_ATTRIBUTE = "accept-charset";
    private static final String ONSUBMIT_ATTRIBUTE = "onsubmit";
    private static final String ONRESET_ATTRIBUTE = "onreset";
    private static final String AUTOCOMPLETE_ATTRIBUTE = "autocomplete";
    private TagWriter tagWriter;
    private String modelAttribute = "command";
    private String name;
    private String action;
    private String method = "post";
    private String target;
    private String enctype;
    private String acceptCharset;
    private String onsubmit;
    private String onreset;
    private String autocomplete;
    private String previousNestedPath;

    public void setModelAttribute(String modelAttribute) {
        this.modelAttribute = modelAttribute;
    }

    protected String getModelAttribute() {
        return this.modelAttribute;
    }

    public void setCommandName(String commandName) {
        this.modelAttribute = commandName;
    }

    protected String getCommandName() {
        return this.modelAttribute;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected String getName() throws JspException {
        return this.name;
    }

    public void setAction(String action) {
        this.action = action != null ? action : "";
    }

    protected String getAction() {
        return this.action;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    protected String getMethod() {
        return this.method;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    protected String getEnctype() {
        return this.enctype;
    }

    public void setAcceptCharset(String acceptCharset) {
        this.acceptCharset = acceptCharset;
    }

    protected String getAcceptCharset() {
        return this.acceptCharset;
    }

    public void setOnsubmit(String onsubmit) {
        this.onsubmit = onsubmit;
    }

    protected String getOnsubmit() {
        return this.onsubmit;
    }

    public void setOnreset(String onreset) {
        this.onreset = onreset;
    }

    protected String getOnreset() {
        return this.onreset;
    }

    public void setAutocomplete(String autocomplete) {
        this.autocomplete = autocomplete;
    }

    protected String getAutocomplete() {
        return this.autocomplete;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        this.tagWriter = tagWriter;
        tagWriter.startTag("form");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute(ACTION_ATTRIBUTE, this.resolveAction());
        this.writeOptionalAttribute(tagWriter, METHOD_ATTRIBUTE, this.getMethod());
        this.writeOptionalAttribute(tagWriter, TARGET_ATTRIBUTE, this.getTarget());
        this.writeOptionalAttribute(tagWriter, ENCTYPE_ATTRIBUTE, this.getEnctype());
        this.writeOptionalAttribute(tagWriter, ACCEPT_CHARSET_ATTRIBUTE, this.getAcceptCharset());
        this.writeOptionalAttribute(tagWriter, ONSUBMIT_ATTRIBUTE, this.getOnsubmit());
        this.writeOptionalAttribute(tagWriter, ONRESET_ATTRIBUTE, this.getOnreset());
        this.writeOptionalAttribute(tagWriter, AUTOCOMPLETE_ATTRIBUTE, this.getAutocomplete());
        tagWriter.forceBlock();
        String modelAttribute = this.resolveModelAttribute();
        this.pageContext.setAttribute(MODEL_ATTRIBUTE_VARIABLE_NAME, (Object)modelAttribute, 2);
        this.pageContext.setAttribute(COMMAND_NAME_VARIABLE_NAME, (Object)modelAttribute, 2);
        this.previousNestedPath = (String)this.pageContext.getAttribute("nestedPath", 2);
        this.pageContext.setAttribute("nestedPath", (Object)(modelAttribute + "."), 2);
        return 1;
    }

    protected String autogenerateId() throws JspException {
        return this.resolveModelAttribute();
    }

    protected String resolveModelAttribute() throws JspException {
        Object resolvedModelAttribute = this.evaluate(MODEL_ATTRIBUTE, this.getModelAttribute());
        if (resolvedModelAttribute == null) {
            throw new IllegalArgumentException("modelAttribute must not be null");
        }
        return (String)resolvedModelAttribute;
    }

    protected String resolveAction() throws JspException {
        String action = this.getAction();
        if (StringUtils.hasText((String)action)) {
            return this.getDisplayString(this.evaluate(ACTION_ATTRIBUTE, action));
        }
        String requestUri = this.getRequestContext().getRequestUri();
        ServletResponse response = this.pageContext.getResponse();
        if (response instanceof HttpServletResponse) {
            requestUri = ((HttpServletResponse)response).encodeURL(requestUri);
            String queryString = this.getRequestContext().getQueryString();
            if (StringUtils.hasText((String)queryString)) {
                requestUri = requestUri + "?" + HtmlUtils.htmlEscape((String)queryString);
            }
        }
        if (StringUtils.hasText((String)requestUri)) {
            return requestUri;
        }
        throw new IllegalArgumentException("Attribute 'action' is required. Attempted to resolve against current request URI but request URI was null.");
    }

    public int doEndTag() throws JspException {
        this.tagWriter.endTag();
        this.pageContext.removeAttribute(MODEL_ATTRIBUTE_VARIABLE_NAME, 2);
        this.pageContext.removeAttribute(COMMAND_NAME_VARIABLE_NAME, 2);
        if (this.previousNestedPath != null) {
            this.pageContext.setAttribute("nestedPath", (Object)this.previousNestedPath, 2);
        } else {
            this.pageContext.removeAttribute("nestedPath", 2);
        }
        return 6;
    }

    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
        this.previousNestedPath = null;
    }

    protected String resolveCssClass() throws JspException {
        return ObjectUtils.getDisplayString((Object)this.evaluate("cssClass", this.getCssClass()));
    }

    public void setPath(String path) {
        throw new UnsupportedOperationException("The 'path' attribute is not supported for forms");
    }

    public void setCssErrorClass(String cssErrorClass) {
        throw new UnsupportedOperationException("The 'cssErrorClass' attribute is not supported for forms");
    }
}

