/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.IoUtils;
import com.tonicsystems.jarjar.StringReader;
import com.tonicsystems.jarjar.ext_util.ClassPathIterator;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import java.io.IOException;
import java.io.PrintWriter;

class StringDumper {
    public void run(String classPath, PrintWriter pw) throws IOException {
        DumpStringReader stringReader = new DumpStringReader(pw);
        ClassPathIterator cp = new ClassPathIterator(classPath);
        try {
            while (cp.hasNext()) {
                try {
                    IoUtils.readClass(cp.getInputStream(cp.next())).accept(stringReader, 0);
                }
                catch (ClassFormatError e) {
                    // empty catch block
                }
                pw.flush();
            }
        }
        catch (RuntimeIOException e) {
            throw (IOException)e.getCause();
        }
    }

    private static class DumpStringReader
    extends StringReader {
        private final PrintWriter pw;
        private String className;

        public DumpStringReader(PrintWriter pw) {
            this.pw = pw;
        }

        public void visitString(String className, String value, int line) {
            if (value.length() > 0) {
                if (!className.equals(this.className)) {
                    this.className = className;
                    this.pw.println(className.replace('/', '.'));
                }
                this.pw.print("\t");
                if (line >= 0) {
                    this.pw.print(line + ": ");
                }
                this.pw.print(IoUtils.escapeStringLiteral(value));
                this.pw.println();
            }
        }
    }
}

