/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.JUnit4ClassRunner;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.SpringMethodRoadie;
import org.springframework.test.context.junit4.SpringTestMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringJUnit4ClassRunner
extends JUnit4ClassRunner {
    private static final Log logger = LogFactory.getLog(SpringJUnit4ClassRunner.class);
    private final TestContextManager testContextManager;

    public SpringJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SpringJUnit4ClassRunner constructor called with [" + clazz + "]."));
        }
        this.testContextManager = this.createTestContextManager(clazz);
    }

    public void run(RunNotifier notifier) {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.getTestClass().getJavaClass())) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        super.run(notifier);
    }

    protected Object createTest() throws Exception {
        Object testInstance = super.createTest();
        this.getTestContextManager().prepareTestInstance(testInstance);
        return testInstance;
    }

    protected TestContextManager createTestContextManager(Class<?> clazz) {
        return new TestContextManager(clazz);
    }

    protected final TestContextManager getTestContextManager() {
        return this.testContextManager;
    }

    protected void invokeTestMethod(Method method, RunNotifier notifier) {
        Object testInstance;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoking test method [" + method.toGenericString() + "]"));
        }
        Description description = this.methodDescription(method);
        try {
            testInstance = this.createTest();
        }
        catch (InvocationTargetException ex) {
            notifier.testAborted(description, ex.getCause());
            return;
        }
        catch (Exception ex) {
            notifier.testAborted(description, (Throwable)ex);
            return;
        }
        SpringTestMethod testMethod = new SpringTestMethod(method, this.getTestClass());
        new SpringMethodRoadie(this.getTestContextManager(), testInstance, testMethod, notifier, description).run();
    }
}

