/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.exceptions.XMLParseException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.XMLException;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.XMLExceptionHandler;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.XPathEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLHelper {
    private Document m_document;
    private ClassLoader m_loader;
    private String m_documentName;
    private String m_defaultPackage;
    private XPathEngine m_xPathEngine = XPathEngine.getInstance();

    protected XMLHelper(Document document, ClassLoader loader) {
        this.m_loader = loader;
        this.m_document = document;
        Node node = this.getNode((Node)document, new String[]{"entity-mappings", "package", "text()"});
        this.m_defaultPackage = node != null && node.getNodeValue() != null ? node.getNodeValue() : "";
    }

    public XMLHelper(Document document, String fileName, ClassLoader loader) {
        this(document, loader);
        this.m_documentName = fileName;
    }

    public List<String> getCascadeTypes(Node node) {
        ArrayList<String> cTypes = new ArrayList<String>();
        NodeList cascadeTypes = this.getNodes(node, "cascade", "child::*");
        for (int i = 0; i < cascadeTypes.getLength(); ++i) {
            cTypes.add(cascadeTypes.item(i).getLocalName());
        }
        return cTypes;
    }

    public Class getClassForName(String className) {
        return MetadataHelper.getClassForName(this.getFullyQualifiedClassName(className), this.m_loader);
    }

    public Class getClassForNode(Node node) {
        return MetadataHelper.getClassForName(this.getClassNameForNode(node), this.m_loader);
    }

    public String getClassNameForNode(Node node) {
        return this.getFullyQualifiedClassName(this.getNodeValue(node, "@class"));
    }

    public Document getDocument() {
        return this.m_document;
    }

    public String getDocumentName() {
        return this.m_documentName;
    }

    public String getFetchTypeDefaultEAGER(Node node) {
        return this.getNodeValue(node, "@fetch", "EAGER");
    }

    public String getFetchTypeDefaultLAZY(Node node) {
        return this.getNodeValue(node, "@fetch", "LAZY");
    }

    public String getFullyQualifiedClassName(String className) {
        return XMLHelper.getFullyQualifiedClassName(className, this.m_defaultPackage);
    }

    public static String getFullyQualifiedClassName(String className, String packageName) {
        if (packageName.equals("") || className.indexOf(".") != -1) {
            return className;
        }
        if (packageName.endsWith(".")) {
            return packageName + className;
        }
        return packageName + "." + className;
    }

    public String getLoggingContextForDefaultMappingReferenceClass(Node mappingNode) {
        if (mappingNode.getLocalName().equals("one-to-one")) {
            return "metadata_default_one_to_one_reference_class";
        }
        if (mappingNode.getLocalName().equals("one-to-many")) {
            return "metadata_default_one_to_many_reference_class";
        }
        if (mappingNode.getLocalName().equals("many-to-one")) {
            return "metadata_default_many_to_one_reference_class";
        }
        return "metadata_default_many_to_many_reference_class";
    }

    public String getMappedBy(Node node) {
        return this.getNodeValue(node, "@mapped-by", "");
    }

    public Node getNode(Node node, String xPath) {
        return this.getNode(node, new String[]{xPath});
    }

    public Node getNode(Node node, String[] xPath) {
        return this.m_xPathEngine.selectSingleNode(node, xPath);
    }

    public Node getNode(String[] xPath) {
        return this.getNode((Node)this.m_document, xPath);
    }

    public NodeList getNodes(String xPath1, String xPath2) {
        return this.getNodes((Node)this.m_document, new String[]{xPath1, xPath2});
    }

    public NodeList getNodes(String[] xPath) {
        return this.getNodes((Node)this.m_document, xPath);
    }

    public String getNodeTextValue(Node node, String xPath) {
        return this.getNodeValue(node, new String[]{xPath, "text()"});
    }

    public String getNodeTextValue(String xPath1, String xPath2) {
        return this.getNodeValue((Node)this.m_document, new String[]{xPath1, xPath2, "text()"});
    }

    public String getNodeTextValue(String xPath1, String xPath2, String defaultValue) {
        return this.getNodeValue((Node)this.m_document, new String[]{xPath1, xPath2, "text()"}, defaultValue);
    }

    public String getNodeValue(Node node, String xPath) {
        return this.getNodeValue(node, new String[]{xPath});
    }

    public boolean getNodeValue(Node node, String xPath, boolean defaultValue) {
        return this.getNodeValue(node, new String[]{xPath}, defaultValue);
    }

    public Class getNodeValue(Node node, String xPath, Class defaultValue) {
        return this.getNodeValue(node, new String[]{xPath}, defaultValue);
    }

    public int getNodeValue(Node node, String xPath, int defaultValue) {
        return this.getNodeValue(node, new String[]{xPath}, defaultValue);
    }

    public String getNodeValue(Node node, String xPath, String defaultValue) {
        return this.getNodeValue(node, new String[]{xPath}, defaultValue);
    }

    public NodeList getNodes(Node node, String xPath) {
        return this.getNodes(node, new String[]{xPath});
    }

    public NodeList getNodes(Node node, String xPath1, String xPath2) {
        return this.getNodes(node, new String[]{xPath1, xPath2});
    }

    public NodeList getNodes(Node node, String[] xPath) {
        return this.m_xPathEngine.selectNodes(node, xPath);
    }

    public boolean getNodeValue(Node node, String[] xPath, boolean defaultValue) {
        return this.getValue(this.getNode(node, xPath), defaultValue);
    }

    public Class getNodeValue(Node node, String[] xPath, Class defaultValue) {
        return this.getValue(this.getNode(node, xPath), defaultValue);
    }

    public int getNodeValue(Node node, String[] xPath, int defaultValue) {
        return this.getValue(this.getNode(node, xPath), defaultValue);
    }

    public String getNodeValue(Node node, String[] xPath, String defaultValue) {
        return this.getValue(this.getNode(node, xPath), defaultValue);
    }

    public String getNodeValue(Node node, String[] xPath) {
        return this.getNodeValue(node, xPath, "");
    }

    public String getNodeValue(String[] xPath) {
        return this.getNodeValue(xPath, "");
    }

    public int getNodeValue(String[] xPath, int defaultValue) {
        return this.getValue(this.getNode(xPath), defaultValue);
    }

    public String getNodeValue(String[] xPath, String defaultValue) {
        return this.getValue(this.getNode(xPath), defaultValue);
    }

    public String getPackage() {
        return this.m_defaultPackage;
    }

    public Class getTargetEntity(Node node) {
        return this.getNodeValue(node, "@target-entity", Void.TYPE);
    }

    public NodeList getTextColumnNodes(Node node) {
        return this.getNodes(node, new String[]{"column-name", "text()"});
    }

    private boolean getValue(Node node, boolean defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(node.getNodeValue());
    }

    private Class getValue(Node node, Class defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return this.getClassForName(node.getNodeValue());
    }

    private int getValue(Node node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return Integer.parseInt(node.getNodeValue());
    }

    private String getValue(Node node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        String value = node.getNodeValue();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean hasNode(Node node, String xPath) {
        return this.getNode(node, xPath) != null;
    }

    public boolean isOptional(Node node) {
        return this.getNodeValue(node, "@optional", true);
    }

    public Node locateEmbeddableNode(Class cls) {
        return this.locateNode(cls, "embeddable");
    }

    public Node locateEntityNode(Class cls) {
        return this.locateNode(cls, "entity");
    }

    public Node locateMappedSuperclassNode(Class cls) {
        return this.locateNode(cls, "mapped-superclass");
    }

    public Node locateNode(Class cls) {
        Node result = null;
        result = this.locateEntityNode(cls);
        if (result == null) {
            result = this.locateMappedSuperclassNode(cls);
        }
        if (result == null) {
            result = this.locateEmbeddableNode(cls);
        }
        return result;
    }

    private Node locateNode(Class cls, String searchString) {
        NodeList nodes = this.getNodes(this.m_document, "entity-mappings", searchString);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!this.getClassNameForNode(node).equals(cls.getName())) continue;
                return node;
            }
        }
        return null;
    }

    public Node locateNodeForAttribute(Node node, String attributeName) {
        NodeList attributeNodes = this.getNodes(node, "attributes", "child::*");
        if (attributeNodes != null) {
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                Node attributeNode = attributeNodes.item(i);
                if (!this.getNodeValue(attributeNode, "@name").equals(attributeName)) continue;
                return attributeNode;
            }
        }
        return null;
    }

    public Class locateRootEntity(Class entityClass) {
        Node entityNode;
        Class superclass = entityClass.getSuperclass();
        if (superclass != null && (entityNode = this.locateEntityNode(superclass)) != null) {
            return this.locateRootEntity(superclass);
        }
        return entityClass;
    }

    public boolean nodeHasPrimaryKeyJoinColumns(Node node) {
        if (node == null) {
            return false;
        }
        NodeList nodes = this.getNodes(node, "primary-key-join-column");
        return nodes != null && nodes.getLength() > 0;
    }

    public boolean nodeHasJoinColumns(Node node) {
        if (node == null) {
            return false;
        }
        NodeList nodes = this.getNodes(node, "join-column");
        return nodes != null && nodes.getLength() > 0;
    }

    public static Document parseDocument(InputStream xmlDocumentInputStream, String documentName, ClassLoader loader) {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        dbf.setValidating(true);
        URL schemaURL = loader.getResource("orm_1_0.xsd");
        if (schemaURL != null) {
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaURL.toString());
        }
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pex) {
            throw XMLParseException.exceptionCreatingDocumentBuilder(documentName, pex);
        }
        XMLExceptionHandler xmlExceptionHandler = new XMLExceptionHandler();
        db.setErrorHandler(xmlExceptionHandler);
        Document doc = null;
        try {
            doc = db.parse(xmlDocumentInputStream);
        }
        catch (IOException ioex) {
            throw XMLParseException.exceptionReadingXMLDocument(documentName, ioex);
        }
        catch (SAXException saxex) {
            // empty catch block
        }
        XMLException xmlEx = xmlExceptionHandler.getXMLException();
        if (xmlEx != null) {
            throw ValidationException.invalidEntityMappingsDocument(documentName, xmlEx);
        }
        return doc;
    }

    public void setLoader(ClassLoader loader) {
        this.m_loader = loader;
    }
}

