/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.schema.DataSourceFactory;
import org.apache.openjpa.lib.conf.BooleanValue;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.StringListValue;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.jdbc.DecoratingDataSource;
import org.apache.openjpa.lib.jdbc.DelegatingDataSource;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.lib.log.LogFactoryImpl;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.slice.DistributedBrokerImpl;
import org.apache.openjpa.slice.DistributionPolicy;
import org.apache.openjpa.slice.ExecutorServiceValue;
import org.apache.openjpa.slice.Slice;
import org.apache.openjpa.slice.jdbc.DistributedDataSource;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfiguration;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedJDBCConfigurationImpl
extends JDBCConfigurationImpl
implements DistributedJDBCConfiguration {
    private final List<Slice> _slices = new ArrayList<Slice>();
    private List<String> _activeSliceNames = new ArrayList<String>();
    private Slice _master;
    private DecoratingDataSource virtualDataSource;
    protected BooleanValue lenientPlugin;
    protected StringValue masterPlugin;
    protected StringListValue namesPlugin;
    protected ExecutorServiceValue executorServicePlugin;
    protected PluginValue distributionPolicyPlugin;
    public static final String DOT = ".";
    public static final String REGEX_DOT = "\\.";
    public static final String PREFIX_SLICE = "openjpa.slice.";
    public static final String PREFIX_OPENJPA = "openjpa.";
    private static Localizer _loc = Localizer.forPackage(DistributedJDBCConfigurationImpl.class);

    public DistributedJDBCConfigurationImpl(ConfigurationProvider cp) {
        super(true, false);
        Map p = cp.getProperties();
        String pUnit = this.getPersistenceUnitName(p);
        this.setDiagnosticContext(pUnit);
        this.brokerPlugin.setString(DistributedBrokerImpl.class.getName());
        this.distributionPolicyPlugin = this.addPlugin("DistributionPolicy", true);
        this.distributionPolicyPlugin.setDynamic(true);
        this.lenientPlugin = this.addBoolean("Lenient");
        this.masterPlugin = this.addString("Master");
        this.namesPlugin = this.addStringList("Names");
        this.executorServicePlugin = new ExecutorServiceValue();
        this.addValue(this.executorServicePlugin);
        this.setSlices(p);
    }

    private String getPersistenceUnitName(Map p) {
        Object unit = p.get(PREFIX_OPENJPA + this.id.getProperty());
        return unit == null ? "?" : unit.toString();
    }

    private void setDiagnosticContext(String unit) {
        LogFactory logFactory = this.getLogFactory();
        if (logFactory instanceof LogFactoryImpl) {
            ((LogFactoryImpl)logFactory).setDiagnosticContext(unit);
        }
    }

    @Override
    public List<String> getActiveSliceNames() {
        if (this._activeSliceNames.isEmpty()) {
            for (Slice slice : this._slices) {
                if (!slice.isActive()) continue;
                this._activeSliceNames.add(slice.getName());
            }
        }
        return this._activeSliceNames;
    }

    @Override
    public List<String> getAvailableSliceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Slice slice : this._slices) {
            result.add(slice.getName());
        }
        return result;
    }

    @Override
    public List<Slice> getSlices(Slice.Status ... statuses) {
        if (statuses == null) {
            return Collections.unmodifiableList(this._slices);
        }
        ArrayList<Slice> result = new ArrayList<Slice>();
        for (Slice slice : this._slices) {
            for (Slice.Status status : statuses) {
                if (!slice.getStatus().equals((Object)status)) continue;
                result.add(slice);
            }
        }
        return result;
    }

    @Override
    public Slice getMaster() {
        return this._master;
    }

    @Override
    public Slice getSlice(String name) {
        for (Slice slice : this._slices) {
            if (!slice.getName().equals(name)) continue;
            return slice;
        }
        throw new UserException(_loc.get("slice-not-found", name, this.getActiveSliceNames()));
    }

    @Override
    public DistributionPolicy getDistributionPolicyInstance() {
        if (this.distributionPolicyPlugin.get() == null) {
            this.distributionPolicyPlugin.instantiate(DistributionPolicy.class, this, true);
        }
        return (DistributionPolicy)this.distributionPolicyPlugin.get();
    }

    public void setDistributionPolicyInstance(String val) {
        this.distributionPolicyPlugin.set(val);
    }

    @Override
    public Object getConnectionFactory() {
        if (this.virtualDataSource == null) {
            DistributedDataSource ds = this.createDistributedDataStore();
            this.virtualDataSource = DataSourceFactory.installDBDictionary(this.getDBDictionaryInstance(), ds, this, false);
        }
        return this.virtualDataSource;
    }

    private DistributedDataSource createDistributedDataStore() {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        boolean isLenient = this.lenientPlugin.get();
        boolean isXA = true;
        for (Slice slice : this._slices) {
            JDBCConfiguration conf = (JDBCConfiguration)slice.getConfiguration();
            Log log = conf.getConfigurationLog();
            String url = this.getConnectionInfo(conf);
            if (log.isInfoEnabled()) {
                log.info(_loc.get("slice-connect", slice, url));
            }
            try {
                DataSource ds = DataSourceFactory.newDataSource(conf, false);
                DecoratingDataSource dds = new DecoratingDataSource(ds);
                ds = DataSourceFactory.installDBDictionary(conf.getDBDictionaryInstance(), dds, conf, false);
                if (!this.verifyDataSource(slice, ds)) continue;
                dataSources.add(ds);
                isXA &= this.isXACompliant(ds);
            }
            catch (Throwable ex) {
                this.handleBadConnection(isLenient, slice, ex);
            }
        }
        if (dataSources.isEmpty()) {
            throw new UserException(_loc.get("no-slice"));
        }
        DistributedDataSource result = new DistributedDataSource(dataSources);
        return result;
    }

    String getConnectionInfo(OpenJPAConfiguration conf) {
        String result = conf.getConnectionURL();
        if (result == null) {
            result = conf.getConnectionDriverName();
            String props = conf.getConnectionProperties();
            if (props != null) {
                result = result + "(" + props + ")";
            }
        }
        return result;
    }

    boolean isXACompliant(DataSource ds) {
        if (ds instanceof DelegatingDataSource) {
            return ((DelegatingDataSource)ds).getInnermostDelegate() instanceof XADataSource;
        }
        return ds instanceof XADataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyDataSource(Slice slice, DataSource ds) {
        Connection con = null;
        try {
            con = ds.getConnection();
            slice.setStatus(Slice.Status.ACTIVE);
            if (con == null) {
                slice.setStatus(Slice.Status.INACTIVE);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            slice.setStatus(Slice.Status.INACTIVE);
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    private void handleBadConnection(boolean isLenient, Slice slice, Throwable ex) {
        OpenJPAConfiguration conf = slice.getConfiguration();
        String url = conf.getConnectionURL();
        Log log = this.getLog("openjpa.Runtime");
        if (isLenient) {
            if (ex != null) {
                log.warn(_loc.get("slice-connect-known-warn", slice, url, ex.getCause()));
            } else {
                log.warn(_loc.get("slice-connect-warn", slice, url));
            }
        } else {
            if (ex != null) {
                throw new UserException(_loc.get("slice-connect-known-error", slice, url, ex), ex.getCause());
            }
            throw new UserException(_loc.get("slice-connect-error", slice, url));
        }
    }

    void setSlices(Map original) {
        List<String> sliceNames = this.findSlices(original);
        Log log = this.getConfigurationLog();
        if (sliceNames.isEmpty()) {
            throw new UserException(_loc.get("slice-none-configured"));
        }
        String unit = this.getPersistenceUnitName(original);
        for (String key : sliceNames) {
            JDBCConfigurationImpl child = new JDBCConfigurationImpl();
            child.fromProperties(this.createSliceProperties(original, key));
            child.setId(unit + DOT + key);
            Slice slice = new Slice(key, child);
            this._slices.add(slice);
            if (!log.isTraceEnabled()) continue;
            log.trace(_loc.get("slice-configuration", key, child.toProperties(false)));
        }
        this.setMaster(original);
    }

    private List<String> findSlices(Map p) {
        ArrayList<String> sliceNames = new ArrayList();
        Log log = this.getConfigurationLog();
        String key = PREFIX_SLICE + this.namesPlugin.getProperty();
        boolean explicit = p.containsKey(key);
        if (explicit) {
            String[] values;
            for (String name : values = p.get(key).toString().split("\\,")) {
                if (sliceNames.contains(name.trim())) continue;
                sliceNames.add(name.trim());
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn(_loc.get("no-slice-names", key));
            }
            sliceNames = this.scanForSliceNames(p);
            Collections.sort(sliceNames);
        }
        if (log.isInfoEnabled()) {
            log.info(_loc.get("slice-available", sliceNames));
        }
        return sliceNames;
    }

    private List<String> scanForSliceNames(Map p) {
        ArrayList<String> sliceNames = new ArrayList<String>();
        for (Object o : p.keySet()) {
            String sliceName;
            String key = o.toString();
            if (!key.startsWith(PREFIX_SLICE) || DistributedJDBCConfigurationImpl.getPartCount(key) <= 3 || sliceNames.contains(sliceName = DistributedJDBCConfigurationImpl.chopTail(DistributedJDBCConfigurationImpl.chopHead(o.toString(), PREFIX_SLICE), DOT))) continue;
            sliceNames.add(sliceName);
        }
        return sliceNames;
    }

    private static int getPartCount(String s) {
        return s == null ? 0 : s.split(REGEX_DOT).length;
    }

    private static String chopHead(String s, String head) {
        if (s.startsWith(head)) {
            return s.substring(head.length());
        }
        return s;
    }

    private static String chopTail(String s, String tail) {
        int i = s.lastIndexOf(tail);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    Map createSliceProperties(Map original, String slice) {
        Properties result = new Properties();
        String prefix = PREFIX_SLICE + slice + DOT;
        for (Object o : original.keySet()) {
            String newKey;
            String key = o.toString();
            if (key.startsWith(prefix)) {
                newKey = PREFIX_OPENJPA + key.substring(prefix.length());
                result.put(newKey, original.get(o));
                continue;
            }
            if (key.startsWith(PREFIX_SLICE)) continue;
            if (key.startsWith(PREFIX_OPENJPA)) {
                newKey = prefix + key.substring(PREFIX_OPENJPA.length());
                if (original.containsKey(newKey)) continue;
                result.put(key, original.get(o));
                continue;
            }
            result.put(key, original.get(o));
        }
        return result;
    }

    private void setMaster(Map original) {
        String key = PREFIX_SLICE + this.masterPlugin.getProperty();
        Object masterSlice = original.get(key);
        Log log = this.getConfigurationLog();
        List<Slice> activeSlices = this.getSlices(null);
        if (masterSlice == null) {
            this._master = activeSlices.get(0);
            if (log.isWarnEnabled()) {
                log.warn(_loc.get("no-master-slice", key, this._master));
            }
            return;
        }
        for (Slice slice : activeSlices) {
            if (!slice.getName().equals(masterSlice)) continue;
            this._master = slice;
        }
        if (this._master == null) {
            this._master = activeSlices.get(0);
        }
    }

    @Override
    public String getExecutorService() {
        return this.executorServicePlugin.getString();
    }

    public void setExecutorService(ExecutorService txnManager) {
        this.executorServicePlugin.set(txnManager);
    }

    @Override
    public ExecutorService getExecutorServiceInstance() {
        if (this.executorServicePlugin.get() == null) {
            this.executorServicePlugin.instantiate(ExecutorService.class, this);
        }
        return (ExecutorService)this.executorServicePlugin.get();
    }
}

