/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.pool.GenerationObject;
import org.enhydra.jdbc.pool.StandardPoolDataSource;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXADataSource;

public class StandardXAPoolDataSource
extends StandardPoolDataSource {
    public XADataSource xads;
    public TransactionManager transactionManager;
    public Log glog = LogFactory.getLog((String)"org.enhydra.jdbc.xapool");

    public StandardXAPoolDataSource() {
    }

    public StandardXAPoolDataSource(int initSize) {
        super(initSize);
    }

    public StandardXAPoolDataSource(StandardXADataSource ds) {
        super(ds);
        this.setDataSource(ds);
    }

    public StandardXAPoolDataSource(StandardXADataSource ds, int initSize) {
        super(ds, initSize);
        this.setDataSource(ds);
    }

    public void setTransactionManager(TransactionManager tm) {
        this.log.debug("StandardXAPoolDataSource:setTransactionManager");
        this.transactionManager = tm;
    }

    public void connectionClosed(ConnectionEvent event) {
        Object obj = event.getSource();
        this.log.debug("StandardXAPoolDataSource:connectionClosed");
        XAConnection xac = (XAConnection)obj;
        Transaction tx = null;
        try {
            if (this.transactionManager == null) {
                TransactionManager tm = ((StandardXADataSource)this.xads).getTransactionManager();
                if (tm == null) {
                    throw new NullPointerException("TM is null");
                }
                tx = tm.getTransaction();
            } else {
                tx = this.transactionManager.getTransaction();
            }
            this.log.debug("StandardXAPoolDataSource:connectionClosed get a transaction");
        }
        catch (NullPointerException n) {
            this.log.error("StandardXAPoolDataSource:connectionClosed should not be used outside an EJBServer");
        }
        catch (SystemException e) {
            this.log.error("StandardXAPoolDataSource:connectionClosed getTransaction failed:" + (Object)((Object)e));
        }
        if (tx != null && ((StandardXAConnection)xac).connectionHandle.isReallyUsed) {
            try {
                tx.delistResource(xac.getXAResource(), 0x4000000);
                this.log.debug("StandardXAPoolDataSource:connectionClosed the resourse is delisted");
            }
            catch (Exception e) {
                this.log.error("StandardXAPoolDataSource:connectionClosed Exception in connectionClosed:" + e);
            }
        }
        this.log.debug("StandardXAPoolDataSource:connectionClosed checkIn an object to the pool");
        this.pool.checkIn(obj);
    }

    public GenerationObject create(String _user, String _password) throws SQLException {
        XAConnection xaCon = this.xads.getXAConnection(_user, _password);
        xaCon.addConnectionEventListener(this);
        this.log.debug("StandardXAPoolDataSource:create create a object for the pool");
        GenerationObject genObject = new GenerationObject(xaCon, this.pool.getGeneration(), _user, _password);
        return genObject;
    }

    public Reference getReference() throws NamingException {
        this.log.debug("StandardXAPoolDataSource:getReference return a reference of the object");
        Reference ref = super.getReference();
        ref.add(new StringRefAddr("transactionManagerName", "TransactionManager"));
        return ref;
    }

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        super.getObjectInstance(refObj, name, nameCtx, env);
        Reference ref = (Reference)refObj;
        InitialContext ictx = new InitialContext(env);
        this.setTransactionManager((TransactionManager)ictx.lookup("javax.transaction.TransactionManager"));
        this.setDataSource((XADataSource)ictx.lookup(this.dataSourceName));
        this.log.debug("StandardPoolDataSource:getObjectInstance: instance created");
        return this;
    }

    public XADataSource getDataSource() {
        return this.xads;
    }

    public void setDataSource(XADataSource dataSource) {
        this.xads = dataSource;
        if (this.transactionManager != null) {
            ((StandardXADataSource)dataSource).setTransactionManager(this.transactionManager);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardXAPoolDataSource:\n");
        if (this.transactionManager != null) {
            sb.append("     transaction manager=<" + this.transactionManager.toString() + ">\n");
        }
        if (this.xads != null) {
            sb.append(this.xads.toString());
        }
        sb.append(super.toString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testThisObject(Object o) {
        boolean bl2;
        Connection ret = null;
        this.log.debug("StandardPoolDataSource:testThisObject verify the current object");
        Transaction suspended = null;
        try {
            try {
                boolean isActive;
                Transaction tx;
                Transaction transaction = tx = this.transactionManager == null ? null : this.transactionManager.getTransaction();
                boolean bl = tx == null ? false : (isActive = tx.getStatus() == 0);
                if (isActive) {
                    suspended = this.transactionManager.suspend();
                }
                PooledConnection con = (PooledConnection)o;
                ret = con.getConnection();
                Statement s = ret.createStatement();
                s.execute(this.jdbcTestStmt);
                s.close();
                try {
                    ret.close();
                }
                catch (Exception e) {
                    this.log.error("StandardPoolDataSource:checkThisObject can't closed the connection: " + e);
                }
                bl2 = true;
                Object var10_14 = null;
                if (suspended == null) return bl2;
            }
            catch (SQLException e) {
                this.log.error("StandardXAPoolDataSource:checkThisObject Error java.sql.SQLException in StandardXAPoolDataSource:testThisObject");
                boolean bl3 = false;
                Object var10_15 = null;
                if (suspended == null) return bl3;
                try {
                    this.transactionManager.resume(suspended);
                    return bl3;
                }
                catch (Exception ex) {
                    this.log.error("StandardXAPoolDataSource:checkThisObject Error Exception in StandardXAPoolDataSource:testThisObject");
                    return false;
                }
            }
            catch (SystemException e) {
                this.log.error("StandardXAPoolDataSource:checkThisObject Error java.sql.SystemException in StandardXAPoolDataSource:testThisObject");
                boolean bl4 = false;
                Object var10_16 = null;
                if (suspended == null) return bl4;
                try {}
                catch (Exception ex) {
                    this.log.error("StandardXAPoolDataSource:checkThisObject Error Exception in StandardXAPoolDataSource:testThisObject");
                    return false;
                }
                this.transactionManager.resume(suspended);
                return bl4;
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (suspended == null) throw throwable;
            try {}
            catch (Exception ex) {
                this.log.error("StandardXAPoolDataSource:checkThisObject Error Exception in StandardXAPoolDataSource:testThisObject");
                return false;
            }
            this.transactionManager.resume(suspended);
            throw throwable;
        }
        try {}
        catch (Exception ex) {
            this.log.error("StandardXAPoolDataSource:checkThisObject Error Exception in StandardXAPoolDataSource:testThisObject");
            return false;
        }
        this.transactionManager.resume(suspended);
        return bl2;
    }
}

