/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParser;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBQueryImpl
implements JpaQuery {
    protected DatabaseQuery databaseQuery = null;
    protected EntityManagerImpl entityManager = null;
    protected String queryName = null;
    protected Map parameters = new HashMap();
    protected int firstResultIndex = -1;
    protected int maxResults = -1;
    protected int maxRows = -1;

    protected EJBQueryImpl(EntityManagerImpl entityManager) {
        this.entityManager = entityManager;
    }

    public EJBQueryImpl(DatabaseQuery query, EntityManagerImpl entityManager) {
        this(entityManager);
        this.databaseQuery = query;
    }

    public EJBQueryImpl(String ejbql, EntityManagerImpl entityManager) {
        this(ejbql, entityManager, false);
    }

    public EJBQueryImpl(String queryDescription, EntityManagerImpl entityManager, boolean isNamedQuery) {
        this(entityManager);
        if (isNamedQuery) {
            this.queryName = queryDescription;
        } else if (this.databaseQuery == null) {
            this.databaseQuery = EJBQueryImpl.buildEJBQLDatabaseQuery(queryDescription, this.getActiveSession());
        }
    }

    protected void setAsSQLModifyQuery() {
        if (this.getDatabaseQuery().isDataReadQuery()) {
            DataModifyQuery query = new DataModifyQuery();
            query.setSQLString(this.databaseQuery.getSQLString());
            query.setIsUserDefined(this.databaseQuery.isUserDefined());
            query.setFlushOnExecute(this.databaseQuery.getFlushOnExecute());
            this.databaseQuery = query;
        }
    }

    protected void setAsSQLReadQuery() {
        if (this.getDatabaseQuery().isDataModifyQuery()) {
            DataReadQuery query = new DataReadQuery();
            query.setUseAbstractRecord(false);
            query.setSQLString(this.databaseQuery.getSQLString());
            query.setIsUserDefined(this.databaseQuery.isUserDefined());
            query.setFlushOnExecute(this.databaseQuery.getFlushOnExecute());
            this.databaseQuery = query;
        }
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Session session) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(ejbql, null, session);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Session session, HashMap hints) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, ejbql, null, session, hints, null);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Session session, HashMap hints, ClassLoader classLoader) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, ejbql, null, session, hints, classLoader);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Boolean flushOnExecute, Session session) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, ejbql, flushOnExecute, session, null, null);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Boolean flushOnExecute, Session session, ClassLoader classLoader) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, ejbql, flushOnExecute, session, null, classLoader);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String queryName, String jpql, Boolean flushOnExecute, Session session, HashMap hints, ClassLoader classLoader) {
        boolean isCacheable = queryName == null && hints == null && flushOnExecute == null;
        DatabaseQuery databaseQuery = null;
        if (isCacheable) {
            databaseQuery = (DatabaseQuery)session.getProject().getJPQLParseCache().get(jpql);
        }
        if (databaseQuery == null || !databaseQuery.isPrepared()) {
            ReadAllQuery readAllQuery;
            JPQLParseTree parseTree = JPQLParser.buildParseTree(queryName, jpql);
            parseTree.setClassLoader(classLoader);
            databaseQuery = parseTree.createDatabaseQuery();
            databaseQuery.setJPQLString(jpql);
            parseTree.populateQuery(databaseQuery, (AbstractSession)session);
            if (databaseQuery.isReadAllQuery() && (readAllQuery = (ReadAllQuery)databaseQuery).hasJoining() && readAllQuery.getDistinctState() == 2) {
                readAllQuery.setShouldFilterDuplicates(false);
            }
            parseTree.addParametersToQuery(databaseQuery);
            ((JPQLCallQueryMechanism)databaseQuery.getQueryMechanism()).getJPQLCall().setIsParsed(true);
            databaseQuery.setFlushOnExecute(flushOnExecute);
            if (databaseQuery.isReadQuery()) {
                databaseQuery.cascadeByMapping();
            }
            databaseQuery = EJBQueryImpl.applyHints(hints, databaseQuery);
            if (isCacheable) {
                databaseQuery.prepareCall(session, new DatabaseRecord());
                databaseQuery.setIsFromParseCache(true);
                session.getProject().getJPQLParseCache().put(jpql, databaseQuery);
            }
        }
        return databaseQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class resultClass, String sqlString) {
        return EJBQueryImpl.buildSQLDatabaseQuery(resultClass, sqlString, null);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class resultClass, String sqlString, HashMap hints) {
        ReadAllQuery query = new ReadAllQuery(resultClass);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, query);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlResultSetMappingName, sqlString, null);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString, HashMap hints) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, query);
    }

    public static DatabaseQuery buildStoredProcedureQuery(Class resultClass, StoredProcedureCall call, List<String> arguments, HashMap hints) {
        DatabaseQuery query = new ReadAllQuery(resultClass);
        query.setCall(call);
        query.setIsUserDefined(true);
        query = EJBQueryImpl.applyHints(hints, query);
        EJBQueryImpl.applyArguments(arguments, query);
        return query;
    }

    public static DatabaseQuery buildStoredProcedureQuery(StoredProcedureCall call, List<String> arguments, HashMap hints) {
        DatabaseQuery query = new ResultSetMappingQuery();
        query.setCall(call);
        query.setIsUserDefined(true);
        query = EJBQueryImpl.applyHints(hints, query);
        EJBQueryImpl.applyArguments(arguments, query);
        return query;
    }

    public static DatabaseQuery buildStoredProcedureQuery(String sqlResultSetMappingName, StoredProcedureCall call, List<String> arguments, HashMap hints) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setCall(call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = EJBQueryImpl.applyHints(hints, query);
        EJBQueryImpl.applyArguments(arguments, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, Boolean flushOnExecute) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlString, new HashMap());
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, HashMap hints) {
        DataReadQuery query = new DataReadQuery();
        query.setUseAbstractRecord(false);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeReadQuery() {
        Vector parameterValues = this.processParameters();
        boolean shouldResetConformResultsInUnitOfWork = false;
        if (this.isFlushModeAUTO()) {
            this.performPreQueryFlush();
            if (this.getDatabaseQuery().isObjectLevelReadQuery() && ((ObjectLevelReadQuery)this.getDatabaseQuery()).shouldConformResultsInUnitOfWork()) {
                this.cloneIfParseCachedQuery();
                ((ObjectLevelReadQuery)this.getDatabaseQuery()).setCacheUsage(-1);
                shouldResetConformResultsInUnitOfWork = true;
            }
        }
        try {
            if (this.getDatabaseQuery().isUserDefined() && this.entityManager.checkForTransaction(false) != null && !((UnitOfWorkImpl)this.getActiveSession()).wasTransactionBegunPrematurely()) {
                ((UnitOfWorkImpl)this.getActiveSession()).beginEarlyTransaction();
            }
            Object object = this.getActiveSession().executeQuery(this.getDatabaseQuery(), (List)parameterValues);
            return object;
        }
        finally {
            if (shouldResetConformResultsInUnitOfWork) {
                ((ObjectLevelReadQuery)this.getDatabaseQuery()).conformResultsInUnitOfWork();
            }
        }
    }

    public int executeUpdate() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLModifyQuery();
            if (!(this.getDatabaseQuery() instanceof ModifyQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_execute_update"));
            }
            this.entityManager.checkForTransaction(true);
            Vector parameterValues = this.processParameters();
            if (this.isFlushModeAUTO()) {
                this.performPreQueryFlush();
            }
            Integer changedRows = (Integer)this.getActiveSession().executeQuery(this.databaseQuery, (List)parameterValues);
            return changedRows;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public DatabaseQuery getDatabaseQuery() {
        if (this.queryName != null && this.databaseQuery == null) {
            this.databaseQuery = this.getActiveSession().getQuery(this.queryName);
            if (this.databaseQuery != null) {
                if (!this.databaseQuery.isPrepared()) {
                    this.databaseQuery.prepareCall(this.getActiveSession(), new DatabaseRecord());
                }
                this.databaseQuery = (DatabaseQuery)this.databaseQuery.clone();
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unable_to_find_named_query", new Object[]{this.queryName}));
            }
        }
        return this.databaseQuery;
    }

    @Override
    public JpaEntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public Collection getResultCollection() {
        this.entityManager.verifyOpen();
        this.setAsSQLReadQuery();
        this.propagateResultProperties();
        if (this.getDatabaseQuery() instanceof ReadAllQuery) {
            Class containerClass = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
            if (!Helper.classImplementsInterface(containerClass, ClassConstants.Collection_Class)) {
                throw QueryException.invalidContainerClass(containerClass, ClassConstants.Collection_Class);
            }
        } else {
            if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
            }
            if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_collection"));
            }
        }
        Object result = this.executeReadQuery();
        return (Collection)result;
    }

    public List getResultList() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (this.getDatabaseQuery() instanceof ReadAllQuery) {
                Class containerClass = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
                if (!Helper.classImplementsInterface(containerClass, ClassConstants.List_Class)) {
                    throw QueryException.invalidContainerClass(containerClass, ClassConstants.List_Class);
                }
            } else {
                if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                    throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
                }
                if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_list"));
                }
            }
            Object result = this.executeReadQuery();
            return (List)result;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object getSingleResult() {
        boolean rollbackOnException = true;
        try {
            Object result;
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (this.getDatabaseQuery() instanceof ReadAllQuery) {
                Class containerClass = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
                if (!Helper.classImplementsInterface(containerClass, ClassConstants.List_Class)) {
                    throw QueryException.invalidContainerClass(containerClass, ClassConstants.List_Class);
                }
            } else if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_single_result"));
            }
            if ((result = this.executeReadQuery()) instanceof List) {
                List results = (List)result;
                if (results.isEmpty()) {
                    rollbackOnException = false;
                    this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
                } else if (results.size() > 1) {
                    rollbackOnException = false;
                    this.throwNonUniqueResultException(ExceptionLocalization.buildMessage("too_many_results_for_get_single_result", null));
                }
                return results.get(0);
            }
            if (result == null) {
                rollbackOnException = false;
                this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
            }
            return result;
        }
        catch (RuntimeException e) {
            if (rollbackOnException) {
                this.setRollbackOnly();
            }
            throw e;
        }
    }

    protected Vector processParameters() {
        Vector arguments;
        if (this.databaseQuery == null) {
            this.getDatabaseQuery();
        }
        if ((arguments = this.databaseQuery.getArguments()).isEmpty()) {
            Iterator params = this.parameters.keySet().iterator();
            while (params.hasNext()) {
                this.databaseQuery.addArgument((String)params.next());
            }
            arguments = this.databaseQuery.getArguments();
        }
        Vector parameterValues = new Vector(arguments.size());
        for (String name : arguments) {
            if (this.parameters.containsKey(name)) {
                parameterValues.add(this.parameters.get(name));
                continue;
            }
            throw new IllegalStateException(ExceptionLocalization.buildMessage("missing_parameter_value", new Object[]{name}));
        }
        return parameterValues;
    }

    @Override
    public void setDatabaseQuery(DatabaseQuery query) {
        this.databaseQuery = query;
    }

    public Query setFirstResult(int startPosition) {
        try {
            this.entityManager.verifyOpen();
            this.setFirstResultInternal(startPosition);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setFirstResultInternal(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_start_position", null));
        }
        this.firstResultIndex = startPosition;
    }

    public Query setFlushMode(FlushModeType flushMode) {
        try {
            this.entityManager.verifyOpen();
            if (flushMode == null) {
                this.getDatabaseQuery().setFlushOnExecute(null);
            } else {
                this.cloneIfParseCachedQuery();
                this.getDatabaseQuery().setFlushOnExecute(flushMode == FlushModeType.AUTO);
            }
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected static void applyArguments(List<String> arguments, DatabaseQuery query) {
        for (String argument : arguments) {
            query.addArgument(argument);
        }
    }

    protected static DatabaseQuery applyHints(HashMap hints, DatabaseQuery query) {
        return QueryHintsHandler.apply(hints, query);
    }

    protected boolean isFlushModeAUTO() {
        if (this.getDatabaseQuery().getFlushOnExecute() != null) {
            return this.getDatabaseQuery().getFlushOnExecute();
        }
        return this.entityManager.isFlushModeAUTO();
    }

    public Query setHint(String hintName, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setHintInternal(hintName, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setHintInternal(String hintName, Object value) {
        this.cloneIfParseCachedQuery();
        DatabaseQuery hintQuery = QueryHintsHandler.apply(hintName, value, this.getDatabaseQuery());
        if (hintQuery != null) {
            this.setDatabaseQuery(hintQuery);
        }
    }

    protected void cloneIfParseCachedQuery() {
        DatabaseQuery query = this.getDatabaseQuery();
        if (query.isFromParseCache()) {
            query = (DatabaseQuery)this.databaseQuery.clone();
            query.setIsFromParseCache(false);
            this.setDatabaseQuery(query);
        }
    }

    protected Object convertTemporalType(Object value, TemporalType type) {
        ConversionManager conversionManager = ((AbstractSession)this.getEntityManager().getActiveSession()).getDatasourcePlatform().getConversionManager();
        if (type == TemporalType.TIME) {
            return conversionManager.convertObject(value, ClassConstants.TIME);
        }
        if (type == TemporalType.TIMESTAMP) {
            return conversionManager.convertObject(value, ClassConstants.TIMESTAMP);
        }
        if (type == TemporalType.DATE) {
            return conversionManager.convertObject(value, ClassConstants.SQLDATE);
        }
        return value;
    }

    public Query setMaxResults(int maxResult) {
        try {
            this.entityManager.verifyOpen();
            this.setMaxResultsInternal(maxResult);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public void setMaxResultsInternal(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_max_result", null));
        }
        this.maxResults = maxResult;
    }

    public Query setParameter(String name, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(name, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query setParameter(String name, Date value, TemporalType temporalType) {
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    public Query setParameter(int position, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(position, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query setParameter(int position, Date value, TemporalType temporalType) {
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    protected void propagateResultProperties() {
        DatabaseQuery databaseQuery = this.getDatabaseQuery();
        if (databaseQuery.isReadQuery()) {
            ReadQuery readQuery = (ReadQuery)databaseQuery;
            if (this.maxResults >= 0) {
                this.cloneIfParseCachedQuery();
                readQuery = (ReadQuery)this.getDatabaseQuery();
                this.maxRows = this.maxResults + (this.firstResultIndex >= 0 ? this.firstResultIndex : 0);
                readQuery.setMaxRows(this.maxRows);
                this.maxResults = -1;
            }
            if (this.firstResultIndex > -1) {
                this.cloneIfParseCachedQuery();
                readQuery = (ReadQuery)this.getDatabaseQuery();
                readQuery.setFirstResult(this.firstResultIndex);
                this.firstResultIndex = -1;
            }
        }
    }

    protected void setParameterInternal(String name, Object value) {
        int index = this.getDatabaseQuery().getArguments().indexOf(name);
        if (this.getDatabaseQuery().getEJBQLString() != null) {
            if (index == -1) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-name", new Object[]{name, this.getDatabaseQuery().getEJBQLString()}));
            }
            if (!this.isValidActualParameter(value, this.getDatabaseQuery().getArgumentTypes().get(index))) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-incorrect-parameter-type", new Object[]{name, value.getClass(), this.getDatabaseQuery().getArgumentTypes().get(index), this.getDatabaseQuery().getEJBQLString()}));
            }
        }
        this.parameters.put(name, value);
    }

    protected void setParameterInternal(int position, Object value) {
        String pos = new Integer(position).toString();
        int index = this.getDatabaseQuery().getArguments().indexOf(pos);
        if (this.getDatabaseQuery().getEJBQLString() != null) {
            if (index == -1) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-index", new Object[]{position, this.getDatabaseQuery().getEJBQLString()}));
            }
            if (!this.isValidActualParameter(value, this.getDatabaseQuery().getArgumentTypes().get(index))) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-incorrect-parameter-type", new Object[]{position, value.getClass(), this.getDatabaseQuery().getArgumentTypes().get(index), this.getDatabaseQuery().getEJBQLString()}));
            }
        }
        this.parameters.put(pos, value);
    }

    protected boolean isValidActualParameter(Object value, Object parameterType) {
        if (value == null) {
            return true;
        }
        return BasicTypeHelperImpl.getInstance().isAssignableFrom(parameterType, value.getClass());
    }

    protected Session getActiveSession() {
        return this.entityManager.getActiveSession();
    }

    protected void performPreQueryFlush() {
        if (this.entityManager.shouldFlushBeforeQuery()) {
            this.entityManager.flush();
        }
    }

    protected void setRollbackOnly() {
        this.entityManager.setRollbackOnly();
    }

    protected void throwNoResultException(String message) {
        throw new NoResultException(message);
    }

    protected void throwNonUniqueResultException(String message) {
        throw new NonUniqueResultException(message);
    }
}

