/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

public class OneToManyAccessor
extends CollectionAccessor {
    public OneToManyAccessor() {
        super("<one-to-many>");
    }

    public OneToManyAccessor(Annotation oneToMany, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(oneToMany, accessibleObject, classAccessor);
    }

    protected String getLoggingContext() {
        return "metadata_default_one_to_many_reference_class";
    }

    public boolean isOneToMany() {
        return true;
    }

    public void process() {
        super.process();
        if (this.getMappedBy() == null || this.getMappedBy().equals("")) {
            if (this.isAnnotationPresent(JoinColumn.class) || this.isAnnotationPresent(JoinColumns.class)) {
                throw ValidationException.uniDirectionalOneToManyHasJoinColumnAnnotations(this.getAttributeName(), this.getJavaClass());
            }
            ManyToManyMapping mapping = new ManyToManyMapping();
            this.process(mapping);
            this.processJoinTable(mapping);
            this.processProperties(mapping);
            this.getDescriptor().addMapping(mapping);
        } else {
            OneToManyMapping mapping = new OneToManyMapping();
            this.process(mapping);
            OneToOneMapping ownerMapping = null;
            if (!this.getOwningMapping(this.getMappedBy()).isOneToOneMapping()) {
                throw ValidationException.invalidMapping(this.getJavaClass(), this.getReferenceClass());
            }
            ownerMapping = (OneToOneMapping)this.getOwningMapping(this.getMappedBy());
            Map<DatabaseField, DatabaseField> keys = ownerMapping.getSourceToTargetKeyFields();
            for (DatabaseField fkField : keys.keySet()) {
                mapping.addTargetForeignKeyField(fkField, keys.get(fkField));
            }
            this.processProperties(mapping);
            this.getDescriptor().addMapping(mapping);
        }
    }
}

