/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.ValueReadQuery;

public class DataReadQuery
extends ReadQuery {
    protected ContainerPolicy containerPolicy;
    protected boolean useAbstractRecord = true;

    public DataReadQuery() {
        this.shouldMaintainCache = false;
        this.useAbstractRecord = true;
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class));
    }

    public DataReadQuery(String sqlString) {
        this();
        this.setSQLString(sqlString);
    }

    public DataReadQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void cacheResult(Object results) {
        this.setTemporaryCachedQueryResults(results);
    }

    public Object clone() {
        DataReadQuery cloneQuery = (DataReadQuery)super.clone();
        cloneQuery.setContainerPolicy(this.getContainerPolicy().clone(cloneQuery));
        return cloneQuery;
    }

    public Object execute(AbstractSession session, AbstractRecord row) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            if (this.getContainerPolicy().overridesRead()) {
                throw QueryException.cannotCacheCursorResultsOnQuery(this);
            }
            if (this.isPrepared()) {
                Object results = this.getQueryResults(session, row, true);
                if (results == InvalidObject.instance) {
                    return null;
                }
                if (results != null) {
                    return results;
                }
            }
        }
        return super.execute(session, row);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        return this.executeNonCursor();
    }

    protected Object executeNonCursor() throws DatabaseException {
        Vector rows = this.getQueryMechanism().executeSelect();
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object results = null;
        if (this.useAbstractRecord) {
            results = containerPolicy.buildContainerFromVector(rows, this.getSession());
        } else {
            results = containerPolicy.containerInstance(rows.size());
            Iterator rowsEnum = rows.iterator();
            while (rowsEnum.hasNext()) {
                containerPolicy.addInto((Object)((AbstractRecord)rowsEnum.next()).getValues(), results, this.getSession());
            }
        }
        this.cacheResult(results);
        return results;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public boolean isDataReadQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getContainerPolicy().prepare(this, this.getSession());
        if (this.getContainerPolicy().overridesRead()) {
            return;
        }
        this.getQueryMechanism().prepareExecuteSelect();
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        this.getContainerPolicy().prepareForExecution();
    }

    public Object remoteExecute() {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().remoteExecute();
        }
        return super.remoteExecute();
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        if (containerPolicy == null) {
            return;
        }
        this.containerPolicy = containerPolicy;
    }

    public void useCollectionClass(Class concreteClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteClass));
    }

    public void useCursoredStream() {
        this.useCursoredStream(10, 5);
    }

    public void setUseAbstractRecord(boolean useAbstractRecord) {
        this.useAbstractRecord = useAbstractRecord;
    }

    public void useCursoredStream(int initialReadSize, int pageSize) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, initialReadSize, pageSize));
    }

    public void useCursoredStream(int initialReadSize, int pageSize, ValueReadQuery sizeQuery) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, initialReadSize, pageSize, sizeQuery));
    }

    public void useScrollableCursor() {
        this.useScrollableCursor(10);
    }

    public void useScrollableCursor(int pageSize) {
        this.setContainerPolicy(new ScrollableCursorPolicy(this, pageSize));
    }

    public void useScrollableCursor(ScrollableCursorPolicy policy) {
        policy.setQuery(this);
        this.setContainerPolicy(policy);
    }
}

