/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.impl.ExternalizableDelegator;
import commonj.sdo.impl.HelperProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.persistence.sdo.SDODataObject;

public class SDOResolvable
implements ExternalizableDelegator.Resolvable {
    private static final long serialVersionUID = 2807334877368539299L;
    public static final String DEFAULT_ROOT_ELEMENT_NAME = "dataObject";
    public static final int SDO_ROOT_OBJECT_IDENTIFIER = 1;
    public static final int SDO_INTERNAL_OBJECT_IDENTIFIER = 0;
    private transient SDODataObject theSDODataObject;
    private transient HelperContext aHelperContext;

    public SDOResolvable() {
        this.aHelperContext = HelperProvider.getDefaultContext();
    }

    public SDOResolvable(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public SDOResolvable(Object target, HelperContext aContext) {
        this.theSDODataObject = (SDODataObject)target;
        this.aHelperContext = aContext;
    }

    public Object readResolve() throws ObjectStreamException {
        return this.theSDODataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        DeflaterOutputStream aGZIPOutputStream = null;
        ByteArrayOutputStream aByteOutputStream = null;
        if (this.theSDODataObject.getContainer() == null) {
            try {
                objectOutput.writeByte(1);
                aByteOutputStream = new ByteArrayOutputStream();
                aGZIPOutputStream = new GZIPOutputStream(aByteOutputStream);
                XMLDocument aDocument = this.aHelperContext.getXMLHelper().createDocument((DataObject)this.theSDODataObject, "commonj.sdo", "sdo:dataObject");
                this.aHelperContext.getXMLHelper().save(aDocument, (OutputStream)aGZIPOutputStream, null);
                ((GZIPOutputStream)aGZIPOutputStream).finish();
                aGZIPOutputStream.flush();
                aByteOutputStream.flush();
                byte[] buf = aByteOutputStream.toByteArray();
                objectOutput.writeInt(buf.length);
                objectOutput.write(buf);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (aGZIPOutputStream != null) {
                    aGZIPOutputStream.close();
                }
                if (aByteOutputStream != null) {
                    aByteOutputStream.close();
                }
            }
        } else {
            objectOutput.writeByte(0);
            String aPath = this.theSDODataObject._getPath();
            objectOutput.writeUTF(aPath);
            ((ObjectOutputStream)objectOutput).writeObject(this.theSDODataObject.getRootObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ByteArrayInputStream aByteInputStream = null;
        GZIPInputStream aGZIPInputStream = null;
        int dataObjectIdentifier = objectInput.read();
        switch (dataObjectIdentifier) {
            case 0: {
                String xPathString = objectInput.readUTF();
                SDODataObject deserializedDataObject = (SDODataObject)objectInput.readObject();
                this.theSDODataObject = (SDODataObject)deserializedDataObject.get(xPathString);
                break;
            }
            case 1: {
                try {
                    int aStreamLength = objectInput.readInt();
                    byte[] aGZIPByteArray = new byte[aStreamLength];
                    objectInput.readFully(aGZIPByteArray);
                    aByteInputStream = new ByteArrayInputStream(aGZIPByteArray);
                    aGZIPInputStream = new GZIPInputStream(aByteInputStream);
                    XMLDocument aDocument = this.aHelperContext.getXMLHelper().load((InputStream)aGZIPInputStream);
                    this.theSDODataObject = (SDODataObject)aDocument.getRootObject();
                    break;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    break;
                }
                finally {
                    if (aGZIPInputStream != null) {
                        aGZIPInputStream.close();
                    }
                    if (aByteInputStream != null) {
                        aByteInputStream.close();
                    }
                }
            }
        }
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

