/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.ArraySorter;
import com.jamonapi.utils.ToArray;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Misc {
    private static Format monthFormat = new SimpleDateFormat("MM");
    private static Format dayOfWeekFormat = new SimpleDateFormat("E");
    private static Format shortDateFormat = new SimpleDateFormat("MM/dd/yy");

    public static String getClassName(Object object) {
        String className = object == null ? "null" : object.getClass().getName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public static String getExceptionTrace(Throwable exception) {
        StackTraceElement[] elements = exception.getStackTrace();
        StringBuffer trace = new StringBuffer().append(exception).append("\n");
        for (int i = 0; i < elements.length; ++i) {
            trace.append(elements[i]).append("\n");
        }
        return trace.toString();
    }

    public static void addTo(Collection coll, Object objToAdd) {
        if (objToAdd instanceof Collection) {
            coll.addAll((Collection)objToAdd);
        } else if (objToAdd instanceof Object[]) {
            coll.addAll(Arrays.asList((Object[])objToAdd));
        } else if (objToAdd instanceof ToArray) {
            coll.addAll(Arrays.asList(((ToArray)objToAdd).toArray()));
        } else {
            coll.add(objToAdd);
        }
    }

    public static String getAsString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Collection) {
            return Misc.getCollAsString((Collection)obj);
        }
        if (obj instanceof Object[]) {
            return Misc.getArrAsString((Object[])obj);
        }
        if (obj instanceof ToArray) {
            return Misc.getArrAsString(((ToArray)obj).toArray());
        }
        if (obj instanceof Throwable) {
            return Misc.getExceptionTrace((Throwable)obj);
        }
        return obj.toString();
    }

    private static String getCollAsString(Collection coll) {
        int currentElement = 1;
        int lastElement = coll.size();
        Iterator iter = coll.iterator();
        StringBuffer buff = new StringBuffer();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Throwable) {
                obj = Misc.getExceptionTrace((Throwable)obj);
            }
            buff.append(obj);
            if (currentElement != lastElement) {
                buff.append(",\n");
            }
            ++currentElement;
        }
        return buff.toString();
    }

    private static String getArrAsString(Object[] arr) {
        int lastElement = arr.length - 1;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            Object obj = arr[i];
            if (obj instanceof Throwable) {
                obj = Misc.getExceptionTrace((Throwable)obj);
            }
            buff.append(obj);
            if (i == lastElement) continue;
            buff.append(",\n");
        }
        return buff.toString();
    }

    public static void isObjectString(Object arg) {
        if (!(arg instanceof String)) {
            throw new IllegalArgumentException("Illegal Argument exception: This object must be of type String.");
        }
    }

    public static Object[][] sort(Object[][] array, int sortCol, String sortOrder) {
        ArraySorter sorter = new ArraySorter(array, sortCol, sortOrder);
        return sorter.sort();
    }

    public static void disp(Object[][] data) {
        for (int i = 0; i < data.length; ++i) {
            System.out.println();
            System.out.print("row=" + i + ", data=");
            for (int j = 0; j < data[i].length; ++j) {
                System.out.print(data[i][j] + ",");
            }
        }
        System.out.println();
    }

    public static Object[][] allocateArray(int rows, int cols) {
        if (rows <= 0 || cols <= 0) {
            return null;
        }
        Object[][] data = new Object[rows][];
        for (int i = 0; i < cols; ++i) {
            data[i] = new Object[cols];
        }
        return data;
    }

    public static String getFormattedDateNow(String format) {
        return Misc.getFormattedDate(format, new Date());
    }

    public static String getFormattedDate(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String getMonth(Date date) {
        return monthFormat.format(date);
    }

    public static String getMonth() {
        return Misc.getMonth(new Date());
    }

    public static String getDayOfWeek(Date date) {
        return dayOfWeekFormat.format(date);
    }

    public static String getDayOfWeek() {
        return Misc.getDayOfWeek(new Date());
    }

    public static String getShortDate(Date date) {
        return shortDateFormat.format(date);
    }

    public static String getShortDate() {
        return Misc.getShortDate(new Date());
    }

    public static Map createCaseInsensitiveMap() {
        return new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    public static void main(String[] args) {
        Date date = new Date();
        System.out.println("month=" + Misc.getMonth(date));
        System.out.println("dayofweek=" + Misc.getDayOfWeek(date));
        System.out.println("shortdate=" + Misc.getShortDate(date));
        System.out.println("formatteddate=" + Misc.getFormattedDate("dd-MMM-yy", date));
        System.out.println("month=" + Misc.getMonth());
        System.out.println("dayofweek=" + Misc.getDayOfWeek());
        System.out.println("shortdate=" + Misc.getShortDate());
        SimpleDateFormat formatter = new SimpleDateFormat("yy");
        System.out.println("yy=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("yyyy");
        System.out.println("yyyy=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("M");
        System.out.println("M=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("MM");
        System.out.println("MM=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("MMM");
        System.out.println("MMM=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("MMMM");
        System.out.println("MMMM=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("d");
        System.out.println("d=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("dd");
        System.out.println("dd=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("E");
        System.out.println("E=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("EEEE");
        System.out.println("EEEE=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("MM/dd/yy");
        System.out.println("MM/dd/yy=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("dd-MMM-yy");
        System.out.println("dd-MMM-yy=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
        System.out.println("yyyy.MM.dd.HH.mm.ss=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
        System.out.println("E, dd MMM yyyy HH:mm:ss Z=" + formatter.format((Object)date));
        Map m = Misc.createCaseInsensitiveMap();
        m.put("Steve", "Souza");
        m.put("STEVE", "Souza");
        System.out.println("Should return 'Souza': " + m.get("StEvE"));
        System.out.println("Map=" + m);
    }
}

