/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import com.pholser.junit.quickcheck.generator.java.lang.StringGenerator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public final class RFC4122 {
    private RFC4122() {
        throw new UnsupportedOperationException();
    }

    public static enum Namespaces {
        DNS(16),
        URL(17),
        ISO_OID(18),
        X500_DN(20);

        final byte[] bytes;

        private Namespaces(int difference) {
            this.bytes = new byte[]{107, -89, -72, (byte)difference, -99, -83, 17, -47, -128, -76, 0, -64, 79, -44, 48, -56};
        }
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface Namespace {
        public Namespaces value() default Namespaces.URL;
    }

    public static class Version5
    extends NameBasedUUIDGenerator {
        public Version5() {
            super("SHA-1", 80);
        }

        public void configure(Namespace namespace) {
            this.setNamespace(namespace);
        }
    }

    public static class Version4
    extends AbstractUUIDGenerator {
        public UUID generate(SourceOfRandomness random, GenerationStatus status) {
            byte[] bytes = random.nextBytes(16);
            this.setVersion(bytes, (byte)64);
            this.setVariant(bytes);
            return this.newUUID(bytes);
        }
    }

    public static class Version3
    extends NameBasedUUIDGenerator {
        public Version3() {
            super("MD5", 48);
        }

        public void configure(Namespace namespace) {
            this.setNamespace(namespace);
        }
    }

    static final class MessageDigests {
        private MessageDigests() {
            throw new UnsupportedOperationException();
        }

        static MessageDigest get(String algorithmName) {
            try {
                return MessageDigest.getInstance(algorithmName);
            }
            catch (NoSuchAlgorithmException shouldNeverHappen) {
                throw new IllegalStateException(shouldNeverHappen);
            }
        }
    }

    private static abstract class NameBasedUUIDGenerator
    extends AbstractUUIDGenerator {
        private final StringGenerator stringGenerator = new StringGenerator();
        private final int versionMask;
        private final MessageDigest digest;
        private Namespace namespace;

        protected NameBasedUUIDGenerator(String hashAlgorithmName, int versionMask) {
            this.versionMask = versionMask;
            this.digest = MessageDigests.get(hashAlgorithmName);
        }

        public UUID generate(SourceOfRandomness random, GenerationStatus status) {
            this.digest.reset();
            this.digest.update((this.namespace == null ? Namespaces.URL : this.namespace.value()).bytes);
            this.digest.update(this.stringGenerator.generate(random, status).getBytes(Charset.forName("UTF-8")));
            byte[] hash = this.digest.digest();
            this.setVersion(hash, (byte)this.versionMask);
            this.setVariant(hash);
            return this.newUUID(hash);
        }

        protected void setNamespace(Namespace namespace) {
            this.namespace = namespace;
        }
    }

    private static abstract class AbstractUUIDGenerator
    extends Generator<UUID> {
        protected AbstractUUIDGenerator() {
            super(UUID.class);
        }

        protected final void setVersion(byte[] bytes, byte mask) {
            bytes[6] = (byte)(bytes[6] & 0xF);
            bytes[6] = (byte)(bytes[6] | mask);
        }

        protected final void setVariant(byte[] bytes) {
            bytes[8] = (byte)(bytes[8] & 0x3F);
            bytes[8] = (byte)(bytes[8] | 0x80);
        }

        protected final UUID newUUID(byte[] bytes) {
            ByteBuffer bytesIn = ByteBuffer.wrap(bytes);
            return new UUID(bytesIn.getLong(), bytesIn.getLong());
        }
    }
}

