/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.AnnotatedConstructorParameter;
import com.pholser.junit.quickcheck.internal.ParameterContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;

public class Ctor<T>
extends Generator<T> {
    public Ctor(Class<T> type) {
        super(type);
    }

    @Override
    public T generate(SourceOfRandomness random, GenerationStatus status) {
        Constructor single = Reflection.singleAccessibleConstructor(this.types().get(0));
        Object[] args = this.arguments(single.getGenericParameterTypes(), single.getParameterAnnotations(), random, status);
        return Reflection.instantiate(single, args);
    }

    @Override
    public boolean canRegisterAsType(Class<?> type) {
        return false;
    }

    private Object[] arguments(Type[] parameterTypes, Annotation[][] parameterAnnotations, SourceOfRandomness random, GenerationStatus status) {
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < args.length; ++i) {
            AnnotatedConstructorParameter ctorParameter = new AnnotatedConstructorParameter(parameterAnnotations[i]);
            ParameterContext parameter = new ParameterContext(parameterTypes[i]).annotate(ctorParameter);
            args[i] = this.generatorFor(parameter).generate(random, status);
        }
        return args;
    }
}

