#include "Location_dict.h"

AFun LOC_afun4;
AFun LOC_afun0;
AFun LOC_afun2;
AFun LOC_afun3;
AFun LOC_afun1;

ATerm LOC_patternAreaAreasMany = NULL;
ATerm LOC_patternAreaAreasSingle = NULL;
ATerm LOC_patternAreaAreasEmpty = NULL;
ATerm LOC_patternSliceSlice = NULL;
ATerm LOC_patternAreaArea = NULL;
ATerm LOC_patternLocationAreaInFile = NULL;
ATerm LOC_patternLocationArea = NULL;
ATerm LOC_patternLocationFile = NULL;
ATerm LOC_patternNatConNatCon = NULL;
ATerm LOC_patternStrConStrCon = NULL;
ATerm LOC_patternStrCharStrChar = NULL;

/*
 * LOC_afun4 = slice(x,x)
 * LOC_afun0 = file(x)
 * LOC_afun2 = area-in-file(x,x)
 * LOC_afun3 = area(x,x,x,x,x,x)
 * LOC_afun1 = area(x)
 *
 * LOC_patternAreaAreasMany = [<term>,<list>]
 * LOC_patternAreaAreasSingle = [<term>]
 * LOC_patternAreaAreasEmpty = []
 * LOC_patternSliceSlice = slice(<str>,<term>)
 * LOC_patternAreaArea = area(<int>,<int>,<int>,<int>,<int>,<int>)
 * LOC_patternLocationAreaInFile = area-in-file(<str>,<term>)
 * LOC_patternLocationArea = area(<term>)
 * LOC_patternLocationFile = file(<str>)
 * LOC_patternNatConNatCon = <str>
 * LOC_patternStrConStrCon = <str>
 * LOC_patternStrCharStrChar = <str>
 *
 */

static ATerm _Location_dict = NULL;

#define _Location_dict_LEN 212

static char _Location_dict_baf[_Location_dict_LEN] = {
0x00,0x8B,0xAF,0x83,0x00,0x0D,0x29,0x03,0x3C,0x5F,0x3E,0x01,0x00,0x04,0x04,0x03,
0x04,0x05,0x06,0x05,0x5B,0x5F,0x2C,0x5F,0x5D,0x02,0x00,0x15,0x08,0x01,0x02,0x00,
0x08,0x09,0x0A,0x0B,0x0C,0x02,0x01,0x02,0x02,0x5B,0x5D,0x00,0x00,0x01,0x03,0x69,
0x6E,0x74,0x00,0x00,0x01,0x03,0x73,0x74,0x72,0x00,0x00,0x01,0x04,0x6C,0x69,0x73,
0x74,0x00,0x00,0x01,0x04,0x74,0x65,0x72,0x6D,0x00,0x00,0x01,0x01,0x78,0x00,0x00,
0x01,0x05,0x73,0x6C,0x69,0x63,0x65,0x02,0x00,0x02,0x02,0x00,0x07,0x02,0x00,0x07,
0x04,0x66,0x69,0x6C,0x65,0x01,0x00,0x02,0x02,0x00,0x07,0x0C,0x61,0x72,0x65,0x61,
0x2D,0x69,0x6E,0x2D,0x66,0x69,0x6C,0x65,0x02,0x00,0x02,0x02,0x00,0x07,0x02,0x00,
0x07,0x04,0x61,0x72,0x65,0x61,0x06,0x00,0x02,0x02,0x00,0x07,0x02,0x00,0x07,0x02,
0x00,0x07,0x02,0x00,0x07,0x02,0x00,0x07,0x02,0x00,0x07,0x04,0x61,0x72,0x65,0x61,
0x01,0x00,0x02,0x02,0x00,0x07,0x01,0x02,0x61,0x46,0x08,0x84,0x51,0x44,0x18,0xAA,
0xA0,0x1C,0x51,0x90,0x48,0x31,0x06,0x28,0x91,0x44,0x43,0x88,0x20,0x30,0x7B,0x21,
0x40,0x0E,0x68,0xC0,0xC6,0x31,0x8C,0x5A,0xA1,0x00,0x37,0x40,0x34,0x50,0x85,0x22,
0x24,0x88,0x12,0x2A
};

void init_Location_dict()
{
  ATermList afuns, terms;

  _Location_dict = ATreadFromBinaryString(_Location_dict_baf, _Location_dict_LEN);

  ATprotect(&_Location_dict);

  afuns = (ATermList)ATelementAt((ATermList)_Location_dict, 0);

  LOC_afun4 = ATgetAFun((ATermAppl)ATgetFirst(afuns));
  afuns = ATgetNext(afuns);
  LOC_afun0 = ATgetAFun((ATermAppl)ATgetFirst(afuns));
  afuns = ATgetNext(afuns);
  LOC_afun2 = ATgetAFun((ATermAppl)ATgetFirst(afuns));
  afuns = ATgetNext(afuns);
  LOC_afun3 = ATgetAFun((ATermAppl)ATgetFirst(afuns));
  afuns = ATgetNext(afuns);
  LOC_afun1 = ATgetAFun((ATermAppl)ATgetFirst(afuns));
  afuns = ATgetNext(afuns);

  terms = (ATermList)ATelementAt((ATermList)_Location_dict, 1);

  LOC_patternAreaAreasMany = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternAreaAreasSingle = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternAreaAreasEmpty = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternSliceSlice = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternAreaArea = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternLocationAreaInFile = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternLocationArea = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternLocationFile = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternNatConNatCon = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternStrConStrCon = ATgetFirst(terms);
  terms = ATgetNext(terms);
  LOC_patternStrCharStrChar = ATgetFirst(terms);
  terms = ATgetNext(terms);
}
