## $Id: yat_svn_release.m4 2787 2012-07-23 03:14:44Z peter $

# serial 9 (yat 0.9)

# SYNOPSIS
#
#   YAT_SVN_RELEASE
#
# DESCRIPTION
#
#   Creates a few make rules useful for maintainer. You need to add
#
#     include $(srcdir)/maintainer.am
#
#   in your top Makefile.am. The main targets are `maintainer-check'
#   and `release'. maintainer-check 'svn exports' from the local wc
#   and try to build from this pristine directory via './boostrap;
#   ./configure $(DISTCHECK_CONFIGURE_FLAGS); make'. You can add
#   additional target that should be run within maintainer-check by
#   defining variable `MAINTAINER_CHECK_LOCAL'. The target `release'
#   runs `maintainer-check' in addition to some more sanity checks
#   such as checking that wc is not modified compared with repository
#   and finishes by running distcheck.
#
# COPYLEFT
m4_define([yat_svn_release_copyright], [dnl
#
#   Copyright (C) 2009, 2010, 2011, 2012 Peter Johansson
#
#   This file is part of the yat library, http://dev.thep.lu.se/yat
#
#   The yat library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as
#   published by the Free Software Foundation; either version 3 of the
#   License, or (at your option) any later version.
#
#   The yat library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with yat. If not, see <http://www.gnu.org/licenses/>.
#
])

AC_DEFUN([YAT_SVN_RELEASE],
[
  AC_REQUIRE([AC_PROG_SED])
  AC_REQUIRE([AC_PROG_EGREP])
  AC_CHECK_PROGS([MD5], [md5sum gmd5sum md5 md5deep], [no])
  m4_pushdef([YAT_OUTPUTFILE], [m4_default([$1], [maintainer.am])])

  AX_AC_PRINT_TO_FILE(YAT_OUTPUTFILE,
[#  ]YAT_OUTPUTFILE[ generated by autoconf from $0
]yat_svn_release_copyright[
.PHONY: check-svn-diff check-news check-news-date check-version \\
        check-release-tools maintainer-check release

# stub rule to work around bug in Automake 1.11
\$(srcdir)/]YAT_OUTPUTFILE[:

check-svn-diff:
	@str=\`svn diff -rHEAD \$(srcdir)\`; \\
	if test -n \"\$\$str\"; then \\
		echo \"\$\$str\" 1>&2;\\
		exit 1;\\
	fi

check-news:
	@case \`sed 15q \$(srcdir)/NEWS\` in \\
	*\"\$(VERSION)\"*);; \\
	*) \\
	  echo \"NEWS not updated\" 1>&2; \\
	  exit 1;; \\
	esac

check-news-date:
	@today=\`date -u \"+%%e %%B %%Y\"\`; \\
	case \`sed 15q \$(srcdir)/NEWS\` in \\
	*\"\$\$today\"*);; \\
	*) \\
	  echo \"NEWS: release date incorrect; expected '\$\$today'\" 1>&2;\\
	  exit 1;; \\
	esac

check-version:
	@echo \$(VERSION) | \$(EGREP) '^[0-9]+(\\.[0-9]+)+\$\$' > /dev/null || \\
	{ echo \"invalid version string: \$(VERSION)\" 1>&2; exit 1; }

check-release-tools:
	@test \"x\$(MD5)\" != \"xno\" || \\
	(echo \"no tool to calculate MD5 checksum available\" 1>&2 && exit 1)

mc_exportdir=_exported
mc_builddir=_exported_build

maintainer-check:
	rm -rf \$(mc_exportdir)
	rm -rf \$(mc_builddir)
	svn export \$(srcdir) \$(mc_exportdir)
	mkdir \$(mc_builddir)
	@cd \$(mc_exportdir) \\
	&& echo \"./bootstrap\" \\
	&& ./bootstrap \\
	&& cd ../\$(mc_builddir) \\
	&& ../\$(mc_exportdir)/configure --srcdir=../\$(mc_exportdir) \\
	   \$(DISTCHECK_CONFIGURE_FLAGS) \\
	&& { test -z \"\$(MAINTAINER_CHECK_LOCAL)\" || \\
	      \$(MAKE) \$(AM_MAKEFLAGS) \$(MAINTAINER_CHECK_LOCAL); } \\
	&& \$(MAKE) \$(AM_MAKEFLAGS) dist || exit 1
	rm -rf \$(mc_builddir) \$(mc_exportdir)

release: all
	\$(MAKE) \$(AM_MAKEFLAGS) check-release-tools
	@test -z \"\$(RELEASE_LOCAL)\" || \$(MAKE) \$(AM_MAKEFLAGS) \$(RELEASE_LOCAL)
	\$(MAKE) \$(AM_MAKEFLAGS) check-version
	\$(MAKE) \$(AM_MAKEFLAGS) check-news
	\$(MAKE) \$(AM_MAKEFLAGS) check-news-date
	\$(MAKE) \$(AM_MAKEFLAGS) check-svn-diff
	\$(MAKE) \$(AM_MAKEFLAGS) maintainer-check
	\$(MAKE) \$(AM_MAKEFLAGS) distcheck
	@for a in \$(DIST_ARCHIVES); do \\
	  \$(MD5) \$\$a > \$\$a.MD5; \\
	done;
	@test -z \"\$(RELEASE_HOOK)\" || \$(MAKE) \$(AM_MAKEFLAGS) \$(RELEASE_HOOK)
])
  m4_popdef([YAT_OUTPUTFILE])

]) # YAT_SVN_RELEASE
