#ifndef _theplu_yat_utility_stl_utility_
#define _theplu_yat_utility_stl_utility_

// $Id: stl_utility.h 4339 2023-04-15 10:35:22Z peter $

/*
	Copyright (C) 2004 Jari Häkkinen
	Copyright (C) 2005 Jari Häkkinen, Peter Johansson, Markus Ringnér
	Copyright (C) 2006 Jari Häkkinen
	Copyright (C) 2007, 2008 Jari Häkkinen, Peter Johansson
	Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2018, 2022 Peter Johansson

	This file is part of the yat library, http://dev.thep.lu.se/yat

	The yat library is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 3 of the
	License, or (at your option) any later version.

	The yat library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with yat. If not, see <http://www.gnu.org/licenses/>.
*/

///
/// \file stl_utility.h
///
/// There are a number of useful functionality missing in the Standard
/// Template Library, STL. This file is an effort to provide
/// extensions to STL functionality.
///

#include "Exception.h"

#include <algorithm>
#include <cmath>
#include <exception>
#include <functional>
#include <iterator>
#include <map>
#include <ostream>
#include <sstream>
#include <string>
#include <utility>
#include <vector>

// We are intruding standard namespace, which might cause
// conflicts. Let the user turn off these declarations by defining
// YAT_STD_DISABE
#ifndef YAT_STD_DISABLE
namespace std {

	///
	/// Print out a pair
	///
	// This is in namespace std because we have not figured out how to have
	// pair and its operator<< in different namespaces
	template <class T1, class T2>
	std::ostream& operator<<(std::ostream& out, const std::pair<T1,T2>& p)
	{ out << p.first << "\t" << p.second; return out; }

}
#endif

namespace theplu {
namespace yat {
namespace utility {

	/**
		 \brief Identity functor that returns its argument

		 \since New in yat 0.7
	 */
	template<typename T>
	struct Identity
	{
		/// \c argument_type is \c T
		typedef T argument_type;
		/// \c result_type is \c T
		typedef T result_type;
		/// \return \a arg
		T operator()(T arg) const { return arg; }
	};


	///
	/// @brief Function converting a string to lower case
	///
	std::string& to_lower(std::string& s);

	///
	/// @brief Function converting a string to upper case
	///
	std::string& to_upper(std::string& s);

}}} // of namespace utility, yat, and theplu
#endif
