## $Id: yat_svn_release.m4 4333 2023-03-16 13:33:53Z peter $

# serial 20 (yat 0.21)

# SYNOPSIS
#
#   YAT_SVN_RELEASE
#
# DESCRIPTION
#
#
# COPYLEFT
m4_define([yat_svn_release_copyright], [dnl
#
#   Copyright (C) 2009, 2010, 2011, 2012, 2014, 2019 Peter Johansson
#
#   This file is part of the yat library, http://dev.thep.lu.se/yat
#
#   The yat library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as
#   published by the Free Software Foundation; either version 3 of the
#   License, or (at your option) any later version.
#
#   The yat library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with yat. If not, see <http://www.gnu.org/licenses/>.
#
])


# YAT_SVN_RELEASE(am-file, stable-version, upload-url, download-url, news-url)
# ============================================================================
AC_DEFUN([YAT_SVN_RELEASE],
[
  m4_pushdef([YAT_OUTPUTFILE], [m4_default([$1], [maintainer.am])])

  AC_REQUIRE([AC_PROG_SED])
  AC_REQUIRE([AC_PROG_EGREP])
  AC_REQUIRE([_YAT_PROG_SVN])
  AC_CHECK_PROGS([MD5], [md5sum gmd5sum md5 md5deep], [false])
  AC_ARG_VAR([MD5], [command to calculate md5 checksum])
  AC_CHECK_PROG([SVNCOPYRIGHT], [svncopyright], [svncopyright], [false])
  AC_ARG_VAR([SVNCOPYRIGHT], [svncopyright program])
  AC_CHECK_PROG([SVNDIGEST_COPY_CACHE], [svndigest-copy-cache],
                [svndigest-copy-cache], [false])
  AC_ARG_VAR([SVNDIGEST_COPY_CACHE], [svndigest-copy-cache program])
  AC_CHECK_PROG([SCP], [scp], [scp], [false])
  AC_ARG_VAR([SCP], [SCP program])

  m4_ifdef([AM_PROG_LIBTOOL], [
    m4_pushdef([write_LIBTOOL_VERSION_cmd],
               [$(srcdir)/libtool --version | head -n 1 | $(SED) -e 's/.*(//' -e 's/)//' >> [$]@])
  ], [
    m4_pushdef([write_LIBTOOL_VERSION_cmd], [:])
  ])
  _YAT_AM_LOCAL_WRITE(YAT_OUTPUTFILE, [

STABLE_VERSION = $2
STABLE_BRANCH = ^/branches/$(STABLE_VERSION)-stable
UPLOAD_URL = $3
DOWNLOAD_URL = $4
NEWS_URL = $5
SVN_LIST_CC = `$(SVN) list -R $(srcdir) | $(EGREP) ".cc$$" | $(SED) 's,^,$(srcdir)/,'`

.PHONY: check-svn-diff check-news check-news-date check-version \
        check-release-tools maintainer-check maintainer-check-local \
				release-tag-upload release-tag-upload-local

# --------------------------------------------------------------------
# Tagging and uploading a release
#
# This is the main target used at release. It does several checks of
# the package, creates a tarball, an svn tag, and uploads the package
# to download page.
# --------------------------------------------------------------------
release-tag-upload:
	$(MAKE) $(AM_MAKEFLAGS) release-tag-upload-local
	$(MAKE) $(AM_MAKEFLAGS) check-release-tools
	$(MAKE) $(AM_MAKEFLAGS) release-check
	$(MAKE) $(AM_MAKEFLAGS) distcheck
	$(MAKE) $(AM_MAKEFLAGS) maintainer-check
	$(MAKE) $(AM_MAKEFLAGS) svn-tag
	$(SVN) update $(srcdir)
	$(MAKE) $(AM_MAKEFLAGS) dist
	$(MAKE) $(AM_MAKEFLAGS) $(distdir).tar.gz.MD5
	$(MAKE) $(AM_MAKEFLAGS) announce.txt
	$(MAKE) $(AM_MAKEFLAGS) upload
	$(MAKE) $(AM_MAKEFLAGS) release-tag-upload-hook

# This is run early in release-tag-upload. Add targets to
# $(RELEASE_LOCAL) such as checks that needed tools to make a release
# are available.
release-tag-upload-local: $(RELEASE_LOCAL)

# This is run late in release-tag-upload. Add targets to
# $(RELEASE_HOOK) if extra targets are desired.
release-tag-upload-hook: $(RELEASE_HOOK)

$(distdir).tar.gz.MD5: $(distdir).tar.gz
	$(MD5) $(distdir).tar.gz > $(distdir).tar.gz.MD5

# Check that we have all tools needed to do a release
check-release-tools:
	@test x"$(sf_user)" != x"" || \
	{ echo "make variable 'sf_user' is empty" >&2; exit 1; }
	@test "x$(MD5)" != "xfalse" || \
	{ echo "no tool to calculate MD5 checksum available" 1>&2 && exit 1; }
	@test "x$(SVN)" != "xfalse" || \
	{ echo "no subversion client available" 1>&2 && exit 1; }
	@test "x$(SVNDIGEST_COPY_CACHE)" != "xfalse" || \
	{ echo "svndigest-copy-cache not available" 1>&2 && exit 1; }
	@test "x$(SCP)" != "xfalse" || \
	{ echo "scp not available" 1>&2 && exit 1; }

# upload dist tarball to $(UPLOAD_URL)
upload: $(distdir).tar.gz $(distdir).tar.gz.MD5
	$(SCP) $(distdir).tar.gz $(distdir).tar.gz.MD5 \
	$(sf_user),$(UPLOAD_URL)


mc_exportdir = _exported
mc_builddir = _exported_build

# ---------------------------------------------------------------------
# Similar to automake generated distcheck rule
#
# This rule 'svn export' the local WC and tries to bootstrap, a VPATH
# configuration, and check that everything is there to make dist. The
# rule is hookable; if variable MAINTAINER_CHECK_LOCAL is non-empty it
# will be issued. A typical declaration would be
# MAINTAINER_CHECK_LOCAL = check
# ---------------------------------------------------------------------
maintainer-check:
	$(MAKE) $(AM_MAKEFLAGS) syntax-check
	rm -rf $(mc_exportdir)
	rm -rf $(mc_builddir)
	$(SVN) export $(srcdir) $(mc_exportdir)
	mkdir $(mc_builddir)
	@cd $(mc_exportdir) \
	&& echo "./bootstrap" \
	&& ./bootstrap \
	&& cd ../$(mc_builddir) \
	&& ../$(mc_exportdir)/configure $(DISTCHECK_CONFIGURE_FLAGS) \
	&& $(MAKE) $(AM_MAKEFLAGS) maintainer-check-local \
	&& $(MAKE) $(AM_MAKEFLAGS) dist || exit 1
	rm -rf $(mc_builddir) $(mc_exportdir)

# This is run during maintainer-check. Add targets to
# $(MAINTAINER_CHECK_LOCAL), if extra targets such as 'check' is
# desired during maintainer-check.
maintainer-check-local: $(MAINTAINER_CHECK_LOCAL)

# -----------------------------------------
# Check that package is ready for release
# -----------------------------------------
release-check: check-news check-news-date check-svn-diff check-version

# Check that NEWS mention VERSION early on
check-news:
	@case `sed 15q $(srcdir)/NEWS` in \
	*"$(VERSION)"*);; \
	*) \
	  echo "NEWS not updated" 1>&2; \
	  exit 1;; \
	esac

# Check that NEWS mention today's date (in UTC)
check-news-date:
	@today=`date -u "+%e %B %Y"`; \
	case `sed 15q $(srcdir)/NEWS` in \
	*"$$today"*);; \
	*) \
	  echo "NEWS: release date incorrect; expected '$$today'" 1>&2;\
	  exit 1;; \
	esac

# Check that VERSION is appropriate for release
check-version:
	@echo $(VERSION) | $(EGREP) '^[0-9]+(\.[0-9]+)+$$' > /dev/null || \
	{ echo "invalid version string: $(VERSION)" 1>&2; exit 1; }


#------------------
# Subversion rules
#------------------

# Check that WC is in sync with repository
check-svn-diff:
	@str=`$(SVN) diff -rHEAD $(srcdir)`; \
	test -z "$$str" || { echo "$$str" 1>&2; exit 1; }

check-svn-wc-is-trunk:
	@$(SVN) info $(srcdir) | $(GREP) -q '/trunk'


# create a tag from current stable branch; depends on check-version to
# ensure that version is macro.minor.micro (no pre suffix), that wc is
# pristine and updated.
svn-tag: check-version check-svn-diff
	cd $(srcdir) && \
	$(SVN) copy $(STABLE_BRANCH) ^/tags/$(VERSION) \
	-m "tagging version $(VERSION)"

# create a stable-branch from trunk
svn-stable-branch: check-svn-diff check-svn-wc-is-trunk
	cd $(srcdir) && \
	$(SVN) copy ^/trunk $(STABLE_BRANCH) \
	-m "New stable branch $(STABLE_VERSION)" \
	&& svn co $(STABLE_BRANCH) ../$(PACKAGE)-$(STABLE_VERSION).x \
	&& $(SVNDIGEST_COPY_CACHE) -v -r . -t ../$(PACKAGE)-$(STABLE_VERSION).x


# Update copyright statement
copyright:
	$(SVNCOPYRIGHT) -v -r $(srcdir)

syntax-check: sc_config_h

sc_config_h:
	@for f in $(SVN_LIST_CC); do \
		$(GREP) '^#include' $$f | head -n 1 | $(GREP) -q '<config.h>' || \
		{ echo "missing '#include <config.h>' in $$f" >&2; exit 1; } \
	done

# Generate an announcement
announce.txt: Makefile $(distdir).tar.gz.MD5
	@echo "I'm happy to announce the release of $(PACKAGE_STRING)" > ]$[@
	@echo >> ]$[@
	@echo "<INSERT TEXT HERE>" >> ]$[@
	@echo >> ]$[@
	@echo "You can find the new release here:" >> ]$[@
	@echo >> ]$[@
	@echo "$(DOWNLOAD_URL)" >> ]$[@
	@echo >> ]$[@
	@echo "Here is the checksum" >> ]$[@
	@echo >> ]$[@
	@printf "MD5:    " >> ]$[@
	@cat $(distdir).tar.gz.MD5 | $(SED) 's/ .*//' >> ]$[@
	@echo >> ]$[@
	@echo "Please report bugs by email to $(PACKAGE_BUGREPORT)" >> ]$[@
	@echo >> ]$[@
	@echo "This release was bootstrapped with the following tools:" >> ]$[@
	@$(AUTOCONF) --version | head -n 1 | $(SED) -e 's/.*(//' -e 's/)//' >> ]$[@
	@$(AUTOMAKE) --version | head -n 1 | $(SED) -e 's/.*(//' -e 's/)//' >> ]$[@
	@]write_LIBTOOL_VERSION_cmd[
	@echo >> ]$[@
	@echo You can find the list of significant changes between $(VERSION)>> ]$[@
	@echo and earlier versions at >> ]$[@
	@echo >> ]$[@
	@echo $(NEWS_URL) >> ]$[@

])
m4_popdef([YAT_OUTPUTFILE])
m4_popdef([write_LIBTOOL_VERSION_cmd])
]) # YAT_SVN_RELEASE

# See file 'yat_common.m4' for new macros
AU_ALIAS([YAT_AC_WRITE], [YAT_AC_WRITE_TO_FILE])
AU_ALIAS([YAT_AC_WRITE_APPEND], [YAT_AC_APPEND_TO_FILE])
