/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class IfGlsFieldEq
extends AbstractGlsCommand {
    protected boolean expandArg;
    protected boolean csname;

    public IfGlsFieldEq(GlossariesSty glossariesSty) {
        this("ifglsfieldeq", false, false, glossariesSty);
    }

    public IfGlsFieldEq(String string, boolean bl, GlossariesSty glossariesSty) {
        this(string, bl, false, glossariesSty);
    }

    public IfGlsFieldEq(String string, boolean bl, boolean bl2, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.expandArg = bl;
        this.csname = bl2;
    }

    @Override
    public Object clone() {
        return new IfGlsFieldEq(this.getName(), this.expandArg, this.csname, this.getSty());
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        String string = this.sty.getFieldName(this.popLabelString(teXParser, teXObjectList));
        TeXObject teXObject = null;
        if (this.csname) {
            object = this.popLabelString(teXParser, teXObjectList);
            teXObject = teXParser.getListener().getControlSequence((String)object);
        } else {
            teXObject = this.popArg(teXParser, teXObjectList);
        }
        object = this.popArg(teXParser, teXObjectList);
        TeXObject teXObject2 = this.popArg(teXParser, teXObjectList);
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        if (glossaryEntry == null) {
            this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
        } else {
            TeXObject teXObject3 = glossaryEntry.get(string);
            if (teXObject3 == null) {
                throw new LaTeXSyntaxException(teXParser, "glossaries.field.not.defined", string);
            }
            if (this.expandArg) {
                teXObject = TeXParserUtils.expandOnce(teXObject, teXParser, teXObjectList);
            }
            teXObject3 = TeXParserUtils.expandOnce(teXObject3, teXParser, teXObjectList);
            if (teXObject.toString(teXParser).equals(teXObject3.toString(teXParser))) {
                TeXParserUtils.process((TeXObject)object, teXParser, teXObjectList);
            } else {
                TeXParserUtils.process(teXObject2, teXParser, teXObjectList);
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

