#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 5882
#define LARGE_STATE_COUNT 1193
#define SYMBOL_COUNT 381
#define ALIAS_COUNT 7
#define TOKEN_COUNT 169
#define EXTERNAL_TOKEN_COUNT 10
#define FIELD_COUNT 43
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 342

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_with = 16,
  anon_sym_assert = 17,
  anon_sym_var = 18,
  anon_sym_let = 19,
  anon_sym_const = 20,
  anon_sym_BANG = 21,
  anon_sym_else = 22,
  anon_sym_if = 23,
  anon_sym_switch = 24,
  anon_sym_for = 25,
  anon_sym_LPAREN = 26,
  anon_sym_SEMI = 27,
  anon_sym_RPAREN = 28,
  anon_sym_await = 29,
  anon_sym_in = 30,
  anon_sym_of = 31,
  anon_sym_while = 32,
  anon_sym_do = 33,
  anon_sym_try = 34,
  anon_sym_break = 35,
  anon_sym_continue = 36,
  anon_sym_debugger = 37,
  anon_sym_return = 38,
  anon_sym_throw = 39,
  anon_sym_COLON = 40,
  anon_sym_case = 41,
  anon_sym_catch = 42,
  anon_sym_finally = 43,
  anon_sym_yield = 44,
  anon_sym_LBRACK = 45,
  anon_sym_RBRACK = 46,
  sym__glimmer_template_content = 47,
  sym_glimmer_opening_tag = 48,
  sym_glimmer_closing_tag = 49,
  anon_sym_GT = 50,
  anon_sym_DOT = 51,
  anon_sym_DQUOTE = 52,
  anon_sym_SQUOTE = 53,
  anon_sym_class = 54,
  anon_sym_async = 55,
  anon_sym_function = 56,
  anon_sym_EQ_GT = 57,
  anon_sym_QMARK_DOT = 58,
  anon_sym_new = 59,
  anon_sym_using = 60,
  anon_sym_PLUS_EQ = 61,
  anon_sym_DASH_EQ = 62,
  anon_sym_STAR_EQ = 63,
  anon_sym_SLASH_EQ = 64,
  anon_sym_PERCENT_EQ = 65,
  anon_sym_CARET_EQ = 66,
  anon_sym_AMP_EQ = 67,
  anon_sym_PIPE_EQ = 68,
  anon_sym_GT_GT_EQ = 69,
  anon_sym_GT_GT_GT_EQ = 70,
  anon_sym_LT_LT_EQ = 71,
  anon_sym_STAR_STAR_EQ = 72,
  anon_sym_AMP_AMP_EQ = 73,
  anon_sym_PIPE_PIPE_EQ = 74,
  anon_sym_QMARK_QMARK_EQ = 75,
  anon_sym_DOT_DOT_DOT = 76,
  anon_sym_AMP_AMP = 77,
  anon_sym_PIPE_PIPE = 78,
  anon_sym_GT_GT = 79,
  anon_sym_GT_GT_GT = 80,
  anon_sym_LT_LT = 81,
  anon_sym_AMP = 82,
  anon_sym_CARET = 83,
  anon_sym_PIPE = 84,
  anon_sym_PLUS = 85,
  anon_sym_DASH = 86,
  anon_sym_SLASH = 87,
  anon_sym_PERCENT = 88,
  anon_sym_STAR_STAR = 89,
  anon_sym_LT = 90,
  anon_sym_LT_EQ = 91,
  anon_sym_EQ_EQ = 92,
  anon_sym_EQ_EQ_EQ = 93,
  anon_sym_BANG_EQ = 94,
  anon_sym_BANG_EQ_EQ = 95,
  anon_sym_GT_EQ = 96,
  anon_sym_QMARK_QMARK = 97,
  anon_sym_instanceof = 98,
  anon_sym_TILDE = 99,
  anon_sym_void = 100,
  anon_sym_delete = 101,
  anon_sym_PLUS_PLUS = 102,
  anon_sym_DASH_DASH = 103,
  sym_unescaped_double_string_fragment = 104,
  sym_unescaped_single_string_fragment = 105,
  sym_escape_sequence = 106,
  sym_comment = 107,
  anon_sym_BQUOTE = 108,
  anon_sym_DOLLAR_LBRACE = 109,
  anon_sym_SLASH2 = 110,
  sym_regex_pattern = 111,
  sym_regex_flags = 112,
  sym_number = 113,
  sym_private_property_identifier = 114,
  anon_sym_target = 115,
  anon_sym_meta = 116,
  sym_this = 117,
  sym_super = 118,
  sym_true = 119,
  sym_false = 120,
  sym_null = 121,
  sym_undefined = 122,
  anon_sym_AT = 123,
  anon_sym_static = 124,
  anon_sym_readonly = 125,
  anon_sym_get = 126,
  anon_sym_set = 127,
  anon_sym_QMARK = 128,
  anon_sym_declare = 129,
  anon_sym_public = 130,
  anon_sym_private = 131,
  anon_sym_protected = 132,
  anon_sym_override = 133,
  anon_sym_module = 134,
  anon_sym_any = 135,
  anon_sym_number = 136,
  anon_sym_boolean = 137,
  anon_sym_string = 138,
  anon_sym_symbol = 139,
  anon_sym_object = 140,
  anon_sym_abstract = 141,
  anon_sym_accessor = 142,
  anon_sym_satisfies = 143,
  anon_sym_require = 144,
  anon_sym_extends = 145,
  anon_sym_implements = 146,
  anon_sym_global = 147,
  anon_sym_interface = 148,
  anon_sym_enum = 149,
  anon_sym_DASH_QMARK_COLON = 150,
  anon_sym_PLUS_QMARK_COLON = 151,
  anon_sym_QMARK_COLON = 152,
  anon_sym_asserts = 153,
  anon_sym_infer = 154,
  anon_sym_is = 155,
  anon_sym_keyof = 156,
  anon_sym_unique = 157,
  anon_sym_unknown = 158,
  anon_sym_never = 159,
  anon_sym_LBRACE_PIPE = 160,
  anon_sym_PIPE_RBRACE = 161,
  sym__automatic_semicolon = 162,
  sym__template_chars = 163,
  sym__ternary_qmark = 164,
  sym_html_comment = 165,
  sym_jsx_text = 166,
  sym__function_signature_automatic_semicolon = 167,
  sym___error_recovery = 168,
  sym_program = 169,
  sym_export_statement = 170,
  sym_namespace_export = 171,
  sym_export_clause = 172,
  sym_export_specifier = 173,
  sym__module_export_name = 174,
  sym_declaration = 175,
  sym_import = 176,
  sym_import_statement = 177,
  sym_import_clause = 178,
  sym__from_clause = 179,
  sym_namespace_import = 180,
  sym_named_imports = 181,
  sym_import_specifier = 182,
  sym_import_attribute = 183,
  sym_statement = 184,
  sym_expression_statement = 185,
  sym_variable_declaration = 186,
  sym_lexical_declaration = 187,
  sym_variable_declarator = 188,
  sym_statement_block = 189,
  sym_else_clause = 190,
  sym_if_statement = 191,
  sym_switch_statement = 192,
  sym_for_statement = 193,
  sym_for_in_statement = 194,
  sym__for_header = 195,
  sym_while_statement = 196,
  sym_do_statement = 197,
  sym_try_statement = 198,
  sym_with_statement = 199,
  sym_break_statement = 200,
  sym_continue_statement = 201,
  sym_debugger_statement = 202,
  sym_return_statement = 203,
  sym_throw_statement = 204,
  sym_empty_statement = 205,
  sym_labeled_statement = 206,
  sym_switch_body = 207,
  sym_switch_case = 208,
  sym_switch_default = 209,
  sym_catch_clause = 210,
  sym_finally_clause = 211,
  sym_parenthesized_expression = 212,
  sym_expression = 213,
  sym_primary_expression = 214,
  sym_yield_expression = 215,
  sym_object = 216,
  sym_object_pattern = 217,
  sym_assignment_pattern = 218,
  sym_object_assignment_pattern = 219,
  sym_array = 220,
  sym_array_pattern = 221,
  sym_glimmer_template = 222,
  sym_nested_identifier = 223,
  sym_class = 224,
  sym_class_declaration = 225,
  sym_class_heritage = 226,
  sym_function_expression = 227,
  sym_function_declaration = 228,
  sym_generator_function = 229,
  sym_generator_function_declaration = 230,
  sym_arrow_function = 231,
  sym__call_signature = 232,
  sym__formal_parameter = 233,
  sym_optional_chain = 234,
  sym_call_expression = 235,
  sym_new_expression = 236,
  sym_await_expression = 237,
  sym_member_expression = 238,
  sym_subscript_expression = 239,
  sym_assignment_expression = 240,
  sym__augmented_assignment_lhs = 241,
  sym_augmented_assignment_expression = 242,
  sym__initializer = 243,
  sym__destructuring_pattern = 244,
  sym_spread_element = 245,
  sym_ternary_expression = 246,
  sym_binary_expression = 247,
  sym_unary_expression = 248,
  sym_update_expression = 249,
  sym_sequence_expression = 250,
  sym_string = 251,
  sym_template_string = 252,
  sym_template_substitution = 253,
  sym_regex = 254,
  sym_meta_property = 255,
  sym_arguments = 256,
  sym_decorator = 257,
  sym_decorator_member_expression = 258,
  sym_decorator_call_expression = 259,
  sym_class_body = 260,
  sym_formal_parameters = 261,
  sym_class_static_block = 262,
  sym_pattern = 263,
  sym_rest_pattern = 264,
  sym_method_definition = 265,
  sym_pair = 266,
  sym_pair_pattern = 267,
  sym__property_name = 268,
  sym_computed_property_name = 269,
  sym_public_field_definition = 270,
  sym__import_identifier = 271,
  sym_non_null_expression = 272,
  sym_method_signature = 273,
  sym_abstract_method_signature = 274,
  sym_function_signature = 275,
  sym_decorator_parenthesized_expression = 276,
  sym_type_assertion = 277,
  sym_as_expression = 278,
  sym_satisfies_expression = 279,
  sym_instantiation_expression = 280,
  sym_import_require_clause = 281,
  sym_extends_clause = 282,
  sym__extends_clause_single = 283,
  sym_implements_clause = 284,
  sym_ambient_declaration = 285,
  sym_abstract_class_declaration = 286,
  sym_module = 287,
  sym_internal_module = 288,
  sym__module = 289,
  sym_import_alias = 290,
  sym_nested_type_identifier = 291,
  sym_interface_declaration = 292,
  sym_extends_type_clause = 293,
  sym_enum_declaration = 294,
  sym_enum_body = 295,
  sym_enum_assignment = 296,
  sym_type_alias_declaration = 297,
  sym_accessibility_modifier = 298,
  sym_override_modifier = 299,
  sym_required_parameter = 300,
  sym_optional_parameter = 301,
  sym__parameter_name = 302,
  sym_omitting_type_annotation = 303,
  sym_adding_type_annotation = 304,
  sym_opting_type_annotation = 305,
  sym_type_annotation = 306,
  sym__type_query_member_expression_in_type_annotation = 307,
  sym__type_query_call_expression_in_type_annotation = 308,
  sym_asserts = 309,
  sym_asserts_annotation = 310,
  sym_type = 311,
  sym_tuple_parameter = 312,
  sym_optional_tuple_parameter = 313,
  sym_optional_type = 314,
  sym_rest_type = 315,
  sym__tuple_type_member = 316,
  sym_constructor_type = 317,
  sym_primary_type = 318,
  sym_template_type = 319,
  sym_template_literal_type = 320,
  sym_infer_type = 321,
  sym_conditional_type = 322,
  sym_generic_type = 323,
  sym_type_predicate = 324,
  sym_type_predicate_annotation = 325,
  sym__type_query_member_expression = 326,
  sym__type_query_subscript_expression = 327,
  sym__type_query_call_expression = 328,
  sym__type_query_instantiation_expression = 329,
  sym_type_query = 330,
  sym_index_type_query = 331,
  sym_lookup_type = 332,
  sym_mapped_type_clause = 333,
  sym_literal_type = 334,
  sym__number = 335,
  sym_existential_type = 336,
  sym_flow_maybe_type = 337,
  sym_parenthesized_type = 338,
  sym_predefined_type = 339,
  sym_type_arguments = 340,
  sym_object_type = 341,
  sym_call_signature = 342,
  sym_property_signature = 343,
  sym_type_parameters = 344,
  sym_type_parameter = 345,
  sym_default_type = 346,
  sym_constraint = 347,
  sym_construct_signature = 348,
  sym_index_signature = 349,
  sym_array_type = 350,
  sym_tuple_type = 351,
  sym_readonly_type = 352,
  sym_union_type = 353,
  sym_intersection_type = 354,
  sym_function_type = 355,
  aux_sym_program_repeat1 = 356,
  aux_sym_export_statement_repeat1 = 357,
  aux_sym_export_clause_repeat1 = 358,
  aux_sym_named_imports_repeat1 = 359,
  aux_sym_variable_declaration_repeat1 = 360,
  aux_sym_switch_body_repeat1 = 361,
  aux_sym_object_repeat1 = 362,
  aux_sym_object_pattern_repeat1 = 363,
  aux_sym_array_repeat1 = 364,
  aux_sym_array_pattern_repeat1 = 365,
  aux_sym_glimmer_template_repeat1 = 366,
  aux_sym_sequence_expression_repeat1 = 367,
  aux_sym_string_repeat1 = 368,
  aux_sym_string_repeat2 = 369,
  aux_sym_template_string_repeat1 = 370,
  aux_sym_class_body_repeat1 = 371,
  aux_sym_formal_parameters_repeat1 = 372,
  aux_sym_extends_clause_repeat1 = 373,
  aux_sym_implements_clause_repeat1 = 374,
  aux_sym_extends_type_clause_repeat1 = 375,
  aux_sym_enum_body_repeat1 = 376,
  aux_sym_template_literal_type_repeat1 = 377,
  aux_sym_object_type_repeat1 = 378,
  aux_sym_type_parameters_repeat1 = 379,
  aux_sym_tuple_type_repeat1 = 380,
  alias_sym_interface_body = 381,
  alias_sym_property_identifier = 382,
  alias_sym_shorthand_property_identifier = 383,
  alias_sym_shorthand_property_identifier_pattern = 384,
  alias_sym_statement_identifier = 385,
  alias_sym_this_type = 386,
  alias_sym_type_identifier = 387,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_with] = "with",
  [anon_sym_assert] = "assert",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_SEMI] = ";",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym__glimmer_template_content] = "_glimmer_template_content",
  [sym_glimmer_opening_tag] = "glimmer_opening_tag",
  [sym_glimmer_closing_tag] = "glimmer_closing_tag",
  [anon_sym_GT] = ">",
  [anon_sym_DOT] = ".",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_using] = "using",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [anon_sym_meta] = "meta",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_override] = "override",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_object] = "object",
  [anon_sym_abstract] = "abstract",
  [anon_sym_accessor] = "accessor",
  [anon_sym_satisfies] = "satisfies",
  [anon_sym_require] = "require",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_PLUS_QMARK_COLON] = "+\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_unique] = "unique symbol",
  [anon_sym_unknown] = "unknown",
  [anon_sym_never] = "never",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "string_fragment",
  [sym__ternary_qmark] = "\?",
  [sym_html_comment] = "html_comment",
  [sym_jsx_text] = "jsx_text",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym___error_recovery] = "__error_recovery",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_namespace_export] = "namespace_export",
  [sym_export_clause] = "export_clause",
  [sym_export_specifier] = "export_specifier",
  [sym__module_export_name] = "_module_export_name",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_import_specifier] = "import_specifier",
  [sym_import_attribute] = "import_attribute",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_glimmer_template] = "glimmer_template",
  [sym_nested_identifier] = "nested_identifier",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function_expression] = "function_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_optional_chain] = "optional_chain",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_class_static_block] = "class_static_block",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym__import_identifier] = "_import_identifier",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_decorator_parenthesized_expression] = "parenthesized_expression",
  [sym_type_assertion] = "type_assertion",
  [sym_as_expression] = "as_expression",
  [sym_satisfies_expression] = "satisfies_expression",
  [sym_instantiation_expression] = "instantiation_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_extends_clause] = "extends_clause",
  [sym__extends_clause_single] = "_extends_clause_single",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_type_clause] = "extends_type_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_override_modifier] = "override_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_adding_type_annotation] = "adding_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym__type_query_member_expression_in_type_annotation] = "member_expression",
  [sym__type_query_call_expression_in_type_annotation] = "call_expression",
  [sym_asserts] = "asserts",
  [sym_asserts_annotation] = "asserts_annotation",
  [sym_type] = "type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym_primary_type] = "primary_type",
  [sym_template_type] = "template_type",
  [sym_template_literal_type] = "template_literal_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym__type_query_member_expression] = "member_expression",
  [sym__type_query_subscript_expression] = "subscript_expression",
  [sym__type_query_call_expression] = "call_expression",
  [sym__type_query_instantiation_expression] = "instantiation_expression",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_glimmer_template_repeat1] = "glimmer_template_repeat1",
  [aux_sym_sequence_expression_repeat1] = "sequence_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_type_clause_repeat1] = "extends_type_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_template_literal_type_repeat1] = "template_literal_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [alias_sym_interface_body] = "interface_body",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_this_type] = "this_type",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym__glimmer_template_content] = sym__glimmer_template_content,
  [sym_glimmer_opening_tag] = sym_glimmer_opening_tag,
  [sym_glimmer_closing_tag] = sym_glimmer_closing_tag,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [sym_unescaped_double_string_fragment] = sym__template_chars,
  [sym_unescaped_single_string_fragment] = sym__template_chars,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_meta] = anon_sym_meta,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_accessor] = anon_sym_accessor,
  [anon_sym_satisfies] = anon_sym_satisfies,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_PLUS_QMARK_COLON] = anon_sym_PLUS_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_unique] = anon_sym_unique,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = anon_sym_QMARK,
  [sym_html_comment] = sym_html_comment,
  [sym_jsx_text] = sym_jsx_text,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym___error_recovery] = sym___error_recovery,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_namespace_export] = sym_namespace_export,
  [sym_export_clause] = sym_export_clause,
  [sym_export_specifier] = sym_export_specifier,
  [sym__module_export_name] = sym__module_export_name,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_import_specifier] = sym_import_specifier,
  [sym_import_attribute] = sym_import_attribute,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_glimmer_template] = sym_glimmer_template,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function_expression] = sym_function_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_optional_chain] = sym_optional_chain,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_class_static_block] = sym_class_static_block,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym__import_identifier] = sym__import_identifier,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_decorator_parenthesized_expression] = sym_parenthesized_expression,
  [sym_type_assertion] = sym_type_assertion,
  [sym_as_expression] = sym_as_expression,
  [sym_satisfies_expression] = sym_satisfies_expression,
  [sym_instantiation_expression] = sym_instantiation_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_extends_clause] = sym_extends_clause,
  [sym__extends_clause_single] = sym__extends_clause_single,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_type_clause] = sym_extends_type_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_override_modifier] = sym_override_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_adding_type_annotation] = sym_adding_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym__type_query_member_expression_in_type_annotation] = sym_member_expression,
  [sym__type_query_call_expression_in_type_annotation] = sym_call_expression,
  [sym_asserts] = sym_asserts,
  [sym_asserts_annotation] = sym_asserts_annotation,
  [sym_type] = sym_type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym_primary_type] = sym_primary_type,
  [sym_template_type] = sym_template_type,
  [sym_template_literal_type] = sym_template_literal_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym__type_query_member_expression] = sym_member_expression,
  [sym__type_query_subscript_expression] = sym_subscript_expression,
  [sym__type_query_call_expression] = sym_call_expression,
  [sym__type_query_instantiation_expression] = sym_instantiation_expression,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_glimmer_template_repeat1] = aux_sym_glimmer_template_repeat1,
  [aux_sym_sequence_expression_repeat1] = aux_sym_sequence_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_type_clause_repeat1] = aux_sym_extends_type_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_template_literal_type_repeat1] = aux_sym_template_literal_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [alias_sym_interface_body] = alias_sym_interface_body,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_this_type] = alias_sym_this_type,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym__glimmer_template_content] = {
    .visible = false,
    .named = true,
  },
  [sym_glimmer_opening_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_meta] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_accessor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_satisfies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_html_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym___error_recovery] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__module_export_name] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_import_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_template] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_static_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__import_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_satisfies_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__extends_clause_single] = {
    .visible = false,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_override_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_adding_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_glimmer_template_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_type_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_literal_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_this_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_body = 5,
  field_close_tag = 6,
  field_condition = 7,
  field_consequence = 8,
  field_constraint = 9,
  field_constructor = 10,
  field_content = 11,
  field_declaration = 12,
  field_decorator = 13,
  field_finalizer = 14,
  field_flags = 15,
  field_function = 16,
  field_handler = 17,
  field_increment = 18,
  field_index = 19,
  field_index_type = 20,
  field_initializer = 21,
  field_key = 22,
  field_kind = 23,
  field_label = 24,
  field_left = 25,
  field_module = 26,
  field_name = 27,
  field_object = 28,
  field_open_tag = 29,
  field_operator = 30,
  field_optional_chain = 31,
  field_parameter = 32,
  field_parameters = 33,
  field_pattern = 34,
  field_property = 35,
  field_return_type = 36,
  field_right = 37,
  field_sign = 38,
  field_source = 39,
  field_type = 40,
  field_type_arguments = 41,
  field_type_parameters = 42,
  field_value = 43,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_constructor] = "constructor",
  [field_content] = "content",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_index_type] = "index_type",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 1},
  [12] = {.index = 12, .length = 2},
  [13] = {.index = 14, .length = 1},
  [15] = {.index = 3, .length = 1},
  [17] = {.index = 15, .length = 2},
  [18] = {.index = 17, .length = 2},
  [19] = {.index = 19, .length = 2},
  [20] = {.index = 21, .length = 2},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 25, .length = 1},
  [23] = {.index = 26, .length = 2},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 2},
  [26] = {.index = 32, .length = 1},
  [27] = {.index = 33, .length = 2},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 2},
  [34] = {.index = 41, .length = 1},
  [35] = {.index = 42, .length = 2},
  [36] = {.index = 44, .length = 2},
  [37] = {.index = 46, .length = 2},
  [38] = {.index = 48, .length = 1},
  [39] = {.index = 49, .length = 2},
  [40] = {.index = 51, .length = 2},
  [41] = {.index = 53, .length = 6},
  [42] = {.index = 59, .length = 1},
  [43] = {.index = 60, .length = 3},
  [44] = {.index = 63, .length = 3},
  [45] = {.index = 66, .length = 2},
  [46] = {.index = 68, .length = 2},
  [47] = {.index = 70, .length = 2},
  [48] = {.index = 72, .length = 2},
  [49] = {.index = 74, .length = 1},
  [50] = {.index = 75, .length = 3},
  [51] = {.index = 78, .length = 2},
  [52] = {.index = 80, .length = 1},
  [53] = {.index = 81, .length = 2},
  [54] = {.index = 83, .length = 1},
  [55] = {.index = 84, .length = 2},
  [56] = {.index = 86, .length = 4},
  [57] = {.index = 90, .length = 2},
  [58] = {.index = 92, .length = 2},
  [59] = {.index = 94, .length = 3},
  [60] = {.index = 97, .length = 2},
  [61] = {.index = 99, .length = 2},
  [62] = {.index = 101, .length = 2},
  [63] = {.index = 103, .length = 2},
  [64] = {.index = 105, .length = 1},
  [65] = {.index = 106, .length = 2},
  [66] = {.index = 108, .length = 2},
  [67] = {.index = 110, .length = 2},
  [70] = {.index = 106, .length = 2},
  [71] = {.index = 112, .length = 4},
  [72] = {.index = 33, .length = 2},
  [73] = {.index = 37, .length = 2},
  [74] = {.index = 116, .length = 3},
  [75] = {.index = 78, .length = 2},
  [76] = {.index = 78, .length = 2},
  [77] = {.index = 119, .length = 2},
  [78] = {.index = 119, .length = 2},
  [79] = {.index = 121, .length = 3},
  [80] = {.index = 121, .length = 3},
  [81] = {.index = 124, .length = 3},
  [82] = {.index = 127, .length = 2},
  [83] = {.index = 129, .length = 4},
  [84] = {.index = 133, .length = 3},
  [85] = {.index = 136, .length = 2},
  [86] = {.index = 138, .length = 2},
  [87] = {.index = 140, .length = 1},
  [88] = {.index = 141, .length = 1},
  [89] = {.index = 105, .length = 1},
  [90] = {.index = 119, .length = 2},
  [91] = {.index = 33, .length = 2},
  [92] = {.index = 142, .length = 2},
  [93] = {.index = 144, .length = 5},
  [94] = {.index = 149, .length = 1},
  [95] = {.index = 150, .length = 1},
  [96] = {.index = 151, .length = 2},
  [97] = {.index = 153, .length = 3},
  [98] = {.index = 156, .length = 2},
  [99] = {.index = 158, .length = 3},
  [100] = {.index = 161, .length = 6},
  [101] = {.index = 167, .length = 1},
  [102] = {.index = 168, .length = 1},
  [103] = {.index = 169, .length = 3},
  [104] = {.index = 172, .length = 3},
  [105] = {.index = 175, .length = 4},
  [106] = {.index = 179, .length = 2},
  [107] = {.index = 181, .length = 2},
  [108] = {.index = 183, .length = 3},
  [109] = {.index = 186, .length = 4},
  [110] = {.index = 190, .length = 1},
  [111] = {.index = 191, .length = 2},
  [112] = {.index = 193, .length = 1},
  [113] = {.index = 194, .length = 2},
  [114] = {.index = 196, .length = 3},
  [115] = {.index = 199, .length = 2},
  [116] = {.index = 201, .length = 4},
  [117] = {.index = 205, .length = 2},
  [118] = {.index = 207, .length = 2},
  [119] = {.index = 209, .length = 4},
  [120] = {.index = 207, .length = 2},
  [121] = {.index = 213, .length = 4},
  [122] = {.index = 217, .length = 4},
  [123] = {.index = 221, .length = 5},
  [124] = {.index = 226, .length = 3},
  [125] = {.index = 229, .length = 2},
  [126] = {.index = 229, .length = 2},
  [127] = {.index = 231, .length = 2},
  [128] = {.index = 233, .length = 1},
  [129] = {.index = 234, .length = 2},
  [130] = {.index = 236, .length = 4},
  [131] = {.index = 240, .length = 4},
  [132] = {.index = 244, .length = 4},
  [133] = {.index = 248, .length = 2},
  [134] = {.index = 250, .length = 2},
  [135] = {.index = 252, .length = 2},
  [136] = {.index = 254, .length = 3},
  [137] = {.index = 257, .length = 2},
  [138] = {.index = 259, .length = 4},
  [139] = {.index = 259, .length = 4},
  [140] = {.index = 263, .length = 4},
  [141] = {.index = 263, .length = 4},
  [142] = {.index = 156, .length = 2},
  [143] = {.index = 267, .length = 1},
  [144] = {.index = 267, .length = 1},
  [145] = {.index = 194, .length = 2},
  [146] = {.index = 196, .length = 3},
  [147] = {.index = 268, .length = 2},
  [148] = {.index = 270, .length = 3},
  [149] = {.index = 273, .length = 2},
  [150] = {.index = 275, .length = 3},
  [151] = {.index = 278, .length = 2},
  [152] = {.index = 280, .length = 3},
  [153] = {.index = 283, .length = 1},
  [154] = {.index = 284, .length = 2},
  [155] = {.index = 286, .length = 2},
  [156] = {.index = 288, .length = 5},
  [157] = {.index = 284, .length = 2},
  [158] = {.index = 293, .length = 1},
  [159] = {.index = 294, .length = 4},
  [160] = {.index = 298, .length = 2},
  [161] = {.index = 300, .length = 1},
  [162] = {.index = 301, .length = 2},
  [163] = {.index = 303, .length = 2},
  [164] = {.index = 305, .length = 2},
  [165] = {.index = 307, .length = 4},
  [166] = {.index = 311, .length = 2},
  [167] = {.index = 313, .length = 3},
  [168] = {.index = 316, .length = 3},
  [169] = {.index = 319, .length = 3},
  [170] = {.index = 322, .length = 4},
  [171] = {.index = 326, .length = 4},
  [172] = {.index = 330, .length = 4},
  [173] = {.index = 334, .length = 5},
  [174] = {.index = 339, .length = 2},
  [175] = {.index = 341, .length = 2},
  [176] = {.index = 343, .length = 1},
  [177] = {.index = 344, .length = 4},
  [178] = {.index = 344, .length = 4},
  [179] = {.index = 348, .length = 3},
  [180] = {.index = 351, .length = 2},
  [181] = {.index = 353, .length = 3},
  [182] = {.index = 356, .length = 2},
  [183] = {.index = 358, .length = 3},
  [184] = {.index = 361, .length = 2},
  [185] = {.index = 361, .length = 2},
  [186] = {.index = 319, .length = 3},
  [187] = {.index = 363, .length = 3},
  [188] = {.index = 366, .length = 3},
  [189] = {.index = 151, .length = 2},
  [190] = {.index = 369, .length = 2},
  [191] = {.index = 371, .length = 3},
  [192] = {.index = 374, .length = 4},
  [193] = {.index = 378, .length = 3},
  [194] = {.index = 381, .length = 3},
  [195] = {.index = 384, .length = 2},
  [196] = {.index = 386, .length = 3},
  [197] = {.index = 389, .length = 5},
  [198] = {.index = 384, .length = 2},
  [199] = {.index = 394, .length = 3},
  [200] = {.index = 394, .length = 3},
  [201] = {.index = 397, .length = 3},
  [202] = {.index = 400, .length = 2},
  [203] = {.index = 402, .length = 4},
  [204] = {.index = 151, .length = 2},
  [205] = {.index = 406, .length = 1},
  [206] = {.index = 407, .length = 2},
  [207] = {.index = 409, .length = 2},
  [208] = {.index = 411, .length = 2},
  [209] = {.index = 413, .length = 2},
  [210] = {.index = 415, .length = 3},
  [211] = {.index = 418, .length = 1},
  [212] = {.index = 419, .length = 3},
  [213] = {.index = 422, .length = 2},
  [214] = {.index = 424, .length = 3},
  [215] = {.index = 427, .length = 3},
  [216] = {.index = 430, .length = 3},
  [217] = {.index = 433, .length = 3},
  [218] = {.index = 436, .length = 4},
  [219] = {.index = 440, .length = 5},
  [220] = {.index = 445, .length = 3},
  [221] = {.index = 448, .length = 2},
  [222] = {.index = 450, .length = 2},
  [223] = {.index = 452, .length = 4},
  [224] = {.index = 456, .length = 4},
  [225] = {.index = 460, .length = 4},
  [226] = {.index = 464, .length = 3},
  [227] = {.index = 467, .length = 2},
  [228] = {.index = 469, .length = 3},
  [229] = {.index = 472, .length = 2},
  [230] = {.index = 474, .length = 2},
  [231] = {.index = 476, .length = 2},
  [232] = {.index = 478, .length = 1},
  [233] = {.index = 479, .length = 4},
  [234] = {.index = 483, .length = 3},
  [235] = {.index = 486, .length = 4},
  [236] = {.index = 490, .length = 5},
  [237] = {.index = 495, .length = 1},
  [238] = {.index = 496, .length = 2},
  [239] = {.index = 498, .length = 4},
  [240] = {.index = 502, .length = 4},
  [241] = {.index = 506, .length = 4},
  [242] = {.index = 510, .length = 3},
  [243] = {.index = 513, .length = 2},
  [244] = {.index = 515, .length = 4},
  [245] = {.index = 519, .length = 4},
  [246] = {.index = 523, .length = 2},
  [247] = {.index = 525, .length = 2},
  [248] = {.index = 527, .length = 3},
  [249] = {.index = 530, .length = 3},
  [250] = {.index = 533, .length = 2},
  [251] = {.index = 535, .length = 2},
  [252] = {.index = 537, .length = 1},
  [253] = {.index = 538, .length = 1},
  [254] = {.index = 539, .length = 3},
  [255] = {.index = 542, .length = 3},
  [256] = {.index = 545, .length = 3},
  [257] = {.index = 548, .length = 3},
  [258] = {.index = 551, .length = 4},
  [259] = {.index = 555, .length = 2},
  [260] = {.index = 557, .length = 4},
  [261] = {.index = 561, .length = 3},
  [262] = {.index = 564, .length = 2},
  [263] = {.index = 566, .length = 4},
  [264] = {.index = 570, .length = 4},
  [265] = {.index = 574, .length = 4},
  [266] = {.index = 578, .length = 3},
  [268] = {.index = 581, .length = 4},
  [269] = {.index = 585, .length = 5},
  [270] = {.index = 590, .length = 5},
  [271] = {.index = 595, .length = 5},
  [272] = {.index = 600, .length = 4},
  [273] = {.index = 604, .length = 5},
  [274] = {.index = 609, .length = 4},
  [275] = {.index = 613, .length = 4},
  [276] = {.index = 617, .length = 3},
  [277] = {.index = 620, .length = 3},
  [278] = {.index = 623, .length = 3},
  [279] = {.index = 620, .length = 3},
  [280] = {.index = 626, .length = 2},
  [281] = {.index = 628, .length = 4},
  [282] = {.index = 632, .length = 4},
  [283] = {.index = 636, .length = 3},
  [284] = {.index = 639, .length = 2},
  [285] = {.index = 641, .length = 2},
  [286] = {.index = 643, .length = 3},
  [287] = {.index = 646, .length = 2},
  [288] = {.index = 648, .length = 2},
  [289] = {.index = 650, .length = 1},
  [290] = {.index = 651, .length = 3},
  [291] = {.index = 654, .length = 3},
  [292] = {.index = 657, .length = 4},
  [293] = {.index = 661, .length = 4},
  [294] = {.index = 665, .length = 3},
  [295] = {.index = 668, .length = 3},
  [296] = {.index = 671, .length = 2},
  [297] = {.index = 673, .length = 4},
  [298] = {.index = 677, .length = 5},
  [299] = {.index = 682, .length = 5},
  [300] = {.index = 687, .length = 5},
  [301] = {.index = 692, .length = 4},
  [302] = {.index = 696, .length = 4},
  [303] = {.index = 700, .length = 3},
  [304] = {.index = 703, .length = 3},
  [305] = {.index = 703, .length = 3},
  [306] = {.index = 706, .length = 2},
  [307] = {.index = 708, .length = 2},
  [308] = {.index = 710, .length = 3},
  [309] = {.index = 713, .length = 2},
  [310] = {.index = 715, .length = 2},
  [311] = {.index = 717, .length = 4},
  [312] = {.index = 721, .length = 3},
  [313] = {.index = 724, .length = 3},
  [314] = {.index = 727, .length = 4},
  [315] = {.index = 731, .length = 3},
  [316] = {.index = 734, .length = 3},
  [317] = {.index = 737, .length = 2},
  [318] = {.index = 739, .length = 5},
  [319] = {.index = 744, .length = 5},
  [320] = {.index = 749, .length = 4},
  [321] = {.index = 749, .length = 4},
  [322] = {.index = 753, .length = 4},
  [323] = {.index = 757, .length = 3},
  [324] = {.index = 760, .length = 2},
  [325] = {.index = 762, .length = 2},
  [326] = {.index = 764, .length = 3},
  [327] = {.index = 767, .length = 4},
  [328] = {.index = 771, .length = 4},
  [329] = {.index = 775, .length = 3},
  [330] = {.index = 778, .length = 3},
  [331] = {.index = 781, .length = 4},
  [332] = {.index = 785, .length = 3},
  [333] = {.index = 788, .length = 3},
  [334] = {.index = 791, .length = 5},
  [335] = {.index = 796, .length = 3},
  [336] = {.index = 799, .length = 4},
  [337] = {.index = 803, .length = 4},
  [338] = {.index = 807, .length = 3},
  [339] = {.index = 810, .length = 3},
  [340] = {.index = 813, .length = 4},
  [341] = {.index = 817, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_declaration, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_pattern, 0},
  [9] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [11] =
    {field_body, 1},
  [12] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [14] =
    {field_constructor, 1},
  [15] =
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [17] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
  [19] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [21] =
    {field_arguments, 1},
    {field_function, 0},
  [23] =
    {field_argument, 0},
    {field_operator, 1},
  [25] =
    {field_type_arguments, 1},
  [26] =
    {field_parameters, 0},
    {field_return_type, 1},
  [28] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [30] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [32] =
    {field_declaration, 2},
  [33] =
    {field_left, 0},
    {field_right, 2},
  [35] =
    {field_body, 2},
    {field_label, 0},
  [37] =
    {field_body, 2},
    {field_parameter, 0},
  [39] =
    {field_body, 1},
    {field_name, 0},
  [41] =
    {field_source, 1},
  [42] =
    {field_body, 2},
    {field_object, 1},
  [44] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [46] =
    {field_name, 0},
    {field_type, 1},
  [48] =
    {field_kind, 0},
  [49] =
    {field_condition, 1},
    {field_consequence, 2},
  [51] =
    {field_body, 2},
    {field_value, 1},
  [53] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [59] =
    {field_pattern, 1},
  [60] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [63] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
  [66] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 1},
  [68] =
    {field_body, 2},
    {field_condition, 1},
  [70] =
    {field_body, 1},
    {field_handler, 2},
  [72] =
    {field_body, 1},
    {field_finalizer, 2},
  [74] =
    {field_label, 1},
  [75] =
    {field_close_tag, 2},
    {field_content, 1},
    {field_open_tag, 0},
  [78] =
    {field_body, 2},
    {field_name, 1},
  [80] =
    {field_value, 0},
  [81] =
    {field_type_arguments, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [83] =
    {field_body, 2},
  [84] =
    {field_body, 2},
    {field_type_parameters, 1},
  [86] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [90] =
    {field_arguments, 2},
    {field_constructor, 1},
  [92] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [94] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [97] =
    {field_object, 1, .inherited = true},
    {field_property, 1, .inherited = true},
  [99] =
    {field_index, 1, .inherited = true},
    {field_object, 1, .inherited = true},
  [101] =
    {field_arguments, 1, .inherited = true},
    {field_function, 1, .inherited = true},
  [103] =
    {field_function, 1, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
  [105] =
    {field_name, 1},
  [106] =
    {field_name, 0},
    {field_type_arguments, 1},
  [108] =
    {field_name, 0},
    {field_value, 1},
  [110] =
    {field_constraint, 1},
    {field_name, 0},
  [112] =
    {field_arguments, 1},
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [116] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [119] =
    {field_object, 0},
    {field_property, 2},
  [121] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [124] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [127] =
    {field_arguments, 2},
    {field_function, 0},
  [129] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [133] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [136] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [138] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [140] =
    {field_source, 2, .inherited = true},
  [141] =
    {field_value, 2},
  [142] =
    {field_key, 0},
    {field_value, 2},
  [144] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [149] =
    {field_source, 2},
  [150] =
    {field_value, 1},
  [151] =
    {field_name, 0},
    {field_type, 2},
  [153] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [156] =
    {field_body, 3},
    {field_name, 2},
  [158] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [161] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [167] =
    {field_type, 2},
  [168] =
    {field_pattern, 2},
  [169] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [172] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
  [175] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [179] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 2},
  [181] =
    {field_body, 1},
    {field_condition, 3},
  [183] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [186] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [190] =
    {field_decorator, 0, .inherited = true},
  [191] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
  [193] =
    {field_decorator, 1, .inherited = true},
  [194] =
    {field_body, 3},
    {field_name, 1},
  [196] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [199] =
    {field_type_arguments, 1},
    {field_value, 0},
  [201] =
    {field_type_arguments, 1, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [205] =
    {field_body, 3},
    {field_type_parameters, 1},
  [207] =
    {field_body, 3},
    {field_parameter, 1},
  [209] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [213] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [217] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [221] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [226] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [229] =
    {field_left, 1},
    {field_right, 3},
  [231] =
    {field_flags, 3},
    {field_pattern, 1},
  [233] =
    {field_parameters, 1},
  [234] =
    {field_function, 0},
    {field_type_arguments, 1},
  [236] =
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_type_arguments, 1},
  [240] =
    {field_arguments, 1},
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
  [244] =
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_type_arguments, 1},
  [248] =
    {field_name, 1},
    {field_value, 2},
  [250] =
    {field_constraint, 2},
    {field_name, 1},
  [252] =
    {field_module, 0},
    {field_name, 2},
  [254] =
    {field_constraint, 1},
    {field_name, 0},
    {field_value, 2},
  [257] =
    {field_parameters, 0},
    {field_return_type, 2},
  [259] =
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 2},
  [263] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0},
    {field_property, 2},
  [267] =
    {field_type, 1},
  [268] =
    {field_index, 2},
    {field_object, 0},
  [270] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [273] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [275] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [278] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [280] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [283] =
    {field_source, 3, .inherited = true},
  [284] =
    {field_alias, 2},
    {field_name, 0},
  [286] =
    {field_name, 1},
    {field_value, 3},
  [288] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [293] =
    {field_pattern, 3},
  [294] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [298] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 3},
  [300] =
    {field_name, 2},
  [301] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [303] =
    {field_name, 1},
    {field_type, 2},
  [305] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [307] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [311] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [313] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [316] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
  [319] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [322] =
    {field_type_arguments, 0, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [326] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [330] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [334] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [339] =
    {field_parameters, 1},
    {field_type, 2},
  [341] =
    {field_parameters, 2},
    {field_type_parameters, 1},
  [343] =
    {field_parameters, 2},
  [344] =
    {field_index, 0, .inherited = true},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 2},
  [348] =
    {field_constraint, 2},
    {field_name, 1},
    {field_value, 3},
  [351] =
    {field_parameters, 1},
    {field_type, 3},
  [353] =
    {field_parameters, 1},
    {field_return_type, 3},
    {field_type_parameters, 0},
  [356] =
    {field_body, 4},
    {field_name, 2},
  [358] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [361] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
  [363] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [366] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [369] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [371] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [374] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [378] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [381] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [384] =
    {field_alias, 3},
    {field_name, 1},
  [386] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [389] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [394] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [397] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [400] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 4},
  [402] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [406] =
    {field_type, 3},
  [407] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [409] =
    {field_name, 2},
    {field_type, 3},
  [411] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [413] =
    {field_name, 1},
    {field_type, 3},
  [415] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [418] =
    {field_name, 3},
  [419] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [422] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [424] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [427] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
  [430] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [433] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
  [436] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [440] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [445] =
    {field_parameters, 2},
    {field_type, 3},
    {field_type_parameters, 1},
  [448] =
    {field_parameters, 2},
    {field_type, 3},
  [450] =
    {field_parameters, 3},
    {field_type_parameters, 2},
  [452] =
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [456] =
    {field_index, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [460] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
  [464] =
    {field_parameters, 2},
    {field_type, 4},
    {field_type_parameters, 1},
  [467] =
    {field_parameters, 2},
    {field_type, 4},
  [469] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [472] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [474] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [476] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [478] =
    {field_name, 2, .inherited = true},
  [479] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [483] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [486] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [490] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [495] =
    {field_source, 4},
  [496] =
    {field_body, 3},
    {field_value, 1},
  [498] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [502] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [506] =
    {field_body, 6},
    {field_condition, 3},
    {field_condition, 4},
    {field_initializer, 2},
  [510] =
    {field_body, 6},
    {field_condition, 4},
    {field_initializer, 2},
  [513] =
    {field_body, 4},
    {field_parameter, 2},
  [515] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [519] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [523] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [525] =
    {field_name, 2},
    {field_type, 4},
  [527] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [530] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [533] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [535] =
    {field_name, 3},
    {field_type, 4},
  [537] =
    {field_type, 4},
  [538] =
    {field_name, 4},
  [539] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [542] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
  [545] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [548] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
  [551] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [555] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
  [557] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [561] =
    {field_parameters, 3},
    {field_type, 4},
    {field_type_parameters, 2},
  [564] =
    {field_index, 3},
    {field_object, 0},
  [566] =
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [570] =
    {field_index, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [574] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
  [578] =
    {field_parameters, 3},
    {field_type, 5},
    {field_type_parameters, 2},
  [581] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [585] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [590] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [595] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [600] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
  [604] =
    {field_body, 7},
    {field_condition, 3},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [609] =
    {field_body, 7},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [613] =
    {field_body, 7},
    {field_condition, 4},
    {field_condition, 5},
    {field_initializer, 2},
  [617] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [620] =
    {field_index_type, 3},
    {field_name, 1},
    {field_type, 5},
  [623] =
    {field_alias, 4},
    {field_name, 0},
    {field_type, 2},
  [626] =
    {field_sign, 0},
    {field_type, 5},
  [628] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [632] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [636] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [639] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [641] =
    {field_name, 3},
    {field_type, 5},
  [643] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [646] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [648] =
    {field_name, 4},
    {field_type, 5},
  [650] =
    {field_name, 5},
  [651] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [654] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
  [657] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [661] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [665] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [668] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
  [671] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
  [673] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [677] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [682] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [687] =
    {field_body, 8},
    {field_condition, 4},
    {field_condition, 5},
    {field_increment, 6},
    {field_initializer, 2},
  [692] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [696] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [700] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [703] =
    {field_index_type, 4},
    {field_name, 2},
    {field_type, 6},
  [706] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [708] =
    {field_name, 4},
    {field_type, 6},
  [710] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [713] =
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [715] =
    {field_name, 5},
    {field_type, 6},
  [717] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [721] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [724] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
  [727] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [731] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [734] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
  [737] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
  [739] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [744] =
    {field_body, 8},
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [749] =
    {field_index_type, 5},
    {field_name, 3},
    {field_sign, 0},
    {field_type, 7},
  [753] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [757] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [760] =
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [762] =
    {field_name, 5},
    {field_type, 7},
  [764] =
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [767] =
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [771] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [775] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [778] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
  [781] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [785] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 7, .inherited = true},
  [788] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
  [791] =
    {field_body, 9},
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [796] =
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [799] =
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [803] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [807] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 8, .inherited = true},
  [810] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
  [813] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [817] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
    {field_value, 9, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = alias_sym_property_identifier,
  },
  [14] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [0] = alias_sym_type_identifier,
  },
  [16] = {
    [0] = alias_sym_this_type,
  },
  [27] = {
    [0] = sym_identifier,
  },
  [28] = {
    [0] = alias_sym_statement_identifier,
  },
  [29] = {
    [0] = sym_identifier,
  },
  [31] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [32] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [33] = {
    [1] = sym_identifier,
  },
  [49] = {
    [1] = alias_sym_statement_identifier,
  },
  [51] = {
    [1] = alias_sym_type_identifier,
  },
  [64] = {
    [1] = alias_sym_type_identifier,
  },
  [65] = {
    [0] = alias_sym_type_identifier,
  },
  [66] = {
    [0] = alias_sym_type_identifier,
  },
  [67] = {
    [0] = alias_sym_type_identifier,
  },
  [68] = {
    [1] = alias_sym_type_identifier,
  },
  [69] = {
    [1] = anon_sym_unique,
  },
  [75] = {
    [1] = alias_sym_type_identifier,
    [2] = alias_sym_interface_body,
  },
  [77] = {
    [2] = alias_sym_property_identifier,
  },
  [79] = {
    [2] = alias_sym_property_identifier,
  },
  [90] = {
    [0] = sym_member_expression,
    [2] = alias_sym_property_identifier,
  },
  [91] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [113] = {
    [1] = alias_sym_type_identifier,
  },
  [114] = {
    [1] = alias_sym_type_identifier,
  },
  [118] = {
    [1] = sym_identifier,
  },
  [125] = {
    [1] = sym_identifier,
  },
  [133] = {
    [1] = alias_sym_type_identifier,
  },
  [134] = {
    [1] = alias_sym_type_identifier,
  },
  [135] = {
    [2] = alias_sym_type_identifier,
  },
  [136] = {
    [0] = alias_sym_type_identifier,
  },
  [138] = {
    [2] = alias_sym_property_identifier,
  },
  [140] = {
    [2] = alias_sym_property_identifier,
  },
  [142] = {
    [2] = alias_sym_type_identifier,
  },
  [143] = {
    [1] = alias_sym_type_identifier,
  },
  [145] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [146] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [150] = {
    [2] = alias_sym_type_identifier,
  },
  [155] = {
    [1] = alias_sym_type_identifier,
  },
  [157] = {
    [0] = sym_identifier,
  },
  [169] = {
    [1] = alias_sym_type_identifier,
  },
  [177] = {
    [2] = alias_sym_property_identifier,
  },
  [179] = {
    [1] = alias_sym_type_identifier,
  },
  [182] = {
    [2] = alias_sym_type_identifier,
  },
  [183] = {
    [2] = alias_sym_type_identifier,
  },
  [184] = {
    [1] = alias_sym_type_identifier,
  },
  [186] = {
    [1] = alias_sym_type_identifier,
    [4] = alias_sym_interface_body,
  },
  [189] = {
    [0] = sym_identifier,
  },
  [191] = {
    [2] = alias_sym_type_identifier,
  },
  [192] = {
    [2] = alias_sym_type_identifier,
  },
  [194] = {
    [3] = alias_sym_type_identifier,
  },
  [196] = {
    [1] = alias_sym_type_identifier,
  },
  [198] = {
    [1] = sym_identifier,
  },
  [199] = {
    [1] = sym_identifier,
  },
  [204] = {
    [0] = alias_sym_type_identifier,
  },
  [228] = {
    [2] = alias_sym_type_identifier,
  },
  [233] = {
    [2] = alias_sym_type_identifier,
  },
  [234] = {
    [3] = alias_sym_type_identifier,
  },
  [235] = {
    [3] = alias_sym_type_identifier,
  },
  [267] = {
    [3] = alias_sym_property_identifier,
  },
  [268] = {
    [3] = alias_sym_type_identifier,
  },
  [277] = {
    [1] = sym_identifier,
  },
  [278] = {
    [0] = alias_sym_type_identifier,
  },
  [304] = {
    [2] = sym_identifier,
  },
  [320] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_nested_identifier, 2,
    sym_nested_identifier,
    sym_member_expression,
  sym_predefined_type, 2,
    sym_predefined_type,
    sym_identifier,
  sym_object_type, 2,
    sym_object_type,
    alias_sym_interface_body,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 4,
  [7] = 4,
  [8] = 4,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 14,
  [19] = 16,
  [20] = 14,
  [21] = 16,
  [22] = 16,
  [23] = 14,
  [24] = 14,
  [25] = 16,
  [26] = 14,
  [27] = 16,
  [28] = 16,
  [29] = 29,
  [30] = 14,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 34,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 40,
  [49] = 35,
  [50] = 50,
  [51] = 31,
  [52] = 41,
  [53] = 42,
  [54] = 43,
  [55] = 32,
  [56] = 38,
  [57] = 44,
  [58] = 45,
  [59] = 46,
  [60] = 38,
  [61] = 47,
  [62] = 37,
  [63] = 38,
  [64] = 38,
  [65] = 33,
  [66] = 38,
  [67] = 38,
  [68] = 38,
  [69] = 38,
  [70] = 50,
  [71] = 38,
  [72] = 72,
  [73] = 72,
  [74] = 72,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 77,
  [83] = 83,
  [84] = 83,
  [85] = 77,
  [86] = 86,
  [87] = 87,
  [88] = 86,
  [89] = 89,
  [90] = 86,
  [91] = 86,
  [92] = 86,
  [93] = 93,
  [94] = 94,
  [95] = 94,
  [96] = 96,
  [97] = 97,
  [98] = 97,
  [99] = 96,
  [100] = 93,
  [101] = 93,
  [102] = 94,
  [103] = 94,
  [104] = 94,
  [105] = 94,
  [106] = 87,
  [107] = 87,
  [108] = 94,
  [109] = 93,
  [110] = 89,
  [111] = 111,
  [112] = 112,
  [113] = 94,
  [114] = 114,
  [115] = 97,
  [116] = 87,
  [117] = 117,
  [118] = 93,
  [119] = 93,
  [120] = 94,
  [121] = 97,
  [122] = 122,
  [123] = 94,
  [124] = 94,
  [125] = 94,
  [126] = 114,
  [127] = 111,
  [128] = 93,
  [129] = 93,
  [130] = 94,
  [131] = 94,
  [132] = 93,
  [133] = 94,
  [134] = 94,
  [135] = 94,
  [136] = 94,
  [137] = 137,
  [138] = 137,
  [139] = 137,
  [140] = 137,
  [141] = 93,
  [142] = 137,
  [143] = 137,
  [144] = 137,
  [145] = 94,
  [146] = 137,
  [147] = 147,
  [148] = 137,
  [149] = 137,
  [150] = 150,
  [151] = 151,
  [152] = 151,
  [153] = 151,
  [154] = 154,
  [155] = 151,
  [156] = 151,
  [157] = 157,
  [158] = 151,
  [159] = 151,
  [160] = 151,
  [161] = 151,
  [162] = 151,
  [163] = 163,
  [164] = 163,
  [165] = 163,
  [166] = 163,
  [167] = 163,
  [168] = 163,
  [169] = 163,
  [170] = 163,
  [171] = 163,
  [172] = 163,
  [173] = 173,
  [174] = 174,
  [175] = 174,
  [176] = 176,
  [177] = 173,
  [178] = 176,
  [179] = 173,
  [180] = 176,
  [181] = 174,
  [182] = 182,
  [183] = 183,
  [184] = 173,
  [185] = 173,
  [186] = 183,
  [187] = 183,
  [188] = 173,
  [189] = 182,
  [190] = 173,
  [191] = 173,
  [192] = 173,
  [193] = 173,
  [194] = 194,
  [195] = 194,
  [196] = 196,
  [197] = 196,
  [198] = 198,
  [199] = 198,
  [200] = 200,
  [201] = 196,
  [202] = 200,
  [203] = 198,
  [204] = 200,
  [205] = 205,
  [206] = 205,
  [207] = 207,
  [208] = 205,
  [209] = 209,
  [210] = 205,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 205,
  [216] = 205,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 222,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 248,
  [250] = 250,
  [251] = 222,
  [252] = 250,
  [253] = 245,
  [254] = 222,
  [255] = 255,
  [256] = 256,
  [257] = 222,
  [258] = 222,
  [259] = 256,
  [260] = 260,
  [261] = 222,
  [262] = 262,
  [263] = 222,
  [264] = 256,
  [265] = 265,
  [266] = 256,
  [267] = 256,
  [268] = 260,
  [269] = 262,
  [270] = 222,
  [271] = 256,
  [272] = 222,
  [273] = 222,
  [274] = 256,
  [275] = 275,
  [276] = 275,
  [277] = 275,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 275,
  [282] = 275,
  [283] = 275,
  [284] = 275,
  [285] = 275,
  [286] = 275,
  [287] = 287,
  [288] = 288,
  [289] = 280,
  [290] = 275,
  [291] = 275,
  [292] = 275,
  [293] = 275,
  [294] = 275,
  [295] = 275,
  [296] = 275,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 299,
  [305] = 301,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 306,
  [310] = 307,
  [311] = 308,
  [312] = 312,
  [313] = 313,
  [314] = 313,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 315,
  [327] = 319,
  [328] = 328,
  [329] = 321,
  [330] = 330,
  [331] = 331,
  [332] = 318,
  [333] = 321,
  [334] = 334,
  [335] = 317,
  [336] = 324,
  [337] = 330,
  [338] = 318,
  [339] = 321,
  [340] = 324,
  [341] = 325,
  [342] = 325,
  [343] = 315,
  [344] = 324,
  [345] = 345,
  [346] = 330,
  [347] = 318,
  [348] = 321,
  [349] = 324,
  [350] = 325,
  [351] = 315,
  [352] = 325,
  [353] = 353,
  [354] = 330,
  [355] = 355,
  [356] = 318,
  [357] = 321,
  [358] = 324,
  [359] = 318,
  [360] = 315,
  [361] = 330,
  [362] = 331,
  [363] = 330,
  [364] = 318,
  [365] = 321,
  [366] = 324,
  [367] = 325,
  [368] = 315,
  [369] = 369,
  [370] = 330,
  [371] = 318,
  [372] = 321,
  [373] = 324,
  [374] = 325,
  [375] = 315,
  [376] = 330,
  [377] = 318,
  [378] = 321,
  [379] = 324,
  [380] = 325,
  [381] = 315,
  [382] = 330,
  [383] = 318,
  [384] = 321,
  [385] = 324,
  [386] = 325,
  [387] = 315,
  [388] = 315,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 330,
  [395] = 325,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 412,
  [424] = 424,
  [425] = 425,
  [426] = 396,
  [427] = 427,
  [428] = 412,
  [429] = 419,
  [430] = 430,
  [431] = 399,
  [432] = 400,
  [433] = 416,
  [434] = 417,
  [435] = 412,
  [436] = 425,
  [437] = 419,
  [438] = 438,
  [439] = 419,
  [440] = 440,
  [441] = 441,
  [442] = 419,
  [443] = 419,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 419,
  [448] = 448,
  [449] = 449,
  [450] = 427,
  [451] = 401,
  [452] = 444,
  [453] = 453,
  [454] = 397,
  [455] = 398,
  [456] = 398,
  [457] = 396,
  [458] = 399,
  [459] = 401,
  [460] = 402,
  [461] = 403,
  [462] = 404,
  [463] = 405,
  [464] = 406,
  [465] = 407,
  [466] = 408,
  [467] = 409,
  [468] = 410,
  [469] = 411,
  [470] = 414,
  [471] = 402,
  [472] = 403,
  [473] = 404,
  [474] = 416,
  [475] = 417,
  [476] = 419,
  [477] = 405,
  [478] = 440,
  [479] = 422,
  [480] = 424,
  [481] = 449,
  [482] = 427,
  [483] = 444,
  [484] = 448,
  [485] = 453,
  [486] = 397,
  [487] = 398,
  [488] = 399,
  [489] = 400,
  [490] = 401,
  [491] = 402,
  [492] = 403,
  [493] = 404,
  [494] = 405,
  [495] = 406,
  [496] = 407,
  [497] = 408,
  [498] = 409,
  [499] = 410,
  [500] = 411,
  [501] = 412,
  [502] = 406,
  [503] = 416,
  [504] = 417,
  [505] = 419,
  [506] = 422,
  [507] = 424,
  [508] = 425,
  [509] = 419,
  [510] = 448,
  [511] = 427,
  [512] = 407,
  [513] = 444,
  [514] = 453,
  [515] = 397,
  [516] = 398,
  [517] = 396,
  [518] = 399,
  [519] = 401,
  [520] = 402,
  [521] = 403,
  [522] = 404,
  [523] = 405,
  [524] = 397,
  [525] = 407,
  [526] = 408,
  [527] = 409,
  [528] = 410,
  [529] = 411,
  [530] = 408,
  [531] = 416,
  [532] = 417,
  [533] = 419,
  [534] = 409,
  [535] = 422,
  [536] = 449,
  [537] = 427,
  [538] = 444,
  [539] = 453,
  [540] = 397,
  [541] = 398,
  [542] = 399,
  [543] = 401,
  [544] = 402,
  [545] = 403,
  [546] = 404,
  [547] = 405,
  [548] = 406,
  [549] = 407,
  [550] = 408,
  [551] = 409,
  [552] = 410,
  [553] = 411,
  [554] = 416,
  [555] = 417,
  [556] = 419,
  [557] = 422,
  [558] = 424,
  [559] = 425,
  [560] = 560,
  [561] = 419,
  [562] = 448,
  [563] = 396,
  [564] = 427,
  [565] = 444,
  [566] = 453,
  [567] = 397,
  [568] = 398,
  [569] = 399,
  [570] = 401,
  [571] = 402,
  [572] = 403,
  [573] = 404,
  [574] = 405,
  [575] = 406,
  [576] = 407,
  [577] = 408,
  [578] = 409,
  [579] = 410,
  [580] = 411,
  [581] = 416,
  [582] = 417,
  [583] = 453,
  [584] = 449,
  [585] = 422,
  [586] = 424,
  [587] = 425,
  [588] = 419,
  [589] = 448,
  [590] = 396,
  [591] = 427,
  [592] = 444,
  [593] = 453,
  [594] = 397,
  [595] = 398,
  [596] = 399,
  [597] = 401,
  [598] = 402,
  [599] = 403,
  [600] = 404,
  [601] = 405,
  [602] = 406,
  [603] = 407,
  [604] = 408,
  [605] = 409,
  [606] = 410,
  [607] = 411,
  [608] = 410,
  [609] = 416,
  [610] = 417,
  [611] = 422,
  [612] = 424,
  [613] = 425,
  [614] = 419,
  [615] = 448,
  [616] = 396,
  [617] = 427,
  [618] = 444,
  [619] = 453,
  [620] = 397,
  [621] = 398,
  [622] = 399,
  [623] = 401,
  [624] = 402,
  [625] = 403,
  [626] = 404,
  [627] = 405,
  [628] = 406,
  [629] = 407,
  [630] = 408,
  [631] = 409,
  [632] = 410,
  [633] = 449,
  [634] = 411,
  [635] = 427,
  [636] = 444,
  [637] = 416,
  [638] = 417,
  [639] = 422,
  [640] = 422,
  [641] = 424,
  [642] = 425,
  [643] = 448,
  [644] = 427,
  [645] = 444,
  [646] = 453,
  [647] = 397,
  [648] = 398,
  [649] = 399,
  [650] = 401,
  [651] = 402,
  [652] = 403,
  [653] = 404,
  [654] = 405,
  [655] = 406,
  [656] = 407,
  [657] = 408,
  [658] = 409,
  [659] = 410,
  [660] = 411,
  [661] = 411,
  [662] = 416,
  [663] = 417,
  [664] = 422,
  [665] = 424,
  [666] = 425,
  [667] = 448,
  [668] = 396,
  [669] = 669,
  [670] = 424,
  [671] = 425,
  [672] = 449,
  [673] = 449,
  [674] = 674,
  [675] = 419,
  [676] = 424,
  [677] = 425,
  [678] = 449,
  [679] = 453,
  [680] = 449,
  [681] = 449,
  [682] = 448,
  [683] = 396,
  [684] = 448,
  [685] = 396,
  [686] = 406,
  [687] = 687,
  [688] = 687,
  [689] = 687,
  [690] = 690,
  [691] = 690,
  [692] = 690,
  [693] = 693,
  [694] = 693,
  [695] = 693,
  [696] = 696,
  [697] = 696,
  [698] = 698,
  [699] = 698,
  [700] = 698,
  [701] = 701,
  [702] = 702,
  [703] = 702,
  [704] = 701,
  [705] = 243,
  [706] = 244,
  [707] = 702,
  [708] = 701,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 709,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 716,
  [720] = 716,
  [721] = 718,
  [722] = 717,
  [723] = 718,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 726,
  [728] = 728,
  [729] = 724,
  [730] = 725,
  [731] = 726,
  [732] = 726,
  [733] = 726,
  [734] = 728,
  [735] = 726,
  [736] = 229,
  [737] = 726,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 226,
  [742] = 726,
  [743] = 726,
  [744] = 724,
  [745] = 726,
  [746] = 225,
  [747] = 747,
  [748] = 726,
  [749] = 227,
  [750] = 234,
  [751] = 225,
  [752] = 229,
  [753] = 233,
  [754] = 226,
  [755] = 726,
  [756] = 756,
  [757] = 233,
  [758] = 756,
  [759] = 759,
  [760] = 756,
  [761] = 724,
  [762] = 725,
  [763] = 211,
  [764] = 213,
  [765] = 726,
  [766] = 726,
  [767] = 726,
  [768] = 726,
  [769] = 726,
  [770] = 726,
  [771] = 739,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 775,
  [783] = 783,
  [784] = 775,
  [785] = 209,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 240,
  [790] = 790,
  [791] = 775,
  [792] = 792,
  [793] = 775,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 775,
  [799] = 775,
  [800] = 726,
  [801] = 241,
  [802] = 802,
  [803] = 803,
  [804] = 775,
  [805] = 775,
  [806] = 775,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 814,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 227,
  [875] = 875,
  [876] = 876,
  [877] = 234,
  [878] = 878,
  [879] = 814,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 220,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 236,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 814,
  [923] = 923,
  [924] = 924,
  [925] = 814,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 936,
  [938] = 935,
  [939] = 936,
  [940] = 936,
  [941] = 936,
  [942] = 935,
  [943] = 935,
  [944] = 935,
  [945] = 945,
  [946] = 790,
  [947] = 773,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 960,
  [964] = 960,
  [965] = 962,
  [966] = 960,
  [967] = 962,
  [968] = 960,
  [969] = 962,
  [970] = 962,
  [971] = 961,
  [972] = 960,
  [973] = 961,
  [974] = 960,
  [975] = 962,
  [976] = 962,
  [977] = 977,
  [978] = 978,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 982,
  [983] = 982,
  [984] = 981,
  [985] = 980,
  [986] = 981,
  [987] = 982,
  [988] = 980,
  [989] = 981,
  [990] = 980,
  [991] = 982,
  [992] = 992,
  [993] = 981,
  [994] = 980,
  [995] = 982,
  [996] = 982,
  [997] = 980,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 999,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 999,
  [1015] = 1015,
  [1016] = 999,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 998,
  [1023] = 1001,
  [1024] = 1003,
  [1025] = 1004,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1002,
  [1030] = 1030,
  [1031] = 1000,
  [1032] = 1009,
  [1033] = 1010,
  [1034] = 1011,
  [1035] = 1013,
  [1036] = 1015,
  [1037] = 1017,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1019,
  [1042] = 1020,
  [1043] = 1015,
  [1044] = 998,
  [1045] = 1001,
  [1046] = 1017,
  [1047] = 1047,
  [1048] = 1003,
  [1049] = 1004,
  [1050] = 1005,
  [1051] = 1007,
  [1052] = 1026,
  [1053] = 1027,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1019,
  [1057] = 1020,
  [1058] = 1015,
  [1059] = 998,
  [1060] = 1001,
  [1061] = 1003,
  [1062] = 1004,
  [1063] = 1017,
  [1064] = 1026,
  [1065] = 1027,
  [1066] = 1000,
  [1067] = 1009,
  [1068] = 1010,
  [1069] = 1011,
  [1070] = 1013,
  [1071] = 1015,
  [1072] = 1017,
  [1073] = 1026,
  [1074] = 1008,
  [1075] = 1005,
  [1076] = 1019,
  [1077] = 1020,
  [1078] = 1003,
  [1079] = 1005,
  [1080] = 1008,
  [1081] = 1026,
  [1082] = 1027,
  [1083] = 999,
  [1084] = 1000,
  [1085] = 1009,
  [1086] = 1010,
  [1087] = 1011,
  [1088] = 1005,
  [1089] = 1013,
  [1090] = 1019,
  [1091] = 1020,
  [1092] = 1015,
  [1093] = 1017,
  [1094] = 1019,
  [1095] = 1020,
  [1096] = 1003,
  [1097] = 1004,
  [1098] = 1026,
  [1099] = 1027,
  [1100] = 1100,
  [1101] = 998,
  [1102] = 1001,
  [1103] = 1012,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1027,
  [1108] = 1000,
  [1109] = 1009,
  [1110] = 1010,
  [1111] = 1011,
  [1112] = 1013,
  [1113] = 999,
  [1114] = 1100,
  [1115] = 1115,
  [1116] = 1039,
  [1117] = 1117,
  [1118] = 1115,
  [1119] = 1015,
  [1120] = 1017,
  [1121] = 1121,
  [1122] = 1019,
  [1123] = 1020,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 998,
  [1127] = 1001,
  [1128] = 1003,
  [1129] = 1004,
  [1130] = 1026,
  [1131] = 1027,
  [1132] = 1000,
  [1133] = 1009,
  [1134] = 1010,
  [1135] = 1011,
  [1136] = 1013,
  [1137] = 1005,
  [1138] = 998,
  [1139] = 1001,
  [1140] = 1000,
  [1141] = 1009,
  [1142] = 1010,
  [1143] = 1011,
  [1144] = 1013,
  [1145] = 1008,
  [1146] = 1005,
  [1147] = 1008,
  [1148] = 1008,
  [1149] = 1008,
  [1150] = 1004,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1151,
  [1154] = 1151,
  [1155] = 1151,
  [1156] = 1151,
  [1157] = 1151,
  [1158] = 1151,
  [1159] = 1151,
  [1160] = 1160,
  [1161] = 1151,
  [1162] = 1162,
  [1163] = 1151,
  [1164] = 1151,
  [1165] = 1151,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1168,
  [1170] = 1166,
  [1171] = 1167,
  [1172] = 1168,
  [1173] = 1167,
  [1174] = 1166,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1177,
  [1179] = 1179,
  [1180] = 1179,
  [1181] = 1177,
  [1182] = 1177,
  [1183] = 1177,
  [1184] = 1184,
  [1185] = 1184,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1187,
  [1189] = 1175,
  [1190] = 1186,
  [1191] = 1177,
  [1192] = 1176,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1177,
  [1201] = 1177,
  [1202] = 1202,
  [1203] = 1176,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 1177,
  [1208] = 1193,
  [1209] = 1193,
  [1210] = 1210,
  [1211] = 1177,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 790,
  [1217] = 1215,
  [1218] = 1218,
  [1219] = 1177,
  [1220] = 1220,
  [1221] = 773,
  [1222] = 1177,
  [1223] = 1218,
  [1224] = 1177,
  [1225] = 1220,
  [1226] = 1226,
  [1227] = 1215,
  [1228] = 1228,
  [1229] = 1226,
  [1230] = 1213,
  [1231] = 1176,
  [1232] = 1232,
  [1233] = 1226,
  [1234] = 1177,
  [1235] = 1235,
  [1236] = 1177,
  [1237] = 1213,
  [1238] = 1177,
  [1239] = 1177,
  [1240] = 1177,
  [1241] = 1177,
  [1242] = 1213,
  [1243] = 1175,
  [1244] = 1244,
  [1245] = 1196,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1213,
  [1250] = 1250,
  [1251] = 1250,
  [1252] = 1250,
  [1253] = 1253,
  [1254] = 1254,
  [1255] = 1255,
  [1256] = 1250,
  [1257] = 1257,
  [1258] = 1246,
  [1259] = 1259,
  [1260] = 1213,
  [1261] = 1250,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1213,
  [1266] = 1266,
  [1267] = 1250,
  [1268] = 1244,
  [1269] = 1213,
  [1270] = 1250,
  [1271] = 1177,
  [1272] = 1244,
  [1273] = 1250,
  [1274] = 1246,
  [1275] = 1250,
  [1276] = 1250,
  [1277] = 1213,
  [1278] = 1278,
  [1279] = 1213,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1206,
  [1284] = 1284,
  [1285] = 1246,
  [1286] = 1286,
  [1287] = 1205,
  [1288] = 1213,
  [1289] = 1289,
  [1290] = 1206,
  [1291] = 1278,
  [1292] = 1246,
  [1293] = 1280,
  [1294] = 1264,
  [1295] = 1289,
  [1296] = 1205,
  [1297] = 1297,
  [1298] = 1246,
  [1299] = 1299,
  [1300] = 1278,
  [1301] = 1213,
  [1302] = 1302,
  [1303] = 1264,
  [1304] = 1213,
  [1305] = 1305,
  [1306] = 1305,
  [1307] = 1213,
  [1308] = 1282,
  [1309] = 1264,
  [1310] = 1206,
  [1311] = 1210,
  [1312] = 1264,
  [1313] = 1313,
  [1314] = 1255,
  [1315] = 1278,
  [1316] = 1264,
  [1317] = 1204,
  [1318] = 1318,
  [1319] = 1194,
  [1320] = 1248,
  [1321] = 1321,
  [1322] = 1318,
  [1323] = 1289,
  [1324] = 1228,
  [1325] = 1228,
  [1326] = 1313,
  [1327] = 1321,
  [1328] = 1259,
  [1329] = 773,
  [1330] = 1305,
  [1331] = 1305,
  [1332] = 1212,
  [1333] = 1199,
  [1334] = 1305,
  [1335] = 790,
  [1336] = 1205,
  [1337] = 1246,
  [1338] = 1213,
  [1339] = 1198,
  [1340] = 1246,
  [1341] = 1289,
  [1342] = 1202,
  [1343] = 1305,
  [1344] = 1213,
  [1345] = 1289,
  [1346] = 1246,
  [1347] = 1289,
  [1348] = 1246,
  [1349] = 1349,
  [1350] = 1206,
  [1351] = 1281,
  [1352] = 1289,
  [1353] = 1228,
  [1354] = 1205,
  [1355] = 1355,
  [1356] = 1349,
  [1357] = 1302,
  [1358] = 1305,
  [1359] = 1264,
  [1360] = 1360,
  [1361] = 1289,
  [1362] = 1362,
  [1363] = 1263,
  [1364] = 1228,
  [1365] = 1205,
  [1366] = 1289,
  [1367] = 1289,
  [1368] = 1264,
  [1369] = 1369,
  [1370] = 1248,
  [1371] = 1264,
  [1372] = 1246,
  [1373] = 1305,
  [1374] = 1305,
  [1375] = 1259,
  [1376] = 1264,
  [1377] = 1305,
  [1378] = 1206,
  [1379] = 1379,
  [1380] = 1289,
  [1381] = 1228,
  [1382] = 1264,
  [1383] = 1383,
  [1384] = 1384,
  [1385] = 1205,
  [1386] = 1386,
  [1387] = 1379,
  [1388] = 1379,
  [1389] = 1379,
  [1390] = 1206,
  [1391] = 1228,
  [1392] = 1305,
  [1393] = 1259,
  [1394] = 1394,
  [1395] = 1248,
  [1396] = 1379,
  [1397] = 1397,
  [1398] = 1305,
  [1399] = 1302,
  [1400] = 1289,
  [1401] = 1379,
  [1402] = 1289,
  [1403] = 1289,
  [1404] = 1305,
  [1405] = 1305,
  [1406] = 1369,
  [1407] = 1305,
  [1408] = 1305,
  [1409] = 1305,
  [1410] = 1305,
  [1411] = 1255,
  [1412] = 1302,
  [1413] = 1289,
  [1414] = 1289,
  [1415] = 1289,
  [1416] = 1289,
  [1417] = 1228,
  [1418] = 1360,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1420,
  [1422] = 1419,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1289,
  [1427] = 1420,
  [1428] = 1425,
  [1429] = 1425,
  [1430] = 1420,
  [1431] = 1423,
  [1432] = 1423,
  [1433] = 1424,
  [1434] = 1420,
  [1435] = 1424,
  [1436] = 1425,
  [1437] = 1420,
  [1438] = 1423,
  [1439] = 1423,
  [1440] = 1419,
  [1441] = 1424,
  [1442] = 1420,
  [1443] = 1423,
  [1444] = 1419,
  [1445] = 1425,
  [1446] = 1420,
  [1447] = 1423,
  [1448] = 1281,
  [1449] = 1383,
  [1450] = 1423,
  [1451] = 1420,
  [1452] = 1423,
  [1453] = 1420,
  [1454] = 1423,
  [1455] = 1425,
  [1456] = 1424,
  [1457] = 1228,
  [1458] = 1419,
  [1459] = 1228,
  [1460] = 1305,
  [1461] = 1228,
  [1462] = 1424,
  [1463] = 1419,
  [1464] = 1464,
  [1465] = 1464,
  [1466] = 1464,
  [1467] = 1464,
  [1468] = 1464,
  [1469] = 1464,
  [1470] = 1464,
  [1471] = 1464,
  [1472] = 1464,
  [1473] = 1464,
  [1474] = 1474,
  [1475] = 1474,
  [1476] = 1474,
  [1477] = 1474,
  [1478] = 1474,
  [1479] = 1479,
  [1480] = 1474,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1482,
  [1484] = 1482,
  [1485] = 1485,
  [1486] = 1482,
  [1487] = 1487,
  [1488] = 1487,
  [1489] = 1481,
  [1490] = 1487,
  [1491] = 1487,
  [1492] = 1481,
  [1493] = 1482,
  [1494] = 1487,
  [1495] = 1481,
  [1496] = 1481,
  [1497] = 1497,
  [1498] = 1497,
  [1499] = 1497,
  [1500] = 1497,
  [1501] = 1497,
  [1502] = 1502,
  [1503] = 1497,
  [1504] = 243,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1510,
  [1511] = 244,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 207,
  [1516] = 979,
  [1517] = 1517,
  [1518] = 243,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 978,
  [1525] = 244,
  [1526] = 1526,
  [1527] = 977,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1162,
  [1539] = 1539,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 710,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1555,
  [1556] = 1556,
  [1557] = 713,
  [1558] = 1558,
  [1559] = 1559,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 711,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 714,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 226,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 211,
  [1604] = 211,
  [1605] = 213,
  [1606] = 209,
  [1607] = 1607,
  [1608] = 1608,
  [1609] = 229,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 1615,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 712,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 213,
  [1625] = 1625,
  [1626] = 209,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1152,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1160,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 227,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 234,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1709,
  [1710] = 240,
  [1711] = 241,
  [1712] = 1502,
  [1713] = 220,
  [1714] = 236,
  [1715] = 225,
  [1716] = 240,
  [1717] = 241,
  [1718] = 233,
  [1719] = 1689,
  [1720] = 1689,
  [1721] = 1689,
  [1722] = 1689,
  [1723] = 1723,
  [1724] = 1724,
  [1725] = 1725,
  [1726] = 229,
  [1727] = 1707,
  [1728] = 225,
  [1729] = 1706,
  [1730] = 226,
  [1731] = 1708,
  [1732] = 1509,
  [1733] = 1733,
  [1734] = 1510,
  [1735] = 233,
  [1736] = 1724,
  [1737] = 1506,
  [1738] = 1733,
  [1739] = 1505,
  [1740] = 1724,
  [1741] = 1741,
  [1742] = 1742,
  [1743] = 1743,
  [1744] = 1744,
  [1745] = 1745,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 227,
  [1753] = 1753,
  [1754] = 1754,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1760,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 234,
  [1769] = 1733,
  [1770] = 220,
  [1771] = 1771,
  [1772] = 1733,
  [1773] = 1773,
  [1774] = 1724,
  [1775] = 1733,
  [1776] = 236,
  [1777] = 1724,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1760,
  [1783] = 1779,
  [1784] = 1780,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1532,
  [1788] = 1520,
  [1789] = 1744,
  [1790] = 1517,
  [1791] = 1785,
  [1792] = 1745,
  [1793] = 1706,
  [1794] = 1746,
  [1795] = 1795,
  [1796] = 1747,
  [1797] = 1645,
  [1798] = 1707,
  [1799] = 1799,
  [1800] = 1708,
  [1801] = 977,
  [1802] = 1748,
  [1803] = 1803,
  [1804] = 1749,
  [1805] = 1750,
  [1806] = 1751,
  [1807] = 1781,
  [1808] = 1753,
  [1809] = 1754,
  [1810] = 1755,
  [1811] = 1756,
  [1812] = 1757,
  [1813] = 1813,
  [1814] = 1513,
  [1815] = 1514,
  [1816] = 1761,
  [1817] = 1817,
  [1818] = 1762,
  [1819] = 1763,
  [1820] = 1764,
  [1821] = 1765,
  [1822] = 1522,
  [1823] = 1521,
  [1824] = 1824,
  [1825] = 1785,
  [1826] = 1778,
  [1827] = 1817,
  [1828] = 1758,
  [1829] = 1759,
  [1830] = 1771,
  [1831] = 1785,
  [1832] = 1519,
  [1833] = 1512,
  [1834] = 1817,
  [1835] = 1785,
  [1836] = 1741,
  [1837] = 1741,
  [1838] = 1742,
  [1839] = 1743,
  [1840] = 1744,
  [1841] = 978,
  [1842] = 1745,
  [1843] = 1746,
  [1844] = 1747,
  [1845] = 1748,
  [1846] = 1749,
  [1847] = 1750,
  [1848] = 1751,
  [1849] = 1781,
  [1850] = 1753,
  [1851] = 1754,
  [1852] = 1755,
  [1853] = 1756,
  [1854] = 1757,
  [1855] = 1758,
  [1856] = 1759,
  [1857] = 1760,
  [1858] = 1761,
  [1859] = 1762,
  [1860] = 1763,
  [1861] = 1764,
  [1862] = 1765,
  [1863] = 1767,
  [1864] = 1645,
  [1865] = 1771,
  [1866] = 1817,
  [1867] = 1526,
  [1868] = 1868,
  [1869] = 1742,
  [1870] = 1743,
  [1871] = 1871,
  [1872] = 1872,
  [1873] = 979,
  [1874] = 1767,
  [1875] = 1778,
  [1876] = 1779,
  [1877] = 1780,
  [1878] = 1532,
  [1879] = 1879,
  [1880] = 1593,
  [1881] = 1594,
  [1882] = 1599,
  [1883] = 1152,
  [1884] = 207,
  [1885] = 1885,
  [1886] = 1803,
  [1887] = 1743,
  [1888] = 1745,
  [1889] = 1779,
  [1890] = 1746,
  [1891] = 1879,
  [1892] = 1747,
  [1893] = 1646,
  [1894] = 1780,
  [1895] = 1748,
  [1896] = 1896,
  [1897] = 1749,
  [1898] = 1750,
  [1899] = 1751,
  [1900] = 1781,
  [1901] = 1753,
  [1902] = 1754,
  [1903] = 1755,
  [1904] = 1756,
  [1905] = 1648,
  [1906] = 1757,
  [1907] = 1588,
  [1908] = 1758,
  [1909] = 1628,
  [1910] = 1595,
  [1911] = 1632,
  [1912] = 1637,
  [1913] = 1759,
  [1914] = 1760,
  [1915] = 1616,
  [1916] = 1916,
  [1917] = 1879,
  [1918] = 1647,
  [1919] = 1744,
  [1920] = 1771,
  [1921] = 1672,
  [1922] = 1868,
  [1923] = 1923,
  [1924] = 1778,
  [1925] = 207,
  [1926] = 1926,
  [1927] = 1761,
  [1928] = 1928,
  [1929] = 1614,
  [1930] = 1762,
  [1931] = 1617,
  [1932] = 1706,
  [1933] = 1763,
  [1934] = 1532,
  [1935] = 1643,
  [1936] = 1645,
  [1937] = 1592,
  [1938] = 1619,
  [1939] = 1634,
  [1940] = 1940,
  [1941] = 710,
  [1942] = 1639,
  [1943] = 1641,
  [1944] = 1944,
  [1945] = 1945,
  [1946] = 1946,
  [1947] = 1947,
  [1948] = 1879,
  [1949] = 1532,
  [1950] = 1645,
  [1951] = 1545,
  [1952] = 1622,
  [1953] = 1879,
  [1954] = 1532,
  [1955] = 1645,
  [1956] = 1709,
  [1957] = 1651,
  [1958] = 1672,
  [1959] = 1764,
  [1960] = 1765,
  [1961] = 1588,
  [1962] = 1962,
  [1963] = 1621,
  [1964] = 1964,
  [1965] = 711,
  [1966] = 1580,
  [1967] = 1587,
  [1968] = 1591,
  [1969] = 1608,
  [1970] = 1970,
  [1971] = 1971,
  [1972] = 1623,
  [1973] = 1629,
  [1974] = 1618,
  [1975] = 1741,
  [1976] = 1625,
  [1977] = 1977,
  [1978] = 1631,
  [1979] = 1633,
  [1980] = 1643,
  [1981] = 1709,
  [1982] = 1592,
  [1983] = 1651,
  [1984] = 1545,
  [1985] = 1535,
  [1986] = 1544,
  [1987] = 1550,
  [1988] = 1551,
  [1989] = 1574,
  [1990] = 1575,
  [1991] = 1597,
  [1992] = 1598,
  [1993] = 1601,
  [1994] = 1602,
  [1995] = 1995,
  [1996] = 1607,
  [1997] = 1610,
  [1998] = 1611,
  [1999] = 1162,
  [2000] = 1612,
  [2001] = 1613,
  [2002] = 1615,
  [2003] = 1885,
  [2004] = 1803,
  [2005] = 1531,
  [2006] = 1536,
  [2007] = 2007,
  [2008] = 1541,
  [2009] = 1542,
  [2010] = 1548,
  [2011] = 712,
  [2012] = 1627,
  [2013] = 1630,
  [2014] = 1635,
  [2015] = 1638,
  [2016] = 2016,
  [2017] = 1640,
  [2018] = 1644,
  [2019] = 1649,
  [2020] = 1529,
  [2021] = 1532,
  [2022] = 1530,
  [2023] = 1533,
  [2024] = 1534,
  [2025] = 1539,
  [2026] = 1645,
  [2027] = 1642,
  [2028] = 2028,
  [2029] = 1540,
  [2030] = 1543,
  [2031] = 1622,
  [2032] = 1546,
  [2033] = 1547,
  [2034] = 1553,
  [2035] = 1160,
  [2036] = 1554,
  [2037] = 1555,
  [2038] = 1964,
  [2039] = 1556,
  [2040] = 1767,
  [2041] = 1552,
  [2042] = 1558,
  [2043] = 1562,
  [2044] = 1563,
  [2045] = 1742,
  [2046] = 1581,
  [2047] = 713,
  [2048] = 1868,
  [2049] = 1559,
  [2050] = 1560,
  [2051] = 1561,
  [2052] = 1564,
  [2053] = 1565,
  [2054] = 1566,
  [2055] = 1567,
  [2056] = 1568,
  [2057] = 1569,
  [2058] = 1528,
  [2059] = 1571,
  [2060] = 1572,
  [2061] = 1573,
  [2062] = 1596,
  [2063] = 1600,
  [2064] = 714,
  [2065] = 1577,
  [2066] = 1707,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 1578,
  [2070] = 2070,
  [2071] = 1582,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 1583,
  [2075] = 1584,
  [2076] = 1708,
  [2077] = 1879,
  [2078] = 1585,
  [2079] = 1586,
  [2080] = 1589,
  [2081] = 1590,
  [2082] = 1741,
  [2083] = 1742,
  [2084] = 1743,
  [2085] = 1744,
  [2086] = 1745,
  [2087] = 1746,
  [2088] = 1747,
  [2089] = 1748,
  [2090] = 1749,
  [2091] = 1750,
  [2092] = 1751,
  [2093] = 1781,
  [2094] = 1753,
  [2095] = 1754,
  [2096] = 1755,
  [2097] = 1756,
  [2098] = 1757,
  [2099] = 1758,
  [2100] = 1759,
  [2101] = 1760,
  [2102] = 1761,
  [2103] = 1762,
  [2104] = 1763,
  [2105] = 1764,
  [2106] = 1765,
  [2107] = 1767,
  [2108] = 1778,
  [2109] = 1779,
  [2110] = 1780,
  [2111] = 1771,
  [2112] = 1537,
  [2113] = 2113,
  [2114] = 1666,
  [2115] = 1661,
  [2116] = 2116,
  [2117] = 1691,
  [2118] = 218,
  [2119] = 2119,
  [2120] = 1673,
  [2121] = 1674,
  [2122] = 2122,
  [2123] = 2123,
  [2124] = 1813,
  [2125] = 1704,
  [2126] = 1651,
  [2127] = 1675,
  [2128] = 2128,
  [2129] = 221,
  [2130] = 1652,
  [2131] = 1705,
  [2132] = 223,
  [2133] = 224,
  [2134] = 1676,
  [2135] = 2135,
  [2136] = 2136,
  [2137] = 1677,
  [2138] = 2138,
  [2139] = 2139,
  [2140] = 2140,
  [2141] = 1678,
  [2142] = 1709,
  [2143] = 2143,
  [2144] = 2144,
  [2145] = 1651,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2138,
  [2149] = 2149,
  [2150] = 2140,
  [2151] = 2151,
  [2152] = 2152,
  [2153] = 1545,
  [2154] = 1622,
  [2155] = 2155,
  [2156] = 2151,
  [2157] = 2152,
  [2158] = 1532,
  [2159] = 1645,
  [2160] = 1667,
  [2161] = 1532,
  [2162] = 1645,
  [2163] = 2151,
  [2164] = 2152,
  [2165] = 2151,
  [2166] = 2152,
  [2167] = 1668,
  [2168] = 2151,
  [2169] = 2152,
  [2170] = 1896,
  [2171] = 1662,
  [2172] = 1654,
  [2173] = 1655,
  [2174] = 2174,
  [2175] = 2175,
  [2176] = 1824,
  [2177] = 2136,
  [2178] = 2178,
  [2179] = 2179,
  [2180] = 2180,
  [2181] = 1741,
  [2182] = 2182,
  [2183] = 1742,
  [2184] = 1743,
  [2185] = 1744,
  [2186] = 1679,
  [2187] = 2187,
  [2188] = 1656,
  [2189] = 1745,
  [2190] = 1746,
  [2191] = 1747,
  [2192] = 2192,
  [2193] = 1748,
  [2194] = 2194,
  [2195] = 1749,
  [2196] = 1750,
  [2197] = 1751,
  [2198] = 1781,
  [2199] = 1753,
  [2200] = 1754,
  [2201] = 1755,
  [2202] = 1756,
  [2203] = 1757,
  [2204] = 1758,
  [2205] = 1759,
  [2206] = 1760,
  [2207] = 1761,
  [2208] = 1762,
  [2209] = 1763,
  [2210] = 1764,
  [2211] = 1765,
  [2212] = 2212,
  [2213] = 2213,
  [2214] = 2214,
  [2215] = 1767,
  [2216] = 217,
  [2217] = 232,
  [2218] = 2218,
  [2219] = 2219,
  [2220] = 2220,
  [2221] = 1868,
  [2222] = 1663,
  [2223] = 235,
  [2224] = 2224,
  [2225] = 1653,
  [2226] = 2226,
  [2227] = 2227,
  [2228] = 2228,
  [2229] = 2229,
  [2230] = 2230,
  [2231] = 2231,
  [2232] = 237,
  [2233] = 2233,
  [2234] = 1681,
  [2235] = 1682,
  [2236] = 2236,
  [2237] = 1683,
  [2238] = 1684,
  [2239] = 1685,
  [2240] = 1686,
  [2241] = 2192,
  [2242] = 1687,
  [2243] = 219,
  [2244] = 230,
  [2245] = 1688,
  [2246] = 2246,
  [2247] = 2247,
  [2248] = 2192,
  [2249] = 1868,
  [2250] = 1643,
  [2251] = 2192,
  [2252] = 1592,
  [2253] = 1651,
  [2254] = 1658,
  [2255] = 1709,
  [2256] = 2192,
  [2257] = 2257,
  [2258] = 2192,
  [2259] = 1778,
  [2260] = 1779,
  [2261] = 1780,
  [2262] = 1771,
  [2263] = 238,
  [2264] = 2264,
  [2265] = 2214,
  [2266] = 1690,
  [2267] = 2138,
  [2268] = 2140,
  [2269] = 228,
  [2270] = 1803,
  [2271] = 1672,
  [2272] = 2138,
  [2273] = 1723,
  [2274] = 2212,
  [2275] = 2140,
  [2276] = 219,
  [2277] = 230,
  [2278] = 238,
  [2279] = 1692,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2285,
  [2286] = 2149,
  [2287] = 2174,
  [2288] = 218,
  [2289] = 221,
  [2290] = 223,
  [2291] = 1693,
  [2292] = 1694,
  [2293] = 1695,
  [2294] = 1696,
  [2295] = 224,
  [2296] = 1659,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2281,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2304,
  [2305] = 2305,
  [2306] = 217,
  [2307] = 2282,
  [2308] = 2308,
  [2309] = 1868,
  [2310] = 2310,
  [2311] = 232,
  [2312] = 235,
  [2313] = 237,
  [2314] = 2314,
  [2315] = 1697,
  [2316] = 2316,
  [2317] = 2317,
  [2318] = 2318,
  [2319] = 2319,
  [2320] = 1669,
  [2321] = 2321,
  [2322] = 2322,
  [2323] = 2323,
  [2324] = 2324,
  [2325] = 1670,
  [2326] = 1660,
  [2327] = 1698,
  [2328] = 2128,
  [2329] = 1699,
  [2330] = 1700,
  [2331] = 1701,
  [2332] = 1702,
  [2333] = 1703,
  [2334] = 2138,
  [2335] = 2140,
  [2336] = 2336,
  [2337] = 2283,
  [2338] = 2284,
  [2339] = 2339,
  [2340] = 1588,
  [2341] = 2175,
  [2342] = 2301,
  [2343] = 2285,
  [2344] = 228,
  [2345] = 2138,
  [2346] = 2140,
  [2347] = 2192,
  [2348] = 1824,
  [2349] = 2349,
  [2350] = 1671,
  [2351] = 1709,
  [2352] = 2352,
  [2353] = 2257,
  [2354] = 1795,
  [2355] = 2194,
  [2356] = 1665,
  [2357] = 2357,
  [2358] = 2358,
  [2359] = 1588,
  [2360] = 2360,
  [2361] = 2233,
  [2362] = 1657,
  [2363] = 1764,
  [2364] = 1741,
  [2365] = 1742,
  [2366] = 1743,
  [2367] = 1744,
  [2368] = 1745,
  [2369] = 1746,
  [2370] = 1747,
  [2371] = 1748,
  [2372] = 1749,
  [2373] = 1750,
  [2374] = 1751,
  [2375] = 1781,
  [2376] = 1753,
  [2377] = 1754,
  [2378] = 1755,
  [2379] = 1756,
  [2380] = 1757,
  [2381] = 1758,
  [2382] = 1759,
  [2383] = 1760,
  [2384] = 1761,
  [2385] = 1762,
  [2386] = 1763,
  [2387] = 1765,
  [2388] = 1767,
  [2389] = 1592,
  [2390] = 239,
  [2391] = 1741,
  [2392] = 1742,
  [2393] = 1743,
  [2394] = 1744,
  [2395] = 1745,
  [2396] = 1746,
  [2397] = 1747,
  [2398] = 1748,
  [2399] = 1749,
  [2400] = 1750,
  [2401] = 1751,
  [2402] = 1781,
  [2403] = 1753,
  [2404] = 1754,
  [2405] = 1755,
  [2406] = 1756,
  [2407] = 1757,
  [2408] = 1758,
  [2409] = 1759,
  [2410] = 1760,
  [2411] = 1761,
  [2412] = 1762,
  [2413] = 1763,
  [2414] = 1764,
  [2415] = 1765,
  [2416] = 1767,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 2419,
  [2420] = 2420,
  [2421] = 2421,
  [2422] = 2323,
  [2423] = 2423,
  [2424] = 1709,
  [2425] = 1672,
  [2426] = 2426,
  [2427] = 2427,
  [2428] = 2423,
  [2429] = 2429,
  [2430] = 2419,
  [2431] = 1651,
  [2432] = 1824,
  [2433] = 2417,
  [2434] = 2434,
  [2435] = 1707,
  [2436] = 2419,
  [2437] = 2437,
  [2438] = 1545,
  [2439] = 2439,
  [2440] = 2440,
  [2441] = 2441,
  [2442] = 2434,
  [2443] = 2443,
  [2444] = 1622,
  [2445] = 2445,
  [2446] = 2446,
  [2447] = 2447,
  [2448] = 2448,
  [2449] = 1706,
  [2450] = 1778,
  [2451] = 1643,
  [2452] = 1780,
  [2453] = 1771,
  [2454] = 1707,
  [2455] = 2455,
  [2456] = 2456,
  [2457] = 2457,
  [2458] = 1778,
  [2459] = 1779,
  [2460] = 1780,
  [2461] = 1771,
  [2462] = 2462,
  [2463] = 1708,
  [2464] = 1532,
  [2465] = 1799,
  [2466] = 1645,
  [2467] = 2467,
  [2468] = 1622,
  [2469] = 2469,
  [2470] = 239,
  [2471] = 2419,
  [2472] = 1896,
  [2473] = 2473,
  [2474] = 2474,
  [2475] = 2475,
  [2476] = 2476,
  [2477] = 2419,
  [2478] = 2420,
  [2479] = 2455,
  [2480] = 1813,
  [2481] = 2481,
  [2482] = 1868,
  [2483] = 2419,
  [2484] = 2481,
  [2485] = 2485,
  [2486] = 1896,
  [2487] = 1868,
  [2488] = 2488,
  [2489] = 1795,
  [2490] = 1741,
  [2491] = 1742,
  [2492] = 1743,
  [2493] = 1744,
  [2494] = 1745,
  [2495] = 1746,
  [2496] = 1747,
  [2497] = 1748,
  [2498] = 1749,
  [2499] = 1750,
  [2500] = 1751,
  [2501] = 1781,
  [2502] = 1753,
  [2503] = 1754,
  [2504] = 1755,
  [2505] = 1756,
  [2506] = 1757,
  [2507] = 1758,
  [2508] = 1759,
  [2509] = 1760,
  [2510] = 1761,
  [2511] = 1762,
  [2512] = 1763,
  [2513] = 1764,
  [2514] = 1765,
  [2515] = 1767,
  [2516] = 1545,
  [2517] = 1588,
  [2518] = 1778,
  [2519] = 1779,
  [2520] = 1780,
  [2521] = 1771,
  [2522] = 2522,
  [2523] = 2473,
  [2524] = 1672,
  [2525] = 1868,
  [2526] = 1588,
  [2527] = 1868,
  [2528] = 1779,
  [2529] = 1757,
  [2530] = 2530,
  [2531] = 2531,
  [2532] = 2532,
  [2533] = 2533,
  [2534] = 1545,
  [2535] = 2535,
  [2536] = 2536,
  [2537] = 2537,
  [2538] = 2538,
  [2539] = 1622,
  [2540] = 2540,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 1778,
  [2544] = 1779,
  [2545] = 1780,
  [2546] = 1771,
  [2547] = 1709,
  [2548] = 2548,
  [2549] = 2549,
  [2550] = 1741,
  [2551] = 2551,
  [2552] = 2552,
  [2553] = 2538,
  [2554] = 1742,
  [2555] = 1743,
  [2556] = 1744,
  [2557] = 1745,
  [2558] = 1746,
  [2559] = 2559,
  [2560] = 1747,
  [2561] = 1748,
  [2562] = 2562,
  [2563] = 1749,
  [2564] = 1651,
  [2565] = 2538,
  [2566] = 1750,
  [2567] = 1751,
  [2568] = 1781,
  [2569] = 1753,
  [2570] = 1754,
  [2571] = 1755,
  [2572] = 2538,
  [2573] = 2573,
  [2574] = 1707,
  [2575] = 2538,
  [2576] = 1708,
  [2577] = 1756,
  [2578] = 1758,
  [2579] = 2538,
  [2580] = 1759,
  [2581] = 2538,
  [2582] = 1588,
  [2583] = 2583,
  [2584] = 2584,
  [2585] = 2585,
  [2586] = 1760,
  [2587] = 1813,
  [2588] = 1761,
  [2589] = 2538,
  [2590] = 2590,
  [2591] = 2591,
  [2592] = 977,
  [2593] = 1896,
  [2594] = 1762,
  [2595] = 1763,
  [2596] = 2538,
  [2597] = 1672,
  [2598] = 1764,
  [2599] = 2599,
  [2600] = 2600,
  [2601] = 2601,
  [2602] = 978,
  [2603] = 1868,
  [2604] = 979,
  [2605] = 2600,
  [2606] = 1672,
  [2607] = 1765,
  [2608] = 1767,
  [2609] = 2609,
  [2610] = 2538,
  [2611] = 2611,
  [2612] = 1706,
  [2613] = 2613,
  [2614] = 2614,
  [2615] = 2615,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2151,
  [2619] = 2151,
  [2620] = 2152,
  [2621] = 2151,
  [2622] = 2152,
  [2623] = 2623,
  [2624] = 2624,
  [2625] = 2475,
  [2626] = 2626,
  [2627] = 2627,
  [2628] = 2152,
  [2629] = 2629,
  [2630] = 2152,
  [2631] = 1824,
  [2632] = 2632,
  [2633] = 2633,
  [2634] = 2151,
  [2635] = 2152,
  [2636] = 2636,
  [2637] = 2637,
  [2638] = 2615,
  [2639] = 2639,
  [2640] = 2640,
  [2641] = 2151,
  [2642] = 2642,
  [2643] = 2643,
  [2644] = 2644,
  [2645] = 2645,
  [2646] = 1588,
  [2647] = 2647,
  [2648] = 1588,
  [2649] = 1588,
  [2650] = 2152,
  [2651] = 2151,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 226,
  [2656] = 2656,
  [2657] = 226,
  [2658] = 2658,
  [2659] = 2659,
  [2660] = 2654,
  [2661] = 2661,
  [2662] = 229,
  [2663] = 1299,
  [2664] = 2664,
  [2665] = 2654,
  [2666] = 2654,
  [2667] = 2654,
  [2668] = 2668,
  [2669] = 2669,
  [2670] = 2670,
  [2671] = 2671,
  [2672] = 2672,
  [2673] = 2673,
  [2674] = 2674,
  [2675] = 2675,
  [2676] = 2676,
  [2677] = 2677,
  [2678] = 2678,
  [2679] = 2654,
  [2680] = 2680,
  [2681] = 2681,
  [2682] = 2682,
  [2683] = 2683,
  [2684] = 2684,
  [2685] = 2685,
  [2686] = 1621,
  [2687] = 2687,
  [2688] = 2688,
  [2689] = 2689,
  [2690] = 2690,
  [2691] = 2691,
  [2692] = 2692,
  [2693] = 2693,
  [2694] = 225,
  [2695] = 229,
  [2696] = 2696,
  [2697] = 2697,
  [2698] = 2698,
  [2699] = 2699,
  [2700] = 2654,
  [2701] = 233,
  [2702] = 2702,
  [2703] = 2703,
  [2704] = 2704,
  [2705] = 2705,
  [2706] = 2654,
  [2707] = 2707,
  [2708] = 1247,
  [2709] = 2709,
  [2710] = 2710,
  [2711] = 2711,
  [2712] = 2712,
  [2713] = 2654,
  [2714] = 2654,
  [2715] = 2715,
  [2716] = 2716,
  [2717] = 2717,
  [2718] = 2718,
  [2719] = 2535,
  [2720] = 1642,
  [2721] = 2721,
  [2722] = 2722,
  [2723] = 2723,
  [2724] = 2533,
  [2725] = 2725,
  [2726] = 233,
  [2727] = 225,
  [2728] = 2728,
  [2729] = 2729,
  [2730] = 2730,
  [2731] = 2264,
  [2732] = 2732,
  [2733] = 2733,
  [2734] = 2734,
  [2735] = 2220,
  [2736] = 2736,
  [2737] = 2231,
  [2738] = 2738,
  [2739] = 2122,
  [2740] = 2740,
  [2741] = 2741,
  [2742] = 2742,
  [2743] = 2462,
  [2744] = 2744,
  [2745] = 2473,
  [2746] = 2746,
  [2747] = 2429,
  [2748] = 1262,
  [2749] = 2488,
  [2750] = 2750,
  [2751] = 2751,
  [2752] = 2474,
  [2753] = 2753,
  [2754] = 2473,
  [2755] = 2455,
  [2756] = 2481,
  [2757] = 2750,
  [2758] = 2485,
  [2759] = 2420,
  [2760] = 2437,
  [2761] = 2761,
  [2762] = 2418,
  [2763] = 2481,
  [2764] = 2426,
  [2765] = 2447,
  [2766] = 2455,
  [2767] = 2426,
  [2768] = 2474,
  [2769] = 2485,
  [2770] = 2447,
  [2771] = 2751,
  [2772] = 2420,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 2777,
  [2778] = 2778,
  [2779] = 2775,
  [2780] = 2776,
  [2781] = 2781,
  [2782] = 2782,
  [2783] = 2783,
  [2784] = 2778,
  [2785] = 2785,
  [2786] = 2778,
  [2787] = 2787,
  [2788] = 2785,
  [2789] = 2774,
  [2790] = 2777,
  [2791] = 2791,
  [2792] = 2791,
  [2793] = 2793,
  [2794] = 2794,
  [2795] = 2795,
  [2796] = 1284,
  [2797] = 2797,
  [2798] = 2798,
  [2799] = 2799,
  [2800] = 2800,
  [2801] = 2801,
  [2802] = 1266,
  [2803] = 2427,
  [2804] = 2804,
  [2805] = 2805,
  [2806] = 2806,
  [2807] = 2807,
  [2808] = 1297,
  [2809] = 2809,
  [2810] = 2810,
  [2811] = 1286,
  [2812] = 1253,
  [2813] = 2813,
  [2814] = 2814,
  [2815] = 2815,
  [2816] = 2816,
  [2817] = 2817,
  [2818] = 2818,
  [2819] = 2819,
  [2820] = 2820,
  [2821] = 2821,
  [2822] = 2822,
  [2823] = 2823,
  [2824] = 2824,
  [2825] = 2825,
  [2826] = 2826,
  [2827] = 2823,
  [2828] = 2828,
  [2829] = 2829,
  [2830] = 2830,
  [2831] = 2818,
  [2832] = 2832,
  [2833] = 2833,
  [2834] = 2834,
  [2835] = 2835,
  [2836] = 2828,
  [2837] = 2837,
  [2838] = 2838,
  [2839] = 2839,
  [2840] = 2840,
  [2841] = 2841,
  [2842] = 2842,
  [2843] = 2843,
  [2844] = 2844,
  [2845] = 2845,
  [2846] = 2846,
  [2847] = 2847,
  [2848] = 2848,
  [2849] = 2849,
  [2850] = 2850,
  [2851] = 2851,
  [2852] = 2852,
  [2853] = 2839,
  [2854] = 2854,
  [2855] = 2850,
  [2856] = 2830,
  [2857] = 2857,
  [2858] = 2824,
  [2859] = 2826,
  [2860] = 2835,
  [2861] = 2834,
  [2862] = 2851,
  [2863] = 2863,
  [2864] = 2819,
  [2865] = 2865,
  [2866] = 2866,
  [2867] = 2867,
  [2868] = 2868,
  [2869] = 2869,
  [2870] = 2870,
  [2871] = 2871,
  [2872] = 2872,
  [2873] = 2873,
  [2874] = 2874,
  [2875] = 2875,
  [2876] = 2876,
  [2877] = 2877,
  [2878] = 2878,
  [2879] = 2879,
  [2880] = 1505,
  [2881] = 1509,
  [2882] = 1506,
  [2883] = 1640,
  [2884] = 1638,
  [2885] = 1644,
  [2886] = 1649,
  [2887] = 1529,
  [2888] = 1530,
  [2889] = 1533,
  [2890] = 1534,
  [2891] = 1539,
  [2892] = 1540,
  [2893] = 1543,
  [2894] = 1578,
  [2895] = 1569,
  [2896] = 1590,
  [2897] = 1593,
  [2898] = 1567,
  [2899] = 1582,
  [2900] = 1635,
  [2901] = 1583,
  [2902] = 1584,
  [2903] = 1568,
  [2904] = 1585,
  [2905] = 1559,
  [2906] = 1560,
  [2907] = 1577,
  [2908] = 1561,
  [2909] = 1564,
  [2910] = 1565,
  [2911] = 1586,
  [2912] = 1589,
  [2913] = 1566,
  [2914] = 1627,
  [2915] = 1630,
  [2916] = 1528,
  [2917] = 243,
  [2918] = 244,
  [2919] = 1580,
  [2920] = 1510,
  [2921] = 1607,
  [2922] = 1623,
  [2923] = 1610,
  [2924] = 1631,
  [2925] = 1611,
  [2926] = 1505,
  [2927] = 1618,
  [2928] = 2928,
  [2929] = 1575,
  [2930] = 1551,
  [2931] = 1506,
  [2932] = 1597,
  [2933] = 1574,
  [2934] = 1517,
  [2935] = 1591,
  [2936] = 1602,
  [2937] = 1509,
  [2938] = 1600,
  [2939] = 1522,
  [2940] = 1581,
  [2941] = 1521,
  [2942] = 1526,
  [2943] = 1520,
  [2944] = 1648,
  [2945] = 2945,
  [2946] = 1590,
  [2947] = 1593,
  [2948] = 1596,
  [2949] = 2949,
  [2950] = 2950,
  [2951] = 2945,
  [2952] = 2952,
  [2953] = 1614,
  [2954] = 1587,
  [2955] = 1509,
  [2956] = 1506,
  [2957] = 1505,
  [2958] = 2958,
  [2959] = 2949,
  [2960] = 2950,
  [2961] = 2952,
  [2962] = 1558,
  [2963] = 1627,
  [2964] = 1608,
  [2965] = 1630,
  [2966] = 1629,
  [2967] = 1635,
  [2968] = 1638,
  [2969] = 2958,
  [2970] = 1640,
  [2971] = 1644,
  [2972] = 1649,
  [2973] = 1529,
  [2974] = 1628,
  [2975] = 1530,
  [2976] = 1533,
  [2977] = 2949,
  [2978] = 2950,
  [2979] = 2945,
  [2980] = 2952,
  [2981] = 1534,
  [2982] = 1539,
  [2983] = 1540,
  [2984] = 2958,
  [2985] = 1633,
  [2986] = 1543,
  [2987] = 2949,
  [2988] = 2950,
  [2989] = 2945,
  [2990] = 2952,
  [2991] = 1594,
  [2992] = 2949,
  [2993] = 1563,
  [2994] = 2950,
  [2995] = 1548,
  [2996] = 2945,
  [2997] = 1571,
  [2998] = 1572,
  [2999] = 2952,
  [3000] = 1542,
  [3001] = 2958,
  [3002] = 1546,
  [3003] = 1547,
  [3004] = 1554,
  [3005] = 1555,
  [3006] = 2958,
  [3007] = 1559,
  [3008] = 1560,
  [3009] = 1561,
  [3010] = 2958,
  [3011] = 1564,
  [3012] = 2958,
  [3013] = 1619,
  [3014] = 1595,
  [3015] = 1625,
  [3016] = 1535,
  [3017] = 1544,
  [3018] = 1616,
  [3019] = 1565,
  [3020] = 1550,
  [3021] = 1566,
  [3022] = 1567,
  [3023] = 1568,
  [3024] = 1569,
  [3025] = 1598,
  [3026] = 1528,
  [3027] = 1510,
  [3028] = 1577,
  [3029] = 1531,
  [3030] = 1612,
  [3031] = 1647,
  [3032] = 1536,
  [3033] = 2958,
  [3034] = 1578,
  [3035] = 1615,
  [3036] = 2958,
  [3037] = 2958,
  [3038] = 1582,
  [3039] = 1583,
  [3040] = 1584,
  [3041] = 1541,
  [3042] = 1634,
  [3043] = 1585,
  [3044] = 1586,
  [3045] = 1589,
  [3046] = 1573,
  [3047] = 3047,
  [3048] = 3048,
  [3049] = 3048,
  [3050] = 3050,
  [3051] = 3051,
  [3052] = 3048,
  [3053] = 3053,
  [3054] = 3054,
  [3055] = 3055,
  [3056] = 3056,
  [3057] = 3053,
  [3058] = 3058,
  [3059] = 3059,
  [3060] = 1513,
  [3061] = 3048,
  [3062] = 1514,
  [3063] = 3063,
  [3064] = 3048,
  [3065] = 3048,
  [3066] = 3066,
  [3067] = 3067,
  [3068] = 3068,
  [3069] = 3053,
  [3070] = 3070,
  [3071] = 3071,
  [3072] = 3072,
  [3073] = 1526,
  [3074] = 3074,
  [3075] = 3053,
  [3076] = 3076,
  [3077] = 3077,
  [3078] = 3078,
  [3079] = 3079,
  [3080] = 3080,
  [3081] = 3053,
  [3082] = 1517,
  [3083] = 1519,
  [3084] = 3084,
  [3085] = 3085,
  [3086] = 3086,
  [3087] = 3048,
  [3088] = 1602,
  [3089] = 1584,
  [3090] = 1585,
  [3091] = 1586,
  [3092] = 1589,
  [3093] = 1590,
  [3094] = 1593,
  [3095] = 1627,
  [3096] = 1630,
  [3097] = 1635,
  [3098] = 3098,
  [3099] = 3099,
  [3100] = 1510,
  [3101] = 1638,
  [3102] = 1552,
  [3103] = 978,
  [3104] = 1597,
  [3105] = 1540,
  [3106] = 1591,
  [3107] = 3107,
  [3108] = 3108,
  [3109] = 1640,
  [3110] = 3110,
  [3111] = 1644,
  [3112] = 1553,
  [3113] = 1649,
  [3114] = 1529,
  [3115] = 1607,
  [3116] = 1560,
  [3117] = 3117,
  [3118] = 1561,
  [3119] = 1610,
  [3120] = 1611,
  [3121] = 1601,
  [3122] = 1564,
  [3123] = 1631,
  [3124] = 3124,
  [3125] = 1623,
  [3126] = 1530,
  [3127] = 1533,
  [3128] = 1580,
  [3129] = 1613,
  [3130] = 1539,
  [3131] = 1521,
  [3132] = 1565,
  [3133] = 3133,
  [3134] = 979,
  [3135] = 3135,
  [3136] = 1551,
  [3137] = 1566,
  [3138] = 1639,
  [3139] = 1641,
  [3140] = 1567,
  [3141] = 1574,
  [3142] = 1568,
  [3143] = 977,
  [3144] = 1569,
  [3145] = 1537,
  [3146] = 1575,
  [3147] = 1528,
  [3148] = 1543,
  [3149] = 1556,
  [3150] = 1559,
  [3151] = 1577,
  [3152] = 1578,
  [3153] = 1562,
  [3154] = 1618,
  [3155] = 1582,
  [3156] = 3156,
  [3157] = 1583,
  [3158] = 3158,
  [3159] = 1599,
  [3160] = 1534,
  [3161] = 243,
  [3162] = 3162,
  [3163] = 3163,
  [3164] = 1581,
  [3165] = 3165,
  [3166] = 3166,
  [3167] = 3167,
  [3168] = 1152,
  [3169] = 1600,
  [3170] = 3170,
  [3171] = 1509,
  [3172] = 1506,
  [3173] = 3173,
  [3174] = 1505,
  [3175] = 1513,
  [3176] = 3176,
  [3177] = 3177,
  [3178] = 3178,
  [3179] = 3179,
  [3180] = 3180,
  [3181] = 3181,
  [3182] = 1162,
  [3183] = 3183,
  [3184] = 1514,
  [3185] = 3185,
  [3186] = 1519,
  [3187] = 3187,
  [3188] = 3188,
  [3189] = 3189,
  [3190] = 1160,
  [3191] = 3191,
  [3192] = 3192,
  [3193] = 3193,
  [3194] = 3194,
  [3195] = 3195,
  [3196] = 3196,
  [3197] = 3197,
  [3198] = 3198,
  [3199] = 3199,
  [3200] = 1526,
  [3201] = 3201,
  [3202] = 3202,
  [3203] = 3203,
  [3204] = 3198,
  [3205] = 244,
  [3206] = 3206,
  [3207] = 3207,
  [3208] = 1522,
  [3209] = 1648,
  [3210] = 3198,
  [3211] = 3198,
  [3212] = 3198,
  [3213] = 1520,
  [3214] = 3214,
  [3215] = 3215,
  [3216] = 3216,
  [3217] = 1517,
  [3218] = 3218,
  [3219] = 3219,
  [3220] = 3220,
  [3221] = 1623,
  [3222] = 1633,
  [3223] = 1594,
  [3224] = 1599,
  [3225] = 1612,
  [3226] = 1613,
  [3227] = 1580,
  [3228] = 1615,
  [3229] = 1634,
  [3230] = 1551,
  [3231] = 1591,
  [3232] = 979,
  [3233] = 1536,
  [3234] = 1574,
  [3235] = 1639,
  [3236] = 3236,
  [3237] = 712,
  [3238] = 1537,
  [3239] = 1596,
  [3240] = 977,
  [3241] = 1575,
  [3242] = 1541,
  [3243] = 1597,
  [3244] = 711,
  [3245] = 1602,
  [3246] = 1607,
  [3247] = 1542,
  [3248] = 1587,
  [3249] = 1610,
  [3250] = 1510,
  [3251] = 1548,
  [3252] = 1521,
  [3253] = 3253,
  [3254] = 1552,
  [3255] = 1608,
  [3256] = 1558,
  [3257] = 1629,
  [3258] = 1562,
  [3259] = 1535,
  [3260] = 1546,
  [3261] = 978,
  [3262] = 1547,
  [3263] = 1544,
  [3264] = 1563,
  [3265] = 1614,
  [3266] = 1571,
  [3267] = 1572,
  [3268] = 1619,
  [3269] = 1625,
  [3270] = 1641,
  [3271] = 1573,
  [3272] = 1628,
  [3273] = 1595,
  [3274] = 1616,
  [3275] = 1647,
  [3276] = 1550,
  [3277] = 1553,
  [3278] = 3278,
  [3279] = 3279,
  [3280] = 1554,
  [3281] = 714,
  [3282] = 3220,
  [3283] = 1598,
  [3284] = 713,
  [3285] = 1555,
  [3286] = 1601,
  [3287] = 1618,
  [3288] = 1531,
  [3289] = 1556,
  [3290] = 1631,
  [3291] = 710,
  [3292] = 1611,
  [3293] = 3293,
  [3294] = 3294,
  [3295] = 1648,
  [3296] = 1520,
  [3297] = 1600,
  [3298] = 3298,
  [3299] = 3299,
  [3300] = 1581,
  [3301] = 3301,
  [3302] = 3302,
  [3303] = 3303,
  [3304] = 3304,
  [3305] = 1522,
  [3306] = 1513,
  [3307] = 3307,
  [3308] = 3308,
  [3309] = 3309,
  [3310] = 3310,
  [3311] = 3311,
  [3312] = 3312,
  [3313] = 3294,
  [3314] = 3310,
  [3315] = 1526,
  [3316] = 1519,
  [3317] = 1510,
  [3318] = 1514,
  [3319] = 3293,
  [3320] = 3302,
  [3321] = 3294,
  [3322] = 3322,
  [3323] = 3293,
  [3324] = 3324,
  [3325] = 3325,
  [3326] = 3326,
  [3327] = 3327,
  [3328] = 711,
  [3329] = 3329,
  [3330] = 3330,
  [3331] = 3331,
  [3332] = 1639,
  [3333] = 1162,
  [3334] = 1526,
  [3335] = 3335,
  [3336] = 1558,
  [3337] = 1641,
  [3338] = 3338,
  [3339] = 3339,
  [3340] = 3340,
  [3341] = 3341,
  [3342] = 1571,
  [3343] = 1612,
  [3344] = 1572,
  [3345] = 3345,
  [3346] = 1573,
  [3347] = 714,
  [3348] = 3348,
  [3349] = 3349,
  [3350] = 1613,
  [3351] = 3198,
  [3352] = 1615,
  [3353] = 3198,
  [3354] = 1596,
  [3355] = 3355,
  [3356] = 712,
  [3357] = 3357,
  [3358] = 1594,
  [3359] = 1599,
  [3360] = 3198,
  [3361] = 3361,
  [3362] = 243,
  [3363] = 3363,
  [3364] = 3364,
  [3365] = 3307,
  [3366] = 1614,
  [3367] = 3367,
  [3368] = 3368,
  [3369] = 1619,
  [3370] = 3370,
  [3371] = 1562,
  [3372] = 244,
  [3373] = 1517,
  [3374] = 1625,
  [3375] = 3312,
  [3376] = 3376,
  [3377] = 3377,
  [3378] = 1152,
  [3379] = 3379,
  [3380] = 1535,
  [3381] = 3381,
  [3382] = 3361,
  [3383] = 3301,
  [3384] = 1628,
  [3385] = 1595,
  [3386] = 3386,
  [3387] = 1152,
  [3388] = 1616,
  [3389] = 1647,
  [3390] = 3390,
  [3391] = 3381,
  [3392] = 3392,
  [3393] = 3393,
  [3394] = 1587,
  [3395] = 3395,
  [3396] = 1162,
  [3397] = 3397,
  [3398] = 3398,
  [3399] = 1160,
  [3400] = 3400,
  [3401] = 1544,
  [3402] = 1550,
  [3403] = 3403,
  [3404] = 1548,
  [3405] = 3405,
  [3406] = 3406,
  [3407] = 3198,
  [3408] = 3386,
  [3409] = 3409,
  [3410] = 3410,
  [3411] = 3411,
  [3412] = 1552,
  [3413] = 3413,
  [3414] = 3198,
  [3415] = 1608,
  [3416] = 3416,
  [3417] = 3417,
  [3418] = 3418,
  [3419] = 3381,
  [3420] = 3420,
  [3421] = 3421,
  [3422] = 1546,
  [3423] = 1547,
  [3424] = 3424,
  [3425] = 3425,
  [3426] = 1553,
  [3427] = 3427,
  [3428] = 3198,
  [3429] = 1160,
  [3430] = 3430,
  [3431] = 3431,
  [3432] = 1554,
  [3433] = 3433,
  [3434] = 1555,
  [3435] = 3435,
  [3436] = 3420,
  [3437] = 1563,
  [3438] = 3438,
  [3439] = 1629,
  [3440] = 3440,
  [3441] = 1247,
  [3442] = 1556,
  [3443] = 3392,
  [3444] = 3444,
  [3445] = 710,
  [3446] = 3446,
  [3447] = 1598,
  [3448] = 3420,
  [3449] = 1601,
  [3450] = 3450,
  [3451] = 1634,
  [3452] = 3395,
  [3453] = 3376,
  [3454] = 3454,
  [3455] = 3363,
  [3456] = 3456,
  [3457] = 3457,
  [3458] = 713,
  [3459] = 3459,
  [3460] = 3460,
  [3461] = 3461,
  [3462] = 1633,
  [3463] = 1531,
  [3464] = 1536,
  [3465] = 3465,
  [3466] = 1537,
  [3467] = 1541,
  [3468] = 3468,
  [3469] = 1542,
  [3470] = 3470,
  [3471] = 3471,
  [3472] = 3472,
  [3473] = 3473,
  [3474] = 3471,
  [3475] = 3475,
  [3476] = 3476,
  [3477] = 211,
  [3478] = 3478,
  [3479] = 3471,
  [3480] = 3220,
  [3481] = 3481,
  [3482] = 3482,
  [3483] = 3483,
  [3484] = 213,
  [3485] = 3485,
  [3486] = 1519,
  [3487] = 3487,
  [3488] = 3483,
  [3489] = 3483,
  [3490] = 3483,
  [3491] = 3483,
  [3492] = 3471,
  [3493] = 3493,
  [3494] = 1521,
  [3495] = 3483,
  [3496] = 1514,
  [3497] = 977,
  [3498] = 3498,
  [3499] = 3499,
  [3500] = 3483,
  [3501] = 3312,
  [3502] = 3502,
  [3503] = 3503,
  [3504] = 3471,
  [3505] = 3475,
  [3506] = 978,
  [3507] = 3483,
  [3508] = 3508,
  [3509] = 3471,
  [3510] = 979,
  [3511] = 1513,
  [3512] = 3512,
  [3513] = 3513,
  [3514] = 3514,
  [3515] = 3515,
  [3516] = 3516,
  [3517] = 3517,
  [3518] = 3518,
  [3519] = 3519,
  [3520] = 3520,
  [3521] = 3521,
  [3522] = 3522,
  [3523] = 3523,
  [3524] = 3524,
  [3525] = 3525,
  [3526] = 3526,
  [3527] = 3527,
  [3528] = 3528,
  [3529] = 3529,
  [3530] = 209,
  [3531] = 3531,
  [3532] = 3532,
  [3533] = 3533,
  [3534] = 240,
  [3535] = 241,
  [3536] = 3536,
  [3537] = 3537,
  [3538] = 3538,
  [3539] = 3539,
  [3540] = 3540,
  [3541] = 3541,
  [3542] = 3513,
  [3543] = 3543,
  [3544] = 3544,
  [3545] = 3545,
  [3546] = 3546,
  [3547] = 3547,
  [3548] = 3544,
  [3549] = 3512,
  [3550] = 3550,
  [3551] = 3551,
  [3552] = 3552,
  [3553] = 3553,
  [3554] = 3554,
  [3555] = 3555,
  [3556] = 3556,
  [3557] = 3557,
  [3558] = 3558,
  [3559] = 3559,
  [3560] = 3560,
  [3561] = 3518,
  [3562] = 3521,
  [3563] = 3533,
  [3564] = 3564,
  [3565] = 3565,
  [3566] = 3566,
  [3567] = 3567,
  [3568] = 3568,
  [3569] = 3569,
  [3570] = 3570,
  [3571] = 1519,
  [3572] = 3572,
  [3573] = 3573,
  [3574] = 3574,
  [3575] = 3575,
  [3576] = 3576,
  [3577] = 3577,
  [3578] = 3578,
  [3579] = 3335,
  [3580] = 3580,
  [3581] = 3581,
  [3582] = 3582,
  [3583] = 3379,
  [3584] = 3584,
  [3585] = 3585,
  [3586] = 3586,
  [3587] = 3553,
  [3588] = 3588,
  [3589] = 3589,
  [3590] = 3590,
  [3591] = 3591,
  [3592] = 3553,
  [3593] = 3593,
  [3594] = 3557,
  [3595] = 3595,
  [3596] = 3596,
  [3597] = 3566,
  [3598] = 3573,
  [3599] = 3599,
  [3600] = 3600,
  [3601] = 3601,
  [3602] = 3602,
  [3603] = 3557,
  [3604] = 3566,
  [3605] = 3605,
  [3606] = 3606,
  [3607] = 3607,
  [3608] = 3608,
  [3609] = 3330,
  [3610] = 3348,
  [3611] = 3611,
  [3612] = 3410,
  [3613] = 3613,
  [3614] = 3557,
  [3615] = 3566,
  [3616] = 3566,
  [3617] = 3551,
  [3618] = 3618,
  [3619] = 3619,
  [3620] = 3557,
  [3621] = 3621,
  [3622] = 3557,
  [3623] = 3566,
  [3624] = 3624,
  [3625] = 3625,
  [3626] = 3626,
  [3627] = 3593,
  [3628] = 3569,
  [3629] = 3629,
  [3630] = 3630,
  [3631] = 3631,
  [3632] = 3632,
  [3633] = 3624,
  [3634] = 3557,
  [3635] = 3635,
  [3636] = 3636,
  [3637] = 3637,
  [3638] = 3638,
  [3639] = 3573,
  [3640] = 3640,
  [3641] = 1513,
  [3642] = 3642,
  [3643] = 1514,
  [3644] = 3644,
  [3645] = 1601,
  [3646] = 1613,
  [3647] = 3647,
  [3648] = 3648,
  [3649] = 1553,
  [3650] = 1556,
  [3651] = 1639,
  [3652] = 1641,
  [3653] = 3653,
  [3654] = 3654,
  [3655] = 3655,
  [3656] = 1599,
  [3657] = 3574,
  [3658] = 3279,
  [3659] = 3545,
  [3660] = 3575,
  [3661] = 3661,
  [3662] = 3662,
  [3663] = 3663,
  [3664] = 3664,
  [3665] = 3665,
  [3666] = 3666,
  [3667] = 3667,
  [3668] = 3668,
  [3669] = 3669,
  [3670] = 3670,
  [3671] = 3671,
  [3672] = 3672,
  [3673] = 3673,
  [3674] = 3674,
  [3675] = 3675,
  [3676] = 3676,
  [3677] = 3677,
  [3678] = 3678,
  [3679] = 3679,
  [3680] = 3680,
  [3681] = 3681,
  [3682] = 3682,
  [3683] = 3683,
  [3684] = 3684,
  [3685] = 3685,
  [3686] = 3686,
  [3687] = 3687,
  [3688] = 3688,
  [3689] = 3689,
  [3690] = 3690,
  [3691] = 3691,
  [3692] = 3692,
  [3693] = 3693,
  [3694] = 3694,
  [3695] = 3299,
  [3696] = 3696,
  [3697] = 3697,
  [3698] = 3698,
  [3699] = 3699,
  [3700] = 3700,
  [3701] = 3701,
  [3702] = 3557,
  [3703] = 3703,
  [3704] = 3704,
  [3705] = 3705,
  [3706] = 3706,
  [3707] = 3707,
  [3708] = 3708,
  [3709] = 3709,
  [3710] = 3710,
  [3711] = 3711,
  [3712] = 3712,
  [3713] = 3713,
  [3714] = 3714,
  [3715] = 3715,
  [3716] = 3716,
  [3717] = 3717,
  [3718] = 3718,
  [3719] = 3626,
  [3720] = 3720,
  [3721] = 3576,
  [3722] = 3722,
  [3723] = 3630,
  [3724] = 3679,
  [3725] = 3685,
  [3726] = 3726,
  [3727] = 3727,
  [3728] = 1537,
  [3729] = 1552,
  [3730] = 1562,
  [3731] = 3731,
  [3732] = 3732,
  [3733] = 3733,
  [3734] = 3734,
  [3735] = 3735,
  [3736] = 3736,
  [3737] = 3737,
  [3738] = 3679,
  [3739] = 3739,
  [3740] = 3685,
  [3741] = 3741,
  [3742] = 3742,
  [3743] = 3743,
  [3744] = 3744,
  [3745] = 3745,
  [3746] = 3746,
  [3747] = 3747,
  [3748] = 3748,
  [3749] = 3749,
  [3750] = 3750,
  [3751] = 3751,
  [3752] = 3752,
  [3753] = 3753,
  [3754] = 3566,
  [3755] = 3755,
  [3756] = 3756,
  [3757] = 3757,
  [3758] = 3758,
  [3759] = 3759,
  [3760] = 3760,
  [3761] = 3755,
  [3762] = 3762,
  [3763] = 3756,
  [3764] = 3759,
  [3765] = 3765,
  [3766] = 3766,
  [3767] = 3756,
  [3768] = 3768,
  [3769] = 3769,
  [3770] = 3770,
  [3771] = 3771,
  [3772] = 3682,
  [3773] = 3773,
  [3774] = 3774,
  [3775] = 3775,
  [3776] = 3696,
  [3777] = 3777,
  [3778] = 3759,
  [3779] = 3779,
  [3780] = 3780,
  [3781] = 3781,
  [3782] = 1601,
  [3783] = 3756,
  [3784] = 3759,
  [3785] = 1613,
  [3786] = 3786,
  [3787] = 3766,
  [3788] = 3779,
  [3789] = 3789,
  [3790] = 3636,
  [3791] = 3791,
  [3792] = 3792,
  [3793] = 710,
  [3794] = 711,
  [3795] = 3638,
  [3796] = 3236,
  [3797] = 3797,
  [3798] = 3798,
  [3799] = 3799,
  [3800] = 3762,
  [3801] = 712,
  [3802] = 3722,
  [3803] = 3640,
  [3804] = 3779,
  [3805] = 3792,
  [3806] = 3766,
  [3807] = 3780,
  [3808] = 1553,
  [3809] = 3756,
  [3810] = 1556,
  [3811] = 3759,
  [3812] = 1639,
  [3813] = 3766,
  [3814] = 1641,
  [3815] = 3686,
  [3816] = 3687,
  [3817] = 3817,
  [3818] = 3689,
  [3819] = 713,
  [3820] = 3766,
  [3821] = 3821,
  [3822] = 3780,
  [3823] = 3779,
  [3824] = 3824,
  [3825] = 3825,
  [3826] = 3780,
  [3827] = 3680,
  [3828] = 3704,
  [3829] = 3829,
  [3830] = 3690,
  [3831] = 3756,
  [3832] = 3832,
  [3833] = 3759,
  [3834] = 3683,
  [3835] = 3760,
  [3836] = 3836,
  [3837] = 3766,
  [3838] = 3838,
  [3839] = 3817,
  [3840] = 3301,
  [3841] = 1599,
  [3842] = 3842,
  [3843] = 3843,
  [3844] = 3844,
  [3845] = 3845,
  [3846] = 714,
  [3847] = 3847,
  [3848] = 3848,
  [3849] = 1262,
  [3850] = 3698,
  [3851] = 3758,
  [3852] = 3852,
  [3853] = 3853,
  [3854] = 3854,
  [3855] = 3780,
  [3856] = 3856,
  [3857] = 3857,
  [3858] = 3797,
  [3859] = 3859,
  [3860] = 3714,
  [3861] = 3825,
  [3862] = 3668,
  [3863] = 3669,
  [3864] = 3824,
  [3865] = 3857,
  [3866] = 3866,
  [3867] = 3670,
  [3868] = 3868,
  [3869] = 3671,
  [3870] = 3870,
  [3871] = 3845,
  [3872] = 3838,
  [3873] = 3873,
  [3874] = 3691,
  [3875] = 3692,
  [3876] = 3870,
  [3877] = 1537,
  [3878] = 1552,
  [3879] = 3844,
  [3880] = 3693,
  [3881] = 1562,
  [3882] = 3681,
  [3883] = 3779,
  [3884] = 3732,
  [3885] = 3885,
  [3886] = 3694,
  [3887] = 3887,
  [3888] = 3888,
  [3889] = 3825,
  [3890] = 3843,
  [3891] = 3868,
  [3892] = 3892,
  [3893] = 3791,
  [3894] = 3894,
  [3895] = 3307,
  [3896] = 3887,
  [3897] = 3868,
  [3898] = 3798,
  [3899] = 3786,
  [3900] = 3779,
  [3901] = 3789,
  [3902] = 3780,
  [3903] = 3903,
  [3904] = 3768,
  [3905] = 3905,
  [3906] = 3613,
  [3907] = 892,
  [3908] = 3908,
  [3909] = 3909,
  [3910] = 3910,
  [3911] = 3911,
  [3912] = 836,
  [3913] = 3913,
  [3914] = 3914,
  [3915] = 923,
  [3916] = 824,
  [3917] = 3917,
  [3918] = 3918,
  [3919] = 3919,
  [3920] = 3920,
  [3921] = 3921,
  [3922] = 3922,
  [3923] = 3923,
  [3924] = 3924,
  [3925] = 3925,
  [3926] = 3926,
  [3927] = 3927,
  [3928] = 3928,
  [3929] = 3929,
  [3930] = 3930,
  [3931] = 3931,
  [3932] = 3932,
  [3933] = 3933,
  [3934] = 3934,
  [3935] = 3935,
  [3936] = 3922,
  [3937] = 3937,
  [3938] = 3938,
  [3939] = 3939,
  [3940] = 3940,
  [3941] = 3941,
  [3942] = 3942,
  [3943] = 3943,
  [3944] = 3944,
  [3945] = 3945,
  [3946] = 3946,
  [3947] = 869,
  [3948] = 3948,
  [3949] = 930,
  [3950] = 3950,
  [3951] = 3951,
  [3952] = 3952,
  [3953] = 3953,
  [3954] = 3954,
  [3955] = 3955,
  [3956] = 3956,
  [3957] = 3957,
  [3958] = 3958,
  [3959] = 3959,
  [3960] = 3960,
  [3961] = 3836,
  [3962] = 3962,
  [3963] = 3963,
  [3964] = 781,
  [3965] = 3965,
  [3966] = 3966,
  [3967] = 3967,
  [3968] = 3968,
  [3969] = 929,
  [3970] = 3970,
  [3971] = 3971,
  [3972] = 3972,
  [3973] = 878,
  [3974] = 3948,
  [3975] = 3975,
  [3976] = 3976,
  [3977] = 776,
  [3978] = 803,
  [3979] = 3979,
  [3980] = 3980,
  [3981] = 3981,
  [3982] = 3945,
  [3983] = 797,
  [3984] = 3950,
  [3985] = 3985,
  [3986] = 3986,
  [3987] = 3987,
  [3988] = 3988,
  [3989] = 3989,
  [3990] = 3990,
  [3991] = 3991,
  [3992] = 3992,
  [3993] = 3993,
  [3994] = 3994,
  [3995] = 3995,
  [3996] = 3930,
  [3997] = 3582,
  [3998] = 3584,
  [3999] = 859,
  [4000] = 860,
  [4001] = 4001,
  [4002] = 4002,
  [4003] = 4003,
  [4004] = 4004,
  [4005] = 4005,
  [4006] = 4006,
  [4007] = 3910,
  [4008] = 4008,
  [4009] = 4009,
  [4010] = 4010,
  [4011] = 4011,
  [4012] = 3952,
  [4013] = 4013,
  [4014] = 3922,
  [4015] = 4015,
  [4016] = 4016,
  [4017] = 4017,
  [4018] = 3932,
  [4019] = 4019,
  [4020] = 4020,
  [4021] = 3938,
  [4022] = 4022,
  [4023] = 4023,
  [4024] = 3952,
  [4025] = 4025,
  [4026] = 4026,
  [4027] = 4027,
  [4028] = 3910,
  [4029] = 4029,
  [4030] = 4030,
  [4031] = 4031,
  [4032] = 4032,
  [4033] = 4033,
  [4034] = 887,
  [4035] = 903,
  [4036] = 911,
  [4037] = 3932,
  [4038] = 4038,
  [4039] = 4039,
  [4040] = 4040,
  [4041] = 4041,
  [4042] = 4042,
  [4043] = 4043,
  [4044] = 4044,
  [4045] = 4045,
  [4046] = 4046,
  [4047] = 4047,
  [4048] = 4048,
  [4049] = 220,
  [4050] = 3922,
  [4051] = 4051,
  [4052] = 4052,
  [4053] = 4053,
  [4054] = 3938,
  [4055] = 4055,
  [4056] = 4056,
  [4057] = 4057,
  [4058] = 3852,
  [4059] = 4059,
  [4060] = 3853,
  [4061] = 3854,
  [4062] = 926,
  [4063] = 4063,
  [4064] = 928,
  [4065] = 809,
  [4066] = 810,
  [4067] = 811,
  [4068] = 780,
  [4069] = 813,
  [4070] = 815,
  [4071] = 817,
  [4072] = 823,
  [4073] = 4073,
  [4074] = 4074,
  [4075] = 236,
  [4076] = 3541,
  [4077] = 839,
  [4078] = 842,
  [4079] = 845,
  [4080] = 3922,
  [4081] = 4081,
  [4082] = 4082,
  [4083] = 3938,
  [4084] = 4084,
  [4085] = 4085,
  [4086] = 4086,
  [4087] = 4087,
  [4088] = 4088,
  [4089] = 4089,
  [4090] = 4090,
  [4091] = 900,
  [4092] = 901,
  [4093] = 902,
  [4094] = 4094,
  [4095] = 3988,
  [4096] = 4096,
  [4097] = 3739,
  [4098] = 4098,
  [4099] = 4099,
  [4100] = 4100,
  [4101] = 3956,
  [4102] = 4102,
  [4103] = 4103,
  [4104] = 4104,
  [4105] = 4105,
  [4106] = 4106,
  [4107] = 3957,
  [4108] = 4108,
  [4109] = 4109,
  [4110] = 4110,
  [4111] = 4111,
  [4112] = 4112,
  [4113] = 4113,
  [4114] = 4114,
  [4115] = 4115,
  [4116] = 4116,
  [4117] = 4117,
  [4118] = 4118,
  [4119] = 3990,
  [4120] = 4120,
  [4121] = 4121,
  [4122] = 4122,
  [4123] = 4123,
  [4124] = 847,
  [4125] = 4125,
  [4126] = 851,
  [4127] = 867,
  [4128] = 868,
  [4129] = 4129,
  [4130] = 4130,
  [4131] = 4131,
  [4132] = 4132,
  [4133] = 4133,
  [4134] = 4134,
  [4135] = 4135,
  [4136] = 4136,
  [4137] = 4137,
  [4138] = 3985,
  [4139] = 4139,
  [4140] = 4140,
  [4141] = 934,
  [4142] = 3958,
  [4143] = 4015,
  [4144] = 4032,
  [4145] = 4145,
  [4146] = 889,
  [4147] = 4147,
  [4148] = 4148,
  [4149] = 4149,
  [4150] = 4150,
  [4151] = 896,
  [4152] = 777,
  [4153] = 779,
  [4154] = 783,
  [4155] = 904,
  [4156] = 4156,
  [4157] = 4157,
  [4158] = 4158,
  [4159] = 4159,
  [4160] = 914,
  [4161] = 4135,
  [4162] = 4162,
  [4163] = 4163,
  [4164] = 3968,
  [4165] = 880,
  [4166] = 4003,
  [4167] = 4167,
  [4168] = 4132,
  [4169] = 4133,
  [4170] = 855,
  [4171] = 865,
  [4172] = 4011,
  [4173] = 852,
  [4174] = 4174,
  [4175] = 4175,
  [4176] = 4176,
  [4177] = 4177,
  [4178] = 4178,
  [4179] = 4179,
  [4180] = 4180,
  [4181] = 4181,
  [4182] = 4182,
  [4183] = 4183,
  [4184] = 4184,
  [4185] = 4185,
  [4186] = 4186,
  [4187] = 4187,
  [4188] = 4188,
  [4189] = 4189,
  [4190] = 4190,
  [4191] = 4191,
  [4192] = 4017,
  [4193] = 3963,
  [4194] = 4074,
  [4195] = 4195,
  [4196] = 4196,
  [4197] = 4197,
  [4198] = 3965,
  [4199] = 933,
  [4200] = 808,
  [4201] = 873,
  [4202] = 861,
  [4203] = 4178,
  [4204] = 829,
  [4205] = 4205,
  [4206] = 4206,
  [4207] = 4179,
  [4208] = 875,
  [4209] = 908,
  [4210] = 4210,
  [4211] = 4211,
  [4212] = 4136,
  [4213] = 812,
  [4214] = 778,
  [4215] = 787,
  [4216] = 794,
  [4217] = 927,
  [4218] = 4218,
  [4219] = 4219,
  [4220] = 4220,
  [4221] = 4221,
  [4222] = 4222,
  [4223] = 4125,
  [4224] = 4224,
  [4225] = 4225,
  [4226] = 4226,
  [4227] = 882,
  [4228] = 884,
  [4229] = 4135,
  [4230] = 4015,
  [4231] = 4032,
  [4232] = 4232,
  [4233] = 4233,
  [4234] = 4234,
  [4235] = 4235,
  [4236] = 4236,
  [4237] = 4011,
  [4238] = 3967,
  [4239] = 4239,
  [4240] = 4240,
  [4241] = 893,
  [4242] = 894,
  [4243] = 897,
  [4244] = 906,
  [4245] = 921,
  [4246] = 4246,
  [4247] = 4247,
  [4248] = 912,
  [4249] = 4249,
  [4250] = 850,
  [4251] = 795,
  [4252] = 4252,
  [4253] = 4253,
  [4254] = 4254,
  [4255] = 4255,
  [4256] = 4256,
  [4257] = 864,
  [4258] = 4258,
  [4259] = 4259,
  [4260] = 886,
  [4261] = 890,
  [4262] = 891,
  [4263] = 899,
  [4264] = 4264,
  [4265] = 4265,
  [4266] = 4266,
  [4267] = 4267,
  [4268] = 4268,
  [4269] = 4269,
  [4270] = 4270,
  [4271] = 4271,
  [4272] = 4272,
  [4273] = 4273,
  [4274] = 4274,
  [4275] = 4275,
  [4276] = 4276,
  [4277] = 4277,
  [4278] = 4278,
  [4279] = 4279,
  [4280] = 3937,
  [4281] = 4281,
  [4282] = 4282,
  [4283] = 4283,
  [4284] = 4284,
  [4285] = 4285,
  [4286] = 4125,
  [4287] = 4287,
  [4288] = 4288,
  [4289] = 4289,
  [4290] = 4290,
  [4291] = 4291,
  [4292] = 4292,
  [4293] = 4293,
  [4294] = 4294,
  [4295] = 4295,
  [4296] = 4296,
  [4297] = 4297,
  [4298] = 3971,
  [4299] = 4299,
  [4300] = 4300,
  [4301] = 4301,
  [4302] = 3727,
  [4303] = 4303,
  [4304] = 4304,
  [4305] = 4305,
  [4306] = 3938,
  [4307] = 4307,
  [4308] = 4308,
  [4309] = 4309,
  [4310] = 4310,
  [4311] = 4311,
  [4312] = 4312,
  [4313] = 4313,
  [4314] = 4188,
  [4315] = 4315,
  [4316] = 4316,
  [4317] = 4317,
  [4318] = 4318,
  [4319] = 1551,
  [4320] = 4139,
  [4321] = 1597,
  [4322] = 4084,
  [4323] = 4323,
  [4324] = 4324,
  [4325] = 4325,
  [4326] = 4326,
  [4327] = 4327,
  [4328] = 4328,
  [4329] = 4329,
  [4330] = 4330,
  [4331] = 4331,
  [4332] = 4332,
  [4333] = 4333,
  [4334] = 4334,
  [4335] = 3981,
  [4336] = 4336,
  [4337] = 4337,
  [4338] = 4338,
  [4339] = 4339,
  [4340] = 4340,
  [4341] = 4341,
  [4342] = 3937,
  [4343] = 4343,
  [4344] = 4197,
  [4345] = 3970,
  [4346] = 3956,
  [4347] = 3957,
  [4348] = 4191,
  [4349] = 3989,
  [4350] = 3971,
  [4351] = 4351,
  [4352] = 4352,
  [4353] = 4353,
  [4354] = 4354,
  [4355] = 4355,
  [4356] = 4356,
  [4357] = 4357,
  [4358] = 4358,
  [4359] = 4359,
  [4360] = 4360,
  [4361] = 4361,
  [4362] = 4362,
  [4363] = 4363,
  [4364] = 4364,
  [4365] = 4365,
  [4366] = 4366,
  [4367] = 4367,
  [4368] = 4368,
  [4369] = 4369,
  [4370] = 4370,
  [4371] = 4371,
  [4372] = 4372,
  [4373] = 4373,
  [4374] = 4374,
  [4375] = 4375,
  [4376] = 4376,
  [4377] = 4377,
  [4378] = 3940,
  [4379] = 4379,
  [4380] = 4380,
  [4381] = 4381,
  [4382] = 4382,
  [4383] = 4140,
  [4384] = 4384,
  [4385] = 4385,
  [4386] = 4386,
  [4387] = 4387,
  [4388] = 4388,
  [4389] = 4389,
  [4390] = 4388,
  [4391] = 4391,
  [4392] = 4392,
  [4393] = 4393,
  [4394] = 4394,
  [4395] = 4395,
  [4396] = 4396,
  [4397] = 4397,
  [4398] = 4393,
  [4399] = 4399,
  [4400] = 4394,
  [4401] = 4391,
  [4402] = 4402,
  [4403] = 4403,
  [4404] = 4404,
  [4405] = 4405,
  [4406] = 4406,
  [4407] = 4407,
  [4408] = 4408,
  [4409] = 4393,
  [4410] = 4410,
  [4411] = 4397,
  [4412] = 4392,
  [4413] = 4408,
  [4414] = 4388,
  [4415] = 4415,
  [4416] = 4416,
  [4417] = 4417,
  [4418] = 4418,
  [4419] = 4419,
  [4420] = 4420,
  [4421] = 4421,
  [4422] = 4422,
  [4423] = 4423,
  [4424] = 4424,
  [4425] = 4425,
  [4426] = 4426,
  [4427] = 4427,
  [4428] = 4428,
  [4429] = 4429,
  [4430] = 4399,
  [4431] = 4431,
  [4432] = 4432,
  [4433] = 4408,
  [4434] = 4434,
  [4435] = 4404,
  [4436] = 4436,
  [4437] = 4437,
  [4438] = 4438,
  [4439] = 4389,
  [4440] = 4440,
  [4441] = 4404,
  [4442] = 4429,
  [4443] = 4443,
  [4444] = 4444,
  [4445] = 4388,
  [4446] = 4394,
  [4447] = 4447,
  [4448] = 3739,
  [4449] = 4396,
  [4450] = 4397,
  [4451] = 4451,
  [4452] = 4452,
  [4453] = 4453,
  [4454] = 4393,
  [4455] = 4429,
  [4456] = 4456,
  [4457] = 4399,
  [4458] = 4394,
  [4459] = 4429,
  [4460] = 4389,
  [4461] = 4461,
  [4462] = 4396,
  [4463] = 3774,
  [4464] = 4422,
  [4465] = 4408,
  [4466] = 4396,
  [4467] = 4389,
  [4468] = 4388,
  [4469] = 4397,
  [4470] = 4470,
  [4471] = 4393,
  [4472] = 4424,
  [4473] = 4389,
  [4474] = 4396,
  [4475] = 4404,
  [4476] = 4404,
  [4477] = 4477,
  [4478] = 4393,
  [4479] = 3770,
  [4480] = 4417,
  [4481] = 4393,
  [4482] = 4482,
  [4483] = 4437,
  [4484] = 4484,
  [4485] = 4485,
  [4486] = 4399,
  [4487] = 4487,
  [4488] = 4456,
  [4489] = 4489,
  [4490] = 4429,
  [4491] = 4394,
  [4492] = 4399,
  [4493] = 4396,
  [4494] = 4389,
  [4495] = 4397,
  [4496] = 4496,
  [4497] = 4399,
  [4498] = 4394,
  [4499] = 4423,
  [4500] = 4424,
  [4501] = 4396,
  [4502] = 4502,
  [4503] = 4397,
  [4504] = 4504,
  [4505] = 4424,
  [4506] = 4399,
  [4507] = 4424,
  [4508] = 4508,
  [4509] = 4470,
  [4510] = 4394,
  [4511] = 4428,
  [4512] = 4429,
  [4513] = 4397,
  [4514] = 4429,
  [4515] = 4387,
  [4516] = 4389,
  [4517] = 4443,
  [4518] = 4424,
  [4519] = 4408,
  [4520] = 4408,
  [4521] = 4424,
  [4522] = 4522,
  [4523] = 4523,
  [4524] = 4524,
  [4525] = 4525,
  [4526] = 4526,
  [4527] = 4527,
  [4528] = 4528,
  [4529] = 4529,
  [4530] = 4530,
  [4531] = 4531,
  [4532] = 4532,
  [4533] = 4533,
  [4534] = 4534,
  [4535] = 4535,
  [4536] = 4536,
  [4537] = 4537,
  [4538] = 4538,
  [4539] = 4539,
  [4540] = 4540,
  [4541] = 4541,
  [4542] = 4527,
  [4543] = 4543,
  [4544] = 4529,
  [4545] = 4537,
  [4546] = 3774,
  [4547] = 4547,
  [4548] = 4548,
  [4549] = 4549,
  [4550] = 4550,
  [4551] = 4551,
  [4552] = 4552,
  [4553] = 4553,
  [4554] = 4548,
  [4555] = 4555,
  [4556] = 4556,
  [4557] = 4557,
  [4558] = 4558,
  [4559] = 4559,
  [4560] = 4560,
  [4561] = 4561,
  [4562] = 4562,
  [4563] = 4547,
  [4564] = 4548,
  [4565] = 4565,
  [4566] = 4566,
  [4567] = 4567,
  [4568] = 4568,
  [4569] = 4569,
  [4570] = 4570,
  [4571] = 4547,
  [4572] = 4572,
  [4573] = 4573,
  [4574] = 4574,
  [4575] = 4575,
  [4576] = 4576,
  [4577] = 4577,
  [4578] = 4578,
  [4579] = 4579,
  [4580] = 4580,
  [4581] = 4581,
  [4582] = 4582,
  [4583] = 4583,
  [4584] = 4535,
  [4585] = 4585,
  [4586] = 4586,
  [4587] = 4551,
  [4588] = 4588,
  [4589] = 4589,
  [4590] = 4590,
  [4591] = 4591,
  [4592] = 4527,
  [4593] = 4529,
  [4594] = 4537,
  [4595] = 4547,
  [4596] = 4548,
  [4597] = 4597,
  [4598] = 4598,
  [4599] = 4599,
  [4600] = 4539,
  [4601] = 4550,
  [4602] = 4558,
  [4603] = 4577,
  [4604] = 4604,
  [4605] = 4605,
  [4606] = 4556,
  [4607] = 4557,
  [4608] = 4608,
  [4609] = 4609,
  [4610] = 4610,
  [4611] = 4611,
  [4612] = 4612,
  [4613] = 4613,
  [4614] = 4614,
  [4615] = 4615,
  [4616] = 4616,
  [4617] = 4617,
  [4618] = 4618,
  [4619] = 4619,
  [4620] = 4620,
  [4621] = 4621,
  [4622] = 4622,
  [4623] = 4623,
  [4624] = 4624,
  [4625] = 4625,
  [4626] = 4626,
  [4627] = 4579,
  [4628] = 4628,
  [4629] = 4615,
  [4630] = 4630,
  [4631] = 4631,
  [4632] = 4632,
  [4633] = 4633,
  [4634] = 4634,
  [4635] = 4537,
  [4636] = 4636,
  [4637] = 4547,
  [4638] = 4548,
  [4639] = 4639,
  [4640] = 4557,
  [4641] = 3722,
  [4642] = 4642,
  [4643] = 4643,
  [4644] = 4556,
  [4645] = 3770,
  [4646] = 4646,
  [4647] = 4647,
  [4648] = 4547,
  [4649] = 4548,
  [4650] = 4650,
  [4651] = 4557,
  [4652] = 4652,
  [4653] = 4556,
  [4654] = 4654,
  [4655] = 4655,
  [4656] = 4656,
  [4657] = 4526,
  [4658] = 4658,
  [4659] = 4659,
  [4660] = 4660,
  [4661] = 4661,
  [4662] = 4662,
  [4663] = 4663,
  [4664] = 4664,
  [4665] = 4665,
  [4666] = 4666,
  [4667] = 4667,
  [4668] = 4668,
  [4669] = 4669,
  [4670] = 4670,
  [4671] = 4671,
  [4672] = 4672,
  [4673] = 4673,
  [4674] = 4674,
  [4675] = 4129,
  [4676] = 4557,
  [4677] = 4677,
  [4678] = 4678,
  [4679] = 4524,
  [4680] = 4535,
  [4681] = 4681,
  [4682] = 4682,
  [4683] = 4683,
  [4684] = 4684,
  [4685] = 4685,
  [4686] = 4686,
  [4687] = 4687,
  [4688] = 4688,
  [4689] = 4689,
  [4690] = 4690,
  [4691] = 4691,
  [4692] = 4670,
  [4693] = 4693,
  [4694] = 4694,
  [4695] = 4695,
  [4696] = 788,
  [4697] = 4697,
  [4698] = 4698,
  [4699] = 4699,
  [4700] = 4580,
  [4701] = 4701,
  [4702] = 4702,
  [4703] = 4673,
  [4704] = 4704,
  [4705] = 4557,
  [4706] = 4706,
  [4707] = 4529,
  [4708] = 4708,
  [4709] = 4709,
  [4710] = 4710,
  [4711] = 4711,
  [4712] = 4712,
  [4713] = 4713,
  [4714] = 4714,
  [4715] = 4715,
  [4716] = 4716,
  [4717] = 4717,
  [4718] = 4718,
  [4719] = 4719,
  [4720] = 4720,
  [4721] = 4721,
  [4722] = 4722,
  [4723] = 4723,
  [4724] = 4661,
  [4725] = 4725,
  [4726] = 4726,
  [4727] = 4727,
  [4728] = 4728,
  [4729] = 4729,
  [4730] = 4730,
  [4731] = 4731,
  [4732] = 4732,
  [4733] = 4733,
  [4734] = 4734,
  [4735] = 4735,
  [4736] = 4736,
  [4737] = 4737,
  [4738] = 4738,
  [4739] = 4739,
  [4740] = 4740,
  [4741] = 4741,
  [4742] = 4742,
  [4743] = 4743,
  [4744] = 4744,
  [4745] = 4745,
  [4746] = 4746,
  [4747] = 4747,
  [4748] = 4748,
  [4749] = 4749,
  [4750] = 4750,
  [4751] = 4751,
  [4752] = 4752,
  [4753] = 4753,
  [4754] = 4754,
  [4755] = 4755,
  [4756] = 4756,
  [4757] = 4757,
  [4758] = 4758,
  [4759] = 4759,
  [4760] = 4760,
  [4761] = 4761,
  [4762] = 4762,
  [4763] = 4763,
  [4764] = 4764,
  [4765] = 4765,
  [4766] = 4766,
  [4767] = 4767,
  [4768] = 4768,
  [4769] = 4769,
  [4770] = 4770,
  [4771] = 4303,
  [4772] = 4535,
  [4773] = 4773,
  [4774] = 4774,
  [4775] = 4775,
  [4776] = 4776,
  [4777] = 4777,
  [4778] = 4720,
  [4779] = 4779,
  [4780] = 4780,
  [4781] = 4667,
  [4782] = 4782,
  [4783] = 4783,
  [4784] = 4784,
  [4785] = 4785,
  [4786] = 4786,
  [4787] = 4787,
  [4788] = 4535,
  [4789] = 4789,
  [4790] = 4790,
  [4791] = 4791,
  [4792] = 4792,
  [4793] = 4793,
  [4794] = 4794,
  [4795] = 4795,
  [4796] = 4796,
  [4797] = 4797,
  [4798] = 4798,
  [4799] = 4799,
  [4800] = 4800,
  [4801] = 4801,
  [4802] = 4802,
  [4803] = 4535,
  [4804] = 4804,
  [4805] = 4805,
  [4806] = 4806,
  [4807] = 4807,
  [4808] = 4808,
  [4809] = 3732,
  [4810] = 3714,
  [4811] = 4811,
  [4812] = 4812,
  [4813] = 4813,
  [4814] = 4814,
  [4815] = 4815,
  [4816] = 4816,
  [4817] = 4632,
  [4818] = 4818,
  [4819] = 4819,
  [4820] = 4820,
  [4821] = 4821,
  [4822] = 4605,
  [4823] = 4823,
  [4824] = 4824,
  [4825] = 4825,
  [4826] = 4826,
  [4827] = 4827,
  [4828] = 4828,
  [4829] = 4829,
  [4830] = 4830,
  [4831] = 4831,
  [4832] = 4832,
  [4833] = 4833,
  [4834] = 4834,
  [4835] = 4835,
  [4836] = 4836,
  [4837] = 4837,
  [4838] = 4838,
  [4839] = 4839,
  [4840] = 4840,
  [4841] = 4841,
  [4842] = 4842,
  [4843] = 4843,
  [4844] = 4844,
  [4845] = 4845,
  [4846] = 4846,
  [4847] = 4847,
  [4848] = 4848,
  [4849] = 4849,
  [4850] = 4850,
  [4851] = 4851,
  [4852] = 4852,
  [4853] = 4853,
  [4854] = 4854,
  [4855] = 4855,
  [4856] = 4856,
  [4857] = 4857,
  [4858] = 4858,
  [4859] = 4859,
  [4860] = 4860,
  [4861] = 4861,
  [4862] = 4862,
  [4863] = 4863,
  [4864] = 4864,
  [4865] = 4865,
  [4866] = 4866,
  [4867] = 4867,
  [4868] = 4868,
  [4869] = 4869,
  [4870] = 4870,
  [4871] = 4871,
  [4872] = 4872,
  [4873] = 4873,
  [4874] = 4874,
  [4875] = 4875,
  [4876] = 4876,
  [4877] = 4877,
  [4878] = 4528,
  [4879] = 4879,
  [4880] = 4880,
  [4881] = 4881,
  [4882] = 4882,
  [4883] = 4883,
  [4884] = 4884,
  [4885] = 4610,
  [4886] = 4886,
  [4887] = 4887,
  [4888] = 4888,
  [4889] = 4889,
  [4890] = 4890,
  [4891] = 4891,
  [4892] = 4892,
  [4893] = 4893,
  [4894] = 4894,
  [4895] = 4895,
  [4896] = 4896,
  [4897] = 4897,
  [4898] = 4898,
  [4899] = 4899,
  [4900] = 4900,
  [4901] = 4704,
  [4902] = 4526,
  [4903] = 4903,
  [4904] = 4551,
  [4905] = 4824,
  [4906] = 4835,
  [4907] = 4907,
  [4908] = 4908,
  [4909] = 4909,
  [4910] = 4910,
  [4911] = 4911,
  [4912] = 4912,
  [4913] = 4913,
  [4914] = 4914,
  [4915] = 4527,
  [4916] = 4611,
  [4917] = 4917,
  [4918] = 4918,
  [4919] = 4919,
  [4920] = 4920,
  [4921] = 4921,
  [4922] = 4668,
  [4923] = 4923,
  [4924] = 4924,
  [4925] = 4925,
  [4926] = 4535,
  [4927] = 4927,
  [4928] = 4928,
  [4929] = 4929,
  [4930] = 4930,
  [4931] = 4931,
  [4932] = 4932,
  [4933] = 4933,
  [4934] = 4934,
  [4935] = 4879,
  [4936] = 4936,
  [4937] = 3704,
  [4938] = 4938,
  [4939] = 4939,
  [4940] = 4824,
  [4941] = 4910,
  [4942] = 4942,
  [4943] = 4943,
  [4944] = 1548,
  [4945] = 1596,
  [4946] = 4946,
  [4947] = 4894,
  [4948] = 4948,
  [4949] = 4949,
  [4950] = 4950,
  [4951] = 4951,
  [4952] = 4728,
  [4953] = 4953,
  [4954] = 4954,
  [4955] = 4955,
  [4956] = 4730,
  [4957] = 4957,
  [4958] = 4958,
  [4959] = 4959,
  [4960] = 4960,
  [4961] = 4908,
  [4962] = 4962,
  [4963] = 4963,
  [4964] = 4894,
  [4965] = 4910,
  [4966] = 4966,
  [4967] = 4967,
  [4968] = 4968,
  [4969] = 4527,
  [4970] = 4970,
  [4971] = 4971,
  [4972] = 4972,
  [4973] = 4973,
  [4974] = 4974,
  [4975] = 4975,
  [4976] = 4529,
  [4977] = 4977,
  [4978] = 4978,
  [4979] = 4979,
  [4980] = 4980,
  [4981] = 4981,
  [4982] = 4982,
  [4983] = 4529,
  [4984] = 4984,
  [4985] = 4985,
  [4986] = 4986,
  [4987] = 4987,
  [4988] = 4988,
  [4989] = 4989,
  [4990] = 4990,
  [4991] = 4537,
  [4992] = 4992,
  [4993] = 4993,
  [4994] = 4566,
  [4995] = 4525,
  [4996] = 4996,
  [4997] = 4547,
  [4998] = 4548,
  [4999] = 4999,
  [5000] = 4578,
  [5001] = 5001,
  [5002] = 5002,
  [5003] = 5003,
  [5004] = 5004,
  [5005] = 5005,
  [5006] = 5006,
  [5007] = 4539,
  [5008] = 4550,
  [5009] = 5009,
  [5010] = 4558,
  [5011] = 4577,
  [5012] = 5012,
  [5013] = 5013,
  [5014] = 5014,
  [5015] = 5015,
  [5016] = 4588,
  [5017] = 5017,
  [5018] = 5018,
  [5019] = 5019,
  [5020] = 4617,
  [5021] = 5021,
  [5022] = 4529,
  [5023] = 5023,
  [5024] = 5024,
  [5025] = 5025,
  [5026] = 5026,
  [5027] = 5027,
  [5028] = 5028,
  [5029] = 4556,
  [5030] = 5030,
  [5031] = 5031,
  [5032] = 5032,
  [5033] = 5033,
  [5034] = 4557,
  [5035] = 5035,
  [5036] = 5036,
  [5037] = 5037,
  [5038] = 5038,
  [5039] = 5039,
  [5040] = 5040,
  [5041] = 5041,
  [5042] = 5042,
  [5043] = 5043,
  [5044] = 5044,
  [5045] = 5045,
  [5046] = 5046,
  [5047] = 5047,
  [5048] = 5048,
  [5049] = 5049,
  [5050] = 5050,
  [5051] = 5051,
  [5052] = 5052,
  [5053] = 5053,
  [5054] = 5054,
  [5055] = 5055,
  [5056] = 4537,
  [5057] = 5057,
  [5058] = 5058,
  [5059] = 5059,
  [5060] = 5060,
  [5061] = 5061,
  [5062] = 5062,
  [5063] = 5063,
  [5064] = 5064,
  [5065] = 5065,
  [5066] = 5066,
  [5067] = 5067,
  [5068] = 5068,
  [5069] = 5069,
  [5070] = 5070,
  [5071] = 5071,
  [5072] = 5072,
  [5073] = 5073,
  [5074] = 5074,
  [5075] = 5075,
  [5076] = 5076,
  [5077] = 5077,
  [5078] = 5078,
  [5079] = 5079,
  [5080] = 5080,
  [5081] = 5081,
  [5082] = 5082,
  [5083] = 5083,
  [5084] = 5084,
  [5085] = 5085,
  [5086] = 5086,
  [5087] = 5087,
  [5088] = 5088,
  [5089] = 5089,
  [5090] = 5090,
  [5091] = 4541,
  [5092] = 5092,
  [5093] = 5093,
  [5094] = 5094,
  [5095] = 5095,
  [5096] = 5096,
  [5097] = 5097,
  [5098] = 5098,
  [5099] = 5099,
  [5100] = 5100,
  [5101] = 5101,
  [5102] = 5102,
  [5103] = 5103,
  [5104] = 5104,
  [5105] = 5105,
  [5106] = 3739,
  [5107] = 5107,
  [5108] = 5108,
  [5109] = 5109,
  [5110] = 4562,
  [5111] = 5111,
  [5112] = 5112,
  [5113] = 5113,
  [5114] = 5114,
  [5115] = 5115,
  [5116] = 4367,
  [5117] = 5117,
  [5118] = 5118,
  [5119] = 4622,
  [5120] = 5120,
  [5121] = 5121,
  [5122] = 5122,
  [5123] = 5123,
  [5124] = 5124,
  [5125] = 5125,
  [5126] = 5126,
  [5127] = 5127,
  [5128] = 5128,
  [5129] = 5129,
  [5130] = 5130,
  [5131] = 5131,
  [5132] = 4683,
  [5133] = 5133,
  [5134] = 4567,
  [5135] = 5135,
  [5136] = 4704,
  [5137] = 5137,
  [5138] = 5138,
  [5139] = 5139,
  [5140] = 5140,
  [5141] = 5141,
  [5142] = 5142,
  [5143] = 5143,
  [5144] = 5144,
  [5145] = 5145,
  [5146] = 5146,
  [5147] = 5147,
  [5148] = 5148,
  [5149] = 5149,
  [5150] = 5150,
  [5151] = 5151,
  [5152] = 5152,
  [5153] = 5153,
  [5154] = 5154,
  [5155] = 5155,
  [5156] = 5156,
  [5157] = 5157,
  [5158] = 5158,
  [5159] = 5159,
  [5160] = 5160,
  [5161] = 5161,
  [5162] = 5162,
  [5163] = 5163,
  [5164] = 2658,
  [5165] = 5165,
  [5166] = 5166,
  [5167] = 5167,
  [5168] = 5168,
  [5169] = 5169,
  [5170] = 5170,
  [5171] = 5171,
  [5172] = 5172,
  [5173] = 5173,
  [5174] = 5174,
  [5175] = 5175,
  [5176] = 5176,
  [5177] = 5177,
  [5178] = 5178,
  [5179] = 5179,
  [5180] = 2684,
  [5181] = 5146,
  [5182] = 2717,
  [5183] = 5183,
  [5184] = 5168,
  [5185] = 5185,
  [5186] = 5186,
  [5187] = 5187,
  [5188] = 5188,
  [5189] = 5189,
  [5190] = 5190,
  [5191] = 5168,
  [5192] = 3836,
  [5193] = 5193,
  [5194] = 5194,
  [5195] = 5195,
  [5196] = 5161,
  [5197] = 5197,
  [5198] = 5198,
  [5199] = 5199,
  [5200] = 5200,
  [5201] = 5201,
  [5202] = 2689,
  [5203] = 2696,
  [5204] = 5168,
  [5205] = 5205,
  [5206] = 2688,
  [5207] = 5207,
  [5208] = 2704,
  [5209] = 5157,
  [5210] = 5210,
  [5211] = 5211,
  [5212] = 5156,
  [5213] = 5211,
  [5214] = 5214,
  [5215] = 5215,
  [5216] = 2656,
  [5217] = 5217,
  [5218] = 5218,
  [5219] = 5219,
  [5220] = 5160,
  [5221] = 5221,
  [5222] = 5222,
  [5223] = 5176,
  [5224] = 2715,
  [5225] = 5178,
  [5226] = 5226,
  [5227] = 5227,
  [5228] = 5228,
  [5229] = 5178,
  [5230] = 2705,
  [5231] = 2716,
  [5232] = 5232,
  [5233] = 5233,
  [5234] = 5234,
  [5235] = 5235,
  [5236] = 2683,
  [5237] = 2711,
  [5238] = 5238,
  [5239] = 5239,
  [5240] = 5238,
  [5241] = 5241,
  [5242] = 5242,
  [5243] = 2677,
  [5244] = 5244,
  [5245] = 5245,
  [5246] = 5246,
  [5247] = 5247,
  [5248] = 5148,
  [5249] = 5151,
  [5250] = 5250,
  [5251] = 5251,
  [5252] = 5252,
  [5253] = 5251,
  [5254] = 5254,
  [5255] = 5255,
  [5256] = 5256,
  [5257] = 5257,
  [5258] = 5160,
  [5259] = 5259,
  [5260] = 5176,
  [5261] = 5178,
  [5262] = 5262,
  [5263] = 5263,
  [5264] = 5264,
  [5265] = 5265,
  [5266] = 5266,
  [5267] = 5267,
  [5268] = 5268,
  [5269] = 5269,
  [5270] = 5270,
  [5271] = 5160,
  [5272] = 5272,
  [5273] = 5273,
  [5274] = 5274,
  [5275] = 3852,
  [5276] = 5276,
  [5277] = 5277,
  [5278] = 5176,
  [5279] = 1660,
  [5280] = 5280,
  [5281] = 5222,
  [5282] = 5255,
  [5283] = 5283,
  [5284] = 5284,
  [5285] = 5254,
  [5286] = 5286,
  [5287] = 5232,
  [5288] = 5198,
  [5289] = 5289,
  [5290] = 5290,
  [5291] = 5291,
  [5292] = 5292,
  [5293] = 5293,
  [5294] = 5294,
  [5295] = 5295,
  [5296] = 5296,
  [5297] = 5297,
  [5298] = 5298,
  [5299] = 5299,
  [5300] = 5300,
  [5301] = 5301,
  [5302] = 5187,
  [5303] = 5303,
  [5304] = 5233,
  [5305] = 5165,
  [5306] = 5267,
  [5307] = 5147,
  [5308] = 5308,
  [5309] = 5309,
  [5310] = 5177,
  [5311] = 5311,
  [5312] = 5195,
  [5313] = 5269,
  [5314] = 5314,
  [5315] = 5158,
  [5316] = 5316,
  [5317] = 5242,
  [5318] = 5289,
  [5319] = 5297,
  [5320] = 5320,
  [5321] = 5321,
  [5322] = 5221,
  [5323] = 5323,
  [5324] = 5324,
  [5325] = 5325,
  [5326] = 5172,
  [5327] = 5327,
  [5328] = 2702,
  [5329] = 5329,
  [5330] = 2712,
  [5331] = 5331,
  [5332] = 5174,
  [5333] = 5262,
  [5334] = 5334,
  [5335] = 5335,
  [5336] = 5336,
  [5337] = 5176,
  [5338] = 5338,
  [5339] = 5339,
  [5340] = 5340,
  [5341] = 5341,
  [5342] = 5274,
  [5343] = 5343,
  [5344] = 1676,
  [5345] = 1677,
  [5346] = 5289,
  [5347] = 5297,
  [5348] = 5222,
  [5349] = 5274,
  [5350] = 5350,
  [5351] = 5351,
  [5352] = 5289,
  [5353] = 5190,
  [5354] = 5297,
  [5355] = 5355,
  [5356] = 5356,
  [5357] = 5357,
  [5358] = 5214,
  [5359] = 5359,
  [5360] = 5360,
  [5361] = 5361,
  [5362] = 5362,
  [5363] = 5270,
  [5364] = 5244,
  [5365] = 2670,
  [5366] = 5149,
  [5367] = 5147,
  [5368] = 5156,
  [5369] = 5187,
  [5370] = 5370,
  [5371] = 5274,
  [5372] = 5158,
  [5373] = 5156,
  [5374] = 5301,
  [5375] = 5158,
  [5376] = 5159,
  [5377] = 5377,
  [5378] = 5160,
  [5379] = 5156,
  [5380] = 5380,
  [5381] = 5381,
  [5382] = 5159,
  [5383] = 5161,
  [5384] = 5161,
  [5385] = 2693,
  [5386] = 5264,
  [5387] = 5158,
  [5388] = 3853,
  [5389] = 5159,
  [5390] = 5390,
  [5391] = 5161,
  [5392] = 5176,
  [5393] = 5272,
  [5394] = 5320,
  [5395] = 5321,
  [5396] = 5256,
  [5397] = 5274,
  [5398] = 2652,
  [5399] = 5143,
  [5400] = 5289,
  [5401] = 2680,
  [5402] = 5298,
  [5403] = 5145,
  [5404] = 5404,
  [5405] = 5405,
  [5406] = 5168,
  [5407] = 5168,
  [5408] = 5408,
  [5409] = 5178,
  [5410] = 5327,
  [5411] = 5152,
  [5412] = 5412,
  [5413] = 5329,
  [5414] = 5270,
  [5415] = 5297,
  [5416] = 5217,
  [5417] = 5178,
  [5418] = 5331,
  [5419] = 5419,
  [5420] = 5242,
  [5421] = 5335,
  [5422] = 5194,
  [5423] = 5150,
  [5424] = 5424,
  [5425] = 5425,
  [5426] = 5338,
  [5427] = 5427,
  [5428] = 5428,
  [5429] = 5429,
  [5430] = 5430,
  [5431] = 5431,
  [5432] = 5432,
  [5433] = 5433,
  [5434] = 5431,
  [5435] = 5435,
  [5436] = 5277,
  [5437] = 5325,
  [5438] = 5320,
  [5439] = 5168,
  [5440] = 5308,
  [5441] = 3854,
  [5442] = 5160,
  [5443] = 5443,
  [5444] = 5425,
  [5445] = 5445,
  [5446] = 5284,
  [5447] = 5189,
  [5448] = 5448,
  [5449] = 5290,
  [5450] = 5450,
  [5451] = 5451,
  [5452] = 5452,
  [5453] = 2691,
  [5454] = 5207,
  [5455] = 5408,
  [5456] = 5316,
  [5457] = 5291,
  [5458] = 5159,
  [5459] = 5452,
  [5460] = 5244,
  [5461] = 2697,
  [5462] = 5265,
  [5463] = 5294,
  [5464] = 5160,
  [5465] = 5262,
  [5466] = 5176,
  [5467] = 5295,
  [5468] = 5468,
  [5469] = 5152,
  [5470] = 5178,
  [5471] = 5296,
  [5472] = 5218,
  [5473] = 5300,
  [5474] = 5235,
  [5475] = 5475,
  [5476] = 5381,
  [5477] = 5273,
  [5478] = 5478,
  [5479] = 5479,
  [5480] = 5480,
  [5481] = 5481,
  [5482] = 5482,
  [5483] = 5483,
  [5484] = 5482,
  [5485] = 5485,
  [5486] = 5486,
  [5487] = 5487,
  [5488] = 5488,
  [5489] = 5478,
  [5490] = 5490,
  [5491] = 5491,
  [5492] = 5492,
  [5493] = 5493,
  [5494] = 5494,
  [5495] = 5495,
  [5496] = 5486,
  [5497] = 5497,
  [5498] = 5498,
  [5499] = 5499,
  [5500] = 5500,
  [5501] = 5501,
  [5502] = 5502,
  [5503] = 5503,
  [5504] = 5504,
  [5505] = 5505,
  [5506] = 5506,
  [5507] = 5507,
  [5508] = 5494,
  [5509] = 5509,
  [5510] = 5510,
  [5511] = 5511,
  [5512] = 5512,
  [5513] = 5513,
  [5514] = 5514,
  [5515] = 5515,
  [5516] = 5516,
  [5517] = 5486,
  [5518] = 5518,
  [5519] = 5519,
  [5520] = 5520,
  [5521] = 5521,
  [5522] = 5514,
  [5523] = 5515,
  [5524] = 5524,
  [5525] = 5478,
  [5526] = 5526,
  [5527] = 5527,
  [5528] = 5509,
  [5529] = 5529,
  [5530] = 5530,
  [5531] = 5531,
  [5532] = 5532,
  [5533] = 5533,
  [5534] = 5534,
  [5535] = 5515,
  [5536] = 5536,
  [5537] = 5504,
  [5538] = 5515,
  [5539] = 5539,
  [5540] = 5488,
  [5541] = 5478,
  [5542] = 5534,
  [5543] = 5491,
  [5544] = 5492,
  [5545] = 5493,
  [5546] = 5504,
  [5547] = 5547,
  [5548] = 5533,
  [5549] = 5549,
  [5550] = 5550,
  [5551] = 5551,
  [5552] = 5552,
  [5553] = 5501,
  [5554] = 5534,
  [5555] = 5506,
  [5556] = 5556,
  [5557] = 5557,
  [5558] = 5558,
  [5559] = 5504,
  [5560] = 5560,
  [5561] = 5561,
  [5562] = 5562,
  [5563] = 5530,
  [5564] = 5488,
  [5565] = 5478,
  [5566] = 5529,
  [5567] = 5491,
  [5568] = 5568,
  [5569] = 5569,
  [5570] = 5510,
  [5571] = 5514,
  [5572] = 5572,
  [5573] = 5504,
  [5574] = 5482,
  [5575] = 5536,
  [5576] = 5576,
  [5577] = 5577,
  [5578] = 5501,
  [5579] = 5579,
  [5580] = 5580,
  [5581] = 5581,
  [5582] = 5582,
  [5583] = 5495,
  [5584] = 5491,
  [5585] = 5585,
  [5586] = 5488,
  [5587] = 5514,
  [5588] = 5588,
  [5589] = 5558,
  [5590] = 5590,
  [5591] = 5591,
  [5592] = 5482,
  [5593] = 5593,
  [5594] = 5594,
  [5595] = 5595,
  [5596] = 5500,
  [5597] = 5510,
  [5598] = 5598,
  [5599] = 5492,
  [5600] = 5600,
  [5601] = 5493,
  [5602] = 5488,
  [5603] = 5478,
  [5604] = 5492,
  [5605] = 5510,
  [5606] = 5606,
  [5607] = 5491,
  [5608] = 5492,
  [5609] = 5493,
  [5610] = 5491,
  [5611] = 5581,
  [5612] = 5492,
  [5613] = 5493,
  [5614] = 5534,
  [5615] = 5615,
  [5616] = 5492,
  [5617] = 5504,
  [5618] = 5479,
  [5619] = 5493,
  [5620] = 5620,
  [5621] = 5501,
  [5622] = 5501,
  [5623] = 5623,
  [5624] = 5624,
  [5625] = 5625,
  [5626] = 5486,
  [5627] = 5524,
  [5628] = 5628,
  [5629] = 5629,
  [5630] = 5630,
  [5631] = 5623,
  [5632] = 5632,
  [5633] = 5495,
  [5634] = 5585,
  [5635] = 5635,
  [5636] = 5620,
  [5637] = 5637,
  [5638] = 5638,
  [5639] = 5527,
  [5640] = 5632,
  [5641] = 5514,
  [5642] = 5642,
  [5643] = 5493,
  [5644] = 5550,
  [5645] = 5645,
  [5646] = 5556,
  [5647] = 5591,
  [5648] = 5598,
  [5649] = 5649,
  [5650] = 5650,
  [5651] = 5494,
  [5652] = 5652,
  [5653] = 5645,
  [5654] = 5515,
  [5655] = 5655,
  [5656] = 5656,
  [5657] = 5628,
  [5658] = 5629,
  [5659] = 5534,
  [5660] = 5660,
  [5661] = 5534,
  [5662] = 5569,
  [5663] = 5635,
  [5664] = 5483,
  [5665] = 5519,
  [5666] = 5510,
  [5667] = 5667,
  [5668] = 5581,
  [5669] = 5581,
  [5670] = 5670,
  [5671] = 5486,
  [5672] = 5672,
  [5673] = 5526,
  [5674] = 5529,
  [5675] = 5530,
  [5676] = 5642,
  [5677] = 5495,
  [5678] = 5480,
  [5679] = 5623,
  [5680] = 5479,
  [5681] = 5480,
  [5682] = 5660,
  [5683] = 5511,
  [5684] = 5511,
  [5685] = 5494,
  [5686] = 5686,
  [5687] = 5569,
  [5688] = 5660,
  [5689] = 5550,
  [5690] = 5511,
  [5691] = 5691,
  [5692] = 5656,
  [5693] = 5551,
  [5694] = 5500,
  [5695] = 5506,
  [5696] = 5660,
  [5697] = 5511,
  [5698] = 5569,
  [5699] = 5534,
  [5700] = 5516,
  [5701] = 5701,
  [5702] = 5526,
  [5703] = 5703,
  [5704] = 5479,
  [5705] = 5502,
  [5706] = 5660,
  [5707] = 5531,
  [5708] = 5557,
  [5709] = 5511,
  [5710] = 5482,
  [5711] = 5561,
  [5712] = 5712,
  [5713] = 5572,
  [5714] = 5514,
  [5715] = 5569,
  [5716] = 5716,
  [5717] = 5480,
  [5718] = 5499,
  [5719] = 5551,
  [5720] = 5720,
  [5721] = 5569,
  [5722] = 5480,
  [5723] = 5723,
  [5724] = 5625,
  [5725] = 5519,
  [5726] = 5629,
  [5727] = 5488,
  [5728] = 5478,
  [5729] = 5729,
  [5730] = 5532,
  [5731] = 5731,
  [5732] = 5491,
  [5733] = 5733,
  [5734] = 5519,
  [5735] = 5526,
  [5736] = 5526,
  [5737] = 5510,
  [5738] = 5529,
  [5739] = 5529,
  [5740] = 5530,
  [5741] = 5550,
  [5742] = 5530,
  [5743] = 5492,
  [5744] = 5550,
  [5745] = 5500,
  [5746] = 5551,
  [5747] = 5483,
  [5748] = 5667,
  [5749] = 5493,
  [5750] = 5551,
  [5751] = 5576,
  [5752] = 5506,
  [5753] = 5506,
  [5754] = 5557,
  [5755] = 5524,
  [5756] = 5510,
  [5757] = 5561,
  [5758] = 5509,
  [5759] = 5572,
  [5760] = 5557,
  [5761] = 5561,
  [5762] = 5579,
  [5763] = 5533,
  [5764] = 5582,
  [5765] = 5500,
  [5766] = 5766,
  [5767] = 5536,
  [5768] = 5733,
  [5769] = 5572,
  [5770] = 5557,
  [5771] = 5558,
  [5772] = 5591,
  [5773] = 5598,
  [5774] = 5500,
  [5775] = 5561,
  [5776] = 5716,
  [5777] = 5777,
  [5778] = 5483,
  [5779] = 5667,
  [5780] = 5488,
  [5781] = 5781,
  [5782] = 5576,
  [5783] = 5478,
  [5784] = 5629,
  [5785] = 5482,
  [5786] = 5552,
  [5787] = 5623,
  [5788] = 5491,
  [5789] = 5524,
  [5790] = 5492,
  [5791] = 5493,
  [5792] = 5509,
  [5793] = 5533,
  [5794] = 5483,
  [5795] = 5536,
  [5796] = 5796,
  [5797] = 5501,
  [5798] = 5667,
  [5799] = 5558,
  [5800] = 5501,
  [5801] = 5628,
  [5802] = 5501,
  [5803] = 5629,
  [5804] = 5591,
  [5805] = 5598,
  [5806] = 5576,
  [5807] = 5524,
  [5808] = 5808,
  [5809] = 5733,
  [5810] = 5509,
  [5811] = 5495,
  [5812] = 5488,
  [5813] = 5533,
  [5814] = 5536,
  [5815] = 5482,
  [5816] = 5629,
  [5817] = 5628,
  [5818] = 5558,
  [5819] = 5686,
  [5820] = 5660,
  [5821] = 5691,
  [5822] = 5591,
  [5823] = 5808,
  [5824] = 5478,
  [5825] = 5825,
  [5826] = 5826,
  [5827] = 5482,
  [5828] = 5628,
  [5829] = 5598,
  [5830] = 5501,
  [5831] = 5660,
  [5832] = 5733,
  [5833] = 5488,
  [5834] = 5581,
  [5835] = 5482,
  [5836] = 5836,
  [5837] = 5593,
  [5838] = 5511,
  [5839] = 5482,
  [5840] = 5623,
  [5841] = 5491,
  [5842] = 5479,
  [5843] = 5492,
  [5844] = 5493,
  [5845] = 5733,
  [5846] = 5638,
  [5847] = 5701,
  [5848] = 5491,
  [5849] = 5623,
  [5850] = 5850,
  [5851] = 5485,
  [5852] = 5488,
  [5853] = 5569,
  [5854] = 5628,
  [5855] = 5629,
  [5856] = 5494,
  [5857] = 5502,
  [5858] = 5556,
  [5859] = 5590,
  [5860] = 5729,
  [5861] = 5507,
  [5862] = 5576,
  [5863] = 5572,
  [5864] = 5712,
  [5865] = 5478,
  [5866] = 5826,
  [5867] = 5481,
  [5868] = 5495,
  [5869] = 5500,
  [5870] = 5502,
  [5871] = 5871,
  [5872] = 5850,
  [5873] = 5520,
  [5874] = 5623,
  [5875] = 5519,
  [5876] = 5667,
  [5877] = 5628,
  [5878] = 5501,
  [5879] = 5879,
  [5880] = 5556,
  [5881] = 5588,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f}, {0x1681, 0x1fff},
  {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f},
  {0x1681, 0x1fff}, {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(97);
      ADVANCE_MAP(
        '!', 110,
        '"', 129,
        '#', 10,
        '$', 236,
        '%', 181,
        '&', 160,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 100,
        '+', 173,
        ',', 107,
        '-', 177,
        '.', 127,
        '/', 222,
        '0', 227,
        ':', 114,
        ';', 112,
        '<', 186,
        '=', 103,
        '>', 124,
        '?', 242,
        '@', 239,
        '[', 115,
        '\\', 55,
        ']', 116,
        '^', 163,
        '`', 220,
        '{', 106,
        '|', 166,
        '}', 108,
        '~', 198,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(94);
      if (lookahead > '@') ADVANCE(237);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(1);
      if (lookahead == '/') ADVANCE(118);
      if (lookahead == '<') ADVANCE(120);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(119);
      if (lookahead != 0) ADVANCE(117);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(29);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(223);
      if (lookahead != 0) ADVANCE(224);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 110,
        '"', 129,
        '#', 38,
        '%', 181,
        '&', 160,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 100,
        '+', 172,
        ',', 107,
        '-', 176,
        '.', 127,
        '/', 179,
        '0', 227,
        ':', 114,
        ';', 112,
        '<', 186,
        '=', 103,
        '>', 124,
        '?', 242,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '^', 163,
        '`', 220,
        '{', 105,
        '|', 165,
        '}', 108,
        '~', 198,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(3);
      if (lookahead > '#') ADVANCE(237);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 110,
        '"', 129,
        '#', 38,
        '%', 181,
        '&', 160,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 100,
        '+', 172,
        ',', 107,
        '-', 176,
        '.', 127,
        '/', 179,
        '0', 227,
        ':', 114,
        '<', 186,
        '=', 103,
        '>', 124,
        '?', 242,
        '@', 239,
        '[', 115,
        '\\', 57,
        '^', 163,
        '`', 220,
        '{', 106,
        '|', 165,
        '~', 198,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(4);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 110,
        '"', 129,
        '#', 38,
        '%', 181,
        '&', 160,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 100,
        '+', 172,
        ',', 107,
        '-', 176,
        '.', 128,
        '/', 179,
        '0', 227,
        ':', 114,
        ';', 112,
        '<', 185,
        '=', 103,
        '>', 124,
        '?', 242,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '^', 163,
        '`', 220,
        '{', 106,
        '|', 166,
        '}', 108,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 110,
        '"', 129,
        '%', 181,
        '&', 160,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 100,
        '+', 172,
        ',', 107,
        '-', 176,
        '.', 126,
        '/', 179,
        ':', 114,
        ';', 112,
        '<', 185,
        '=', 103,
        '>', 124,
        '?', 242,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '^', 163,
        '`', 220,
        '{', 105,
        '|', 165,
        '}', 108,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(6);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 110,
        '%', 180,
        '&', 161,
        '(', 111,
        ')', 113,
        '*', 101,
        '+', 171,
        ',', 107,
        '-', 175,
        '.', 126,
        '/', 178,
        ':', 114,
        ';', 112,
        '<', 187,
        '=', 102,
        '>', 125,
        '?', 243,
        '[', 115,
        '\\', 57,
        ']', 116,
        '^', 162,
        '`', 220,
        '{', 105,
        '|', 168,
        '}', 108,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(7);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 110,
        '%', 180,
        '&', 161,
        '(', 111,
        ')', 113,
        '*', 101,
        '+', 171,
        ',', 107,
        '-', 175,
        '.', 126,
        '/', 178,
        ':', 114,
        ';', 112,
        '<', 187,
        '=', 33,
        '>', 125,
        '?', 26,
        '[', 115,
        '\\', 57,
        ']', 116,
        '^', 162,
        '`', 220,
        '{', 105,
        '|', 167,
        '}', 108,
      );
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(225);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '`' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 110,
        '%', 180,
        '&', 161,
        '(', 111,
        ')', 113,
        '*', 101,
        '+', 171,
        ',', 107,
        '-', 175,
        '.', 126,
        '/', 178,
        ':', 114,
        ';', 112,
        '<', 187,
        '=', 33,
        '>', 125,
        '?', 26,
        '[', 115,
        '\\', 57,
        ']', 116,
        '^', 162,
        '`', 220,
        '{', 105,
        '|', 167,
        '}', 108,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(98);
      if (lookahead == '\\') ADVANCE(56);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(238);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 109,
        '"', 129,
        '#', 38,
        '&', 159,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 99,
        '+', 171,
        ',', 107,
        '-', 175,
        '.', 25,
        '/', 178,
        '0', 227,
        '<', 189,
        '?', 240,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '`', 220,
        '{', 106,
        '|', 164,
        '~', 198,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 109,
        '"', 129,
        '#', 38,
        '&', 159,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 99,
        '+', 170,
        ',', 107,
        '-', 174,
        '.', 127,
        '/', 22,
        '0', 227,
        ':', 114,
        ';', 112,
        '<', 184,
        '=', 104,
        '>', 123,
        '?', 240,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '`', 220,
        '{', 106,
        '|', 169,
        '}', 108,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(12);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '!', 109,
        '"', 129,
        '#', 38,
        '&', 159,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 99,
        '+', 170,
        ',', 107,
        '-', 174,
        '.', 127,
        '/', 22,
        '0', 227,
        ':', 114,
        ';', 112,
        '<', 184,
        '=', 104,
        '>', 123,
        '?', 240,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '{', 105,
        '|', 169,
        '}', 108,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(13);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '!', 109,
        '"', 129,
        '#', 38,
        '&', 159,
        '\'', 130,
        '(', 111,
        ')', 113,
        '+', 171,
        ',', 107,
        '-', 175,
        '.', 127,
        '/', 178,
        '0', 227,
        ':', 114,
        ';', 112,
        '<', 189,
        '=', 104,
        '>', 123,
        '?', 241,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '`', 220,
        '{', 105,
        '|', 169,
        '}', 108,
        '~', 198,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(14);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(237);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '"', 129,
        '&', 159,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 99,
        ',', 107,
        '.', 126,
        '/', 22,
        ':', 114,
        ';', 112,
        '<', 184,
        '=', 104,
        '>', 123,
        '?', 241,
        '[', 115,
        '\\', 57,
        ']', 116,
        '{', 105,
        '|', 169,
        '}', 108,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(15);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(237);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(129);
      if (lookahead == '/') ADVANCE(22);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(16);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(129);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(16);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(204);
      if (lookahead != 0) ADVANCE(206);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        '$', 59,
        '+', 36,
        '-', 37,
        '/', 22,
        ':', 114,
        '?', 32,
        '\\', 58,
        '`', 220,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(19);
      END_STATE();
    case 19:
      if (lookahead == '$') ADVANCE(59);
      if (lookahead == '+') ADVANCE(36);
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == ':') ADVANCE(114);
      if (lookahead == '?') ADVANCE(32);
      if (lookahead == '`') ADVANCE(220);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(19);
      END_STATE();
    case 20:
      if (lookahead == '\'') ADVANCE(130);
      if (lookahead == '/') ADVANCE(22);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(20);
      END_STATE();
    case 21:
      if (lookahead == '\'') ADVANCE(130);
      if (lookahead == '/') ADVANCE(207);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(20);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(210);
      if (lookahead != 0) ADVANCE(212);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(219);
      END_STATE();
    case 23:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(218);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(233);
      END_STATE();
    case 26:
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '?') ADVANCE(196);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(148);
      END_STATE();
    case 28:
      if (lookahead == '/') ADVANCE(222);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(29);
      END_STATE();
    case 29:
      if (lookahead == '/') ADVANCE(22);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(29);
      END_STATE();
    case 30:
      if (lookahead == ':') ADVANCE(245);
      END_STATE();
    case 31:
      if (lookahead == ':') ADVANCE(244);
      END_STATE();
    case 32:
      if (lookahead == ':') ADVANCE(246);
      END_STATE();
    case 33:
      if (lookahead == '=') ADVANCE(191);
      END_STATE();
    case 34:
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 35:
      if (lookahead == '>') ADVANCE(122);
      END_STATE();
    case 36:
      if (lookahead == '?') ADVANCE(30);
      END_STATE();
    case 37:
      if (lookahead == '?') ADVANCE(31);
      END_STATE();
    case 38:
      if (lookahead == '\\') ADVANCE(56);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(238);
      END_STATE();
    case 39:
      if (lookahead == '\\') ADVANCE(92);
      if (lookahead == ']') ADVANCE(224);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(39);
      END_STATE();
    case 40:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(53);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(40);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 48:
      if (lookahead == 'm') ADVANCE(50);
      END_STATE();
    case 49:
      if (lookahead == 'm') ADVANCE(51);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(46);
      END_STATE();
    case 51:
      if (lookahead == 'p') ADVANCE(47);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 54:
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 55:
      if (lookahead == 'u') ADVANCE(60);
      if (lookahead == 'x') ADVANCE(84);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(217);
      if (lookahead != 0) ADVANCE(213);
      END_STATE();
    case 56:
      if (lookahead == 'u') ADVANCE(61);
      END_STATE();
    case 57:
      if (lookahead == 'u') ADVANCE(62);
      END_STATE();
    case 58:
      if (lookahead == 'u') ADVANCE(63);
      if (lookahead == 'x') ADVANCE(84);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(217);
      if (lookahead != 0) ADVANCE(213);
      END_STATE();
    case 59:
      if (lookahead == '{') ADVANCE(221);
      END_STATE();
    case 60:
      if (lookahead == '{') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(89);
      END_STATE();
    case 61:
      if (lookahead == '{') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 62:
      if (lookahead == '{') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 63:
      if (lookahead == '{') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 64:
      if (lookahead == '}') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 65:
      if (lookahead == '}') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 66:
      if (lookahead == '}') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 67:
      if (lookahead == '}') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 68:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(234);
      END_STATE();
    case 69:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(230);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(231);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(228);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(233);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(229);
      END_STATE();
    case 74:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(234);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(237);
      END_STATE();
    case 76:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(238);
      END_STATE();
    case 77:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(213);
      END_STATE();
    case 78:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(232);
      END_STATE();
    case 79:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 80:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(214);
      END_STATE();
    case 81:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 82:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 83:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 84:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(77);
      END_STATE();
    case 85:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 86:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 87:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(76);
      END_STATE();
    case 88:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(75);
      END_STATE();
    case 89:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      END_STATE();
    case 90:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      END_STATE();
    case 91:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(88);
      END_STATE();
    case 92:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(39);
      END_STATE();
    case 93:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(224);
      END_STATE();
    case 94:
      if (eof) ADVANCE(97);
      ADVANCE_MAP(
        '!', 110,
        '"', 129,
        '#', 10,
        '$', 236,
        '%', 181,
        '&', 160,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 100,
        '+', 173,
        ',', 107,
        '-', 177,
        '.', 127,
        '/', 179,
        '0', 227,
        ':', 114,
        ';', 112,
        '<', 186,
        '=', 103,
        '>', 124,
        '?', 242,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '^', 163,
        '`', 220,
        '{', 106,
        '|', 166,
        '}', 108,
        '~', 198,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(94);
      if (lookahead > '@') ADVANCE(237);
      END_STATE();
    case 95:
      if (eof) ADVANCE(97);
      ADVANCE_MAP(
        '!', 110,
        '"', 129,
        '#', 38,
        '%', 180,
        '&', 161,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 101,
        '+', 171,
        ',', 107,
        '-', 175,
        '.', 128,
        '/', 178,
        '0', 227,
        ':', 114,
        ';', 112,
        '<', 188,
        '=', 102,
        '>', 125,
        '?', 26,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '^', 162,
        '`', 220,
        '{', 105,
        '|', 167,
        '}', 108,
        '~', 198,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(95);
      if (lookahead > '#') ADVANCE(237);
      END_STATE();
    case 96:
      if (eof) ADVANCE(97);
      ADVANCE_MAP(
        '!', 109,
        '"', 129,
        '#', 10,
        '&', 159,
        '\'', 130,
        '(', 111,
        ')', 113,
        '*', 99,
        '+', 171,
        ',', 107,
        '-', 175,
        '.', 127,
        '/', 178,
        '0', 227,
        ':', 114,
        ';', 112,
        '<', 189,
        '=', 104,
        '>', 123,
        '?', 240,
        '@', 239,
        '[', 115,
        '\\', 57,
        ']', 116,
        '`', 220,
        '{', 105,
        '|', 169,
        '}', 108,
        '~', 198,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(96);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(237);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(98);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(183);
      if (lookahead == '=') ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(182);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(191);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(191);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(247);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(193);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(219);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(118);
      if (lookahead == '<') ADVANCE(120);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n') ADVANCE(119);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(117);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(54);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_glimmer_opening_tag);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_glimmer_closing_tag);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(195);
      if (lookahead == '>') ADVANCE(153);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(195);
      if (lookahead == '>') ADVANCE(154);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(233);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(233);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(145);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(141);
      if (lookahead == '>') ADVANCE(156);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(143);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(150);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(149);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(140);
      if (lookahead == '|') ADVANCE(152);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(140);
      if (lookahead == '|') ADVANCE(152);
      if (lookahead == '}') ADVANCE(248);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(151);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(151);
      if (lookahead == '}') ADVANCE(248);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(248);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(199);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(199);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(199);
      if (lookahead == '=') ADVANCE(133);
      if (lookahead == '?') ADVANCE(30);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(200);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '=') ADVANCE(134);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '?') ADVANCE(31);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(219);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(219);
      if (lookahead == '=') ADVANCE(136);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(144);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(158);
      if (lookahead == '=') ADVANCE(190);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(158);
      if (lookahead == '=') ADVANCE(190);
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(190);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(190);
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(192);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(194);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(203);
      if (lookahead == '/') ADVANCE(205);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(206);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(202);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(203);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(202);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(201);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(204);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(206);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(206);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(209);
      if (lookahead == '/') ADVANCE(211);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(212);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(208);
      if (lookahead == '/') ADVANCE(212);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(209);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(208);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(207);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(210);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(212);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(212);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(211);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(212);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(57);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(237);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(213);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(213);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(216);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(29);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(223);
      if (lookahead != 0) ADVANCE(224);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(93);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(224);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(57);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(225);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(237);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 235,
        '0', 229,
        '_', 73,
        'n', 226,
        'B', 69,
        'b', 69,
        'E', 68,
        'e', 68,
        'O', 70,
        'o', 70,
        'X', 78,
        'x', 78,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(228);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(235);
      if (lookahead == '_') ADVANCE(71);
      if (lookahead == 'n') ADVANCE(226);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(228);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(73);
      if (lookahead == 'n') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(229);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(226);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(230);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(70);
      if (lookahead == 'n') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(231);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(78);
      if (lookahead == 'n') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(232);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(72);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(233);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(234);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(233);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead == '{') ADVANCE(221);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(237);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(57);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(237);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(56);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(238);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(132);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '?') ADVANCE(197);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '?') ADVANCE(196);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_PLUS_QMARK_COLON);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'k', 9,
        'l', 10,
        'm', 11,
        'n', 12,
        'o', 13,
        'p', 14,
        'r', 15,
        's', 16,
        't', 17,
        'u', 18,
        'v', 19,
        'w', 20,
        'y', 21,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 's') ADVANCE(25);
      if (lookahead == 'w') ADVANCE(26);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(42);
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(44);
      if (lookahead == 'm') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 13:
      if (lookahead == 'b') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'v') ADVANCE(57);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(61);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == 'u') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(68);
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'y') ADVANCE(70);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(71);
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(73);
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(75);
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 24:
      if (lookahead == 'y') ADVANCE(80);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 'y') ADVANCE(82);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(86);
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(88);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 32:
      if (lookahead == 'b') ADVANCE(90);
      if (lookahead == 'c') ADVANCE(91);
      if (lookahead == 'f') ADVANCE(92);
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(96);
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(99);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 40:
      if (lookahead == 'o') ADVANCE(101);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(105);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(106);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 48:
      if (lookahead == 'y') ADVANCE(109);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(112);
      END_STATE();
    case 52:
      if (lookahead == 'm') ADVANCE(113);
      END_STATE();
    case 53:
      if (lookahead == 'v') ADVANCE(114);
      if (lookahead == 'w') ADVANCE(115);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(116);
      if (lookahead == 'm') ADVANCE(117);
      END_STATE();
    case 55:
      if (lookahead == 'j') ADVANCE(118);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(120);
      if (lookahead == 'o') ADVANCE(121);
      END_STATE();
    case 59:
      if (lookahead == 'b') ADVANCE(122);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(123);
      if (lookahead == 'q') ADVANCE(124);
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(128);
      if (lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(130);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 66:
      if (lookahead == 'm') ADVANCE(132);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 69:
      if (lookahead == 'u') ADVANCE(136);
      if (lookahead == 'y') ADVANCE(137);
      END_STATE();
    case 70:
      if (lookahead == 'p') ADVANCE(138);
      END_STATE();
    case 71:
      if (lookahead == 'd') ADVANCE(139);
      if (lookahead == 'i') ADVANCE(140);
      if (lookahead == 'k') ADVANCE(141);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(145);
      END_STATE();
    case 76:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(151);
      END_STATE();
    case 83:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(153);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(154);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(156);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(157);
      END_STATE();
    case 89:
      if (lookahead == 's') ADVANCE(158);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 90:
      if (lookahead == 'u') ADVANCE(160);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(162);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 95:
      if (lookahead == 'm') ADVANCE(165);
      END_STATE();
    case 96:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(168);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(169);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 101:
      if (lookahead == 'm') ADVANCE(170);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 104:
      if (lookahead == 'b') ADVANCE(172);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(173);
      if (lookahead == 'o') ADVANCE(174);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 109:
      if (lookahead == 'o') ADVANCE(178);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 117:
      if (lookahead == 'b') ADVANCE(184);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(186);
      END_STATE();
    case 120:
      if (lookahead == 'v') ADVANCE(187);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(189);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 124:
      if (lookahead == 'u') ADVANCE(191);
      END_STATE();
    case 125:
      if (lookahead == 'u') ADVANCE(192);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 132:
      if (lookahead == 'b') ADVANCE(198);
      END_STATE();
    case 133:
      if (lookahead == 'g') ADVANCE(199);
      END_STATE();
    case 134:
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 135:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 140:
      if (lookahead == 'q') ADVANCE(205);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(206);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(207);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 146:
      if (lookahead == 'h') ADVANCE(210);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(211);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(213);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(215);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 154:
      if (lookahead == 'k') ADVANCE(218);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 156:
      if (lookahead == 'h') ADVANCE(219);
      END_STATE();
    case 157:
      if (lookahead == 's') ADVANCE(220);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(221);
      END_STATE();
    case 159:
      if (lookahead == 'i') ADVANCE(222);
      END_STATE();
    case 160:
      if (lookahead == 'g') ADVANCE(223);
      END_STATE();
    case 161:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 162:
      if (lookahead == 'u') ADVANCE(225);
      END_STATE();
    case 163:
      if (lookahead == 't') ADVANCE(226);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(227);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 169:
      if (lookahead == 'l') ADVANCE(230);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(231);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(232);
      END_STATE();
    case 173:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 174:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(237);
      END_STATE();
    case 178:
      if (lookahead == 'f') ADVANCE(238);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_meta);
      END_STATE();
    case 180:
      if (lookahead == 'l') ADVANCE(239);
      END_STATE();
    case 181:
      if (lookahead == 's') ADVANCE(240);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(241);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 184:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 185:
      if (lookahead == 'c') ADVANCE(243);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(244);
      END_STATE();
    case 187:
      if (lookahead == 'a') ADVANCE(245);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 189:
      if (lookahead == 'i') ADVANCE(247);
      END_STATE();
    case 190:
      if (lookahead == 'o') ADVANCE(248);
      END_STATE();
    case 191:
      if (lookahead == 'i') ADVANCE(249);
      END_STATE();
    case 192:
      if (lookahead == 'r') ADVANCE(250);
      END_STATE();
    case 193:
      if (lookahead == 's') ADVANCE(251);
      END_STATE();
    case 194:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(253);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 197:
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 198:
      if (lookahead == 'o') ADVANCE(256);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 201:
      if (lookahead == 'w') ADVANCE(258);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(259);
      END_STATE();
    case 204:
      if (lookahead == 'f') ADVANCE(260);
      END_STATE();
    case 205:
      if (lookahead == 'u') ADVANCE(261);
      END_STATE();
    case 206:
      if (lookahead == 'o') ADVANCE(262);
      END_STATE();
    case 207:
      if (lookahead == 'g') ADVANCE(263);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 211:
      if (lookahead == 'd') ADVANCE(265);
      END_STATE();
    case 212:
      if (lookahead == 'a') ADVANCE(266);
      END_STATE();
    case 213:
      if (lookahead == 's') ADVANCE(267);
      END_STATE();
    case 214:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 217:
      if (lookahead == 'a') ADVANCE(269);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(270);
      END_STATE();
    case 223:
      if (lookahead == 'g') ADVANCE(271);
      END_STATE();
    case 224:
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 225:
      if (lookahead == 'l') ADVANCE(273);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 227:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 228:
      if (lookahead == 'd') ADVANCE(276);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 230:
      if (lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 231:
      if (lookahead == 'i') ADVANCE(278);
      END_STATE();
    case 232:
      if (lookahead == 'l') ADVANCE(279);
      END_STATE();
    case 233:
      if (lookahead == 'm') ADVANCE(280);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 236:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 237:
      if (lookahead == 'f') ADVANCE(283);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 240:
      if (lookahead == 'p') ADVANCE(285);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 242:
      if (lookahead == 'r') ADVANCE(286);
      END_STATE();
    case 243:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(288);
      END_STATE();
    case 245:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 246:
      if (lookahead == 'c') ADVANCE(290);
      END_STATE();
    case 247:
      if (lookahead == 'c') ADVANCE(291);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(292);
      END_STATE();
    case 249:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 250:
      if (lookahead == 'n') ADVANCE(294);
      END_STATE();
    case 251:
      if (lookahead == 'f') ADVANCE(295);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(296);
      END_STATE();
    case 253:
      if (lookahead == 'g') ADVANCE(297);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 255:
      if (lookahead == 'h') ADVANCE(298);
      END_STATE();
    case 256:
      if (lookahead == 'l') ADVANCE(299);
      END_STATE();
    case 257:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 259:
      if (lookahead == 'f') ADVANCE(301);
      END_STATE();
    case 260:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 262:
      if (lookahead == 'w') ADVANCE(304);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 266:
      if (lookahead == 'c') ADVANCE(305);
      END_STATE();
    case 267:
      if (lookahead == 'o') ADVANCE(306);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_assert);
      if (lookahead == 's') ADVANCE(307);
      END_STATE();
    case 269:
      if (lookahead == 'n') ADVANCE(308);
      END_STATE();
    case 270:
      if (lookahead == 'u') ADVANCE(309);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(311);
      END_STATE();
    case 273:
      if (lookahead == 't') ADVANCE(312);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 276:
      if (lookahead == 's') ADVANCE(313);
      END_STATE();
    case 277:
      if (lookahead == 'y') ADVANCE(314);
      END_STATE();
    case 278:
      if (lookahead == 'o') ADVANCE(315);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 280:
      if (lookahead == 'e') ADVANCE(316);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 282:
      if (lookahead == 'c') ADVANCE(317);
      END_STATE();
    case 283:
      if (lookahead == 'a') ADVANCE(318);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 285:
      if (lookahead == 'a') ADVANCE(319);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 288:
      if (lookahead == 'd') ADVANCE(320);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(323);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 295:
      if (lookahead == 'i') ADVANCE(325);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 302:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 304:
      if (lookahead == 'n') ADVANCE(327);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(328);
      END_STATE();
    case 306:
      if (lookahead == 'r') ADVANCE(329);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 309:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 310:
      if (lookahead == 'r') ADVANCE(331);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 315:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 316:
      if (lookahead == 'n') ADVANCE(333);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 318:
      if (lookahead == 'c') ADVANCE(335);
      END_STATE();
    case 319:
      if (lookahead == 'c') ADVANCE(336);
      END_STATE();
    case 320:
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 322:
      if (lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 323:
      if (lookahead == 'y') ADVANCE(339);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 325:
      if (lookahead == 'e') ADVANCE(340);
      END_STATE();
    case 326:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_accessor);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(342);
      END_STATE();
    case 334:
      if (lookahead == 'o') ADVANCE(343);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(344);
      END_STATE();
    case 336:
      if (lookahead == 'e') ADVANCE(345);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 338:
      if (lookahead == 'd') ADVANCE(346);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 340:
      if (lookahead == 's') ADVANCE(347);
      END_STATE();
    case 341:
      if (lookahead == 'd') ADVANCE(348);
      END_STATE();
    case 342:
      if (lookahead == 's') ADVANCE(349);
      END_STATE();
    case 343:
      if (lookahead == 'f') ADVANCE(350);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_satisfies);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 96, .external_lex_state = 2},
  [2] = {.lex_state = 4, .external_lex_state = 3},
  [3] = {.lex_state = 4, .external_lex_state = 3},
  [4] = {.lex_state = 96, .external_lex_state = 2},
  [5] = {.lex_state = 96, .external_lex_state = 2},
  [6] = {.lex_state = 96, .external_lex_state = 2},
  [7] = {.lex_state = 96, .external_lex_state = 2},
  [8] = {.lex_state = 96, .external_lex_state = 2},
  [9] = {.lex_state = 96, .external_lex_state = 2},
  [10] = {.lex_state = 96, .external_lex_state = 2},
  [11] = {.lex_state = 96, .external_lex_state = 2},
  [12] = {.lex_state = 96, .external_lex_state = 2},
  [13] = {.lex_state = 96, .external_lex_state = 2},
  [14] = {.lex_state = 96, .external_lex_state = 2},
  [15] = {.lex_state = 96, .external_lex_state = 2},
  [16] = {.lex_state = 96, .external_lex_state = 2},
  [17] = {.lex_state = 96, .external_lex_state = 2},
  [18] = {.lex_state = 96, .external_lex_state = 2},
  [19] = {.lex_state = 96, .external_lex_state = 2},
  [20] = {.lex_state = 96, .external_lex_state = 2},
  [21] = {.lex_state = 96, .external_lex_state = 2},
  [22] = {.lex_state = 96, .external_lex_state = 2},
  [23] = {.lex_state = 96, .external_lex_state = 2},
  [24] = {.lex_state = 96, .external_lex_state = 2},
  [25] = {.lex_state = 96, .external_lex_state = 2},
  [26] = {.lex_state = 96, .external_lex_state = 2},
  [27] = {.lex_state = 96, .external_lex_state = 2},
  [28] = {.lex_state = 96, .external_lex_state = 2},
  [29] = {.lex_state = 96, .external_lex_state = 2},
  [30] = {.lex_state = 96, .external_lex_state = 2},
  [31] = {.lex_state = 96, .external_lex_state = 2},
  [32] = {.lex_state = 96, .external_lex_state = 2},
  [33] = {.lex_state = 96, .external_lex_state = 2},
  [34] = {.lex_state = 96, .external_lex_state = 2},
  [35] = {.lex_state = 96, .external_lex_state = 2},
  [36] = {.lex_state = 96, .external_lex_state = 2},
  [37] = {.lex_state = 96, .external_lex_state = 2},
  [38] = {.lex_state = 11, .external_lex_state = 2},
  [39] = {.lex_state = 96, .external_lex_state = 2},
  [40] = {.lex_state = 96, .external_lex_state = 2},
  [41] = {.lex_state = 96, .external_lex_state = 2},
  [42] = {.lex_state = 96, .external_lex_state = 2},
  [43] = {.lex_state = 96, .external_lex_state = 2},
  [44] = {.lex_state = 96, .external_lex_state = 2},
  [45] = {.lex_state = 96, .external_lex_state = 2},
  [46] = {.lex_state = 96, .external_lex_state = 2},
  [47] = {.lex_state = 96, .external_lex_state = 2},
  [48] = {.lex_state = 96, .external_lex_state = 2},
  [49] = {.lex_state = 96, .external_lex_state = 2},
  [50] = {.lex_state = 96, .external_lex_state = 2},
  [51] = {.lex_state = 96, .external_lex_state = 2},
  [52] = {.lex_state = 96, .external_lex_state = 2},
  [53] = {.lex_state = 96, .external_lex_state = 2},
  [54] = {.lex_state = 96, .external_lex_state = 2},
  [55] = {.lex_state = 96, .external_lex_state = 2},
  [56] = {.lex_state = 11, .external_lex_state = 2},
  [57] = {.lex_state = 96, .external_lex_state = 2},
  [58] = {.lex_state = 96, .external_lex_state = 2},
  [59] = {.lex_state = 96, .external_lex_state = 2},
  [60] = {.lex_state = 11, .external_lex_state = 2},
  [61] = {.lex_state = 96, .external_lex_state = 2},
  [62] = {.lex_state = 96, .external_lex_state = 2},
  [63] = {.lex_state = 11, .external_lex_state = 2},
  [64] = {.lex_state = 11, .external_lex_state = 2},
  [65] = {.lex_state = 96, .external_lex_state = 2},
  [66] = {.lex_state = 11, .external_lex_state = 2},
  [67] = {.lex_state = 11, .external_lex_state = 2},
  [68] = {.lex_state = 11, .external_lex_state = 2},
  [69] = {.lex_state = 11, .external_lex_state = 2},
  [70] = {.lex_state = 96, .external_lex_state = 2},
  [71] = {.lex_state = 11, .external_lex_state = 2},
  [72] = {.lex_state = 3, .external_lex_state = 4},
  [73] = {.lex_state = 3, .external_lex_state = 4},
  [74] = {.lex_state = 3, .external_lex_state = 4},
  [75] = {.lex_state = 3, .external_lex_state = 3},
  [76] = {.lex_state = 3, .external_lex_state = 3},
  [77] = {.lex_state = 11, .external_lex_state = 2},
  [78] = {.lex_state = 3, .external_lex_state = 3},
  [79] = {.lex_state = 3, .external_lex_state = 3},
  [80] = {.lex_state = 3, .external_lex_state = 3},
  [81] = {.lex_state = 3, .external_lex_state = 3},
  [82] = {.lex_state = 11, .external_lex_state = 2},
  [83] = {.lex_state = 3, .external_lex_state = 3},
  [84] = {.lex_state = 3, .external_lex_state = 3},
  [85] = {.lex_state = 11, .external_lex_state = 2},
  [86] = {.lex_state = 11, .external_lex_state = 2},
  [87] = {.lex_state = 3, .external_lex_state = 3},
  [88] = {.lex_state = 11, .external_lex_state = 2},
  [89] = {.lex_state = 3, .external_lex_state = 3},
  [90] = {.lex_state = 11, .external_lex_state = 2},
  [91] = {.lex_state = 11, .external_lex_state = 2},
  [92] = {.lex_state = 11, .external_lex_state = 2},
  [93] = {.lex_state = 3, .external_lex_state = 3},
  [94] = {.lex_state = 3, .external_lex_state = 3},
  [95] = {.lex_state = 3, .external_lex_state = 3},
  [96] = {.lex_state = 3, .external_lex_state = 4},
  [97] = {.lex_state = 3, .external_lex_state = 3},
  [98] = {.lex_state = 3, .external_lex_state = 3},
  [99] = {.lex_state = 3, .external_lex_state = 4},
  [100] = {.lex_state = 3, .external_lex_state = 4},
  [101] = {.lex_state = 3, .external_lex_state = 4},
  [102] = {.lex_state = 3, .external_lex_state = 4},
  [103] = {.lex_state = 3, .external_lex_state = 4},
  [104] = {.lex_state = 3, .external_lex_state = 4},
  [105] = {.lex_state = 3, .external_lex_state = 4},
  [106] = {.lex_state = 3, .external_lex_state = 3},
  [107] = {.lex_state = 3, .external_lex_state = 3},
  [108] = {.lex_state = 3, .external_lex_state = 3},
  [109] = {.lex_state = 3, .external_lex_state = 3},
  [110] = {.lex_state = 3, .external_lex_state = 3},
  [111] = {.lex_state = 3, .external_lex_state = 3},
  [112] = {.lex_state = 3, .external_lex_state = 3},
  [113] = {.lex_state = 3, .external_lex_state = 3},
  [114] = {.lex_state = 3, .external_lex_state = 3},
  [115] = {.lex_state = 3, .external_lex_state = 3},
  [116] = {.lex_state = 3, .external_lex_state = 3},
  [117] = {.lex_state = 3, .external_lex_state = 3},
  [118] = {.lex_state = 3, .external_lex_state = 4},
  [119] = {.lex_state = 3, .external_lex_state = 3},
  [120] = {.lex_state = 3, .external_lex_state = 4},
  [121] = {.lex_state = 3, .external_lex_state = 3},
  [122] = {.lex_state = 3, .external_lex_state = 3},
  [123] = {.lex_state = 3, .external_lex_state = 3},
  [124] = {.lex_state = 3, .external_lex_state = 3},
  [125] = {.lex_state = 3, .external_lex_state = 4},
  [126] = {.lex_state = 3, .external_lex_state = 3},
  [127] = {.lex_state = 3, .external_lex_state = 3},
  [128] = {.lex_state = 3, .external_lex_state = 3},
  [129] = {.lex_state = 3, .external_lex_state = 3},
  [130] = {.lex_state = 3, .external_lex_state = 3},
  [131] = {.lex_state = 3, .external_lex_state = 3},
  [132] = {.lex_state = 3, .external_lex_state = 3},
  [133] = {.lex_state = 3, .external_lex_state = 3},
  [134] = {.lex_state = 3, .external_lex_state = 3},
  [135] = {.lex_state = 3, .external_lex_state = 3},
  [136] = {.lex_state = 3, .external_lex_state = 3},
  [137] = {.lex_state = 3, .external_lex_state = 3},
  [138] = {.lex_state = 3, .external_lex_state = 3},
  [139] = {.lex_state = 3, .external_lex_state = 3},
  [140] = {.lex_state = 3, .external_lex_state = 3},
  [141] = {.lex_state = 3, .external_lex_state = 3},
  [142] = {.lex_state = 3, .external_lex_state = 3},
  [143] = {.lex_state = 3, .external_lex_state = 3},
  [144] = {.lex_state = 3, .external_lex_state = 3},
  [145] = {.lex_state = 3, .external_lex_state = 3},
  [146] = {.lex_state = 3, .external_lex_state = 3},
  [147] = {.lex_state = 11, .external_lex_state = 2},
  [148] = {.lex_state = 3, .external_lex_state = 3},
  [149] = {.lex_state = 3, .external_lex_state = 3},
  [150] = {.lex_state = 11, .external_lex_state = 2},
  [151] = {.lex_state = 11, .external_lex_state = 2},
  [152] = {.lex_state = 11, .external_lex_state = 2},
  [153] = {.lex_state = 11, .external_lex_state = 2},
  [154] = {.lex_state = 11, .external_lex_state = 2},
  [155] = {.lex_state = 11, .external_lex_state = 2},
  [156] = {.lex_state = 11, .external_lex_state = 2},
  [157] = {.lex_state = 11, .external_lex_state = 2},
  [158] = {.lex_state = 11, .external_lex_state = 2},
  [159] = {.lex_state = 11, .external_lex_state = 2},
  [160] = {.lex_state = 11, .external_lex_state = 2},
  [161] = {.lex_state = 11, .external_lex_state = 2},
  [162] = {.lex_state = 11, .external_lex_state = 2},
  [163] = {.lex_state = 95, .external_lex_state = 3},
  [164] = {.lex_state = 95, .external_lex_state = 4},
  [165] = {.lex_state = 95, .external_lex_state = 4},
  [166] = {.lex_state = 95, .external_lex_state = 3},
  [167] = {.lex_state = 95, .external_lex_state = 4},
  [168] = {.lex_state = 95, .external_lex_state = 3},
  [169] = {.lex_state = 95, .external_lex_state = 3},
  [170] = {.lex_state = 95, .external_lex_state = 3},
  [171] = {.lex_state = 95, .external_lex_state = 3},
  [172] = {.lex_state = 95, .external_lex_state = 3},
  [173] = {.lex_state = 5, .external_lex_state = 3},
  [174] = {.lex_state = 96, .external_lex_state = 2},
  [175] = {.lex_state = 96, .external_lex_state = 2},
  [176] = {.lex_state = 96, .external_lex_state = 2},
  [177] = {.lex_state = 5, .external_lex_state = 4},
  [178] = {.lex_state = 96, .external_lex_state = 2},
  [179] = {.lex_state = 5, .external_lex_state = 4},
  [180] = {.lex_state = 96, .external_lex_state = 2},
  [181] = {.lex_state = 96, .external_lex_state = 2},
  [182] = {.lex_state = 5, .external_lex_state = 3},
  [183] = {.lex_state = 5, .external_lex_state = 3},
  [184] = {.lex_state = 5, .external_lex_state = 3},
  [185] = {.lex_state = 5, .external_lex_state = 4},
  [186] = {.lex_state = 5, .external_lex_state = 3},
  [187] = {.lex_state = 5, .external_lex_state = 3},
  [188] = {.lex_state = 5, .external_lex_state = 3},
  [189] = {.lex_state = 5, .external_lex_state = 3},
  [190] = {.lex_state = 5, .external_lex_state = 3},
  [191] = {.lex_state = 5, .external_lex_state = 3},
  [192] = {.lex_state = 5, .external_lex_state = 3},
  [193] = {.lex_state = 5, .external_lex_state = 3},
  [194] = {.lex_state = 96, .external_lex_state = 2},
  [195] = {.lex_state = 96, .external_lex_state = 2},
  [196] = {.lex_state = 96, .external_lex_state = 2},
  [197] = {.lex_state = 96, .external_lex_state = 2},
  [198] = {.lex_state = 96, .external_lex_state = 2},
  [199] = {.lex_state = 96, .external_lex_state = 2},
  [200] = {.lex_state = 96, .external_lex_state = 2},
  [201] = {.lex_state = 96, .external_lex_state = 2},
  [202] = {.lex_state = 96, .external_lex_state = 2},
  [203] = {.lex_state = 96, .external_lex_state = 2},
  [204] = {.lex_state = 96, .external_lex_state = 2},
  [205] = {.lex_state = 96, .external_lex_state = 2},
  [206] = {.lex_state = 96, .external_lex_state = 2},
  [207] = {.lex_state = 95, .external_lex_state = 4},
  [208] = {.lex_state = 96, .external_lex_state = 2},
  [209] = {.lex_state = 95, .external_lex_state = 4},
  [210] = {.lex_state = 96, .external_lex_state = 2},
  [211] = {.lex_state = 95, .external_lex_state = 4},
  [212] = {.lex_state = 96, .external_lex_state = 2},
  [213] = {.lex_state = 95, .external_lex_state = 4},
  [214] = {.lex_state = 96, .external_lex_state = 2},
  [215] = {.lex_state = 96, .external_lex_state = 2},
  [216] = {.lex_state = 96, .external_lex_state = 2},
  [217] = {.lex_state = 95, .external_lex_state = 4},
  [218] = {.lex_state = 95, .external_lex_state = 4},
  [219] = {.lex_state = 95, .external_lex_state = 4},
  [220] = {.lex_state = 95, .external_lex_state = 4},
  [221] = {.lex_state = 95, .external_lex_state = 4},
  [222] = {.lex_state = 96, .external_lex_state = 2},
  [223] = {.lex_state = 95, .external_lex_state = 4},
  [224] = {.lex_state = 95, .external_lex_state = 4},
  [225] = {.lex_state = 95, .external_lex_state = 4},
  [226] = {.lex_state = 95, .external_lex_state = 4},
  [227] = {.lex_state = 95, .external_lex_state = 4},
  [228] = {.lex_state = 95, .external_lex_state = 4},
  [229] = {.lex_state = 95, .external_lex_state = 4},
  [230] = {.lex_state = 95, .external_lex_state = 4},
  [231] = {.lex_state = 96, .external_lex_state = 5},
  [232] = {.lex_state = 95, .external_lex_state = 4},
  [233] = {.lex_state = 95, .external_lex_state = 4},
  [234] = {.lex_state = 95, .external_lex_state = 4},
  [235] = {.lex_state = 95, .external_lex_state = 4},
  [236] = {.lex_state = 95, .external_lex_state = 4},
  [237] = {.lex_state = 95, .external_lex_state = 4},
  [238] = {.lex_state = 95, .external_lex_state = 4},
  [239] = {.lex_state = 95, .external_lex_state = 4},
  [240] = {.lex_state = 95, .external_lex_state = 4},
  [241] = {.lex_state = 95, .external_lex_state = 4},
  [242] = {.lex_state = 96, .external_lex_state = 2},
  [243] = {.lex_state = 95, .external_lex_state = 4},
  [244] = {.lex_state = 95, .external_lex_state = 4},
  [245] = {.lex_state = 96, .external_lex_state = 2},
  [246] = {.lex_state = 96, .external_lex_state = 2},
  [247] = {.lex_state = 96, .external_lex_state = 2},
  [248] = {.lex_state = 96, .external_lex_state = 2},
  [249] = {.lex_state = 96, .external_lex_state = 2},
  [250] = {.lex_state = 96, .external_lex_state = 2},
  [251] = {.lex_state = 96, .external_lex_state = 2},
  [252] = {.lex_state = 96, .external_lex_state = 2},
  [253] = {.lex_state = 96, .external_lex_state = 2},
  [254] = {.lex_state = 96, .external_lex_state = 2},
  [255] = {.lex_state = 96, .external_lex_state = 2},
  [256] = {.lex_state = 96, .external_lex_state = 2},
  [257] = {.lex_state = 96, .external_lex_state = 2},
  [258] = {.lex_state = 96, .external_lex_state = 2},
  [259] = {.lex_state = 96, .external_lex_state = 2},
  [260] = {.lex_state = 3, .external_lex_state = 3},
  [261] = {.lex_state = 96, .external_lex_state = 2},
  [262] = {.lex_state = 3, .external_lex_state = 3},
  [263] = {.lex_state = 96, .external_lex_state = 2},
  [264] = {.lex_state = 96, .external_lex_state = 2},
  [265] = {.lex_state = 96, .external_lex_state = 2},
  [266] = {.lex_state = 96, .external_lex_state = 2},
  [267] = {.lex_state = 96, .external_lex_state = 2},
  [268] = {.lex_state = 3, .external_lex_state = 3},
  [269] = {.lex_state = 3, .external_lex_state = 3},
  [270] = {.lex_state = 96, .external_lex_state = 2},
  [271] = {.lex_state = 96, .external_lex_state = 2},
  [272] = {.lex_state = 96, .external_lex_state = 2},
  [273] = {.lex_state = 96, .external_lex_state = 2},
  [274] = {.lex_state = 96, .external_lex_state = 2},
  [275] = {.lex_state = 96, .external_lex_state = 2},
  [276] = {.lex_state = 96, .external_lex_state = 2},
  [277] = {.lex_state = 96, .external_lex_state = 2},
  [278] = {.lex_state = 96, .external_lex_state = 2},
  [279] = {.lex_state = 96, .external_lex_state = 2},
  [280] = {.lex_state = 96, .external_lex_state = 2},
  [281] = {.lex_state = 96, .external_lex_state = 2},
  [282] = {.lex_state = 96, .external_lex_state = 2},
  [283] = {.lex_state = 96, .external_lex_state = 2},
  [284] = {.lex_state = 96, .external_lex_state = 2},
  [285] = {.lex_state = 96, .external_lex_state = 2},
  [286] = {.lex_state = 96, .external_lex_state = 2},
  [287] = {.lex_state = 96, .external_lex_state = 2},
  [288] = {.lex_state = 96, .external_lex_state = 2},
  [289] = {.lex_state = 96, .external_lex_state = 2},
  [290] = {.lex_state = 96, .external_lex_state = 2},
  [291] = {.lex_state = 96, .external_lex_state = 2},
  [292] = {.lex_state = 96, .external_lex_state = 2},
  [293] = {.lex_state = 96, .external_lex_state = 2},
  [294] = {.lex_state = 96, .external_lex_state = 2},
  [295] = {.lex_state = 96, .external_lex_state = 2},
  [296] = {.lex_state = 96, .external_lex_state = 2},
  [297] = {.lex_state = 96, .external_lex_state = 5},
  [298] = {.lex_state = 96, .external_lex_state = 2},
  [299] = {.lex_state = 96, .external_lex_state = 2},
  [300] = {.lex_state = 96, .external_lex_state = 2},
  [301] = {.lex_state = 96, .external_lex_state = 2},
  [302] = {.lex_state = 96, .external_lex_state = 2},
  [303] = {.lex_state = 96, .external_lex_state = 2},
  [304] = {.lex_state = 96, .external_lex_state = 2},
  [305] = {.lex_state = 96, .external_lex_state = 2},
  [306] = {.lex_state = 96, .external_lex_state = 2},
  [307] = {.lex_state = 96, .external_lex_state = 2},
  [308] = {.lex_state = 96, .external_lex_state = 2},
  [309] = {.lex_state = 96, .external_lex_state = 2},
  [310] = {.lex_state = 96, .external_lex_state = 2},
  [311] = {.lex_state = 96, .external_lex_state = 2},
  [312] = {.lex_state = 96, .external_lex_state = 2},
  [313] = {.lex_state = 96, .external_lex_state = 2},
  [314] = {.lex_state = 96, .external_lex_state = 2},
  [315] = {.lex_state = 96, .external_lex_state = 2},
  [316] = {.lex_state = 96, .external_lex_state = 2},
  [317] = {.lex_state = 96, .external_lex_state = 2},
  [318] = {.lex_state = 96, .external_lex_state = 2},
  [319] = {.lex_state = 96, .external_lex_state = 2},
  [320] = {.lex_state = 96, .external_lex_state = 2},
  [321] = {.lex_state = 96, .external_lex_state = 2},
  [322] = {.lex_state = 96, .external_lex_state = 2},
  [323] = {.lex_state = 96, .external_lex_state = 2},
  [324] = {.lex_state = 96, .external_lex_state = 2},
  [325] = {.lex_state = 96, .external_lex_state = 2},
  [326] = {.lex_state = 96, .external_lex_state = 2},
  [327] = {.lex_state = 96, .external_lex_state = 2},
  [328] = {.lex_state = 96, .external_lex_state = 2},
  [329] = {.lex_state = 96, .external_lex_state = 2},
  [330] = {.lex_state = 96, .external_lex_state = 2},
  [331] = {.lex_state = 96, .external_lex_state = 2},
  [332] = {.lex_state = 96, .external_lex_state = 2},
  [333] = {.lex_state = 96, .external_lex_state = 2},
  [334] = {.lex_state = 96, .external_lex_state = 2},
  [335] = {.lex_state = 96, .external_lex_state = 2},
  [336] = {.lex_state = 96, .external_lex_state = 2},
  [337] = {.lex_state = 96, .external_lex_state = 2},
  [338] = {.lex_state = 96, .external_lex_state = 2},
  [339] = {.lex_state = 96, .external_lex_state = 2},
  [340] = {.lex_state = 96, .external_lex_state = 2},
  [341] = {.lex_state = 96, .external_lex_state = 2},
  [342] = {.lex_state = 96, .external_lex_state = 2},
  [343] = {.lex_state = 96, .external_lex_state = 2},
  [344] = {.lex_state = 96, .external_lex_state = 2},
  [345] = {.lex_state = 96, .external_lex_state = 2},
  [346] = {.lex_state = 96, .external_lex_state = 2},
  [347] = {.lex_state = 96, .external_lex_state = 2},
  [348] = {.lex_state = 96, .external_lex_state = 2},
  [349] = {.lex_state = 96, .external_lex_state = 2},
  [350] = {.lex_state = 96, .external_lex_state = 2},
  [351] = {.lex_state = 96, .external_lex_state = 2},
  [352] = {.lex_state = 96, .external_lex_state = 2},
  [353] = {.lex_state = 96, .external_lex_state = 2},
  [354] = {.lex_state = 96, .external_lex_state = 2},
  [355] = {.lex_state = 96, .external_lex_state = 2},
  [356] = {.lex_state = 96, .external_lex_state = 2},
  [357] = {.lex_state = 96, .external_lex_state = 2},
  [358] = {.lex_state = 96, .external_lex_state = 2},
  [359] = {.lex_state = 96, .external_lex_state = 2},
  [360] = {.lex_state = 96, .external_lex_state = 2},
  [361] = {.lex_state = 96, .external_lex_state = 2},
  [362] = {.lex_state = 96, .external_lex_state = 2},
  [363] = {.lex_state = 96, .external_lex_state = 2},
  [364] = {.lex_state = 96, .external_lex_state = 2},
  [365] = {.lex_state = 96, .external_lex_state = 2},
  [366] = {.lex_state = 96, .external_lex_state = 2},
  [367] = {.lex_state = 96, .external_lex_state = 2},
  [368] = {.lex_state = 96, .external_lex_state = 2},
  [369] = {.lex_state = 96, .external_lex_state = 2},
  [370] = {.lex_state = 96, .external_lex_state = 2},
  [371] = {.lex_state = 96, .external_lex_state = 2},
  [372] = {.lex_state = 96, .external_lex_state = 2},
  [373] = {.lex_state = 96, .external_lex_state = 2},
  [374] = {.lex_state = 96, .external_lex_state = 2},
  [375] = {.lex_state = 96, .external_lex_state = 2},
  [376] = {.lex_state = 96, .external_lex_state = 2},
  [377] = {.lex_state = 96, .external_lex_state = 2},
  [378] = {.lex_state = 96, .external_lex_state = 2},
  [379] = {.lex_state = 96, .external_lex_state = 2},
  [380] = {.lex_state = 96, .external_lex_state = 2},
  [381] = {.lex_state = 96, .external_lex_state = 2},
  [382] = {.lex_state = 96, .external_lex_state = 2},
  [383] = {.lex_state = 96, .external_lex_state = 2},
  [384] = {.lex_state = 96, .external_lex_state = 2},
  [385] = {.lex_state = 96, .external_lex_state = 2},
  [386] = {.lex_state = 96, .external_lex_state = 2},
  [387] = {.lex_state = 96, .external_lex_state = 2},
  [388] = {.lex_state = 96, .external_lex_state = 2},
  [389] = {.lex_state = 96, .external_lex_state = 2},
  [390] = {.lex_state = 96, .external_lex_state = 2},
  [391] = {.lex_state = 96, .external_lex_state = 2},
  [392] = {.lex_state = 96, .external_lex_state = 2},
  [393] = {.lex_state = 96, .external_lex_state = 2},
  [394] = {.lex_state = 96, .external_lex_state = 2},
  [395] = {.lex_state = 96, .external_lex_state = 2},
  [396] = {.lex_state = 96, .external_lex_state = 2},
  [397] = {.lex_state = 96, .external_lex_state = 2},
  [398] = {.lex_state = 96, .external_lex_state = 2},
  [399] = {.lex_state = 96, .external_lex_state = 2},
  [400] = {.lex_state = 96, .external_lex_state = 2},
  [401] = {.lex_state = 96, .external_lex_state = 2},
  [402] = {.lex_state = 96, .external_lex_state = 2},
  [403] = {.lex_state = 96, .external_lex_state = 2},
  [404] = {.lex_state = 96, .external_lex_state = 2},
  [405] = {.lex_state = 96, .external_lex_state = 2},
  [406] = {.lex_state = 96, .external_lex_state = 2},
  [407] = {.lex_state = 96, .external_lex_state = 2},
  [408] = {.lex_state = 96, .external_lex_state = 2},
  [409] = {.lex_state = 96, .external_lex_state = 2},
  [410] = {.lex_state = 96, .external_lex_state = 2},
  [411] = {.lex_state = 96, .external_lex_state = 2},
  [412] = {.lex_state = 96, .external_lex_state = 2},
  [413] = {.lex_state = 96, .external_lex_state = 2},
  [414] = {.lex_state = 96, .external_lex_state = 2},
  [415] = {.lex_state = 96, .external_lex_state = 2},
  [416] = {.lex_state = 96, .external_lex_state = 2},
  [417] = {.lex_state = 96, .external_lex_state = 2},
  [418] = {.lex_state = 96, .external_lex_state = 2},
  [419] = {.lex_state = 96, .external_lex_state = 2},
  [420] = {.lex_state = 96, .external_lex_state = 2},
  [421] = {.lex_state = 96, .external_lex_state = 2},
  [422] = {.lex_state = 96, .external_lex_state = 2},
  [423] = {.lex_state = 96, .external_lex_state = 2},
  [424] = {.lex_state = 96, .external_lex_state = 2},
  [425] = {.lex_state = 96, .external_lex_state = 2},
  [426] = {.lex_state = 96, .external_lex_state = 2},
  [427] = {.lex_state = 96, .external_lex_state = 2},
  [428] = {.lex_state = 96, .external_lex_state = 2},
  [429] = {.lex_state = 96, .external_lex_state = 2},
  [430] = {.lex_state = 96, .external_lex_state = 2},
  [431] = {.lex_state = 96, .external_lex_state = 2},
  [432] = {.lex_state = 96, .external_lex_state = 2},
  [433] = {.lex_state = 96, .external_lex_state = 2},
  [434] = {.lex_state = 96, .external_lex_state = 2},
  [435] = {.lex_state = 96, .external_lex_state = 2},
  [436] = {.lex_state = 96, .external_lex_state = 2},
  [437] = {.lex_state = 96, .external_lex_state = 2},
  [438] = {.lex_state = 96, .external_lex_state = 2},
  [439] = {.lex_state = 96, .external_lex_state = 2},
  [440] = {.lex_state = 96, .external_lex_state = 2},
  [441] = {.lex_state = 96, .external_lex_state = 2},
  [442] = {.lex_state = 96, .external_lex_state = 2},
  [443] = {.lex_state = 96, .external_lex_state = 2},
  [444] = {.lex_state = 96, .external_lex_state = 2},
  [445] = {.lex_state = 96, .external_lex_state = 2},
  [446] = {.lex_state = 96, .external_lex_state = 2},
  [447] = {.lex_state = 96, .external_lex_state = 2},
  [448] = {.lex_state = 96, .external_lex_state = 2},
  [449] = {.lex_state = 96, .external_lex_state = 2},
  [450] = {.lex_state = 96, .external_lex_state = 2},
  [451] = {.lex_state = 96, .external_lex_state = 2},
  [452] = {.lex_state = 96, .external_lex_state = 2},
  [453] = {.lex_state = 96, .external_lex_state = 2},
  [454] = {.lex_state = 96, .external_lex_state = 2},
  [455] = {.lex_state = 96, .external_lex_state = 2},
  [456] = {.lex_state = 96, .external_lex_state = 2},
  [457] = {.lex_state = 96, .external_lex_state = 2},
  [458] = {.lex_state = 96, .external_lex_state = 2},
  [459] = {.lex_state = 96, .external_lex_state = 2},
  [460] = {.lex_state = 96, .external_lex_state = 2},
  [461] = {.lex_state = 96, .external_lex_state = 2},
  [462] = {.lex_state = 96, .external_lex_state = 2},
  [463] = {.lex_state = 96, .external_lex_state = 2},
  [464] = {.lex_state = 96, .external_lex_state = 2},
  [465] = {.lex_state = 96, .external_lex_state = 2},
  [466] = {.lex_state = 96, .external_lex_state = 2},
  [467] = {.lex_state = 96, .external_lex_state = 2},
  [468] = {.lex_state = 96, .external_lex_state = 2},
  [469] = {.lex_state = 96, .external_lex_state = 2},
  [470] = {.lex_state = 96, .external_lex_state = 2},
  [471] = {.lex_state = 96, .external_lex_state = 2},
  [472] = {.lex_state = 96, .external_lex_state = 2},
  [473] = {.lex_state = 96, .external_lex_state = 2},
  [474] = {.lex_state = 96, .external_lex_state = 2},
  [475] = {.lex_state = 96, .external_lex_state = 2},
  [476] = {.lex_state = 96, .external_lex_state = 2},
  [477] = {.lex_state = 96, .external_lex_state = 2},
  [478] = {.lex_state = 96, .external_lex_state = 2},
  [479] = {.lex_state = 96, .external_lex_state = 2},
  [480] = {.lex_state = 96, .external_lex_state = 2},
  [481] = {.lex_state = 96, .external_lex_state = 2},
  [482] = {.lex_state = 96, .external_lex_state = 2},
  [483] = {.lex_state = 96, .external_lex_state = 2},
  [484] = {.lex_state = 96, .external_lex_state = 2},
  [485] = {.lex_state = 96, .external_lex_state = 2},
  [486] = {.lex_state = 96, .external_lex_state = 2},
  [487] = {.lex_state = 96, .external_lex_state = 2},
  [488] = {.lex_state = 96, .external_lex_state = 2},
  [489] = {.lex_state = 96, .external_lex_state = 2},
  [490] = {.lex_state = 96, .external_lex_state = 2},
  [491] = {.lex_state = 96, .external_lex_state = 2},
  [492] = {.lex_state = 96, .external_lex_state = 2},
  [493] = {.lex_state = 96, .external_lex_state = 2},
  [494] = {.lex_state = 96, .external_lex_state = 2},
  [495] = {.lex_state = 96, .external_lex_state = 2},
  [496] = {.lex_state = 96, .external_lex_state = 2},
  [497] = {.lex_state = 96, .external_lex_state = 2},
  [498] = {.lex_state = 96, .external_lex_state = 2},
  [499] = {.lex_state = 96, .external_lex_state = 2},
  [500] = {.lex_state = 96, .external_lex_state = 2},
  [501] = {.lex_state = 96, .external_lex_state = 2},
  [502] = {.lex_state = 96, .external_lex_state = 2},
  [503] = {.lex_state = 96, .external_lex_state = 2},
  [504] = {.lex_state = 96, .external_lex_state = 2},
  [505] = {.lex_state = 96, .external_lex_state = 2},
  [506] = {.lex_state = 96, .external_lex_state = 2},
  [507] = {.lex_state = 96, .external_lex_state = 2},
  [508] = {.lex_state = 96, .external_lex_state = 2},
  [509] = {.lex_state = 96, .external_lex_state = 2},
  [510] = {.lex_state = 96, .external_lex_state = 2},
  [511] = {.lex_state = 96, .external_lex_state = 2},
  [512] = {.lex_state = 96, .external_lex_state = 2},
  [513] = {.lex_state = 96, .external_lex_state = 2},
  [514] = {.lex_state = 96, .external_lex_state = 2},
  [515] = {.lex_state = 96, .external_lex_state = 2},
  [516] = {.lex_state = 96, .external_lex_state = 2},
  [517] = {.lex_state = 96, .external_lex_state = 2},
  [518] = {.lex_state = 96, .external_lex_state = 2},
  [519] = {.lex_state = 96, .external_lex_state = 2},
  [520] = {.lex_state = 96, .external_lex_state = 2},
  [521] = {.lex_state = 96, .external_lex_state = 2},
  [522] = {.lex_state = 96, .external_lex_state = 2},
  [523] = {.lex_state = 96, .external_lex_state = 2},
  [524] = {.lex_state = 96, .external_lex_state = 2},
  [525] = {.lex_state = 96, .external_lex_state = 2},
  [526] = {.lex_state = 96, .external_lex_state = 2},
  [527] = {.lex_state = 96, .external_lex_state = 2},
  [528] = {.lex_state = 96, .external_lex_state = 2},
  [529] = {.lex_state = 96, .external_lex_state = 2},
  [530] = {.lex_state = 96, .external_lex_state = 2},
  [531] = {.lex_state = 96, .external_lex_state = 2},
  [532] = {.lex_state = 96, .external_lex_state = 2},
  [533] = {.lex_state = 96, .external_lex_state = 2},
  [534] = {.lex_state = 96, .external_lex_state = 2},
  [535] = {.lex_state = 96, .external_lex_state = 2},
  [536] = {.lex_state = 96, .external_lex_state = 2},
  [537] = {.lex_state = 96, .external_lex_state = 2},
  [538] = {.lex_state = 96, .external_lex_state = 2},
  [539] = {.lex_state = 96, .external_lex_state = 2},
  [540] = {.lex_state = 96, .external_lex_state = 2},
  [541] = {.lex_state = 96, .external_lex_state = 2},
  [542] = {.lex_state = 96, .external_lex_state = 2},
  [543] = {.lex_state = 96, .external_lex_state = 2},
  [544] = {.lex_state = 96, .external_lex_state = 2},
  [545] = {.lex_state = 96, .external_lex_state = 2},
  [546] = {.lex_state = 96, .external_lex_state = 2},
  [547] = {.lex_state = 96, .external_lex_state = 2},
  [548] = {.lex_state = 96, .external_lex_state = 2},
  [549] = {.lex_state = 96, .external_lex_state = 2},
  [550] = {.lex_state = 96, .external_lex_state = 2},
  [551] = {.lex_state = 96, .external_lex_state = 2},
  [552] = {.lex_state = 96, .external_lex_state = 2},
  [553] = {.lex_state = 96, .external_lex_state = 2},
  [554] = {.lex_state = 96, .external_lex_state = 2},
  [555] = {.lex_state = 96, .external_lex_state = 2},
  [556] = {.lex_state = 96, .external_lex_state = 2},
  [557] = {.lex_state = 96, .external_lex_state = 2},
  [558] = {.lex_state = 96, .external_lex_state = 2},
  [559] = {.lex_state = 96, .external_lex_state = 2},
  [560] = {.lex_state = 96, .external_lex_state = 2},
  [561] = {.lex_state = 96, .external_lex_state = 2},
  [562] = {.lex_state = 96, .external_lex_state = 2},
  [563] = {.lex_state = 96, .external_lex_state = 2},
  [564] = {.lex_state = 96, .external_lex_state = 2},
  [565] = {.lex_state = 96, .external_lex_state = 2},
  [566] = {.lex_state = 96, .external_lex_state = 2},
  [567] = {.lex_state = 96, .external_lex_state = 2},
  [568] = {.lex_state = 96, .external_lex_state = 2},
  [569] = {.lex_state = 96, .external_lex_state = 2},
  [570] = {.lex_state = 96, .external_lex_state = 2},
  [571] = {.lex_state = 96, .external_lex_state = 2},
  [572] = {.lex_state = 96, .external_lex_state = 2},
  [573] = {.lex_state = 96, .external_lex_state = 2},
  [574] = {.lex_state = 96, .external_lex_state = 2},
  [575] = {.lex_state = 96, .external_lex_state = 2},
  [576] = {.lex_state = 96, .external_lex_state = 2},
  [577] = {.lex_state = 96, .external_lex_state = 2},
  [578] = {.lex_state = 96, .external_lex_state = 2},
  [579] = {.lex_state = 96, .external_lex_state = 2},
  [580] = {.lex_state = 96, .external_lex_state = 2},
  [581] = {.lex_state = 96, .external_lex_state = 2},
  [582] = {.lex_state = 96, .external_lex_state = 2},
  [583] = {.lex_state = 96, .external_lex_state = 2},
  [584] = {.lex_state = 96, .external_lex_state = 2},
  [585] = {.lex_state = 96, .external_lex_state = 2},
  [586] = {.lex_state = 96, .external_lex_state = 2},
  [587] = {.lex_state = 96, .external_lex_state = 2},
  [588] = {.lex_state = 96, .external_lex_state = 2},
  [589] = {.lex_state = 96, .external_lex_state = 2},
  [590] = {.lex_state = 96, .external_lex_state = 2},
  [591] = {.lex_state = 96, .external_lex_state = 2},
  [592] = {.lex_state = 96, .external_lex_state = 2},
  [593] = {.lex_state = 96, .external_lex_state = 2},
  [594] = {.lex_state = 96, .external_lex_state = 2},
  [595] = {.lex_state = 96, .external_lex_state = 2},
  [596] = {.lex_state = 96, .external_lex_state = 2},
  [597] = {.lex_state = 96, .external_lex_state = 2},
  [598] = {.lex_state = 96, .external_lex_state = 2},
  [599] = {.lex_state = 96, .external_lex_state = 2},
  [600] = {.lex_state = 96, .external_lex_state = 2},
  [601] = {.lex_state = 96, .external_lex_state = 2},
  [602] = {.lex_state = 96, .external_lex_state = 2},
  [603] = {.lex_state = 96, .external_lex_state = 2},
  [604] = {.lex_state = 96, .external_lex_state = 2},
  [605] = {.lex_state = 96, .external_lex_state = 2},
  [606] = {.lex_state = 96, .external_lex_state = 2},
  [607] = {.lex_state = 96, .external_lex_state = 2},
  [608] = {.lex_state = 96, .external_lex_state = 2},
  [609] = {.lex_state = 96, .external_lex_state = 2},
  [610] = {.lex_state = 96, .external_lex_state = 2},
  [611] = {.lex_state = 96, .external_lex_state = 2},
  [612] = {.lex_state = 96, .external_lex_state = 2},
  [613] = {.lex_state = 96, .external_lex_state = 2},
  [614] = {.lex_state = 96, .external_lex_state = 2},
  [615] = {.lex_state = 96, .external_lex_state = 2},
  [616] = {.lex_state = 96, .external_lex_state = 2},
  [617] = {.lex_state = 96, .external_lex_state = 2},
  [618] = {.lex_state = 96, .external_lex_state = 2},
  [619] = {.lex_state = 96, .external_lex_state = 2},
  [620] = {.lex_state = 96, .external_lex_state = 2},
  [621] = {.lex_state = 96, .external_lex_state = 2},
  [622] = {.lex_state = 96, .external_lex_state = 2},
  [623] = {.lex_state = 96, .external_lex_state = 2},
  [624] = {.lex_state = 96, .external_lex_state = 2},
  [625] = {.lex_state = 96, .external_lex_state = 2},
  [626] = {.lex_state = 96, .external_lex_state = 2},
  [627] = {.lex_state = 96, .external_lex_state = 2},
  [628] = {.lex_state = 96, .external_lex_state = 2},
  [629] = {.lex_state = 96, .external_lex_state = 2},
  [630] = {.lex_state = 96, .external_lex_state = 2},
  [631] = {.lex_state = 96, .external_lex_state = 2},
  [632] = {.lex_state = 96, .external_lex_state = 2},
  [633] = {.lex_state = 96, .external_lex_state = 2},
  [634] = {.lex_state = 96, .external_lex_state = 2},
  [635] = {.lex_state = 96, .external_lex_state = 2},
  [636] = {.lex_state = 96, .external_lex_state = 2},
  [637] = {.lex_state = 96, .external_lex_state = 2},
  [638] = {.lex_state = 96, .external_lex_state = 2},
  [639] = {.lex_state = 96, .external_lex_state = 2},
  [640] = {.lex_state = 96, .external_lex_state = 2},
  [641] = {.lex_state = 96, .external_lex_state = 2},
  [642] = {.lex_state = 96, .external_lex_state = 2},
  [643] = {.lex_state = 96, .external_lex_state = 2},
  [644] = {.lex_state = 96, .external_lex_state = 2},
  [645] = {.lex_state = 96, .external_lex_state = 2},
  [646] = {.lex_state = 96, .external_lex_state = 2},
  [647] = {.lex_state = 96, .external_lex_state = 2},
  [648] = {.lex_state = 96, .external_lex_state = 2},
  [649] = {.lex_state = 96, .external_lex_state = 2},
  [650] = {.lex_state = 96, .external_lex_state = 2},
  [651] = {.lex_state = 96, .external_lex_state = 2},
  [652] = {.lex_state = 96, .external_lex_state = 2},
  [653] = {.lex_state = 96, .external_lex_state = 2},
  [654] = {.lex_state = 96, .external_lex_state = 2},
  [655] = {.lex_state = 96, .external_lex_state = 2},
  [656] = {.lex_state = 96, .external_lex_state = 2},
  [657] = {.lex_state = 96, .external_lex_state = 2},
  [658] = {.lex_state = 96, .external_lex_state = 2},
  [659] = {.lex_state = 96, .external_lex_state = 2},
  [660] = {.lex_state = 96, .external_lex_state = 2},
  [661] = {.lex_state = 96, .external_lex_state = 2},
  [662] = {.lex_state = 96, .external_lex_state = 2},
  [663] = {.lex_state = 96, .external_lex_state = 2},
  [664] = {.lex_state = 96, .external_lex_state = 2},
  [665] = {.lex_state = 96, .external_lex_state = 2},
  [666] = {.lex_state = 96, .external_lex_state = 2},
  [667] = {.lex_state = 96, .external_lex_state = 2},
  [668] = {.lex_state = 96, .external_lex_state = 2},
  [669] = {.lex_state = 96, .external_lex_state = 2},
  [670] = {.lex_state = 96, .external_lex_state = 2},
  [671] = {.lex_state = 96, .external_lex_state = 2},
  [672] = {.lex_state = 96, .external_lex_state = 2},
  [673] = {.lex_state = 96, .external_lex_state = 2},
  [674] = {.lex_state = 96, .external_lex_state = 2},
  [675] = {.lex_state = 96, .external_lex_state = 2},
  [676] = {.lex_state = 96, .external_lex_state = 2},
  [677] = {.lex_state = 96, .external_lex_state = 2},
  [678] = {.lex_state = 96, .external_lex_state = 2},
  [679] = {.lex_state = 96, .external_lex_state = 2},
  [680] = {.lex_state = 96, .external_lex_state = 2},
  [681] = {.lex_state = 96, .external_lex_state = 2},
  [682] = {.lex_state = 96, .external_lex_state = 2},
  [683] = {.lex_state = 96, .external_lex_state = 2},
  [684] = {.lex_state = 96, .external_lex_state = 2},
  [685] = {.lex_state = 96, .external_lex_state = 2},
  [686] = {.lex_state = 96, .external_lex_state = 2},
  [687] = {.lex_state = 6, .external_lex_state = 4},
  [688] = {.lex_state = 6, .external_lex_state = 4},
  [689] = {.lex_state = 6, .external_lex_state = 4},
  [690] = {.lex_state = 5, .external_lex_state = 4},
  [691] = {.lex_state = 5, .external_lex_state = 4},
  [692] = {.lex_state = 5, .external_lex_state = 4},
  [693] = {.lex_state = 5, .external_lex_state = 4},
  [694] = {.lex_state = 5, .external_lex_state = 4},
  [695] = {.lex_state = 5, .external_lex_state = 4},
  [696] = {.lex_state = 6, .external_lex_state = 4},
  [697] = {.lex_state = 6, .external_lex_state = 4},
  [698] = {.lex_state = 5, .external_lex_state = 4},
  [699] = {.lex_state = 5, .external_lex_state = 4},
  [700] = {.lex_state = 5, .external_lex_state = 4},
  [701] = {.lex_state = 5, .external_lex_state = 4},
  [702] = {.lex_state = 5, .external_lex_state = 4},
  [703] = {.lex_state = 5, .external_lex_state = 4},
  [704] = {.lex_state = 5, .external_lex_state = 4},
  [705] = {.lex_state = 96, .external_lex_state = 2},
  [706] = {.lex_state = 96, .external_lex_state = 2},
  [707] = {.lex_state = 5, .external_lex_state = 4},
  [708] = {.lex_state = 5, .external_lex_state = 4},
  [709] = {.lex_state = 5, .external_lex_state = 4},
  [710] = {.lex_state = 96, .external_lex_state = 2},
  [711] = {.lex_state = 96, .external_lex_state = 2},
  [712] = {.lex_state = 96, .external_lex_state = 2},
  [713] = {.lex_state = 96, .external_lex_state = 2},
  [714] = {.lex_state = 96, .external_lex_state = 2},
  [715] = {.lex_state = 5, .external_lex_state = 4},
  [716] = {.lex_state = 5, .external_lex_state = 4},
  [717] = {.lex_state = 5, .external_lex_state = 4},
  [718] = {.lex_state = 5, .external_lex_state = 4},
  [719] = {.lex_state = 5, .external_lex_state = 4},
  [720] = {.lex_state = 5, .external_lex_state = 4},
  [721] = {.lex_state = 5, .external_lex_state = 4},
  [722] = {.lex_state = 5, .external_lex_state = 4},
  [723] = {.lex_state = 5, .external_lex_state = 4},
  [724] = {.lex_state = 5, .external_lex_state = 3},
  [725] = {.lex_state = 5, .external_lex_state = 3},
  [726] = {.lex_state = 5, .external_lex_state = 3},
  [727] = {.lex_state = 5, .external_lex_state = 3},
  [728] = {.lex_state = 5, .external_lex_state = 4},
  [729] = {.lex_state = 5, .external_lex_state = 3},
  [730] = {.lex_state = 5, .external_lex_state = 3},
  [731] = {.lex_state = 5, .external_lex_state = 4},
  [732] = {.lex_state = 5, .external_lex_state = 4},
  [733] = {.lex_state = 5, .external_lex_state = 4},
  [734] = {.lex_state = 5, .external_lex_state = 4},
  [735] = {.lex_state = 5, .external_lex_state = 4},
  [736] = {.lex_state = 96, .external_lex_state = 5},
  [737] = {.lex_state = 6, .external_lex_state = 3},
  [738] = {.lex_state = 5, .external_lex_state = 3},
  [739] = {.lex_state = 5, .external_lex_state = 3},
  [740] = {.lex_state = 96, .external_lex_state = 2},
  [741] = {.lex_state = 96, .external_lex_state = 5},
  [742] = {.lex_state = 6, .external_lex_state = 3},
  [743] = {.lex_state = 5, .external_lex_state = 3},
  [744] = {.lex_state = 5, .external_lex_state = 3},
  [745] = {.lex_state = 5, .external_lex_state = 3},
  [746] = {.lex_state = 96, .external_lex_state = 2},
  [747] = {.lex_state = 5, .external_lex_state = 3},
  [748] = {.lex_state = 5, .external_lex_state = 4},
  [749] = {.lex_state = 96, .external_lex_state = 5},
  [750] = {.lex_state = 96, .external_lex_state = 5},
  [751] = {.lex_state = 96, .external_lex_state = 5},
  [752] = {.lex_state = 96, .external_lex_state = 5},
  [753] = {.lex_state = 96, .external_lex_state = 5},
  [754] = {.lex_state = 96, .external_lex_state = 5},
  [755] = {.lex_state = 5, .external_lex_state = 4},
  [756] = {.lex_state = 5, .external_lex_state = 4},
  [757] = {.lex_state = 96, .external_lex_state = 2},
  [758] = {.lex_state = 5, .external_lex_state = 4},
  [759] = {.lex_state = 5, .external_lex_state = 3},
  [760] = {.lex_state = 5, .external_lex_state = 4},
  [761] = {.lex_state = 5, .external_lex_state = 3},
  [762] = {.lex_state = 5, .external_lex_state = 3},
  [763] = {.lex_state = 96, .external_lex_state = 2},
  [764] = {.lex_state = 96, .external_lex_state = 2},
  [765] = {.lex_state = 5, .external_lex_state = 3},
  [766] = {.lex_state = 5, .external_lex_state = 3},
  [767] = {.lex_state = 5, .external_lex_state = 3},
  [768] = {.lex_state = 5, .external_lex_state = 3},
  [769] = {.lex_state = 5, .external_lex_state = 3},
  [770] = {.lex_state = 5, .external_lex_state = 3},
  [771] = {.lex_state = 5, .external_lex_state = 3},
  [772] = {.lex_state = 96, .external_lex_state = 2},
  [773] = {.lex_state = 96, .external_lex_state = 5},
  [774] = {.lex_state = 96, .external_lex_state = 2},
  [775] = {.lex_state = 5, .external_lex_state = 3},
  [776] = {.lex_state = 96, .external_lex_state = 5},
  [777] = {.lex_state = 96, .external_lex_state = 5},
  [778] = {.lex_state = 96, .external_lex_state = 5},
  [779] = {.lex_state = 96, .external_lex_state = 5},
  [780] = {.lex_state = 96, .external_lex_state = 5},
  [781] = {.lex_state = 96, .external_lex_state = 5},
  [782] = {.lex_state = 5, .external_lex_state = 3},
  [783] = {.lex_state = 96, .external_lex_state = 5},
  [784] = {.lex_state = 5, .external_lex_state = 3},
  [785] = {.lex_state = 96, .external_lex_state = 2},
  [786] = {.lex_state = 96, .external_lex_state = 2},
  [787] = {.lex_state = 96, .external_lex_state = 5},
  [788] = {.lex_state = 96, .external_lex_state = 2},
  [789] = {.lex_state = 96, .external_lex_state = 2},
  [790] = {.lex_state = 96, .external_lex_state = 5},
  [791] = {.lex_state = 5, .external_lex_state = 3},
  [792] = {.lex_state = 96, .external_lex_state = 2},
  [793] = {.lex_state = 5, .external_lex_state = 3},
  [794] = {.lex_state = 96, .external_lex_state = 5},
  [795] = {.lex_state = 96, .external_lex_state = 5},
  [796] = {.lex_state = 96, .external_lex_state = 5},
  [797] = {.lex_state = 96, .external_lex_state = 5},
  [798] = {.lex_state = 5, .external_lex_state = 3},
  [799] = {.lex_state = 5, .external_lex_state = 3},
  [800] = {.lex_state = 5, .external_lex_state = 3},
  [801] = {.lex_state = 96, .external_lex_state = 2},
  [802] = {.lex_state = 96, .external_lex_state = 2},
  [803] = {.lex_state = 96, .external_lex_state = 5},
  [804] = {.lex_state = 5, .external_lex_state = 3},
  [805] = {.lex_state = 5, .external_lex_state = 3},
  [806] = {.lex_state = 5, .external_lex_state = 3},
  [807] = {.lex_state = 96, .external_lex_state = 2},
  [808] = {.lex_state = 96, .external_lex_state = 2},
  [809] = {.lex_state = 96, .external_lex_state = 2},
  [810] = {.lex_state = 96, .external_lex_state = 2},
  [811] = {.lex_state = 96, .external_lex_state = 2},
  [812] = {.lex_state = 96, .external_lex_state = 2},
  [813] = {.lex_state = 96, .external_lex_state = 2},
  [814] = {.lex_state = 12, .external_lex_state = 2},
  [815] = {.lex_state = 96, .external_lex_state = 2},
  [816] = {.lex_state = 96, .external_lex_state = 2},
  [817] = {.lex_state = 96, .external_lex_state = 2},
  [818] = {.lex_state = 96, .external_lex_state = 2},
  [819] = {.lex_state = 96, .external_lex_state = 2},
  [820] = {.lex_state = 96, .external_lex_state = 2},
  [821] = {.lex_state = 96, .external_lex_state = 2},
  [822] = {.lex_state = 96, .external_lex_state = 2},
  [823] = {.lex_state = 96, .external_lex_state = 2},
  [824] = {.lex_state = 96, .external_lex_state = 2},
  [825] = {.lex_state = 96, .external_lex_state = 2},
  [826] = {.lex_state = 96, .external_lex_state = 2},
  [827] = {.lex_state = 96, .external_lex_state = 2},
  [828] = {.lex_state = 96, .external_lex_state = 2},
  [829] = {.lex_state = 96, .external_lex_state = 2},
  [830] = {.lex_state = 96, .external_lex_state = 2},
  [831] = {.lex_state = 96, .external_lex_state = 2},
  [832] = {.lex_state = 96, .external_lex_state = 2},
  [833] = {.lex_state = 96, .external_lex_state = 2},
  [834] = {.lex_state = 96, .external_lex_state = 2},
  [835] = {.lex_state = 96, .external_lex_state = 2},
  [836] = {.lex_state = 96, .external_lex_state = 2},
  [837] = {.lex_state = 96, .external_lex_state = 2},
  [838] = {.lex_state = 96, .external_lex_state = 2},
  [839] = {.lex_state = 96, .external_lex_state = 2},
  [840] = {.lex_state = 12, .external_lex_state = 2},
  [841] = {.lex_state = 96, .external_lex_state = 2},
  [842] = {.lex_state = 96, .external_lex_state = 2},
  [843] = {.lex_state = 96, .external_lex_state = 2},
  [844] = {.lex_state = 96, .external_lex_state = 2},
  [845] = {.lex_state = 96, .external_lex_state = 2},
  [846] = {.lex_state = 96, .external_lex_state = 2},
  [847] = {.lex_state = 96, .external_lex_state = 2},
  [848] = {.lex_state = 96, .external_lex_state = 2},
  [849] = {.lex_state = 96, .external_lex_state = 2},
  [850] = {.lex_state = 96, .external_lex_state = 2},
  [851] = {.lex_state = 96, .external_lex_state = 2},
  [852] = {.lex_state = 96, .external_lex_state = 2},
  [853] = {.lex_state = 96, .external_lex_state = 2},
  [854] = {.lex_state = 96, .external_lex_state = 2},
  [855] = {.lex_state = 96, .external_lex_state = 2},
  [856] = {.lex_state = 96, .external_lex_state = 2},
  [857] = {.lex_state = 96, .external_lex_state = 2},
  [858] = {.lex_state = 96, .external_lex_state = 2},
  [859] = {.lex_state = 96, .external_lex_state = 2},
  [860] = {.lex_state = 96, .external_lex_state = 2},
  [861] = {.lex_state = 96, .external_lex_state = 2},
  [862] = {.lex_state = 96, .external_lex_state = 2},
  [863] = {.lex_state = 96, .external_lex_state = 2},
  [864] = {.lex_state = 96, .external_lex_state = 2},
  [865] = {.lex_state = 96, .external_lex_state = 2},
  [866] = {.lex_state = 96, .external_lex_state = 2},
  [867] = {.lex_state = 96, .external_lex_state = 2},
  [868] = {.lex_state = 96, .external_lex_state = 2},
  [869] = {.lex_state = 96, .external_lex_state = 2},
  [870] = {.lex_state = 96, .external_lex_state = 2},
  [871] = {.lex_state = 96, .external_lex_state = 2},
  [872] = {.lex_state = 96, .external_lex_state = 2},
  [873] = {.lex_state = 96, .external_lex_state = 2},
  [874] = {.lex_state = 96, .external_lex_state = 2},
  [875] = {.lex_state = 96, .external_lex_state = 2},
  [876] = {.lex_state = 96, .external_lex_state = 2},
  [877] = {.lex_state = 96, .external_lex_state = 2},
  [878] = {.lex_state = 96, .external_lex_state = 2},
  [879] = {.lex_state = 12, .external_lex_state = 2},
  [880] = {.lex_state = 96, .external_lex_state = 2},
  [881] = {.lex_state = 96, .external_lex_state = 2},
  [882] = {.lex_state = 96, .external_lex_state = 2},
  [883] = {.lex_state = 96, .external_lex_state = 2},
  [884] = {.lex_state = 96, .external_lex_state = 2},
  [885] = {.lex_state = 96, .external_lex_state = 2},
  [886] = {.lex_state = 96, .external_lex_state = 2},
  [887] = {.lex_state = 96, .external_lex_state = 2},
  [888] = {.lex_state = 96, .external_lex_state = 2},
  [889] = {.lex_state = 96, .external_lex_state = 2},
  [890] = {.lex_state = 96, .external_lex_state = 2},
  [891] = {.lex_state = 96, .external_lex_state = 2},
  [892] = {.lex_state = 96, .external_lex_state = 2},
  [893] = {.lex_state = 96, .external_lex_state = 2},
  [894] = {.lex_state = 96, .external_lex_state = 2},
  [895] = {.lex_state = 96, .external_lex_state = 2},
  [896] = {.lex_state = 96, .external_lex_state = 2},
  [897] = {.lex_state = 96, .external_lex_state = 2},
  [898] = {.lex_state = 96, .external_lex_state = 2},
  [899] = {.lex_state = 96, .external_lex_state = 2},
  [900] = {.lex_state = 96, .external_lex_state = 2},
  [901] = {.lex_state = 96, .external_lex_state = 2},
  [902] = {.lex_state = 96, .external_lex_state = 2},
  [903] = {.lex_state = 96, .external_lex_state = 2},
  [904] = {.lex_state = 96, .external_lex_state = 2},
  [905] = {.lex_state = 96, .external_lex_state = 2},
  [906] = {.lex_state = 96, .external_lex_state = 2},
  [907] = {.lex_state = 96, .external_lex_state = 2},
  [908] = {.lex_state = 96, .external_lex_state = 2},
  [909] = {.lex_state = 96, .external_lex_state = 2},
  [910] = {.lex_state = 96, .external_lex_state = 2},
  [911] = {.lex_state = 96, .external_lex_state = 2},
  [912] = {.lex_state = 96, .external_lex_state = 2},
  [913] = {.lex_state = 96, .external_lex_state = 2},
  [914] = {.lex_state = 96, .external_lex_state = 2},
  [915] = {.lex_state = 96, .external_lex_state = 2},
  [916] = {.lex_state = 96, .external_lex_state = 2},
  [917] = {.lex_state = 96, .external_lex_state = 2},
  [918] = {.lex_state = 96, .external_lex_state = 2},
  [919] = {.lex_state = 96, .external_lex_state = 2},
  [920] = {.lex_state = 96, .external_lex_state = 2},
  [921] = {.lex_state = 96, .external_lex_state = 2},
  [922] = {.lex_state = 12, .external_lex_state = 2},
  [923] = {.lex_state = 96, .external_lex_state = 2},
  [924] = {.lex_state = 96, .external_lex_state = 2},
  [925] = {.lex_state = 12, .external_lex_state = 2},
  [926] = {.lex_state = 96, .external_lex_state = 2},
  [927] = {.lex_state = 96, .external_lex_state = 2},
  [928] = {.lex_state = 96, .external_lex_state = 2},
  [929] = {.lex_state = 96, .external_lex_state = 2},
  [930] = {.lex_state = 96, .external_lex_state = 2},
  [931] = {.lex_state = 96, .external_lex_state = 2},
  [932] = {.lex_state = 96, .external_lex_state = 2},
  [933] = {.lex_state = 96, .external_lex_state = 2},
  [934] = {.lex_state = 96, .external_lex_state = 2},
  [935] = {.lex_state = 12, .external_lex_state = 2},
  [936] = {.lex_state = 12, .external_lex_state = 2},
  [937] = {.lex_state = 12, .external_lex_state = 2},
  [938] = {.lex_state = 12, .external_lex_state = 2},
  [939] = {.lex_state = 12, .external_lex_state = 2},
  [940] = {.lex_state = 12, .external_lex_state = 2},
  [941] = {.lex_state = 12, .external_lex_state = 2},
  [942] = {.lex_state = 12, .external_lex_state = 2},
  [943] = {.lex_state = 12, .external_lex_state = 2},
  [944] = {.lex_state = 12, .external_lex_state = 2},
  [945] = {.lex_state = 12, .external_lex_state = 2},
  [946] = {.lex_state = 96, .external_lex_state = 2},
  [947] = {.lex_state = 96, .external_lex_state = 2},
  [948] = {.lex_state = 96, .external_lex_state = 2},
  [949] = {.lex_state = 96, .external_lex_state = 2},
  [950] = {.lex_state = 96, .external_lex_state = 2},
  [951] = {.lex_state = 96, .external_lex_state = 2},
  [952] = {.lex_state = 96, .external_lex_state = 2},
  [953] = {.lex_state = 96, .external_lex_state = 2},
  [954] = {.lex_state = 96, .external_lex_state = 2},
  [955] = {.lex_state = 96, .external_lex_state = 2},
  [956] = {.lex_state = 96, .external_lex_state = 2},
  [957] = {.lex_state = 96, .external_lex_state = 2},
  [958] = {.lex_state = 96, .external_lex_state = 2},
  [959] = {.lex_state = 96, .external_lex_state = 2},
  [960] = {.lex_state = 12, .external_lex_state = 2},
  [961] = {.lex_state = 12, .external_lex_state = 2},
  [962] = {.lex_state = 12, .external_lex_state = 2},
  [963] = {.lex_state = 12, .external_lex_state = 2},
  [964] = {.lex_state = 12, .external_lex_state = 2},
  [965] = {.lex_state = 12, .external_lex_state = 2},
  [966] = {.lex_state = 12, .external_lex_state = 2},
  [967] = {.lex_state = 12, .external_lex_state = 2},
  [968] = {.lex_state = 12, .external_lex_state = 2},
  [969] = {.lex_state = 12, .external_lex_state = 2},
  [970] = {.lex_state = 12, .external_lex_state = 2},
  [971] = {.lex_state = 12, .external_lex_state = 2},
  [972] = {.lex_state = 12, .external_lex_state = 2},
  [973] = {.lex_state = 12, .external_lex_state = 2},
  [974] = {.lex_state = 12, .external_lex_state = 2},
  [975] = {.lex_state = 12, .external_lex_state = 2},
  [976] = {.lex_state = 12, .external_lex_state = 2},
  [977] = {.lex_state = 14, .external_lex_state = 2},
  [978] = {.lex_state = 14, .external_lex_state = 2},
  [979] = {.lex_state = 14, .external_lex_state = 2},
  [980] = {.lex_state = 12, .external_lex_state = 2},
  [981] = {.lex_state = 12, .external_lex_state = 2},
  [982] = {.lex_state = 12, .external_lex_state = 2},
  [983] = {.lex_state = 12, .external_lex_state = 2},
  [984] = {.lex_state = 12, .external_lex_state = 2},
  [985] = {.lex_state = 12, .external_lex_state = 2},
  [986] = {.lex_state = 12, .external_lex_state = 2},
  [987] = {.lex_state = 12, .external_lex_state = 2},
  [988] = {.lex_state = 12, .external_lex_state = 2},
  [989] = {.lex_state = 12, .external_lex_state = 2},
  [990] = {.lex_state = 12, .external_lex_state = 2},
  [991] = {.lex_state = 12, .external_lex_state = 2},
  [992] = {.lex_state = 12, .external_lex_state = 2},
  [993] = {.lex_state = 12, .external_lex_state = 2},
  [994] = {.lex_state = 12, .external_lex_state = 2},
  [995] = {.lex_state = 12, .external_lex_state = 2},
  [996] = {.lex_state = 12, .external_lex_state = 2},
  [997] = {.lex_state = 12, .external_lex_state = 2},
  [998] = {.lex_state = 12, .external_lex_state = 2},
  [999] = {.lex_state = 12, .external_lex_state = 2},
  [1000] = {.lex_state = 12, .external_lex_state = 2},
  [1001] = {.lex_state = 12, .external_lex_state = 2},
  [1002] = {.lex_state = 12, .external_lex_state = 2},
  [1003] = {.lex_state = 12, .external_lex_state = 2},
  [1004] = {.lex_state = 12, .external_lex_state = 2},
  [1005] = {.lex_state = 12, .external_lex_state = 2},
  [1006] = {.lex_state = 12, .external_lex_state = 2},
  [1007] = {.lex_state = 12, .external_lex_state = 2},
  [1008] = {.lex_state = 12, .external_lex_state = 2},
  [1009] = {.lex_state = 12, .external_lex_state = 2},
  [1010] = {.lex_state = 12, .external_lex_state = 2},
  [1011] = {.lex_state = 12, .external_lex_state = 2},
  [1012] = {.lex_state = 12, .external_lex_state = 2},
  [1013] = {.lex_state = 12, .external_lex_state = 2},
  [1014] = {.lex_state = 12, .external_lex_state = 2},
  [1015] = {.lex_state = 12, .external_lex_state = 2},
  [1016] = {.lex_state = 12, .external_lex_state = 2},
  [1017] = {.lex_state = 12, .external_lex_state = 2},
  [1018] = {.lex_state = 12, .external_lex_state = 2},
  [1019] = {.lex_state = 12, .external_lex_state = 2},
  [1020] = {.lex_state = 12, .external_lex_state = 2},
  [1021] = {.lex_state = 12, .external_lex_state = 2},
  [1022] = {.lex_state = 12, .external_lex_state = 2},
  [1023] = {.lex_state = 12, .external_lex_state = 2},
  [1024] = {.lex_state = 12, .external_lex_state = 2},
  [1025] = {.lex_state = 12, .external_lex_state = 2},
  [1026] = {.lex_state = 12, .external_lex_state = 2},
  [1027] = {.lex_state = 12, .external_lex_state = 2},
  [1028] = {.lex_state = 12, .external_lex_state = 2},
  [1029] = {.lex_state = 12, .external_lex_state = 2},
  [1030] = {.lex_state = 12, .external_lex_state = 2},
  [1031] = {.lex_state = 12, .external_lex_state = 2},
  [1032] = {.lex_state = 12, .external_lex_state = 2},
  [1033] = {.lex_state = 12, .external_lex_state = 2},
  [1034] = {.lex_state = 12, .external_lex_state = 2},
  [1035] = {.lex_state = 12, .external_lex_state = 2},
  [1036] = {.lex_state = 12, .external_lex_state = 2},
  [1037] = {.lex_state = 12, .external_lex_state = 2},
  [1038] = {.lex_state = 12, .external_lex_state = 2},
  [1039] = {.lex_state = 12, .external_lex_state = 2},
  [1040] = {.lex_state = 12, .external_lex_state = 2},
  [1041] = {.lex_state = 12, .external_lex_state = 2},
  [1042] = {.lex_state = 12, .external_lex_state = 2},
  [1043] = {.lex_state = 12, .external_lex_state = 2},
  [1044] = {.lex_state = 12, .external_lex_state = 2},
  [1045] = {.lex_state = 12, .external_lex_state = 2},
  [1046] = {.lex_state = 12, .external_lex_state = 2},
  [1047] = {.lex_state = 12, .external_lex_state = 2},
  [1048] = {.lex_state = 12, .external_lex_state = 2},
  [1049] = {.lex_state = 12, .external_lex_state = 2},
  [1050] = {.lex_state = 12, .external_lex_state = 2},
  [1051] = {.lex_state = 12, .external_lex_state = 2},
  [1052] = {.lex_state = 12, .external_lex_state = 2},
  [1053] = {.lex_state = 12, .external_lex_state = 2},
  [1054] = {.lex_state = 12, .external_lex_state = 2},
  [1055] = {.lex_state = 12, .external_lex_state = 2},
  [1056] = {.lex_state = 12, .external_lex_state = 2},
  [1057] = {.lex_state = 12, .external_lex_state = 2},
  [1058] = {.lex_state = 12, .external_lex_state = 2},
  [1059] = {.lex_state = 12, .external_lex_state = 2},
  [1060] = {.lex_state = 12, .external_lex_state = 2},
  [1061] = {.lex_state = 12, .external_lex_state = 2},
  [1062] = {.lex_state = 12, .external_lex_state = 2},
  [1063] = {.lex_state = 12, .external_lex_state = 2},
  [1064] = {.lex_state = 12, .external_lex_state = 2},
  [1065] = {.lex_state = 12, .external_lex_state = 2},
  [1066] = {.lex_state = 12, .external_lex_state = 2},
  [1067] = {.lex_state = 12, .external_lex_state = 2},
  [1068] = {.lex_state = 12, .external_lex_state = 2},
  [1069] = {.lex_state = 12, .external_lex_state = 2},
  [1070] = {.lex_state = 12, .external_lex_state = 2},
  [1071] = {.lex_state = 12, .external_lex_state = 2},
  [1072] = {.lex_state = 12, .external_lex_state = 2},
  [1073] = {.lex_state = 12, .external_lex_state = 2},
  [1074] = {.lex_state = 12, .external_lex_state = 2},
  [1075] = {.lex_state = 12, .external_lex_state = 2},
  [1076] = {.lex_state = 12, .external_lex_state = 2},
  [1077] = {.lex_state = 12, .external_lex_state = 2},
  [1078] = {.lex_state = 12, .external_lex_state = 2},
  [1079] = {.lex_state = 12, .external_lex_state = 2},
  [1080] = {.lex_state = 12, .external_lex_state = 2},
  [1081] = {.lex_state = 12, .external_lex_state = 2},
  [1082] = {.lex_state = 12, .external_lex_state = 2},
  [1083] = {.lex_state = 12, .external_lex_state = 2},
  [1084] = {.lex_state = 12, .external_lex_state = 2},
  [1085] = {.lex_state = 12, .external_lex_state = 2},
  [1086] = {.lex_state = 12, .external_lex_state = 2},
  [1087] = {.lex_state = 12, .external_lex_state = 2},
  [1088] = {.lex_state = 12, .external_lex_state = 2},
  [1089] = {.lex_state = 12, .external_lex_state = 2},
  [1090] = {.lex_state = 12, .external_lex_state = 2},
  [1091] = {.lex_state = 12, .external_lex_state = 2},
  [1092] = {.lex_state = 12, .external_lex_state = 2},
  [1093] = {.lex_state = 12, .external_lex_state = 2},
  [1094] = {.lex_state = 12, .external_lex_state = 2},
  [1095] = {.lex_state = 12, .external_lex_state = 2},
  [1096] = {.lex_state = 12, .external_lex_state = 2},
  [1097] = {.lex_state = 12, .external_lex_state = 2},
  [1098] = {.lex_state = 12, .external_lex_state = 2},
  [1099] = {.lex_state = 12, .external_lex_state = 2},
  [1100] = {.lex_state = 12, .external_lex_state = 2},
  [1101] = {.lex_state = 12, .external_lex_state = 2},
  [1102] = {.lex_state = 12, .external_lex_state = 2},
  [1103] = {.lex_state = 12, .external_lex_state = 2},
  [1104] = {.lex_state = 12, .external_lex_state = 2},
  [1105] = {.lex_state = 12, .external_lex_state = 2},
  [1106] = {.lex_state = 12, .external_lex_state = 2},
  [1107] = {.lex_state = 12, .external_lex_state = 2},
  [1108] = {.lex_state = 12, .external_lex_state = 2},
  [1109] = {.lex_state = 12, .external_lex_state = 2},
  [1110] = {.lex_state = 12, .external_lex_state = 2},
  [1111] = {.lex_state = 12, .external_lex_state = 2},
  [1112] = {.lex_state = 12, .external_lex_state = 2},
  [1113] = {.lex_state = 12, .external_lex_state = 2},
  [1114] = {.lex_state = 12, .external_lex_state = 2},
  [1115] = {.lex_state = 12, .external_lex_state = 2},
  [1116] = {.lex_state = 12, .external_lex_state = 2},
  [1117] = {.lex_state = 12, .external_lex_state = 2},
  [1118] = {.lex_state = 12, .external_lex_state = 2},
  [1119] = {.lex_state = 12, .external_lex_state = 2},
  [1120] = {.lex_state = 12, .external_lex_state = 2},
  [1121] = {.lex_state = 12, .external_lex_state = 2},
  [1122] = {.lex_state = 12, .external_lex_state = 2},
  [1123] = {.lex_state = 12, .external_lex_state = 2},
  [1124] = {.lex_state = 12, .external_lex_state = 2},
  [1125] = {.lex_state = 12, .external_lex_state = 2},
  [1126] = {.lex_state = 12, .external_lex_state = 2},
  [1127] = {.lex_state = 12, .external_lex_state = 2},
  [1128] = {.lex_state = 12, .external_lex_state = 2},
  [1129] = {.lex_state = 12, .external_lex_state = 2},
  [1130] = {.lex_state = 12, .external_lex_state = 2},
  [1131] = {.lex_state = 12, .external_lex_state = 2},
  [1132] = {.lex_state = 12, .external_lex_state = 2},
  [1133] = {.lex_state = 12, .external_lex_state = 2},
  [1134] = {.lex_state = 12, .external_lex_state = 2},
  [1135] = {.lex_state = 12, .external_lex_state = 2},
  [1136] = {.lex_state = 12, .external_lex_state = 2},
  [1137] = {.lex_state = 12, .external_lex_state = 2},
  [1138] = {.lex_state = 12, .external_lex_state = 2},
  [1139] = {.lex_state = 12, .external_lex_state = 2},
  [1140] = {.lex_state = 12, .external_lex_state = 2},
  [1141] = {.lex_state = 12, .external_lex_state = 2},
  [1142] = {.lex_state = 12, .external_lex_state = 2},
  [1143] = {.lex_state = 12, .external_lex_state = 2},
  [1144] = {.lex_state = 12, .external_lex_state = 2},
  [1145] = {.lex_state = 12, .external_lex_state = 2},
  [1146] = {.lex_state = 12, .external_lex_state = 2},
  [1147] = {.lex_state = 12, .external_lex_state = 2},
  [1148] = {.lex_state = 12, .external_lex_state = 2},
  [1149] = {.lex_state = 12, .external_lex_state = 2},
  [1150] = {.lex_state = 12, .external_lex_state = 2},
  [1151] = {.lex_state = 13, .external_lex_state = 2},
  [1152] = {.lex_state = 96, .external_lex_state = 2},
  [1153] = {.lex_state = 13, .external_lex_state = 2},
  [1154] = {.lex_state = 13, .external_lex_state = 2},
  [1155] = {.lex_state = 13, .external_lex_state = 2},
  [1156] = {.lex_state = 13, .external_lex_state = 2},
  [1157] = {.lex_state = 13, .external_lex_state = 2},
  [1158] = {.lex_state = 13, .external_lex_state = 2},
  [1159] = {.lex_state = 13, .external_lex_state = 2},
  [1160] = {.lex_state = 96, .external_lex_state = 2},
  [1161] = {.lex_state = 13, .external_lex_state = 2},
  [1162] = {.lex_state = 96, .external_lex_state = 2},
  [1163] = {.lex_state = 13, .external_lex_state = 2},
  [1164] = {.lex_state = 13, .external_lex_state = 2},
  [1165] = {.lex_state = 13, .external_lex_state = 2},
  [1166] = {.lex_state = 6, .external_lex_state = 4},
  [1167] = {.lex_state = 5, .external_lex_state = 4},
  [1168] = {.lex_state = 5, .external_lex_state = 4},
  [1169] = {.lex_state = 5, .external_lex_state = 4},
  [1170] = {.lex_state = 6, .external_lex_state = 4},
  [1171] = {.lex_state = 5, .external_lex_state = 4},
  [1172] = {.lex_state = 5, .external_lex_state = 4},
  [1173] = {.lex_state = 5, .external_lex_state = 4},
  [1174] = {.lex_state = 6, .external_lex_state = 4},
  [1175] = {.lex_state = 5, .external_lex_state = 3},
  [1176] = {.lex_state = 5, .external_lex_state = 3},
  [1177] = {.lex_state = 5, .external_lex_state = 3},
  [1178] = {.lex_state = 5, .external_lex_state = 3},
  [1179] = {.lex_state = 13, .external_lex_state = 2},
  [1180] = {.lex_state = 13, .external_lex_state = 2},
  [1181] = {.lex_state = 5, .external_lex_state = 4},
  [1182] = {.lex_state = 5, .external_lex_state = 4},
  [1183] = {.lex_state = 5, .external_lex_state = 4},
  [1184] = {.lex_state = 5, .external_lex_state = 4},
  [1185] = {.lex_state = 5, .external_lex_state = 4},
  [1186] = {.lex_state = 5, .external_lex_state = 4},
  [1187] = {.lex_state = 6, .external_lex_state = 4},
  [1188] = {.lex_state = 6, .external_lex_state = 4},
  [1189] = {.lex_state = 5, .external_lex_state = 3},
  [1190] = {.lex_state = 5, .external_lex_state = 4},
  [1191] = {.lex_state = 5, .external_lex_state = 4},
  [1192] = {.lex_state = 5, .external_lex_state = 3},
  [1193] = {.lex_state = 5, .external_lex_state = 4},
  [1194] = {.lex_state = 6, .external_lex_state = 3},
  [1195] = {.lex_state = 5, .external_lex_state = 3},
  [1196] = {.lex_state = 5, .external_lex_state = 3},
  [1197] = {.lex_state = 6, .external_lex_state = 3},
  [1198] = {.lex_state = 6, .external_lex_state = 3},
  [1199] = {.lex_state = 6, .external_lex_state = 3},
  [1200] = {.lex_state = 6, .external_lex_state = 3},
  [1201] = {.lex_state = 6, .external_lex_state = 3},
  [1202] = {.lex_state = 6, .external_lex_state = 3},
  [1203] = {.lex_state = 5, .external_lex_state = 3},
  [1204] = {.lex_state = 6, .external_lex_state = 3},
  [1205] = {.lex_state = 6, .external_lex_state = 3},
  [1206] = {.lex_state = 6, .external_lex_state = 3},
  [1207] = {.lex_state = 5, .external_lex_state = 3},
  [1208] = {.lex_state = 5, .external_lex_state = 4},
  [1209] = {.lex_state = 5, .external_lex_state = 4},
  [1210] = {.lex_state = 6, .external_lex_state = 3},
  [1211] = {.lex_state = 5, .external_lex_state = 3},
  [1212] = {.lex_state = 6, .external_lex_state = 3},
  [1213] = {.lex_state = 5, .external_lex_state = 4},
  [1214] = {.lex_state = 5, .external_lex_state = 3},
  [1215] = {.lex_state = 5, .external_lex_state = 4},
  [1216] = {.lex_state = 6, .external_lex_state = 3},
  [1217] = {.lex_state = 5, .external_lex_state = 4},
  [1218] = {.lex_state = 6, .external_lex_state = 4},
  [1219] = {.lex_state = 5, .external_lex_state = 4},
  [1220] = {.lex_state = 5, .external_lex_state = 4},
  [1221] = {.lex_state = 6, .external_lex_state = 3},
  [1222] = {.lex_state = 5, .external_lex_state = 4},
  [1223] = {.lex_state = 6, .external_lex_state = 4},
  [1224] = {.lex_state = 5, .external_lex_state = 4},
  [1225] = {.lex_state = 5, .external_lex_state = 4},
  [1226] = {.lex_state = 5, .external_lex_state = 4},
  [1227] = {.lex_state = 5, .external_lex_state = 4},
  [1228] = {.lex_state = 6, .external_lex_state = 3},
  [1229] = {.lex_state = 5, .external_lex_state = 4},
  [1230] = {.lex_state = 5, .external_lex_state = 3},
  [1231] = {.lex_state = 5, .external_lex_state = 3},
  [1232] = {.lex_state = 5, .external_lex_state = 3},
  [1233] = {.lex_state = 5, .external_lex_state = 4},
  [1234] = {.lex_state = 5, .external_lex_state = 3},
  [1235] = {.lex_state = 5, .external_lex_state = 3},
  [1236] = {.lex_state = 5, .external_lex_state = 3},
  [1237] = {.lex_state = 5, .external_lex_state = 4},
  [1238] = {.lex_state = 5, .external_lex_state = 3},
  [1239] = {.lex_state = 5, .external_lex_state = 3},
  [1240] = {.lex_state = 5, .external_lex_state = 3},
  [1241] = {.lex_state = 5, .external_lex_state = 3},
  [1242] = {.lex_state = 5, .external_lex_state = 4},
  [1243] = {.lex_state = 5, .external_lex_state = 3},
  [1244] = {.lex_state = 5, .external_lex_state = 4},
  [1245] = {.lex_state = 5, .external_lex_state = 3},
  [1246] = {.lex_state = 5, .external_lex_state = 3},
  [1247] = {.lex_state = 96, .external_lex_state = 2},
  [1248] = {.lex_state = 5, .external_lex_state = 3},
  [1249] = {.lex_state = 6, .external_lex_state = 3},
  [1250] = {.lex_state = 5, .external_lex_state = 3},
  [1251] = {.lex_state = 5, .external_lex_state = 3},
  [1252] = {.lex_state = 5, .external_lex_state = 3},
  [1253] = {.lex_state = 96, .external_lex_state = 2},
  [1254] = {.lex_state = 6, .external_lex_state = 3},
  [1255] = {.lex_state = 5, .external_lex_state = 3},
  [1256] = {.lex_state = 5, .external_lex_state = 3},
  [1257] = {.lex_state = 96, .external_lex_state = 2},
  [1258] = {.lex_state = 5, .external_lex_state = 4},
  [1259] = {.lex_state = 5, .external_lex_state = 3},
  [1260] = {.lex_state = 5, .external_lex_state = 3},
  [1261] = {.lex_state = 5, .external_lex_state = 3},
  [1262] = {.lex_state = 96, .external_lex_state = 2},
  [1263] = {.lex_state = 5, .external_lex_state = 3},
  [1264] = {.lex_state = 5, .external_lex_state = 3},
  [1265] = {.lex_state = 5, .external_lex_state = 4},
  [1266] = {.lex_state = 96, .external_lex_state = 2},
  [1267] = {.lex_state = 5, .external_lex_state = 3},
  [1268] = {.lex_state = 5, .external_lex_state = 3},
  [1269] = {.lex_state = 5, .external_lex_state = 3},
  [1270] = {.lex_state = 5, .external_lex_state = 3},
  [1271] = {.lex_state = 5, .external_lex_state = 3},
  [1272] = {.lex_state = 5, .external_lex_state = 3},
  [1273] = {.lex_state = 5, .external_lex_state = 3},
  [1274] = {.lex_state = 5, .external_lex_state = 4},
  [1275] = {.lex_state = 5, .external_lex_state = 3},
  [1276] = {.lex_state = 5, .external_lex_state = 3},
  [1277] = {.lex_state = 5, .external_lex_state = 3},
  [1278] = {.lex_state = 5, .external_lex_state = 4},
  [1279] = {.lex_state = 5, .external_lex_state = 3},
  [1280] = {.lex_state = 5, .external_lex_state = 3},
  [1281] = {.lex_state = 5, .external_lex_state = 3},
  [1282] = {.lex_state = 5, .external_lex_state = 4},
  [1283] = {.lex_state = 5, .external_lex_state = 4},
  [1284] = {.lex_state = 96, .external_lex_state = 2},
  [1285] = {.lex_state = 5, .external_lex_state = 4},
  [1286] = {.lex_state = 96, .external_lex_state = 2},
  [1287] = {.lex_state = 5, .external_lex_state = 4},
  [1288] = {.lex_state = 5, .external_lex_state = 3},
  [1289] = {.lex_state = 5, .external_lex_state = 3},
  [1290] = {.lex_state = 5, .external_lex_state = 4},
  [1291] = {.lex_state = 5, .external_lex_state = 3},
  [1292] = {.lex_state = 6, .external_lex_state = 3},
  [1293] = {.lex_state = 5, .external_lex_state = 3},
  [1294] = {.lex_state = 5, .external_lex_state = 4},
  [1295] = {.lex_state = 5, .external_lex_state = 3},
  [1296] = {.lex_state = 5, .external_lex_state = 4},
  [1297] = {.lex_state = 96, .external_lex_state = 2},
  [1298] = {.lex_state = 5, .external_lex_state = 3},
  [1299] = {.lex_state = 96, .external_lex_state = 2},
  [1300] = {.lex_state = 5, .external_lex_state = 3},
  [1301] = {.lex_state = 5, .external_lex_state = 3},
  [1302] = {.lex_state = 5, .external_lex_state = 3},
  [1303] = {.lex_state = 5, .external_lex_state = 4},
  [1304] = {.lex_state = 5, .external_lex_state = 3},
  [1305] = {.lex_state = 5, .external_lex_state = 3},
  [1306] = {.lex_state = 5, .external_lex_state = 3},
  [1307] = {.lex_state = 5, .external_lex_state = 3},
  [1308] = {.lex_state = 5, .external_lex_state = 4},
  [1309] = {.lex_state = 5, .external_lex_state = 3},
  [1310] = {.lex_state = 5, .external_lex_state = 3},
  [1311] = {.lex_state = 5, .external_lex_state = 4},
  [1312] = {.lex_state = 6, .external_lex_state = 3},
  [1313] = {.lex_state = 5, .external_lex_state = 3},
  [1314] = {.lex_state = 5, .external_lex_state = 3},
  [1315] = {.lex_state = 5, .external_lex_state = 3},
  [1316] = {.lex_state = 5, .external_lex_state = 4},
  [1317] = {.lex_state = 5, .external_lex_state = 4},
  [1318] = {.lex_state = 5, .external_lex_state = 4},
  [1319] = {.lex_state = 5, .external_lex_state = 4},
  [1320] = {.lex_state = 5, .external_lex_state = 3},
  [1321] = {.lex_state = 5, .external_lex_state = 4},
  [1322] = {.lex_state = 5, .external_lex_state = 4},
  [1323] = {.lex_state = 5, .external_lex_state = 4},
  [1324] = {.lex_state = 5, .external_lex_state = 3},
  [1325] = {.lex_state = 5, .external_lex_state = 4},
  [1326] = {.lex_state = 5, .external_lex_state = 3},
  [1327] = {.lex_state = 5, .external_lex_state = 4},
  [1328] = {.lex_state = 5, .external_lex_state = 3},
  [1329] = {.lex_state = 5, .external_lex_state = 4},
  [1330] = {.lex_state = 5, .external_lex_state = 4},
  [1331] = {.lex_state = 5, .external_lex_state = 4},
  [1332] = {.lex_state = 5, .external_lex_state = 4},
  [1333] = {.lex_state = 5, .external_lex_state = 4},
  [1334] = {.lex_state = 5, .external_lex_state = 4},
  [1335] = {.lex_state = 5, .external_lex_state = 4},
  [1336] = {.lex_state = 5, .external_lex_state = 3},
  [1337] = {.lex_state = 5, .external_lex_state = 3},
  [1338] = {.lex_state = 5, .external_lex_state = 3},
  [1339] = {.lex_state = 5, .external_lex_state = 4},
  [1340] = {.lex_state = 5, .external_lex_state = 3},
  [1341] = {.lex_state = 5, .external_lex_state = 4},
  [1342] = {.lex_state = 5, .external_lex_state = 4},
  [1343] = {.lex_state = 5, .external_lex_state = 4},
  [1344] = {.lex_state = 5, .external_lex_state = 3},
  [1345] = {.lex_state = 5, .external_lex_state = 4},
  [1346] = {.lex_state = 5, .external_lex_state = 3},
  [1347] = {.lex_state = 5, .external_lex_state = 4},
  [1348] = {.lex_state = 5, .external_lex_state = 3},
  [1349] = {.lex_state = 5, .external_lex_state = 4},
  [1350] = {.lex_state = 5, .external_lex_state = 4},
  [1351] = {.lex_state = 5, .external_lex_state = 3},
  [1352] = {.lex_state = 6, .external_lex_state = 3},
  [1353] = {.lex_state = 5, .external_lex_state = 4},
  [1354] = {.lex_state = 5, .external_lex_state = 3},
  [1355] = {.lex_state = 5, .external_lex_state = 3},
  [1356] = {.lex_state = 5, .external_lex_state = 4},
  [1357] = {.lex_state = 5, .external_lex_state = 3},
  [1358] = {.lex_state = 5, .external_lex_state = 3},
  [1359] = {.lex_state = 5, .external_lex_state = 3},
  [1360] = {.lex_state = 5, .external_lex_state = 3},
  [1361] = {.lex_state = 5, .external_lex_state = 3},
  [1362] = {.lex_state = 5, .external_lex_state = 3},
  [1363] = {.lex_state = 5, .external_lex_state = 3},
  [1364] = {.lex_state = 5, .external_lex_state = 4},
  [1365] = {.lex_state = 5, .external_lex_state = 4},
  [1366] = {.lex_state = 5, .external_lex_state = 3},
  [1367] = {.lex_state = 6, .external_lex_state = 3},
  [1368] = {.lex_state = 5, .external_lex_state = 3},
  [1369] = {.lex_state = 5, .external_lex_state = 3},
  [1370] = {.lex_state = 5, .external_lex_state = 3},
  [1371] = {.lex_state = 5, .external_lex_state = 3},
  [1372] = {.lex_state = 5, .external_lex_state = 3},
  [1373] = {.lex_state = 6, .external_lex_state = 3},
  [1374] = {.lex_state = 6, .external_lex_state = 3},
  [1375] = {.lex_state = 5, .external_lex_state = 3},
  [1376] = {.lex_state = 5, .external_lex_state = 3},
  [1377] = {.lex_state = 5, .external_lex_state = 3},
  [1378] = {.lex_state = 5, .external_lex_state = 3},
  [1379] = {.lex_state = 12, .external_lex_state = 2},
  [1380] = {.lex_state = 5, .external_lex_state = 4},
  [1381] = {.lex_state = 5, .external_lex_state = 3},
  [1382] = {.lex_state = 5, .external_lex_state = 3},
  [1383] = {.lex_state = 5, .external_lex_state = 3},
  [1384] = {.lex_state = 5, .external_lex_state = 3},
  [1385] = {.lex_state = 5, .external_lex_state = 3},
  [1386] = {.lex_state = 5, .external_lex_state = 3},
  [1387] = {.lex_state = 12, .external_lex_state = 2},
  [1388] = {.lex_state = 12, .external_lex_state = 2},
  [1389] = {.lex_state = 12, .external_lex_state = 2},
  [1390] = {.lex_state = 5, .external_lex_state = 3},
  [1391] = {.lex_state = 6, .external_lex_state = 3},
  [1392] = {.lex_state = 5, .external_lex_state = 4},
  [1393] = {.lex_state = 5, .external_lex_state = 3},
  [1394] = {.lex_state = 5, .external_lex_state = 3},
  [1395] = {.lex_state = 5, .external_lex_state = 3},
  [1396] = {.lex_state = 12, .external_lex_state = 2},
  [1397] = {.lex_state = 5, .external_lex_state = 3},
  [1398] = {.lex_state = 5, .external_lex_state = 4},
  [1399] = {.lex_state = 5, .external_lex_state = 3},
  [1400] = {.lex_state = 5, .external_lex_state = 4},
  [1401] = {.lex_state = 12, .external_lex_state = 2},
  [1402] = {.lex_state = 5, .external_lex_state = 3},
  [1403] = {.lex_state = 5, .external_lex_state = 3},
  [1404] = {.lex_state = 5, .external_lex_state = 3},
  [1405] = {.lex_state = 5, .external_lex_state = 3},
  [1406] = {.lex_state = 5, .external_lex_state = 3},
  [1407] = {.lex_state = 5, .external_lex_state = 3},
  [1408] = {.lex_state = 5, .external_lex_state = 3},
  [1409] = {.lex_state = 5, .external_lex_state = 3},
  [1410] = {.lex_state = 5, .external_lex_state = 3},
  [1411] = {.lex_state = 5, .external_lex_state = 3},
  [1412] = {.lex_state = 5, .external_lex_state = 3},
  [1413] = {.lex_state = 5, .external_lex_state = 3},
  [1414] = {.lex_state = 5, .external_lex_state = 3},
  [1415] = {.lex_state = 5, .external_lex_state = 3},
  [1416] = {.lex_state = 5, .external_lex_state = 3},
  [1417] = {.lex_state = 5, .external_lex_state = 4},
  [1418] = {.lex_state = 5, .external_lex_state = 3},
  [1419] = {.lex_state = 12, .external_lex_state = 2},
  [1420] = {.lex_state = 5, .external_lex_state = 3},
  [1421] = {.lex_state = 5, .external_lex_state = 3},
  [1422] = {.lex_state = 12, .external_lex_state = 2},
  [1423] = {.lex_state = 5, .external_lex_state = 3},
  [1424] = {.lex_state = 12, .external_lex_state = 2},
  [1425] = {.lex_state = 12, .external_lex_state = 2},
  [1426] = {.lex_state = 5, .external_lex_state = 3},
  [1427] = {.lex_state = 5, .external_lex_state = 3},
  [1428] = {.lex_state = 12, .external_lex_state = 2},
  [1429] = {.lex_state = 12, .external_lex_state = 2},
  [1430] = {.lex_state = 5, .external_lex_state = 3},
  [1431] = {.lex_state = 5, .external_lex_state = 3},
  [1432] = {.lex_state = 5, .external_lex_state = 3},
  [1433] = {.lex_state = 12, .external_lex_state = 2},
  [1434] = {.lex_state = 5, .external_lex_state = 3},
  [1435] = {.lex_state = 12, .external_lex_state = 2},
  [1436] = {.lex_state = 12, .external_lex_state = 2},
  [1437] = {.lex_state = 5, .external_lex_state = 3},
  [1438] = {.lex_state = 5, .external_lex_state = 3},
  [1439] = {.lex_state = 5, .external_lex_state = 3},
  [1440] = {.lex_state = 12, .external_lex_state = 2},
  [1441] = {.lex_state = 12, .external_lex_state = 2},
  [1442] = {.lex_state = 5, .external_lex_state = 3},
  [1443] = {.lex_state = 5, .external_lex_state = 3},
  [1444] = {.lex_state = 12, .external_lex_state = 2},
  [1445] = {.lex_state = 12, .external_lex_state = 2},
  [1446] = {.lex_state = 5, .external_lex_state = 3},
  [1447] = {.lex_state = 5, .external_lex_state = 3},
  [1448] = {.lex_state = 5, .external_lex_state = 3},
  [1449] = {.lex_state = 5, .external_lex_state = 3},
  [1450] = {.lex_state = 5, .external_lex_state = 3},
  [1451] = {.lex_state = 5, .external_lex_state = 3},
  [1452] = {.lex_state = 5, .external_lex_state = 3},
  [1453] = {.lex_state = 5, .external_lex_state = 3},
  [1454] = {.lex_state = 5, .external_lex_state = 3},
  [1455] = {.lex_state = 12, .external_lex_state = 2},
  [1456] = {.lex_state = 12, .external_lex_state = 2},
  [1457] = {.lex_state = 5, .external_lex_state = 3},
  [1458] = {.lex_state = 12, .external_lex_state = 2},
  [1459] = {.lex_state = 5, .external_lex_state = 3},
  [1460] = {.lex_state = 5, .external_lex_state = 3},
  [1461] = {.lex_state = 5, .external_lex_state = 3},
  [1462] = {.lex_state = 12, .external_lex_state = 2},
  [1463] = {.lex_state = 12, .external_lex_state = 2},
  [1464] = {.lex_state = 5, .external_lex_state = 3},
  [1465] = {.lex_state = 5, .external_lex_state = 3},
  [1466] = {.lex_state = 5, .external_lex_state = 3},
  [1467] = {.lex_state = 5, .external_lex_state = 3},
  [1468] = {.lex_state = 5, .external_lex_state = 3},
  [1469] = {.lex_state = 5, .external_lex_state = 3},
  [1470] = {.lex_state = 5, .external_lex_state = 3},
  [1471] = {.lex_state = 5, .external_lex_state = 3},
  [1472] = {.lex_state = 5, .external_lex_state = 3},
  [1473] = {.lex_state = 5, .external_lex_state = 3},
  [1474] = {.lex_state = 12, .external_lex_state = 2},
  [1475] = {.lex_state = 12, .external_lex_state = 2},
  [1476] = {.lex_state = 12, .external_lex_state = 2},
  [1477] = {.lex_state = 12, .external_lex_state = 2},
  [1478] = {.lex_state = 12, .external_lex_state = 2},
  [1479] = {.lex_state = 12, .external_lex_state = 2},
  [1480] = {.lex_state = 12, .external_lex_state = 2},
  [1481] = {.lex_state = 12, .external_lex_state = 2},
  [1482] = {.lex_state = 13, .external_lex_state = 5},
  [1483] = {.lex_state = 13, .external_lex_state = 5},
  [1484] = {.lex_state = 13, .external_lex_state = 5},
  [1485] = {.lex_state = 12, .external_lex_state = 2},
  [1486] = {.lex_state = 13, .external_lex_state = 5},
  [1487] = {.lex_state = 12, .external_lex_state = 2},
  [1488] = {.lex_state = 12, .external_lex_state = 2},
  [1489] = {.lex_state = 12, .external_lex_state = 2},
  [1490] = {.lex_state = 12, .external_lex_state = 2},
  [1491] = {.lex_state = 12, .external_lex_state = 2},
  [1492] = {.lex_state = 12, .external_lex_state = 2},
  [1493] = {.lex_state = 13, .external_lex_state = 5},
  [1494] = {.lex_state = 12, .external_lex_state = 2},
  [1495] = {.lex_state = 12, .external_lex_state = 2},
  [1496] = {.lex_state = 12, .external_lex_state = 2},
  [1497] = {.lex_state = 96, .external_lex_state = 2},
  [1498] = {.lex_state = 96, .external_lex_state = 2},
  [1499] = {.lex_state = 96, .external_lex_state = 2},
  [1500] = {.lex_state = 96, .external_lex_state = 2},
  [1501] = {.lex_state = 96, .external_lex_state = 2},
  [1502] = {.lex_state = 7, .external_lex_state = 3},
  [1503] = {.lex_state = 96, .external_lex_state = 2},
  [1504] = {.lex_state = 7, .external_lex_state = 4},
  [1505] = {.lex_state = 7, .external_lex_state = 3},
  [1506] = {.lex_state = 7, .external_lex_state = 3},
  [1507] = {.lex_state = 13, .external_lex_state = 5},
  [1508] = {.lex_state = 13, .external_lex_state = 5},
  [1509] = {.lex_state = 7, .external_lex_state = 3},
  [1510] = {.lex_state = 7, .external_lex_state = 3},
  [1511] = {.lex_state = 7, .external_lex_state = 4},
  [1512] = {.lex_state = 7, .external_lex_state = 3},
  [1513] = {.lex_state = 7, .external_lex_state = 3},
  [1514] = {.lex_state = 7, .external_lex_state = 3},
  [1515] = {.lex_state = 7, .external_lex_state = 4},
  [1516] = {.lex_state = 7, .external_lex_state = 3},
  [1517] = {.lex_state = 7, .external_lex_state = 3},
  [1518] = {.lex_state = 7, .external_lex_state = 3},
  [1519] = {.lex_state = 7, .external_lex_state = 3},
  [1520] = {.lex_state = 7, .external_lex_state = 3},
  [1521] = {.lex_state = 7, .external_lex_state = 3},
  [1522] = {.lex_state = 7, .external_lex_state = 3},
  [1523] = {.lex_state = 96, .external_lex_state = 2},
  [1524] = {.lex_state = 7, .external_lex_state = 3},
  [1525] = {.lex_state = 7, .external_lex_state = 3},
  [1526] = {.lex_state = 7, .external_lex_state = 3},
  [1527] = {.lex_state = 7, .external_lex_state = 3},
  [1528] = {.lex_state = 7, .external_lex_state = 3},
  [1529] = {.lex_state = 7, .external_lex_state = 3},
  [1530] = {.lex_state = 7, .external_lex_state = 3},
  [1531] = {.lex_state = 7, .external_lex_state = 3},
  [1532] = {.lex_state = 7, .external_lex_state = 3},
  [1533] = {.lex_state = 7, .external_lex_state = 3},
  [1534] = {.lex_state = 7, .external_lex_state = 3},
  [1535] = {.lex_state = 7, .external_lex_state = 3},
  [1536] = {.lex_state = 7, .external_lex_state = 3},
  [1537] = {.lex_state = 7, .external_lex_state = 3},
  [1538] = {.lex_state = 7, .external_lex_state = 3},
  [1539] = {.lex_state = 7, .external_lex_state = 3},
  [1540] = {.lex_state = 7, .external_lex_state = 3},
  [1541] = {.lex_state = 7, .external_lex_state = 3},
  [1542] = {.lex_state = 7, .external_lex_state = 3},
  [1543] = {.lex_state = 7, .external_lex_state = 3},
  [1544] = {.lex_state = 7, .external_lex_state = 3},
  [1545] = {.lex_state = 7, .external_lex_state = 3},
  [1546] = {.lex_state = 7, .external_lex_state = 3},
  [1547] = {.lex_state = 7, .external_lex_state = 3},
  [1548] = {.lex_state = 7, .external_lex_state = 3},
  [1549] = {.lex_state = 7, .external_lex_state = 3},
  [1550] = {.lex_state = 7, .external_lex_state = 3},
  [1551] = {.lex_state = 7, .external_lex_state = 3},
  [1552] = {.lex_state = 7, .external_lex_state = 3},
  [1553] = {.lex_state = 7, .external_lex_state = 3},
  [1554] = {.lex_state = 7, .external_lex_state = 3},
  [1555] = {.lex_state = 7, .external_lex_state = 3},
  [1556] = {.lex_state = 7, .external_lex_state = 3},
  [1557] = {.lex_state = 7, .external_lex_state = 3},
  [1558] = {.lex_state = 7, .external_lex_state = 3},
  [1559] = {.lex_state = 7, .external_lex_state = 3},
  [1560] = {.lex_state = 7, .external_lex_state = 3},
  [1561] = {.lex_state = 7, .external_lex_state = 3},
  [1562] = {.lex_state = 7, .external_lex_state = 3},
  [1563] = {.lex_state = 7, .external_lex_state = 3},
  [1564] = {.lex_state = 7, .external_lex_state = 3},
  [1565] = {.lex_state = 7, .external_lex_state = 3},
  [1566] = {.lex_state = 7, .external_lex_state = 3},
  [1567] = {.lex_state = 7, .external_lex_state = 3},
  [1568] = {.lex_state = 7, .external_lex_state = 3},
  [1569] = {.lex_state = 7, .external_lex_state = 3},
  [1570] = {.lex_state = 7, .external_lex_state = 3},
  [1571] = {.lex_state = 7, .external_lex_state = 3},
  [1572] = {.lex_state = 7, .external_lex_state = 3},
  [1573] = {.lex_state = 7, .external_lex_state = 3},
  [1574] = {.lex_state = 7, .external_lex_state = 3},
  [1575] = {.lex_state = 7, .external_lex_state = 3},
  [1576] = {.lex_state = 7, .external_lex_state = 3},
  [1577] = {.lex_state = 7, .external_lex_state = 3},
  [1578] = {.lex_state = 7, .external_lex_state = 3},
  [1579] = {.lex_state = 7, .external_lex_state = 4},
  [1580] = {.lex_state = 7, .external_lex_state = 3},
  [1581] = {.lex_state = 7, .external_lex_state = 3},
  [1582] = {.lex_state = 7, .external_lex_state = 3},
  [1583] = {.lex_state = 7, .external_lex_state = 3},
  [1584] = {.lex_state = 7, .external_lex_state = 3},
  [1585] = {.lex_state = 7, .external_lex_state = 3},
  [1586] = {.lex_state = 7, .external_lex_state = 3},
  [1587] = {.lex_state = 7, .external_lex_state = 3},
  [1588] = {.lex_state = 7, .external_lex_state = 3},
  [1589] = {.lex_state = 7, .external_lex_state = 3},
  [1590] = {.lex_state = 7, .external_lex_state = 3},
  [1591] = {.lex_state = 7, .external_lex_state = 3},
  [1592] = {.lex_state = 7, .external_lex_state = 3},
  [1593] = {.lex_state = 7, .external_lex_state = 3},
  [1594] = {.lex_state = 7, .external_lex_state = 3},
  [1595] = {.lex_state = 7, .external_lex_state = 3},
  [1596] = {.lex_state = 7, .external_lex_state = 3},
  [1597] = {.lex_state = 7, .external_lex_state = 3},
  [1598] = {.lex_state = 7, .external_lex_state = 3},
  [1599] = {.lex_state = 7, .external_lex_state = 3},
  [1600] = {.lex_state = 7, .external_lex_state = 3},
  [1601] = {.lex_state = 7, .external_lex_state = 3},
  [1602] = {.lex_state = 7, .external_lex_state = 3},
  [1603] = {.lex_state = 7, .external_lex_state = 3},
  [1604] = {.lex_state = 7, .external_lex_state = 4},
  [1605] = {.lex_state = 7, .external_lex_state = 3},
  [1606] = {.lex_state = 7, .external_lex_state = 3},
  [1607] = {.lex_state = 7, .external_lex_state = 3},
  [1608] = {.lex_state = 7, .external_lex_state = 3},
  [1609] = {.lex_state = 7, .external_lex_state = 4},
  [1610] = {.lex_state = 7, .external_lex_state = 3},
  [1611] = {.lex_state = 7, .external_lex_state = 3},
  [1612] = {.lex_state = 7, .external_lex_state = 3},
  [1613] = {.lex_state = 7, .external_lex_state = 3},
  [1614] = {.lex_state = 7, .external_lex_state = 3},
  [1615] = {.lex_state = 7, .external_lex_state = 3},
  [1616] = {.lex_state = 7, .external_lex_state = 3},
  [1617] = {.lex_state = 7, .external_lex_state = 3},
  [1618] = {.lex_state = 7, .external_lex_state = 3},
  [1619] = {.lex_state = 7, .external_lex_state = 3},
  [1620] = {.lex_state = 7, .external_lex_state = 3},
  [1621] = {.lex_state = 7, .external_lex_state = 3},
  [1622] = {.lex_state = 7, .external_lex_state = 3},
  [1623] = {.lex_state = 7, .external_lex_state = 3},
  [1624] = {.lex_state = 7, .external_lex_state = 4},
  [1625] = {.lex_state = 7, .external_lex_state = 3},
  [1626] = {.lex_state = 7, .external_lex_state = 4},
  [1627] = {.lex_state = 7, .external_lex_state = 3},
  [1628] = {.lex_state = 7, .external_lex_state = 3},
  [1629] = {.lex_state = 7, .external_lex_state = 3},
  [1630] = {.lex_state = 7, .external_lex_state = 3},
  [1631] = {.lex_state = 7, .external_lex_state = 3},
  [1632] = {.lex_state = 7, .external_lex_state = 3},
  [1633] = {.lex_state = 7, .external_lex_state = 3},
  [1634] = {.lex_state = 7, .external_lex_state = 3},
  [1635] = {.lex_state = 7, .external_lex_state = 3},
  [1636] = {.lex_state = 7, .external_lex_state = 3},
  [1637] = {.lex_state = 7, .external_lex_state = 3},
  [1638] = {.lex_state = 7, .external_lex_state = 3},
  [1639] = {.lex_state = 7, .external_lex_state = 3},
  [1640] = {.lex_state = 7, .external_lex_state = 3},
  [1641] = {.lex_state = 7, .external_lex_state = 3},
  [1642] = {.lex_state = 7, .external_lex_state = 3},
  [1643] = {.lex_state = 7, .external_lex_state = 3},
  [1644] = {.lex_state = 7, .external_lex_state = 3},
  [1645] = {.lex_state = 7, .external_lex_state = 3},
  [1646] = {.lex_state = 7, .external_lex_state = 3},
  [1647] = {.lex_state = 7, .external_lex_state = 3},
  [1648] = {.lex_state = 7, .external_lex_state = 3},
  [1649] = {.lex_state = 7, .external_lex_state = 3},
  [1650] = {.lex_state = 7, .external_lex_state = 3},
  [1651] = {.lex_state = 7, .external_lex_state = 3},
  [1652] = {.lex_state = 7, .external_lex_state = 3},
  [1653] = {.lex_state = 7, .external_lex_state = 3},
  [1654] = {.lex_state = 7, .external_lex_state = 3},
  [1655] = {.lex_state = 7, .external_lex_state = 3},
  [1656] = {.lex_state = 7, .external_lex_state = 3},
  [1657] = {.lex_state = 7, .external_lex_state = 3},
  [1658] = {.lex_state = 7, .external_lex_state = 3},
  [1659] = {.lex_state = 7, .external_lex_state = 3},
  [1660] = {.lex_state = 7, .external_lex_state = 3},
  [1661] = {.lex_state = 7, .external_lex_state = 3},
  [1662] = {.lex_state = 7, .external_lex_state = 3},
  [1663] = {.lex_state = 7, .external_lex_state = 3},
  [1664] = {.lex_state = 7, .external_lex_state = 3},
  [1665] = {.lex_state = 7, .external_lex_state = 3},
  [1666] = {.lex_state = 7, .external_lex_state = 3},
  [1667] = {.lex_state = 7, .external_lex_state = 3},
  [1668] = {.lex_state = 7, .external_lex_state = 3},
  [1669] = {.lex_state = 7, .external_lex_state = 3},
  [1670] = {.lex_state = 7, .external_lex_state = 3},
  [1671] = {.lex_state = 7, .external_lex_state = 3},
  [1672] = {.lex_state = 7, .external_lex_state = 3},
  [1673] = {.lex_state = 7, .external_lex_state = 3},
  [1674] = {.lex_state = 7, .external_lex_state = 3},
  [1675] = {.lex_state = 7, .external_lex_state = 3},
  [1676] = {.lex_state = 7, .external_lex_state = 3},
  [1677] = {.lex_state = 7, .external_lex_state = 3},
  [1678] = {.lex_state = 7, .external_lex_state = 3},
  [1679] = {.lex_state = 7, .external_lex_state = 3},
  [1680] = {.lex_state = 7, .external_lex_state = 3},
  [1681] = {.lex_state = 7, .external_lex_state = 3},
  [1682] = {.lex_state = 7, .external_lex_state = 3},
  [1683] = {.lex_state = 7, .external_lex_state = 3},
  [1684] = {.lex_state = 7, .external_lex_state = 3},
  [1685] = {.lex_state = 7, .external_lex_state = 3},
  [1686] = {.lex_state = 7, .external_lex_state = 3},
  [1687] = {.lex_state = 7, .external_lex_state = 3},
  [1688] = {.lex_state = 7, .external_lex_state = 3},
  [1689] = {.lex_state = 12, .external_lex_state = 5},
  [1690] = {.lex_state = 7, .external_lex_state = 3},
  [1691] = {.lex_state = 7, .external_lex_state = 3},
  [1692] = {.lex_state = 7, .external_lex_state = 3},
  [1693] = {.lex_state = 7, .external_lex_state = 3},
  [1694] = {.lex_state = 7, .external_lex_state = 3},
  [1695] = {.lex_state = 7, .external_lex_state = 3},
  [1696] = {.lex_state = 7, .external_lex_state = 3},
  [1697] = {.lex_state = 7, .external_lex_state = 3},
  [1698] = {.lex_state = 7, .external_lex_state = 3},
  [1699] = {.lex_state = 7, .external_lex_state = 3},
  [1700] = {.lex_state = 7, .external_lex_state = 3},
  [1701] = {.lex_state = 7, .external_lex_state = 3},
  [1702] = {.lex_state = 7, .external_lex_state = 3},
  [1703] = {.lex_state = 7, .external_lex_state = 3},
  [1704] = {.lex_state = 7, .external_lex_state = 3},
  [1705] = {.lex_state = 7, .external_lex_state = 3},
  [1706] = {.lex_state = 7, .external_lex_state = 3},
  [1707] = {.lex_state = 7, .external_lex_state = 3},
  [1708] = {.lex_state = 7, .external_lex_state = 3},
  [1709] = {.lex_state = 7, .external_lex_state = 3},
  [1710] = {.lex_state = 7, .external_lex_state = 4},
  [1711] = {.lex_state = 7, .external_lex_state = 4},
  [1712] = {.lex_state = 7, .external_lex_state = 4},
  [1713] = {.lex_state = 7, .external_lex_state = 3},
  [1714] = {.lex_state = 7, .external_lex_state = 3},
  [1715] = {.lex_state = 7, .external_lex_state = 3},
  [1716] = {.lex_state = 7, .external_lex_state = 3},
  [1717] = {.lex_state = 7, .external_lex_state = 3},
  [1718] = {.lex_state = 7, .external_lex_state = 3},
  [1719] = {.lex_state = 12, .external_lex_state = 5},
  [1720] = {.lex_state = 12, .external_lex_state = 5},
  [1721] = {.lex_state = 12, .external_lex_state = 5},
  [1722] = {.lex_state = 12, .external_lex_state = 5},
  [1723] = {.lex_state = 7, .external_lex_state = 3},
  [1724] = {.lex_state = 12, .external_lex_state = 5},
  [1725] = {.lex_state = 13, .external_lex_state = 5},
  [1726] = {.lex_state = 7, .external_lex_state = 4},
  [1727] = {.lex_state = 7, .external_lex_state = 3},
  [1728] = {.lex_state = 7, .external_lex_state = 4},
  [1729] = {.lex_state = 7, .external_lex_state = 3},
  [1730] = {.lex_state = 7, .external_lex_state = 4},
  [1731] = {.lex_state = 7, .external_lex_state = 3},
  [1732] = {.lex_state = 7, .external_lex_state = 4},
  [1733] = {.lex_state = 12, .external_lex_state = 5},
  [1734] = {.lex_state = 7, .external_lex_state = 4},
  [1735] = {.lex_state = 7, .external_lex_state = 4},
  [1736] = {.lex_state = 12, .external_lex_state = 5},
  [1737] = {.lex_state = 7, .external_lex_state = 4},
  [1738] = {.lex_state = 12, .external_lex_state = 5},
  [1739] = {.lex_state = 7, .external_lex_state = 4},
  [1740] = {.lex_state = 12, .external_lex_state = 5},
  [1741] = {.lex_state = 7, .external_lex_state = 3},
  [1742] = {.lex_state = 7, .external_lex_state = 3},
  [1743] = {.lex_state = 7, .external_lex_state = 3},
  [1744] = {.lex_state = 7, .external_lex_state = 3},
  [1745] = {.lex_state = 7, .external_lex_state = 3},
  [1746] = {.lex_state = 7, .external_lex_state = 3},
  [1747] = {.lex_state = 7, .external_lex_state = 3},
  [1748] = {.lex_state = 7, .external_lex_state = 3},
  [1749] = {.lex_state = 7, .external_lex_state = 3},
  [1750] = {.lex_state = 7, .external_lex_state = 3},
  [1751] = {.lex_state = 7, .external_lex_state = 3},
  [1752] = {.lex_state = 7, .external_lex_state = 4},
  [1753] = {.lex_state = 7, .external_lex_state = 3},
  [1754] = {.lex_state = 7, .external_lex_state = 3},
  [1755] = {.lex_state = 7, .external_lex_state = 3},
  [1756] = {.lex_state = 7, .external_lex_state = 3},
  [1757] = {.lex_state = 7, .external_lex_state = 3},
  [1758] = {.lex_state = 7, .external_lex_state = 3},
  [1759] = {.lex_state = 7, .external_lex_state = 3},
  [1760] = {.lex_state = 7, .external_lex_state = 3},
  [1761] = {.lex_state = 7, .external_lex_state = 3},
  [1762] = {.lex_state = 7, .external_lex_state = 3},
  [1763] = {.lex_state = 7, .external_lex_state = 3},
  [1764] = {.lex_state = 7, .external_lex_state = 3},
  [1765] = {.lex_state = 7, .external_lex_state = 3},
  [1766] = {.lex_state = 12, .external_lex_state = 5},
  [1767] = {.lex_state = 7, .external_lex_state = 3},
  [1768] = {.lex_state = 7, .external_lex_state = 4},
  [1769] = {.lex_state = 12, .external_lex_state = 5},
  [1770] = {.lex_state = 7, .external_lex_state = 4},
  [1771] = {.lex_state = 7, .external_lex_state = 3},
  [1772] = {.lex_state = 12, .external_lex_state = 5},
  [1773] = {.lex_state = 12, .external_lex_state = 5},
  [1774] = {.lex_state = 12, .external_lex_state = 5},
  [1775] = {.lex_state = 12, .external_lex_state = 5},
  [1776] = {.lex_state = 7, .external_lex_state = 4},
  [1777] = {.lex_state = 12, .external_lex_state = 5},
  [1778] = {.lex_state = 7, .external_lex_state = 3},
  [1779] = {.lex_state = 7, .external_lex_state = 3},
  [1780] = {.lex_state = 7, .external_lex_state = 3},
  [1781] = {.lex_state = 7, .external_lex_state = 3},
  [1782] = {.lex_state = 7, .external_lex_state = 4},
  [1783] = {.lex_state = 7, .external_lex_state = 4},
  [1784] = {.lex_state = 7, .external_lex_state = 4},
  [1785] = {.lex_state = 12, .external_lex_state = 5},
  [1786] = {.lex_state = 12, .external_lex_state = 5},
  [1787] = {.lex_state = 7, .external_lex_state = 4},
  [1788] = {.lex_state = 7, .external_lex_state = 4},
  [1789] = {.lex_state = 7, .external_lex_state = 4},
  [1790] = {.lex_state = 7, .external_lex_state = 4},
  [1791] = {.lex_state = 12, .external_lex_state = 5},
  [1792] = {.lex_state = 7, .external_lex_state = 4},
  [1793] = {.lex_state = 7, .external_lex_state = 3},
  [1794] = {.lex_state = 7, .external_lex_state = 4},
  [1795] = {.lex_state = 7, .external_lex_state = 3},
  [1796] = {.lex_state = 7, .external_lex_state = 4},
  [1797] = {.lex_state = 7, .external_lex_state = 4},
  [1798] = {.lex_state = 7, .external_lex_state = 3},
  [1799] = {.lex_state = 7, .external_lex_state = 3},
  [1800] = {.lex_state = 7, .external_lex_state = 3},
  [1801] = {.lex_state = 7, .external_lex_state = 4},
  [1802] = {.lex_state = 7, .external_lex_state = 4},
  [1803] = {.lex_state = 7, .external_lex_state = 4},
  [1804] = {.lex_state = 7, .external_lex_state = 4},
  [1805] = {.lex_state = 7, .external_lex_state = 4},
  [1806] = {.lex_state = 7, .external_lex_state = 4},
  [1807] = {.lex_state = 7, .external_lex_state = 4},
  [1808] = {.lex_state = 7, .external_lex_state = 4},
  [1809] = {.lex_state = 7, .external_lex_state = 4},
  [1810] = {.lex_state = 7, .external_lex_state = 4},
  [1811] = {.lex_state = 7, .external_lex_state = 4},
  [1812] = {.lex_state = 7, .external_lex_state = 4},
  [1813] = {.lex_state = 7, .external_lex_state = 3},
  [1814] = {.lex_state = 7, .external_lex_state = 4},
  [1815] = {.lex_state = 7, .external_lex_state = 4},
  [1816] = {.lex_state = 7, .external_lex_state = 4},
  [1817] = {.lex_state = 7, .external_lex_state = 3},
  [1818] = {.lex_state = 7, .external_lex_state = 4},
  [1819] = {.lex_state = 7, .external_lex_state = 4},
  [1820] = {.lex_state = 7, .external_lex_state = 4},
  [1821] = {.lex_state = 7, .external_lex_state = 4},
  [1822] = {.lex_state = 7, .external_lex_state = 4},
  [1823] = {.lex_state = 7, .external_lex_state = 4},
  [1824] = {.lex_state = 8, .external_lex_state = 3},
  [1825] = {.lex_state = 12, .external_lex_state = 5},
  [1826] = {.lex_state = 7, .external_lex_state = 4},
  [1827] = {.lex_state = 7, .external_lex_state = 3},
  [1828] = {.lex_state = 7, .external_lex_state = 4},
  [1829] = {.lex_state = 7, .external_lex_state = 4},
  [1830] = {.lex_state = 7, .external_lex_state = 4},
  [1831] = {.lex_state = 12, .external_lex_state = 5},
  [1832] = {.lex_state = 7, .external_lex_state = 4},
  [1833] = {.lex_state = 7, .external_lex_state = 4},
  [1834] = {.lex_state = 7, .external_lex_state = 3},
  [1835] = {.lex_state = 12, .external_lex_state = 5},
  [1836] = {.lex_state = 7, .external_lex_state = 4},
  [1837] = {.lex_state = 7, .external_lex_state = 4},
  [1838] = {.lex_state = 7, .external_lex_state = 4},
  [1839] = {.lex_state = 7, .external_lex_state = 4},
  [1840] = {.lex_state = 7, .external_lex_state = 4},
  [1841] = {.lex_state = 7, .external_lex_state = 4},
  [1842] = {.lex_state = 7, .external_lex_state = 4},
  [1843] = {.lex_state = 7, .external_lex_state = 4},
  [1844] = {.lex_state = 7, .external_lex_state = 4},
  [1845] = {.lex_state = 7, .external_lex_state = 4},
  [1846] = {.lex_state = 7, .external_lex_state = 4},
  [1847] = {.lex_state = 7, .external_lex_state = 4},
  [1848] = {.lex_state = 7, .external_lex_state = 4},
  [1849] = {.lex_state = 7, .external_lex_state = 4},
  [1850] = {.lex_state = 7, .external_lex_state = 4},
  [1851] = {.lex_state = 7, .external_lex_state = 4},
  [1852] = {.lex_state = 7, .external_lex_state = 4},
  [1853] = {.lex_state = 7, .external_lex_state = 4},
  [1854] = {.lex_state = 7, .external_lex_state = 4},
  [1855] = {.lex_state = 7, .external_lex_state = 4},
  [1856] = {.lex_state = 7, .external_lex_state = 4},
  [1857] = {.lex_state = 7, .external_lex_state = 4},
  [1858] = {.lex_state = 7, .external_lex_state = 4},
  [1859] = {.lex_state = 7, .external_lex_state = 4},
  [1860] = {.lex_state = 7, .external_lex_state = 4},
  [1861] = {.lex_state = 7, .external_lex_state = 4},
  [1862] = {.lex_state = 7, .external_lex_state = 4},
  [1863] = {.lex_state = 7, .external_lex_state = 4},
  [1864] = {.lex_state = 7, .external_lex_state = 4},
  [1865] = {.lex_state = 7, .external_lex_state = 4},
  [1866] = {.lex_state = 7, .external_lex_state = 3},
  [1867] = {.lex_state = 7, .external_lex_state = 4},
  [1868] = {.lex_state = 7, .external_lex_state = 3},
  [1869] = {.lex_state = 7, .external_lex_state = 4},
  [1870] = {.lex_state = 7, .external_lex_state = 4},
  [1871] = {.lex_state = 12, .external_lex_state = 5},
  [1872] = {.lex_state = 12, .external_lex_state = 5},
  [1873] = {.lex_state = 7, .external_lex_state = 4},
  [1874] = {.lex_state = 7, .external_lex_state = 4},
  [1875] = {.lex_state = 7, .external_lex_state = 4},
  [1876] = {.lex_state = 7, .external_lex_state = 4},
  [1877] = {.lex_state = 7, .external_lex_state = 4},
  [1878] = {.lex_state = 7, .external_lex_state = 4},
  [1879] = {.lex_state = 12, .external_lex_state = 2},
  [1880] = {.lex_state = 7, .external_lex_state = 4},
  [1881] = {.lex_state = 7, .external_lex_state = 4},
  [1882] = {.lex_state = 7, .external_lex_state = 4},
  [1883] = {.lex_state = 7, .external_lex_state = 4},
  [1884] = {.lex_state = 7, .external_lex_state = 4},
  [1885] = {.lex_state = 7, .external_lex_state = 3},
  [1886] = {.lex_state = 7, .external_lex_state = 3},
  [1887] = {.lex_state = 7, .external_lex_state = 3},
  [1888] = {.lex_state = 7, .external_lex_state = 3},
  [1889] = {.lex_state = 7, .external_lex_state = 3},
  [1890] = {.lex_state = 7, .external_lex_state = 3},
  [1891] = {.lex_state = 12, .external_lex_state = 2},
  [1892] = {.lex_state = 7, .external_lex_state = 3},
  [1893] = {.lex_state = 7, .external_lex_state = 4},
  [1894] = {.lex_state = 7, .external_lex_state = 3},
  [1895] = {.lex_state = 7, .external_lex_state = 3},
  [1896] = {.lex_state = 7, .external_lex_state = 4},
  [1897] = {.lex_state = 7, .external_lex_state = 3},
  [1898] = {.lex_state = 7, .external_lex_state = 3},
  [1899] = {.lex_state = 7, .external_lex_state = 3},
  [1900] = {.lex_state = 7, .external_lex_state = 3},
  [1901] = {.lex_state = 7, .external_lex_state = 3},
  [1902] = {.lex_state = 7, .external_lex_state = 3},
  [1903] = {.lex_state = 7, .external_lex_state = 3},
  [1904] = {.lex_state = 7, .external_lex_state = 3},
  [1905] = {.lex_state = 7, .external_lex_state = 4},
  [1906] = {.lex_state = 7, .external_lex_state = 3},
  [1907] = {.lex_state = 7, .external_lex_state = 3},
  [1908] = {.lex_state = 7, .external_lex_state = 3},
  [1909] = {.lex_state = 7, .external_lex_state = 4},
  [1910] = {.lex_state = 7, .external_lex_state = 4},
  [1911] = {.lex_state = 7, .external_lex_state = 4},
  [1912] = {.lex_state = 7, .external_lex_state = 4},
  [1913] = {.lex_state = 7, .external_lex_state = 3},
  [1914] = {.lex_state = 7, .external_lex_state = 3},
  [1915] = {.lex_state = 7, .external_lex_state = 4},
  [1916] = {.lex_state = 12, .external_lex_state = 5},
  [1917] = {.lex_state = 12, .external_lex_state = 2},
  [1918] = {.lex_state = 7, .external_lex_state = 4},
  [1919] = {.lex_state = 7, .external_lex_state = 3},
  [1920] = {.lex_state = 7, .external_lex_state = 3},
  [1921] = {.lex_state = 7, .external_lex_state = 4},
  [1922] = {.lex_state = 7, .external_lex_state = 4},
  [1923] = {.lex_state = 7, .external_lex_state = 4},
  [1924] = {.lex_state = 7, .external_lex_state = 3},
  [1925] = {.lex_state = 7, .external_lex_state = 4},
  [1926] = {.lex_state = 7, .external_lex_state = 4},
  [1927] = {.lex_state = 7, .external_lex_state = 3},
  [1928] = {.lex_state = 12, .external_lex_state = 5},
  [1929] = {.lex_state = 7, .external_lex_state = 4},
  [1930] = {.lex_state = 7, .external_lex_state = 3},
  [1931] = {.lex_state = 7, .external_lex_state = 4},
  [1932] = {.lex_state = 7, .external_lex_state = 4},
  [1933] = {.lex_state = 7, .external_lex_state = 3},
  [1934] = {.lex_state = 7, .external_lex_state = 3},
  [1935] = {.lex_state = 7, .external_lex_state = 4},
  [1936] = {.lex_state = 7, .external_lex_state = 3},
  [1937] = {.lex_state = 7, .external_lex_state = 4},
  [1938] = {.lex_state = 7, .external_lex_state = 4},
  [1939] = {.lex_state = 7, .external_lex_state = 4},
  [1940] = {.lex_state = 7, .external_lex_state = 4},
  [1941] = {.lex_state = 7, .external_lex_state = 4},
  [1942] = {.lex_state = 7, .external_lex_state = 4},
  [1943] = {.lex_state = 7, .external_lex_state = 4},
  [1944] = {.lex_state = 7, .external_lex_state = 4},
  [1945] = {.lex_state = 7, .external_lex_state = 4},
  [1946] = {.lex_state = 7, .external_lex_state = 4},
  [1947] = {.lex_state = 7, .external_lex_state = 4},
  [1948] = {.lex_state = 12, .external_lex_state = 2},
  [1949] = {.lex_state = 7, .external_lex_state = 3},
  [1950] = {.lex_state = 7, .external_lex_state = 3},
  [1951] = {.lex_state = 7, .external_lex_state = 4},
  [1952] = {.lex_state = 7, .external_lex_state = 4},
  [1953] = {.lex_state = 12, .external_lex_state = 2},
  [1954] = {.lex_state = 7, .external_lex_state = 3},
  [1955] = {.lex_state = 7, .external_lex_state = 3},
  [1956] = {.lex_state = 7, .external_lex_state = 4},
  [1957] = {.lex_state = 7, .external_lex_state = 4},
  [1958] = {.lex_state = 7, .external_lex_state = 4},
  [1959] = {.lex_state = 7, .external_lex_state = 3},
  [1960] = {.lex_state = 7, .external_lex_state = 3},
  [1961] = {.lex_state = 7, .external_lex_state = 4},
  [1962] = {.lex_state = 12, .external_lex_state = 5},
  [1963] = {.lex_state = 7, .external_lex_state = 4},
  [1964] = {.lex_state = 96, .external_lex_state = 2},
  [1965] = {.lex_state = 7, .external_lex_state = 4},
  [1966] = {.lex_state = 7, .external_lex_state = 4},
  [1967] = {.lex_state = 7, .external_lex_state = 4},
  [1968] = {.lex_state = 7, .external_lex_state = 4},
  [1969] = {.lex_state = 7, .external_lex_state = 4},
  [1970] = {.lex_state = 12, .external_lex_state = 5},
  [1971] = {.lex_state = 12, .external_lex_state = 5},
  [1972] = {.lex_state = 7, .external_lex_state = 4},
  [1973] = {.lex_state = 7, .external_lex_state = 4},
  [1974] = {.lex_state = 7, .external_lex_state = 4},
  [1975] = {.lex_state = 7, .external_lex_state = 3},
  [1976] = {.lex_state = 7, .external_lex_state = 4},
  [1977] = {.lex_state = 12, .external_lex_state = 5},
  [1978] = {.lex_state = 7, .external_lex_state = 4},
  [1979] = {.lex_state = 7, .external_lex_state = 4},
  [1980] = {.lex_state = 7, .external_lex_state = 4},
  [1981] = {.lex_state = 7, .external_lex_state = 4},
  [1982] = {.lex_state = 7, .external_lex_state = 4},
  [1983] = {.lex_state = 7, .external_lex_state = 4},
  [1984] = {.lex_state = 7, .external_lex_state = 4},
  [1985] = {.lex_state = 7, .external_lex_state = 4},
  [1986] = {.lex_state = 7, .external_lex_state = 4},
  [1987] = {.lex_state = 7, .external_lex_state = 4},
  [1988] = {.lex_state = 7, .external_lex_state = 4},
  [1989] = {.lex_state = 7, .external_lex_state = 4},
  [1990] = {.lex_state = 7, .external_lex_state = 4},
  [1991] = {.lex_state = 7, .external_lex_state = 4},
  [1992] = {.lex_state = 7, .external_lex_state = 4},
  [1993] = {.lex_state = 7, .external_lex_state = 4},
  [1994] = {.lex_state = 7, .external_lex_state = 4},
  [1995] = {.lex_state = 12, .external_lex_state = 5},
  [1996] = {.lex_state = 7, .external_lex_state = 4},
  [1997] = {.lex_state = 7, .external_lex_state = 4},
  [1998] = {.lex_state = 7, .external_lex_state = 4},
  [1999] = {.lex_state = 7, .external_lex_state = 4},
  [2000] = {.lex_state = 7, .external_lex_state = 4},
  [2001] = {.lex_state = 7, .external_lex_state = 4},
  [2002] = {.lex_state = 7, .external_lex_state = 4},
  [2003] = {.lex_state = 7, .external_lex_state = 3},
  [2004] = {.lex_state = 7, .external_lex_state = 3},
  [2005] = {.lex_state = 7, .external_lex_state = 4},
  [2006] = {.lex_state = 7, .external_lex_state = 4},
  [2007] = {.lex_state = 7, .external_lex_state = 4},
  [2008] = {.lex_state = 7, .external_lex_state = 4},
  [2009] = {.lex_state = 7, .external_lex_state = 4},
  [2010] = {.lex_state = 7, .external_lex_state = 4},
  [2011] = {.lex_state = 7, .external_lex_state = 4},
  [2012] = {.lex_state = 7, .external_lex_state = 4},
  [2013] = {.lex_state = 7, .external_lex_state = 4},
  [2014] = {.lex_state = 7, .external_lex_state = 4},
  [2015] = {.lex_state = 7, .external_lex_state = 4},
  [2016] = {.lex_state = 12, .external_lex_state = 5},
  [2017] = {.lex_state = 7, .external_lex_state = 4},
  [2018] = {.lex_state = 7, .external_lex_state = 4},
  [2019] = {.lex_state = 7, .external_lex_state = 4},
  [2020] = {.lex_state = 7, .external_lex_state = 4},
  [2021] = {.lex_state = 7, .external_lex_state = 3},
  [2022] = {.lex_state = 7, .external_lex_state = 4},
  [2023] = {.lex_state = 7, .external_lex_state = 4},
  [2024] = {.lex_state = 7, .external_lex_state = 4},
  [2025] = {.lex_state = 7, .external_lex_state = 4},
  [2026] = {.lex_state = 7, .external_lex_state = 3},
  [2027] = {.lex_state = 7, .external_lex_state = 4},
  [2028] = {.lex_state = 7, .external_lex_state = 3},
  [2029] = {.lex_state = 7, .external_lex_state = 4},
  [2030] = {.lex_state = 7, .external_lex_state = 4},
  [2031] = {.lex_state = 7, .external_lex_state = 4},
  [2032] = {.lex_state = 7, .external_lex_state = 4},
  [2033] = {.lex_state = 7, .external_lex_state = 4},
  [2034] = {.lex_state = 7, .external_lex_state = 4},
  [2035] = {.lex_state = 7, .external_lex_state = 4},
  [2036] = {.lex_state = 7, .external_lex_state = 4},
  [2037] = {.lex_state = 7, .external_lex_state = 4},
  [2038] = {.lex_state = 96, .external_lex_state = 2},
  [2039] = {.lex_state = 7, .external_lex_state = 4},
  [2040] = {.lex_state = 7, .external_lex_state = 3},
  [2041] = {.lex_state = 7, .external_lex_state = 4},
  [2042] = {.lex_state = 7, .external_lex_state = 4},
  [2043] = {.lex_state = 7, .external_lex_state = 4},
  [2044] = {.lex_state = 7, .external_lex_state = 4},
  [2045] = {.lex_state = 7, .external_lex_state = 3},
  [2046] = {.lex_state = 7, .external_lex_state = 4},
  [2047] = {.lex_state = 7, .external_lex_state = 4},
  [2048] = {.lex_state = 7, .external_lex_state = 4},
  [2049] = {.lex_state = 7, .external_lex_state = 4},
  [2050] = {.lex_state = 7, .external_lex_state = 4},
  [2051] = {.lex_state = 7, .external_lex_state = 4},
  [2052] = {.lex_state = 7, .external_lex_state = 4},
  [2053] = {.lex_state = 7, .external_lex_state = 4},
  [2054] = {.lex_state = 7, .external_lex_state = 4},
  [2055] = {.lex_state = 7, .external_lex_state = 4},
  [2056] = {.lex_state = 7, .external_lex_state = 4},
  [2057] = {.lex_state = 7, .external_lex_state = 4},
  [2058] = {.lex_state = 7, .external_lex_state = 4},
  [2059] = {.lex_state = 7, .external_lex_state = 4},
  [2060] = {.lex_state = 7, .external_lex_state = 4},
  [2061] = {.lex_state = 7, .external_lex_state = 4},
  [2062] = {.lex_state = 7, .external_lex_state = 4},
  [2063] = {.lex_state = 7, .external_lex_state = 4},
  [2064] = {.lex_state = 7, .external_lex_state = 4},
  [2065] = {.lex_state = 7, .external_lex_state = 4},
  [2066] = {.lex_state = 7, .external_lex_state = 4},
  [2067] = {.lex_state = 12, .external_lex_state = 5},
  [2068] = {.lex_state = 12, .external_lex_state = 5},
  [2069] = {.lex_state = 7, .external_lex_state = 4},
  [2070] = {.lex_state = 12, .external_lex_state = 5},
  [2071] = {.lex_state = 7, .external_lex_state = 4},
  [2072] = {.lex_state = 12, .external_lex_state = 5},
  [2073] = {.lex_state = 12, .external_lex_state = 5},
  [2074] = {.lex_state = 7, .external_lex_state = 4},
  [2075] = {.lex_state = 7, .external_lex_state = 4},
  [2076] = {.lex_state = 7, .external_lex_state = 4},
  [2077] = {.lex_state = 12, .external_lex_state = 2},
  [2078] = {.lex_state = 7, .external_lex_state = 4},
  [2079] = {.lex_state = 7, .external_lex_state = 4},
  [2080] = {.lex_state = 7, .external_lex_state = 4},
  [2081] = {.lex_state = 7, .external_lex_state = 4},
  [2082] = {.lex_state = 7, .external_lex_state = 3},
  [2083] = {.lex_state = 7, .external_lex_state = 3},
  [2084] = {.lex_state = 7, .external_lex_state = 3},
  [2085] = {.lex_state = 7, .external_lex_state = 3},
  [2086] = {.lex_state = 7, .external_lex_state = 3},
  [2087] = {.lex_state = 7, .external_lex_state = 3},
  [2088] = {.lex_state = 7, .external_lex_state = 3},
  [2089] = {.lex_state = 7, .external_lex_state = 3},
  [2090] = {.lex_state = 7, .external_lex_state = 3},
  [2091] = {.lex_state = 7, .external_lex_state = 3},
  [2092] = {.lex_state = 7, .external_lex_state = 3},
  [2093] = {.lex_state = 7, .external_lex_state = 3},
  [2094] = {.lex_state = 7, .external_lex_state = 3},
  [2095] = {.lex_state = 7, .external_lex_state = 3},
  [2096] = {.lex_state = 7, .external_lex_state = 3},
  [2097] = {.lex_state = 7, .external_lex_state = 3},
  [2098] = {.lex_state = 7, .external_lex_state = 3},
  [2099] = {.lex_state = 7, .external_lex_state = 3},
  [2100] = {.lex_state = 7, .external_lex_state = 3},
  [2101] = {.lex_state = 7, .external_lex_state = 3},
  [2102] = {.lex_state = 7, .external_lex_state = 3},
  [2103] = {.lex_state = 7, .external_lex_state = 3},
  [2104] = {.lex_state = 7, .external_lex_state = 3},
  [2105] = {.lex_state = 7, .external_lex_state = 3},
  [2106] = {.lex_state = 7, .external_lex_state = 3},
  [2107] = {.lex_state = 7, .external_lex_state = 3},
  [2108] = {.lex_state = 7, .external_lex_state = 3},
  [2109] = {.lex_state = 7, .external_lex_state = 3},
  [2110] = {.lex_state = 7, .external_lex_state = 3},
  [2111] = {.lex_state = 7, .external_lex_state = 3},
  [2112] = {.lex_state = 7, .external_lex_state = 4},
  [2113] = {.lex_state = 7, .external_lex_state = 3},
  [2114] = {.lex_state = 7, .external_lex_state = 4},
  [2115] = {.lex_state = 7, .external_lex_state = 4},
  [2116] = {.lex_state = 7, .external_lex_state = 3},
  [2117] = {.lex_state = 7, .external_lex_state = 4},
  [2118] = {.lex_state = 7, .external_lex_state = 4},
  [2119] = {.lex_state = 12, .external_lex_state = 5},
  [2120] = {.lex_state = 7, .external_lex_state = 4},
  [2121] = {.lex_state = 7, .external_lex_state = 4},
  [2122] = {.lex_state = 12, .external_lex_state = 5},
  [2123] = {.lex_state = 12, .external_lex_state = 5},
  [2124] = {.lex_state = 7, .external_lex_state = 3},
  [2125] = {.lex_state = 7, .external_lex_state = 4},
  [2126] = {.lex_state = 7, .external_lex_state = 3},
  [2127] = {.lex_state = 7, .external_lex_state = 4},
  [2128] = {.lex_state = 7, .external_lex_state = 3},
  [2129] = {.lex_state = 7, .external_lex_state = 4},
  [2130] = {.lex_state = 7, .external_lex_state = 4},
  [2131] = {.lex_state = 7, .external_lex_state = 4},
  [2132] = {.lex_state = 7, .external_lex_state = 4},
  [2133] = {.lex_state = 7, .external_lex_state = 4},
  [2134] = {.lex_state = 7, .external_lex_state = 4},
  [2135] = {.lex_state = 7, .external_lex_state = 4},
  [2136] = {.lex_state = 7, .external_lex_state = 3},
  [2137] = {.lex_state = 7, .external_lex_state = 4},
  [2138] = {.lex_state = 12, .external_lex_state = 2},
  [2139] = {.lex_state = 7, .external_lex_state = 3},
  [2140] = {.lex_state = 12, .external_lex_state = 2},
  [2141] = {.lex_state = 7, .external_lex_state = 4},
  [2142] = {.lex_state = 7, .external_lex_state = 3},
  [2143] = {.lex_state = 7, .external_lex_state = 3},
  [2144] = {.lex_state = 7, .external_lex_state = 3},
  [2145] = {.lex_state = 7, .external_lex_state = 3},
  [2146] = {.lex_state = 7, .external_lex_state = 3},
  [2147] = {.lex_state = 7, .external_lex_state = 3},
  [2148] = {.lex_state = 12, .external_lex_state = 2},
  [2149] = {.lex_state = 7, .external_lex_state = 3},
  [2150] = {.lex_state = 12, .external_lex_state = 2},
  [2151] = {.lex_state = 12, .external_lex_state = 5},
  [2152] = {.lex_state = 12, .external_lex_state = 5},
  [2153] = {.lex_state = 7, .external_lex_state = 3},
  [2154] = {.lex_state = 7, .external_lex_state = 3},
  [2155] = {.lex_state = 96, .external_lex_state = 2},
  [2156] = {.lex_state = 12, .external_lex_state = 5},
  [2157] = {.lex_state = 12, .external_lex_state = 5},
  [2158] = {.lex_state = 7, .external_lex_state = 3},
  [2159] = {.lex_state = 7, .external_lex_state = 3},
  [2160] = {.lex_state = 7, .external_lex_state = 4},
  [2161] = {.lex_state = 7, .external_lex_state = 4},
  [2162] = {.lex_state = 7, .external_lex_state = 4},
  [2163] = {.lex_state = 12, .external_lex_state = 5},
  [2164] = {.lex_state = 12, .external_lex_state = 5},
  [2165] = {.lex_state = 12, .external_lex_state = 5},
  [2166] = {.lex_state = 12, .external_lex_state = 5},
  [2167] = {.lex_state = 7, .external_lex_state = 4},
  [2168] = {.lex_state = 12, .external_lex_state = 5},
  [2169] = {.lex_state = 12, .external_lex_state = 5},
  [2170] = {.lex_state = 7, .external_lex_state = 4},
  [2171] = {.lex_state = 7, .external_lex_state = 4},
  [2172] = {.lex_state = 7, .external_lex_state = 4},
  [2173] = {.lex_state = 7, .external_lex_state = 4},
  [2174] = {.lex_state = 12, .external_lex_state = 5},
  [2175] = {.lex_state = 7, .external_lex_state = 3},
  [2176] = {.lex_state = 8, .external_lex_state = 4},
  [2177] = {.lex_state = 7, .external_lex_state = 3},
  [2178] = {.lex_state = 7, .external_lex_state = 3},
  [2179] = {.lex_state = 7, .external_lex_state = 3},
  [2180] = {.lex_state = 7, .external_lex_state = 3},
  [2181] = {.lex_state = 7, .external_lex_state = 4},
  [2182] = {.lex_state = 7, .external_lex_state = 3},
  [2183] = {.lex_state = 7, .external_lex_state = 4},
  [2184] = {.lex_state = 7, .external_lex_state = 4},
  [2185] = {.lex_state = 7, .external_lex_state = 4},
  [2186] = {.lex_state = 7, .external_lex_state = 4},
  [2187] = {.lex_state = 7, .external_lex_state = 3},
  [2188] = {.lex_state = 7, .external_lex_state = 4},
  [2189] = {.lex_state = 7, .external_lex_state = 4},
  [2190] = {.lex_state = 7, .external_lex_state = 4},
  [2191] = {.lex_state = 7, .external_lex_state = 4},
  [2192] = {.lex_state = 7, .external_lex_state = 3},
  [2193] = {.lex_state = 7, .external_lex_state = 4},
  [2194] = {.lex_state = 7, .external_lex_state = 3},
  [2195] = {.lex_state = 7, .external_lex_state = 4},
  [2196] = {.lex_state = 7, .external_lex_state = 4},
  [2197] = {.lex_state = 7, .external_lex_state = 4},
  [2198] = {.lex_state = 7, .external_lex_state = 4},
  [2199] = {.lex_state = 7, .external_lex_state = 4},
  [2200] = {.lex_state = 7, .external_lex_state = 4},
  [2201] = {.lex_state = 7, .external_lex_state = 4},
  [2202] = {.lex_state = 7, .external_lex_state = 4},
  [2203] = {.lex_state = 7, .external_lex_state = 4},
  [2204] = {.lex_state = 7, .external_lex_state = 4},
  [2205] = {.lex_state = 7, .external_lex_state = 4},
  [2206] = {.lex_state = 7, .external_lex_state = 4},
  [2207] = {.lex_state = 7, .external_lex_state = 4},
  [2208] = {.lex_state = 7, .external_lex_state = 4},
  [2209] = {.lex_state = 7, .external_lex_state = 4},
  [2210] = {.lex_state = 7, .external_lex_state = 4},
  [2211] = {.lex_state = 7, .external_lex_state = 4},
  [2212] = {.lex_state = 12, .external_lex_state = 5},
  [2213] = {.lex_state = 12, .external_lex_state = 5},
  [2214] = {.lex_state = 7, .external_lex_state = 3},
  [2215] = {.lex_state = 7, .external_lex_state = 4},
  [2216] = {.lex_state = 7, .external_lex_state = 4},
  [2217] = {.lex_state = 7, .external_lex_state = 4},
  [2218] = {.lex_state = 12, .external_lex_state = 5},
  [2219] = {.lex_state = 12, .external_lex_state = 5},
  [2220] = {.lex_state = 12, .external_lex_state = 5},
  [2221] = {.lex_state = 7, .external_lex_state = 3},
  [2222] = {.lex_state = 7, .external_lex_state = 4},
  [2223] = {.lex_state = 7, .external_lex_state = 4},
  [2224] = {.lex_state = 12, .external_lex_state = 5},
  [2225] = {.lex_state = 7, .external_lex_state = 4},
  [2226] = {.lex_state = 12, .external_lex_state = 5},
  [2227] = {.lex_state = 12, .external_lex_state = 5},
  [2228] = {.lex_state = 12, .external_lex_state = 5},
  [2229] = {.lex_state = 12, .external_lex_state = 5},
  [2230] = {.lex_state = 12, .external_lex_state = 5},
  [2231] = {.lex_state = 12, .external_lex_state = 5},
  [2232] = {.lex_state = 7, .external_lex_state = 4},
  [2233] = {.lex_state = 7, .external_lex_state = 3},
  [2234] = {.lex_state = 7, .external_lex_state = 4},
  [2235] = {.lex_state = 7, .external_lex_state = 4},
  [2236] = {.lex_state = 7, .external_lex_state = 3},
  [2237] = {.lex_state = 7, .external_lex_state = 4},
  [2238] = {.lex_state = 7, .external_lex_state = 4},
  [2239] = {.lex_state = 7, .external_lex_state = 4},
  [2240] = {.lex_state = 7, .external_lex_state = 4},
  [2241] = {.lex_state = 7, .external_lex_state = 3},
  [2242] = {.lex_state = 7, .external_lex_state = 4},
  [2243] = {.lex_state = 7, .external_lex_state = 4},
  [2244] = {.lex_state = 7, .external_lex_state = 4},
  [2245] = {.lex_state = 7, .external_lex_state = 4},
  [2246] = {.lex_state = 12, .external_lex_state = 5},
  [2247] = {.lex_state = 12, .external_lex_state = 5},
  [2248] = {.lex_state = 7, .external_lex_state = 3},
  [2249] = {.lex_state = 7, .external_lex_state = 4},
  [2250] = {.lex_state = 7, .external_lex_state = 3},
  [2251] = {.lex_state = 7, .external_lex_state = 3},
  [2252] = {.lex_state = 7, .external_lex_state = 3},
  [2253] = {.lex_state = 7, .external_lex_state = 3},
  [2254] = {.lex_state = 7, .external_lex_state = 4},
  [2255] = {.lex_state = 7, .external_lex_state = 3},
  [2256] = {.lex_state = 7, .external_lex_state = 3},
  [2257] = {.lex_state = 7, .external_lex_state = 3},
  [2258] = {.lex_state = 7, .external_lex_state = 3},
  [2259] = {.lex_state = 7, .external_lex_state = 4},
  [2260] = {.lex_state = 7, .external_lex_state = 4},
  [2261] = {.lex_state = 7, .external_lex_state = 4},
  [2262] = {.lex_state = 7, .external_lex_state = 4},
  [2263] = {.lex_state = 7, .external_lex_state = 4},
  [2264] = {.lex_state = 12, .external_lex_state = 5},
  [2265] = {.lex_state = 7, .external_lex_state = 3},
  [2266] = {.lex_state = 7, .external_lex_state = 4},
  [2267] = {.lex_state = 12, .external_lex_state = 2},
  [2268] = {.lex_state = 12, .external_lex_state = 2},
  [2269] = {.lex_state = 7, .external_lex_state = 4},
  [2270] = {.lex_state = 7, .external_lex_state = 3},
  [2271] = {.lex_state = 7, .external_lex_state = 3},
  [2272] = {.lex_state = 12, .external_lex_state = 2},
  [2273] = {.lex_state = 7, .external_lex_state = 4},
  [2274] = {.lex_state = 12, .external_lex_state = 5},
  [2275] = {.lex_state = 12, .external_lex_state = 2},
  [2276] = {.lex_state = 7, .external_lex_state = 4},
  [2277] = {.lex_state = 7, .external_lex_state = 4},
  [2278] = {.lex_state = 7, .external_lex_state = 4},
  [2279] = {.lex_state = 7, .external_lex_state = 4},
  [2280] = {.lex_state = 7, .external_lex_state = 4},
  [2281] = {.lex_state = 7, .external_lex_state = 3},
  [2282] = {.lex_state = 12, .external_lex_state = 5},
  [2283] = {.lex_state = 7, .external_lex_state = 3},
  [2284] = {.lex_state = 7, .external_lex_state = 3},
  [2285] = {.lex_state = 12, .external_lex_state = 5},
  [2286] = {.lex_state = 7, .external_lex_state = 3},
  [2287] = {.lex_state = 12, .external_lex_state = 5},
  [2288] = {.lex_state = 7, .external_lex_state = 4},
  [2289] = {.lex_state = 7, .external_lex_state = 4},
  [2290] = {.lex_state = 7, .external_lex_state = 4},
  [2291] = {.lex_state = 7, .external_lex_state = 4},
  [2292] = {.lex_state = 7, .external_lex_state = 4},
  [2293] = {.lex_state = 7, .external_lex_state = 4},
  [2294] = {.lex_state = 7, .external_lex_state = 4},
  [2295] = {.lex_state = 7, .external_lex_state = 4},
  [2296] = {.lex_state = 7, .external_lex_state = 4},
  [2297] = {.lex_state = 7, .external_lex_state = 3},
  [2298] = {.lex_state = 7, .external_lex_state = 3},
  [2299] = {.lex_state = 7, .external_lex_state = 3},
  [2300] = {.lex_state = 7, .external_lex_state = 3},
  [2301] = {.lex_state = 7, .external_lex_state = 3},
  [2302] = {.lex_state = 7, .external_lex_state = 3},
  [2303] = {.lex_state = 7, .external_lex_state = 3},
  [2304] = {.lex_state = 7, .external_lex_state = 3},
  [2305] = {.lex_state = 7, .external_lex_state = 3},
  [2306] = {.lex_state = 7, .external_lex_state = 4},
  [2307] = {.lex_state = 12, .external_lex_state = 5},
  [2308] = {.lex_state = 12, .external_lex_state = 5},
  [2309] = {.lex_state = 7, .external_lex_state = 3},
  [2310] = {.lex_state = 12, .external_lex_state = 5},
  [2311] = {.lex_state = 7, .external_lex_state = 4},
  [2312] = {.lex_state = 7, .external_lex_state = 4},
  [2313] = {.lex_state = 7, .external_lex_state = 4},
  [2314] = {.lex_state = 12, .external_lex_state = 5},
  [2315] = {.lex_state = 7, .external_lex_state = 4},
  [2316] = {.lex_state = 12, .external_lex_state = 5},
  [2317] = {.lex_state = 12, .external_lex_state = 5},
  [2318] = {.lex_state = 12, .external_lex_state = 5},
  [2319] = {.lex_state = 7, .external_lex_state = 3},
  [2320] = {.lex_state = 7, .external_lex_state = 4},
  [2321] = {.lex_state = 12, .external_lex_state = 5},
  [2322] = {.lex_state = 12, .external_lex_state = 5},
  [2323] = {.lex_state = 7, .external_lex_state = 3},
  [2324] = {.lex_state = 96, .external_lex_state = 2},
  [2325] = {.lex_state = 7, .external_lex_state = 4},
  [2326] = {.lex_state = 7, .external_lex_state = 4},
  [2327] = {.lex_state = 7, .external_lex_state = 4},
  [2328] = {.lex_state = 7, .external_lex_state = 3},
  [2329] = {.lex_state = 7, .external_lex_state = 4},
  [2330] = {.lex_state = 7, .external_lex_state = 4},
  [2331] = {.lex_state = 7, .external_lex_state = 4},
  [2332] = {.lex_state = 7, .external_lex_state = 4},
  [2333] = {.lex_state = 7, .external_lex_state = 4},
  [2334] = {.lex_state = 12, .external_lex_state = 2},
  [2335] = {.lex_state = 12, .external_lex_state = 2},
  [2336] = {.lex_state = 7, .external_lex_state = 3},
  [2337] = {.lex_state = 7, .external_lex_state = 3},
  [2338] = {.lex_state = 7, .external_lex_state = 3},
  [2339] = {.lex_state = 7, .external_lex_state = 3},
  [2340] = {.lex_state = 7, .external_lex_state = 4},
  [2341] = {.lex_state = 7, .external_lex_state = 3},
  [2342] = {.lex_state = 7, .external_lex_state = 3},
  [2343] = {.lex_state = 12, .external_lex_state = 5},
  [2344] = {.lex_state = 7, .external_lex_state = 4},
  [2345] = {.lex_state = 12, .external_lex_state = 2},
  [2346] = {.lex_state = 12, .external_lex_state = 2},
  [2347] = {.lex_state = 7, .external_lex_state = 3},
  [2348] = {.lex_state = 8, .external_lex_state = 4},
  [2349] = {.lex_state = 7, .external_lex_state = 4},
  [2350] = {.lex_state = 7, .external_lex_state = 4},
  [2351] = {.lex_state = 7, .external_lex_state = 3},
  [2352] = {.lex_state = 7, .external_lex_state = 3},
  [2353] = {.lex_state = 7, .external_lex_state = 3},
  [2354] = {.lex_state = 7, .external_lex_state = 4},
  [2355] = {.lex_state = 7, .external_lex_state = 3},
  [2356] = {.lex_state = 7, .external_lex_state = 4},
  [2357] = {.lex_state = 12, .external_lex_state = 5},
  [2358] = {.lex_state = 12, .external_lex_state = 5},
  [2359] = {.lex_state = 7, .external_lex_state = 4},
  [2360] = {.lex_state = 12, .external_lex_state = 5},
  [2361] = {.lex_state = 7, .external_lex_state = 3},
  [2362] = {.lex_state = 7, .external_lex_state = 4},
  [2363] = {.lex_state = 7, .external_lex_state = 3},
  [2364] = {.lex_state = 7, .external_lex_state = 3},
  [2365] = {.lex_state = 7, .external_lex_state = 3},
  [2366] = {.lex_state = 7, .external_lex_state = 3},
  [2367] = {.lex_state = 7, .external_lex_state = 3},
  [2368] = {.lex_state = 7, .external_lex_state = 3},
  [2369] = {.lex_state = 7, .external_lex_state = 3},
  [2370] = {.lex_state = 7, .external_lex_state = 3},
  [2371] = {.lex_state = 7, .external_lex_state = 3},
  [2372] = {.lex_state = 7, .external_lex_state = 3},
  [2373] = {.lex_state = 7, .external_lex_state = 3},
  [2374] = {.lex_state = 7, .external_lex_state = 3},
  [2375] = {.lex_state = 7, .external_lex_state = 3},
  [2376] = {.lex_state = 7, .external_lex_state = 3},
  [2377] = {.lex_state = 7, .external_lex_state = 3},
  [2378] = {.lex_state = 7, .external_lex_state = 3},
  [2379] = {.lex_state = 7, .external_lex_state = 3},
  [2380] = {.lex_state = 7, .external_lex_state = 3},
  [2381] = {.lex_state = 7, .external_lex_state = 3},
  [2382] = {.lex_state = 7, .external_lex_state = 3},
  [2383] = {.lex_state = 7, .external_lex_state = 3},
  [2384] = {.lex_state = 7, .external_lex_state = 3},
  [2385] = {.lex_state = 7, .external_lex_state = 3},
  [2386] = {.lex_state = 7, .external_lex_state = 3},
  [2387] = {.lex_state = 7, .external_lex_state = 3},
  [2388] = {.lex_state = 7, .external_lex_state = 3},
  [2389] = {.lex_state = 7, .external_lex_state = 3},
  [2390] = {.lex_state = 7, .external_lex_state = 4},
  [2391] = {.lex_state = 7, .external_lex_state = 3},
  [2392] = {.lex_state = 7, .external_lex_state = 3},
  [2393] = {.lex_state = 7, .external_lex_state = 3},
  [2394] = {.lex_state = 7, .external_lex_state = 3},
  [2395] = {.lex_state = 7, .external_lex_state = 3},
  [2396] = {.lex_state = 7, .external_lex_state = 3},
  [2397] = {.lex_state = 7, .external_lex_state = 3},
  [2398] = {.lex_state = 7, .external_lex_state = 3},
  [2399] = {.lex_state = 7, .external_lex_state = 3},
  [2400] = {.lex_state = 7, .external_lex_state = 3},
  [2401] = {.lex_state = 7, .external_lex_state = 3},
  [2402] = {.lex_state = 7, .external_lex_state = 3},
  [2403] = {.lex_state = 7, .external_lex_state = 3},
  [2404] = {.lex_state = 7, .external_lex_state = 3},
  [2405] = {.lex_state = 7, .external_lex_state = 3},
  [2406] = {.lex_state = 7, .external_lex_state = 3},
  [2407] = {.lex_state = 7, .external_lex_state = 3},
  [2408] = {.lex_state = 7, .external_lex_state = 3},
  [2409] = {.lex_state = 7, .external_lex_state = 3},
  [2410] = {.lex_state = 7, .external_lex_state = 3},
  [2411] = {.lex_state = 7, .external_lex_state = 3},
  [2412] = {.lex_state = 7, .external_lex_state = 3},
  [2413] = {.lex_state = 7, .external_lex_state = 3},
  [2414] = {.lex_state = 7, .external_lex_state = 3},
  [2415] = {.lex_state = 7, .external_lex_state = 3},
  [2416] = {.lex_state = 7, .external_lex_state = 3},
  [2417] = {.lex_state = 7, .external_lex_state = 4},
  [2418] = {.lex_state = 12, .external_lex_state = 5},
  [2419] = {.lex_state = 12, .external_lex_state = 2},
  [2420] = {.lex_state = 12, .external_lex_state = 5},
  [2421] = {.lex_state = 96, .external_lex_state = 2},
  [2422] = {.lex_state = 7, .external_lex_state = 3},
  [2423] = {.lex_state = 7, .external_lex_state = 3},
  [2424] = {.lex_state = 7, .external_lex_state = 4},
  [2425] = {.lex_state = 7, .external_lex_state = 4},
  [2426] = {.lex_state = 12, .external_lex_state = 5},
  [2427] = {.lex_state = 12, .external_lex_state = 5},
  [2428] = {.lex_state = 7, .external_lex_state = 3},
  [2429] = {.lex_state = 12, .external_lex_state = 5},
  [2430] = {.lex_state = 12, .external_lex_state = 2},
  [2431] = {.lex_state = 7, .external_lex_state = 4},
  [2432] = {.lex_state = 8, .external_lex_state = 3},
  [2433] = {.lex_state = 7, .external_lex_state = 4},
  [2434] = {.lex_state = 7, .external_lex_state = 4},
  [2435] = {.lex_state = 7, .external_lex_state = 3},
  [2436] = {.lex_state = 12, .external_lex_state = 2},
  [2437] = {.lex_state = 12, .external_lex_state = 5},
  [2438] = {.lex_state = 7, .external_lex_state = 3},
  [2439] = {.lex_state = 7, .external_lex_state = 3},
  [2440] = {.lex_state = 7, .external_lex_state = 3},
  [2441] = {.lex_state = 7, .external_lex_state = 3},
  [2442] = {.lex_state = 7, .external_lex_state = 4},
  [2443] = {.lex_state = 12, .external_lex_state = 5},
  [2444] = {.lex_state = 7, .external_lex_state = 3},
  [2445] = {.lex_state = 12, .external_lex_state = 2},
  [2446] = {.lex_state = 12, .external_lex_state = 5},
  [2447] = {.lex_state = 12, .external_lex_state = 5},
  [2448] = {.lex_state = 12, .external_lex_state = 5},
  [2449] = {.lex_state = 7, .external_lex_state = 3},
  [2450] = {.lex_state = 7, .external_lex_state = 3},
  [2451] = {.lex_state = 7, .external_lex_state = 3},
  [2452] = {.lex_state = 7, .external_lex_state = 3},
  [2453] = {.lex_state = 7, .external_lex_state = 3},
  [2454] = {.lex_state = 7, .external_lex_state = 3},
  [2455] = {.lex_state = 12, .external_lex_state = 5},
  [2456] = {.lex_state = 12, .external_lex_state = 2},
  [2457] = {.lex_state = 7, .external_lex_state = 4},
  [2458] = {.lex_state = 7, .external_lex_state = 3},
  [2459] = {.lex_state = 7, .external_lex_state = 3},
  [2460] = {.lex_state = 7, .external_lex_state = 3},
  [2461] = {.lex_state = 7, .external_lex_state = 3},
  [2462] = {.lex_state = 12, .external_lex_state = 5},
  [2463] = {.lex_state = 7, .external_lex_state = 3},
  [2464] = {.lex_state = 7, .external_lex_state = 3},
  [2465] = {.lex_state = 7, .external_lex_state = 3},
  [2466] = {.lex_state = 7, .external_lex_state = 3},
  [2467] = {.lex_state = 12, .external_lex_state = 5},
  [2468] = {.lex_state = 7, .external_lex_state = 4},
  [2469] = {.lex_state = 96, .external_lex_state = 2},
  [2470] = {.lex_state = 7, .external_lex_state = 4},
  [2471] = {.lex_state = 12, .external_lex_state = 2},
  [2472] = {.lex_state = 7, .external_lex_state = 3},
  [2473] = {.lex_state = 12, .external_lex_state = 5},
  [2474] = {.lex_state = 12, .external_lex_state = 5},
  [2475] = {.lex_state = 7, .external_lex_state = 3},
  [2476] = {.lex_state = 12, .external_lex_state = 5},
  [2477] = {.lex_state = 12, .external_lex_state = 2},
  [2478] = {.lex_state = 12, .external_lex_state = 5},
  [2479] = {.lex_state = 12, .external_lex_state = 5},
  [2480] = {.lex_state = 7, .external_lex_state = 3},
  [2481] = {.lex_state = 12, .external_lex_state = 5},
  [2482] = {.lex_state = 7, .external_lex_state = 3},
  [2483] = {.lex_state = 12, .external_lex_state = 2},
  [2484] = {.lex_state = 12, .external_lex_state = 5},
  [2485] = {.lex_state = 12, .external_lex_state = 5},
  [2486] = {.lex_state = 7, .external_lex_state = 3},
  [2487] = {.lex_state = 7, .external_lex_state = 3},
  [2488] = {.lex_state = 12, .external_lex_state = 5},
  [2489] = {.lex_state = 7, .external_lex_state = 3},
  [2490] = {.lex_state = 7, .external_lex_state = 3},
  [2491] = {.lex_state = 7, .external_lex_state = 3},
  [2492] = {.lex_state = 7, .external_lex_state = 3},
  [2493] = {.lex_state = 7, .external_lex_state = 3},
  [2494] = {.lex_state = 7, .external_lex_state = 3},
  [2495] = {.lex_state = 7, .external_lex_state = 3},
  [2496] = {.lex_state = 7, .external_lex_state = 3},
  [2497] = {.lex_state = 7, .external_lex_state = 3},
  [2498] = {.lex_state = 7, .external_lex_state = 3},
  [2499] = {.lex_state = 7, .external_lex_state = 3},
  [2500] = {.lex_state = 7, .external_lex_state = 3},
  [2501] = {.lex_state = 7, .external_lex_state = 3},
  [2502] = {.lex_state = 7, .external_lex_state = 3},
  [2503] = {.lex_state = 7, .external_lex_state = 3},
  [2504] = {.lex_state = 7, .external_lex_state = 3},
  [2505] = {.lex_state = 7, .external_lex_state = 3},
  [2506] = {.lex_state = 7, .external_lex_state = 3},
  [2507] = {.lex_state = 7, .external_lex_state = 3},
  [2508] = {.lex_state = 7, .external_lex_state = 3},
  [2509] = {.lex_state = 7, .external_lex_state = 3},
  [2510] = {.lex_state = 7, .external_lex_state = 3},
  [2511] = {.lex_state = 7, .external_lex_state = 3},
  [2512] = {.lex_state = 7, .external_lex_state = 3},
  [2513] = {.lex_state = 7, .external_lex_state = 3},
  [2514] = {.lex_state = 7, .external_lex_state = 3},
  [2515] = {.lex_state = 7, .external_lex_state = 3},
  [2516] = {.lex_state = 7, .external_lex_state = 4},
  [2517] = {.lex_state = 7, .external_lex_state = 3},
  [2518] = {.lex_state = 7, .external_lex_state = 3},
  [2519] = {.lex_state = 7, .external_lex_state = 3},
  [2520] = {.lex_state = 7, .external_lex_state = 3},
  [2521] = {.lex_state = 7, .external_lex_state = 3},
  [2522] = {.lex_state = 12, .external_lex_state = 5},
  [2523] = {.lex_state = 12, .external_lex_state = 5},
  [2524] = {.lex_state = 7, .external_lex_state = 3},
  [2525] = {.lex_state = 7, .external_lex_state = 3},
  [2526] = {.lex_state = 7, .external_lex_state = 3},
  [2527] = {.lex_state = 7, .external_lex_state = 3},
  [2528] = {.lex_state = 7, .external_lex_state = 3},
  [2529] = {.lex_state = 7, .external_lex_state = 3},
  [2530] = {.lex_state = 96, .external_lex_state = 5},
  [2531] = {.lex_state = 96, .external_lex_state = 5},
  [2532] = {.lex_state = 96, .external_lex_state = 5},
  [2533] = {.lex_state = 12, .external_lex_state = 5},
  [2534] = {.lex_state = 7, .external_lex_state = 3},
  [2535] = {.lex_state = 12, .external_lex_state = 5},
  [2536] = {.lex_state = 12, .external_lex_state = 2},
  [2537] = {.lex_state = 12, .external_lex_state = 2},
  [2538] = {.lex_state = 7, .external_lex_state = 3},
  [2539] = {.lex_state = 7, .external_lex_state = 3},
  [2540] = {.lex_state = 7, .external_lex_state = 3},
  [2541] = {.lex_state = 7, .external_lex_state = 3},
  [2542] = {.lex_state = 7, .external_lex_state = 3},
  [2543] = {.lex_state = 7, .external_lex_state = 3},
  [2544] = {.lex_state = 7, .external_lex_state = 3},
  [2545] = {.lex_state = 7, .external_lex_state = 3},
  [2546] = {.lex_state = 7, .external_lex_state = 3},
  [2547] = {.lex_state = 7, .external_lex_state = 3},
  [2548] = {.lex_state = 96, .external_lex_state = 5},
  [2549] = {.lex_state = 96, .external_lex_state = 5},
  [2550] = {.lex_state = 7, .external_lex_state = 3},
  [2551] = {.lex_state = 96, .external_lex_state = 5},
  [2552] = {.lex_state = 96, .external_lex_state = 5},
  [2553] = {.lex_state = 7, .external_lex_state = 3},
  [2554] = {.lex_state = 7, .external_lex_state = 3},
  [2555] = {.lex_state = 7, .external_lex_state = 3},
  [2556] = {.lex_state = 7, .external_lex_state = 3},
  [2557] = {.lex_state = 7, .external_lex_state = 3},
  [2558] = {.lex_state = 7, .external_lex_state = 3},
  [2559] = {.lex_state = 12, .external_lex_state = 2},
  [2560] = {.lex_state = 7, .external_lex_state = 3},
  [2561] = {.lex_state = 7, .external_lex_state = 3},
  [2562] = {.lex_state = 12, .external_lex_state = 2},
  [2563] = {.lex_state = 7, .external_lex_state = 3},
  [2564] = {.lex_state = 7, .external_lex_state = 3},
  [2565] = {.lex_state = 7, .external_lex_state = 3},
  [2566] = {.lex_state = 7, .external_lex_state = 3},
  [2567] = {.lex_state = 7, .external_lex_state = 3},
  [2568] = {.lex_state = 7, .external_lex_state = 3},
  [2569] = {.lex_state = 7, .external_lex_state = 3},
  [2570] = {.lex_state = 7, .external_lex_state = 3},
  [2571] = {.lex_state = 7, .external_lex_state = 3},
  [2572] = {.lex_state = 7, .external_lex_state = 3},
  [2573] = {.lex_state = 96, .external_lex_state = 5},
  [2574] = {.lex_state = 7, .external_lex_state = 3},
  [2575] = {.lex_state = 7, .external_lex_state = 3},
  [2576] = {.lex_state = 7, .external_lex_state = 3},
  [2577] = {.lex_state = 7, .external_lex_state = 3},
  [2578] = {.lex_state = 7, .external_lex_state = 3},
  [2579] = {.lex_state = 7, .external_lex_state = 3},
  [2580] = {.lex_state = 7, .external_lex_state = 3},
  [2581] = {.lex_state = 7, .external_lex_state = 3},
  [2582] = {.lex_state = 7, .external_lex_state = 4},
  [2583] = {.lex_state = 7, .external_lex_state = 3},
  [2584] = {.lex_state = 7, .external_lex_state = 3},
  [2585] = {.lex_state = 7, .external_lex_state = 3},
  [2586] = {.lex_state = 7, .external_lex_state = 3},
  [2587] = {.lex_state = 7, .external_lex_state = 3},
  [2588] = {.lex_state = 7, .external_lex_state = 3},
  [2589] = {.lex_state = 7, .external_lex_state = 3},
  [2590] = {.lex_state = 96, .external_lex_state = 5},
  [2591] = {.lex_state = 7, .external_lex_state = 3},
  [2592] = {.lex_state = 96, .external_lex_state = 2},
  [2593] = {.lex_state = 7, .external_lex_state = 3},
  [2594] = {.lex_state = 7, .external_lex_state = 3},
  [2595] = {.lex_state = 7, .external_lex_state = 3},
  [2596] = {.lex_state = 7, .external_lex_state = 3},
  [2597] = {.lex_state = 7, .external_lex_state = 3},
  [2598] = {.lex_state = 7, .external_lex_state = 3},
  [2599] = {.lex_state = 7, .external_lex_state = 3},
  [2600] = {.lex_state = 7, .external_lex_state = 3},
  [2601] = {.lex_state = 12, .external_lex_state = 2},
  [2602] = {.lex_state = 96, .external_lex_state = 2},
  [2603] = {.lex_state = 7, .external_lex_state = 3},
  [2604] = {.lex_state = 96, .external_lex_state = 2},
  [2605] = {.lex_state = 7, .external_lex_state = 3},
  [2606] = {.lex_state = 7, .external_lex_state = 3},
  [2607] = {.lex_state = 7, .external_lex_state = 3},
  [2608] = {.lex_state = 7, .external_lex_state = 3},
  [2609] = {.lex_state = 7, .external_lex_state = 3},
  [2610] = {.lex_state = 7, .external_lex_state = 3},
  [2611] = {.lex_state = 96, .external_lex_state = 5},
  [2612] = {.lex_state = 7, .external_lex_state = 3},
  [2613] = {.lex_state = 96, .external_lex_state = 5},
  [2614] = {.lex_state = 96, .external_lex_state = 5},
  [2615] = {.lex_state = 7, .external_lex_state = 3},
  [2616] = {.lex_state = 12, .external_lex_state = 2},
  [2617] = {.lex_state = 96, .external_lex_state = 5},
  [2618] = {.lex_state = 12, .external_lex_state = 2},
  [2619] = {.lex_state = 12, .external_lex_state = 2},
  [2620] = {.lex_state = 12, .external_lex_state = 2},
  [2621] = {.lex_state = 12, .external_lex_state = 2},
  [2622] = {.lex_state = 12, .external_lex_state = 2},
  [2623] = {.lex_state = 96, .external_lex_state = 5},
  [2624] = {.lex_state = 96, .external_lex_state = 5},
  [2625] = {.lex_state = 7, .external_lex_state = 3},
  [2626] = {.lex_state = 12, .external_lex_state = 2},
  [2627] = {.lex_state = 96, .external_lex_state = 5},
  [2628] = {.lex_state = 12, .external_lex_state = 2},
  [2629] = {.lex_state = 96, .external_lex_state = 5},
  [2630] = {.lex_state = 12, .external_lex_state = 2},
  [2631] = {.lex_state = 8, .external_lex_state = 3},
  [2632] = {.lex_state = 96, .external_lex_state = 5},
  [2633] = {.lex_state = 96, .external_lex_state = 5},
  [2634] = {.lex_state = 12, .external_lex_state = 2},
  [2635] = {.lex_state = 12, .external_lex_state = 2},
  [2636] = {.lex_state = 96, .external_lex_state = 5},
  [2637] = {.lex_state = 96, .external_lex_state = 5},
  [2638] = {.lex_state = 7, .external_lex_state = 3},
  [2639] = {.lex_state = 96, .external_lex_state = 5},
  [2640] = {.lex_state = 12, .external_lex_state = 2},
  [2641] = {.lex_state = 12, .external_lex_state = 2},
  [2642] = {.lex_state = 12, .external_lex_state = 2},
  [2643] = {.lex_state = 96, .external_lex_state = 5},
  [2644] = {.lex_state = 96, .external_lex_state = 5},
  [2645] = {.lex_state = 96, .external_lex_state = 5},
  [2646] = {.lex_state = 7, .external_lex_state = 3},
  [2647] = {.lex_state = 96, .external_lex_state = 5},
  [2648] = {.lex_state = 7, .external_lex_state = 3},
  [2649] = {.lex_state = 7, .external_lex_state = 3},
  [2650] = {.lex_state = 12, .external_lex_state = 2},
  [2651] = {.lex_state = 12, .external_lex_state = 2},
  [2652] = {.lex_state = 12, .external_lex_state = 5},
  [2653] = {.lex_state = 12, .external_lex_state = 5},
  [2654] = {.lex_state = 7, .external_lex_state = 3},
  [2655] = {.lex_state = 12, .external_lex_state = 5},
  [2656] = {.lex_state = 12, .external_lex_state = 5},
  [2657] = {.lex_state = 12, .external_lex_state = 5},
  [2658] = {.lex_state = 12, .external_lex_state = 5},
  [2659] = {.lex_state = 12, .external_lex_state = 5},
  [2660] = {.lex_state = 7, .external_lex_state = 3},
  [2661] = {.lex_state = 12, .external_lex_state = 5},
  [2662] = {.lex_state = 12, .external_lex_state = 5},
  [2663] = {.lex_state = 12, .external_lex_state = 2},
  [2664] = {.lex_state = 12, .external_lex_state = 5},
  [2665] = {.lex_state = 7, .external_lex_state = 3},
  [2666] = {.lex_state = 7, .external_lex_state = 3},
  [2667] = {.lex_state = 7, .external_lex_state = 3},
  [2668] = {.lex_state = 12, .external_lex_state = 5},
  [2669] = {.lex_state = 12, .external_lex_state = 5},
  [2670] = {.lex_state = 12, .external_lex_state = 5},
  [2671] = {.lex_state = 12, .external_lex_state = 5},
  [2672] = {.lex_state = 12, .external_lex_state = 5},
  [2673] = {.lex_state = 12, .external_lex_state = 5},
  [2674] = {.lex_state = 12, .external_lex_state = 5},
  [2675] = {.lex_state = 12, .external_lex_state = 5},
  [2676] = {.lex_state = 12, .external_lex_state = 5},
  [2677] = {.lex_state = 12, .external_lex_state = 5},
  [2678] = {.lex_state = 12, .external_lex_state = 5},
  [2679] = {.lex_state = 7, .external_lex_state = 3},
  [2680] = {.lex_state = 12, .external_lex_state = 5},
  [2681] = {.lex_state = 12, .external_lex_state = 5},
  [2682] = {.lex_state = 12, .external_lex_state = 5},
  [2683] = {.lex_state = 12, .external_lex_state = 5},
  [2684] = {.lex_state = 12, .external_lex_state = 5},
  [2685] = {.lex_state = 12, .external_lex_state = 5},
  [2686] = {.lex_state = 7, .external_lex_state = 3},
  [2687] = {.lex_state = 12, .external_lex_state = 5},
  [2688] = {.lex_state = 12, .external_lex_state = 5},
  [2689] = {.lex_state = 12, .external_lex_state = 5},
  [2690] = {.lex_state = 12, .external_lex_state = 2},
  [2691] = {.lex_state = 12, .external_lex_state = 5},
  [2692] = {.lex_state = 12, .external_lex_state = 5},
  [2693] = {.lex_state = 12, .external_lex_state = 5},
  [2694] = {.lex_state = 12, .external_lex_state = 5},
  [2695] = {.lex_state = 12, .external_lex_state = 5},
  [2696] = {.lex_state = 12, .external_lex_state = 5},
  [2697] = {.lex_state = 12, .external_lex_state = 5},
  [2698] = {.lex_state = 12, .external_lex_state = 5},
  [2699] = {.lex_state = 12, .external_lex_state = 5},
  [2700] = {.lex_state = 7, .external_lex_state = 3},
  [2701] = {.lex_state = 12, .external_lex_state = 5},
  [2702] = {.lex_state = 12, .external_lex_state = 5},
  [2703] = {.lex_state = 12, .external_lex_state = 5},
  [2704] = {.lex_state = 12, .external_lex_state = 5},
  [2705] = {.lex_state = 12, .external_lex_state = 5},
  [2706] = {.lex_state = 7, .external_lex_state = 3},
  [2707] = {.lex_state = 12, .external_lex_state = 5},
  [2708] = {.lex_state = 12, .external_lex_state = 2},
  [2709] = {.lex_state = 12, .external_lex_state = 5},
  [2710] = {.lex_state = 12, .external_lex_state = 5},
  [2711] = {.lex_state = 12, .external_lex_state = 5},
  [2712] = {.lex_state = 12, .external_lex_state = 5},
  [2713] = {.lex_state = 7, .external_lex_state = 3},
  [2714] = {.lex_state = 7, .external_lex_state = 3},
  [2715] = {.lex_state = 12, .external_lex_state = 5},
  [2716] = {.lex_state = 12, .external_lex_state = 5},
  [2717] = {.lex_state = 12, .external_lex_state = 5},
  [2718] = {.lex_state = 12, .external_lex_state = 2},
  [2719] = {.lex_state = 12, .external_lex_state = 2},
  [2720] = {.lex_state = 7, .external_lex_state = 3},
  [2721] = {.lex_state = 12, .external_lex_state = 2},
  [2722] = {.lex_state = 12, .external_lex_state = 2},
  [2723] = {.lex_state = 12, .external_lex_state = 2},
  [2724] = {.lex_state = 12, .external_lex_state = 2},
  [2725] = {.lex_state = 12, .external_lex_state = 2},
  [2726] = {.lex_state = 12, .external_lex_state = 2},
  [2727] = {.lex_state = 12, .external_lex_state = 2},
  [2728] = {.lex_state = 12, .external_lex_state = 2},
  [2729] = {.lex_state = 12, .external_lex_state = 2},
  [2730] = {.lex_state = 12, .external_lex_state = 2},
  [2731] = {.lex_state = 12, .external_lex_state = 2},
  [2732] = {.lex_state = 96, .external_lex_state = 2},
  [2733] = {.lex_state = 12, .external_lex_state = 2},
  [2734] = {.lex_state = 12, .external_lex_state = 2},
  [2735] = {.lex_state = 12, .external_lex_state = 2},
  [2736] = {.lex_state = 12, .external_lex_state = 2},
  [2737] = {.lex_state = 12, .external_lex_state = 2},
  [2738] = {.lex_state = 12, .external_lex_state = 2},
  [2739] = {.lex_state = 12, .external_lex_state = 2},
  [2740] = {.lex_state = 12, .external_lex_state = 2},
  [2741] = {.lex_state = 12, .external_lex_state = 2},
  [2742] = {.lex_state = 96, .external_lex_state = 2},
  [2743] = {.lex_state = 12, .external_lex_state = 2},
  [2744] = {.lex_state = 12, .external_lex_state = 2},
  [2745] = {.lex_state = 12, .external_lex_state = 2},
  [2746] = {.lex_state = 96, .external_lex_state = 2},
  [2747] = {.lex_state = 12, .external_lex_state = 2},
  [2748] = {.lex_state = 96, .external_lex_state = 2},
  [2749] = {.lex_state = 12, .external_lex_state = 2},
  [2750] = {.lex_state = 12, .external_lex_state = 2},
  [2751] = {.lex_state = 12, .external_lex_state = 2},
  [2752] = {.lex_state = 12, .external_lex_state = 2},
  [2753] = {.lex_state = 12, .external_lex_state = 2},
  [2754] = {.lex_state = 12, .external_lex_state = 2},
  [2755] = {.lex_state = 12, .external_lex_state = 2},
  [2756] = {.lex_state = 12, .external_lex_state = 2},
  [2757] = {.lex_state = 12, .external_lex_state = 2},
  [2758] = {.lex_state = 12, .external_lex_state = 2},
  [2759] = {.lex_state = 12, .external_lex_state = 2},
  [2760] = {.lex_state = 12, .external_lex_state = 2},
  [2761] = {.lex_state = 96, .external_lex_state = 2},
  [2762] = {.lex_state = 12, .external_lex_state = 2},
  [2763] = {.lex_state = 12, .external_lex_state = 2},
  [2764] = {.lex_state = 12, .external_lex_state = 2},
  [2765] = {.lex_state = 12, .external_lex_state = 2},
  [2766] = {.lex_state = 12, .external_lex_state = 2},
  [2767] = {.lex_state = 12, .external_lex_state = 2},
  [2768] = {.lex_state = 12, .external_lex_state = 2},
  [2769] = {.lex_state = 12, .external_lex_state = 2},
  [2770] = {.lex_state = 12, .external_lex_state = 2},
  [2771] = {.lex_state = 12, .external_lex_state = 2},
  [2772] = {.lex_state = 12, .external_lex_state = 2},
  [2773] = {.lex_state = 96, .external_lex_state = 2},
  [2774] = {.lex_state = 96, .external_lex_state = 2},
  [2775] = {.lex_state = 96, .external_lex_state = 2},
  [2776] = {.lex_state = 96, .external_lex_state = 2},
  [2777] = {.lex_state = 96, .external_lex_state = 2},
  [2778] = {.lex_state = 96, .external_lex_state = 2},
  [2779] = {.lex_state = 96, .external_lex_state = 2},
  [2780] = {.lex_state = 96, .external_lex_state = 2},
  [2781] = {.lex_state = 96, .external_lex_state = 2},
  [2782] = {.lex_state = 96, .external_lex_state = 2},
  [2783] = {.lex_state = 96, .external_lex_state = 2},
  [2784] = {.lex_state = 96, .external_lex_state = 2},
  [2785] = {.lex_state = 96, .external_lex_state = 2},
  [2786] = {.lex_state = 96, .external_lex_state = 2},
  [2787] = {.lex_state = 96, .external_lex_state = 2},
  [2788] = {.lex_state = 96, .external_lex_state = 2},
  [2789] = {.lex_state = 96, .external_lex_state = 2},
  [2790] = {.lex_state = 96, .external_lex_state = 2},
  [2791] = {.lex_state = 96, .external_lex_state = 2},
  [2792] = {.lex_state = 96, .external_lex_state = 2},
  [2793] = {.lex_state = 96, .external_lex_state = 2},
  [2794] = {.lex_state = 96, .external_lex_state = 2},
  [2795] = {.lex_state = 96, .external_lex_state = 2},
  [2796] = {.lex_state = 96, .external_lex_state = 2},
  [2797] = {.lex_state = 96, .external_lex_state = 2},
  [2798] = {.lex_state = 96, .external_lex_state = 2},
  [2799] = {.lex_state = 96, .external_lex_state = 2},
  [2800] = {.lex_state = 96, .external_lex_state = 2},
  [2801] = {.lex_state = 96, .external_lex_state = 2},
  [2802] = {.lex_state = 96, .external_lex_state = 2},
  [2803] = {.lex_state = 12, .external_lex_state = 2},
  [2804] = {.lex_state = 96, .external_lex_state = 2},
  [2805] = {.lex_state = 96, .external_lex_state = 2},
  [2806] = {.lex_state = 96, .external_lex_state = 2},
  [2807] = {.lex_state = 96, .external_lex_state = 2},
  [2808] = {.lex_state = 96, .external_lex_state = 2},
  [2809] = {.lex_state = 96, .external_lex_state = 2},
  [2810] = {.lex_state = 96, .external_lex_state = 2},
  [2811] = {.lex_state = 96, .external_lex_state = 2},
  [2812] = {.lex_state = 96, .external_lex_state = 2},
  [2813] = {.lex_state = 96, .external_lex_state = 2},
  [2814] = {.lex_state = 96, .external_lex_state = 2},
  [2815] = {.lex_state = 96, .external_lex_state = 2},
  [2816] = {.lex_state = 96, .external_lex_state = 2},
  [2817] = {.lex_state = 96, .external_lex_state = 2},
  [2818] = {.lex_state = 96, .external_lex_state = 2},
  [2819] = {.lex_state = 96, .external_lex_state = 2},
  [2820] = {.lex_state = 96, .external_lex_state = 2},
  [2821] = {.lex_state = 96, .external_lex_state = 2},
  [2822] = {.lex_state = 96, .external_lex_state = 2},
  [2823] = {.lex_state = 96, .external_lex_state = 2},
  [2824] = {.lex_state = 96, .external_lex_state = 2},
  [2825] = {.lex_state = 96, .external_lex_state = 2},
  [2826] = {.lex_state = 96, .external_lex_state = 2},
  [2827] = {.lex_state = 96, .external_lex_state = 2},
  [2828] = {.lex_state = 96, .external_lex_state = 2},
  [2829] = {.lex_state = 96, .external_lex_state = 2},
  [2830] = {.lex_state = 96, .external_lex_state = 2},
  [2831] = {.lex_state = 96, .external_lex_state = 2},
  [2832] = {.lex_state = 96, .external_lex_state = 2},
  [2833] = {.lex_state = 96, .external_lex_state = 2},
  [2834] = {.lex_state = 96, .external_lex_state = 2},
  [2835] = {.lex_state = 96, .external_lex_state = 2},
  [2836] = {.lex_state = 96, .external_lex_state = 2},
  [2837] = {.lex_state = 96, .external_lex_state = 2},
  [2838] = {.lex_state = 96, .external_lex_state = 2},
  [2839] = {.lex_state = 96, .external_lex_state = 2},
  [2840] = {.lex_state = 96, .external_lex_state = 2},
  [2841] = {.lex_state = 96, .external_lex_state = 2},
  [2842] = {.lex_state = 96, .external_lex_state = 2},
  [2843] = {.lex_state = 96, .external_lex_state = 2},
  [2844] = {.lex_state = 96, .external_lex_state = 2},
  [2845] = {.lex_state = 96, .external_lex_state = 2},
  [2846] = {.lex_state = 96, .external_lex_state = 2},
  [2847] = {.lex_state = 96, .external_lex_state = 2},
  [2848] = {.lex_state = 96, .external_lex_state = 2},
  [2849] = {.lex_state = 96, .external_lex_state = 2},
  [2850] = {.lex_state = 96, .external_lex_state = 2},
  [2851] = {.lex_state = 96, .external_lex_state = 2},
  [2852] = {.lex_state = 96, .external_lex_state = 2},
  [2853] = {.lex_state = 96, .external_lex_state = 2},
  [2854] = {.lex_state = 96, .external_lex_state = 2},
  [2855] = {.lex_state = 96, .external_lex_state = 2},
  [2856] = {.lex_state = 96, .external_lex_state = 2},
  [2857] = {.lex_state = 96, .external_lex_state = 2},
  [2858] = {.lex_state = 96, .external_lex_state = 2},
  [2859] = {.lex_state = 96, .external_lex_state = 2},
  [2860] = {.lex_state = 96, .external_lex_state = 2},
  [2861] = {.lex_state = 96, .external_lex_state = 2},
  [2862] = {.lex_state = 96, .external_lex_state = 2},
  [2863] = {.lex_state = 96, .external_lex_state = 2},
  [2864] = {.lex_state = 96, .external_lex_state = 2},
  [2865] = {.lex_state = 96, .external_lex_state = 2},
  [2866] = {.lex_state = 96, .external_lex_state = 2},
  [2867] = {.lex_state = 96, .external_lex_state = 2},
  [2868] = {.lex_state = 96, .external_lex_state = 2},
  [2869] = {.lex_state = 96, .external_lex_state = 2},
  [2870] = {.lex_state = 96, .external_lex_state = 2},
  [2871] = {.lex_state = 96, .external_lex_state = 2},
  [2872] = {.lex_state = 96, .external_lex_state = 2},
  [2873] = {.lex_state = 96, .external_lex_state = 2},
  [2874] = {.lex_state = 96, .external_lex_state = 2},
  [2875] = {.lex_state = 96, .external_lex_state = 2},
  [2876] = {.lex_state = 96, .external_lex_state = 2},
  [2877] = {.lex_state = 96, .external_lex_state = 2},
  [2878] = {.lex_state = 96, .external_lex_state = 2},
  [2879] = {.lex_state = 96, .external_lex_state = 2},
  [2880] = {.lex_state = 15, .external_lex_state = 2},
  [2881] = {.lex_state = 15, .external_lex_state = 2},
  [2882] = {.lex_state = 15, .external_lex_state = 2},
  [2883] = {.lex_state = 15, .external_lex_state = 2},
  [2884] = {.lex_state = 15, .external_lex_state = 2},
  [2885] = {.lex_state = 15, .external_lex_state = 2},
  [2886] = {.lex_state = 15, .external_lex_state = 2},
  [2887] = {.lex_state = 15, .external_lex_state = 2},
  [2888] = {.lex_state = 15, .external_lex_state = 2},
  [2889] = {.lex_state = 15, .external_lex_state = 2},
  [2890] = {.lex_state = 15, .external_lex_state = 2},
  [2891] = {.lex_state = 15, .external_lex_state = 2},
  [2892] = {.lex_state = 15, .external_lex_state = 2},
  [2893] = {.lex_state = 15, .external_lex_state = 2},
  [2894] = {.lex_state = 15, .external_lex_state = 2},
  [2895] = {.lex_state = 15, .external_lex_state = 2},
  [2896] = {.lex_state = 15, .external_lex_state = 2},
  [2897] = {.lex_state = 15, .external_lex_state = 2},
  [2898] = {.lex_state = 15, .external_lex_state = 2},
  [2899] = {.lex_state = 15, .external_lex_state = 2},
  [2900] = {.lex_state = 15, .external_lex_state = 2},
  [2901] = {.lex_state = 15, .external_lex_state = 2},
  [2902] = {.lex_state = 15, .external_lex_state = 2},
  [2903] = {.lex_state = 15, .external_lex_state = 2},
  [2904] = {.lex_state = 15, .external_lex_state = 2},
  [2905] = {.lex_state = 15, .external_lex_state = 2},
  [2906] = {.lex_state = 15, .external_lex_state = 2},
  [2907] = {.lex_state = 15, .external_lex_state = 2},
  [2908] = {.lex_state = 15, .external_lex_state = 2},
  [2909] = {.lex_state = 15, .external_lex_state = 2},
  [2910] = {.lex_state = 15, .external_lex_state = 2},
  [2911] = {.lex_state = 15, .external_lex_state = 2},
  [2912] = {.lex_state = 15, .external_lex_state = 2},
  [2913] = {.lex_state = 15, .external_lex_state = 2},
  [2914] = {.lex_state = 15, .external_lex_state = 2},
  [2915] = {.lex_state = 15, .external_lex_state = 2},
  [2916] = {.lex_state = 15, .external_lex_state = 2},
  [2917] = {.lex_state = 13, .external_lex_state = 5},
  [2918] = {.lex_state = 13, .external_lex_state = 5},
  [2919] = {.lex_state = 14, .external_lex_state = 2},
  [2920] = {.lex_state = 13, .external_lex_state = 2},
  [2921] = {.lex_state = 96, .external_lex_state = 2},
  [2922] = {.lex_state = 14, .external_lex_state = 2},
  [2923] = {.lex_state = 96, .external_lex_state = 2},
  [2924] = {.lex_state = 14, .external_lex_state = 2},
  [2925] = {.lex_state = 96, .external_lex_state = 2},
  [2926] = {.lex_state = 15, .external_lex_state = 5},
  [2927] = {.lex_state = 14, .external_lex_state = 2},
  [2928] = {.lex_state = 15, .external_lex_state = 2},
  [2929] = {.lex_state = 96, .external_lex_state = 2},
  [2930] = {.lex_state = 13, .external_lex_state = 2},
  [2931] = {.lex_state = 15, .external_lex_state = 5},
  [2932] = {.lex_state = 13, .external_lex_state = 2},
  [2933] = {.lex_state = 96, .external_lex_state = 2},
  [2934] = {.lex_state = 13, .external_lex_state = 2},
  [2935] = {.lex_state = 14, .external_lex_state = 2},
  [2936] = {.lex_state = 96, .external_lex_state = 2},
  [2937] = {.lex_state = 15, .external_lex_state = 5},
  [2938] = {.lex_state = 96, .external_lex_state = 2},
  [2939] = {.lex_state = 96, .external_lex_state = 2},
  [2940] = {.lex_state = 96, .external_lex_state = 2},
  [2941] = {.lex_state = 13, .external_lex_state = 2},
  [2942] = {.lex_state = 96, .external_lex_state = 2},
  [2943] = {.lex_state = 96, .external_lex_state = 2},
  [2944] = {.lex_state = 96, .external_lex_state = 2},
  [2945] = {.lex_state = 96, .external_lex_state = 2},
  [2946] = {.lex_state = 15, .external_lex_state = 5},
  [2947] = {.lex_state = 15, .external_lex_state = 5},
  [2948] = {.lex_state = 96, .external_lex_state = 2},
  [2949] = {.lex_state = 96, .external_lex_state = 2},
  [2950] = {.lex_state = 96, .external_lex_state = 2},
  [2951] = {.lex_state = 96, .external_lex_state = 2},
  [2952] = {.lex_state = 96, .external_lex_state = 2},
  [2953] = {.lex_state = 96, .external_lex_state = 2},
  [2954] = {.lex_state = 96, .external_lex_state = 2},
  [2955] = {.lex_state = 15, .external_lex_state = 6},
  [2956] = {.lex_state = 15, .external_lex_state = 6},
  [2957] = {.lex_state = 15, .external_lex_state = 6},
  [2958] = {.lex_state = 4, .external_lex_state = 2},
  [2959] = {.lex_state = 96, .external_lex_state = 2},
  [2960] = {.lex_state = 96, .external_lex_state = 2},
  [2961] = {.lex_state = 96, .external_lex_state = 2},
  [2962] = {.lex_state = 96, .external_lex_state = 2},
  [2963] = {.lex_state = 15, .external_lex_state = 5},
  [2964] = {.lex_state = 96, .external_lex_state = 2},
  [2965] = {.lex_state = 15, .external_lex_state = 5},
  [2966] = {.lex_state = 96, .external_lex_state = 2},
  [2967] = {.lex_state = 15, .external_lex_state = 5},
  [2968] = {.lex_state = 15, .external_lex_state = 5},
  [2969] = {.lex_state = 4, .external_lex_state = 2},
  [2970] = {.lex_state = 15, .external_lex_state = 5},
  [2971] = {.lex_state = 15, .external_lex_state = 5},
  [2972] = {.lex_state = 15, .external_lex_state = 5},
  [2973] = {.lex_state = 15, .external_lex_state = 5},
  [2974] = {.lex_state = 96, .external_lex_state = 2},
  [2975] = {.lex_state = 15, .external_lex_state = 5},
  [2976] = {.lex_state = 15, .external_lex_state = 5},
  [2977] = {.lex_state = 96, .external_lex_state = 2},
  [2978] = {.lex_state = 96, .external_lex_state = 2},
  [2979] = {.lex_state = 96, .external_lex_state = 2},
  [2980] = {.lex_state = 96, .external_lex_state = 2},
  [2981] = {.lex_state = 15, .external_lex_state = 5},
  [2982] = {.lex_state = 15, .external_lex_state = 5},
  [2983] = {.lex_state = 15, .external_lex_state = 5},
  [2984] = {.lex_state = 4, .external_lex_state = 2},
  [2985] = {.lex_state = 96, .external_lex_state = 2},
  [2986] = {.lex_state = 15, .external_lex_state = 5},
  [2987] = {.lex_state = 96, .external_lex_state = 2},
  [2988] = {.lex_state = 96, .external_lex_state = 2},
  [2989] = {.lex_state = 96, .external_lex_state = 2},
  [2990] = {.lex_state = 96, .external_lex_state = 2},
  [2991] = {.lex_state = 96, .external_lex_state = 2},
  [2992] = {.lex_state = 96, .external_lex_state = 2},
  [2993] = {.lex_state = 96, .external_lex_state = 2},
  [2994] = {.lex_state = 96, .external_lex_state = 2},
  [2995] = {.lex_state = 96, .external_lex_state = 2},
  [2996] = {.lex_state = 96, .external_lex_state = 2},
  [2997] = {.lex_state = 96, .external_lex_state = 2},
  [2998] = {.lex_state = 96, .external_lex_state = 2},
  [2999] = {.lex_state = 96, .external_lex_state = 2},
  [3000] = {.lex_state = 96, .external_lex_state = 2},
  [3001] = {.lex_state = 4, .external_lex_state = 2},
  [3002] = {.lex_state = 96, .external_lex_state = 2},
  [3003] = {.lex_state = 96, .external_lex_state = 2},
  [3004] = {.lex_state = 96, .external_lex_state = 2},
  [3005] = {.lex_state = 96, .external_lex_state = 2},
  [3006] = {.lex_state = 4, .external_lex_state = 2},
  [3007] = {.lex_state = 15, .external_lex_state = 5},
  [3008] = {.lex_state = 15, .external_lex_state = 5},
  [3009] = {.lex_state = 15, .external_lex_state = 5},
  [3010] = {.lex_state = 4, .external_lex_state = 2},
  [3011] = {.lex_state = 15, .external_lex_state = 5},
  [3012] = {.lex_state = 4, .external_lex_state = 2},
  [3013] = {.lex_state = 96, .external_lex_state = 2},
  [3014] = {.lex_state = 96, .external_lex_state = 2},
  [3015] = {.lex_state = 96, .external_lex_state = 2},
  [3016] = {.lex_state = 96, .external_lex_state = 2},
  [3017] = {.lex_state = 96, .external_lex_state = 2},
  [3018] = {.lex_state = 96, .external_lex_state = 2},
  [3019] = {.lex_state = 15, .external_lex_state = 5},
  [3020] = {.lex_state = 96, .external_lex_state = 2},
  [3021] = {.lex_state = 15, .external_lex_state = 5},
  [3022] = {.lex_state = 15, .external_lex_state = 5},
  [3023] = {.lex_state = 15, .external_lex_state = 5},
  [3024] = {.lex_state = 15, .external_lex_state = 5},
  [3025] = {.lex_state = 96, .external_lex_state = 2},
  [3026] = {.lex_state = 15, .external_lex_state = 5},
  [3027] = {.lex_state = 13, .external_lex_state = 5},
  [3028] = {.lex_state = 15, .external_lex_state = 5},
  [3029] = {.lex_state = 96, .external_lex_state = 2},
  [3030] = {.lex_state = 96, .external_lex_state = 2},
  [3031] = {.lex_state = 96, .external_lex_state = 2},
  [3032] = {.lex_state = 96, .external_lex_state = 2},
  [3033] = {.lex_state = 4, .external_lex_state = 2},
  [3034] = {.lex_state = 15, .external_lex_state = 5},
  [3035] = {.lex_state = 96, .external_lex_state = 2},
  [3036] = {.lex_state = 4, .external_lex_state = 2},
  [3037] = {.lex_state = 4, .external_lex_state = 2},
  [3038] = {.lex_state = 15, .external_lex_state = 5},
  [3039] = {.lex_state = 15, .external_lex_state = 5},
  [3040] = {.lex_state = 15, .external_lex_state = 5},
  [3041] = {.lex_state = 96, .external_lex_state = 2},
  [3042] = {.lex_state = 96, .external_lex_state = 2},
  [3043] = {.lex_state = 15, .external_lex_state = 5},
  [3044] = {.lex_state = 15, .external_lex_state = 5},
  [3045] = {.lex_state = 15, .external_lex_state = 5},
  [3046] = {.lex_state = 96, .external_lex_state = 2},
  [3047] = {.lex_state = 12, .external_lex_state = 5},
  [3048] = {.lex_state = 96, .external_lex_state = 2},
  [3049] = {.lex_state = 96, .external_lex_state = 2},
  [3050] = {.lex_state = 12, .external_lex_state = 5},
  [3051] = {.lex_state = 12, .external_lex_state = 5},
  [3052] = {.lex_state = 96, .external_lex_state = 2},
  [3053] = {.lex_state = 12, .external_lex_state = 5},
  [3054] = {.lex_state = 12, .external_lex_state = 5},
  [3055] = {.lex_state = 12, .external_lex_state = 5},
  [3056] = {.lex_state = 12, .external_lex_state = 5},
  [3057] = {.lex_state = 12, .external_lex_state = 5},
  [3058] = {.lex_state = 12, .external_lex_state = 5},
  [3059] = {.lex_state = 12, .external_lex_state = 5},
  [3060] = {.lex_state = 96, .external_lex_state = 2},
  [3061] = {.lex_state = 96, .external_lex_state = 2},
  [3062] = {.lex_state = 96, .external_lex_state = 2},
  [3063] = {.lex_state = 12, .external_lex_state = 5},
  [3064] = {.lex_state = 96, .external_lex_state = 2},
  [3065] = {.lex_state = 96, .external_lex_state = 2},
  [3066] = {.lex_state = 12, .external_lex_state = 5},
  [3067] = {.lex_state = 12, .external_lex_state = 5},
  [3068] = {.lex_state = 12, .external_lex_state = 5},
  [3069] = {.lex_state = 12, .external_lex_state = 5},
  [3070] = {.lex_state = 12, .external_lex_state = 5},
  [3071] = {.lex_state = 12, .external_lex_state = 5},
  [3072] = {.lex_state = 12, .external_lex_state = 5},
  [3073] = {.lex_state = 96, .external_lex_state = 5},
  [3074] = {.lex_state = 12, .external_lex_state = 5},
  [3075] = {.lex_state = 12, .external_lex_state = 5},
  [3076] = {.lex_state = 12, .external_lex_state = 5},
  [3077] = {.lex_state = 12, .external_lex_state = 5},
  [3078] = {.lex_state = 96, .external_lex_state = 2},
  [3079] = {.lex_state = 12, .external_lex_state = 5},
  [3080] = {.lex_state = 12, .external_lex_state = 5},
  [3081] = {.lex_state = 12, .external_lex_state = 5},
  [3082] = {.lex_state = 13, .external_lex_state = 5},
  [3083] = {.lex_state = 96, .external_lex_state = 2},
  [3084] = {.lex_state = 12, .external_lex_state = 5},
  [3085] = {.lex_state = 12, .external_lex_state = 5},
  [3086] = {.lex_state = 12, .external_lex_state = 5},
  [3087] = {.lex_state = 96, .external_lex_state = 2},
  [3088] = {.lex_state = 96, .external_lex_state = 5},
  [3089] = {.lex_state = 15, .external_lex_state = 6},
  [3090] = {.lex_state = 15, .external_lex_state = 6},
  [3091] = {.lex_state = 15, .external_lex_state = 6},
  [3092] = {.lex_state = 15, .external_lex_state = 6},
  [3093] = {.lex_state = 15, .external_lex_state = 6},
  [3094] = {.lex_state = 15, .external_lex_state = 6},
  [3095] = {.lex_state = 15, .external_lex_state = 6},
  [3096] = {.lex_state = 15, .external_lex_state = 6},
  [3097] = {.lex_state = 15, .external_lex_state = 6},
  [3098] = {.lex_state = 12, .external_lex_state = 5},
  [3099] = {.lex_state = 12, .external_lex_state = 2},
  [3100] = {.lex_state = 13, .external_lex_state = 6},
  [3101] = {.lex_state = 15, .external_lex_state = 6},
  [3102] = {.lex_state = 96, .external_lex_state = 2},
  [3103] = {.lex_state = 14, .external_lex_state = 5},
  [3104] = {.lex_state = 13, .external_lex_state = 5},
  [3105] = {.lex_state = 15, .external_lex_state = 6},
  [3106] = {.lex_state = 14, .external_lex_state = 5},
  [3107] = {.lex_state = 12, .external_lex_state = 5},
  [3108] = {.lex_state = 12, .external_lex_state = 5},
  [3109] = {.lex_state = 15, .external_lex_state = 6},
  [3110] = {.lex_state = 12, .external_lex_state = 5},
  [3111] = {.lex_state = 15, .external_lex_state = 6},
  [3112] = {.lex_state = 96, .external_lex_state = 2},
  [3113] = {.lex_state = 15, .external_lex_state = 6},
  [3114] = {.lex_state = 15, .external_lex_state = 6},
  [3115] = {.lex_state = 96, .external_lex_state = 5},
  [3116] = {.lex_state = 15, .external_lex_state = 6},
  [3117] = {.lex_state = 12, .external_lex_state = 5},
  [3118] = {.lex_state = 15, .external_lex_state = 6},
  [3119] = {.lex_state = 96, .external_lex_state = 5},
  [3120] = {.lex_state = 96, .external_lex_state = 5},
  [3121] = {.lex_state = 96, .external_lex_state = 2},
  [3122] = {.lex_state = 15, .external_lex_state = 6},
  [3123] = {.lex_state = 14, .external_lex_state = 5},
  [3124] = {.lex_state = 12, .external_lex_state = 5},
  [3125] = {.lex_state = 14, .external_lex_state = 5},
  [3126] = {.lex_state = 15, .external_lex_state = 6},
  [3127] = {.lex_state = 15, .external_lex_state = 6},
  [3128] = {.lex_state = 14, .external_lex_state = 5},
  [3129] = {.lex_state = 96, .external_lex_state = 2},
  [3130] = {.lex_state = 15, .external_lex_state = 6},
  [3131] = {.lex_state = 13, .external_lex_state = 5},
  [3132] = {.lex_state = 15, .external_lex_state = 6},
  [3133] = {.lex_state = 12, .external_lex_state = 5},
  [3134] = {.lex_state = 14, .external_lex_state = 5},
  [3135] = {.lex_state = 12, .external_lex_state = 5},
  [3136] = {.lex_state = 13, .external_lex_state = 5},
  [3137] = {.lex_state = 15, .external_lex_state = 6},
  [3138] = {.lex_state = 96, .external_lex_state = 2},
  [3139] = {.lex_state = 96, .external_lex_state = 2},
  [3140] = {.lex_state = 15, .external_lex_state = 6},
  [3141] = {.lex_state = 96, .external_lex_state = 5},
  [3142] = {.lex_state = 15, .external_lex_state = 6},
  [3143] = {.lex_state = 14, .external_lex_state = 5},
  [3144] = {.lex_state = 15, .external_lex_state = 6},
  [3145] = {.lex_state = 96, .external_lex_state = 2},
  [3146] = {.lex_state = 96, .external_lex_state = 5},
  [3147] = {.lex_state = 15, .external_lex_state = 6},
  [3148] = {.lex_state = 15, .external_lex_state = 6},
  [3149] = {.lex_state = 96, .external_lex_state = 2},
  [3150] = {.lex_state = 15, .external_lex_state = 6},
  [3151] = {.lex_state = 15, .external_lex_state = 6},
  [3152] = {.lex_state = 15, .external_lex_state = 6},
  [3153] = {.lex_state = 96, .external_lex_state = 2},
  [3154] = {.lex_state = 14, .external_lex_state = 5},
  [3155] = {.lex_state = 15, .external_lex_state = 6},
  [3156] = {.lex_state = 12, .external_lex_state = 5},
  [3157] = {.lex_state = 15, .external_lex_state = 6},
  [3158] = {.lex_state = 12, .external_lex_state = 5},
  [3159] = {.lex_state = 96, .external_lex_state = 2},
  [3160] = {.lex_state = 15, .external_lex_state = 6},
  [3161] = {.lex_state = 12, .external_lex_state = 2},
  [3162] = {.lex_state = 12, .external_lex_state = 5},
  [3163] = {.lex_state = 12, .external_lex_state = 5},
  [3164] = {.lex_state = 96, .external_lex_state = 5},
  [3165] = {.lex_state = 12, .external_lex_state = 5},
  [3166] = {.lex_state = 12, .external_lex_state = 5},
  [3167] = {.lex_state = 12, .external_lex_state = 5},
  [3168] = {.lex_state = 96, .external_lex_state = 5},
  [3169] = {.lex_state = 96, .external_lex_state = 5},
  [3170] = {.lex_state = 12, .external_lex_state = 5},
  [3171] = {.lex_state = 15, .external_lex_state = 2},
  [3172] = {.lex_state = 15, .external_lex_state = 2},
  [3173] = {.lex_state = 96, .external_lex_state = 2},
  [3174] = {.lex_state = 15, .external_lex_state = 2},
  [3175] = {.lex_state = 96, .external_lex_state = 5},
  [3176] = {.lex_state = 12, .external_lex_state = 5},
  [3177] = {.lex_state = 12, .external_lex_state = 5},
  [3178] = {.lex_state = 12, .external_lex_state = 5},
  [3179] = {.lex_state = 12, .external_lex_state = 5},
  [3180] = {.lex_state = 12, .external_lex_state = 5},
  [3181] = {.lex_state = 12, .external_lex_state = 5},
  [3182] = {.lex_state = 96, .external_lex_state = 5},
  [3183] = {.lex_state = 12, .external_lex_state = 5},
  [3184] = {.lex_state = 96, .external_lex_state = 5},
  [3185] = {.lex_state = 12, .external_lex_state = 5},
  [3186] = {.lex_state = 96, .external_lex_state = 5},
  [3187] = {.lex_state = 12, .external_lex_state = 5},
  [3188] = {.lex_state = 12, .external_lex_state = 5},
  [3189] = {.lex_state = 12, .external_lex_state = 5},
  [3190] = {.lex_state = 96, .external_lex_state = 5},
  [3191] = {.lex_state = 12, .external_lex_state = 5},
  [3192] = {.lex_state = 12, .external_lex_state = 5},
  [3193] = {.lex_state = 12, .external_lex_state = 5},
  [3194] = {.lex_state = 12, .external_lex_state = 5},
  [3195] = {.lex_state = 12, .external_lex_state = 5},
  [3196] = {.lex_state = 12, .external_lex_state = 5},
  [3197] = {.lex_state = 12, .external_lex_state = 5},
  [3198] = {.lex_state = 12, .external_lex_state = 5},
  [3199] = {.lex_state = 12, .external_lex_state = 5},
  [3200] = {.lex_state = 96, .external_lex_state = 6},
  [3201] = {.lex_state = 12, .external_lex_state = 5},
  [3202] = {.lex_state = 12, .external_lex_state = 5},
  [3203] = {.lex_state = 12, .external_lex_state = 5},
  [3204] = {.lex_state = 12, .external_lex_state = 5},
  [3205] = {.lex_state = 12, .external_lex_state = 2},
  [3206] = {.lex_state = 12, .external_lex_state = 5},
  [3207] = {.lex_state = 12, .external_lex_state = 2},
  [3208] = {.lex_state = 96, .external_lex_state = 5},
  [3209] = {.lex_state = 96, .external_lex_state = 5},
  [3210] = {.lex_state = 12, .external_lex_state = 5},
  [3211] = {.lex_state = 12, .external_lex_state = 5},
  [3212] = {.lex_state = 12, .external_lex_state = 5},
  [3213] = {.lex_state = 96, .external_lex_state = 5},
  [3214] = {.lex_state = 12, .external_lex_state = 5},
  [3215] = {.lex_state = 12, .external_lex_state = 5},
  [3216] = {.lex_state = 12, .external_lex_state = 5},
  [3217] = {.lex_state = 13, .external_lex_state = 6},
  [3218] = {.lex_state = 12, .external_lex_state = 5},
  [3219] = {.lex_state = 12, .external_lex_state = 5},
  [3220] = {.lex_state = 96, .external_lex_state = 2},
  [3221] = {.lex_state = 14, .external_lex_state = 6},
  [3222] = {.lex_state = 96, .external_lex_state = 5},
  [3223] = {.lex_state = 96, .external_lex_state = 5},
  [3224] = {.lex_state = 96, .external_lex_state = 5},
  [3225] = {.lex_state = 96, .external_lex_state = 5},
  [3226] = {.lex_state = 96, .external_lex_state = 5},
  [3227] = {.lex_state = 14, .external_lex_state = 6},
  [3228] = {.lex_state = 96, .external_lex_state = 5},
  [3229] = {.lex_state = 96, .external_lex_state = 5},
  [3230] = {.lex_state = 13, .external_lex_state = 6},
  [3231] = {.lex_state = 14, .external_lex_state = 6},
  [3232] = {.lex_state = 14, .external_lex_state = 6},
  [3233] = {.lex_state = 96, .external_lex_state = 5},
  [3234] = {.lex_state = 96, .external_lex_state = 6},
  [3235] = {.lex_state = 96, .external_lex_state = 5},
  [3236] = {.lex_state = 12, .external_lex_state = 5},
  [3237] = {.lex_state = 96, .external_lex_state = 5},
  [3238] = {.lex_state = 96, .external_lex_state = 5},
  [3239] = {.lex_state = 96, .external_lex_state = 5},
  [3240] = {.lex_state = 14, .external_lex_state = 6},
  [3241] = {.lex_state = 96, .external_lex_state = 6},
  [3242] = {.lex_state = 96, .external_lex_state = 5},
  [3243] = {.lex_state = 13, .external_lex_state = 6},
  [3244] = {.lex_state = 96, .external_lex_state = 5},
  [3245] = {.lex_state = 96, .external_lex_state = 6},
  [3246] = {.lex_state = 96, .external_lex_state = 6},
  [3247] = {.lex_state = 96, .external_lex_state = 5},
  [3248] = {.lex_state = 96, .external_lex_state = 5},
  [3249] = {.lex_state = 96, .external_lex_state = 6},
  [3250] = {.lex_state = 12, .external_lex_state = 2},
  [3251] = {.lex_state = 96, .external_lex_state = 5},
  [3252] = {.lex_state = 13, .external_lex_state = 6},
  [3253] = {.lex_state = 12, .external_lex_state = 5},
  [3254] = {.lex_state = 96, .external_lex_state = 5},
  [3255] = {.lex_state = 96, .external_lex_state = 5},
  [3256] = {.lex_state = 96, .external_lex_state = 5},
  [3257] = {.lex_state = 96, .external_lex_state = 5},
  [3258] = {.lex_state = 96, .external_lex_state = 5},
  [3259] = {.lex_state = 96, .external_lex_state = 5},
  [3260] = {.lex_state = 96, .external_lex_state = 5},
  [3261] = {.lex_state = 14, .external_lex_state = 6},
  [3262] = {.lex_state = 96, .external_lex_state = 5},
  [3263] = {.lex_state = 96, .external_lex_state = 5},
  [3264] = {.lex_state = 96, .external_lex_state = 5},
  [3265] = {.lex_state = 96, .external_lex_state = 5},
  [3266] = {.lex_state = 96, .external_lex_state = 5},
  [3267] = {.lex_state = 96, .external_lex_state = 5},
  [3268] = {.lex_state = 96, .external_lex_state = 5},
  [3269] = {.lex_state = 96, .external_lex_state = 5},
  [3270] = {.lex_state = 96, .external_lex_state = 5},
  [3271] = {.lex_state = 96, .external_lex_state = 5},
  [3272] = {.lex_state = 96, .external_lex_state = 5},
  [3273] = {.lex_state = 96, .external_lex_state = 5},
  [3274] = {.lex_state = 96, .external_lex_state = 5},
  [3275] = {.lex_state = 96, .external_lex_state = 5},
  [3276] = {.lex_state = 96, .external_lex_state = 5},
  [3277] = {.lex_state = 96, .external_lex_state = 5},
  [3278] = {.lex_state = 96, .external_lex_state = 2},
  [3279] = {.lex_state = 12, .external_lex_state = 5},
  [3280] = {.lex_state = 96, .external_lex_state = 5},
  [3281] = {.lex_state = 96, .external_lex_state = 5},
  [3282] = {.lex_state = 96, .external_lex_state = 5},
  [3283] = {.lex_state = 96, .external_lex_state = 5},
  [3284] = {.lex_state = 96, .external_lex_state = 5},
  [3285] = {.lex_state = 96, .external_lex_state = 5},
  [3286] = {.lex_state = 96, .external_lex_state = 5},
  [3287] = {.lex_state = 14, .external_lex_state = 6},
  [3288] = {.lex_state = 96, .external_lex_state = 5},
  [3289] = {.lex_state = 96, .external_lex_state = 5},
  [3290] = {.lex_state = 14, .external_lex_state = 6},
  [3291] = {.lex_state = 96, .external_lex_state = 5},
  [3292] = {.lex_state = 96, .external_lex_state = 6},
  [3293] = {.lex_state = 13, .external_lex_state = 2},
  [3294] = {.lex_state = 13, .external_lex_state = 2},
  [3295] = {.lex_state = 96, .external_lex_state = 6},
  [3296] = {.lex_state = 96, .external_lex_state = 6},
  [3297] = {.lex_state = 96, .external_lex_state = 6},
  [3298] = {.lex_state = 96, .external_lex_state = 2},
  [3299] = {.lex_state = 12, .external_lex_state = 5},
  [3300] = {.lex_state = 96, .external_lex_state = 6},
  [3301] = {.lex_state = 96, .external_lex_state = 5},
  [3302] = {.lex_state = 13, .external_lex_state = 2},
  [3303] = {.lex_state = 96, .external_lex_state = 2},
  [3304] = {.lex_state = 13, .external_lex_state = 2},
  [3305] = {.lex_state = 96, .external_lex_state = 6},
  [3306] = {.lex_state = 96, .external_lex_state = 6},
  [3307] = {.lex_state = 96, .external_lex_state = 5},
  [3308] = {.lex_state = 96, .external_lex_state = 5},
  [3309] = {.lex_state = 96, .external_lex_state = 5},
  [3310] = {.lex_state = 13, .external_lex_state = 2},
  [3311] = {.lex_state = 96, .external_lex_state = 2},
  [3312] = {.lex_state = 96, .external_lex_state = 5},
  [3313] = {.lex_state = 13, .external_lex_state = 2},
  [3314] = {.lex_state = 13, .external_lex_state = 2},
  [3315] = {.lex_state = 96, .external_lex_state = 2},
  [3316] = {.lex_state = 96, .external_lex_state = 6},
  [3317] = {.lex_state = 12, .external_lex_state = 2},
  [3318] = {.lex_state = 96, .external_lex_state = 6},
  [3319] = {.lex_state = 13, .external_lex_state = 2},
  [3320] = {.lex_state = 13, .external_lex_state = 2},
  [3321] = {.lex_state = 13, .external_lex_state = 2},
  [3322] = {.lex_state = 96, .external_lex_state = 2},
  [3323] = {.lex_state = 13, .external_lex_state = 2},
  [3324] = {.lex_state = 96, .external_lex_state = 5},
  [3325] = {.lex_state = 96, .external_lex_state = 5},
  [3326] = {.lex_state = 96, .external_lex_state = 5},
  [3327] = {.lex_state = 96, .external_lex_state = 5},
  [3328] = {.lex_state = 96, .external_lex_state = 6},
  [3329] = {.lex_state = 96, .external_lex_state = 5},
  [3330] = {.lex_state = 96, .external_lex_state = 2},
  [3331] = {.lex_state = 96, .external_lex_state = 5},
  [3332] = {.lex_state = 96, .external_lex_state = 6},
  [3333] = {.lex_state = 11, .external_lex_state = 2},
  [3334] = {.lex_state = 96, .external_lex_state = 2},
  [3335] = {.lex_state = 96, .external_lex_state = 2},
  [3336] = {.lex_state = 96, .external_lex_state = 6},
  [3337] = {.lex_state = 96, .external_lex_state = 6},
  [3338] = {.lex_state = 96, .external_lex_state = 5},
  [3339] = {.lex_state = 96, .external_lex_state = 5},
  [3340] = {.lex_state = 96, .external_lex_state = 5},
  [3341] = {.lex_state = 96, .external_lex_state = 5},
  [3342] = {.lex_state = 96, .external_lex_state = 6},
  [3343] = {.lex_state = 96, .external_lex_state = 6},
  [3344] = {.lex_state = 96, .external_lex_state = 6},
  [3345] = {.lex_state = 96, .external_lex_state = 5},
  [3346] = {.lex_state = 96, .external_lex_state = 6},
  [3347] = {.lex_state = 96, .external_lex_state = 6},
  [3348] = {.lex_state = 96, .external_lex_state = 2},
  [3349] = {.lex_state = 96, .external_lex_state = 5},
  [3350] = {.lex_state = 96, .external_lex_state = 6},
  [3351] = {.lex_state = 12, .external_lex_state = 2},
  [3352] = {.lex_state = 96, .external_lex_state = 6},
  [3353] = {.lex_state = 12, .external_lex_state = 2},
  [3354] = {.lex_state = 96, .external_lex_state = 6},
  [3355] = {.lex_state = 96, .external_lex_state = 2},
  [3356] = {.lex_state = 96, .external_lex_state = 6},
  [3357] = {.lex_state = 96, .external_lex_state = 5},
  [3358] = {.lex_state = 96, .external_lex_state = 6},
  [3359] = {.lex_state = 96, .external_lex_state = 6},
  [3360] = {.lex_state = 12, .external_lex_state = 2},
  [3361] = {.lex_state = 13, .external_lex_state = 2},
  [3362] = {.lex_state = 96, .external_lex_state = 6},
  [3363] = {.lex_state = 13, .external_lex_state = 2},
  [3364] = {.lex_state = 96, .external_lex_state = 5},
  [3365] = {.lex_state = 96, .external_lex_state = 6},
  [3366] = {.lex_state = 96, .external_lex_state = 6},
  [3367] = {.lex_state = 96, .external_lex_state = 5},
  [3368] = {.lex_state = 96, .external_lex_state = 5},
  [3369] = {.lex_state = 96, .external_lex_state = 6},
  [3370] = {.lex_state = 96, .external_lex_state = 5},
  [3371] = {.lex_state = 96, .external_lex_state = 6},
  [3372] = {.lex_state = 96, .external_lex_state = 6},
  [3373] = {.lex_state = 12, .external_lex_state = 2},
  [3374] = {.lex_state = 96, .external_lex_state = 6},
  [3375] = {.lex_state = 96, .external_lex_state = 2},
  [3376] = {.lex_state = 13, .external_lex_state = 2},
  [3377] = {.lex_state = 96, .external_lex_state = 5},
  [3378] = {.lex_state = 96, .external_lex_state = 6},
  [3379] = {.lex_state = 96, .external_lex_state = 2},
  [3380] = {.lex_state = 96, .external_lex_state = 6},
  [3381] = {.lex_state = 13, .external_lex_state = 2},
  [3382] = {.lex_state = 13, .external_lex_state = 2},
  [3383] = {.lex_state = 96, .external_lex_state = 6},
  [3384] = {.lex_state = 96, .external_lex_state = 6},
  [3385] = {.lex_state = 96, .external_lex_state = 6},
  [3386] = {.lex_state = 13, .external_lex_state = 2},
  [3387] = {.lex_state = 11, .external_lex_state = 2},
  [3388] = {.lex_state = 96, .external_lex_state = 6},
  [3389] = {.lex_state = 96, .external_lex_state = 6},
  [3390] = {.lex_state = 96, .external_lex_state = 2},
  [3391] = {.lex_state = 13, .external_lex_state = 2},
  [3392] = {.lex_state = 13, .external_lex_state = 2},
  [3393] = {.lex_state = 96, .external_lex_state = 5},
  [3394] = {.lex_state = 96, .external_lex_state = 6},
  [3395] = {.lex_state = 13, .external_lex_state = 2},
  [3396] = {.lex_state = 96, .external_lex_state = 6},
  [3397] = {.lex_state = 96, .external_lex_state = 5},
  [3398] = {.lex_state = 96, .external_lex_state = 2},
  [3399] = {.lex_state = 96, .external_lex_state = 6},
  [3400] = {.lex_state = 96, .external_lex_state = 5},
  [3401] = {.lex_state = 96, .external_lex_state = 6},
  [3402] = {.lex_state = 96, .external_lex_state = 6},
  [3403] = {.lex_state = 96, .external_lex_state = 5},
  [3404] = {.lex_state = 96, .external_lex_state = 6},
  [3405] = {.lex_state = 96, .external_lex_state = 5},
  [3406] = {.lex_state = 96, .external_lex_state = 5},
  [3407] = {.lex_state = 12, .external_lex_state = 2},
  [3408] = {.lex_state = 13, .external_lex_state = 2},
  [3409] = {.lex_state = 96, .external_lex_state = 5},
  [3410] = {.lex_state = 96, .external_lex_state = 2},
  [3411] = {.lex_state = 96, .external_lex_state = 5},
  [3412] = {.lex_state = 96, .external_lex_state = 6},
  [3413] = {.lex_state = 96, .external_lex_state = 5},
  [3414] = {.lex_state = 12, .external_lex_state = 2},
  [3415] = {.lex_state = 96, .external_lex_state = 6},
  [3416] = {.lex_state = 96, .external_lex_state = 5},
  [3417] = {.lex_state = 96, .external_lex_state = 5},
  [3418] = {.lex_state = 96, .external_lex_state = 5},
  [3419] = {.lex_state = 13, .external_lex_state = 2},
  [3420] = {.lex_state = 13, .external_lex_state = 2},
  [3421] = {.lex_state = 96, .external_lex_state = 5},
  [3422] = {.lex_state = 96, .external_lex_state = 6},
  [3423] = {.lex_state = 96, .external_lex_state = 6},
  [3424] = {.lex_state = 96, .external_lex_state = 5},
  [3425] = {.lex_state = 96, .external_lex_state = 5},
  [3426] = {.lex_state = 96, .external_lex_state = 6},
  [3427] = {.lex_state = 96, .external_lex_state = 5},
  [3428] = {.lex_state = 12, .external_lex_state = 2},
  [3429] = {.lex_state = 11, .external_lex_state = 2},
  [3430] = {.lex_state = 96, .external_lex_state = 5},
  [3431] = {.lex_state = 96, .external_lex_state = 5},
  [3432] = {.lex_state = 96, .external_lex_state = 6},
  [3433] = {.lex_state = 96, .external_lex_state = 5},
  [3434] = {.lex_state = 96, .external_lex_state = 6},
  [3435] = {.lex_state = 96, .external_lex_state = 5},
  [3436] = {.lex_state = 13, .external_lex_state = 2},
  [3437] = {.lex_state = 96, .external_lex_state = 6},
  [3438] = {.lex_state = 96, .external_lex_state = 5},
  [3439] = {.lex_state = 96, .external_lex_state = 6},
  [3440] = {.lex_state = 96, .external_lex_state = 5},
  [3441] = {.lex_state = 12, .external_lex_state = 2},
  [3442] = {.lex_state = 96, .external_lex_state = 6},
  [3443] = {.lex_state = 13, .external_lex_state = 2},
  [3444] = {.lex_state = 96, .external_lex_state = 5},
  [3445] = {.lex_state = 96, .external_lex_state = 6},
  [3446] = {.lex_state = 96, .external_lex_state = 5},
  [3447] = {.lex_state = 96, .external_lex_state = 6},
  [3448] = {.lex_state = 13, .external_lex_state = 2},
  [3449] = {.lex_state = 96, .external_lex_state = 6},
  [3450] = {.lex_state = 96, .external_lex_state = 5},
  [3451] = {.lex_state = 96, .external_lex_state = 6},
  [3452] = {.lex_state = 13, .external_lex_state = 2},
  [3453] = {.lex_state = 13, .external_lex_state = 2},
  [3454] = {.lex_state = 96, .external_lex_state = 5},
  [3455] = {.lex_state = 13, .external_lex_state = 2},
  [3456] = {.lex_state = 96, .external_lex_state = 5},
  [3457] = {.lex_state = 13, .external_lex_state = 2},
  [3458] = {.lex_state = 96, .external_lex_state = 6},
  [3459] = {.lex_state = 96, .external_lex_state = 5},
  [3460] = {.lex_state = 96, .external_lex_state = 5},
  [3461] = {.lex_state = 96, .external_lex_state = 5},
  [3462] = {.lex_state = 96, .external_lex_state = 6},
  [3463] = {.lex_state = 96, .external_lex_state = 6},
  [3464] = {.lex_state = 96, .external_lex_state = 6},
  [3465] = {.lex_state = 96, .external_lex_state = 5},
  [3466] = {.lex_state = 96, .external_lex_state = 6},
  [3467] = {.lex_state = 96, .external_lex_state = 6},
  [3468] = {.lex_state = 96, .external_lex_state = 5},
  [3469] = {.lex_state = 96, .external_lex_state = 6},
  [3470] = {.lex_state = 96, .external_lex_state = 5},
  [3471] = {.lex_state = 96, .external_lex_state = 2},
  [3472] = {.lex_state = 96, .external_lex_state = 2},
  [3473] = {.lex_state = 18, .external_lex_state = 2},
  [3474] = {.lex_state = 96, .external_lex_state = 2},
  [3475] = {.lex_state = 96, .external_lex_state = 2},
  [3476] = {.lex_state = 18, .external_lex_state = 2},
  [3477] = {.lex_state = 96, .external_lex_state = 5},
  [3478] = {.lex_state = 96, .external_lex_state = 5},
  [3479] = {.lex_state = 96, .external_lex_state = 2},
  [3480] = {.lex_state = 96, .external_lex_state = 2},
  [3481] = {.lex_state = 96, .external_lex_state = 5},
  [3482] = {.lex_state = 18, .external_lex_state = 2},
  [3483] = {.lex_state = 18, .external_lex_state = 7},
  [3484] = {.lex_state = 96, .external_lex_state = 5},
  [3485] = {.lex_state = 18, .external_lex_state = 2},
  [3486] = {.lex_state = 96, .external_lex_state = 2},
  [3487] = {.lex_state = 18, .external_lex_state = 2},
  [3488] = {.lex_state = 18, .external_lex_state = 7},
  [3489] = {.lex_state = 18, .external_lex_state = 7},
  [3490] = {.lex_state = 18, .external_lex_state = 7},
  [3491] = {.lex_state = 18, .external_lex_state = 7},
  [3492] = {.lex_state = 96, .external_lex_state = 2},
  [3493] = {.lex_state = 18, .external_lex_state = 2},
  [3494] = {.lex_state = 12, .external_lex_state = 2},
  [3495] = {.lex_state = 18, .external_lex_state = 7},
  [3496] = {.lex_state = 96, .external_lex_state = 2},
  [3497] = {.lex_state = 14, .external_lex_state = 2},
  [3498] = {.lex_state = 18, .external_lex_state = 2},
  [3499] = {.lex_state = 18, .external_lex_state = 2},
  [3500] = {.lex_state = 18, .external_lex_state = 7},
  [3501] = {.lex_state = 96, .external_lex_state = 6},
  [3502] = {.lex_state = 96, .external_lex_state = 5},
  [3503] = {.lex_state = 96, .external_lex_state = 5},
  [3504] = {.lex_state = 96, .external_lex_state = 2},
  [3505] = {.lex_state = 96, .external_lex_state = 2},
  [3506] = {.lex_state = 14, .external_lex_state = 2},
  [3507] = {.lex_state = 18, .external_lex_state = 7},
  [3508] = {.lex_state = 18, .external_lex_state = 2},
  [3509] = {.lex_state = 96, .external_lex_state = 2},
  [3510] = {.lex_state = 14, .external_lex_state = 2},
  [3511] = {.lex_state = 96, .external_lex_state = 2},
  [3512] = {.lex_state = 12, .external_lex_state = 2},
  [3513] = {.lex_state = 15, .external_lex_state = 2},
  [3514] = {.lex_state = 96, .external_lex_state = 2},
  [3515] = {.lex_state = 96, .external_lex_state = 5},
  [3516] = {.lex_state = 96, .external_lex_state = 5},
  [3517] = {.lex_state = 96, .external_lex_state = 5},
  [3518] = {.lex_state = 96, .external_lex_state = 2},
  [3519] = {.lex_state = 96, .external_lex_state = 5},
  [3520] = {.lex_state = 96, .external_lex_state = 5},
  [3521] = {.lex_state = 96, .external_lex_state = 2},
  [3522] = {.lex_state = 96, .external_lex_state = 5},
  [3523] = {.lex_state = 96, .external_lex_state = 5},
  [3524] = {.lex_state = 96, .external_lex_state = 5},
  [3525] = {.lex_state = 96, .external_lex_state = 5},
  [3526] = {.lex_state = 96, .external_lex_state = 5},
  [3527] = {.lex_state = 96, .external_lex_state = 5},
  [3528] = {.lex_state = 12, .external_lex_state = 2},
  [3529] = {.lex_state = 96, .external_lex_state = 5},
  [3530] = {.lex_state = 96, .external_lex_state = 5},
  [3531] = {.lex_state = 96, .external_lex_state = 5},
  [3532] = {.lex_state = 96, .external_lex_state = 5},
  [3533] = {.lex_state = 96, .external_lex_state = 2},
  [3534] = {.lex_state = 96, .external_lex_state = 5},
  [3535] = {.lex_state = 96, .external_lex_state = 5},
  [3536] = {.lex_state = 96, .external_lex_state = 5},
  [3537] = {.lex_state = 96, .external_lex_state = 5},
  [3538] = {.lex_state = 96, .external_lex_state = 5},
  [3539] = {.lex_state = 96, .external_lex_state = 5},
  [3540] = {.lex_state = 96, .external_lex_state = 5},
  [3541] = {.lex_state = 96, .external_lex_state = 5},
  [3542] = {.lex_state = 15, .external_lex_state = 2},
  [3543] = {.lex_state = 96, .external_lex_state = 5},
  [3544] = {.lex_state = 96, .external_lex_state = 2},
  [3545] = {.lex_state = 96, .external_lex_state = 2},
  [3546] = {.lex_state = 96, .external_lex_state = 2},
  [3547] = {.lex_state = 96, .external_lex_state = 5},
  [3548] = {.lex_state = 96, .external_lex_state = 2},
  [3549] = {.lex_state = 12, .external_lex_state = 2},
  [3550] = {.lex_state = 96, .external_lex_state = 5},
  [3551] = {.lex_state = 12, .external_lex_state = 2},
  [3552] = {.lex_state = 12, .external_lex_state = 2},
  [3553] = {.lex_state = 96, .external_lex_state = 2},
  [3554] = {.lex_state = 96, .external_lex_state = 5},
  [3555] = {.lex_state = 96, .external_lex_state = 5},
  [3556] = {.lex_state = 96, .external_lex_state = 5},
  [3557] = {.lex_state = 15, .external_lex_state = 2},
  [3558] = {.lex_state = 96, .external_lex_state = 5},
  [3559] = {.lex_state = 96, .external_lex_state = 5},
  [3560] = {.lex_state = 96, .external_lex_state = 5},
  [3561] = {.lex_state = 96, .external_lex_state = 2},
  [3562] = {.lex_state = 96, .external_lex_state = 2},
  [3563] = {.lex_state = 96, .external_lex_state = 2},
  [3564] = {.lex_state = 96, .external_lex_state = 5},
  [3565] = {.lex_state = 96, .external_lex_state = 5},
  [3566] = {.lex_state = 15, .external_lex_state = 2},
  [3567] = {.lex_state = 96, .external_lex_state = 5},
  [3568] = {.lex_state = 96, .external_lex_state = 5},
  [3569] = {.lex_state = 96, .external_lex_state = 2},
  [3570] = {.lex_state = 96, .external_lex_state = 5},
  [3571] = {.lex_state = 96, .external_lex_state = 2},
  [3572] = {.lex_state = 96, .external_lex_state = 5},
  [3573] = {.lex_state = 96, .external_lex_state = 2},
  [3574] = {.lex_state = 96, .external_lex_state = 2},
  [3575] = {.lex_state = 96, .external_lex_state = 2},
  [3576] = {.lex_state = 96, .external_lex_state = 2},
  [3577] = {.lex_state = 96, .external_lex_state = 5},
  [3578] = {.lex_state = 96, .external_lex_state = 5},
  [3579] = {.lex_state = 96, .external_lex_state = 5},
  [3580] = {.lex_state = 96, .external_lex_state = 5},
  [3581] = {.lex_state = 96, .external_lex_state = 2},
  [3582] = {.lex_state = 96, .external_lex_state = 5},
  [3583] = {.lex_state = 96, .external_lex_state = 5},
  [3584] = {.lex_state = 96, .external_lex_state = 5},
  [3585] = {.lex_state = 96, .external_lex_state = 5},
  [3586] = {.lex_state = 96, .external_lex_state = 5},
  [3587] = {.lex_state = 96, .external_lex_state = 2},
  [3588] = {.lex_state = 96, .external_lex_state = 5},
  [3589] = {.lex_state = 96, .external_lex_state = 5},
  [3590] = {.lex_state = 96, .external_lex_state = 5},
  [3591] = {.lex_state = 96, .external_lex_state = 5},
  [3592] = {.lex_state = 96, .external_lex_state = 2},
  [3593] = {.lex_state = 12, .external_lex_state = 2},
  [3594] = {.lex_state = 15, .external_lex_state = 2},
  [3595] = {.lex_state = 96, .external_lex_state = 5},
  [3596] = {.lex_state = 96, .external_lex_state = 5},
  [3597] = {.lex_state = 15, .external_lex_state = 2},
  [3598] = {.lex_state = 96, .external_lex_state = 2},
  [3599] = {.lex_state = 96, .external_lex_state = 5},
  [3600] = {.lex_state = 96, .external_lex_state = 5},
  [3601] = {.lex_state = 96, .external_lex_state = 5},
  [3602] = {.lex_state = 96, .external_lex_state = 5},
  [3603] = {.lex_state = 15, .external_lex_state = 2},
  [3604] = {.lex_state = 15, .external_lex_state = 2},
  [3605] = {.lex_state = 96, .external_lex_state = 2},
  [3606] = {.lex_state = 96, .external_lex_state = 2},
  [3607] = {.lex_state = 96, .external_lex_state = 2},
  [3608] = {.lex_state = 96, .external_lex_state = 2},
  [3609] = {.lex_state = 96, .external_lex_state = 5},
  [3610] = {.lex_state = 96, .external_lex_state = 5},
  [3611] = {.lex_state = 96, .external_lex_state = 2},
  [3612] = {.lex_state = 96, .external_lex_state = 5},
  [3613] = {.lex_state = 96, .external_lex_state = 5},
  [3614] = {.lex_state = 15, .external_lex_state = 2},
  [3615] = {.lex_state = 15, .external_lex_state = 2},
  [3616] = {.lex_state = 15, .external_lex_state = 2},
  [3617] = {.lex_state = 12, .external_lex_state = 2},
  [3618] = {.lex_state = 96, .external_lex_state = 5},
  [3619] = {.lex_state = 96, .external_lex_state = 2},
  [3620] = {.lex_state = 15, .external_lex_state = 2},
  [3621] = {.lex_state = 96, .external_lex_state = 5},
  [3622] = {.lex_state = 15, .external_lex_state = 2},
  [3623] = {.lex_state = 15, .external_lex_state = 2},
  [3624] = {.lex_state = 96, .external_lex_state = 2},
  [3625] = {.lex_state = 96, .external_lex_state = 5},
  [3626] = {.lex_state = 96, .external_lex_state = 2},
  [3627] = {.lex_state = 12, .external_lex_state = 2},
  [3628] = {.lex_state = 96, .external_lex_state = 2},
  [3629] = {.lex_state = 12, .external_lex_state = 2},
  [3630] = {.lex_state = 12, .external_lex_state = 2},
  [3631] = {.lex_state = 96, .external_lex_state = 5},
  [3632] = {.lex_state = 96, .external_lex_state = 5},
  [3633] = {.lex_state = 96, .external_lex_state = 2},
  [3634] = {.lex_state = 15, .external_lex_state = 2},
  [3635] = {.lex_state = 96, .external_lex_state = 5},
  [3636] = {.lex_state = 96, .external_lex_state = 5},
  [3637] = {.lex_state = 96, .external_lex_state = 5},
  [3638] = {.lex_state = 96, .external_lex_state = 5},
  [3639] = {.lex_state = 96, .external_lex_state = 2},
  [3640] = {.lex_state = 96, .external_lex_state = 5},
  [3641] = {.lex_state = 96, .external_lex_state = 2},
  [3642] = {.lex_state = 96, .external_lex_state = 5},
  [3643] = {.lex_state = 96, .external_lex_state = 2},
  [3644] = {.lex_state = 96, .external_lex_state = 5},
  [3645] = {.lex_state = 96, .external_lex_state = 2},
  [3646] = {.lex_state = 96, .external_lex_state = 2},
  [3647] = {.lex_state = 96, .external_lex_state = 5},
  [3648] = {.lex_state = 96, .external_lex_state = 5},
  [3649] = {.lex_state = 96, .external_lex_state = 2},
  [3650] = {.lex_state = 96, .external_lex_state = 2},
  [3651] = {.lex_state = 96, .external_lex_state = 2},
  [3652] = {.lex_state = 96, .external_lex_state = 2},
  [3653] = {.lex_state = 96, .external_lex_state = 2},
  [3654] = {.lex_state = 96, .external_lex_state = 5},
  [3655] = {.lex_state = 96, .external_lex_state = 5},
  [3656] = {.lex_state = 96, .external_lex_state = 2},
  [3657] = {.lex_state = 96, .external_lex_state = 2},
  [3658] = {.lex_state = 12, .external_lex_state = 2},
  [3659] = {.lex_state = 96, .external_lex_state = 2},
  [3660] = {.lex_state = 96, .external_lex_state = 2},
  [3661] = {.lex_state = 96, .external_lex_state = 5},
  [3662] = {.lex_state = 96, .external_lex_state = 5},
  [3663] = {.lex_state = 12, .external_lex_state = 2},
  [3664] = {.lex_state = 96, .external_lex_state = 5},
  [3665] = {.lex_state = 96, .external_lex_state = 5},
  [3666] = {.lex_state = 96, .external_lex_state = 5},
  [3667] = {.lex_state = 96, .external_lex_state = 5},
  [3668] = {.lex_state = 96, .external_lex_state = 5},
  [3669] = {.lex_state = 96, .external_lex_state = 5},
  [3670] = {.lex_state = 96, .external_lex_state = 5},
  [3671] = {.lex_state = 96, .external_lex_state = 5},
  [3672] = {.lex_state = 96, .external_lex_state = 2},
  [3673] = {.lex_state = 96, .external_lex_state = 5},
  [3674] = {.lex_state = 96, .external_lex_state = 5},
  [3675] = {.lex_state = 96, .external_lex_state = 5},
  [3676] = {.lex_state = 96, .external_lex_state = 5},
  [3677] = {.lex_state = 96, .external_lex_state = 5},
  [3678] = {.lex_state = 96, .external_lex_state = 5},
  [3679] = {.lex_state = 12, .external_lex_state = 2},
  [3680] = {.lex_state = 96, .external_lex_state = 5},
  [3681] = {.lex_state = 96, .external_lex_state = 5},
  [3682] = {.lex_state = 96, .external_lex_state = 5},
  [3683] = {.lex_state = 96, .external_lex_state = 5},
  [3684] = {.lex_state = 96, .external_lex_state = 5},
  [3685] = {.lex_state = 12, .external_lex_state = 2},
  [3686] = {.lex_state = 96, .external_lex_state = 5},
  [3687] = {.lex_state = 96, .external_lex_state = 5},
  [3688] = {.lex_state = 96, .external_lex_state = 5},
  [3689] = {.lex_state = 96, .external_lex_state = 5},
  [3690] = {.lex_state = 96, .external_lex_state = 5},
  [3691] = {.lex_state = 96, .external_lex_state = 5},
  [3692] = {.lex_state = 96, .external_lex_state = 5},
  [3693] = {.lex_state = 96, .external_lex_state = 5},
  [3694] = {.lex_state = 96, .external_lex_state = 5},
  [3695] = {.lex_state = 12, .external_lex_state = 2},
  [3696] = {.lex_state = 96, .external_lex_state = 5},
  [3697] = {.lex_state = 96, .external_lex_state = 5},
  [3698] = {.lex_state = 96, .external_lex_state = 5},
  [3699] = {.lex_state = 96, .external_lex_state = 5},
  [3700] = {.lex_state = 96, .external_lex_state = 5},
  [3701] = {.lex_state = 96, .external_lex_state = 5},
  [3702] = {.lex_state = 15, .external_lex_state = 2},
  [3703] = {.lex_state = 96, .external_lex_state = 5},
  [3704] = {.lex_state = 96, .external_lex_state = 5},
  [3705] = {.lex_state = 96, .external_lex_state = 5},
  [3706] = {.lex_state = 96, .external_lex_state = 5},
  [3707] = {.lex_state = 96, .external_lex_state = 5},
  [3708] = {.lex_state = 96, .external_lex_state = 5},
  [3709] = {.lex_state = 96, .external_lex_state = 5},
  [3710] = {.lex_state = 96, .external_lex_state = 5},
  [3711] = {.lex_state = 96, .external_lex_state = 5},
  [3712] = {.lex_state = 96, .external_lex_state = 5},
  [3713] = {.lex_state = 96, .external_lex_state = 5},
  [3714] = {.lex_state = 96, .external_lex_state = 5},
  [3715] = {.lex_state = 96, .external_lex_state = 5},
  [3716] = {.lex_state = 96, .external_lex_state = 5},
  [3717] = {.lex_state = 96, .external_lex_state = 5},
  [3718] = {.lex_state = 96, .external_lex_state = 5},
  [3719] = {.lex_state = 96, .external_lex_state = 2},
  [3720] = {.lex_state = 96, .external_lex_state = 5},
  [3721] = {.lex_state = 96, .external_lex_state = 2},
  [3722] = {.lex_state = 96, .external_lex_state = 5},
  [3723] = {.lex_state = 12, .external_lex_state = 2},
  [3724] = {.lex_state = 12, .external_lex_state = 2},
  [3725] = {.lex_state = 12, .external_lex_state = 2},
  [3726] = {.lex_state = 96, .external_lex_state = 5},
  [3727] = {.lex_state = 96, .external_lex_state = 2},
  [3728] = {.lex_state = 96, .external_lex_state = 2},
  [3729] = {.lex_state = 96, .external_lex_state = 2},
  [3730] = {.lex_state = 96, .external_lex_state = 2},
  [3731] = {.lex_state = 96, .external_lex_state = 5},
  [3732] = {.lex_state = 96, .external_lex_state = 5},
  [3733] = {.lex_state = 96, .external_lex_state = 5},
  [3734] = {.lex_state = 96, .external_lex_state = 5},
  [3735] = {.lex_state = 96, .external_lex_state = 5},
  [3736] = {.lex_state = 96, .external_lex_state = 5},
  [3737] = {.lex_state = 96, .external_lex_state = 5},
  [3738] = {.lex_state = 12, .external_lex_state = 2},
  [3739] = {.lex_state = 96, .external_lex_state = 2},
  [3740] = {.lex_state = 12, .external_lex_state = 2},
  [3741] = {.lex_state = 96, .external_lex_state = 5},
  [3742] = {.lex_state = 96, .external_lex_state = 5},
  [3743] = {.lex_state = 96, .external_lex_state = 5},
  [3744] = {.lex_state = 96, .external_lex_state = 5},
  [3745] = {.lex_state = 96, .external_lex_state = 5},
  [3746] = {.lex_state = 96, .external_lex_state = 5},
  [3747] = {.lex_state = 96, .external_lex_state = 5},
  [3748] = {.lex_state = 96, .external_lex_state = 5},
  [3749] = {.lex_state = 96, .external_lex_state = 5},
  [3750] = {.lex_state = 96, .external_lex_state = 5},
  [3751] = {.lex_state = 96, .external_lex_state = 5},
  [3752] = {.lex_state = 96, .external_lex_state = 5},
  [3753] = {.lex_state = 96, .external_lex_state = 5},
  [3754] = {.lex_state = 15, .external_lex_state = 2},
  [3755] = {.lex_state = 12, .external_lex_state = 2},
  [3756] = {.lex_state = 96, .external_lex_state = 5},
  [3757] = {.lex_state = 96, .external_lex_state = 2},
  [3758] = {.lex_state = 12, .external_lex_state = 2},
  [3759] = {.lex_state = 96, .external_lex_state = 5},
  [3760] = {.lex_state = 12, .external_lex_state = 2},
  [3761] = {.lex_state = 12, .external_lex_state = 2},
  [3762] = {.lex_state = 12, .external_lex_state = 2},
  [3763] = {.lex_state = 96, .external_lex_state = 5},
  [3764] = {.lex_state = 96, .external_lex_state = 5},
  [3765] = {.lex_state = 12, .external_lex_state = 2},
  [3766] = {.lex_state = 96, .external_lex_state = 5},
  [3767] = {.lex_state = 96, .external_lex_state = 5},
  [3768] = {.lex_state = 12, .external_lex_state = 2},
  [3769] = {.lex_state = 96, .external_lex_state = 2},
  [3770] = {.lex_state = 96, .external_lex_state = 2},
  [3771] = {.lex_state = 12, .external_lex_state = 2},
  [3772] = {.lex_state = 96, .external_lex_state = 6},
  [3773] = {.lex_state = 96, .external_lex_state = 2},
  [3774] = {.lex_state = 96, .external_lex_state = 2},
  [3775] = {.lex_state = 12, .external_lex_state = 2},
  [3776] = {.lex_state = 96, .external_lex_state = 6},
  [3777] = {.lex_state = 12, .external_lex_state = 2},
  [3778] = {.lex_state = 96, .external_lex_state = 5},
  [3779] = {.lex_state = 96, .external_lex_state = 2},
  [3780] = {.lex_state = 96, .external_lex_state = 5},
  [3781] = {.lex_state = 96, .external_lex_state = 2},
  [3782] = {.lex_state = 96, .external_lex_state = 2},
  [3783] = {.lex_state = 96, .external_lex_state = 5},
  [3784] = {.lex_state = 96, .external_lex_state = 5},
  [3785] = {.lex_state = 96, .external_lex_state = 2},
  [3786] = {.lex_state = 12, .external_lex_state = 2},
  [3787] = {.lex_state = 96, .external_lex_state = 5},
  [3788] = {.lex_state = 96, .external_lex_state = 2},
  [3789] = {.lex_state = 18, .external_lex_state = 7},
  [3790] = {.lex_state = 96, .external_lex_state = 6},
  [3791] = {.lex_state = 96, .external_lex_state = 2},
  [3792] = {.lex_state = 12, .external_lex_state = 2},
  [3793] = {.lex_state = 96, .external_lex_state = 2},
  [3794] = {.lex_state = 96, .external_lex_state = 2},
  [3795] = {.lex_state = 96, .external_lex_state = 6},
  [3796] = {.lex_state = 12, .external_lex_state = 2},
  [3797] = {.lex_state = 12, .external_lex_state = 2},
  [3798] = {.lex_state = 12, .external_lex_state = 2},
  [3799] = {.lex_state = 12, .external_lex_state = 2},
  [3800] = {.lex_state = 12, .external_lex_state = 2},
  [3801] = {.lex_state = 96, .external_lex_state = 2},
  [3802] = {.lex_state = 96, .external_lex_state = 6},
  [3803] = {.lex_state = 96, .external_lex_state = 6},
  [3804] = {.lex_state = 96, .external_lex_state = 2},
  [3805] = {.lex_state = 12, .external_lex_state = 2},
  [3806] = {.lex_state = 96, .external_lex_state = 5},
  [3807] = {.lex_state = 96, .external_lex_state = 5},
  [3808] = {.lex_state = 96, .external_lex_state = 2},
  [3809] = {.lex_state = 96, .external_lex_state = 5},
  [3810] = {.lex_state = 96, .external_lex_state = 2},
  [3811] = {.lex_state = 96, .external_lex_state = 5},
  [3812] = {.lex_state = 96, .external_lex_state = 2},
  [3813] = {.lex_state = 96, .external_lex_state = 5},
  [3814] = {.lex_state = 96, .external_lex_state = 2},
  [3815] = {.lex_state = 96, .external_lex_state = 6},
  [3816] = {.lex_state = 96, .external_lex_state = 6},
  [3817] = {.lex_state = 12, .external_lex_state = 2},
  [3818] = {.lex_state = 96, .external_lex_state = 6},
  [3819] = {.lex_state = 96, .external_lex_state = 2},
  [3820] = {.lex_state = 96, .external_lex_state = 5},
  [3821] = {.lex_state = 12, .external_lex_state = 2},
  [3822] = {.lex_state = 96, .external_lex_state = 5},
  [3823] = {.lex_state = 96, .external_lex_state = 2},
  [3824] = {.lex_state = 12, .external_lex_state = 2},
  [3825] = {.lex_state = 12, .external_lex_state = 2},
  [3826] = {.lex_state = 96, .external_lex_state = 5},
  [3827] = {.lex_state = 96, .external_lex_state = 6},
  [3828] = {.lex_state = 96, .external_lex_state = 6},
  [3829] = {.lex_state = 96, .external_lex_state = 5},
  [3830] = {.lex_state = 96, .external_lex_state = 6},
  [3831] = {.lex_state = 96, .external_lex_state = 5},
  [3832] = {.lex_state = 96, .external_lex_state = 2},
  [3833] = {.lex_state = 96, .external_lex_state = 5},
  [3834] = {.lex_state = 96, .external_lex_state = 6},
  [3835] = {.lex_state = 12, .external_lex_state = 2},
  [3836] = {.lex_state = 96, .external_lex_state = 5},
  [3837] = {.lex_state = 96, .external_lex_state = 5},
  [3838] = {.lex_state = 12, .external_lex_state = 2},
  [3839] = {.lex_state = 12, .external_lex_state = 2},
  [3840] = {.lex_state = 96, .external_lex_state = 2},
  [3841] = {.lex_state = 96, .external_lex_state = 2},
  [3842] = {.lex_state = 96, .external_lex_state = 2},
  [3843] = {.lex_state = 96, .external_lex_state = 2},
  [3844] = {.lex_state = 12, .external_lex_state = 2},
  [3845] = {.lex_state = 96, .external_lex_state = 2},
  [3846] = {.lex_state = 96, .external_lex_state = 2},
  [3847] = {.lex_state = 96, .external_lex_state = 2},
  [3848] = {.lex_state = 96, .external_lex_state = 2},
  [3849] = {.lex_state = 96, .external_lex_state = 2},
  [3850] = {.lex_state = 96, .external_lex_state = 6},
  [3851] = {.lex_state = 12, .external_lex_state = 2},
  [3852] = {.lex_state = 96, .external_lex_state = 5},
  [3853] = {.lex_state = 96, .external_lex_state = 5},
  [3854] = {.lex_state = 96, .external_lex_state = 5},
  [3855] = {.lex_state = 96, .external_lex_state = 5},
  [3856] = {.lex_state = 12, .external_lex_state = 2},
  [3857] = {.lex_state = 12, .external_lex_state = 2},
  [3858] = {.lex_state = 12, .external_lex_state = 2},
  [3859] = {.lex_state = 12, .external_lex_state = 2},
  [3860] = {.lex_state = 96, .external_lex_state = 6},
  [3861] = {.lex_state = 12, .external_lex_state = 2},
  [3862] = {.lex_state = 96, .external_lex_state = 6},
  [3863] = {.lex_state = 96, .external_lex_state = 6},
  [3864] = {.lex_state = 12, .external_lex_state = 2},
  [3865] = {.lex_state = 12, .external_lex_state = 2},
  [3866] = {.lex_state = 12, .external_lex_state = 2},
  [3867] = {.lex_state = 96, .external_lex_state = 6},
  [3868] = {.lex_state = 12, .external_lex_state = 2},
  [3869] = {.lex_state = 96, .external_lex_state = 6},
  [3870] = {.lex_state = 18, .external_lex_state = 7},
  [3871] = {.lex_state = 96, .external_lex_state = 2},
  [3872] = {.lex_state = 12, .external_lex_state = 2},
  [3873] = {.lex_state = 12, .external_lex_state = 2},
  [3874] = {.lex_state = 96, .external_lex_state = 6},
  [3875] = {.lex_state = 96, .external_lex_state = 6},
  [3876] = {.lex_state = 18, .external_lex_state = 7},
  [3877] = {.lex_state = 96, .external_lex_state = 2},
  [3878] = {.lex_state = 96, .external_lex_state = 2},
  [3879] = {.lex_state = 12, .external_lex_state = 2},
  [3880] = {.lex_state = 96, .external_lex_state = 6},
  [3881] = {.lex_state = 96, .external_lex_state = 2},
  [3882] = {.lex_state = 96, .external_lex_state = 6},
  [3883] = {.lex_state = 96, .external_lex_state = 2},
  [3884] = {.lex_state = 96, .external_lex_state = 6},
  [3885] = {.lex_state = 12, .external_lex_state = 2},
  [3886] = {.lex_state = 96, .external_lex_state = 6},
  [3887] = {.lex_state = 12, .external_lex_state = 2},
  [3888] = {.lex_state = 96, .external_lex_state = 2},
  [3889] = {.lex_state = 12, .external_lex_state = 2},
  [3890] = {.lex_state = 96, .external_lex_state = 2},
  [3891] = {.lex_state = 12, .external_lex_state = 2},
  [3892] = {.lex_state = 18, .external_lex_state = 7},
  [3893] = {.lex_state = 96, .external_lex_state = 2},
  [3894] = {.lex_state = 12, .external_lex_state = 2},
  [3895] = {.lex_state = 96, .external_lex_state = 2},
  [3896] = {.lex_state = 12, .external_lex_state = 2},
  [3897] = {.lex_state = 12, .external_lex_state = 2},
  [3898] = {.lex_state = 12, .external_lex_state = 2},
  [3899] = {.lex_state = 12, .external_lex_state = 2},
  [3900] = {.lex_state = 96, .external_lex_state = 2},
  [3901] = {.lex_state = 18, .external_lex_state = 7},
  [3902] = {.lex_state = 96, .external_lex_state = 5},
  [3903] = {.lex_state = 96, .external_lex_state = 2},
  [3904] = {.lex_state = 12, .external_lex_state = 2},
  [3905] = {.lex_state = 96, .external_lex_state = 2},
  [3906] = {.lex_state = 96, .external_lex_state = 6},
  [3907] = {.lex_state = 96, .external_lex_state = 5},
  [3908] = {.lex_state = 96, .external_lex_state = 5},
  [3909] = {.lex_state = 96, .external_lex_state = 5},
  [3910] = {.lex_state = 96, .external_lex_state = 2},
  [3911] = {.lex_state = 96, .external_lex_state = 5},
  [3912] = {.lex_state = 96, .external_lex_state = 5},
  [3913] = {.lex_state = 96, .external_lex_state = 5},
  [3914] = {.lex_state = 96, .external_lex_state = 5},
  [3915] = {.lex_state = 96, .external_lex_state = 5},
  [3916] = {.lex_state = 96, .external_lex_state = 5},
  [3917] = {.lex_state = 96, .external_lex_state = 5},
  [3918] = {.lex_state = 96, .external_lex_state = 5},
  [3919] = {.lex_state = 96, .external_lex_state = 5},
  [3920] = {.lex_state = 96, .external_lex_state = 2},
  [3921] = {.lex_state = 96, .external_lex_state = 2},
  [3922] = {.lex_state = 18, .external_lex_state = 8},
  [3923] = {.lex_state = 96, .external_lex_state = 5},
  [3924] = {.lex_state = 96, .external_lex_state = 5},
  [3925] = {.lex_state = 96, .external_lex_state = 5},
  [3926] = {.lex_state = 96, .external_lex_state = 2},
  [3927] = {.lex_state = 96, .external_lex_state = 2},
  [3928] = {.lex_state = 96, .external_lex_state = 2},
  [3929] = {.lex_state = 96, .external_lex_state = 5},
  [3930] = {.lex_state = 96, .external_lex_state = 2},
  [3931] = {.lex_state = 96, .external_lex_state = 5},
  [3932] = {.lex_state = 96, .external_lex_state = 6},
  [3933] = {.lex_state = 96, .external_lex_state = 5},
  [3934] = {.lex_state = 96, .external_lex_state = 5},
  [3935] = {.lex_state = 96, .external_lex_state = 5},
  [3936] = {.lex_state = 18, .external_lex_state = 8},
  [3937] = {.lex_state = 96, .external_lex_state = 2},
  [3938] = {.lex_state = 18, .external_lex_state = 8},
  [3939] = {.lex_state = 96, .external_lex_state = 5},
  [3940] = {.lex_state = 4, .external_lex_state = 2},
  [3941] = {.lex_state = 96, .external_lex_state = 5},
  [3942] = {.lex_state = 96, .external_lex_state = 5},
  [3943] = {.lex_state = 96, .external_lex_state = 5},
  [3944] = {.lex_state = 96, .external_lex_state = 5},
  [3945] = {.lex_state = 96, .external_lex_state = 5},
  [3946] = {.lex_state = 96, .external_lex_state = 5},
  [3947] = {.lex_state = 96, .external_lex_state = 5},
  [3948] = {.lex_state = 96, .external_lex_state = 6},
  [3949] = {.lex_state = 96, .external_lex_state = 5},
  [3950] = {.lex_state = 96, .external_lex_state = 5},
  [3951] = {.lex_state = 12, .external_lex_state = 2},
  [3952] = {.lex_state = 96, .external_lex_state = 6},
  [3953] = {.lex_state = 96, .external_lex_state = 5},
  [3954] = {.lex_state = 96, .external_lex_state = 5},
  [3955] = {.lex_state = 96, .external_lex_state = 5},
  [3956] = {.lex_state = 96, .external_lex_state = 2},
  [3957] = {.lex_state = 96, .external_lex_state = 2},
  [3958] = {.lex_state = 96, .external_lex_state = 2},
  [3959] = {.lex_state = 96, .external_lex_state = 5},
  [3960] = {.lex_state = 96, .external_lex_state = 2},
  [3961] = {.lex_state = 96, .external_lex_state = 6},
  [3962] = {.lex_state = 96, .external_lex_state = 5},
  [3963] = {.lex_state = 96, .external_lex_state = 6},
  [3964] = {.lex_state = 96, .external_lex_state = 5},
  [3965] = {.lex_state = 96, .external_lex_state = 5},
  [3966] = {.lex_state = 96, .external_lex_state = 5},
  [3967] = {.lex_state = 12, .external_lex_state = 2},
  [3968] = {.lex_state = 12, .external_lex_state = 2},
  [3969] = {.lex_state = 96, .external_lex_state = 5},
  [3970] = {.lex_state = 12, .external_lex_state = 2},
  [3971] = {.lex_state = 96, .external_lex_state = 2},
  [3972] = {.lex_state = 96, .external_lex_state = 5},
  [3973] = {.lex_state = 96, .external_lex_state = 5},
  [3974] = {.lex_state = 96, .external_lex_state = 6},
  [3975] = {.lex_state = 96, .external_lex_state = 5},
  [3976] = {.lex_state = 96, .external_lex_state = 5},
  [3977] = {.lex_state = 96, .external_lex_state = 5},
  [3978] = {.lex_state = 96, .external_lex_state = 5},
  [3979] = {.lex_state = 96, .external_lex_state = 5},
  [3980] = {.lex_state = 96, .external_lex_state = 5},
  [3981] = {.lex_state = 12, .external_lex_state = 2},
  [3982] = {.lex_state = 96, .external_lex_state = 5},
  [3983] = {.lex_state = 96, .external_lex_state = 5},
  [3984] = {.lex_state = 96, .external_lex_state = 5},
  [3985] = {.lex_state = 12, .external_lex_state = 2},
  [3986] = {.lex_state = 96, .external_lex_state = 5},
  [3987] = {.lex_state = 96, .external_lex_state = 5},
  [3988] = {.lex_state = 12, .external_lex_state = 2},
  [3989] = {.lex_state = 12, .external_lex_state = 2},
  [3990] = {.lex_state = 12, .external_lex_state = 2},
  [3991] = {.lex_state = 96, .external_lex_state = 5},
  [3992] = {.lex_state = 96, .external_lex_state = 5},
  [3993] = {.lex_state = 96, .external_lex_state = 5},
  [3994] = {.lex_state = 96, .external_lex_state = 5},
  [3995] = {.lex_state = 96, .external_lex_state = 5},
  [3996] = {.lex_state = 96, .external_lex_state = 2},
  [3997] = {.lex_state = 96, .external_lex_state = 2},
  [3998] = {.lex_state = 96, .external_lex_state = 2},
  [3999] = {.lex_state = 96, .external_lex_state = 5},
  [4000] = {.lex_state = 96, .external_lex_state = 5},
  [4001] = {.lex_state = 96, .external_lex_state = 5},
  [4002] = {.lex_state = 96, .external_lex_state = 5},
  [4003] = {.lex_state = 12, .external_lex_state = 2},
  [4004] = {.lex_state = 96, .external_lex_state = 5},
  [4005] = {.lex_state = 96, .external_lex_state = 5},
  [4006] = {.lex_state = 96, .external_lex_state = 5},
  [4007] = {.lex_state = 96, .external_lex_state = 2},
  [4008] = {.lex_state = 96, .external_lex_state = 5},
  [4009] = {.lex_state = 96, .external_lex_state = 5},
  [4010] = {.lex_state = 96, .external_lex_state = 5},
  [4011] = {.lex_state = 12, .external_lex_state = 2},
  [4012] = {.lex_state = 96, .external_lex_state = 6},
  [4013] = {.lex_state = 96, .external_lex_state = 5},
  [4014] = {.lex_state = 18, .external_lex_state = 8},
  [4015] = {.lex_state = 12, .external_lex_state = 2},
  [4016] = {.lex_state = 96, .external_lex_state = 5},
  [4017] = {.lex_state = 12, .external_lex_state = 2},
  [4018] = {.lex_state = 96, .external_lex_state = 6},
  [4019] = {.lex_state = 96, .external_lex_state = 5},
  [4020] = {.lex_state = 96, .external_lex_state = 5},
  [4021] = {.lex_state = 18, .external_lex_state = 8},
  [4022] = {.lex_state = 96, .external_lex_state = 5},
  [4023] = {.lex_state = 96, .external_lex_state = 5},
  [4024] = {.lex_state = 96, .external_lex_state = 6},
  [4025] = {.lex_state = 96, .external_lex_state = 5},
  [4026] = {.lex_state = 96, .external_lex_state = 5},
  [4027] = {.lex_state = 96, .external_lex_state = 5},
  [4028] = {.lex_state = 96, .external_lex_state = 2},
  [4029] = {.lex_state = 96, .external_lex_state = 5},
  [4030] = {.lex_state = 96, .external_lex_state = 5},
  [4031] = {.lex_state = 96, .external_lex_state = 5},
  [4032] = {.lex_state = 12, .external_lex_state = 2},
  [4033] = {.lex_state = 96, .external_lex_state = 5},
  [4034] = {.lex_state = 96, .external_lex_state = 5},
  [4035] = {.lex_state = 96, .external_lex_state = 5},
  [4036] = {.lex_state = 96, .external_lex_state = 5},
  [4037] = {.lex_state = 96, .external_lex_state = 6},
  [4038] = {.lex_state = 96, .external_lex_state = 5},
  [4039] = {.lex_state = 12, .external_lex_state = 2},
  [4040] = {.lex_state = 96, .external_lex_state = 5},
  [4041] = {.lex_state = 96, .external_lex_state = 5},
  [4042] = {.lex_state = 96, .external_lex_state = 5},
  [4043] = {.lex_state = 96, .external_lex_state = 5},
  [4044] = {.lex_state = 96, .external_lex_state = 5},
  [4045] = {.lex_state = 96, .external_lex_state = 5},
  [4046] = {.lex_state = 96, .external_lex_state = 5},
  [4047] = {.lex_state = 96, .external_lex_state = 5},
  [4048] = {.lex_state = 96, .external_lex_state = 5},
  [4049] = {.lex_state = 96, .external_lex_state = 5},
  [4050] = {.lex_state = 18, .external_lex_state = 8},
  [4051] = {.lex_state = 96, .external_lex_state = 5},
  [4052] = {.lex_state = 96, .external_lex_state = 5},
  [4053] = {.lex_state = 96, .external_lex_state = 5},
  [4054] = {.lex_state = 18, .external_lex_state = 8},
  [4055] = {.lex_state = 96, .external_lex_state = 5},
  [4056] = {.lex_state = 96, .external_lex_state = 5},
  [4057] = {.lex_state = 96, .external_lex_state = 2},
  [4058] = {.lex_state = 96, .external_lex_state = 6},
  [4059] = {.lex_state = 96, .external_lex_state = 5},
  [4060] = {.lex_state = 96, .external_lex_state = 6},
  [4061] = {.lex_state = 96, .external_lex_state = 6},
  [4062] = {.lex_state = 96, .external_lex_state = 5},
  [4063] = {.lex_state = 96, .external_lex_state = 5},
  [4064] = {.lex_state = 96, .external_lex_state = 5},
  [4065] = {.lex_state = 96, .external_lex_state = 5},
  [4066] = {.lex_state = 96, .external_lex_state = 5},
  [4067] = {.lex_state = 96, .external_lex_state = 5},
  [4068] = {.lex_state = 96, .external_lex_state = 5},
  [4069] = {.lex_state = 96, .external_lex_state = 5},
  [4070] = {.lex_state = 96, .external_lex_state = 5},
  [4071] = {.lex_state = 96, .external_lex_state = 5},
  [4072] = {.lex_state = 96, .external_lex_state = 5},
  [4073] = {.lex_state = 96, .external_lex_state = 5},
  [4074] = {.lex_state = 12, .external_lex_state = 2},
  [4075] = {.lex_state = 96, .external_lex_state = 5},
  [4076] = {.lex_state = 96, .external_lex_state = 2},
  [4077] = {.lex_state = 96, .external_lex_state = 5},
  [4078] = {.lex_state = 96, .external_lex_state = 5},
  [4079] = {.lex_state = 96, .external_lex_state = 5},
  [4080] = {.lex_state = 18, .external_lex_state = 8},
  [4081] = {.lex_state = 96, .external_lex_state = 5},
  [4082] = {.lex_state = 96, .external_lex_state = 5},
  [4083] = {.lex_state = 18, .external_lex_state = 8},
  [4084] = {.lex_state = 96, .external_lex_state = 2},
  [4085] = {.lex_state = 96, .external_lex_state = 2},
  [4086] = {.lex_state = 96, .external_lex_state = 5},
  [4087] = {.lex_state = 96, .external_lex_state = 5},
  [4088] = {.lex_state = 12, .external_lex_state = 2},
  [4089] = {.lex_state = 96, .external_lex_state = 2},
  [4090] = {.lex_state = 96, .external_lex_state = 5},
  [4091] = {.lex_state = 96, .external_lex_state = 5},
  [4092] = {.lex_state = 96, .external_lex_state = 5},
  [4093] = {.lex_state = 96, .external_lex_state = 5},
  [4094] = {.lex_state = 96, .external_lex_state = 5},
  [4095] = {.lex_state = 12, .external_lex_state = 2},
  [4096] = {.lex_state = 96, .external_lex_state = 5},
  [4097] = {.lex_state = 96, .external_lex_state = 2},
  [4098] = {.lex_state = 96, .external_lex_state = 5},
  [4099] = {.lex_state = 12, .external_lex_state = 2},
  [4100] = {.lex_state = 96, .external_lex_state = 5},
  [4101] = {.lex_state = 96, .external_lex_state = 2},
  [4102] = {.lex_state = 96, .external_lex_state = 5},
  [4103] = {.lex_state = 96, .external_lex_state = 5},
  [4104] = {.lex_state = 96, .external_lex_state = 5},
  [4105] = {.lex_state = 96, .external_lex_state = 5},
  [4106] = {.lex_state = 96, .external_lex_state = 5},
  [4107] = {.lex_state = 96, .external_lex_state = 2},
  [4108] = {.lex_state = 96, .external_lex_state = 5},
  [4109] = {.lex_state = 96, .external_lex_state = 5},
  [4110] = {.lex_state = 12, .external_lex_state = 2},
  [4111] = {.lex_state = 96, .external_lex_state = 5},
  [4112] = {.lex_state = 96, .external_lex_state = 2},
  [4113] = {.lex_state = 96, .external_lex_state = 5},
  [4114] = {.lex_state = 96, .external_lex_state = 2},
  [4115] = {.lex_state = 18, .external_lex_state = 8},
  [4116] = {.lex_state = 96, .external_lex_state = 2},
  [4117] = {.lex_state = 96, .external_lex_state = 5},
  [4118] = {.lex_state = 96, .external_lex_state = 5},
  [4119] = {.lex_state = 12, .external_lex_state = 2},
  [4120] = {.lex_state = 96, .external_lex_state = 5},
  [4121] = {.lex_state = 96, .external_lex_state = 5},
  [4122] = {.lex_state = 96, .external_lex_state = 5},
  [4123] = {.lex_state = 96, .external_lex_state = 5},
  [4124] = {.lex_state = 96, .external_lex_state = 5},
  [4125] = {.lex_state = 12, .external_lex_state = 2},
  [4126] = {.lex_state = 96, .external_lex_state = 5},
  [4127] = {.lex_state = 96, .external_lex_state = 5},
  [4128] = {.lex_state = 96, .external_lex_state = 5},
  [4129] = {.lex_state = 96, .external_lex_state = 2},
  [4130] = {.lex_state = 96, .external_lex_state = 2},
  [4131] = {.lex_state = 96, .external_lex_state = 5},
  [4132] = {.lex_state = 12, .external_lex_state = 2},
  [4133] = {.lex_state = 12, .external_lex_state = 2},
  [4134] = {.lex_state = 96, .external_lex_state = 5},
  [4135] = {.lex_state = 96, .external_lex_state = 2},
  [4136] = {.lex_state = 12, .external_lex_state = 2},
  [4137] = {.lex_state = 96, .external_lex_state = 5},
  [4138] = {.lex_state = 12, .external_lex_state = 2},
  [4139] = {.lex_state = 12, .external_lex_state = 2},
  [4140] = {.lex_state = 15, .external_lex_state = 2},
  [4141] = {.lex_state = 96, .external_lex_state = 5},
  [4142] = {.lex_state = 96, .external_lex_state = 2},
  [4143] = {.lex_state = 12, .external_lex_state = 2},
  [4144] = {.lex_state = 12, .external_lex_state = 2},
  [4145] = {.lex_state = 96, .external_lex_state = 5},
  [4146] = {.lex_state = 96, .external_lex_state = 5},
  [4147] = {.lex_state = 96, .external_lex_state = 5},
  [4148] = {.lex_state = 96, .external_lex_state = 5},
  [4149] = {.lex_state = 96, .external_lex_state = 5},
  [4150] = {.lex_state = 96, .external_lex_state = 5},
  [4151] = {.lex_state = 96, .external_lex_state = 5},
  [4152] = {.lex_state = 96, .external_lex_state = 5},
  [4153] = {.lex_state = 96, .external_lex_state = 5},
  [4154] = {.lex_state = 96, .external_lex_state = 5},
  [4155] = {.lex_state = 96, .external_lex_state = 5},
  [4156] = {.lex_state = 96, .external_lex_state = 5},
  [4157] = {.lex_state = 96, .external_lex_state = 5},
  [4158] = {.lex_state = 96, .external_lex_state = 5},
  [4159] = {.lex_state = 96, .external_lex_state = 5},
  [4160] = {.lex_state = 96, .external_lex_state = 5},
  [4161] = {.lex_state = 96, .external_lex_state = 2},
  [4162] = {.lex_state = 96, .external_lex_state = 5},
  [4163] = {.lex_state = 96, .external_lex_state = 5},
  [4164] = {.lex_state = 12, .external_lex_state = 2},
  [4165] = {.lex_state = 96, .external_lex_state = 5},
  [4166] = {.lex_state = 12, .external_lex_state = 2},
  [4167] = {.lex_state = 96, .external_lex_state = 5},
  [4168] = {.lex_state = 12, .external_lex_state = 2},
  [4169] = {.lex_state = 12, .external_lex_state = 2},
  [4170] = {.lex_state = 96, .external_lex_state = 5},
  [4171] = {.lex_state = 96, .external_lex_state = 5},
  [4172] = {.lex_state = 12, .external_lex_state = 2},
  [4173] = {.lex_state = 96, .external_lex_state = 5},
  [4174] = {.lex_state = 96, .external_lex_state = 5},
  [4175] = {.lex_state = 96, .external_lex_state = 5},
  [4176] = {.lex_state = 96, .external_lex_state = 5},
  [4177] = {.lex_state = 96, .external_lex_state = 2},
  [4178] = {.lex_state = 12, .external_lex_state = 2},
  [4179] = {.lex_state = 12, .external_lex_state = 2},
  [4180] = {.lex_state = 96, .external_lex_state = 5},
  [4181] = {.lex_state = 96, .external_lex_state = 5},
  [4182] = {.lex_state = 96, .external_lex_state = 5},
  [4183] = {.lex_state = 96, .external_lex_state = 5},
  [4184] = {.lex_state = 96, .external_lex_state = 2},
  [4185] = {.lex_state = 96, .external_lex_state = 5},
  [4186] = {.lex_state = 96, .external_lex_state = 5},
  [4187] = {.lex_state = 96, .external_lex_state = 5},
  [4188] = {.lex_state = 12, .external_lex_state = 2},
  [4189] = {.lex_state = 96, .external_lex_state = 5},
  [4190] = {.lex_state = 96, .external_lex_state = 5},
  [4191] = {.lex_state = 12, .external_lex_state = 2},
  [4192] = {.lex_state = 12, .external_lex_state = 2},
  [4193] = {.lex_state = 96, .external_lex_state = 6},
  [4194] = {.lex_state = 12, .external_lex_state = 2},
  [4195] = {.lex_state = 96, .external_lex_state = 5},
  [4196] = {.lex_state = 96, .external_lex_state = 5},
  [4197] = {.lex_state = 12, .external_lex_state = 2},
  [4198] = {.lex_state = 96, .external_lex_state = 5},
  [4199] = {.lex_state = 96, .external_lex_state = 5},
  [4200] = {.lex_state = 96, .external_lex_state = 5},
  [4201] = {.lex_state = 96, .external_lex_state = 5},
  [4202] = {.lex_state = 96, .external_lex_state = 5},
  [4203] = {.lex_state = 12, .external_lex_state = 2},
  [4204] = {.lex_state = 96, .external_lex_state = 5},
  [4205] = {.lex_state = 96, .external_lex_state = 5},
  [4206] = {.lex_state = 96, .external_lex_state = 5},
  [4207] = {.lex_state = 12, .external_lex_state = 2},
  [4208] = {.lex_state = 96, .external_lex_state = 5},
  [4209] = {.lex_state = 96, .external_lex_state = 5},
  [4210] = {.lex_state = 96, .external_lex_state = 5},
  [4211] = {.lex_state = 96, .external_lex_state = 5},
  [4212] = {.lex_state = 12, .external_lex_state = 2},
  [4213] = {.lex_state = 96, .external_lex_state = 5},
  [4214] = {.lex_state = 96, .external_lex_state = 5},
  [4215] = {.lex_state = 96, .external_lex_state = 5},
  [4216] = {.lex_state = 96, .external_lex_state = 5},
  [4217] = {.lex_state = 96, .external_lex_state = 5},
  [4218] = {.lex_state = 96, .external_lex_state = 5},
  [4219] = {.lex_state = 96, .external_lex_state = 5},
  [4220] = {.lex_state = 96, .external_lex_state = 5},
  [4221] = {.lex_state = 96, .external_lex_state = 5},
  [4222] = {.lex_state = 96, .external_lex_state = 5},
  [4223] = {.lex_state = 12, .external_lex_state = 2},
  [4224] = {.lex_state = 96, .external_lex_state = 5},
  [4225] = {.lex_state = 96, .external_lex_state = 5},
  [4226] = {.lex_state = 96, .external_lex_state = 2},
  [4227] = {.lex_state = 96, .external_lex_state = 5},
  [4228] = {.lex_state = 96, .external_lex_state = 5},
  [4229] = {.lex_state = 96, .external_lex_state = 2},
  [4230] = {.lex_state = 12, .external_lex_state = 2},
  [4231] = {.lex_state = 12, .external_lex_state = 2},
  [4232] = {.lex_state = 96, .external_lex_state = 5},
  [4233] = {.lex_state = 96, .external_lex_state = 2},
  [4234] = {.lex_state = 96, .external_lex_state = 5},
  [4235] = {.lex_state = 96, .external_lex_state = 2},
  [4236] = {.lex_state = 96, .external_lex_state = 2},
  [4237] = {.lex_state = 12, .external_lex_state = 2},
  [4238] = {.lex_state = 12, .external_lex_state = 2},
  [4239] = {.lex_state = 96, .external_lex_state = 5},
  [4240] = {.lex_state = 96, .external_lex_state = 5},
  [4241] = {.lex_state = 96, .external_lex_state = 5},
  [4242] = {.lex_state = 96, .external_lex_state = 5},
  [4243] = {.lex_state = 96, .external_lex_state = 5},
  [4244] = {.lex_state = 96, .external_lex_state = 5},
  [4245] = {.lex_state = 96, .external_lex_state = 5},
  [4246] = {.lex_state = 96, .external_lex_state = 5},
  [4247] = {.lex_state = 96, .external_lex_state = 5},
  [4248] = {.lex_state = 96, .external_lex_state = 5},
  [4249] = {.lex_state = 96, .external_lex_state = 5},
  [4250] = {.lex_state = 96, .external_lex_state = 5},
  [4251] = {.lex_state = 96, .external_lex_state = 5},
  [4252] = {.lex_state = 96, .external_lex_state = 5},
  [4253] = {.lex_state = 96, .external_lex_state = 5},
  [4254] = {.lex_state = 96, .external_lex_state = 5},
  [4255] = {.lex_state = 96, .external_lex_state = 5},
  [4256] = {.lex_state = 96, .external_lex_state = 5},
  [4257] = {.lex_state = 96, .external_lex_state = 5},
  [4258] = {.lex_state = 96, .external_lex_state = 5},
  [4259] = {.lex_state = 96, .external_lex_state = 5},
  [4260] = {.lex_state = 96, .external_lex_state = 5},
  [4261] = {.lex_state = 96, .external_lex_state = 5},
  [4262] = {.lex_state = 96, .external_lex_state = 5},
  [4263] = {.lex_state = 96, .external_lex_state = 5},
  [4264] = {.lex_state = 96, .external_lex_state = 5},
  [4265] = {.lex_state = 96, .external_lex_state = 5},
  [4266] = {.lex_state = 96, .external_lex_state = 5},
  [4267] = {.lex_state = 96, .external_lex_state = 5},
  [4268] = {.lex_state = 96, .external_lex_state = 5},
  [4269] = {.lex_state = 96, .external_lex_state = 5},
  [4270] = {.lex_state = 96, .external_lex_state = 5},
  [4271] = {.lex_state = 12, .external_lex_state = 2},
  [4272] = {.lex_state = 96, .external_lex_state = 5},
  [4273] = {.lex_state = 96, .external_lex_state = 5},
  [4274] = {.lex_state = 96, .external_lex_state = 5},
  [4275] = {.lex_state = 96, .external_lex_state = 5},
  [4276] = {.lex_state = 96, .external_lex_state = 5},
  [4277] = {.lex_state = 96, .external_lex_state = 5},
  [4278] = {.lex_state = 96, .external_lex_state = 5},
  [4279] = {.lex_state = 96, .external_lex_state = 5},
  [4280] = {.lex_state = 96, .external_lex_state = 2},
  [4281] = {.lex_state = 96, .external_lex_state = 5},
  [4282] = {.lex_state = 96, .external_lex_state = 5},
  [4283] = {.lex_state = 96, .external_lex_state = 5},
  [4284] = {.lex_state = 96, .external_lex_state = 5},
  [4285] = {.lex_state = 96, .external_lex_state = 5},
  [4286] = {.lex_state = 12, .external_lex_state = 2},
  [4287] = {.lex_state = 96, .external_lex_state = 5},
  [4288] = {.lex_state = 96, .external_lex_state = 5},
  [4289] = {.lex_state = 96, .external_lex_state = 5},
  [4290] = {.lex_state = 96, .external_lex_state = 5},
  [4291] = {.lex_state = 96, .external_lex_state = 5},
  [4292] = {.lex_state = 96, .external_lex_state = 5},
  [4293] = {.lex_state = 96, .external_lex_state = 5},
  [4294] = {.lex_state = 96, .external_lex_state = 5},
  [4295] = {.lex_state = 96, .external_lex_state = 5},
  [4296] = {.lex_state = 96, .external_lex_state = 5},
  [4297] = {.lex_state = 96, .external_lex_state = 5},
  [4298] = {.lex_state = 96, .external_lex_state = 2},
  [4299] = {.lex_state = 12, .external_lex_state = 2},
  [4300] = {.lex_state = 96, .external_lex_state = 5},
  [4301] = {.lex_state = 96, .external_lex_state = 5},
  [4302] = {.lex_state = 96, .external_lex_state = 2},
  [4303] = {.lex_state = 96, .external_lex_state = 2},
  [4304] = {.lex_state = 96, .external_lex_state = 5},
  [4305] = {.lex_state = 96, .external_lex_state = 5},
  [4306] = {.lex_state = 18, .external_lex_state = 8},
  [4307] = {.lex_state = 96, .external_lex_state = 5},
  [4308] = {.lex_state = 96, .external_lex_state = 5},
  [4309] = {.lex_state = 96, .external_lex_state = 5},
  [4310] = {.lex_state = 96, .external_lex_state = 5},
  [4311] = {.lex_state = 96, .external_lex_state = 5},
  [4312] = {.lex_state = 12, .external_lex_state = 2},
  [4313] = {.lex_state = 96, .external_lex_state = 5},
  [4314] = {.lex_state = 12, .external_lex_state = 2},
  [4315] = {.lex_state = 96, .external_lex_state = 5},
  [4316] = {.lex_state = 96, .external_lex_state = 5},
  [4317] = {.lex_state = 96, .external_lex_state = 5},
  [4318] = {.lex_state = 96, .external_lex_state = 5},
  [4319] = {.lex_state = 12, .external_lex_state = 2},
  [4320] = {.lex_state = 12, .external_lex_state = 2},
  [4321] = {.lex_state = 12, .external_lex_state = 2},
  [4322] = {.lex_state = 96, .external_lex_state = 2},
  [4323] = {.lex_state = 96, .external_lex_state = 5},
  [4324] = {.lex_state = 12, .external_lex_state = 2},
  [4325] = {.lex_state = 96, .external_lex_state = 5},
  [4326] = {.lex_state = 96, .external_lex_state = 5},
  [4327] = {.lex_state = 96, .external_lex_state = 2},
  [4328] = {.lex_state = 96, .external_lex_state = 5},
  [4329] = {.lex_state = 12, .external_lex_state = 2},
  [4330] = {.lex_state = 96, .external_lex_state = 5},
  [4331] = {.lex_state = 96, .external_lex_state = 2},
  [4332] = {.lex_state = 96, .external_lex_state = 5},
  [4333] = {.lex_state = 96, .external_lex_state = 5},
  [4334] = {.lex_state = 96, .external_lex_state = 5},
  [4335] = {.lex_state = 12, .external_lex_state = 2},
  [4336] = {.lex_state = 12, .external_lex_state = 2},
  [4337] = {.lex_state = 96, .external_lex_state = 5},
  [4338] = {.lex_state = 96, .external_lex_state = 5},
  [4339] = {.lex_state = 96, .external_lex_state = 5},
  [4340] = {.lex_state = 96, .external_lex_state = 5},
  [4341] = {.lex_state = 96, .external_lex_state = 5},
  [4342] = {.lex_state = 96, .external_lex_state = 2},
  [4343] = {.lex_state = 96, .external_lex_state = 5},
  [4344] = {.lex_state = 12, .external_lex_state = 2},
  [4345] = {.lex_state = 12, .external_lex_state = 2},
  [4346] = {.lex_state = 96, .external_lex_state = 2},
  [4347] = {.lex_state = 96, .external_lex_state = 2},
  [4348] = {.lex_state = 12, .external_lex_state = 2},
  [4349] = {.lex_state = 12, .external_lex_state = 2},
  [4350] = {.lex_state = 96, .external_lex_state = 2},
  [4351] = {.lex_state = 96, .external_lex_state = 5},
  [4352] = {.lex_state = 96, .external_lex_state = 5},
  [4353] = {.lex_state = 96, .external_lex_state = 5},
  [4354] = {.lex_state = 96, .external_lex_state = 5},
  [4355] = {.lex_state = 96, .external_lex_state = 5},
  [4356] = {.lex_state = 96, .external_lex_state = 5},
  [4357] = {.lex_state = 96, .external_lex_state = 5},
  [4358] = {.lex_state = 96, .external_lex_state = 5},
  [4359] = {.lex_state = 96, .external_lex_state = 5},
  [4360] = {.lex_state = 12, .external_lex_state = 2},
  [4361] = {.lex_state = 96, .external_lex_state = 5},
  [4362] = {.lex_state = 96, .external_lex_state = 5},
  [4363] = {.lex_state = 96, .external_lex_state = 5},
  [4364] = {.lex_state = 96, .external_lex_state = 5},
  [4365] = {.lex_state = 96, .external_lex_state = 5},
  [4366] = {.lex_state = 96, .external_lex_state = 5},
  [4367] = {.lex_state = 96, .external_lex_state = 2},
  [4368] = {.lex_state = 96, .external_lex_state = 5},
  [4369] = {.lex_state = 96, .external_lex_state = 5},
  [4370] = {.lex_state = 96, .external_lex_state = 5},
  [4371] = {.lex_state = 96, .external_lex_state = 5},
  [4372] = {.lex_state = 96, .external_lex_state = 5},
  [4373] = {.lex_state = 96, .external_lex_state = 5},
  [4374] = {.lex_state = 96, .external_lex_state = 5},
  [4375] = {.lex_state = 96, .external_lex_state = 5},
  [4376] = {.lex_state = 96, .external_lex_state = 5},
  [4377] = {.lex_state = 96, .external_lex_state = 5},
  [4378] = {.lex_state = 4, .external_lex_state = 2},
  [4379] = {.lex_state = 96, .external_lex_state = 5},
  [4380] = {.lex_state = 96, .external_lex_state = 5},
  [4381] = {.lex_state = 96, .external_lex_state = 5},
  [4382] = {.lex_state = 96, .external_lex_state = 5},
  [4383] = {.lex_state = 15, .external_lex_state = 2},
  [4384] = {.lex_state = 96, .external_lex_state = 5},
  [4385] = {.lex_state = 96, .external_lex_state = 5},
  [4386] = {.lex_state = 96, .external_lex_state = 5},
  [4387] = {.lex_state = 96, .external_lex_state = 5},
  [4388] = {.lex_state = 96, .external_lex_state = 2},
  [4389] = {.lex_state = 12, .external_lex_state = 2},
  [4390] = {.lex_state = 96, .external_lex_state = 2},
  [4391] = {.lex_state = 96, .external_lex_state = 5},
  [4392] = {.lex_state = 96, .external_lex_state = 5},
  [4393] = {.lex_state = 96, .external_lex_state = 2},
  [4394] = {.lex_state = 21, .external_lex_state = 9},
  [4395] = {.lex_state = 96, .external_lex_state = 2},
  [4396] = {.lex_state = 17, .external_lex_state = 9},
  [4397] = {.lex_state = 21, .external_lex_state = 9},
  [4398] = {.lex_state = 96, .external_lex_state = 2},
  [4399] = {.lex_state = 17, .external_lex_state = 9},
  [4400] = {.lex_state = 21, .external_lex_state = 9},
  [4401] = {.lex_state = 96, .external_lex_state = 5},
  [4402] = {.lex_state = 96, .external_lex_state = 2},
  [4403] = {.lex_state = 12, .external_lex_state = 2},
  [4404] = {.lex_state = 96, .external_lex_state = 2},
  [4405] = {.lex_state = 12, .external_lex_state = 2},
  [4406] = {.lex_state = 96, .external_lex_state = 2},
  [4407] = {.lex_state = 96, .external_lex_state = 2},
  [4408] = {.lex_state = 12, .external_lex_state = 2},
  [4409] = {.lex_state = 96, .external_lex_state = 2},
  [4410] = {.lex_state = 96, .external_lex_state = 2},
  [4411] = {.lex_state = 21, .external_lex_state = 9},
  [4412] = {.lex_state = 96, .external_lex_state = 5},
  [4413] = {.lex_state = 12, .external_lex_state = 2},
  [4414] = {.lex_state = 96, .external_lex_state = 2},
  [4415] = {.lex_state = 96, .external_lex_state = 5},
  [4416] = {.lex_state = 96, .external_lex_state = 2},
  [4417] = {.lex_state = 15, .external_lex_state = 2},
  [4418] = {.lex_state = 96, .external_lex_state = 2},
  [4419] = {.lex_state = 4, .external_lex_state = 2},
  [4420] = {.lex_state = 4, .external_lex_state = 2},
  [4421] = {.lex_state = 4, .external_lex_state = 2},
  [4422] = {.lex_state = 96, .external_lex_state = 5},
  [4423] = {.lex_state = 96, .external_lex_state = 2},
  [4424] = {.lex_state = 96, .external_lex_state = 2},
  [4425] = {.lex_state = 96, .external_lex_state = 5},
  [4426] = {.lex_state = 96, .external_lex_state = 2},
  [4427] = {.lex_state = 96, .external_lex_state = 2},
  [4428] = {.lex_state = 96, .external_lex_state = 2},
  [4429] = {.lex_state = 12, .external_lex_state = 2},
  [4430] = {.lex_state = 17, .external_lex_state = 9},
  [4431] = {.lex_state = 17, .external_lex_state = 9},
  [4432] = {.lex_state = 96, .external_lex_state = 2},
  [4433] = {.lex_state = 12, .external_lex_state = 2},
  [4434] = {.lex_state = 96, .external_lex_state = 2},
  [4435] = {.lex_state = 96, .external_lex_state = 2},
  [4436] = {.lex_state = 21, .external_lex_state = 9},
  [4437] = {.lex_state = 96, .external_lex_state = 2},
  [4438] = {.lex_state = 18, .external_lex_state = 7},
  [4439] = {.lex_state = 12, .external_lex_state = 2},
  [4440] = {.lex_state = 4, .external_lex_state = 2},
  [4441] = {.lex_state = 96, .external_lex_state = 2},
  [4442] = {.lex_state = 12, .external_lex_state = 2},
  [4443] = {.lex_state = 96, .external_lex_state = 5},
  [4444] = {.lex_state = 96, .external_lex_state = 2},
  [4445] = {.lex_state = 96, .external_lex_state = 2},
  [4446] = {.lex_state = 21, .external_lex_state = 9},
  [4447] = {.lex_state = 4, .external_lex_state = 2},
  [4448] = {.lex_state = 96, .external_lex_state = 2},
  [4449] = {.lex_state = 17, .external_lex_state = 9},
  [4450] = {.lex_state = 21, .external_lex_state = 9},
  [4451] = {.lex_state = 96, .external_lex_state = 2},
  [4452] = {.lex_state = 96, .external_lex_state = 2},
  [4453] = {.lex_state = 96, .external_lex_state = 2},
  [4454] = {.lex_state = 96, .external_lex_state = 2},
  [4455] = {.lex_state = 12, .external_lex_state = 2},
  [4456] = {.lex_state = 96, .external_lex_state = 2},
  [4457] = {.lex_state = 17, .external_lex_state = 9},
  [4458] = {.lex_state = 21, .external_lex_state = 9},
  [4459] = {.lex_state = 12, .external_lex_state = 2},
  [4460] = {.lex_state = 12, .external_lex_state = 2},
  [4461] = {.lex_state = 96, .external_lex_state = 2},
  [4462] = {.lex_state = 17, .external_lex_state = 9},
  [4463] = {.lex_state = 96, .external_lex_state = 5},
  [4464] = {.lex_state = 96, .external_lex_state = 5},
  [4465] = {.lex_state = 12, .external_lex_state = 2},
  [4466] = {.lex_state = 17, .external_lex_state = 9},
  [4467] = {.lex_state = 12, .external_lex_state = 2},
  [4468] = {.lex_state = 96, .external_lex_state = 2},
  [4469] = {.lex_state = 21, .external_lex_state = 9},
  [4470] = {.lex_state = 96, .external_lex_state = 5},
  [4471] = {.lex_state = 96, .external_lex_state = 2},
  [4472] = {.lex_state = 96, .external_lex_state = 2},
  [4473] = {.lex_state = 12, .external_lex_state = 2},
  [4474] = {.lex_state = 17, .external_lex_state = 9},
  [4475] = {.lex_state = 96, .external_lex_state = 2},
  [4476] = {.lex_state = 96, .external_lex_state = 2},
  [4477] = {.lex_state = 96, .external_lex_state = 2},
  [4478] = {.lex_state = 96, .external_lex_state = 2},
  [4479] = {.lex_state = 96, .external_lex_state = 5},
  [4480] = {.lex_state = 15, .external_lex_state = 2},
  [4481] = {.lex_state = 96, .external_lex_state = 2},
  [4482] = {.lex_state = 96, .external_lex_state = 2},
  [4483] = {.lex_state = 96, .external_lex_state = 2},
  [4484] = {.lex_state = 96, .external_lex_state = 5},
  [4485] = {.lex_state = 96, .external_lex_state = 6},
  [4486] = {.lex_state = 17, .external_lex_state = 9},
  [4487] = {.lex_state = 96, .external_lex_state = 2},
  [4488] = {.lex_state = 96, .external_lex_state = 2},
  [4489] = {.lex_state = 96, .external_lex_state = 2},
  [4490] = {.lex_state = 12, .external_lex_state = 2},
  [4491] = {.lex_state = 21, .external_lex_state = 9},
  [4492] = {.lex_state = 17, .external_lex_state = 9},
  [4493] = {.lex_state = 17, .external_lex_state = 9},
  [4494] = {.lex_state = 12, .external_lex_state = 2},
  [4495] = {.lex_state = 21, .external_lex_state = 9},
  [4496] = {.lex_state = 12, .external_lex_state = 2},
  [4497] = {.lex_state = 17, .external_lex_state = 9},
  [4498] = {.lex_state = 21, .external_lex_state = 9},
  [4499] = {.lex_state = 96, .external_lex_state = 2},
  [4500] = {.lex_state = 96, .external_lex_state = 2},
  [4501] = {.lex_state = 17, .external_lex_state = 9},
  [4502] = {.lex_state = 96, .external_lex_state = 2},
  [4503] = {.lex_state = 21, .external_lex_state = 9},
  [4504] = {.lex_state = 18, .external_lex_state = 7},
  [4505] = {.lex_state = 96, .external_lex_state = 2},
  [4506] = {.lex_state = 17, .external_lex_state = 9},
  [4507] = {.lex_state = 96, .external_lex_state = 2},
  [4508] = {.lex_state = 96, .external_lex_state = 2},
  [4509] = {.lex_state = 96, .external_lex_state = 5},
  [4510] = {.lex_state = 21, .external_lex_state = 9},
  [4511] = {.lex_state = 96, .external_lex_state = 2},
  [4512] = {.lex_state = 12, .external_lex_state = 2},
  [4513] = {.lex_state = 21, .external_lex_state = 9},
  [4514] = {.lex_state = 12, .external_lex_state = 2},
  [4515] = {.lex_state = 96, .external_lex_state = 5},
  [4516] = {.lex_state = 12, .external_lex_state = 2},
  [4517] = {.lex_state = 96, .external_lex_state = 5},
  [4518] = {.lex_state = 96, .external_lex_state = 2},
  [4519] = {.lex_state = 12, .external_lex_state = 2},
  [4520] = {.lex_state = 12, .external_lex_state = 2},
  [4521] = {.lex_state = 96, .external_lex_state = 2},
  [4522] = {.lex_state = 96, .external_lex_state = 2},
  [4523] = {.lex_state = 96, .external_lex_state = 2},
  [4524] = {.lex_state = 96, .external_lex_state = 2},
  [4525] = {.lex_state = 12, .external_lex_state = 2},
  [4526] = {.lex_state = 96, .external_lex_state = 2},
  [4527] = {.lex_state = 96, .external_lex_state = 2},
  [4528] = {.lex_state = 96, .external_lex_state = 2},
  [4529] = {.lex_state = 96, .external_lex_state = 2},
  [4530] = {.lex_state = 96, .external_lex_state = 5},
  [4531] = {.lex_state = 96, .external_lex_state = 5},
  [4532] = {.lex_state = 96, .external_lex_state = 5},
  [4533] = {.lex_state = 96, .external_lex_state = 5},
  [4534] = {.lex_state = 96, .external_lex_state = 2},
  [4535] = {.lex_state = 96, .external_lex_state = 2},
  [4536] = {.lex_state = 96, .external_lex_state = 5},
  [4537] = {.lex_state = 96, .external_lex_state = 2},
  [4538] = {.lex_state = 96, .external_lex_state = 5},
  [4539] = {.lex_state = 96, .external_lex_state = 2},
  [4540] = {.lex_state = 96, .external_lex_state = 5},
  [4541] = {.lex_state = 96, .external_lex_state = 2},
  [4542] = {.lex_state = 96, .external_lex_state = 2},
  [4543] = {.lex_state = 96, .external_lex_state = 5},
  [4544] = {.lex_state = 96, .external_lex_state = 2},
  [4545] = {.lex_state = 96, .external_lex_state = 2},
  [4546] = {.lex_state = 96, .external_lex_state = 2},
  [4547] = {.lex_state = 96, .external_lex_state = 2},
  [4548] = {.lex_state = 96, .external_lex_state = 2},
  [4549] = {.lex_state = 96, .external_lex_state = 2},
  [4550] = {.lex_state = 96, .external_lex_state = 2},
  [4551] = {.lex_state = 96, .external_lex_state = 2},
  [4552] = {.lex_state = 96, .external_lex_state = 5},
  [4553] = {.lex_state = 96, .external_lex_state = 2},
  [4554] = {.lex_state = 96, .external_lex_state = 2},
  [4555] = {.lex_state = 96, .external_lex_state = 5},
  [4556] = {.lex_state = 96, .external_lex_state = 2},
  [4557] = {.lex_state = 96, .external_lex_state = 2},
  [4558] = {.lex_state = 96, .external_lex_state = 2},
  [4559] = {.lex_state = 96, .external_lex_state = 5},
  [4560] = {.lex_state = 96, .external_lex_state = 5},
  [4561] = {.lex_state = 96, .external_lex_state = 5},
  [4562] = {.lex_state = 4, .external_lex_state = 2},
  [4563] = {.lex_state = 96, .external_lex_state = 2},
  [4564] = {.lex_state = 96, .external_lex_state = 2},
  [4565] = {.lex_state = 96, .external_lex_state = 5},
  [4566] = {.lex_state = 96, .external_lex_state = 2},
  [4567] = {.lex_state = 96, .external_lex_state = 2},
  [4568] = {.lex_state = 96, .external_lex_state = 5},
  [4569] = {.lex_state = 96, .external_lex_state = 5},
  [4570] = {.lex_state = 96, .external_lex_state = 5},
  [4571] = {.lex_state = 96, .external_lex_state = 2},
  [4572] = {.lex_state = 96, .external_lex_state = 5},
  [4573] = {.lex_state = 96, .external_lex_state = 5},
  [4574] = {.lex_state = 96, .external_lex_state = 5},
  [4575] = {.lex_state = 96, .external_lex_state = 5},
  [4576] = {.lex_state = 96, .external_lex_state = 5},
  [4577] = {.lex_state = 96, .external_lex_state = 2},
  [4578] = {.lex_state = 96, .external_lex_state = 2},
  [4579] = {.lex_state = 96, .external_lex_state = 2},
  [4580] = {.lex_state = 96, .external_lex_state = 2},
  [4581] = {.lex_state = 96, .external_lex_state = 5},
  [4582] = {.lex_state = 96, .external_lex_state = 5},
  [4583] = {.lex_state = 96, .external_lex_state = 5},
  [4584] = {.lex_state = 96, .external_lex_state = 2},
  [4585] = {.lex_state = 96, .external_lex_state = 5},
  [4586] = {.lex_state = 96, .external_lex_state = 5},
  [4587] = {.lex_state = 96, .external_lex_state = 2},
  [4588] = {.lex_state = 96, .external_lex_state = 2},
  [4589] = {.lex_state = 96, .external_lex_state = 5},
  [4590] = {.lex_state = 96, .external_lex_state = 5},
  [4591] = {.lex_state = 96, .external_lex_state = 5},
  [4592] = {.lex_state = 96, .external_lex_state = 2},
  [4593] = {.lex_state = 96, .external_lex_state = 2},
  [4594] = {.lex_state = 96, .external_lex_state = 2},
  [4595] = {.lex_state = 96, .external_lex_state = 2},
  [4596] = {.lex_state = 96, .external_lex_state = 2},
  [4597] = {.lex_state = 96, .external_lex_state = 5},
  [4598] = {.lex_state = 96, .external_lex_state = 5},
  [4599] = {.lex_state = 96, .external_lex_state = 5},
  [4600] = {.lex_state = 96, .external_lex_state = 2},
  [4601] = {.lex_state = 96, .external_lex_state = 2},
  [4602] = {.lex_state = 96, .external_lex_state = 2},
  [4603] = {.lex_state = 96, .external_lex_state = 2},
  [4604] = {.lex_state = 96, .external_lex_state = 5},
  [4605] = {.lex_state = 96, .external_lex_state = 2},
  [4606] = {.lex_state = 96, .external_lex_state = 2},
  [4607] = {.lex_state = 96, .external_lex_state = 2},
  [4608] = {.lex_state = 96, .external_lex_state = 5},
  [4609] = {.lex_state = 96, .external_lex_state = 2},
  [4610] = {.lex_state = 96, .external_lex_state = 5},
  [4611] = {.lex_state = 96, .external_lex_state = 5},
  [4612] = {.lex_state = 4, .external_lex_state = 2},
  [4613] = {.lex_state = 1, .external_lex_state = 2},
  [4614] = {.lex_state = 96, .external_lex_state = 5},
  [4615] = {.lex_state = 96, .external_lex_state = 2},
  [4616] = {.lex_state = 96, .external_lex_state = 5},
  [4617] = {.lex_state = 96, .external_lex_state = 2},
  [4618] = {.lex_state = 96, .external_lex_state = 5},
  [4619] = {.lex_state = 96, .external_lex_state = 5},
  [4620] = {.lex_state = 96, .external_lex_state = 5},
  [4621] = {.lex_state = 96, .external_lex_state = 5},
  [4622] = {.lex_state = 96, .external_lex_state = 2},
  [4623] = {.lex_state = 96, .external_lex_state = 5},
  [4624] = {.lex_state = 96, .external_lex_state = 5},
  [4625] = {.lex_state = 96, .external_lex_state = 5},
  [4626] = {.lex_state = 96, .external_lex_state = 5},
  [4627] = {.lex_state = 96, .external_lex_state = 2},
  [4628] = {.lex_state = 96, .external_lex_state = 5},
  [4629] = {.lex_state = 96, .external_lex_state = 2},
  [4630] = {.lex_state = 96, .external_lex_state = 5},
  [4631] = {.lex_state = 96, .external_lex_state = 5},
  [4632] = {.lex_state = 1, .external_lex_state = 2},
  [4633] = {.lex_state = 96, .external_lex_state = 5},
  [4634] = {.lex_state = 96, .external_lex_state = 5},
  [4635] = {.lex_state = 96, .external_lex_state = 2},
  [4636] = {.lex_state = 96, .external_lex_state = 5},
  [4637] = {.lex_state = 96, .external_lex_state = 2},
  [4638] = {.lex_state = 96, .external_lex_state = 2},
  [4639] = {.lex_state = 96, .external_lex_state = 2},
  [4640] = {.lex_state = 96, .external_lex_state = 2},
  [4641] = {.lex_state = 96, .external_lex_state = 2},
  [4642] = {.lex_state = 96, .external_lex_state = 5},
  [4643] = {.lex_state = 96, .external_lex_state = 5},
  [4644] = {.lex_state = 96, .external_lex_state = 2},
  [4645] = {.lex_state = 96, .external_lex_state = 2},
  [4646] = {.lex_state = 96, .external_lex_state = 5},
  [4647] = {.lex_state = 96, .external_lex_state = 5},
  [4648] = {.lex_state = 96, .external_lex_state = 2},
  [4649] = {.lex_state = 96, .external_lex_state = 2},
  [4650] = {.lex_state = 96, .external_lex_state = 5},
  [4651] = {.lex_state = 96, .external_lex_state = 2},
  [4652] = {.lex_state = 96, .external_lex_state = 5},
  [4653] = {.lex_state = 96, .external_lex_state = 2},
  [4654] = {.lex_state = 96, .external_lex_state = 2},
  [4655] = {.lex_state = 96, .external_lex_state = 5},
  [4656] = {.lex_state = 96, .external_lex_state = 5},
  [4657] = {.lex_state = 96, .external_lex_state = 2},
  [4658] = {.lex_state = 96, .external_lex_state = 5},
  [4659] = {.lex_state = 96, .external_lex_state = 5},
  [4660] = {.lex_state = 96, .external_lex_state = 5},
  [4661] = {.lex_state = 96, .external_lex_state = 2},
  [4662] = {.lex_state = 96, .external_lex_state = 5},
  [4663] = {.lex_state = 96, .external_lex_state = 5},
  [4664] = {.lex_state = 96, .external_lex_state = 5},
  [4665] = {.lex_state = 96, .external_lex_state = 5},
  [4666] = {.lex_state = 96, .external_lex_state = 2},
  [4667] = {.lex_state = 96, .external_lex_state = 2},
  [4668] = {.lex_state = 96, .external_lex_state = 2},
  [4669] = {.lex_state = 96, .external_lex_state = 5},
  [4670] = {.lex_state = 4, .external_lex_state = 2},
  [4671] = {.lex_state = 96, .external_lex_state = 5},
  [4672] = {.lex_state = 96, .external_lex_state = 5},
  [4673] = {.lex_state = 96, .external_lex_state = 2},
  [4674] = {.lex_state = 96, .external_lex_state = 5},
  [4675] = {.lex_state = 4, .external_lex_state = 2},
  [4676] = {.lex_state = 96, .external_lex_state = 2},
  [4677] = {.lex_state = 96, .external_lex_state = 2},
  [4678] = {.lex_state = 96, .external_lex_state = 5},
  [4679] = {.lex_state = 96, .external_lex_state = 2},
  [4680] = {.lex_state = 96, .external_lex_state = 2},
  [4681] = {.lex_state = 96, .external_lex_state = 5},
  [4682] = {.lex_state = 96, .external_lex_state = 5},
  [4683] = {.lex_state = 96, .external_lex_state = 2},
  [4684] = {.lex_state = 96, .external_lex_state = 5},
  [4685] = {.lex_state = 96, .external_lex_state = 2},
  [4686] = {.lex_state = 12, .external_lex_state = 2},
  [4687] = {.lex_state = 96, .external_lex_state = 2},
  [4688] = {.lex_state = 96, .external_lex_state = 5},
  [4689] = {.lex_state = 96, .external_lex_state = 5},
  [4690] = {.lex_state = 96, .external_lex_state = 5},
  [4691] = {.lex_state = 96, .external_lex_state = 5},
  [4692] = {.lex_state = 4, .external_lex_state = 2},
  [4693] = {.lex_state = 96, .external_lex_state = 5},
  [4694] = {.lex_state = 96, .external_lex_state = 5},
  [4695] = {.lex_state = 96, .external_lex_state = 2},
  [4696] = {.lex_state = 96, .external_lex_state = 2},
  [4697] = {.lex_state = 96, .external_lex_state = 5},
  [4698] = {.lex_state = 96, .external_lex_state = 5},
  [4699] = {.lex_state = 96, .external_lex_state = 5},
  [4700] = {.lex_state = 96, .external_lex_state = 2},
  [4701] = {.lex_state = 96, .external_lex_state = 5},
  [4702] = {.lex_state = 96, .external_lex_state = 5},
  [4703] = {.lex_state = 96, .external_lex_state = 2},
  [4704] = {.lex_state = 96, .external_lex_state = 2},
  [4705] = {.lex_state = 96, .external_lex_state = 2},
  [4706] = {.lex_state = 96, .external_lex_state = 5},
  [4707] = {.lex_state = 96, .external_lex_state = 2},
  [4708] = {.lex_state = 96, .external_lex_state = 5},
  [4709] = {.lex_state = 96, .external_lex_state = 5},
  [4710] = {.lex_state = 96, .external_lex_state = 5},
  [4711] = {.lex_state = 96, .external_lex_state = 5},
  [4712] = {.lex_state = 96, .external_lex_state = 5},
  [4713] = {.lex_state = 96, .external_lex_state = 5},
  [4714] = {.lex_state = 96, .external_lex_state = 5},
  [4715] = {.lex_state = 96, .external_lex_state = 5},
  [4716] = {.lex_state = 96, .external_lex_state = 5},
  [4717] = {.lex_state = 96, .external_lex_state = 5},
  [4718] = {.lex_state = 96, .external_lex_state = 5},
  [4719] = {.lex_state = 96, .external_lex_state = 5},
  [4720] = {.lex_state = 96, .external_lex_state = 2},
  [4721] = {.lex_state = 96, .external_lex_state = 5},
  [4722] = {.lex_state = 96, .external_lex_state = 5},
  [4723] = {.lex_state = 96, .external_lex_state = 5},
  [4724] = {.lex_state = 96, .external_lex_state = 2},
  [4725] = {.lex_state = 96, .external_lex_state = 5},
  [4726] = {.lex_state = 96, .external_lex_state = 5},
  [4727] = {.lex_state = 96, .external_lex_state = 5},
  [4728] = {.lex_state = 96, .external_lex_state = 2},
  [4729] = {.lex_state = 96, .external_lex_state = 5},
  [4730] = {.lex_state = 96, .external_lex_state = 2},
  [4731] = {.lex_state = 96, .external_lex_state = 5},
  [4732] = {.lex_state = 96, .external_lex_state = 5},
  [4733] = {.lex_state = 96, .external_lex_state = 5},
  [4734] = {.lex_state = 96, .external_lex_state = 5},
  [4735] = {.lex_state = 96, .external_lex_state = 5},
  [4736] = {.lex_state = 96, .external_lex_state = 5},
  [4737] = {.lex_state = 96, .external_lex_state = 5},
  [4738] = {.lex_state = 96, .external_lex_state = 5},
  [4739] = {.lex_state = 96, .external_lex_state = 5},
  [4740] = {.lex_state = 96, .external_lex_state = 5},
  [4741] = {.lex_state = 96, .external_lex_state = 5},
  [4742] = {.lex_state = 96, .external_lex_state = 5},
  [4743] = {.lex_state = 96, .external_lex_state = 5},
  [4744] = {.lex_state = 96, .external_lex_state = 5},
  [4745] = {.lex_state = 96, .external_lex_state = 5},
  [4746] = {.lex_state = 96, .external_lex_state = 5},
  [4747] = {.lex_state = 96, .external_lex_state = 5},
  [4748] = {.lex_state = 96, .external_lex_state = 5},
  [4749] = {.lex_state = 96, .external_lex_state = 5},
  [4750] = {.lex_state = 96, .external_lex_state = 2},
  [4751] = {.lex_state = 96, .external_lex_state = 5},
  [4752] = {.lex_state = 96, .external_lex_state = 5},
  [4753] = {.lex_state = 96, .external_lex_state = 5},
  [4754] = {.lex_state = 96, .external_lex_state = 5},
  [4755] = {.lex_state = 96, .external_lex_state = 5},
  [4756] = {.lex_state = 96, .external_lex_state = 5},
  [4757] = {.lex_state = 96, .external_lex_state = 5},
  [4758] = {.lex_state = 96, .external_lex_state = 2},
  [4759] = {.lex_state = 96, .external_lex_state = 5},
  [4760] = {.lex_state = 96, .external_lex_state = 5},
  [4761] = {.lex_state = 96, .external_lex_state = 5},
  [4762] = {.lex_state = 96, .external_lex_state = 5},
  [4763] = {.lex_state = 96, .external_lex_state = 5},
  [4764] = {.lex_state = 96, .external_lex_state = 5},
  [4765] = {.lex_state = 96, .external_lex_state = 5},
  [4766] = {.lex_state = 96, .external_lex_state = 5},
  [4767] = {.lex_state = 96, .external_lex_state = 2},
  [4768] = {.lex_state = 96, .external_lex_state = 5},
  [4769] = {.lex_state = 96, .external_lex_state = 2},
  [4770] = {.lex_state = 96, .external_lex_state = 5},
  [4771] = {.lex_state = 4, .external_lex_state = 2},
  [4772] = {.lex_state = 96, .external_lex_state = 2},
  [4773] = {.lex_state = 96, .external_lex_state = 5},
  [4774] = {.lex_state = 96, .external_lex_state = 5},
  [4775] = {.lex_state = 96, .external_lex_state = 2},
  [4776] = {.lex_state = 96, .external_lex_state = 5},
  [4777] = {.lex_state = 96, .external_lex_state = 5},
  [4778] = {.lex_state = 96, .external_lex_state = 2},
  [4779] = {.lex_state = 96, .external_lex_state = 2},
  [4780] = {.lex_state = 96, .external_lex_state = 5},
  [4781] = {.lex_state = 96, .external_lex_state = 2},
  [4782] = {.lex_state = 96, .external_lex_state = 5},
  [4783] = {.lex_state = 96, .external_lex_state = 2},
  [4784] = {.lex_state = 96, .external_lex_state = 2},
  [4785] = {.lex_state = 96, .external_lex_state = 5},
  [4786] = {.lex_state = 96, .external_lex_state = 5},
  [4787] = {.lex_state = 96, .external_lex_state = 2},
  [4788] = {.lex_state = 96, .external_lex_state = 2},
  [4789] = {.lex_state = 96, .external_lex_state = 2},
  [4790] = {.lex_state = 96, .external_lex_state = 5},
  [4791] = {.lex_state = 96, .external_lex_state = 5},
  [4792] = {.lex_state = 96, .external_lex_state = 5},
  [4793] = {.lex_state = 96, .external_lex_state = 5},
  [4794] = {.lex_state = 96, .external_lex_state = 5},
  [4795] = {.lex_state = 96, .external_lex_state = 5},
  [4796] = {.lex_state = 96, .external_lex_state = 5},
  [4797] = {.lex_state = 96, .external_lex_state = 5},
  [4798] = {.lex_state = 96, .external_lex_state = 5},
  [4799] = {.lex_state = 96, .external_lex_state = 5},
  [4800] = {.lex_state = 96, .external_lex_state = 5},
  [4801] = {.lex_state = 96, .external_lex_state = 5},
  [4802] = {.lex_state = 96, .external_lex_state = 5},
  [4803] = {.lex_state = 96, .external_lex_state = 2},
  [4804] = {.lex_state = 96, .external_lex_state = 5},
  [4805] = {.lex_state = 96, .external_lex_state = 5},
  [4806] = {.lex_state = 96, .external_lex_state = 5},
  [4807] = {.lex_state = 96, .external_lex_state = 2},
  [4808] = {.lex_state = 96, .external_lex_state = 5},
  [4809] = {.lex_state = 96, .external_lex_state = 2},
  [4810] = {.lex_state = 96, .external_lex_state = 2},
  [4811] = {.lex_state = 96, .external_lex_state = 5},
  [4812] = {.lex_state = 96, .external_lex_state = 5},
  [4813] = {.lex_state = 96, .external_lex_state = 5},
  [4814] = {.lex_state = 96, .external_lex_state = 5},
  [4815] = {.lex_state = 96, .external_lex_state = 5},
  [4816] = {.lex_state = 96, .external_lex_state = 5},
  [4817] = {.lex_state = 1, .external_lex_state = 2},
  [4818] = {.lex_state = 96, .external_lex_state = 5},
  [4819] = {.lex_state = 96, .external_lex_state = 5},
  [4820] = {.lex_state = 96, .external_lex_state = 2},
  [4821] = {.lex_state = 96, .external_lex_state = 5},
  [4822] = {.lex_state = 96, .external_lex_state = 2},
  [4823] = {.lex_state = 96, .external_lex_state = 5},
  [4824] = {.lex_state = 96, .external_lex_state = 2},
  [4825] = {.lex_state = 96, .external_lex_state = 2},
  [4826] = {.lex_state = 96, .external_lex_state = 5},
  [4827] = {.lex_state = 96, .external_lex_state = 5},
  [4828] = {.lex_state = 96, .external_lex_state = 5},
  [4829] = {.lex_state = 96, .external_lex_state = 5},
  [4830] = {.lex_state = 96, .external_lex_state = 5},
  [4831] = {.lex_state = 96, .external_lex_state = 5},
  [4832] = {.lex_state = 96, .external_lex_state = 5},
  [4833] = {.lex_state = 96, .external_lex_state = 5},
  [4834] = {.lex_state = 96, .external_lex_state = 5},
  [4835] = {.lex_state = 96, .external_lex_state = 2},
  [4836] = {.lex_state = 96, .external_lex_state = 5},
  [4837] = {.lex_state = 96, .external_lex_state = 5},
  [4838] = {.lex_state = 96, .external_lex_state = 5},
  [4839] = {.lex_state = 96, .external_lex_state = 5},
  [4840] = {.lex_state = 96, .external_lex_state = 5},
  [4841] = {.lex_state = 96, .external_lex_state = 5},
  [4842] = {.lex_state = 96, .external_lex_state = 5},
  [4843] = {.lex_state = 96, .external_lex_state = 5},
  [4844] = {.lex_state = 96, .external_lex_state = 5},
  [4845] = {.lex_state = 96, .external_lex_state = 2},
  [4846] = {.lex_state = 96, .external_lex_state = 5},
  [4847] = {.lex_state = 96, .external_lex_state = 5},
  [4848] = {.lex_state = 96, .external_lex_state = 5},
  [4849] = {.lex_state = 96, .external_lex_state = 5},
  [4850] = {.lex_state = 96, .external_lex_state = 5},
  [4851] = {.lex_state = 96, .external_lex_state = 5},
  [4852] = {.lex_state = 96, .external_lex_state = 5},
  [4853] = {.lex_state = 96, .external_lex_state = 5},
  [4854] = {.lex_state = 96, .external_lex_state = 5},
  [4855] = {.lex_state = 96, .external_lex_state = 5},
  [4856] = {.lex_state = 96, .external_lex_state = 5},
  [4857] = {.lex_state = 96, .external_lex_state = 5},
  [4858] = {.lex_state = 96, .external_lex_state = 5},
  [4859] = {.lex_state = 96, .external_lex_state = 5},
  [4860] = {.lex_state = 96, .external_lex_state = 5},
  [4861] = {.lex_state = 96, .external_lex_state = 5},
  [4862] = {.lex_state = 96, .external_lex_state = 5},
  [4863] = {.lex_state = 96, .external_lex_state = 5},
  [4864] = {.lex_state = 96, .external_lex_state = 5},
  [4865] = {.lex_state = 96, .external_lex_state = 5},
  [4866] = {.lex_state = 96, .external_lex_state = 5},
  [4867] = {.lex_state = 96, .external_lex_state = 5},
  [4868] = {.lex_state = 96, .external_lex_state = 5},
  [4869] = {.lex_state = 96, .external_lex_state = 5},
  [4870] = {.lex_state = 96, .external_lex_state = 5},
  [4871] = {.lex_state = 96, .external_lex_state = 5},
  [4872] = {.lex_state = 96, .external_lex_state = 5},
  [4873] = {.lex_state = 96, .external_lex_state = 5},
  [4874] = {.lex_state = 96, .external_lex_state = 5},
  [4875] = {.lex_state = 96, .external_lex_state = 5},
  [4876] = {.lex_state = 96, .external_lex_state = 5},
  [4877] = {.lex_state = 96, .external_lex_state = 5},
  [4878] = {.lex_state = 96, .external_lex_state = 2},
  [4879] = {.lex_state = 1, .external_lex_state = 2},
  [4880] = {.lex_state = 96, .external_lex_state = 5},
  [4881] = {.lex_state = 96, .external_lex_state = 5},
  [4882] = {.lex_state = 96, .external_lex_state = 5},
  [4883] = {.lex_state = 96, .external_lex_state = 5},
  [4884] = {.lex_state = 96, .external_lex_state = 5},
  [4885] = {.lex_state = 96, .external_lex_state = 5},
  [4886] = {.lex_state = 96, .external_lex_state = 5},
  [4887] = {.lex_state = 96, .external_lex_state = 5},
  [4888] = {.lex_state = 96, .external_lex_state = 2},
  [4889] = {.lex_state = 96, .external_lex_state = 5},
  [4890] = {.lex_state = 96, .external_lex_state = 5},
  [4891] = {.lex_state = 96, .external_lex_state = 5},
  [4892] = {.lex_state = 96, .external_lex_state = 5},
  [4893] = {.lex_state = 96, .external_lex_state = 5},
  [4894] = {.lex_state = 96, .external_lex_state = 2},
  [4895] = {.lex_state = 96, .external_lex_state = 5},
  [4896] = {.lex_state = 96, .external_lex_state = 5},
  [4897] = {.lex_state = 96, .external_lex_state = 2},
  [4898] = {.lex_state = 96, .external_lex_state = 5},
  [4899] = {.lex_state = 96, .external_lex_state = 5},
  [4900] = {.lex_state = 96, .external_lex_state = 5},
  [4901] = {.lex_state = 96, .external_lex_state = 2},
  [4902] = {.lex_state = 96, .external_lex_state = 2},
  [4903] = {.lex_state = 96, .external_lex_state = 5},
  [4904] = {.lex_state = 96, .external_lex_state = 2},
  [4905] = {.lex_state = 96, .external_lex_state = 2},
  [4906] = {.lex_state = 96, .external_lex_state = 2},
  [4907] = {.lex_state = 96, .external_lex_state = 5},
  [4908] = {.lex_state = 96, .external_lex_state = 2},
  [4909] = {.lex_state = 96, .external_lex_state = 5},
  [4910] = {.lex_state = 96, .external_lex_state = 2},
  [4911] = {.lex_state = 96, .external_lex_state = 5},
  [4912] = {.lex_state = 96, .external_lex_state = 5},
  [4913] = {.lex_state = 96, .external_lex_state = 5},
  [4914] = {.lex_state = 96, .external_lex_state = 5},
  [4915] = {.lex_state = 96, .external_lex_state = 2},
  [4916] = {.lex_state = 96, .external_lex_state = 5},
  [4917] = {.lex_state = 96, .external_lex_state = 5},
  [4918] = {.lex_state = 96, .external_lex_state = 5},
  [4919] = {.lex_state = 96, .external_lex_state = 5},
  [4920] = {.lex_state = 96, .external_lex_state = 5},
  [4921] = {.lex_state = 96, .external_lex_state = 5},
  [4922] = {.lex_state = 96, .external_lex_state = 2},
  [4923] = {.lex_state = 96, .external_lex_state = 5},
  [4924] = {.lex_state = 96, .external_lex_state = 5},
  [4925] = {.lex_state = 96, .external_lex_state = 5},
  [4926] = {.lex_state = 96, .external_lex_state = 2},
  [4927] = {.lex_state = 96, .external_lex_state = 5},
  [4928] = {.lex_state = 96, .external_lex_state = 5},
  [4929] = {.lex_state = 96, .external_lex_state = 5},
  [4930] = {.lex_state = 96, .external_lex_state = 5},
  [4931] = {.lex_state = 96, .external_lex_state = 5},
  [4932] = {.lex_state = 96, .external_lex_state = 5},
  [4933] = {.lex_state = 96, .external_lex_state = 5},
  [4934] = {.lex_state = 96, .external_lex_state = 5},
  [4935] = {.lex_state = 1, .external_lex_state = 2},
  [4936] = {.lex_state = 96, .external_lex_state = 5},
  [4937] = {.lex_state = 96, .external_lex_state = 2},
  [4938] = {.lex_state = 96, .external_lex_state = 5},
  [4939] = {.lex_state = 96, .external_lex_state = 2},
  [4940] = {.lex_state = 96, .external_lex_state = 2},
  [4941] = {.lex_state = 96, .external_lex_state = 2},
  [4942] = {.lex_state = 18, .external_lex_state = 8},
  [4943] = {.lex_state = 96, .external_lex_state = 5},
  [4944] = {.lex_state = 4, .external_lex_state = 2},
  [4945] = {.lex_state = 4, .external_lex_state = 2},
  [4946] = {.lex_state = 96, .external_lex_state = 5},
  [4947] = {.lex_state = 96, .external_lex_state = 2},
  [4948] = {.lex_state = 96, .external_lex_state = 2},
  [4949] = {.lex_state = 96, .external_lex_state = 5},
  [4950] = {.lex_state = 96, .external_lex_state = 5},
  [4951] = {.lex_state = 96, .external_lex_state = 5},
  [4952] = {.lex_state = 96, .external_lex_state = 2},
  [4953] = {.lex_state = 96, .external_lex_state = 5},
  [4954] = {.lex_state = 96, .external_lex_state = 5},
  [4955] = {.lex_state = 96, .external_lex_state = 5},
  [4956] = {.lex_state = 96, .external_lex_state = 2},
  [4957] = {.lex_state = 96, .external_lex_state = 5},
  [4958] = {.lex_state = 96, .external_lex_state = 5},
  [4959] = {.lex_state = 96, .external_lex_state = 5},
  [4960] = {.lex_state = 96, .external_lex_state = 5},
  [4961] = {.lex_state = 96, .external_lex_state = 2},
  [4962] = {.lex_state = 96, .external_lex_state = 5},
  [4963] = {.lex_state = 96, .external_lex_state = 2},
  [4964] = {.lex_state = 96, .external_lex_state = 2},
  [4965] = {.lex_state = 96, .external_lex_state = 2},
  [4966] = {.lex_state = 96, .external_lex_state = 5},
  [4967] = {.lex_state = 96, .external_lex_state = 5},
  [4968] = {.lex_state = 96, .external_lex_state = 5},
  [4969] = {.lex_state = 96, .external_lex_state = 2},
  [4970] = {.lex_state = 96, .external_lex_state = 2},
  [4971] = {.lex_state = 96, .external_lex_state = 2},
  [4972] = {.lex_state = 96, .external_lex_state = 5},
  [4973] = {.lex_state = 96, .external_lex_state = 5},
  [4974] = {.lex_state = 96, .external_lex_state = 2},
  [4975] = {.lex_state = 96, .external_lex_state = 5},
  [4976] = {.lex_state = 96, .external_lex_state = 2},
  [4977] = {.lex_state = 96, .external_lex_state = 5},
  [4978] = {.lex_state = 96, .external_lex_state = 5},
  [4979] = {.lex_state = 96, .external_lex_state = 5},
  [4980] = {.lex_state = 96, .external_lex_state = 5},
  [4981] = {.lex_state = 96, .external_lex_state = 5},
  [4982] = {.lex_state = 96, .external_lex_state = 5},
  [4983] = {.lex_state = 96, .external_lex_state = 2},
  [4984] = {.lex_state = 96, .external_lex_state = 5},
  [4985] = {.lex_state = 96, .external_lex_state = 5},
  [4986] = {.lex_state = 96, .external_lex_state = 5},
  [4987] = {.lex_state = 96, .external_lex_state = 2},
  [4988] = {.lex_state = 96, .external_lex_state = 2},
  [4989] = {.lex_state = 96, .external_lex_state = 5},
  [4990] = {.lex_state = 96, .external_lex_state = 2},
  [4991] = {.lex_state = 96, .external_lex_state = 2},
  [4992] = {.lex_state = 96, .external_lex_state = 5},
  [4993] = {.lex_state = 96, .external_lex_state = 5},
  [4994] = {.lex_state = 96, .external_lex_state = 2},
  [4995] = {.lex_state = 12, .external_lex_state = 2},
  [4996] = {.lex_state = 96, .external_lex_state = 5},
  [4997] = {.lex_state = 96, .external_lex_state = 2},
  [4998] = {.lex_state = 96, .external_lex_state = 2},
  [4999] = {.lex_state = 96, .external_lex_state = 5},
  [5000] = {.lex_state = 96, .external_lex_state = 2},
  [5001] = {.lex_state = 96, .external_lex_state = 5},
  [5002] = {.lex_state = 96, .external_lex_state = 5},
  [5003] = {.lex_state = 96, .external_lex_state = 5},
  [5004] = {.lex_state = 96, .external_lex_state = 5},
  [5005] = {.lex_state = 96, .external_lex_state = 5},
  [5006] = {.lex_state = 96, .external_lex_state = 5},
  [5007] = {.lex_state = 96, .external_lex_state = 2},
  [5008] = {.lex_state = 96, .external_lex_state = 2},
  [5009] = {.lex_state = 96, .external_lex_state = 5},
  [5010] = {.lex_state = 96, .external_lex_state = 2},
  [5011] = {.lex_state = 96, .external_lex_state = 2},
  [5012] = {.lex_state = 96, .external_lex_state = 5},
  [5013] = {.lex_state = 96, .external_lex_state = 5},
  [5014] = {.lex_state = 96, .external_lex_state = 5},
  [5015] = {.lex_state = 96, .external_lex_state = 5},
  [5016] = {.lex_state = 96, .external_lex_state = 2},
  [5017] = {.lex_state = 96, .external_lex_state = 5},
  [5018] = {.lex_state = 96, .external_lex_state = 5},
  [5019] = {.lex_state = 96, .external_lex_state = 5},
  [5020] = {.lex_state = 96, .external_lex_state = 2},
  [5021] = {.lex_state = 96, .external_lex_state = 5},
  [5022] = {.lex_state = 96, .external_lex_state = 2},
  [5023] = {.lex_state = 96, .external_lex_state = 5},
  [5024] = {.lex_state = 96, .external_lex_state = 5},
  [5025] = {.lex_state = 96, .external_lex_state = 5},
  [5026] = {.lex_state = 96, .external_lex_state = 5},
  [5027] = {.lex_state = 96, .external_lex_state = 5},
  [5028] = {.lex_state = 96, .external_lex_state = 5},
  [5029] = {.lex_state = 96, .external_lex_state = 2},
  [5030] = {.lex_state = 96, .external_lex_state = 5},
  [5031] = {.lex_state = 96, .external_lex_state = 5},
  [5032] = {.lex_state = 96, .external_lex_state = 5},
  [5033] = {.lex_state = 96, .external_lex_state = 5},
  [5034] = {.lex_state = 96, .external_lex_state = 2},
  [5035] = {.lex_state = 96, .external_lex_state = 5},
  [5036] = {.lex_state = 96, .external_lex_state = 5},
  [5037] = {.lex_state = 96, .external_lex_state = 5},
  [5038] = {.lex_state = 96, .external_lex_state = 5},
  [5039] = {.lex_state = 96, .external_lex_state = 5},
  [5040] = {.lex_state = 96, .external_lex_state = 5},
  [5041] = {.lex_state = 96, .external_lex_state = 5},
  [5042] = {.lex_state = 96, .external_lex_state = 5},
  [5043] = {.lex_state = 96, .external_lex_state = 5},
  [5044] = {.lex_state = 96, .external_lex_state = 5},
  [5045] = {.lex_state = 96, .external_lex_state = 5},
  [5046] = {.lex_state = 96, .external_lex_state = 5},
  [5047] = {.lex_state = 96, .external_lex_state = 5},
  [5048] = {.lex_state = 96, .external_lex_state = 5},
  [5049] = {.lex_state = 96, .external_lex_state = 5},
  [5050] = {.lex_state = 96, .external_lex_state = 5},
  [5051] = {.lex_state = 96, .external_lex_state = 5},
  [5052] = {.lex_state = 96, .external_lex_state = 5},
  [5053] = {.lex_state = 96, .external_lex_state = 5},
  [5054] = {.lex_state = 96, .external_lex_state = 5},
  [5055] = {.lex_state = 96, .external_lex_state = 5},
  [5056] = {.lex_state = 96, .external_lex_state = 2},
  [5057] = {.lex_state = 96, .external_lex_state = 5},
  [5058] = {.lex_state = 96, .external_lex_state = 5},
  [5059] = {.lex_state = 96, .external_lex_state = 5},
  [5060] = {.lex_state = 96, .external_lex_state = 5},
  [5061] = {.lex_state = 96, .external_lex_state = 5},
  [5062] = {.lex_state = 96, .external_lex_state = 5},
  [5063] = {.lex_state = 96, .external_lex_state = 5},
  [5064] = {.lex_state = 96, .external_lex_state = 5},
  [5065] = {.lex_state = 96, .external_lex_state = 5},
  [5066] = {.lex_state = 96, .external_lex_state = 5},
  [5067] = {.lex_state = 96, .external_lex_state = 5},
  [5068] = {.lex_state = 96, .external_lex_state = 5},
  [5069] = {.lex_state = 96, .external_lex_state = 5},
  [5070] = {.lex_state = 96, .external_lex_state = 5},
  [5071] = {.lex_state = 96, .external_lex_state = 5},
  [5072] = {.lex_state = 96, .external_lex_state = 5},
  [5073] = {.lex_state = 96, .external_lex_state = 5},
  [5074] = {.lex_state = 96, .external_lex_state = 5},
  [5075] = {.lex_state = 96, .external_lex_state = 5},
  [5076] = {.lex_state = 96, .external_lex_state = 5},
  [5077] = {.lex_state = 96, .external_lex_state = 5},
  [5078] = {.lex_state = 96, .external_lex_state = 5},
  [5079] = {.lex_state = 96, .external_lex_state = 5},
  [5080] = {.lex_state = 96, .external_lex_state = 5},
  [5081] = {.lex_state = 96, .external_lex_state = 5},
  [5082] = {.lex_state = 96, .external_lex_state = 5},
  [5083] = {.lex_state = 96, .external_lex_state = 5},
  [5084] = {.lex_state = 96, .external_lex_state = 5},
  [5085] = {.lex_state = 96, .external_lex_state = 5},
  [5086] = {.lex_state = 96, .external_lex_state = 5},
  [5087] = {.lex_state = 96, .external_lex_state = 5},
  [5088] = {.lex_state = 96, .external_lex_state = 5},
  [5089] = {.lex_state = 96, .external_lex_state = 5},
  [5090] = {.lex_state = 96, .external_lex_state = 5},
  [5091] = {.lex_state = 96, .external_lex_state = 2},
  [5092] = {.lex_state = 96, .external_lex_state = 5},
  [5093] = {.lex_state = 96, .external_lex_state = 5},
  [5094] = {.lex_state = 96, .external_lex_state = 5},
  [5095] = {.lex_state = 96, .external_lex_state = 5},
  [5096] = {.lex_state = 96, .external_lex_state = 5},
  [5097] = {.lex_state = 96, .external_lex_state = 5},
  [5098] = {.lex_state = 96, .external_lex_state = 5},
  [5099] = {.lex_state = 96, .external_lex_state = 5},
  [5100] = {.lex_state = 96, .external_lex_state = 5},
  [5101] = {.lex_state = 96, .external_lex_state = 5},
  [5102] = {.lex_state = 96, .external_lex_state = 5},
  [5103] = {.lex_state = 96, .external_lex_state = 5},
  [5104] = {.lex_state = 96, .external_lex_state = 5},
  [5105] = {.lex_state = 96, .external_lex_state = 5},
  [5106] = {.lex_state = 96, .external_lex_state = 2},
  [5107] = {.lex_state = 96, .external_lex_state = 5},
  [5108] = {.lex_state = 96, .external_lex_state = 5},
  [5109] = {.lex_state = 96, .external_lex_state = 5},
  [5110] = {.lex_state = 4, .external_lex_state = 2},
  [5111] = {.lex_state = 96, .external_lex_state = 5},
  [5112] = {.lex_state = 96, .external_lex_state = 5},
  [5113] = {.lex_state = 96, .external_lex_state = 5},
  [5114] = {.lex_state = 96, .external_lex_state = 5},
  [5115] = {.lex_state = 96, .external_lex_state = 5},
  [5116] = {.lex_state = 4, .external_lex_state = 2},
  [5117] = {.lex_state = 96, .external_lex_state = 5},
  [5118] = {.lex_state = 96, .external_lex_state = 5},
  [5119] = {.lex_state = 96, .external_lex_state = 2},
  [5120] = {.lex_state = 96, .external_lex_state = 5},
  [5121] = {.lex_state = 96, .external_lex_state = 5},
  [5122] = {.lex_state = 96, .external_lex_state = 5},
  [5123] = {.lex_state = 96, .external_lex_state = 5},
  [5124] = {.lex_state = 96, .external_lex_state = 5},
  [5125] = {.lex_state = 96, .external_lex_state = 5},
  [5126] = {.lex_state = 96, .external_lex_state = 5},
  [5127] = {.lex_state = 96, .external_lex_state = 5},
  [5128] = {.lex_state = 96, .external_lex_state = 5},
  [5129] = {.lex_state = 96, .external_lex_state = 5},
  [5130] = {.lex_state = 96, .external_lex_state = 5},
  [5131] = {.lex_state = 96, .external_lex_state = 5},
  [5132] = {.lex_state = 96, .external_lex_state = 2},
  [5133] = {.lex_state = 96, .external_lex_state = 5},
  [5134] = {.lex_state = 96, .external_lex_state = 2},
  [5135] = {.lex_state = 96, .external_lex_state = 5},
  [5136] = {.lex_state = 96, .external_lex_state = 2},
  [5137] = {.lex_state = 96, .external_lex_state = 5},
  [5138] = {.lex_state = 96, .external_lex_state = 2},
  [5139] = {.lex_state = 96, .external_lex_state = 2},
  [5140] = {.lex_state = 96, .external_lex_state = 2},
  [5141] = {.lex_state = 96, .external_lex_state = 2},
  [5142] = {.lex_state = 96, .external_lex_state = 2},
  [5143] = {.lex_state = 96, .external_lex_state = 2},
  [5144] = {.lex_state = 96, .external_lex_state = 5},
  [5145] = {.lex_state = 96, .external_lex_state = 2},
  [5146] = {.lex_state = 96, .external_lex_state = 2},
  [5147] = {.lex_state = 96, .external_lex_state = 2},
  [5148] = {.lex_state = 96, .external_lex_state = 5},
  [5149] = {.lex_state = 96, .external_lex_state = 2},
  [5150] = {.lex_state = 96, .external_lex_state = 2},
  [5151] = {.lex_state = 96, .external_lex_state = 5},
  [5152] = {.lex_state = 96, .external_lex_state = 2},
  [5153] = {.lex_state = 96, .external_lex_state = 5},
  [5154] = {.lex_state = 96, .external_lex_state = 2},
  [5155] = {.lex_state = 96, .external_lex_state = 2},
  [5156] = {.lex_state = 96, .external_lex_state = 2},
  [5157] = {.lex_state = 96, .external_lex_state = 2},
  [5158] = {.lex_state = 96, .external_lex_state = 2},
  [5159] = {.lex_state = 96, .external_lex_state = 2},
  [5160] = {.lex_state = 96, .external_lex_state = 2},
  [5161] = {.lex_state = 96, .external_lex_state = 2},
  [5162] = {.lex_state = 96, .external_lex_state = 2},
  [5163] = {.lex_state = 96, .external_lex_state = 5},
  [5164] = {.lex_state = 96, .external_lex_state = 2},
  [5165] = {.lex_state = 96, .external_lex_state = 2},
  [5166] = {.lex_state = 96, .external_lex_state = 2},
  [5167] = {.lex_state = 96, .external_lex_state = 2},
  [5168] = {.lex_state = 96, .external_lex_state = 2},
  [5169] = {.lex_state = 96, .external_lex_state = 2},
  [5170] = {.lex_state = 96, .external_lex_state = 2},
  [5171] = {.lex_state = 96, .external_lex_state = 2},
  [5172] = {.lex_state = 96, .external_lex_state = 2},
  [5173] = {.lex_state = 96, .external_lex_state = 5},
  [5174] = {.lex_state = 96, .external_lex_state = 2},
  [5175] = {.lex_state = 96, .external_lex_state = 2},
  [5176] = {.lex_state = 96, .external_lex_state = 2},
  [5177] = {.lex_state = 96, .external_lex_state = 5},
  [5178] = {.lex_state = 96, .external_lex_state = 2},
  [5179] = {.lex_state = 96, .external_lex_state = 2},
  [5180] = {.lex_state = 96, .external_lex_state = 2},
  [5181] = {.lex_state = 96, .external_lex_state = 2},
  [5182] = {.lex_state = 96, .external_lex_state = 2},
  [5183] = {.lex_state = 96, .external_lex_state = 2},
  [5184] = {.lex_state = 96, .external_lex_state = 2},
  [5185] = {.lex_state = 96, .external_lex_state = 2},
  [5186] = {.lex_state = 96, .external_lex_state = 5},
  [5187] = {.lex_state = 96, .external_lex_state = 2},
  [5188] = {.lex_state = 96, .external_lex_state = 2},
  [5189] = {.lex_state = 96, .external_lex_state = 2},
  [5190] = {.lex_state = 96, .external_lex_state = 2},
  [5191] = {.lex_state = 96, .external_lex_state = 2},
  [5192] = {.lex_state = 96, .external_lex_state = 2},
  [5193] = {.lex_state = 96, .external_lex_state = 2},
  [5194] = {.lex_state = 96, .external_lex_state = 2},
  [5195] = {.lex_state = 96, .external_lex_state = 5},
  [5196] = {.lex_state = 96, .external_lex_state = 2},
  [5197] = {.lex_state = 96, .external_lex_state = 2},
  [5198] = {.lex_state = 96, .external_lex_state = 5},
  [5199] = {.lex_state = 96, .external_lex_state = 2},
  [5200] = {.lex_state = 96, .external_lex_state = 2},
  [5201] = {.lex_state = 96, .external_lex_state = 2},
  [5202] = {.lex_state = 96, .external_lex_state = 2},
  [5203] = {.lex_state = 96, .external_lex_state = 2},
  [5204] = {.lex_state = 96, .external_lex_state = 2},
  [5205] = {.lex_state = 96, .external_lex_state = 2},
  [5206] = {.lex_state = 96, .external_lex_state = 2},
  [5207] = {.lex_state = 96, .external_lex_state = 2},
  [5208] = {.lex_state = 96, .external_lex_state = 2},
  [5209] = {.lex_state = 96, .external_lex_state = 2},
  [5210] = {.lex_state = 96, .external_lex_state = 2},
  [5211] = {.lex_state = 96, .external_lex_state = 2},
  [5212] = {.lex_state = 96, .external_lex_state = 2},
  [5213] = {.lex_state = 96, .external_lex_state = 2},
  [5214] = {.lex_state = 96, .external_lex_state = 2},
  [5215] = {.lex_state = 96, .external_lex_state = 2},
  [5216] = {.lex_state = 96, .external_lex_state = 2},
  [5217] = {.lex_state = 96, .external_lex_state = 2},
  [5218] = {.lex_state = 96, .external_lex_state = 2},
  [5219] = {.lex_state = 96, .external_lex_state = 2},
  [5220] = {.lex_state = 96, .external_lex_state = 2},
  [5221] = {.lex_state = 96, .external_lex_state = 2},
  [5222] = {.lex_state = 96, .external_lex_state = 2},
  [5223] = {.lex_state = 96, .external_lex_state = 2},
  [5224] = {.lex_state = 96, .external_lex_state = 2},
  [5225] = {.lex_state = 96, .external_lex_state = 2},
  [5226] = {.lex_state = 96, .external_lex_state = 2},
  [5227] = {.lex_state = 96, .external_lex_state = 2},
  [5228] = {.lex_state = 96, .external_lex_state = 2},
  [5229] = {.lex_state = 96, .external_lex_state = 2},
  [5230] = {.lex_state = 96, .external_lex_state = 2},
  [5231] = {.lex_state = 96, .external_lex_state = 2},
  [5232] = {.lex_state = 96, .external_lex_state = 2},
  [5233] = {.lex_state = 96, .external_lex_state = 2},
  [5234] = {.lex_state = 96, .external_lex_state = 2},
  [5235] = {.lex_state = 96, .external_lex_state = 2},
  [5236] = {.lex_state = 96, .external_lex_state = 2},
  [5237] = {.lex_state = 96, .external_lex_state = 2},
  [5238] = {.lex_state = 96, .external_lex_state = 2},
  [5239] = {.lex_state = 96, .external_lex_state = 2},
  [5240] = {.lex_state = 96, .external_lex_state = 2},
  [5241] = {.lex_state = 96, .external_lex_state = 2},
  [5242] = {.lex_state = 96, .external_lex_state = 2},
  [5243] = {.lex_state = 96, .external_lex_state = 2},
  [5244] = {.lex_state = 96, .external_lex_state = 2},
  [5245] = {.lex_state = 96, .external_lex_state = 2},
  [5246] = {.lex_state = 96, .external_lex_state = 2},
  [5247] = {.lex_state = 96, .external_lex_state = 2},
  [5248] = {.lex_state = 96, .external_lex_state = 5},
  [5249] = {.lex_state = 96, .external_lex_state = 5},
  [5250] = {.lex_state = 96, .external_lex_state = 2},
  [5251] = {.lex_state = 96, .external_lex_state = 2},
  [5252] = {.lex_state = 96, .external_lex_state = 2},
  [5253] = {.lex_state = 96, .external_lex_state = 2},
  [5254] = {.lex_state = 96, .external_lex_state = 2},
  [5255] = {.lex_state = 96, .external_lex_state = 2},
  [5256] = {.lex_state = 96, .external_lex_state = 2},
  [5257] = {.lex_state = 96, .external_lex_state = 2},
  [5258] = {.lex_state = 96, .external_lex_state = 2},
  [5259] = {.lex_state = 96, .external_lex_state = 2},
  [5260] = {.lex_state = 96, .external_lex_state = 2},
  [5261] = {.lex_state = 96, .external_lex_state = 2},
  [5262] = {.lex_state = 96, .external_lex_state = 2},
  [5263] = {.lex_state = 96, .external_lex_state = 2},
  [5264] = {.lex_state = 96, .external_lex_state = 2},
  [5265] = {.lex_state = 96, .external_lex_state = 2},
  [5266] = {.lex_state = 96, .external_lex_state = 2},
  [5267] = {.lex_state = 96, .external_lex_state = 2},
  [5268] = {.lex_state = 96, .external_lex_state = 2},
  [5269] = {.lex_state = 96, .external_lex_state = 2},
  [5270] = {.lex_state = 96, .external_lex_state = 2},
  [5271] = {.lex_state = 96, .external_lex_state = 2},
  [5272] = {.lex_state = 96, .external_lex_state = 2},
  [5273] = {.lex_state = 96, .external_lex_state = 2},
  [5274] = {.lex_state = 96, .external_lex_state = 2},
  [5275] = {.lex_state = 96, .external_lex_state = 2},
  [5276] = {.lex_state = 96, .external_lex_state = 2},
  [5277] = {.lex_state = 96, .external_lex_state = 2},
  [5278] = {.lex_state = 96, .external_lex_state = 2},
  [5279] = {.lex_state = 96, .external_lex_state = 5},
  [5280] = {.lex_state = 96, .external_lex_state = 2},
  [5281] = {.lex_state = 96, .external_lex_state = 2},
  [5282] = {.lex_state = 96, .external_lex_state = 2},
  [5283] = {.lex_state = 96, .external_lex_state = 2},
  [5284] = {.lex_state = 96, .external_lex_state = 2},
  [5285] = {.lex_state = 96, .external_lex_state = 2},
  [5286] = {.lex_state = 96, .external_lex_state = 2},
  [5287] = {.lex_state = 96, .external_lex_state = 2},
  [5288] = {.lex_state = 96, .external_lex_state = 5},
  [5289] = {.lex_state = 96, .external_lex_state = 2},
  [5290] = {.lex_state = 96, .external_lex_state = 2},
  [5291] = {.lex_state = 96, .external_lex_state = 2},
  [5292] = {.lex_state = 96, .external_lex_state = 2},
  [5293] = {.lex_state = 96, .external_lex_state = 2},
  [5294] = {.lex_state = 96, .external_lex_state = 2},
  [5295] = {.lex_state = 96, .external_lex_state = 2},
  [5296] = {.lex_state = 96, .external_lex_state = 2},
  [5297] = {.lex_state = 96, .external_lex_state = 2},
  [5298] = {.lex_state = 96, .external_lex_state = 2},
  [5299] = {.lex_state = 96, .external_lex_state = 2},
  [5300] = {.lex_state = 96, .external_lex_state = 2},
  [5301] = {.lex_state = 96, .external_lex_state = 2},
  [5302] = {.lex_state = 96, .external_lex_state = 2},
  [5303] = {.lex_state = 96, .external_lex_state = 5},
  [5304] = {.lex_state = 96, .external_lex_state = 2},
  [5305] = {.lex_state = 96, .external_lex_state = 2},
  [5306] = {.lex_state = 96, .external_lex_state = 2},
  [5307] = {.lex_state = 96, .external_lex_state = 2},
  [5308] = {.lex_state = 96, .external_lex_state = 2},
  [5309] = {.lex_state = 96, .external_lex_state = 2},
  [5310] = {.lex_state = 96, .external_lex_state = 5},
  [5311] = {.lex_state = 96, .external_lex_state = 2},
  [5312] = {.lex_state = 96, .external_lex_state = 5},
  [5313] = {.lex_state = 96, .external_lex_state = 2},
  [5314] = {.lex_state = 96, .external_lex_state = 2},
  [5315] = {.lex_state = 96, .external_lex_state = 2},
  [5316] = {.lex_state = 96, .external_lex_state = 2},
  [5317] = {.lex_state = 96, .external_lex_state = 2},
  [5318] = {.lex_state = 96, .external_lex_state = 2},
  [5319] = {.lex_state = 96, .external_lex_state = 2},
  [5320] = {.lex_state = 96, .external_lex_state = 2},
  [5321] = {.lex_state = 96, .external_lex_state = 2},
  [5322] = {.lex_state = 96, .external_lex_state = 2},
  [5323] = {.lex_state = 96, .external_lex_state = 2},
  [5324] = {.lex_state = 96, .external_lex_state = 2},
  [5325] = {.lex_state = 96, .external_lex_state = 2},
  [5326] = {.lex_state = 96, .external_lex_state = 2},
  [5327] = {.lex_state = 96, .external_lex_state = 2},
  [5328] = {.lex_state = 96, .external_lex_state = 2},
  [5329] = {.lex_state = 96, .external_lex_state = 2},
  [5330] = {.lex_state = 96, .external_lex_state = 2},
  [5331] = {.lex_state = 96, .external_lex_state = 2},
  [5332] = {.lex_state = 96, .external_lex_state = 2},
  [5333] = {.lex_state = 96, .external_lex_state = 2},
  [5334] = {.lex_state = 96, .external_lex_state = 2},
  [5335] = {.lex_state = 96, .external_lex_state = 2},
  [5336] = {.lex_state = 96, .external_lex_state = 2},
  [5337] = {.lex_state = 96, .external_lex_state = 2},
  [5338] = {.lex_state = 96, .external_lex_state = 2},
  [5339] = {.lex_state = 96, .external_lex_state = 2},
  [5340] = {.lex_state = 96, .external_lex_state = 2},
  [5341] = {.lex_state = 96, .external_lex_state = 5},
  [5342] = {.lex_state = 96, .external_lex_state = 2},
  [5343] = {.lex_state = 96, .external_lex_state = 2},
  [5344] = {.lex_state = 96, .external_lex_state = 5},
  [5345] = {.lex_state = 96, .external_lex_state = 5},
  [5346] = {.lex_state = 96, .external_lex_state = 2},
  [5347] = {.lex_state = 96, .external_lex_state = 2},
  [5348] = {.lex_state = 96, .external_lex_state = 2},
  [5349] = {.lex_state = 96, .external_lex_state = 2},
  [5350] = {.lex_state = 96, .external_lex_state = 2},
  [5351] = {.lex_state = 96, .external_lex_state = 2},
  [5352] = {.lex_state = 96, .external_lex_state = 2},
  [5353] = {.lex_state = 96, .external_lex_state = 2},
  [5354] = {.lex_state = 96, .external_lex_state = 2},
  [5355] = {.lex_state = 96, .external_lex_state = 2},
  [5356] = {.lex_state = 96, .external_lex_state = 2},
  [5357] = {.lex_state = 96, .external_lex_state = 2},
  [5358] = {.lex_state = 96, .external_lex_state = 2},
  [5359] = {.lex_state = 96, .external_lex_state = 2},
  [5360] = {.lex_state = 96, .external_lex_state = 2},
  [5361] = {.lex_state = 96, .external_lex_state = 2},
  [5362] = {.lex_state = 96, .external_lex_state = 2},
  [5363] = {.lex_state = 96, .external_lex_state = 2},
  [5364] = {.lex_state = 96, .external_lex_state = 2},
  [5365] = {.lex_state = 96, .external_lex_state = 2},
  [5366] = {.lex_state = 96, .external_lex_state = 2},
  [5367] = {.lex_state = 96, .external_lex_state = 2},
  [5368] = {.lex_state = 96, .external_lex_state = 2},
  [5369] = {.lex_state = 96, .external_lex_state = 2},
  [5370] = {.lex_state = 96, .external_lex_state = 2},
  [5371] = {.lex_state = 96, .external_lex_state = 2},
  [5372] = {.lex_state = 96, .external_lex_state = 2},
  [5373] = {.lex_state = 96, .external_lex_state = 2},
  [5374] = {.lex_state = 96, .external_lex_state = 2},
  [5375] = {.lex_state = 96, .external_lex_state = 2},
  [5376] = {.lex_state = 96, .external_lex_state = 2},
  [5377] = {.lex_state = 96, .external_lex_state = 5},
  [5378] = {.lex_state = 96, .external_lex_state = 2},
  [5379] = {.lex_state = 96, .external_lex_state = 2},
  [5380] = {.lex_state = 96, .external_lex_state = 2},
  [5381] = {.lex_state = 96, .external_lex_state = 2},
  [5382] = {.lex_state = 96, .external_lex_state = 2},
  [5383] = {.lex_state = 96, .external_lex_state = 2},
  [5384] = {.lex_state = 96, .external_lex_state = 2},
  [5385] = {.lex_state = 96, .external_lex_state = 2},
  [5386] = {.lex_state = 96, .external_lex_state = 2},
  [5387] = {.lex_state = 96, .external_lex_state = 2},
  [5388] = {.lex_state = 96, .external_lex_state = 2},
  [5389] = {.lex_state = 96, .external_lex_state = 2},
  [5390] = {.lex_state = 96, .external_lex_state = 2},
  [5391] = {.lex_state = 96, .external_lex_state = 2},
  [5392] = {.lex_state = 96, .external_lex_state = 2},
  [5393] = {.lex_state = 96, .external_lex_state = 2},
  [5394] = {.lex_state = 96, .external_lex_state = 2},
  [5395] = {.lex_state = 96, .external_lex_state = 2},
  [5396] = {.lex_state = 96, .external_lex_state = 2},
  [5397] = {.lex_state = 96, .external_lex_state = 2},
  [5398] = {.lex_state = 96, .external_lex_state = 2},
  [5399] = {.lex_state = 96, .external_lex_state = 2},
  [5400] = {.lex_state = 96, .external_lex_state = 2},
  [5401] = {.lex_state = 96, .external_lex_state = 2},
  [5402] = {.lex_state = 96, .external_lex_state = 2},
  [5403] = {.lex_state = 96, .external_lex_state = 2},
  [5404] = {.lex_state = 96, .external_lex_state = 5},
  [5405] = {.lex_state = 96, .external_lex_state = 2},
  [5406] = {.lex_state = 96, .external_lex_state = 2},
  [5407] = {.lex_state = 96, .external_lex_state = 2},
  [5408] = {.lex_state = 96, .external_lex_state = 2},
  [5409] = {.lex_state = 96, .external_lex_state = 2},
  [5410] = {.lex_state = 96, .external_lex_state = 2},
  [5411] = {.lex_state = 96, .external_lex_state = 2},
  [5412] = {.lex_state = 96, .external_lex_state = 2},
  [5413] = {.lex_state = 96, .external_lex_state = 2},
  [5414] = {.lex_state = 96, .external_lex_state = 2},
  [5415] = {.lex_state = 96, .external_lex_state = 2},
  [5416] = {.lex_state = 96, .external_lex_state = 2},
  [5417] = {.lex_state = 96, .external_lex_state = 2},
  [5418] = {.lex_state = 96, .external_lex_state = 2},
  [5419] = {.lex_state = 96, .external_lex_state = 5},
  [5420] = {.lex_state = 96, .external_lex_state = 2},
  [5421] = {.lex_state = 96, .external_lex_state = 2},
  [5422] = {.lex_state = 96, .external_lex_state = 2},
  [5423] = {.lex_state = 96, .external_lex_state = 2},
  [5424] = {.lex_state = 96, .external_lex_state = 2},
  [5425] = {.lex_state = 96, .external_lex_state = 2},
  [5426] = {.lex_state = 96, .external_lex_state = 2},
  [5427] = {.lex_state = 96, .external_lex_state = 5},
  [5428] = {.lex_state = 96, .external_lex_state = 2},
  [5429] = {.lex_state = 96, .external_lex_state = 2},
  [5430] = {.lex_state = 96, .external_lex_state = 2},
  [5431] = {.lex_state = 96, .external_lex_state = 2},
  [5432] = {.lex_state = 96, .external_lex_state = 2},
  [5433] = {.lex_state = 96, .external_lex_state = 5},
  [5434] = {.lex_state = 96, .external_lex_state = 2},
  [5435] = {.lex_state = 96, .external_lex_state = 2},
  [5436] = {.lex_state = 96, .external_lex_state = 2},
  [5437] = {.lex_state = 96, .external_lex_state = 2},
  [5438] = {.lex_state = 96, .external_lex_state = 2},
  [5439] = {.lex_state = 96, .external_lex_state = 2},
  [5440] = {.lex_state = 96, .external_lex_state = 2},
  [5441] = {.lex_state = 96, .external_lex_state = 2},
  [5442] = {.lex_state = 96, .external_lex_state = 2},
  [5443] = {.lex_state = 96, .external_lex_state = 5},
  [5444] = {.lex_state = 96, .external_lex_state = 2},
  [5445] = {.lex_state = 96, .external_lex_state = 2},
  [5446] = {.lex_state = 96, .external_lex_state = 2},
  [5447] = {.lex_state = 96, .external_lex_state = 2},
  [5448] = {.lex_state = 96, .external_lex_state = 5},
  [5449] = {.lex_state = 96, .external_lex_state = 2},
  [5450] = {.lex_state = 96, .external_lex_state = 2},
  [5451] = {.lex_state = 96, .external_lex_state = 2},
  [5452] = {.lex_state = 96, .external_lex_state = 2},
  [5453] = {.lex_state = 96, .external_lex_state = 2},
  [5454] = {.lex_state = 96, .external_lex_state = 2},
  [5455] = {.lex_state = 96, .external_lex_state = 2},
  [5456] = {.lex_state = 96, .external_lex_state = 2},
  [5457] = {.lex_state = 96, .external_lex_state = 2},
  [5458] = {.lex_state = 96, .external_lex_state = 2},
  [5459] = {.lex_state = 96, .external_lex_state = 2},
  [5460] = {.lex_state = 96, .external_lex_state = 2},
  [5461] = {.lex_state = 96, .external_lex_state = 2},
  [5462] = {.lex_state = 96, .external_lex_state = 2},
  [5463] = {.lex_state = 96, .external_lex_state = 2},
  [5464] = {.lex_state = 96, .external_lex_state = 2},
  [5465] = {.lex_state = 96, .external_lex_state = 2},
  [5466] = {.lex_state = 96, .external_lex_state = 2},
  [5467] = {.lex_state = 96, .external_lex_state = 2},
  [5468] = {.lex_state = 96, .external_lex_state = 2},
  [5469] = {.lex_state = 96, .external_lex_state = 2},
  [5470] = {.lex_state = 96, .external_lex_state = 2},
  [5471] = {.lex_state = 96, .external_lex_state = 2},
  [5472] = {.lex_state = 96, .external_lex_state = 2},
  [5473] = {.lex_state = 96, .external_lex_state = 2},
  [5474] = {.lex_state = 96, .external_lex_state = 2},
  [5475] = {.lex_state = 96, .external_lex_state = 5},
  [5476] = {.lex_state = 96, .external_lex_state = 2},
  [5477] = {.lex_state = 96, .external_lex_state = 2},
  [5478] = {.lex_state = 96, .external_lex_state = 2},
  [5479] = {.lex_state = 96, .external_lex_state = 2},
  [5480] = {.lex_state = 96, .external_lex_state = 2},
  [5481] = {.lex_state = 96, .external_lex_state = 2},
  [5482] = {.lex_state = 96, .external_lex_state = 2},
  [5483] = {.lex_state = 96, .external_lex_state = 2},
  [5484] = {.lex_state = 96, .external_lex_state = 2},
  [5485] = {.lex_state = 96, .external_lex_state = 2},
  [5486] = {.lex_state = 2, .external_lex_state = 10},
  [5487] = {.lex_state = 96, .external_lex_state = 2},
  [5488] = {.lex_state = 96, .external_lex_state = 2},
  [5489] = {.lex_state = 96, .external_lex_state = 2},
  [5490] = {.lex_state = 96, .external_lex_state = 2},
  [5491] = {.lex_state = 96, .external_lex_state = 2},
  [5492] = {.lex_state = 96, .external_lex_state = 2},
  [5493] = {.lex_state = 96, .external_lex_state = 2},
  [5494] = {.lex_state = 96, .external_lex_state = 2},
  [5495] = {.lex_state = 96, .external_lex_state = 2},
  [5496] = {.lex_state = 2, .external_lex_state = 10},
  [5497] = {.lex_state = 96, .external_lex_state = 2},
  [5498] = {.lex_state = 96, .external_lex_state = 2},
  [5499] = {.lex_state = 96, .external_lex_state = 2},
  [5500] = {.lex_state = 96, .external_lex_state = 2},
  [5501] = {.lex_state = 96, .external_lex_state = 2},
  [5502] = {.lex_state = 96, .external_lex_state = 2},
  [5503] = {.lex_state = 96, .external_lex_state = 2},
  [5504] = {.lex_state = 96, .external_lex_state = 2},
  [5505] = {.lex_state = 96, .external_lex_state = 2},
  [5506] = {.lex_state = 96, .external_lex_state = 2},
  [5507] = {.lex_state = 96, .external_lex_state = 2},
  [5508] = {.lex_state = 96, .external_lex_state = 2},
  [5509] = {.lex_state = 96, .external_lex_state = 2},
  [5510] = {.lex_state = 96, .external_lex_state = 2},
  [5511] = {.lex_state = 96, .external_lex_state = 2},
  [5512] = {.lex_state = 96, .external_lex_state = 2},
  [5513] = {.lex_state = 96, .external_lex_state = 2},
  [5514] = {.lex_state = 96, .external_lex_state = 2},
  [5515] = {.lex_state = 96, .external_lex_state = 2},
  [5516] = {.lex_state = 96, .external_lex_state = 2},
  [5517] = {.lex_state = 2, .external_lex_state = 10},
  [5518] = {.lex_state = 96, .external_lex_state = 2},
  [5519] = {.lex_state = 96, .external_lex_state = 2},
  [5520] = {.lex_state = 96, .external_lex_state = 2},
  [5521] = {.lex_state = 96, .external_lex_state = 2},
  [5522] = {.lex_state = 96, .external_lex_state = 2},
  [5523] = {.lex_state = 96, .external_lex_state = 2},
  [5524] = {.lex_state = 96, .external_lex_state = 2},
  [5525] = {.lex_state = 96, .external_lex_state = 2},
  [5526] = {.lex_state = 96, .external_lex_state = 2},
  [5527] = {.lex_state = 96, .external_lex_state = 2},
  [5528] = {.lex_state = 96, .external_lex_state = 2},
  [5529] = {.lex_state = 96, .external_lex_state = 2},
  [5530] = {.lex_state = 96, .external_lex_state = 2},
  [5531] = {.lex_state = 96, .external_lex_state = 2},
  [5532] = {.lex_state = 96, .external_lex_state = 2},
  [5533] = {.lex_state = 96, .external_lex_state = 2},
  [5534] = {.lex_state = 96, .external_lex_state = 2},
  [5535] = {.lex_state = 96, .external_lex_state = 2},
  [5536] = {.lex_state = 96, .external_lex_state = 2},
  [5537] = {.lex_state = 96, .external_lex_state = 2},
  [5538] = {.lex_state = 96, .external_lex_state = 2},
  [5539] = {.lex_state = 96, .external_lex_state = 2},
  [5540] = {.lex_state = 96, .external_lex_state = 2},
  [5541] = {.lex_state = 96, .external_lex_state = 2},
  [5542] = {.lex_state = 96, .external_lex_state = 2},
  [5543] = {.lex_state = 96, .external_lex_state = 2},
  [5544] = {.lex_state = 96, .external_lex_state = 2},
  [5545] = {.lex_state = 96, .external_lex_state = 2},
  [5546] = {.lex_state = 96, .external_lex_state = 2},
  [5547] = {.lex_state = 96, .external_lex_state = 2},
  [5548] = {.lex_state = 96, .external_lex_state = 2},
  [5549] = {.lex_state = 96, .external_lex_state = 2},
  [5550] = {.lex_state = 96, .external_lex_state = 2},
  [5551] = {.lex_state = 96, .external_lex_state = 2},
  [5552] = {.lex_state = 96, .external_lex_state = 2},
  [5553] = {.lex_state = 96, .external_lex_state = 2},
  [5554] = {.lex_state = 96, .external_lex_state = 2},
  [5555] = {.lex_state = 96, .external_lex_state = 2},
  [5556] = {.lex_state = 96, .external_lex_state = 2},
  [5557] = {.lex_state = 96, .external_lex_state = 2},
  [5558] = {.lex_state = 96, .external_lex_state = 2},
  [5559] = {.lex_state = 96, .external_lex_state = 2},
  [5560] = {.lex_state = 96, .external_lex_state = 2},
  [5561] = {.lex_state = 96, .external_lex_state = 2},
  [5562] = {.lex_state = 96, .external_lex_state = 2},
  [5563] = {.lex_state = 96, .external_lex_state = 2},
  [5564] = {.lex_state = 96, .external_lex_state = 2},
  [5565] = {.lex_state = 96, .external_lex_state = 2},
  [5566] = {.lex_state = 96, .external_lex_state = 2},
  [5567] = {.lex_state = 96, .external_lex_state = 2},
  [5568] = {.lex_state = 96, .external_lex_state = 2},
  [5569] = {.lex_state = 96, .external_lex_state = 2},
  [5570] = {.lex_state = 96, .external_lex_state = 2},
  [5571] = {.lex_state = 96, .external_lex_state = 2},
  [5572] = {.lex_state = 96, .external_lex_state = 2},
  [5573] = {.lex_state = 96, .external_lex_state = 2},
  [5574] = {.lex_state = 96, .external_lex_state = 2},
  [5575] = {.lex_state = 96, .external_lex_state = 2},
  [5576] = {.lex_state = 96, .external_lex_state = 2},
  [5577] = {.lex_state = 96, .external_lex_state = 2},
  [5578] = {.lex_state = 96, .external_lex_state = 2},
  [5579] = {.lex_state = 96, .external_lex_state = 2},
  [5580] = {.lex_state = 96, .external_lex_state = 2},
  [5581] = {.lex_state = 28, .external_lex_state = 2},
  [5582] = {.lex_state = 96, .external_lex_state = 2},
  [5583] = {.lex_state = 96, .external_lex_state = 2},
  [5584] = {.lex_state = 96, .external_lex_state = 2},
  [5585] = {.lex_state = 96, .external_lex_state = 2},
  [5586] = {.lex_state = 96, .external_lex_state = 2},
  [5587] = {.lex_state = 96, .external_lex_state = 2},
  [5588] = {.lex_state = 96, .external_lex_state = 2},
  [5589] = {.lex_state = 96, .external_lex_state = 2},
  [5590] = {.lex_state = 96, .external_lex_state = 2},
  [5591] = {.lex_state = 96, .external_lex_state = 2},
  [5592] = {.lex_state = 96, .external_lex_state = 2},
  [5593] = {.lex_state = 96, .external_lex_state = 2},
  [5594] = {.lex_state = 96, .external_lex_state = 2},
  [5595] = {.lex_state = 96, .external_lex_state = 2},
  [5596] = {.lex_state = 96, .external_lex_state = 2},
  [5597] = {.lex_state = 96, .external_lex_state = 2},
  [5598] = {.lex_state = 96, .external_lex_state = 2},
  [5599] = {.lex_state = 96, .external_lex_state = 2},
  [5600] = {.lex_state = 96, .external_lex_state = 2},
  [5601] = {.lex_state = 96, .external_lex_state = 2},
  [5602] = {.lex_state = 96, .external_lex_state = 2},
  [5603] = {.lex_state = 96, .external_lex_state = 2},
  [5604] = {.lex_state = 96, .external_lex_state = 2},
  [5605] = {.lex_state = 96, .external_lex_state = 2},
  [5606] = {.lex_state = 96, .external_lex_state = 2},
  [5607] = {.lex_state = 96, .external_lex_state = 2},
  [5608] = {.lex_state = 96, .external_lex_state = 2},
  [5609] = {.lex_state = 96, .external_lex_state = 2},
  [5610] = {.lex_state = 96, .external_lex_state = 2},
  [5611] = {.lex_state = 28, .external_lex_state = 2},
  [5612] = {.lex_state = 96, .external_lex_state = 2},
  [5613] = {.lex_state = 96, .external_lex_state = 2},
  [5614] = {.lex_state = 96, .external_lex_state = 2},
  [5615] = {.lex_state = 96, .external_lex_state = 2},
  [5616] = {.lex_state = 96, .external_lex_state = 2},
  [5617] = {.lex_state = 96, .external_lex_state = 2},
  [5618] = {.lex_state = 96, .external_lex_state = 2},
  [5619] = {.lex_state = 96, .external_lex_state = 2},
  [5620] = {.lex_state = 96, .external_lex_state = 2},
  [5621] = {.lex_state = 96, .external_lex_state = 2},
  [5622] = {.lex_state = 96, .external_lex_state = 2},
  [5623] = {.lex_state = 96, .external_lex_state = 2},
  [5624] = {.lex_state = 96, .external_lex_state = 2},
  [5625] = {.lex_state = 96, .external_lex_state = 2},
  [5626] = {.lex_state = 2, .external_lex_state = 10},
  [5627] = {.lex_state = 96, .external_lex_state = 2},
  [5628] = {.lex_state = 96, .external_lex_state = 2},
  [5629] = {.lex_state = 96, .external_lex_state = 2},
  [5630] = {.lex_state = 96, .external_lex_state = 2},
  [5631] = {.lex_state = 96, .external_lex_state = 2},
  [5632] = {.lex_state = 96, .external_lex_state = 2},
  [5633] = {.lex_state = 96, .external_lex_state = 2},
  [5634] = {.lex_state = 96, .external_lex_state = 2},
  [5635] = {.lex_state = 96, .external_lex_state = 2},
  [5636] = {.lex_state = 96, .external_lex_state = 2},
  [5637] = {.lex_state = 96, .external_lex_state = 2},
  [5638] = {.lex_state = 96, .external_lex_state = 2},
  [5639] = {.lex_state = 96, .external_lex_state = 2},
  [5640] = {.lex_state = 96, .external_lex_state = 2},
  [5641] = {.lex_state = 96, .external_lex_state = 2},
  [5642] = {.lex_state = 96, .external_lex_state = 2},
  [5643] = {.lex_state = 96, .external_lex_state = 2},
  [5644] = {.lex_state = 96, .external_lex_state = 2},
  [5645] = {.lex_state = 96, .external_lex_state = 2},
  [5646] = {.lex_state = 96, .external_lex_state = 2},
  [5647] = {.lex_state = 96, .external_lex_state = 2},
  [5648] = {.lex_state = 96, .external_lex_state = 2},
  [5649] = {.lex_state = 96, .external_lex_state = 2},
  [5650] = {.lex_state = 96, .external_lex_state = 2},
  [5651] = {.lex_state = 96, .external_lex_state = 2},
  [5652] = {.lex_state = 96, .external_lex_state = 2},
  [5653] = {.lex_state = 96, .external_lex_state = 2},
  [5654] = {.lex_state = 96, .external_lex_state = 2},
  [5655] = {.lex_state = 96, .external_lex_state = 2},
  [5656] = {.lex_state = 96, .external_lex_state = 2},
  [5657] = {.lex_state = 96, .external_lex_state = 2},
  [5658] = {.lex_state = 96, .external_lex_state = 2},
  [5659] = {.lex_state = 96, .external_lex_state = 2},
  [5660] = {.lex_state = 96, .external_lex_state = 2},
  [5661] = {.lex_state = 96, .external_lex_state = 2},
  [5662] = {.lex_state = 96, .external_lex_state = 2},
  [5663] = {.lex_state = 96, .external_lex_state = 2},
  [5664] = {.lex_state = 96, .external_lex_state = 2},
  [5665] = {.lex_state = 96, .external_lex_state = 2},
  [5666] = {.lex_state = 96, .external_lex_state = 2},
  [5667] = {.lex_state = 96, .external_lex_state = 2},
  [5668] = {.lex_state = 28, .external_lex_state = 2},
  [5669] = {.lex_state = 28, .external_lex_state = 2},
  [5670] = {.lex_state = 96, .external_lex_state = 2},
  [5671] = {.lex_state = 2, .external_lex_state = 10},
  [5672] = {.lex_state = 96, .external_lex_state = 2},
  [5673] = {.lex_state = 96, .external_lex_state = 2},
  [5674] = {.lex_state = 96, .external_lex_state = 2},
  [5675] = {.lex_state = 96, .external_lex_state = 2},
  [5676] = {.lex_state = 96, .external_lex_state = 2},
  [5677] = {.lex_state = 96, .external_lex_state = 2},
  [5678] = {.lex_state = 96, .external_lex_state = 2},
  [5679] = {.lex_state = 96, .external_lex_state = 2},
  [5680] = {.lex_state = 96, .external_lex_state = 2},
  [5681] = {.lex_state = 96, .external_lex_state = 2},
  [5682] = {.lex_state = 96, .external_lex_state = 2},
  [5683] = {.lex_state = 96, .external_lex_state = 2},
  [5684] = {.lex_state = 96, .external_lex_state = 2},
  [5685] = {.lex_state = 96, .external_lex_state = 2},
  [5686] = {.lex_state = 96, .external_lex_state = 2},
  [5687] = {.lex_state = 96, .external_lex_state = 2},
  [5688] = {.lex_state = 96, .external_lex_state = 2},
  [5689] = {.lex_state = 96, .external_lex_state = 2},
  [5690] = {.lex_state = 96, .external_lex_state = 2},
  [5691] = {.lex_state = 96, .external_lex_state = 2},
  [5692] = {.lex_state = 96, .external_lex_state = 2},
  [5693] = {.lex_state = 96, .external_lex_state = 2},
  [5694] = {.lex_state = 96, .external_lex_state = 2},
  [5695] = {.lex_state = 96, .external_lex_state = 2},
  [5696] = {.lex_state = 96, .external_lex_state = 2},
  [5697] = {.lex_state = 96, .external_lex_state = 2},
  [5698] = {.lex_state = 96, .external_lex_state = 2},
  [5699] = {.lex_state = 96, .external_lex_state = 2},
  [5700] = {.lex_state = 96, .external_lex_state = 2},
  [5701] = {.lex_state = 96, .external_lex_state = 2},
  [5702] = {.lex_state = 96, .external_lex_state = 2},
  [5703] = {.lex_state = 96, .external_lex_state = 2},
  [5704] = {.lex_state = 96, .external_lex_state = 2},
  [5705] = {.lex_state = 96, .external_lex_state = 2},
  [5706] = {.lex_state = 96, .external_lex_state = 2},
  [5707] = {.lex_state = 96, .external_lex_state = 2},
  [5708] = {.lex_state = 96, .external_lex_state = 2},
  [5709] = {.lex_state = 96, .external_lex_state = 2},
  [5710] = {.lex_state = 96, .external_lex_state = 2},
  [5711] = {.lex_state = 96, .external_lex_state = 2},
  [5712] = {.lex_state = 96, .external_lex_state = 2},
  [5713] = {.lex_state = 96, .external_lex_state = 2},
  [5714] = {.lex_state = 96, .external_lex_state = 2},
  [5715] = {.lex_state = 96, .external_lex_state = 2},
  [5716] = {.lex_state = 96, .external_lex_state = 2},
  [5717] = {.lex_state = 96, .external_lex_state = 2},
  [5718] = {.lex_state = 96, .external_lex_state = 2},
  [5719] = {.lex_state = 96, .external_lex_state = 2},
  [5720] = {.lex_state = 96, .external_lex_state = 2},
  [5721] = {.lex_state = 96, .external_lex_state = 2},
  [5722] = {.lex_state = 96, .external_lex_state = 2},
  [5723] = {.lex_state = 96, .external_lex_state = 2},
  [5724] = {.lex_state = 96, .external_lex_state = 2},
  [5725] = {.lex_state = 96, .external_lex_state = 2},
  [5726] = {.lex_state = 96, .external_lex_state = 2},
  [5727] = {.lex_state = 96, .external_lex_state = 2},
  [5728] = {.lex_state = 96, .external_lex_state = 2},
  [5729] = {.lex_state = 96, .external_lex_state = 2},
  [5730] = {.lex_state = 96, .external_lex_state = 2},
  [5731] = {.lex_state = 96, .external_lex_state = 2},
  [5732] = {.lex_state = 96, .external_lex_state = 2},
  [5733] = {.lex_state = 96, .external_lex_state = 2},
  [5734] = {.lex_state = 96, .external_lex_state = 2},
  [5735] = {.lex_state = 96, .external_lex_state = 2},
  [5736] = {.lex_state = 96, .external_lex_state = 2},
  [5737] = {.lex_state = 96, .external_lex_state = 2},
  [5738] = {.lex_state = 96, .external_lex_state = 2},
  [5739] = {.lex_state = 96, .external_lex_state = 2},
  [5740] = {.lex_state = 96, .external_lex_state = 2},
  [5741] = {.lex_state = 96, .external_lex_state = 2},
  [5742] = {.lex_state = 96, .external_lex_state = 2},
  [5743] = {.lex_state = 96, .external_lex_state = 2},
  [5744] = {.lex_state = 96, .external_lex_state = 2},
  [5745] = {.lex_state = 96, .external_lex_state = 2},
  [5746] = {.lex_state = 96, .external_lex_state = 2},
  [5747] = {.lex_state = 96, .external_lex_state = 2},
  [5748] = {.lex_state = 96, .external_lex_state = 2},
  [5749] = {.lex_state = 96, .external_lex_state = 2},
  [5750] = {.lex_state = 96, .external_lex_state = 2},
  [5751] = {.lex_state = 96, .external_lex_state = 2},
  [5752] = {.lex_state = 96, .external_lex_state = 2},
  [5753] = {.lex_state = 96, .external_lex_state = 2},
  [5754] = {.lex_state = 96, .external_lex_state = 2},
  [5755] = {.lex_state = 96, .external_lex_state = 2},
  [5756] = {.lex_state = 96, .external_lex_state = 2},
  [5757] = {.lex_state = 96, .external_lex_state = 2},
  [5758] = {.lex_state = 96, .external_lex_state = 2},
  [5759] = {.lex_state = 96, .external_lex_state = 2},
  [5760] = {.lex_state = 96, .external_lex_state = 2},
  [5761] = {.lex_state = 96, .external_lex_state = 2},
  [5762] = {.lex_state = 96, .external_lex_state = 2},
  [5763] = {.lex_state = 96, .external_lex_state = 2},
  [5764] = {.lex_state = 96, .external_lex_state = 2},
  [5765] = {.lex_state = 96, .external_lex_state = 2},
  [5766] = {.lex_state = 96, .external_lex_state = 2},
  [5767] = {.lex_state = 96, .external_lex_state = 2},
  [5768] = {.lex_state = 96, .external_lex_state = 2},
  [5769] = {.lex_state = 96, .external_lex_state = 2},
  [5770] = {.lex_state = 96, .external_lex_state = 2},
  [5771] = {.lex_state = 96, .external_lex_state = 2},
  [5772] = {.lex_state = 96, .external_lex_state = 2},
  [5773] = {.lex_state = 96, .external_lex_state = 2},
  [5774] = {.lex_state = 96, .external_lex_state = 2},
  [5775] = {.lex_state = 96, .external_lex_state = 2},
  [5776] = {.lex_state = 96, .external_lex_state = 2},
  [5777] = {.lex_state = 96, .external_lex_state = 2},
  [5778] = {.lex_state = 96, .external_lex_state = 2},
  [5779] = {.lex_state = 96, .external_lex_state = 2},
  [5780] = {.lex_state = 96, .external_lex_state = 2},
  [5781] = {.lex_state = 96, .external_lex_state = 2},
  [5782] = {.lex_state = 96, .external_lex_state = 2},
  [5783] = {.lex_state = 96, .external_lex_state = 2},
  [5784] = {.lex_state = 96, .external_lex_state = 2},
  [5785] = {.lex_state = 96, .external_lex_state = 2},
  [5786] = {.lex_state = 96, .external_lex_state = 2},
  [5787] = {.lex_state = 96, .external_lex_state = 2},
  [5788] = {.lex_state = 96, .external_lex_state = 2},
  [5789] = {.lex_state = 96, .external_lex_state = 2},
  [5790] = {.lex_state = 96, .external_lex_state = 2},
  [5791] = {.lex_state = 96, .external_lex_state = 2},
  [5792] = {.lex_state = 96, .external_lex_state = 2},
  [5793] = {.lex_state = 96, .external_lex_state = 2},
  [5794] = {.lex_state = 96, .external_lex_state = 2},
  [5795] = {.lex_state = 96, .external_lex_state = 2},
  [5796] = {.lex_state = 96, .external_lex_state = 2},
  [5797] = {.lex_state = 96, .external_lex_state = 2},
  [5798] = {.lex_state = 96, .external_lex_state = 2},
  [5799] = {.lex_state = 96, .external_lex_state = 2},
  [5800] = {.lex_state = 96, .external_lex_state = 2},
  [5801] = {.lex_state = 96, .external_lex_state = 2},
  [5802] = {.lex_state = 96, .external_lex_state = 2},
  [5803] = {.lex_state = 96, .external_lex_state = 2},
  [5804] = {.lex_state = 96, .external_lex_state = 2},
  [5805] = {.lex_state = 96, .external_lex_state = 2},
  [5806] = {.lex_state = 96, .external_lex_state = 2},
  [5807] = {.lex_state = 96, .external_lex_state = 2},
  [5808] = {.lex_state = 96, .external_lex_state = 2},
  [5809] = {.lex_state = 96, .external_lex_state = 2},
  [5810] = {.lex_state = 96, .external_lex_state = 2},
  [5811] = {.lex_state = 96, .external_lex_state = 2},
  [5812] = {.lex_state = 96, .external_lex_state = 2},
  [5813] = {.lex_state = 96, .external_lex_state = 2},
  [5814] = {.lex_state = 96, .external_lex_state = 2},
  [5815] = {.lex_state = 96, .external_lex_state = 2},
  [5816] = {.lex_state = 96, .external_lex_state = 2},
  [5817] = {.lex_state = 96, .external_lex_state = 2},
  [5818] = {.lex_state = 96, .external_lex_state = 2},
  [5819] = {.lex_state = 96, .external_lex_state = 2},
  [5820] = {.lex_state = 96, .external_lex_state = 2},
  [5821] = {.lex_state = 96, .external_lex_state = 2},
  [5822] = {.lex_state = 96, .external_lex_state = 2},
  [5823] = {.lex_state = 96, .external_lex_state = 2},
  [5824] = {.lex_state = 96, .external_lex_state = 2},
  [5825] = {.lex_state = 96, .external_lex_state = 2},
  [5826] = {.lex_state = 96, .external_lex_state = 2},
  [5827] = {.lex_state = 96, .external_lex_state = 2},
  [5828] = {.lex_state = 96, .external_lex_state = 2},
  [5829] = {.lex_state = 96, .external_lex_state = 2},
  [5830] = {.lex_state = 96, .external_lex_state = 2},
  [5831] = {.lex_state = 96, .external_lex_state = 2},
  [5832] = {.lex_state = 96, .external_lex_state = 2},
  [5833] = {.lex_state = 96, .external_lex_state = 2},
  [5834] = {.lex_state = 28, .external_lex_state = 2},
  [5835] = {.lex_state = 96, .external_lex_state = 2},
  [5836] = {.lex_state = 96, .external_lex_state = 2},
  [5837] = {.lex_state = 96, .external_lex_state = 2},
  [5838] = {.lex_state = 96, .external_lex_state = 2},
  [5839] = {.lex_state = 96, .external_lex_state = 2},
  [5840] = {.lex_state = 96, .external_lex_state = 2},
  [5841] = {.lex_state = 96, .external_lex_state = 2},
  [5842] = {.lex_state = 96, .external_lex_state = 2},
  [5843] = {.lex_state = 96, .external_lex_state = 2},
  [5844] = {.lex_state = 96, .external_lex_state = 2},
  [5845] = {.lex_state = 96, .external_lex_state = 2},
  [5846] = {.lex_state = 96, .external_lex_state = 2},
  [5847] = {.lex_state = 96, .external_lex_state = 2},
  [5848] = {.lex_state = 96, .external_lex_state = 2},
  [5849] = {.lex_state = 96, .external_lex_state = 2},
  [5850] = {.lex_state = 96, .external_lex_state = 2},
  [5851] = {.lex_state = 96, .external_lex_state = 2},
  [5852] = {.lex_state = 96, .external_lex_state = 2},
  [5853] = {.lex_state = 96, .external_lex_state = 2},
  [5854] = {.lex_state = 96, .external_lex_state = 2},
  [5855] = {.lex_state = 96, .external_lex_state = 2},
  [5856] = {.lex_state = 96, .external_lex_state = 2},
  [5857] = {.lex_state = 96, .external_lex_state = 2},
  [5858] = {.lex_state = 96, .external_lex_state = 2},
  [5859] = {.lex_state = 96, .external_lex_state = 2},
  [5860] = {.lex_state = 96, .external_lex_state = 2},
  [5861] = {.lex_state = 96, .external_lex_state = 2},
  [5862] = {.lex_state = 96, .external_lex_state = 2},
  [5863] = {.lex_state = 96, .external_lex_state = 2},
  [5864] = {.lex_state = 96, .external_lex_state = 2},
  [5865] = {.lex_state = 96, .external_lex_state = 2},
  [5866] = {.lex_state = 96, .external_lex_state = 2},
  [5867] = {.lex_state = 96, .external_lex_state = 2},
  [5868] = {.lex_state = 96, .external_lex_state = 2},
  [5869] = {.lex_state = 96, .external_lex_state = 2},
  [5870] = {.lex_state = 96, .external_lex_state = 2},
  [5871] = {.lex_state = 96, .external_lex_state = 2},
  [5872] = {.lex_state = 96, .external_lex_state = 2},
  [5873] = {.lex_state = 96, .external_lex_state = 2},
  [5874] = {.lex_state = 96, .external_lex_state = 2},
  [5875] = {.lex_state = 96, .external_lex_state = 2},
  [5876] = {.lex_state = 96, .external_lex_state = 2},
  [5877] = {.lex_state = 96, .external_lex_state = 2},
  [5878] = {.lex_state = 96, .external_lex_state = 2},
  [5879] = {.lex_state = 96, .external_lex_state = 2},
  [5880] = {.lex_state = 96, .external_lex_state = 2},
  [5881] = {.lex_state = 96, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_glimmer_opening_tag] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [anon_sym_meta] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_accessor] = ACTIONS(1),
    [anon_sym_satisfies] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_PLUS_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym_html_comment] = ACTIONS(5),
    [sym_jsx_text] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
    [sym___error_recovery] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(5731),
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(17),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_import] = STATE(3702),
    [sym_parenthesized_expression] = STATE(1228),
    [sym_expression] = STATE(2615),
    [sym_primary_expression] = STATE(1512),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1691),
    [sym_object_pattern] = STATE(3739),
    [sym_array] = STATE(1691),
    [sym_array_pattern] = STATE(3739),
    [sym_glimmer_template] = STATE(1652),
    [sym_nested_identifier] = STATE(5868),
    [sym_class] = STATE(1691),
    [sym_function_expression] = STATE(1691),
    [sym_generator_function] = STATE(1691),
    [sym_arrow_function] = STATE(1691),
    [sym__call_signature] = STATE(5824),
    [sym_call_expression] = STATE(1691),
    [sym_new_expression] = STATE(1621),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1302),
    [sym_subscript_expression] = STATE(1302),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(2969),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(3739),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2255),
    [sym_template_string] = STATE(1691),
    [sym_regex] = STATE(1691),
    [sym_meta_property] = STATE(1691),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(4280),
    [sym_pattern] = STATE(4085),
    [sym_rest_pattern] = STATE(3605),
    [sym_non_null_expression] = STATE(1302),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2941),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2942),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2944),
    [sym_type] = STATE(3102),
    [sym_constructor_type] = STATE(2974),
    [sym_primary_type] = STATE(3014),
    [sym_template_literal_type] = STATE(3018),
    [sym_infer_type] = STATE(2974),
    [sym_conditional_type] = STATE(3018),
    [sym_generic_type] = STATE(3018),
    [sym_type_query] = STATE(3018),
    [sym_index_type_query] = STATE(3018),
    [sym_lookup_type] = STATE(3018),
    [sym_literal_type] = STATE(3018),
    [sym__number] = STATE(3031),
    [sym_existential_type] = STATE(3018),
    [sym_flow_maybe_type] = STATE(3018),
    [sym_parenthesized_type] = STATE(3018),
    [sym_predefined_type] = STATE(3018),
    [sym_type_arguments] = STATE(537),
    [sym_object_type] = STATE(3018),
    [sym_type_parameters] = STATE(5262),
    [sym_array_type] = STATE(3018),
    [sym_tuple_type] = STATE(3018),
    [sym_readonly_type] = STATE(2974),
    [sym_union_type] = STATE(3018),
    [sym_intersection_type] = STATE(3018),
    [sym_function_type] = STATE(2974),
    [aux_sym_export_statement_repeat1] = STATE(4423),
    [sym_identifier] = ACTIONS(113),
    [anon_sym_export] = ACTIONS(115),
    [anon_sym_STAR] = ACTIONS(117),
    [anon_sym_type] = ACTIONS(115),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_as] = ACTIONS(122),
    [anon_sym_namespace] = ACTIONS(124),
    [anon_sym_LBRACE] = ACTIONS(126),
    [anon_sym_COMMA] = ACTIONS(128),
    [anon_sym_typeof] = ACTIONS(130),
    [anon_sym_import] = ACTIONS(132),
    [anon_sym_let] = ACTIONS(115),
    [anon_sym_const] = ACTIONS(134),
    [anon_sym_BANG] = ACTIONS(136),
    [anon_sym_LPAREN] = ACTIONS(139),
    [anon_sym_RPAREN] = ACTIONS(128),
    [anon_sym_await] = ACTIONS(141),
    [anon_sym_in] = ACTIONS(122),
    [anon_sym_COLON] = ACTIONS(128),
    [anon_sym_yield] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(145),
    [sym_glimmer_opening_tag] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(122),
    [anon_sym_DOT] = ACTIONS(122),
    [anon_sym_DQUOTE] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_class] = ACTIONS(153),
    [anon_sym_async] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_EQ_GT] = ACTIONS(159),
    [anon_sym_QMARK_DOT] = ACTIONS(161),
    [anon_sym_new] = ACTIONS(163),
    [anon_sym_using] = ACTIONS(165),
    [anon_sym_PLUS_EQ] = ACTIONS(167),
    [anon_sym_DASH_EQ] = ACTIONS(167),
    [anon_sym_STAR_EQ] = ACTIONS(167),
    [anon_sym_SLASH_EQ] = ACTIONS(167),
    [anon_sym_PERCENT_EQ] = ACTIONS(167),
    [anon_sym_CARET_EQ] = ACTIONS(167),
    [anon_sym_AMP_EQ] = ACTIONS(167),
    [anon_sym_PIPE_EQ] = ACTIONS(167),
    [anon_sym_GT_GT_EQ] = ACTIONS(167),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(167),
    [anon_sym_LT_LT_EQ] = ACTIONS(167),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(167),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(167),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(167),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(167),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(122),
    [anon_sym_PIPE_PIPE] = ACTIONS(122),
    [anon_sym_GT_GT] = ACTIONS(122),
    [anon_sym_GT_GT_GT] = ACTIONS(122),
    [anon_sym_LT_LT] = ACTIONS(122),
    [anon_sym_AMP] = ACTIONS(171),
    [anon_sym_CARET] = ACTIONS(122),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(175),
    [anon_sym_DASH] = ACTIONS(175),
    [anon_sym_SLASH] = ACTIONS(177),
    [anon_sym_PERCENT] = ACTIONS(122),
    [anon_sym_STAR_STAR] = ACTIONS(122),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_LT_EQ] = ACTIONS(161),
    [anon_sym_EQ_EQ] = ACTIONS(122),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(161),
    [anon_sym_BANG_EQ] = ACTIONS(122),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(161),
    [anon_sym_GT_EQ] = ACTIONS(161),
    [anon_sym_QMARK_QMARK] = ACTIONS(122),
    [anon_sym_instanceof] = ACTIONS(122),
    [anon_sym_TILDE] = ACTIONS(180),
    [anon_sym_void] = ACTIONS(182),
    [anon_sym_delete] = ACTIONS(184),
    [anon_sym_PLUS_PLUS] = ACTIONS(186),
    [anon_sym_DASH_DASH] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [sym_number] = ACTIONS(191),
    [sym_private_property_identifier] = ACTIONS(193),
    [sym_this] = ACTIONS(195),
    [sym_super] = ACTIONS(197),
    [sym_true] = ACTIONS(199),
    [sym_false] = ACTIONS(199),
    [sym_null] = ACTIONS(199),
    [sym_undefined] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_readonly] = ACTIONS(203),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(115),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_declare] = ACTIONS(115),
    [anon_sym_public] = ACTIONS(115),
    [anon_sym_private] = ACTIONS(115),
    [anon_sym_protected] = ACTIONS(115),
    [anon_sym_override] = ACTIONS(115),
    [anon_sym_module] = ACTIONS(115),
    [anon_sym_any] = ACTIONS(207),
    [anon_sym_number] = ACTIONS(207),
    [anon_sym_boolean] = ACTIONS(207),
    [anon_sym_string] = ACTIONS(207),
    [anon_sym_symbol] = ACTIONS(207),
    [anon_sym_object] = ACTIONS(207),
    [anon_sym_abstract] = ACTIONS(209),
    [anon_sym_satisfies] = ACTIONS(122),
    [anon_sym_infer] = ACTIONS(211),
    [anon_sym_keyof] = ACTIONS(213),
    [anon_sym_unique] = ACTIONS(215),
    [anon_sym_unknown] = ACTIONS(217),
    [anon_sym_never] = ACTIONS(217),
    [anon_sym_LBRACE_PIPE] = ACTIONS(219),
    [sym__ternary_qmark] = ACTIONS(161),
    [sym_html_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_import] = STATE(3702),
    [sym_parenthesized_expression] = STATE(1228),
    [sym_expression] = STATE(2615),
    [sym_primary_expression] = STATE(1512),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1691),
    [sym_object_pattern] = STATE(3739),
    [sym_array] = STATE(1691),
    [sym_array_pattern] = STATE(3739),
    [sym_glimmer_template] = STATE(1652),
    [sym_nested_identifier] = STATE(5868),
    [sym_class] = STATE(1691),
    [sym_function_expression] = STATE(1691),
    [sym_generator_function] = STATE(1691),
    [sym_arrow_function] = STATE(1691),
    [sym__call_signature] = STATE(5824),
    [sym_call_expression] = STATE(1691),
    [sym_new_expression] = STATE(1621),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1302),
    [sym_subscript_expression] = STATE(1302),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(2969),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(3739),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2255),
    [sym_template_string] = STATE(1691),
    [sym_regex] = STATE(1691),
    [sym_meta_property] = STATE(1691),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(4280),
    [sym_pattern] = STATE(4085),
    [sym_rest_pattern] = STATE(3605),
    [sym_non_null_expression] = STATE(1302),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2941),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2942),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2944),
    [sym_type] = STATE(3102),
    [sym_constructor_type] = STATE(2974),
    [sym_primary_type] = STATE(3014),
    [sym_template_literal_type] = STATE(3018),
    [sym_infer_type] = STATE(2974),
    [sym_conditional_type] = STATE(3018),
    [sym_generic_type] = STATE(3018),
    [sym_type_query] = STATE(3018),
    [sym_index_type_query] = STATE(3018),
    [sym_lookup_type] = STATE(3018),
    [sym_literal_type] = STATE(3018),
    [sym__number] = STATE(3031),
    [sym_existential_type] = STATE(3018),
    [sym_flow_maybe_type] = STATE(3018),
    [sym_parenthesized_type] = STATE(3018),
    [sym_predefined_type] = STATE(3018),
    [sym_type_arguments] = STATE(537),
    [sym_object_type] = STATE(3018),
    [sym_type_parameters] = STATE(5262),
    [sym_array_type] = STATE(3018),
    [sym_tuple_type] = STATE(3018),
    [sym_readonly_type] = STATE(2974),
    [sym_union_type] = STATE(3018),
    [sym_intersection_type] = STATE(3018),
    [sym_function_type] = STATE(2974),
    [aux_sym_export_statement_repeat1] = STATE(4423),
    [sym_identifier] = ACTIONS(113),
    [anon_sym_export] = ACTIONS(115),
    [anon_sym_STAR] = ACTIONS(117),
    [anon_sym_type] = ACTIONS(115),
    [anon_sym_EQ] = ACTIONS(221),
    [anon_sym_as] = ACTIONS(122),
    [anon_sym_namespace] = ACTIONS(124),
    [anon_sym_LBRACE] = ACTIONS(126),
    [anon_sym_COMMA] = ACTIONS(224),
    [anon_sym_typeof] = ACTIONS(130),
    [anon_sym_import] = ACTIONS(132),
    [anon_sym_let] = ACTIONS(115),
    [anon_sym_const] = ACTIONS(134),
    [anon_sym_BANG] = ACTIONS(136),
    [anon_sym_LPAREN] = ACTIONS(139),
    [anon_sym_RPAREN] = ACTIONS(224),
    [anon_sym_await] = ACTIONS(141),
    [anon_sym_in] = ACTIONS(122),
    [anon_sym_COLON] = ACTIONS(224),
    [anon_sym_yield] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(145),
    [sym_glimmer_opening_tag] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(122),
    [anon_sym_DOT] = ACTIONS(122),
    [anon_sym_DQUOTE] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_class] = ACTIONS(153),
    [anon_sym_async] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_EQ_GT] = ACTIONS(227),
    [anon_sym_QMARK_DOT] = ACTIONS(161),
    [anon_sym_new] = ACTIONS(163),
    [anon_sym_using] = ACTIONS(165),
    [anon_sym_PLUS_EQ] = ACTIONS(167),
    [anon_sym_DASH_EQ] = ACTIONS(167),
    [anon_sym_STAR_EQ] = ACTIONS(167),
    [anon_sym_SLASH_EQ] = ACTIONS(167),
    [anon_sym_PERCENT_EQ] = ACTIONS(167),
    [anon_sym_CARET_EQ] = ACTIONS(167),
    [anon_sym_AMP_EQ] = ACTIONS(167),
    [anon_sym_PIPE_EQ] = ACTIONS(167),
    [anon_sym_GT_GT_EQ] = ACTIONS(167),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(167),
    [anon_sym_LT_LT_EQ] = ACTIONS(167),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(167),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(167),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(167),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(167),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(122),
    [anon_sym_PIPE_PIPE] = ACTIONS(122),
    [anon_sym_GT_GT] = ACTIONS(122),
    [anon_sym_GT_GT_GT] = ACTIONS(122),
    [anon_sym_LT_LT] = ACTIONS(122),
    [anon_sym_AMP] = ACTIONS(171),
    [anon_sym_CARET] = ACTIONS(122),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(175),
    [anon_sym_DASH] = ACTIONS(175),
    [anon_sym_SLASH] = ACTIONS(177),
    [anon_sym_PERCENT] = ACTIONS(122),
    [anon_sym_STAR_STAR] = ACTIONS(122),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_LT_EQ] = ACTIONS(161),
    [anon_sym_EQ_EQ] = ACTIONS(122),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(161),
    [anon_sym_BANG_EQ] = ACTIONS(122),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(161),
    [anon_sym_GT_EQ] = ACTIONS(161),
    [anon_sym_QMARK_QMARK] = ACTIONS(122),
    [anon_sym_instanceof] = ACTIONS(122),
    [anon_sym_TILDE] = ACTIONS(180),
    [anon_sym_void] = ACTIONS(182),
    [anon_sym_delete] = ACTIONS(184),
    [anon_sym_PLUS_PLUS] = ACTIONS(186),
    [anon_sym_DASH_DASH] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [sym_number] = ACTIONS(191),
    [sym_private_property_identifier] = ACTIONS(193),
    [sym_this] = ACTIONS(195),
    [sym_super] = ACTIONS(197),
    [sym_true] = ACTIONS(199),
    [sym_false] = ACTIONS(199),
    [sym_null] = ACTIONS(199),
    [sym_undefined] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_readonly] = ACTIONS(203),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(115),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_declare] = ACTIONS(115),
    [anon_sym_public] = ACTIONS(115),
    [anon_sym_private] = ACTIONS(115),
    [anon_sym_protected] = ACTIONS(115),
    [anon_sym_override] = ACTIONS(115),
    [anon_sym_module] = ACTIONS(115),
    [anon_sym_any] = ACTIONS(207),
    [anon_sym_number] = ACTIONS(207),
    [anon_sym_boolean] = ACTIONS(207),
    [anon_sym_string] = ACTIONS(207),
    [anon_sym_symbol] = ACTIONS(207),
    [anon_sym_object] = ACTIONS(207),
    [anon_sym_abstract] = ACTIONS(209),
    [anon_sym_satisfies] = ACTIONS(122),
    [anon_sym_infer] = ACTIONS(211),
    [anon_sym_keyof] = ACTIONS(213),
    [anon_sym_unique] = ACTIONS(215),
    [anon_sym_unknown] = ACTIONS(217),
    [anon_sym_never] = ACTIONS(217),
    [anon_sym_LBRACE_PIPE] = ACTIONS(219),
    [sym__ternary_qmark] = ACTIONS(161),
    [sym_html_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5836),
    [sym_object_assignment_pattern] = STATE(4567),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5836),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5836),
    [sym_spread_element] = STATE(4704),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2349),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_rest_pattern] = STATE(4567),
    [sym_method_definition] = STATE(4704),
    [sym_pair] = STATE(4704),
    [sym_pair_pattern] = STATE(4567),
    [sym__property_name] = STATE(3552),
    [sym_computed_property_name] = STATE(3552),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_accessibility_modifier] = STATE(2781),
    [sym_override_modifier] = STATE(2816),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [aux_sym_object_repeat1] = STATE(4657),
    [aux_sym_object_pattern_repeat1] = STATE(4878),
    [sym_identifier] = ACTIONS(229),
    [anon_sym_export] = ACTIONS(231),
    [anon_sym_STAR] = ACTIONS(233),
    [anon_sym_type] = ACTIONS(235),
    [anon_sym_namespace] = ACTIONS(237),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_RBRACE] = ACTIONS(241),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(243),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(245),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(247),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(249),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(253),
    [sym_private_property_identifier] = ACTIONS(255),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(257),
    [anon_sym_readonly] = ACTIONS(259),
    [anon_sym_get] = ACTIONS(261),
    [anon_sym_set] = ACTIONS(261),
    [anon_sym_declare] = ACTIONS(263),
    [anon_sym_public] = ACTIONS(265),
    [anon_sym_private] = ACTIONS(265),
    [anon_sym_protected] = ACTIONS(265),
    [anon_sym_override] = ACTIONS(267),
    [anon_sym_module] = ACTIONS(269),
    [anon_sym_any] = ACTIONS(271),
    [anon_sym_number] = ACTIONS(271),
    [anon_sym_boolean] = ACTIONS(271),
    [anon_sym_string] = ACTIONS(271),
    [anon_sym_symbol] = ACTIONS(271),
    [anon_sym_object] = ACTIONS(271),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5836),
    [sym_object_assignment_pattern] = STATE(4567),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5836),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5836),
    [sym_spread_element] = STATE(4704),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2349),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_rest_pattern] = STATE(4567),
    [sym_method_definition] = STATE(4704),
    [sym_pair] = STATE(4704),
    [sym_pair_pattern] = STATE(4567),
    [sym__property_name] = STATE(3552),
    [sym_computed_property_name] = STATE(3552),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_accessibility_modifier] = STATE(2781),
    [sym_override_modifier] = STATE(2816),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [aux_sym_object_repeat1] = STATE(4657),
    [aux_sym_object_pattern_repeat1] = STATE(4878),
    [sym_identifier] = ACTIONS(229),
    [anon_sym_export] = ACTIONS(231),
    [anon_sym_STAR] = ACTIONS(233),
    [anon_sym_type] = ACTIONS(235),
    [anon_sym_namespace] = ACTIONS(237),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_RBRACE] = ACTIONS(273),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(243),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(245),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(247),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(249),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(253),
    [sym_private_property_identifier] = ACTIONS(255),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(257),
    [anon_sym_readonly] = ACTIONS(259),
    [anon_sym_get] = ACTIONS(261),
    [anon_sym_set] = ACTIONS(261),
    [anon_sym_declare] = ACTIONS(263),
    [anon_sym_public] = ACTIONS(265),
    [anon_sym_private] = ACTIONS(265),
    [anon_sym_protected] = ACTIONS(265),
    [anon_sym_override] = ACTIONS(267),
    [anon_sym_module] = ACTIONS(269),
    [anon_sym_any] = ACTIONS(271),
    [anon_sym_number] = ACTIONS(271),
    [anon_sym_boolean] = ACTIONS(271),
    [anon_sym_string] = ACTIONS(271),
    [anon_sym_symbol] = ACTIONS(271),
    [anon_sym_object] = ACTIONS(271),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5836),
    [sym_object_assignment_pattern] = STATE(4567),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5836),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5836),
    [sym_spread_element] = STATE(4704),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2349),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_rest_pattern] = STATE(4567),
    [sym_method_definition] = STATE(4704),
    [sym_pair] = STATE(4704),
    [sym_pair_pattern] = STATE(4567),
    [sym__property_name] = STATE(3552),
    [sym_computed_property_name] = STATE(3552),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_accessibility_modifier] = STATE(2781),
    [sym_override_modifier] = STATE(2816),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [aux_sym_object_repeat1] = STATE(4657),
    [aux_sym_object_pattern_repeat1] = STATE(4878),
    [sym_identifier] = ACTIONS(229),
    [anon_sym_export] = ACTIONS(231),
    [anon_sym_STAR] = ACTIONS(233),
    [anon_sym_type] = ACTIONS(235),
    [anon_sym_namespace] = ACTIONS(237),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_RBRACE] = ACTIONS(275),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(243),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(245),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(247),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(249),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(253),
    [sym_private_property_identifier] = ACTIONS(255),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(257),
    [anon_sym_readonly] = ACTIONS(259),
    [anon_sym_get] = ACTIONS(261),
    [anon_sym_set] = ACTIONS(261),
    [anon_sym_declare] = ACTIONS(263),
    [anon_sym_public] = ACTIONS(265),
    [anon_sym_private] = ACTIONS(265),
    [anon_sym_protected] = ACTIONS(265),
    [anon_sym_override] = ACTIONS(267),
    [anon_sym_module] = ACTIONS(269),
    [anon_sym_any] = ACTIONS(271),
    [anon_sym_number] = ACTIONS(271),
    [anon_sym_boolean] = ACTIONS(271),
    [anon_sym_string] = ACTIONS(271),
    [anon_sym_symbol] = ACTIONS(271),
    [anon_sym_object] = ACTIONS(271),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(23),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5836),
    [sym_object_assignment_pattern] = STATE(4567),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5836),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5836),
    [sym_spread_element] = STATE(5136),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2349),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_rest_pattern] = STATE(4567),
    [sym_method_definition] = STATE(5136),
    [sym_pair] = STATE(5136),
    [sym_pair_pattern] = STATE(4567),
    [sym__property_name] = STATE(3552),
    [sym_computed_property_name] = STATE(3552),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_accessibility_modifier] = STATE(2781),
    [sym_override_modifier] = STATE(2816),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [aux_sym_object_repeat1] = STATE(4526),
    [aux_sym_object_pattern_repeat1] = STATE(4878),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_export] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(233),
    [anon_sym_type] = ACTIONS(281),
    [anon_sym_namespace] = ACTIONS(283),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(287),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(245),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(289),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(291),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(253),
    [sym_private_property_identifier] = ACTIONS(255),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(293),
    [anon_sym_readonly] = ACTIONS(295),
    [anon_sym_get] = ACTIONS(297),
    [anon_sym_set] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_public] = ACTIONS(301),
    [anon_sym_private] = ACTIONS(301),
    [anon_sym_protected] = ACTIONS(301),
    [anon_sym_override] = ACTIONS(303),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_any] = ACTIONS(307),
    [anon_sym_number] = ACTIONS(307),
    [anon_sym_boolean] = ACTIONS(307),
    [anon_sym_string] = ACTIONS(307),
    [anon_sym_symbol] = ACTIONS(307),
    [anon_sym_object] = ACTIONS(307),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(23),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5836),
    [sym_object_assignment_pattern] = STATE(4567),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5836),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5836),
    [sym_spread_element] = STATE(5136),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2349),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_rest_pattern] = STATE(4567),
    [sym_method_definition] = STATE(5136),
    [sym_pair] = STATE(5136),
    [sym_pair_pattern] = STATE(4567),
    [sym__property_name] = STATE(3552),
    [sym_computed_property_name] = STATE(3552),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_accessibility_modifier] = STATE(2781),
    [sym_override_modifier] = STATE(2816),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [aux_sym_object_repeat1] = STATE(4526),
    [aux_sym_object_pattern_repeat1] = STATE(4878),
    [sym_identifier] = ACTIONS(309),
    [anon_sym_export] = ACTIONS(311),
    [anon_sym_STAR] = ACTIONS(233),
    [anon_sym_type] = ACTIONS(313),
    [anon_sym_namespace] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(245),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(319),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(321),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(253),
    [sym_private_property_identifier] = ACTIONS(255),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_readonly] = ACTIONS(325),
    [anon_sym_get] = ACTIONS(327),
    [anon_sym_set] = ACTIONS(327),
    [anon_sym_declare] = ACTIONS(329),
    [anon_sym_public] = ACTIONS(331),
    [anon_sym_private] = ACTIONS(331),
    [anon_sym_protected] = ACTIONS(331),
    [anon_sym_override] = ACTIONS(333),
    [anon_sym_module] = ACTIONS(335),
    [anon_sym_any] = ACTIONS(337),
    [anon_sym_number] = ACTIONS(337),
    [anon_sym_boolean] = ACTIONS(337),
    [anon_sym_string] = ACTIONS(337),
    [anon_sym_symbol] = ACTIONS(337),
    [anon_sym_object] = ACTIONS(337),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [ts_builtin_sym_end] = ACTIONS(339),
    [sym_identifier] = ACTIONS(341),
    [anon_sym_export] = ACTIONS(344),
    [anon_sym_default] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(349),
    [anon_sym_namespace] = ACTIONS(352),
    [anon_sym_LBRACE] = ACTIONS(355),
    [anon_sym_RBRACE] = ACTIONS(339),
    [anon_sym_typeof] = ACTIONS(358),
    [anon_sym_import] = ACTIONS(361),
    [anon_sym_with] = ACTIONS(364),
    [anon_sym_var] = ACTIONS(367),
    [anon_sym_let] = ACTIONS(370),
    [anon_sym_const] = ACTIONS(373),
    [anon_sym_BANG] = ACTIONS(376),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(388),
    [anon_sym_SEMI] = ACTIONS(391),
    [anon_sym_await] = ACTIONS(394),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_do] = ACTIONS(400),
    [anon_sym_try] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(406),
    [anon_sym_continue] = ACTIONS(409),
    [anon_sym_debugger] = ACTIONS(412),
    [anon_sym_return] = ACTIONS(415),
    [anon_sym_throw] = ACTIONS(418),
    [anon_sym_case] = ACTIONS(347),
    [anon_sym_yield] = ACTIONS(421),
    [anon_sym_LBRACK] = ACTIONS(424),
    [sym_glimmer_opening_tag] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(430),
    [anon_sym_SQUOTE] = ACTIONS(433),
    [anon_sym_class] = ACTIONS(436),
    [anon_sym_async] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(442),
    [anon_sym_new] = ACTIONS(445),
    [anon_sym_using] = ACTIONS(448),
    [anon_sym_PLUS] = ACTIONS(358),
    [anon_sym_DASH] = ACTIONS(358),
    [anon_sym_SLASH] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(454),
    [anon_sym_TILDE] = ACTIONS(376),
    [anon_sym_void] = ACTIONS(358),
    [anon_sym_delete] = ACTIONS(358),
    [anon_sym_PLUS_PLUS] = ACTIONS(457),
    [anon_sym_DASH_DASH] = ACTIONS(457),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(460),
    [sym_number] = ACTIONS(463),
    [sym_private_property_identifier] = ACTIONS(466),
    [sym_this] = ACTIONS(469),
    [sym_super] = ACTIONS(469),
    [sym_true] = ACTIONS(469),
    [sym_false] = ACTIONS(469),
    [sym_null] = ACTIONS(469),
    [sym_undefined] = ACTIONS(472),
    [anon_sym_AT] = ACTIONS(475),
    [anon_sym_static] = ACTIONS(478),
    [anon_sym_readonly] = ACTIONS(478),
    [anon_sym_get] = ACTIONS(478),
    [anon_sym_set] = ACTIONS(478),
    [anon_sym_declare] = ACTIONS(481),
    [anon_sym_public] = ACTIONS(478),
    [anon_sym_private] = ACTIONS(478),
    [anon_sym_protected] = ACTIONS(478),
    [anon_sym_override] = ACTIONS(478),
    [anon_sym_module] = ACTIONS(484),
    [anon_sym_any] = ACTIONS(478),
    [anon_sym_number] = ACTIONS(478),
    [anon_sym_boolean] = ACTIONS(478),
    [anon_sym_string] = ACTIONS(478),
    [anon_sym_symbol] = ACTIONS(478),
    [anon_sym_object] = ACTIONS(478),
    [anon_sym_abstract] = ACTIONS(487),
    [anon_sym_interface] = ACTIONS(490),
    [anon_sym_enum] = ACTIONS(493),
    [sym_html_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(13),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(496),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(498),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(496),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(500),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(502),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(500),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(11),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(504),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(506),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(504),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(510),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(508),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(512),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [ts_builtin_sym_end] = ACTIONS(514),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(516),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [ts_builtin_sym_end] = ACTIONS(518),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(520),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(20),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(522),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(524),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(526),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(23),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(528),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(530),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(532),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(24),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(30),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(30),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(538),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(26),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(26),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(15),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [ts_builtin_sym_end] = ACTIONS(518),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(919),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(848),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(4696),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(931),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(866),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(931),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(883),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_import] = STATE(3634),
    [sym_parenthesized_expression] = STATE(1324),
    [sym_expression] = STATE(2136),
    [sym_primary_expression] = STATE(1512),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1691),
    [sym_object_pattern] = STATE(4448),
    [sym_assignment_pattern] = STATE(5020),
    [sym_array] = STATE(1691),
    [sym_array_pattern] = STATE(4448),
    [sym_glimmer_template] = STATE(1652),
    [sym_nested_identifier] = STATE(5868),
    [sym_class] = STATE(1691),
    [sym_function_expression] = STATE(1691),
    [sym_generator_function] = STATE(1691),
    [sym_arrow_function] = STATE(1691),
    [sym__call_signature] = STATE(5565),
    [sym_call_expression] = STATE(1691),
    [sym_new_expression] = STATE(1621),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1399),
    [sym_subscript_expression] = STATE(1399),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(2958),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(4448),
    [sym_spread_element] = STATE(5119),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2255),
    [sym_template_string] = STATE(1691),
    [sym_regex] = STATE(1691),
    [sym_meta_property] = STATE(1691),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(4342),
    [sym_pattern] = STATE(4511),
    [sym_rest_pattern] = STATE(4089),
    [sym_non_null_expression] = STATE(1399),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2941),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3315),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2944),
    [sym_type] = STATE(3832),
    [sym_tuple_parameter] = STATE(4915),
    [sym_optional_tuple_parameter] = STATE(4915),
    [sym_optional_type] = STATE(4915),
    [sym_rest_type] = STATE(4915),
    [sym__tuple_type_member] = STATE(4915),
    [sym_constructor_type] = STATE(2974),
    [sym_primary_type] = STATE(3014),
    [sym_template_literal_type] = STATE(3018),
    [sym_infer_type] = STATE(2974),
    [sym_conditional_type] = STATE(3018),
    [sym_generic_type] = STATE(3018),
    [sym_type_query] = STATE(3018),
    [sym_index_type_query] = STATE(3018),
    [sym_lookup_type] = STATE(3018),
    [sym_literal_type] = STATE(3018),
    [sym__number] = STATE(3031),
    [sym_existential_type] = STATE(3018),
    [sym_flow_maybe_type] = STATE(3018),
    [sym_parenthesized_type] = STATE(3018),
    [sym_predefined_type] = STATE(3018),
    [sym_type_arguments] = STATE(482),
    [sym_object_type] = STATE(3018),
    [sym_type_parameters] = STATE(5465),
    [sym_array_type] = STATE(3018),
    [sym_tuple_type] = STATE(3018),
    [sym_readonly_type] = STATE(2974),
    [sym_union_type] = STATE(3018),
    [sym_intersection_type] = STATE(3018),
    [sym_function_type] = STATE(2974),
    [aux_sym_export_statement_repeat1] = STATE(4423),
    [aux_sym_array_repeat1] = STATE(4579),
    [aux_sym_array_pattern_repeat1] = STATE(4615),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_export] = ACTIONS(580),
    [anon_sym_STAR] = ACTIONS(582),
    [anon_sym_type] = ACTIONS(580),
    [anon_sym_namespace] = ACTIONS(584),
    [anon_sym_LBRACE] = ACTIONS(586),
    [anon_sym_COMMA] = ACTIONS(588),
    [anon_sym_typeof] = ACTIONS(590),
    [anon_sym_import] = ACTIONS(132),
    [anon_sym_let] = ACTIONS(580),
    [anon_sym_const] = ACTIONS(134),
    [anon_sym_BANG] = ACTIONS(592),
    [anon_sym_LPAREN] = ACTIONS(139),
    [anon_sym_await] = ACTIONS(594),
    [anon_sym_yield] = ACTIONS(596),
    [anon_sym_LBRACK] = ACTIONS(598),
    [anon_sym_RBRACK] = ACTIONS(600),
    [sym_glimmer_opening_tag] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_class] = ACTIONS(153),
    [anon_sym_async] = ACTIONS(602),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_new] = ACTIONS(604),
    [anon_sym_using] = ACTIONS(606),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(608),
    [anon_sym_AMP] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(614),
    [anon_sym_DASH] = ACTIONS(614),
    [anon_sym_SLASH] = ACTIONS(616),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(592),
    [anon_sym_void] = ACTIONS(618),
    [anon_sym_delete] = ACTIONS(620),
    [anon_sym_PLUS_PLUS] = ACTIONS(622),
    [anon_sym_DASH_DASH] = ACTIONS(622),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [sym_number] = ACTIONS(191),
    [sym_private_property_identifier] = ACTIONS(624),
    [sym_this] = ACTIONS(626),
    [sym_super] = ACTIONS(197),
    [sym_true] = ACTIONS(199),
    [sym_false] = ACTIONS(199),
    [sym_null] = ACTIONS(199),
    [sym_undefined] = ACTIONS(628),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_readonly] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(580),
    [anon_sym_set] = ACTIONS(580),
    [anon_sym_QMARK] = ACTIONS(632),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(580),
    [anon_sym_private] = ACTIONS(580),
    [anon_sym_protected] = ACTIONS(580),
    [anon_sym_override] = ACTIONS(580),
    [anon_sym_module] = ACTIONS(580),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_object] = ACTIONS(634),
    [anon_sym_abstract] = ACTIONS(636),
    [anon_sym_infer] = ACTIONS(638),
    [anon_sym_keyof] = ACTIONS(640),
    [anon_sym_unique] = ACTIONS(215),
    [anon_sym_unknown] = ACTIONS(217),
    [anon_sym_never] = ACTIONS(217),
    [anon_sym_LBRACE_PIPE] = ACTIONS(219),
    [sym_html_comment] = ACTIONS(5),
  },
  [39] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(5503),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [40] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(876),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [41] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(819),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [42] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(821),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [43] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(827),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [44] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(826),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [45] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(807),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [46] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(838),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [47] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(853),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(2470),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3845),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(548),
    [anon_sym_namespace] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_readonly] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [anon_sym_declare] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_override] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_any] = ACTIONS(572),
    [anon_sym_number] = ACTIONS(572),
    [anon_sym_boolean] = ACTIONS(572),
    [anon_sym_string] = ACTIONS(572),
    [anon_sym_symbol] = ACTIONS(572),
    [anon_sym_object] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [48] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(876),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [49] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(866),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [50] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(932),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [51] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(919),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [52] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(819),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [53] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(821),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [54] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(827),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [55] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(848),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [56] = {
    [sym_import] = STATE(3634),
    [sym_parenthesized_expression] = STATE(1324),
    [sym_expression] = STATE(2177),
    [sym_primary_expression] = STATE(1512),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1691),
    [sym_object_pattern] = STATE(4448),
    [sym_assignment_pattern] = STATE(5020),
    [sym_array] = STATE(1691),
    [sym_array_pattern] = STATE(4448),
    [sym_glimmer_template] = STATE(1652),
    [sym_nested_identifier] = STATE(5868),
    [sym_class] = STATE(1691),
    [sym_function_expression] = STATE(1691),
    [sym_generator_function] = STATE(1691),
    [sym_arrow_function] = STATE(1691),
    [sym__call_signature] = STATE(5565),
    [sym_call_expression] = STATE(1691),
    [sym_new_expression] = STATE(1621),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1399),
    [sym_subscript_expression] = STATE(1399),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(2958),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(4448),
    [sym_spread_element] = STATE(4622),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2255),
    [sym_template_string] = STATE(1691),
    [sym_regex] = STATE(1691),
    [sym_meta_property] = STATE(1691),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(4342),
    [sym_pattern] = STATE(4511),
    [sym_rest_pattern] = STATE(4089),
    [sym_non_null_expression] = STATE(1399),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2941),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3315),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2944),
    [sym_type] = STATE(3832),
    [sym_tuple_parameter] = STATE(4915),
    [sym_optional_tuple_parameter] = STATE(4915),
    [sym_optional_type] = STATE(4915),
    [sym_rest_type] = STATE(4915),
    [sym__tuple_type_member] = STATE(4915),
    [sym_constructor_type] = STATE(2974),
    [sym_primary_type] = STATE(3014),
    [sym_template_literal_type] = STATE(3018),
    [sym_infer_type] = STATE(2974),
    [sym_conditional_type] = STATE(3018),
    [sym_generic_type] = STATE(3018),
    [sym_type_query] = STATE(3018),
    [sym_index_type_query] = STATE(3018),
    [sym_lookup_type] = STATE(3018),
    [sym_literal_type] = STATE(3018),
    [sym__number] = STATE(3031),
    [sym_existential_type] = STATE(3018),
    [sym_flow_maybe_type] = STATE(3018),
    [sym_parenthesized_type] = STATE(3018),
    [sym_predefined_type] = STATE(3018),
    [sym_type_arguments] = STATE(482),
    [sym_object_type] = STATE(3018),
    [sym_type_parameters] = STATE(5465),
    [sym_array_type] = STATE(3018),
    [sym_tuple_type] = STATE(3018),
    [sym_readonly_type] = STATE(2974),
    [sym_union_type] = STATE(3018),
    [sym_intersection_type] = STATE(3018),
    [sym_function_type] = STATE(2974),
    [aux_sym_export_statement_repeat1] = STATE(4423),
    [aux_sym_array_repeat1] = STATE(4627),
    [aux_sym_array_pattern_repeat1] = STATE(4615),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_export] = ACTIONS(580),
    [anon_sym_STAR] = ACTIONS(582),
    [anon_sym_type] = ACTIONS(580),
    [anon_sym_namespace] = ACTIONS(584),
    [anon_sym_LBRACE] = ACTIONS(586),
    [anon_sym_COMMA] = ACTIONS(588),
    [anon_sym_typeof] = ACTIONS(590),
    [anon_sym_import] = ACTIONS(132),
    [anon_sym_let] = ACTIONS(580),
    [anon_sym_const] = ACTIONS(134),
    [anon_sym_BANG] = ACTIONS(592),
    [anon_sym_LPAREN] = ACTIONS(139),
    [anon_sym_await] = ACTIONS(594),
    [anon_sym_yield] = ACTIONS(596),
    [anon_sym_LBRACK] = ACTIONS(598),
    [anon_sym_RBRACK] = ACTIONS(642),
    [sym_glimmer_opening_tag] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_class] = ACTIONS(153),
    [anon_sym_async] = ACTIONS(602),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_new] = ACTIONS(604),
    [anon_sym_using] = ACTIONS(606),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(608),
    [anon_sym_AMP] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(614),
    [anon_sym_DASH] = ACTIONS(614),
    [anon_sym_SLASH] = ACTIONS(616),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(592),
    [anon_sym_void] = ACTIONS(618),
    [anon_sym_delete] = ACTIONS(620),
    [anon_sym_PLUS_PLUS] = ACTIONS(622),
    [anon_sym_DASH_DASH] = ACTIONS(622),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [sym_number] = ACTIONS(191),
    [sym_private_property_identifier] = ACTIONS(624),
    [sym_this] = ACTIONS(626),
    [sym_super] = ACTIONS(197),
    [sym_true] = ACTIONS(199),
    [sym_false] = ACTIONS(199),
    [sym_null] = ACTIONS(199),
    [sym_undefined] = ACTIONS(628),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_readonly] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(580),
    [anon_sym_set] = ACTIONS(580),
    [anon_sym_QMARK] = ACTIONS(632),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(580),
    [anon_sym_private] = ACTIONS(580),
    [anon_sym_protected] = ACTIONS(580),
    [anon_sym_override] = ACTIONS(580),
    [anon_sym_module] = ACTIONS(580),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_object] = ACTIONS(634),
    [anon_sym_abstract] = ACTIONS(636),
    [anon_sym_infer] = ACTIONS(638),
    [anon_sym_keyof] = ACTIONS(640),
    [anon_sym_unique] = ACTIONS(215),
    [anon_sym_unknown] = ACTIONS(217),
    [anon_sym_never] = ACTIONS(217),
    [anon_sym_LBRACE_PIPE] = ACTIONS(219),
    [sym_html_comment] = ACTIONS(5),
  },
  [57] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(826),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [58] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(807),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [59] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(838),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [60] = {
    [sym_import] = STATE(3634),
    [sym_parenthesized_expression] = STATE(1324),
    [sym_expression] = STATE(2177),
    [sym_primary_expression] = STATE(1512),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1691),
    [sym_object_pattern] = STATE(4448),
    [sym_assignment_pattern] = STATE(5020),
    [sym_array] = STATE(1691),
    [sym_array_pattern] = STATE(4448),
    [sym_glimmer_template] = STATE(1652),
    [sym_nested_identifier] = STATE(5868),
    [sym_class] = STATE(1691),
    [sym_function_expression] = STATE(1691),
    [sym_generator_function] = STATE(1691),
    [sym_arrow_function] = STATE(1691),
    [sym__call_signature] = STATE(5565),
    [sym_call_expression] = STATE(1691),
    [sym_new_expression] = STATE(1621),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1399),
    [sym_subscript_expression] = STATE(1399),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(2958),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(4448),
    [sym_spread_element] = STATE(4622),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2255),
    [sym_template_string] = STATE(1691),
    [sym_regex] = STATE(1691),
    [sym_meta_property] = STATE(1691),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(4342),
    [sym_pattern] = STATE(4511),
    [sym_rest_pattern] = STATE(4089),
    [sym_non_null_expression] = STATE(1399),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2941),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3315),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2944),
    [sym_type] = STATE(3832),
    [sym_tuple_parameter] = STATE(4915),
    [sym_optional_tuple_parameter] = STATE(4915),
    [sym_optional_type] = STATE(4915),
    [sym_rest_type] = STATE(4915),
    [sym__tuple_type_member] = STATE(4915),
    [sym_constructor_type] = STATE(2974),
    [sym_primary_type] = STATE(3014),
    [sym_template_literal_type] = STATE(3018),
    [sym_infer_type] = STATE(2974),
    [sym_conditional_type] = STATE(3018),
    [sym_generic_type] = STATE(3018),
    [sym_type_query] = STATE(3018),
    [sym_index_type_query] = STATE(3018),
    [sym_lookup_type] = STATE(3018),
    [sym_literal_type] = STATE(3018),
    [sym__number] = STATE(3031),
    [sym_existential_type] = STATE(3018),
    [sym_flow_maybe_type] = STATE(3018),
    [sym_parenthesized_type] = STATE(3018),
    [sym_predefined_type] = STATE(3018),
    [sym_type_arguments] = STATE(482),
    [sym_object_type] = STATE(3018),
    [sym_type_parameters] = STATE(5465),
    [sym_array_type] = STATE(3018),
    [sym_tuple_type] = STATE(3018),
    [sym_readonly_type] = STATE(2974),
    [sym_union_type] = STATE(3018),
    [sym_intersection_type] = STATE(3018),
    [sym_function_type] = STATE(2974),
    [aux_sym_export_statement_repeat1] = STATE(4423),
    [aux_sym_array_repeat1] = STATE(4627),
    [aux_sym_array_pattern_repeat1] = STATE(4615),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_export] = ACTIONS(580),
    [anon_sym_STAR] = ACTIONS(582),
    [anon_sym_type] = ACTIONS(580),
    [anon_sym_namespace] = ACTIONS(584),
    [anon_sym_LBRACE] = ACTIONS(586),
    [anon_sym_COMMA] = ACTIONS(588),
    [anon_sym_typeof] = ACTIONS(590),
    [anon_sym_import] = ACTIONS(132),
    [anon_sym_let] = ACTIONS(580),
    [anon_sym_const] = ACTIONS(134),
    [anon_sym_BANG] = ACTIONS(592),
    [anon_sym_LPAREN] = ACTIONS(139),
    [anon_sym_await] = ACTIONS(594),
    [anon_sym_yield] = ACTIONS(596),
    [anon_sym_LBRACK] = ACTIONS(598),
    [anon_sym_RBRACK] = ACTIONS(644),
    [sym_glimmer_opening_tag] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_class] = ACTIONS(153),
    [anon_sym_async] = ACTIONS(602),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_new] = ACTIONS(604),
    [anon_sym_using] = ACTIONS(606),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(608),
    [anon_sym_AMP] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(614),
    [anon_sym_DASH] = ACTIONS(614),
    [anon_sym_SLASH] = ACTIONS(616),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(592),
    [anon_sym_void] = ACTIONS(618),
    [anon_sym_delete] = ACTIONS(620),
    [anon_sym_PLUS_PLUS] = ACTIONS(622),
    [anon_sym_DASH_DASH] = ACTIONS(622),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [sym_number] = ACTIONS(191),
    [sym_private_property_identifier] = ACTIONS(624),
    [sym_this] = ACTIONS(626),
    [sym_super] = ACTIONS(197),
    [sym_true] = ACTIONS(199),
    [sym_false] = ACTIONS(199),
    [sym_null] = ACTIONS(199),
    [sym_undefined] = ACTIONS(628),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_readonly] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(580),
    [anon_sym_set] = ACTIONS(580),
    [anon_sym_QMARK] = ACTIONS(632),
    [anon_sym_declare] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(580),
    [anon_sym_private] = ACTIONS(580),
    [anon_sym_protected] = ACTIONS(580),
    [anon_sym_override] = ACTIONS(580),
    [anon_sym_module] = ACTIONS(580),
    [anon_sym_any] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_boolean] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_symbol] = ACTIONS(634),
    [anon_sym_object] = ACTIONS(634),
    [anon_sym_abstract] = ACTIONS(636),
    [anon_sym_infer] = ACTIONS(638),
    [anon_sym_keyof] = ACTIONS(640),
    [anon_sym_unique] = ACTIONS(215),
    [anon_sym_unknown] = ACTIONS(217),
    [anon_sym_never] = ACTIONS(217),
    [anon_sym_LBRACE_PIPE] = ACTIONS(219),
    [sym_html_comment] = ACTIONS(5),
  },
  [61] = {
    [sym_export_statement] = STATE(888),
    [sym_declaration] = STATE(888),
    [sym_import] = STATE(3513),
    [sym_import_statement] = STATE(888),
    [sym_statement] = STATE(853),
    [sym_expression_statement] = STATE(888),
    [sym_variable_declaration] = STATE(836),
    [sym_lexical_declaration] = STATE(836),
    [sym_statement_block] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_switch_statement] = STATE(888),
    [sym_for_statement] = STATE(888),
    [sym_for_in_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_do_statement] = STATE(888),
    [sym_try_statement] = STATE(888),
    [sym_with_statement] = STATE(888),
    [sym_break_statement] = STATE(888),
    [sym_continue_statement] = STATE(888),
    [sym_debugger_statement] = STATE(888),
    [sym_return_statement] = STATE(888),
    [sym_throw_statement] = STATE(888),
    [sym_empty_statement] = STATE(888),
    [sym_labeled_statement] = STATE(888),
    [sym_parenthesized_expression] = STATE(1353),
    [sym_expression] = STATE(1940),
    [sym_primary_expression] = STATE(1833),
    [sym_yield_expression] = STATE(2130),
    [sym_object] = STATE(2117),
    [sym_object_pattern] = STATE(5484),
    [sym_array] = STATE(2117),
    [sym_array_pattern] = STATE(5484),
    [sym_glimmer_template] = STATE(2130),
    [sym_class] = STATE(2117),
    [sym_class_declaration] = STATE(836),
    [sym_function_expression] = STATE(2117),
    [sym_function_declaration] = STATE(836),
    [sym_generator_function] = STATE(2117),
    [sym_generator_function_declaration] = STATE(836),
    [sym_arrow_function] = STATE(2117),
    [sym__call_signature] = STATE(5525),
    [sym_call_expression] = STATE(2117),
    [sym_new_expression] = STATE(1963),
    [sym_await_expression] = STATE(2130),
    [sym_member_expression] = STATE(1353),
    [sym_subscript_expression] = STATE(1353),
    [sym_assignment_expression] = STATE(2130),
    [sym__augmented_assignment_lhs] = STATE(3036),
    [sym_augmented_assignment_expression] = STATE(2130),
    [sym__destructuring_pattern] = STATE(5484),
    [sym_ternary_expression] = STATE(2130),
    [sym_binary_expression] = STATE(2130),
    [sym_unary_expression] = STATE(2130),
    [sym_update_expression] = STATE(2130),
    [sym_sequence_expression] = STATE(5427),
    [sym_string] = STATE(2117),
    [sym_template_string] = STATE(2117),
    [sym_regex] = STATE(2117),
    [sym_meta_property] = STATE(2117),
    [sym_decorator] = STATE(1297),
    [sym_formal_parameters] = STATE(3895),
    [sym_non_null_expression] = STATE(1353),
    [sym_function_signature] = STATE(836),
    [sym_type_assertion] = STATE(2130),
    [sym_as_expression] = STATE(2130),
    [sym_satisfies_expression] = STATE(2130),
    [sym_instantiation_expression] = STATE(2130),
    [sym_ambient_declaration] = STATE(836),
    [sym_abstract_class_declaration] = STATE(836),
    [sym_module] = STATE(836),
    [sym_internal_module] = STATE(239),
    [sym_import_alias] = STATE(836),
    [sym_interface_declaration] = STATE(836),
    [sym_enum_declaration] = STATE(836),
    [sym_type_alias_declaration] = STATE(836),
    [sym_type_arguments] = STATE(427),
    [sym_type_parameters] = STATE(5348),
    [aux_sym_export_statement_repeat1] = STATE(3871),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(