/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.unicodeconvert;

import com.jacob.com.ComFailException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import net.sourceforge.unicodeconvert.ExtensionFileFilter;
import net.sourceforge.unicodeconvert.FileDropTargetListener;
import net.sourceforge.unicodeconvert.FormLocalizer;
import net.sourceforge.unicodeconvert.HtmlPane;
import net.sourceforge.unicodeconvert.OSXAdapter;
import net.sourceforge.unicodeconvert.StatusFrame;
import net.sourceforge.unicodeconvert.converter.LegacyDoc;
import net.sourceforge.unicodeconvert.converter.LegacyXLS;
import net.sourceforge.unicodeconvert.converter.UnicodeConversion;
import net.sourceforge.unicodeconvert.converter.VietEncodings;

public class Gui
extends JFrame
implements ActionListener {
    static final String APP_NAME = "UnicodeConverter";
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private final JFileChooser fc;
    private StatusFrame statusFrame;
    private JFrame overviewFrame;
    private final JButton selectButton;
    private final JButton quitButton;
    private final JCheckBox fileDirCheckBox;
    private final JMenu helpMenu;
    private final JMenu interfaceMenu;
    private final JMenu languageMenu;
    private final JMenu lafMenu;
    private final JRadioButtonMenuItem enItem;
    private final JRadioButtonMenuItem viItem;
    private final JComboBox encodingComboBox;
    private javax.swing.filechooser.FileFilter[] fileFilters;
    static final Preferences preferences = Preferences.userRoot().node("/net/sourceforge/unicodeconvert");
    private String sourceEncoding = preferences.get("sourceEncoding", "");
    private String currentDirectory = preferences.get("currentDirectory", "");
    private int filterIndex = preferences.getInt("filterIndex", 0);
    private ResourceBundle myResources;
    static final Locale VIETNAM = new Locale("vi", "VN");
    private static boolean localeVN;
    private JMenuItem overviewItem;
    private JMenuItem aboutItem;
    private FileFilter ioFilter;
    private File baseDir;
    private LegacyDoc legacyDoc;
    private LegacyXLS legacyXLS;
    private UnicodeConversion legacyText;

    public Gui() {
        super(APP_NAME);
        JComponent jComponent;
        this.setDefaultCloseOperation(3);
        this.myResources = ResourceBundle.getBundle("net.sourceforge.unicodeconvert.Resources");
        OptionListener optionListener = new OptionListener();
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        this.interfaceMenu = new JMenu(this.myResources.getString("interfaceMenu.Text"));
        jMenuBar.add(this.interfaceMenu);
        this.languageMenu = new JMenu(this.myResources.getString("languageMenu.Text"));
        this.enItem = new JRadioButtonMenuItem(this.myResources.getString("enItem.Text"), !localeVN);
        this.enItem.addActionListener(optionListener);
        this.viItem = new JRadioButtonMenuItem(this.myResources.getString("viItem.Text"), localeVN);
        this.viItem.addActionListener(optionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.enItem);
        buttonGroup.add(this.viItem);
        this.languageMenu.add(this.enItem);
        this.languageMenu.add(this.viItem);
        this.interfaceMenu.add(this.languageMenu);
        this.interfaceMenu.addSeparator();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.updateLaF(actionEvent.getActionCommand());
            }
        };
        ButtonGroup buttonGroup2 = new ButtonGroup();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        this.lafMenu = new JMenu(this.myResources.getString("lafMenu.Text"));
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            jComponent = new JRadioButtonMenuItem(lookAndFeelInfoArray[i].getName());
            ((AbstractButton)jComponent).setActionCommand(lookAndFeelInfoArray[i].getClassName());
            if (UIManager.getLookAndFeel().getClass().getName().equals(((AbstractButton)jComponent).getActionCommand())) {
                ((AbstractButton)jComponent).setSelected(true);
            }
            ((AbstractButton)jComponent).addActionListener(actionListener);
            buttonGroup2.add((AbstractButton)jComponent);
            this.lafMenu.add((JMenuItem)jComponent);
        }
        this.interfaceMenu.add(this.lafMenu);
        this.helpMenu = new JMenu(this.myResources.getString("helpMenu.Text"));
        jMenuBar.add(this.helpMenu);
        this.overviewItem = this.helpMenu.add(APP_NAME + this.myResources.getString("overviewItem.Text"));
        this.overviewItem.addActionListener(optionListener);
        if (!MAC_OS_X) {
            this.helpMenu.addSeparator();
            this.aboutItem = this.helpMenu.add(this.myResources.getString("aboutItem.Text") + APP_NAME);
            this.aboutItem.addActionListener(optionListener);
        }
        JPanel jPanel = new JPanel();
        this.encodingComboBox = new JComboBox<String>(VietEncodings.getNames());
        this.encodingComboBox.setSelectedItem(this.sourceEncoding);
        this.sourceEncoding = (String)this.encodingComboBox.getSelectedItem();
        this.encodingComboBox.setToolTipText(this.myResources.getString("encodingComboBox.Text"));
        this.encodingComboBox.setName(this.myResources.getString("encodingComboBox.Text"));
        this.encodingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.sourceEncoding = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
            }
        });
        jPanel.add(this.encodingComboBox);
        this.selectButton = new JButton(this.myResources.getString("selectButton.Text"));
        this.selectButton.addActionListener(this);
        this.rootPane.setDefaultButton(this.selectButton);
        this.quitButton = new JButton(this.myResources.getString("quitButton.Text"));
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.handleQuit();
            }
        });
        jComponent = new Box(2);
        jComponent.add(Box.createGlue());
        jComponent.add(Box.createHorizontalStrut(22));
        jComponent.add(this.selectButton);
        jComponent.add(Box.createHorizontalStrut(6));
        jComponent.add(this.quitButton);
        jComponent.add(Box.createHorizontalStrut(22));
        jComponent.add(Box.createGlue());
        JPanel jPanel2 = new JPanel();
        this.fileDirCheckBox = new JCheckBox(this.myResources.getString("fileDirCheckBox.Text"), preferences.getBoolean("fileDirCheckBox", false));
        this.fileDirCheckBox.setFont(this.fileDirCheckBox.getFont().deriveFont(0, 11.0f));
        this.fileDirCheckBox.addActionListener(optionListener);
        jPanel2.add(this.fileDirCheckBox);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(Box.createVerticalStrut(13));
        this.getContentPane().add(jPanel);
        this.getContentPane().add(Box.createVerticalStrut(5));
        this.getContentPane().add(jComponent);
        this.getContentPane().add(Box.createVerticalStrut(6));
        this.getContentPane().add(jPanel2);
        this.getContentPane().add(Box.createVerticalStrut(12));
        this.setResizable(false);
        this.pack();
        this.fc = new JFileChooser(this.currentDirectory);
        if (this.fileDirCheckBox.isSelected()) {
            this.fc.setMultiSelectionEnabled(false);
            this.fc.setFileSelectionMode(1);
            this.fc.setApproveButtonToolTipText(this.myResources.getString("Convert_selected_directory"));
            this.selectButton.setText(this.myResources.getString("Select_Directory"));
        } else {
            this.fc.setMultiSelectionEnabled(true);
            this.fc.setFileSelectionMode(0);
            this.fc.setApproveButtonToolTipText(this.myResources.getString("Convert_selected_files"));
            this.selectButton.setText(this.myResources.getString("selectButton.Text"));
        }
        this.setLocation(preferences.getInt("frameX", GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint().x), preferences.getInt("frameY", GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint().y));
        this.fc.setApproveButtonText(this.myResources.getString("Convert"));
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(new String[]{"html", "htm"}, "Web Pages");
        ExtensionFileFilter extensionFileFilter2 = new ExtensionFileFilter("txt", "Text Files");
        ExtensionFileFilter extensionFileFilter3 = new ExtensionFileFilter("doc", "Word Documents");
        ExtensionFileFilter extensionFileFilter4 = new ExtensionFileFilter("xls", "Excel Workbooks");
        ExtensionFileFilter extensionFileFilter5 = new ExtensionFileFilter("rtf", "Rich Text Format");
        extensionFileFilter.setExtensionListInDescription(true);
        extensionFileFilter2.setExtensionListInDescription(true);
        extensionFileFilter3.setExtensionListInDescription(true);
        extensionFileFilter4.setExtensionListInDescription(true);
        extensionFileFilter5.setExtensionListInDescription(true);
        this.fc.setAcceptAllFileFilterUsed(true);
        this.fc.addChoosableFileFilter(extensionFileFilter);
        this.fc.addChoosableFileFilter(extensionFileFilter2);
        if (System.getProperty("os.name").startsWith("Windows")) {
            this.fc.addChoosableFileFilter(extensionFileFilter3);
            this.fc.addChoosableFileFilter(extensionFileFilter4);
        }
        this.fc.addChoosableFileFilter(extensionFileFilter5);
        this.fileFilters = this.fc.getChoosableFileFilters();
        this.fc.setFileFilter(this.fileFilters[this.filterIndex]);
        if (MAC_OS_X) {
            new OSXAdapter(this);
        }
        this.statusFrame = new StatusFrame();
        this.statusFrame.setTitle(this.myResources.getString("statusFrame.Title"));
        this.statusFrame.setLocation(preferences.getInt("statusX", 33), preferences.getInt("statusY", 14));
        this.statusFrame.setSize(preferences.getInt("statusWidth", 400), preferences.getInt("statusHeight", 200));
        new DropTarget(this, new FileDropTargetListener(this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Gui.this.handleQuit();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                Gui.this.statusFrame.setExtendedState(1);
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                Gui.this.statusFrame.setExtendedState(0);
            }
        });
    }

    protected void updateLaF(String string) {
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SwingUtilities.updateComponentTreeUI(this);
        SwingUtilities.updateComponentTreeUI(this.fc);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectButton) {
            if (this.sourceEncoding.equals("")) {
                JOptionPane.showMessageDialog(this.fc, this.myResources.getString("Select_a_Source_Encoding_option."), this.myResources.getString("Message"), 2);
                return;
            }
            this.fc.setDialogTitle(this.myResources.getString("Convert_from_") + this.sourceEncoding);
            int n = this.fc.showDialog(this, null);
            if (n == 0) {
                this.currentDirectory = this.fc.getCurrentDirectory().getPath();
                File file = this.fc.getSelectedFile();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, file.isDirectory() ? this.myResources.getString("Directory_does_not_exist.") : this.myResources.getString("File_does_not_exist."), this.myResources.getString("Error"), 0);
                    return;
                }
                if (file.isDirectory()) {
                    this.runTask(file);
                } else {
                    this.runTask(this.fc.getSelectedFiles());
                }
                for (int i = 0; i < this.fileFilters.length; ++i) {
                    if (this.fileFilters[i] != this.fc.getFileFilter()) continue;
                    this.filterIndex = i;
                    break;
                }
            }
        }
    }

    public void runTask(File file) {
        this.ioFilter = new FileFilter(){
            javax.swing.filechooser.FileFilter swingFilter;
            {
                this.swingFilter = Gui.this.fc.getFileFilter();
            }

            @Override
            public boolean accept(File file) {
                return this.swingFilter.accept(file);
            }
        };
        this.runTask(file.listFiles(this.ioFilter));
    }

    public void runTask(final File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        this.ioFilter = new FileFilter(){
            javax.swing.filechooser.FileFilter swingFilter;
            {
                this.swingFilter = Gui.this.fc.getFileFilter();
            }

            @Override
            public boolean accept(File file) {
                return this.swingFilter.accept(file);
            }
        };
        this.baseDir = fileArray[0].getParentFile();
        this.statusFrame.setVisible(true);
        this.statusFrame.getTextArea().append("\t-- " + this.myResources.getString("Beginning_of_task") + " --\n");
        this.statusFrame.setExtendedState(0);
        this.setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Gui.this.convert(fileArray);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    String string = null;
                    Throwable throwable = executionException.getCause();
                    string = throwable != null ? (throwable instanceof IOException ? Gui.this.myResources.getString("Can't_write_to_file.") : (throwable instanceof UnsatisfiedLinkError ? Gui.this.myResources.getString("Could_not_find_jacob.dll_in_PATH.\nConversion_of_Word/Excel_documents_not_possible.") : (throwable instanceof OutOfMemoryError ? Gui.this.myResources.getString("OutOfMemoryError") : (throwable instanceof ComFailException ? Gui.this.myResources.getString("Microsoft_Word/Excel_not_installed_or_JNI_problem.") : (throwable instanceof RuntimeException ? executionException.getCause().getMessage() : throwable.getMessage()))))) : executionException.getMessage();
                    executionException.printStackTrace();
                    System.err.println(string);
                    JOptionPane.showMessageDialog(null, string, Gui.APP_NAME, 0);
                }
                finally {
                    Gui.this.setCursor(Cursor.getPredefinedCursor(0));
                    Gui.this.statusFrame.getTextArea().append("\t-- " + Gui.this.myResources.getString("End_of_task") + " --\n");
                    Gui.this.statusFrame.getTextArea().setCaretPosition(Gui.this.statusFrame.getTextArea().getDocument().getLength());
                    if (Gui.this.legacyDoc != null) {
                        Gui.this.legacyDoc.quitWord();
                        Gui.this.legacyDoc = null;
                    }
                    if (Gui.this.legacyXLS != null) {
                        Gui.this.legacyXLS.quitExcel();
                        Gui.this.legacyXLS = null;
                    }
                    if (Gui.this.legacyText != null) {
                        Gui.this.legacyText = null;
                    }
                    JOptionPane.showMessageDialog(Gui.this, Gui.this.myResources.getString("Check_output_in_directory") + Gui.this.baseDir + "_Unicode", Gui.this.myResources.getString("Message"), 1);
                }
            }
        };
        swingWorker.execute();
    }

    void convert(File[] fileArray) throws Exception {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file = new File(this.baseDir.getPath() + "_Unicode", fileArray[0].getParent().substring(this.baseDir.getPath().length()));
        file.mkdir();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                String string = fileArray[i].getName().toLowerCase();
                if (System.getProperty("os.name").startsWith("Windows") && string.endsWith(".doc")) {
                    if (this.legacyDoc == null) {
                        this.legacyDoc = new LegacyDoc(this.sourceEncoding);
                    }
                    this.legacyDoc.convert(file, fileArray[i]);
                } else if (System.getProperty("os.name").startsWith("Windows") && string.endsWith(".xls")) {
                    if (this.legacyXLS == null) {
                        this.legacyXLS = new LegacyXLS(this.sourceEncoding);
                    }
                    this.legacyXLS.convert(file, fileArray[i]);
                } else {
                    if (string.matches(".*\\.(dll|exe|jpg|jpeg|gif|tif|tiff|bmp|png|pdf)$")) continue;
                    if (this.legacyText == null) {
                        this.legacyText = new UnicodeConversion(this.sourceEncoding);
                    }
                    this.legacyText.convert(file, fileArray[i]);
                }
                final String string2 = fileArray[i].getPath();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Gui.this.statusFrame.getTextArea().append(string2 + "\n");
                        Gui.this.statusFrame.getTextArea().setCaretPosition(Gui.this.statusFrame.getTextArea().getDocument().getLength());
                    }
                });
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            this.convert(fileArray[i].listFiles(this.ioFilter));
        }
    }

    private void changeUILanguage(Locale locale) {
        if (locale.equals(Locale.getDefault())) {
            return;
        }
        Locale.setDefault(locale);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.swing.internal.plaf.basic.resources.basic");
        UIManager.put("FileChooser.cancelButtonText", resourceBundle.getString("FileChooser.cancelButtonText"));
        UIManager.put("OptionPane.okButtonText", resourceBundle.getString("OptionPane.okButtonText"));
        SwingUtilities.updateComponentTreeUI(this.fc);
        this.myResources = ResourceBundle.getBundle("net.sourceforge.unicodeconvert.Resources");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FormLocalizer formLocalizer = new FormLocalizer(Gui.this, Gui.class);
                formLocalizer.ApplyCulture(Gui.this.myResources);
                if (Gui.this.fileDirCheckBox.isSelected()) {
                    Gui.this.selectButton.setText(Gui.this.myResources.getString("Select_Directory"));
                }
                Gui.this.overviewItem.setText(Gui.APP_NAME + Gui.this.overviewItem.getText());
                Gui.this.aboutItem.setText(Gui.this.aboutItem.getText() + Gui.APP_NAME);
                Gui.this.fc.setDialogTitle(Gui.this.myResources.getString("Convert_from_") + Gui.this.sourceEncoding);
                Gui.this.fc.setApproveButtonText(Gui.this.myResources.getString("Convert"));
                Gui.this.statusFrame.setTitle(Gui.this.myResources.getString("statusFrame.Title"));
                if (Gui.this.overviewFrame != null) {
                    Gui.this.overviewFrame.setTitle(Gui.this.overviewItem.getText());
                }
            }
        });
    }

    public void handleAbout() {
        try {
            Properties properties = new Properties();
            properties.loadFromXML(this.getClass().getResourceAsStream("config.xml"));
            String string = properties.getProperty("Version");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            Date date = simpleDateFormat.parse(properties.getProperty("ReleaseDate"));
            JOptionPane.showMessageDialog(this, "UnicodeConverter, " + string + " \u00a9 2002\n" + DateFormat.getDateInstance(1).format(date) + "\nhttp://unicodeconvert.sourceforge.net", this.myResources.getString("aboutItem.Text") + APP_NAME, 1);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public void handleOpenFile(File file) {
        this.ioFilter = new ExtensionFileFilter(new String[]{"html", "htm", "txt", "doc", "xls", "rtf", "xml"});
        if (!this.ioFilter.accept(file)) {
            return;
        }
        if (file.isDirectory()) {
            this.runTask(file);
        } else {
            this.runTask(new File[]{file});
        }
    }

    public void handleQuit() {
        preferences.put("sourceEncoding", this.sourceEncoding);
        preferences.put("currentDirectory", this.currentDirectory);
        preferences.putInt("filterIndex", this.filterIndex);
        preferences.putInt("frameX", this.getX());
        preferences.putInt("frameY", this.getY());
        preferences.putInt("statusX", this.statusFrame.getX());
        preferences.putInt("statusY", this.statusFrame.getY());
        preferences.putInt("statusWidth", this.statusFrame.getWidth());
        preferences.putInt("statusHeight", this.statusFrame.getHeight());
        preferences.putBoolean("fileDirCheckBox", this.fileDirCheckBox.isSelected());
        preferences.putBoolean("localeVN", localeVN);
        preferences.put("lookAndFeel", UIManager.getLookAndFeel().getClass().getName());
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        localeVN = Locale.getDefault().getLanguage().equals("vi") || Locale.getDefault().getCountry().equals("VN");
        if (localeVN == preferences.getBoolean("systemLocaleVN", !localeVN)) {
            localeVN = preferences.getBoolean("localeVN", localeVN);
        } else {
            preferences.putBoolean("systemLocaleVN", localeVN);
        }
        Locale.setDefault(localeVN ? VIETNAM : Locale.US);
        try {
            UIManager.setLookAndFeel(preferences.get("lookAndFeel", UIManager.getLookAndFeel().getClass().getName()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Gui().setVisible(true);
            }
        });
    }

    class OptionListener
    implements ActionListener {
        OptionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            if (jComponent == Gui.this.enItem) {
                localeVN = false;
                Gui.this.changeUILanguage(Locale.US);
            } else if (jComponent == Gui.this.viItem) {
                localeVN = true;
                Gui.this.changeUILanguage(VIETNAM);
            } else if (jComponent == Gui.this.fileDirCheckBox) {
                if (Gui.this.fileDirCheckBox.isSelected()) {
                    Gui.this.selectButton.setText(Gui.this.myResources.getString("Select_Directory"));
                    Gui.this.fc.setMultiSelectionEnabled(false);
                    Gui.this.fc.setFileSelectionMode(1);
                    Gui.this.fc.setApproveButtonToolTipText(Gui.this.myResources.getString("Convert_selected_directory"));
                } else {
                    Gui.this.selectButton.setText(Gui.this.myResources.getString("selectButton.Text"));
                    Gui.this.fc.setMultiSelectionEnabled(true);
                    Gui.this.fc.setFileSelectionMode(0);
                    Gui.this.fc.setApproveButtonToolTipText(Gui.this.myResources.getString("Convert_selected_files"));
                }
            } else if (jComponent == Gui.this.overviewItem) {
                if (MAC_OS_X && new File("readme.html").exists()) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"open", "-a", "Help Viewer", "readme.html"});
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    if (Gui.this.overviewFrame == null) {
                        Gui.this.overviewFrame = new JFrame(Gui.this.overviewItem.getText());
                        HtmlPane htmlPane = new HtmlPane("net/sourceforge/unicodeconvert/resources/readme.html");
                        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                        Gui.this.overviewFrame.getContentPane().add((Component)htmlPane, "Center");
                        Gui.this.overviewFrame.getContentPane().add((Component)htmlPane.getStatusBar(), "South");
                        Gui.this.overviewFrame.pack();
                        Gui.this.overviewFrame.setLocation((rectangle.width - Gui.this.overviewFrame.getWidth()) / 2, 40);
                    }
                    Gui.this.overviewFrame.setVisible(true);
                }
            } else if (jComponent == Gui.this.aboutItem) {
                Gui.this.handleAbout();
            }
        }
    }
}

