if(ANDROID)
    set(OUTPUT_DIRECTORY ${CMAKE_SOURCE_DIR}/bin/android/${ANDROID_ABI})
elseif(IOS)
    set(OUTPUT_DIRECTORY ${CMAKE_SOURCE_DIR}/bin/iOS/${IOS_PLATFORM})
else()
    if(WIN32)
        set(USE_GUI ON)
    endif()
    set(OUTPUT_DIRECTORY ${CMAKE_SOURCE_DIR}/bin/${CMAKE_SYSTEM_NAME}_${ARCH_BITS})
endif()

message("SYSTEM NAME: ${CMAKE_SYSTEM_NAME}")
message("OUTPUT DIRECTORY: ${OUTPUT_DIRECTORY}")

set(OUTPUT_DIRECTORY_DEBUG ${OUTPUT_DIRECTORY}_Debug)
set(OUTPUT_DIRECTORY_RELEASE ${OUTPUT_DIRECTORY}_Release)

set(CMAKE_RUNTIME_OUTPUT_DIRECTORY ${OUTPUT_DIRECTORY})
set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY ${OUTPUT_DIRECTORY})
set(CMAKE_LIBRARY_OUTPUT_DIRECTORY ${OUTPUT_DIRECTORY})

set(CMAKE_RUNTIME_OUTPUT_DIRECTORY_DEBUG ${OUTPUT_DIRECTORY_DEBUG})
set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY_DEBUG ${OUTPUT_DIRECTORY_DEBUG})
set(CMAKE_LIBRARY_OUTPUT_DIRECTORY_DEBUG ${OUTPUT_DIRECTORY_DEBUG})

set(CMAKE_RUNTIME_OUTPUT_DIRECTORY_RELEASE ${OUTPUT_DIRECTORY_RELEASE})
set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY_RELEASE ${OUTPUT_DIRECTORY_RELEASE})
set(CMAKE_LIBRARY_OUTPUT_DIRECTORY_RELEASE ${OUTPUT_DIRECTORY_RELEASE})