# Contains the source file definitions in src/libGLESv2.gn
#
# This is a direct mapping of ALL values unless otherwise specified. All
# declarations are in the same ordering as the original .gn file

set(libangle_common_sources
    src/common/Color.h
    src/common/Color.inc
    src/common/FastVector.h
    src/common/FixedVector.h
    src/common/Float16ToFloat32.cpp
    src/common/MemoryBuffer.cpp
    src/common/MemoryBuffer.h
    src/common/Optional.h
    src/common/PackedEGLEnums_autogen.cpp
    src/common/PackedEGLEnums_autogen.h
    src/common/PackedEnums.cpp
    src/common/PackedEnums.h
    src/common/PackedGLEnums_autogen.cpp
    src/common/PackedGLEnums_autogen.h
    src/common/PoolAlloc.cpp
    src/common/PoolAlloc.h
    src/common/aligned_memory.cpp
    src/common/aligned_memory.h
    src/common/android_util.cpp
    src/common/android_util.h
    src/common/angleutils.cpp
    src/common/angleutils.h
    src/common/bitset_utils.h
    src/common/debug.cpp
    src/common/debug.h
    src/common/event_tracer.cpp
    src/common/event_tracer.h
    src/common/hash_utils.h
    src/common/mathutil.cpp
    src/common/mathutil.h
    src/common/matrix_utils.cpp
    src/common/matrix_utils.h
    src/common/platform.h
    src/common/string_utils.cpp
    src/common/string_utils.h
    src/common/third_party/base/anglebase/base_export.h
    src/common/third_party/base/anglebase/containers/mru_cache.h
    src/common/third_party/base/anglebase/logging.h
    src/common/third_party/base/anglebase/macros.h
    src/common/third_party/base/anglebase/no_destructor.h
    src/common/third_party/base/anglebase/numerics/safe_conversions.h
    src/common/third_party/base/anglebase/numerics/safe_conversions_impl.h
    src/common/third_party/base/anglebase/numerics/safe_math.h
    src/common/third_party/base/anglebase/numerics/safe_math_impl.h
    src/common/third_party/base/anglebase/sha1.cc
    src/common/third_party/base/anglebase/sha1.h
    src/common/third_party/base/anglebase/sys_byteorder.h
    src/common/third_party/smhasher/src/PMurHash.cpp
    src/common/third_party/smhasher/src/PMurHash.h
    src/common/tls.cpp
    src/common/tls.h
    src/common/uniform_type_info_autogen.cpp
    src/common/utilities.cpp
    src/common/utilities.h
    src/common/vector_utils.h
)

set(xxhash_sources
    src/common/third_party/xxhash/xxhash.c
    src/common/third_party/xxhash/xxhash.h
)

set(angle_system_utils_sources
    src/common/Optional.h
    src/common/angleutils.h
    src/common/platform.h
    src/common/system_utils.cpp
    src/common/system_utils.h
)

# Rather than appending to the angle_system_utils_sources we instead make variables that can be used

set(angle_system_utils_sources_linux src/common/system_utils_linux.cpp)
set(angle_system_utils_sources_posix src/common/system_utils_posix.cpp)
set(angle_system_utils_sources_mac src/common/system_utils_mac.cpp)
set(angle_system_utils_sources_win src/common/system_utils_win.cpp)
set(angle_system_utils_sources_android
    src/common/android_util.cpp
    src/common/android_util.h
)

# end modification

set(libangle_image_util_sources
    src/image_util/copyimage.cpp
    src/image_util/copyimage.h
    src/image_util/copyimage.inc
    src/image_util/generatemip.h
    src/image_util/generatemip.inc
    src/image_util/imageformats.cpp
    src/image_util/imageformats.h
    src/image_util/loadimage.cpp
    src/image_util/loadimage.h
    src/image_util/loadimage.inc
    src/image_util/loadimage_etc.cpp
)

set(libangle_gpu_info_util_sources
    src/gpu_info_util/SystemInfo.cpp
    src/gpu_info_util/SystemInfo.h
    src/gpu_info_util/SystemInfo_internal.h
)

set(libangle_gpu_info_util_win_sources src/gpu_info_util/SystemInfo_win.cpp)

set(libangle_gpu_info_util_linux_sources src/gpu_info_util/SystemInfo_linux.cpp)

set(libangle_gpu_info_util_libpci_sources src/gpu_info_util/SystemInfo_libpci.cpp)

set(libangle_gpu_info_util_x11_sources src/gpu_info_util/SystemInfo_x11.cpp)

set(libangle_gpu_info_util_mac_sources src/gpu_info_util/SystemInfo_mac.mm)

set(libangle_includes
    include/angle_gl.h
    include/export.h
    include/EGL/egl.h
    include/EGL/eglext.h
    include/EGL/eglext_angle.h
    include/EGL/eglplatform.h
    include/GLES/gl.h
    include/GLES/glplatform.h
    include/GLES/glext.h
    include/GLES/glext_angle.h
    include/GLES/glext_explicit_context_autogen.inc
    include/GLES2/gl2.h
    include/GLES2/gl2ext.h
    include/GLES2/gl2ext_angle.h
    include/GLES2/gl2ext_explicit_context_autogen.inc
    include/GLES2/gl2platform.h
    include/GLES3/gl3.h
    include/GLES3/gl3ext_explicit_context_autogen.inc
    include/GLES3/gl3platform.h
    include/GLES3/gl31.h
    include/GLES3/gl31ext_explicit_context_autogen.inc
    include/GLES3/gl32.h
    include/GLSLANG/ShaderLang.h
    include/GLSLANG/ShaderVars.h
    include/KHR/khrplatform.h
    include/WGL/wgl.h
    include/platform/Feature.h
    include/platform/FeaturesD3D.h
    include/platform/FeaturesGL.h
    include/platform/FeaturesVk.h
    include/platform/FrontendFeatures.h
    include/platform/Platform.h
)

set(libangle_sources
    src/libANGLE/AttributeMap.cpp
    src/libANGLE/AttributeMap.h
    src/libANGLE/BinaryStream.h
    src/libANGLE/BlobCache.cpp
    src/libANGLE/BlobCache.h
    src/libANGLE/Buffer.cpp
    src/libANGLE/Buffer.h
    src/libANGLE/Caps.cpp
    src/libANGLE/Caps.h
    src/libANGLE/Compiler.cpp
    src/libANGLE/Compiler.h
    src/libANGLE/Config.cpp
    src/libANGLE/Config.h
    src/libANGLE/Constants.h
    src/libANGLE/Context.cpp
    src/libANGLE/Context_gl.cpp
    src/libANGLE/Context_gles_1_0.cpp
    src/libANGLE/Context_gl_1_0_autogen.h
    src/libANGLE/Context_gl_1_1_autogen.h
    src/libANGLE/Context_gl_1_2_autogen.h
    src/libANGLE/Context_gl_1_3_autogen.h
    src/libANGLE/Context_gl_1_4_autogen.h
    src/libANGLE/Context_gl_1_5_autogen.h
    src/libANGLE/Context_gl_2_0_autogen.h
    src/libANGLE/Context_gl_2_1_autogen.h
    src/libANGLE/Context_gl_3_0_autogen.h
    src/libANGLE/Context_gl_3_1_autogen.h
    src/libANGLE/Context_gl_3_2_autogen.h
    src/libANGLE/Context_gl_3_3_autogen.h
    src/libANGLE/Context_gl_4_0_autogen.h
    src/libANGLE/Context_gl_4_1_autogen.h
    src/libANGLE/Context_gl_4_2_autogen.h
    src/libANGLE/Context_gl_4_3_autogen.h
    src/libANGLE/Context_gl_4_4_autogen.h
    src/libANGLE/Context_gl_4_5_autogen.h
    src/libANGLE/Context_gl_4_6_autogen.h
    src/libANGLE/Context_gles_1_0_autogen.h
    src/libANGLE/Context_gles_2_0_autogen.h
    src/libANGLE/Context_gles_3_0_autogen.h
    src/libANGLE/Context_gles_3_1_autogen.h
    src/libANGLE/Context_gles_ext_autogen.h
    src/libANGLE/Context.h
    src/libANGLE/Context.inl.h
    src/libANGLE/Debug.cpp
    src/libANGLE/Debug.h
    src/libANGLE/Device.cpp
    src/libANGLE/Device.h
    src/libANGLE/Display.cpp
    src/libANGLE/Display.h
    src/libANGLE/EGLSync.cpp
    src/libANGLE/EGLSync.h
    src/libANGLE/Error.cpp
    src/libANGLE/Error.h
    src/libANGLE/Error.inc
    src/libANGLE/ErrorStrings.h
    src/libANGLE/Fence.cpp
    src/libANGLE/Fence.h
    src/libANGLE/Framebuffer.cpp
    src/libANGLE/Framebuffer.h
    src/libANGLE/FramebufferAttachment.cpp
    src/libANGLE/FramebufferAttachment.h
    src/libANGLE/GLES1Renderer.cpp
    src/libANGLE/GLES1Renderer.h
    src/libANGLE/GLES1Shaders.inc
    src/libANGLE/GLES1State.cpp
    src/libANGLE/GLES1State.h
    src/libANGLE/HandleAllocator.cpp
    src/libANGLE/HandleAllocator.h
    src/libANGLE/HandleRangeAllocator.h
    src/libANGLE/HandleRangeAllocator.cpp
    src/libANGLE/Image.h
    src/libANGLE/Image.cpp
    src/libANGLE/ImageIndex.h
    src/libANGLE/ImageIndex.cpp
    src/libANGLE/IndexRangeCache.cpp
    src/libANGLE/IndexRangeCache.h
    src/libANGLE/LoggingAnnotator.cpp
    src/libANGLE/LoggingAnnotator.h
    src/libANGLE/MemoryObject.cpp
    src/libANGLE/MemoryObject.h
    src/libANGLE/MemoryProgramCache.cpp
    src/libANGLE/MemoryProgramCache.h
    src/libANGLE/Observer.cpp
    src/libANGLE/Observer.h
    src/libANGLE/Overlay.cpp
    src/libANGLE/Overlay.h
    src/libANGLE/OverlayWidgets.cpp
    src/libANGLE/OverlayWidgets.h
    src/libANGLE/Overlay_autogen.cpp
    src/libANGLE/Overlay_font_autogen.cpp
    src/libANGLE/Overlay_font_autogen.h
    src/libANGLE/Path.h
    src/libANGLE/Path.cpp
    src/libANGLE/Platform.cpp
    src/libANGLE/Program.cpp
    src/libANGLE/Program.h
    src/libANGLE/ProgramLinkedResources.cpp
    src/libANGLE/ProgramLinkedResources.h
    src/libANGLE/ProgramPipeline.cpp
    src/libANGLE/ProgramPipeline.h
    src/libANGLE/Query.cpp
    src/libANGLE/Query.h
    src/libANGLE/RefCountObject.h
    src/libANGLE/Renderbuffer.cpp
    src/libANGLE/Renderbuffer.h
    src/libANGLE/ResourceManager.cpp
    src/libANGLE/ResourceManager.h
    src/libANGLE/ResourceMap.h
    src/libANGLE/Sampler.cpp
    src/libANGLE/Sampler.h
    src/libANGLE/Semaphore.cpp
    src/libANGLE/Semaphore.h
    src/libANGLE/Shader.cpp
    src/libANGLE/Shader.h
    src/libANGLE/SizedMRUCache.h
    src/libANGLE/State.cpp
    src/libANGLE/State.h
    src/libANGLE/Stream.cpp
    src/libANGLE/Stream.h
    src/libANGLE/Surface.cpp
    src/libANGLE/Surface.h
    src/libANGLE/Texture.cpp
    src/libANGLE/Texture.h
    src/libANGLE/Thread.cpp
    src/libANGLE/Thread.h
    src/libANGLE/TransformFeedback.cpp
    src/libANGLE/TransformFeedback.h
    src/libANGLE/Uniform.cpp
    src/libANGLE/Uniform.h
    src/libANGLE/VaryingPacking.cpp
    src/libANGLE/VaryingPacking.h
    src/libANGLE/Version.h
    src/libANGLE/Version.inc
    src/libANGLE/VertexArray.cpp
    src/libANGLE/VertexArray.h
    src/libANGLE/VertexAttribute.cpp
    src/libANGLE/VertexAttribute.h
    src/libANGLE/VertexAttribute.inc
    src/libANGLE/WorkerThread.cpp
    src/libANGLE/WorkerThread.h
    src/libANGLE/angletypes.cpp
    src/libANGLE/angletypes.h
    src/libANGLE/angletypes.inc
    src/libANGLE/entry_points_enum_autogen.cpp
    src/libANGLE/entry_points_enum_autogen.h
    src/libANGLE/entry_points_utils.h
    src/libANGLE/es3_copy_conversion_table_autogen.cpp
    src/libANGLE/features.h
    src/libANGLE/format_map_autogen.cpp
    src/libANGLE/format_map_desktop.cpp
    src/libANGLE/formatutils.cpp
    src/libANGLE/formatutils.h
    src/libANGLE/histogram_macros.h
    src/libANGLE/queryconversions.cpp
    src/libANGLE/queryconversions.h
    src/libANGLE/queryutils.cpp
    src/libANGLE/queryutils.h
    src/libANGLE/trace.h
    src/libANGLE/renderer/BufferImpl.h
    src/libANGLE/renderer/CompilerImpl.h
    src/libANGLE/renderer/ContextImpl.cpp
    src/libANGLE/renderer/ContextImpl.h
    src/libANGLE/renderer/driver_utils.cpp
    src/libANGLE/renderer/driver_utils.h
    src/libANGLE/renderer/DeviceImpl.cpp
    src/libANGLE/renderer/DeviceImpl.h
    src/libANGLE/renderer/DisplayImpl.cpp
    src/libANGLE/renderer/DisplayImpl.h
    src/libANGLE/renderer/EGLImplFactory.h
    src/libANGLE/renderer/EGLSyncImpl.h
    src/libANGLE/renderer/FenceNVImpl.h
    src/libANGLE/renderer/FormatID_autogen.h
    src/libANGLE/renderer/Format_table_autogen.cpp
    src/libANGLE/renderer/Format.h
    src/libANGLE/renderer/FramebufferAttachmentObjectImpl.h
    src/libANGLE/renderer/FramebufferImpl.h
    src/libANGLE/renderer/GLImplFactory.h
    src/libANGLE/renderer/ImageImpl.h
    src/libANGLE/renderer/MemoryObjectImpl.h
    src/libANGLE/renderer/PathImpl.h
    src/libANGLE/renderer/ProgramImpl.h
    src/libANGLE/renderer/ProgramPipelineImpl.h
    src/libANGLE/renderer/QueryImpl.cpp
    src/libANGLE/renderer/QueryImpl.h
    src/libANGLE/renderer/RenderbufferImpl.h
    src/libANGLE/renderer/RenderTargetCache.h
    src/libANGLE/renderer/SamplerImpl.h
    src/libANGLE/renderer/SemaphoreImpl.h
    src/libANGLE/renderer/ShaderImpl.cpp
    src/libANGLE/renderer/ShaderImpl.h
    src/libANGLE/renderer/StreamProducerImpl.h
    src/libANGLE/renderer/SurfaceImpl.cpp
    src/libANGLE/renderer/SurfaceImpl.h
    src/libANGLE/renderer/SyncImpl.h
    src/libANGLE/renderer/TextureImpl.cpp
    src/libANGLE/renderer/TextureImpl.h
    src/libANGLE/renderer/TransformFeedbackImpl.h
    src/libANGLE/renderer/VertexArrayImpl.h
    src/libANGLE/renderer/copyvertex.h
    src/libANGLE/renderer/copyvertex.inc.h
    src/libANGLE/renderer/load_functions_table.h
    src/libANGLE/renderer/load_functions_table_autogen.cpp
    src/libANGLE/renderer/renderer_utils.cpp
    src/libANGLE/renderer/renderer_utils.h
    src/libANGLE/validationEGL.cpp
    src/libANGLE/validationEGL.h
    src/libANGLE/validationES.cpp
    src/libANGLE/validationES.h
    src/libANGLE/validationES1.cpp
    src/libANGLE/validationES1_autogen.h
    src/libANGLE/validationES1.h
    src/libANGLE/validationES2.cpp
    src/libANGLE/validationES2_autogen.h
    src/libANGLE/validationES2.h
    src/libANGLE/validationES3.cpp
    src/libANGLE/validationES31.cpp
    src/libANGLE/validationES31_autogen.h
    src/libANGLE/validationES31.h
    src/libANGLE/validationES3_autogen.h
    src/libANGLE/validationES3.h
    src/libANGLE/validationESEXT_autogen.h
    src/libANGLE/validationESEXT.h
    src/libANGLE/validationGL1.cpp
    src/libANGLE/validationGL1_autogen.h
    src/libANGLE/validationGL2.cpp
    src/libANGLE/validationGL2_autogen.h
    src/libANGLE/validationGL3.cpp
    src/libANGLE/validationGL3_autogen.h
    src/libANGLE/validationGL4.cpp
    src/libANGLE/validationGL4_autogen.h
    src/libANGLE/validationGL11.cpp
    src/libANGLE/validationGL11_autogen.h
    src/libANGLE/validationGL12.cpp
    src/libANGLE/validationGL12_autogen.h
    src/libANGLE/validationGL13.cpp
    src/libANGLE/validationGL13_autogen.h
    src/libANGLE/validationGL14.cpp
    src/libANGLE/validationGL14_autogen.h
    src/libANGLE/validationGL15.cpp
    src/libANGLE/validationGL15_autogen.h
    src/libANGLE/validationGL21.cpp
    src/libANGLE/validationGL21_autogen.h
    src/libANGLE/validationGL31.cpp
    src/libANGLE/validationGL31_autogen.h
    src/libANGLE/validationGL32.cpp
    src/libANGLE/validationGL32_autogen.h
    src/libANGLE/validationGL33.cpp
    src/libANGLE/validationGL33_autogen.h
    src/libANGLE/validationGL41.cpp
    src/libANGLE/validationGL41_autogen.h
    src/libANGLE/validationGL42.cpp
    src/libANGLE/validationGL42_autogen.h
    src/libANGLE/validationGL43.cpp
    src/libANGLE/validationGL43_autogen.h
    src/libANGLE/validationGL44.cpp
    src/libANGLE/validationGL44_autogen.h
    src/libANGLE/validationGL45.cpp
    src/libANGLE/validationGL45_autogen.h
    src/libANGLE/validationGL46.cpp
    src/libANGLE/validationGL46_autogen.h
    src/third_party/trace_event/trace_event.h
    # Added lower in libGLESv2.gni
    src/libANGLE/FrameCapture.h
    src/libANGLE/capture_gles_1_0_autogen.h
    src/libANGLE/capture_gles_2_0_autogen.h
    src/libANGLE/capture_gles_3_0_autogen.h
    src/libANGLE/capture_gles_3_1_autogen.h
    src/libANGLE/capture_gles_ext_autogen.h
    src/libANGLE/frame_capture_utils_autogen.h
    src/libANGLE/gl_enum_utils_autogen.h
)

set(libangle_d3d_shared_sources
    src/libANGLE/renderer/d3d/BufferD3D.cpp
    src/libANGLE/renderer/d3d/BufferD3D.h
    src/libANGLE/renderer/d3d/CompilerD3D.cpp
    src/libANGLE/renderer/d3d/CompilerD3D.h
    src/libANGLE/renderer/d3d/ContextD3D.h
    src/libANGLE/renderer/d3d/DeviceD3D.cpp
    src/libANGLE/renderer/d3d/DeviceD3D.h
    src/libANGLE/renderer/d3d/DisplayD3D.cpp
    src/libANGLE/renderer/d3d/DisplayD3D.h
    src/libANGLE/renderer/d3d/DynamicHLSL.cpp
    src/libANGLE/renderer/d3d/DynamicHLSL.h
    src/libANGLE/renderer/d3d/DynamicImage2DHLSL.cpp
    src/libANGLE/renderer/d3d/DynamicImage2DHLSL.h
    src/libANGLE/renderer/d3d/EGLImageD3D.cpp
    src/libANGLE/renderer/d3d/EGLImageD3D.h
    src/libANGLE/renderer/d3d/formatutilsD3D.h
    src/libANGLE/renderer/d3d/FramebufferD3D.cpp
    src/libANGLE/renderer/d3d/FramebufferD3D.h
    src/libANGLE/renderer/d3d/HLSLCompiler.cpp
    src/libANGLE/renderer/d3d/HLSLCompiler.h
    src/libANGLE/renderer/d3d/ImageD3D.cpp
    src/libANGLE/renderer/d3d/ImageD3D.h
    src/libANGLE/renderer/d3d/IndexBuffer.cpp
    src/libANGLE/renderer/d3d/IndexBuffer.h
    src/libANGLE/renderer/d3d/IndexDataManager.cpp
    src/libANGLE/renderer/d3d/IndexDataManager.h
    src/libANGLE/renderer/d3d/NativeWindowD3D.cpp
    src/libANGLE/renderer/d3d/NativeWindowD3D.h
    src/libANGLE/renderer/d3d/ProgramD3D.cpp
    src/libANGLE/renderer/d3d/ProgramD3D.h
    src/libANGLE/renderer/d3d/RenderbufferD3D.cpp
    src/libANGLE/renderer/d3d/RenderbufferD3D.h
    src/libANGLE/renderer/d3d/RendererD3D.cpp
    src/libANGLE/renderer/d3d/RendererD3D.h
    src/libANGLE/renderer/d3d/RenderTargetD3D.h
    src/libANGLE/renderer/d3d/RenderTargetD3D.cpp
    src/libANGLE/renderer/d3d/SamplerD3D.h
    src/libANGLE/renderer/d3d/ShaderD3D.cpp
    src/libANGLE/renderer/d3d/ShaderD3D.h
    src/libANGLE/renderer/d3d/ShaderExecutableD3D.cpp
    src/libANGLE/renderer/d3d/ShaderExecutableD3D.h
    src/libANGLE/renderer/d3d/SurfaceD3D.cpp
    src/libANGLE/renderer/d3d/SurfaceD3D.h
    src/libANGLE/renderer/d3d/SwapChainD3D.cpp
    src/libANGLE/renderer/d3d/SwapChainD3D.h
    src/libANGLE/renderer/d3d/TextureD3D.cpp
    src/libANGLE/renderer/d3d/TextureD3D.h
    src/libANGLE/renderer/d3d/TextureStorage.h
    src/libANGLE/renderer/d3d/VertexBuffer.cpp
    src/libANGLE/renderer/d3d/VertexBuffer.h
    src/libANGLE/renderer/d3d/VertexDataManager.cpp
    src/libANGLE/renderer/d3d/VertexDataManager.h
)

set(libangle_d3d9_sources
    src/libANGLE/renderer/d3d/d3d9/Blit9.cpp
    src/libANGLE/renderer/d3d/d3d9/Blit9.h
    src/libANGLE/renderer/d3d/d3d9/Buffer9.cpp
    src/libANGLE/renderer/d3d/d3d9/Buffer9.h
    src/libANGLE/renderer/d3d/d3d9/Context9.cpp
    src/libANGLE/renderer/d3d/d3d9/Context9.h
    src/libANGLE/renderer/d3d/d3d9/DebugAnnotator9.cpp
    src/libANGLE/renderer/d3d/d3d9/DebugAnnotator9.h
    src/libANGLE/renderer/d3d/d3d9/Fence9.cpp
    src/libANGLE/renderer/d3d/d3d9/Fence9.h
    src/libANGLE/renderer/d3d/d3d9/formatutils9.cpp
    src/libANGLE/renderer/d3d/d3d9/formatutils9.h
    src/libANGLE/renderer/d3d/d3d9/Framebuffer9.cpp
    src/libANGLE/renderer/d3d/d3d9/Framebuffer9.h
    src/libANGLE/renderer/d3d/d3d9/Image9.cpp
    src/libANGLE/renderer/d3d/d3d9/Image9.h
    src/libANGLE/renderer/d3d/d3d9/IndexBuffer9.cpp
    src/libANGLE/renderer/d3d/d3d9/IndexBuffer9.h
    src/libANGLE/renderer/d3d/d3d9/NativeWindow9.cpp
    src/libANGLE/renderer/d3d/d3d9/NativeWindow9.h
    src/libANGLE/renderer/d3d/d3d9/Query9.cpp
    src/libANGLE/renderer/d3d/d3d9/Query9.h
    src/libANGLE/renderer/d3d/d3d9/Renderer9.cpp
    src/libANGLE/renderer/d3d/d3d9/Renderer9.h
    src/libANGLE/renderer/d3d/d3d9/renderer9_utils.cpp
    src/libANGLE/renderer/d3d/d3d9/renderer9_utils.h
    src/libANGLE/renderer/d3d/d3d9/RenderTarget9.cpp
    src/libANGLE/renderer/d3d/d3d9/RenderTarget9.h
    src/libANGLE/renderer/d3d/d3d9/ShaderCache.h
    src/libANGLE/renderer/d3d/d3d9/ShaderExecutable9.cpp
    src/libANGLE/renderer/d3d/d3d9/ShaderExecutable9.h
    src/libANGLE/renderer/d3d/d3d9/shaders/compiled/componentmaskps.h
    src/libANGLE/renderer/d3d/d3d9/shaders/compiled/componentmaskpremultps.h
    src/libANGLE/renderer/d3d/d3d9/shaders/compiled/componentmaskunmultps.h
    src/libANGLE/renderer/d3d/d3d9/shaders/compiled/luminanceps.h
    src/libANGLE/renderer/d3d/d3d9/shaders/compiled/luminancepremultps.h
    src/libANGLE/renderer/d3d/d3d9/shaders/compiled/luminanceunmultps.h
    src/libANGLE/renderer/d3d/d3d9/shaders/compiled/passthroughps.h
    src/libANGLE/renderer/d3d/d3d9/shaders/compiled/standardvs.h
    src/libANGLE/renderer/d3d/d3d9/StateManager9.cpp
    src/libANGLE/renderer/d3d/d3d9/StateManager9.h
    src/libANGLE/renderer/d3d/d3d9/SwapChain9.cpp
    src/libANGLE/renderer/d3d/d3d9/SwapChain9.h
    src/libANGLE/renderer/d3d/d3d9/TextureStorage9.cpp
    src/libANGLE/renderer/d3d/d3d9/TextureStorage9.h
    src/libANGLE/renderer/d3d/d3d9/VertexArray9.h
    src/libANGLE/renderer/d3d/d3d9/VertexBuffer9.cpp
    src/libANGLE/renderer/d3d/d3d9/VertexBuffer9.h
    src/libANGLE/renderer/d3d/d3d9/vertexconversion.h
    src/libANGLE/renderer/d3d/d3d9/VertexDeclarationCache.cpp
    src/libANGLE/renderer/d3d/d3d9/VertexDeclarationCache.h
)

set(libangle_d3d11_sources
    src/libANGLE/renderer/d3d/d3d11/Blit11.cpp
    src/libANGLE/renderer/d3d/d3d11/Blit11.h
    src/libANGLE/renderer/d3d/d3d11/Blit11Helper_autogen.inc
    src/libANGLE/renderer/d3d/d3d11/Buffer11.cpp
    src/libANGLE/renderer/d3d/d3d11/Buffer11.h
    src/libANGLE/renderer/d3d/d3d11/Clear11.cpp
    src/libANGLE/renderer/d3d/d3d11/Clear11.h
    src/libANGLE/renderer/d3d/d3d11/Context11.cpp
    src/libANGLE/renderer/d3d/d3d11/Context11.h
    src/libANGLE/renderer/d3d/d3d11/DebugAnnotator11.cpp
    src/libANGLE/renderer/d3d/d3d11/DebugAnnotator11.h
    src/libANGLE/renderer/d3d/d3d11/dxgi_format_map_autogen.cpp
    src/libANGLE/renderer/d3d/d3d11/dxgi_support_table_autogen.cpp
    src/libANGLE/renderer/d3d/d3d11/dxgi_support_table.h
    src/libANGLE/renderer/d3d/d3d11/ExternalImageSiblingImpl11.cpp
    src/libANGLE/renderer/d3d/d3d11/ExternalImageSiblingImpl11.h
    src/libANGLE/renderer/d3d/d3d11/Fence11.cpp
    src/libANGLE/renderer/d3d/d3d11/Fence11.h
    src/libANGLE/renderer/d3d/d3d11/formatutils11.cpp
    src/libANGLE/renderer/d3d/d3d11/formatutils11.h
    src/libANGLE/renderer/d3d/d3d11/Framebuffer11.cpp
    src/libANGLE/renderer/d3d/d3d11/Framebuffer11.h
    src/libANGLE/renderer/d3d/d3d11/Image11.cpp
    src/libANGLE/renderer/d3d/d3d11/Image11.h
    src/libANGLE/renderer/d3d/d3d11/IndexBuffer11.cpp
    src/libANGLE/renderer/d3d/d3d11/IndexBuffer11.h
    src/libANGLE/renderer/d3d/d3d11/InputLayoutCache.cpp
    src/libANGLE/renderer/d3d/d3d11/InputLayoutCache.h
    src/libANGLE/renderer/d3d/d3d11/NativeWindow11.h
    src/libANGLE/renderer/d3d/d3d11/MappedSubresourceVerifier11.cpp
    src/libANGLE/renderer/d3d/d3d11/MappedSubresourceVerifier11.h
    src/libANGLE/renderer/d3d/d3d11/PixelTransfer11.cpp
    src/libANGLE/renderer/d3d/d3d11/PixelTransfer11.h
    src/libANGLE/renderer/d3d/d3d11/Program11.cpp
    src/libANGLE/renderer/d3d/d3d11/Program11.h
    src/libANGLE/renderer/d3d/d3d11/ProgramPipeline11.cpp
    src/libANGLE/renderer/d3d/d3d11/ProgramPipeline11.h
    src/libANGLE/renderer/d3d/d3d11/Query11.cpp
    src/libANGLE/renderer/d3d/d3d11/Query11.h
    src/libANGLE/renderer/d3d/d3d11/Renderer11.cpp
    src/libANGLE/renderer/d3d/d3d11/Renderer11.h
    src/libANGLE/renderer/d3d/d3d11/renderer11_utils.cpp
    src/libANGLE/renderer/d3d/d3d11/renderer11_utils.h
    src/libANGLE/renderer/d3d/d3d11/RenderStateCache.cpp
    src/libANGLE/renderer/d3d/d3d11/RenderStateCache.h
    src/libANGLE/renderer/d3d/d3d11/RenderTarget11.cpp
    src/libANGLE/renderer/d3d/d3d11/RenderTarget11.h
    src/libANGLE/renderer/d3d/d3d11/ResourceManager11.cpp
    src/libANGLE/renderer/d3d/d3d11/ResourceManager11.h
    src/libANGLE/renderer/d3d/d3d11/ShaderExecutable11.cpp
    src/libANGLE/renderer/d3d/d3d11/ShaderExecutable11.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/buffertotexture11_gs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/buffertotexture11_ps_4f.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/buffertotexture11_ps_4i.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/buffertotexture11_ps_4ui.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/buffertotexture11_vs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clear11_fl9vs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clear11multiviewgs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clear11multiviewvs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clear11vs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/cleardepth11ps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearfloat11_fl9ps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearfloat11ps1.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearfloat11ps2.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearfloat11ps3.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearfloat11ps4.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearfloat11ps5.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearfloat11ps6.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearfloat11ps7.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearfloat11ps8.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearsint11ps1.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearsint11ps2.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearsint11ps3.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearsint11ps4.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearsint11ps5.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearsint11ps6.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearsint11ps7.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearsint11ps8.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearuint11ps1.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearuint11ps2.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearuint11ps3.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearuint11ps4.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearuint11ps5.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearuint11ps6.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearuint11ps7.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/clearuint11ps8.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/passthrough2d11vs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/passthrough3d11gs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/passthrough3d11vs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/passthroughdepth2d11ps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/passthroughrgba2dms11ps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/resolvecolor2dps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/resolvedepth11_ps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/resolvedepthstencil11_ps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/resolvedepthstencil11_vs.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/resolvestencil11_ps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/swizzlef2darrayps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/swizzlef2dps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/swizzlef3dps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/swizzlei2darrayps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/swizzlei2dps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/swizzlei3dps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/swizzleui2darrayps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/swizzleui2dps.h
    src/libANGLE/renderer/d3d/d3d11/shaders/compiled/swizzleui3dps.h
    src/libANGLE/renderer/d3d/d3d11/StateManager11.cpp
    src/libANGLE/renderer/d3d/d3d11/StateManager11.h
    src/libANGLE/renderer/d3d/d3d11/StreamProducerD3DTexture.cpp
    src/libANGLE/renderer/d3d/d3d11/StreamProducerD3DTexture.h
    src/libANGLE/renderer/d3d/d3d11/SwapChain11.cpp
    src/libANGLE/renderer/d3d/d3d11/SwapChain11.h
    src/libANGLE/renderer/d3d/d3d11/texture_format_table.cpp
    src/libANGLE/renderer/d3d/d3d11/texture_format_table.h
    src/libANGLE/renderer/d3d/d3d11/texture_format_table_autogen.cpp
    src/libANGLE/renderer/d3d/d3d11/texture_format_table_utils.h
    src/libANGLE/renderer/d3d/d3d11/TextureStorage11.cpp
    src/libANGLE/renderer/d3d/d3d11/TextureStorage11.h
    src/libANGLE/renderer/d3d/d3d11/TransformFeedback11.cpp
    src/libANGLE/renderer/d3d/d3d11/TransformFeedback11.h
    src/libANGLE/renderer/d3d/d3d11/Trim11.cpp
    src/libANGLE/renderer/d3d/d3d11/Trim11.h
    src/libANGLE/renderer/d3d/d3d11/VertexArray11.cpp
    src/libANGLE/renderer/d3d/d3d11/VertexArray11.h
    src/libANGLE/renderer/d3d/d3d11/VertexBuffer11.cpp
    src/libANGLE/renderer/d3d/d3d11/VertexBuffer11.h
)

set(libangle_d3d11_win32_sources
    src/libANGLE/renderer/d3d/d3d11/win32/NativeWindow11Win32.cpp
    src/libANGLE/renderer/d3d/d3d11/win32/NativeWindow11Win32.h
    src/libANGLE/renderer/d3d/d3d11/converged/CompositorNativeWindow11.cpp
    src/libANGLE/renderer/d3d/d3d11/converged/CompositorNativeWindow11.h
    src/third_party/systeminfo/SystemInfo.cpp
    src/third_party/systeminfo/SystemInfo.h
)

set(libangle_d3d11_winrt_sources
    src/libANGLE/renderer/d3d/d3d11/winrt/CoreWindowNativeWindow.cpp
    src/libANGLE/renderer/d3d/d3d11/winrt/CoreWindowNativeWindow.h
    src/libANGLE/renderer/d3d/d3d11/winrt/InspectableNativeWindow.cpp
    src/libANGLE/renderer/d3d/d3d11/winrt/InspectableNativeWindow.h
    src/libANGLE/renderer/d3d/d3d11/winrt/NativeWindow11WinRT.cpp
    src/libANGLE/renderer/d3d/d3d11/winrt/NativeWindow11WinRT.h
    src/libANGLE/renderer/d3d/d3d11/winrt/SwapChainPanelNativeWindow.cpp
    src/libANGLE/renderer/d3d/d3d11/winrt/SwapChainPanelNativeWindow.h
)

set(libangle_gl_sources
    src/libANGLE/renderer/gl/BlitGL.cpp
    src/libANGLE/renderer/gl/BlitGL.h
    src/libANGLE/renderer/gl/BufferGL.cpp
    src/libANGLE/renderer/gl/BufferGL.h
    src/libANGLE/renderer/gl/ClearMultiviewGL.cpp
    src/libANGLE/renderer/gl/ClearMultiviewGL.h
    src/libANGLE/renderer/gl/CompilerGL.cpp
    src/libANGLE/renderer/gl/CompilerGL.h
    src/libANGLE/renderer/gl/ContextGL.cpp
    src/libANGLE/renderer/gl/ContextGL.h
    src/libANGLE/renderer/gl/DispatchTableGL_autogen.cpp
    src/libANGLE/renderer/gl/DispatchTableGL_autogen.h
    src/libANGLE/renderer/gl/DisplayGL.cpp
    src/libANGLE/renderer/gl/DisplayGL.h
    src/libANGLE/renderer/gl/FenceNVGL.cpp
    src/libANGLE/renderer/gl/FenceNVGL.h
    src/libANGLE/renderer/gl/FramebufferGL.cpp
    src/libANGLE/renderer/gl/FramebufferGL.h
    src/libANGLE/renderer/gl/FunctionsGL.cpp
    src/libANGLE/renderer/gl/FunctionsGL.h
    src/libANGLE/renderer/gl/ImageGL.cpp
    src/libANGLE/renderer/gl/ImageGL.h
    src/libANGLE/renderer/gl/MemoryObjectGL.cpp
    src/libANGLE/renderer/gl/MemoryObjectGL.h
    src/libANGLE/renderer/gl/PathGL.h
    src/libANGLE/renderer/gl/PathGL.cpp
    src/libANGLE/renderer/gl/ProgramGL.cpp
    src/libANGLE/renderer/gl/ProgramGL.h
    src/libANGLE/renderer/gl/ProgramPipelineGL.cpp
    src/libANGLE/renderer/gl/ProgramPipelineGL.h
    src/libANGLE/renderer/gl/QueryGL.cpp
    src/libANGLE/renderer/gl/QueryGL.h
    src/libANGLE/renderer/gl/RenderbufferGL.cpp
    src/libANGLE/renderer/gl/RenderbufferGL.h
    src/libANGLE/renderer/gl/RendererGL.cpp
    src/libANGLE/renderer/gl/RendererGL.h
    src/libANGLE/renderer/gl/SamplerGL.cpp
    src/libANGLE/renderer/gl/SamplerGL.h
    src/libANGLE/renderer/gl/SemaphoreGL.cpp
    src/libANGLE/renderer/gl/SemaphoreGL.h
    src/libANGLE/renderer/gl/ShaderGL.cpp
    src/libANGLE/renderer/gl/ShaderGL.h
    src/libANGLE/renderer/gl/StateManagerGL.cpp
    src/libANGLE/renderer/gl/StateManagerGL.h
    src/libANGLE/renderer/gl/SurfaceGL.cpp
    src/libANGLE/renderer/gl/SurfaceGL.h
    src/libANGLE/renderer/gl/SyncGL.cpp
    src/libANGLE/renderer/gl/SyncGL.h
    src/libANGLE/renderer/gl/TextureGL.cpp
    src/libANGLE/renderer/gl/TextureGL.h
    src/libANGLE/renderer/gl/TransformFeedbackGL.cpp
    src/libANGLE/renderer/gl/TransformFeedbackGL.h
    src/libANGLE/renderer/gl/VertexArrayGL.cpp
    src/libANGLE/renderer/gl/VertexArrayGL.h
    src/libANGLE/renderer/gl/formatutilsgl.cpp
    src/libANGLE/renderer/gl/formatutilsgl.h
    src/libANGLE/renderer/gl/functionsgl_enums.h
    src/libANGLE/renderer/gl/functionsgl_typedefs.h
    src/libANGLE/renderer/gl/renderergl_utils.cpp
    src/libANGLE/renderer/gl/renderergl_utils.h
)

set(libangle_gl_null_sources
    src/libANGLE/renderer/gl/null_functions.cpp
    src/libANGLE/renderer/gl/null_functions.h
)

set(libangle_gl_wgl_sources
    src/libANGLE/renderer/gl/wgl/ContextWGL.cpp
    src/libANGLE/renderer/gl/wgl/ContextWGL.h
    src/libANGLE/renderer/gl/wgl/D3DTextureSurfaceWGL.cpp
    src/libANGLE/renderer/gl/wgl/D3DTextureSurfaceWGL.h
    src/libANGLE/renderer/gl/wgl/DisplayWGL.cpp
    src/libANGLE/renderer/gl/wgl/DisplayWGL.h
    src/libANGLE/renderer/gl/wgl/DXGISwapChainWindowSurfaceWGL.cpp
    src/libANGLE/renderer/gl/wgl/DXGISwapChainWindowSurfaceWGL.h
    src/libANGLE/renderer/gl/wgl/FunctionsWGL.cpp
    src/libANGLE/renderer/gl/wgl/FunctionsWGL.h
    src/libANGLE/renderer/gl/wgl/PbufferSurfaceWGL.cpp
    src/libANGLE/renderer/gl/wgl/PbufferSurfaceWGL.h
    src/libANGLE/renderer/gl/wgl/RendererWGL.cpp
    src/libANGLE/renderer/gl/wgl/RendererWGL.h
    src/libANGLE/renderer/gl/wgl/SurfaceWGL.h
    src/libANGLE/renderer/gl/wgl/WindowSurfaceWGL.cpp
    src/libANGLE/renderer/gl/wgl/WindowSurfaceWGL.h
    src/libANGLE/renderer/gl/wgl/functionswgl_typedefs.h
    src/libANGLE/renderer/gl/wgl/wgl_utils.cpp
    src/libANGLE/renderer/gl/wgl/wgl_utils.h
    src/third_party/khronos/GL/wglext.h
)

set(libangle_gl_glx_sources
    src/libANGLE/renderer/gl/glx/DisplayGLX.cpp
    src/libANGLE/renderer/gl/glx/DisplayGLX.h
    src/libANGLE/renderer/gl/glx/FunctionsGLX.cpp
    src/libANGLE/renderer/gl/glx/FunctionsGLX.h
    src/libANGLE/renderer/gl/glx/RendererGLX.h
    src/libANGLE/renderer/gl/glx/RendererGLX.cpp
    src/libANGLE/renderer/gl/glx/PbufferSurfaceGLX.cpp
    src/libANGLE/renderer/gl/glx/PbufferSurfaceGLX.h
    src/libANGLE/renderer/gl/glx/SurfaceGLX.h
    src/libANGLE/renderer/gl/glx/WindowSurfaceGLX.cpp
    src/libANGLE/renderer/gl/glx/WindowSurfaceGLX.h
    src/libANGLE/renderer/gl/glx/functionsglx_typedefs.h
    src/libANGLE/renderer/gl/glx/platform_glx.h
)

set(libangle_gl_egl_sources
    src/libANGLE/renderer/gl/egl/ContextEGL.cpp
    src/libANGLE/renderer/gl/egl/ContextEGL.h
    src/libANGLE/renderer/gl/egl/DisplayEGL.cpp
    src/libANGLE/renderer/gl/egl/DisplayEGL.h
    src/libANGLE/renderer/gl/egl/ExternalImageSiblingEGL.h
    src/libANGLE/renderer/gl/egl/egl_utils.cpp
    src/libANGLE/renderer/gl/egl/egl_utils.h
    src/libANGLE/renderer/gl/egl/FunctionsEGL.cpp
    src/libANGLE/renderer/gl/egl/FunctionsEGL.h
    src/libANGLE/renderer/gl/egl/ImageEGL.cpp
    src/libANGLE/renderer/gl/egl/ImageEGL.h
    src/libANGLE/renderer/gl/egl/functionsegl_typedefs.h
    src/libANGLE/renderer/gl/egl/PbufferSurfaceEGL.cpp
    src/libANGLE/renderer/gl/egl/PbufferSurfaceEGL.h
    src/libANGLE/renderer/gl/egl/RendererEGL.cpp
    src/libANGLE/renderer/gl/egl/RendererEGL.h
    src/libANGLE/renderer/gl/egl/SurfaceEGL.cpp
    src/libANGLE/renderer/gl/egl/SurfaceEGL.h
    src/libANGLE/renderer/gl/egl/SyncEGL.cpp
    src/libANGLE/renderer/gl/egl/SyncEGL.h
    src/libANGLE/renderer/gl/egl/WindowSurfaceEGL.cpp
    src/libANGLE/renderer/gl/egl/WindowSurfaceEGL.h
)

set(libangle_gl_egl_dl_sources
    src/libANGLE/renderer/gl/egl/FunctionsEGLDL.cpp
    src/libANGLE/renderer/gl/egl/FunctionsEGLDL.h
)

set(libangle_gl_ozone_sources
    src/libANGLE/renderer/gl/egl/ozone/DisplayOzone.cpp
    src/libANGLE/renderer/gl/egl/ozone/DisplayOzone.h
    src/libANGLE/renderer/gl/egl/ozone/SurfaceOzone.cpp
    src/libANGLE/renderer/gl/egl/ozone/SurfaceOzone.h
)

set(libangle_gl_egl_android_sources
    src/libANGLE/renderer/gl/egl/android/DisplayAndroid.cpp
    src/libANGLE/renderer/gl/egl/android/DisplayAndroid.h
    src/libANGLE/renderer/gl/egl/android/NativeBufferImageSiblingAndroid.cpp
    src/libANGLE/renderer/gl/egl/android/NativeBufferImageSiblingAndroid.h
)

set(libangle_gl_cgl_sources
    src/libANGLE/renderer/gl/cgl/ContextCGL.cpp
    src/libANGLE/renderer/gl/cgl/ContextCGL.h
    src/libANGLE/renderer/gl/cgl/DeviceCGL.cpp
    src/libANGLE/renderer/gl/cgl/DeviceCGL.h
    src/libANGLE/renderer/gl/cgl/DisplayCGL.mm
    src/libANGLE/renderer/gl/cgl/DisplayCGL.h
    src/libANGLE/renderer/gl/cgl/IOSurfaceSurfaceCGL.mm
    src/libANGLE/renderer/gl/cgl/IOSurfaceSurfaceCGL.h
    src/libANGLE/renderer/gl/cgl/RendererCGL.mm
    src/libANGLE/renderer/gl/cgl/RendererCGL.h
    src/libANGLE/renderer/gl/cgl/PbufferSurfaceCGL.mm
    src/libANGLE/renderer/gl/cgl/PbufferSurfaceCGL.h
    src/libANGLE/renderer/gl/cgl/WindowSurfaceCGL.mm
    src/libANGLE/renderer/gl/cgl/WindowSurfaceCGL.h
)

set(libangle_mac_sources src/libANGLE/renderer/driver_utils_mac.mm)

set(libangle_vulkan_sources
    src/libANGLE/renderer/vulkan/BufferVk.cpp
    src/libANGLE/renderer/vulkan/BufferVk.h
    src/libANGLE/renderer/vulkan/CommandGraph.cpp
    src/libANGLE/renderer/vulkan/CommandGraph.h
    src/libANGLE/renderer/vulkan/CompilerVk.cpp
    src/libANGLE/renderer/vulkan/CompilerVk.h
    src/libANGLE/renderer/vulkan/ContextVk.cpp
    src/libANGLE/renderer/vulkan/ContextVk.h
    src/libANGLE/renderer/vulkan/DeviceVk.cpp
    src/libANGLE/renderer/vulkan/DeviceVk.h
    src/libANGLE/renderer/vulkan/DisplayVk.cpp
    src/libANGLE/renderer/vulkan/DisplayVk.h
    src/libANGLE/renderer/vulkan/FenceNVVk.cpp
    src/libANGLE/renderer/vulkan/FenceNVVk.h
    src/libANGLE/renderer/vulkan/FramebufferVk.cpp
    src/libANGLE/renderer/vulkan/FramebufferVk.h
    src/libANGLE/renderer/vulkan/GlslangWrapper.cpp
    src/libANGLE/renderer/vulkan/GlslangWrapper.h
    src/libANGLE/renderer/vulkan/ImageVk.cpp
    src/libANGLE/renderer/vulkan/ImageVk.h
    src/libANGLE/renderer/vulkan/MemoryObjectVk.cpp
    src/libANGLE/renderer/vulkan/MemoryObjectVk.h
    src/libANGLE/renderer/vulkan/PersistentCommandPool.cpp
    src/libANGLE/renderer/vulkan/PersistentCommandPool.h
    src/libANGLE/renderer/vulkan/ProgramVk.cpp
    src/libANGLE/renderer/vulkan/ProgramVk.h
    src/libANGLE/renderer/vulkan/ProgramPipelineVk.cpp
    src/libANGLE/renderer/vulkan/ProgramPipelineVk.h
    src/libANGLE/renderer/vulkan/QueryVk.cpp
    src/libANGLE/renderer/vulkan/QueryVk.h
    src/libANGLE/renderer/vulkan/RenderbufferVk.cpp
    src/libANGLE/renderer/vulkan/RenderbufferVk.h
    src/libANGLE/renderer/vulkan/RendererVk.cpp
    src/libANGLE/renderer/vulkan/RendererVk.h
    src/libANGLE/renderer/vulkan/RenderTargetVk.cpp
    src/libANGLE/renderer/vulkan/RenderTargetVk.h
    src/libANGLE/renderer/vulkan/SamplerVk.cpp
    src/libANGLE/renderer/vulkan/SamplerVk.h
    src/libANGLE/renderer/vulkan/SecondaryCommandBuffer.cpp
    src/libANGLE/renderer/vulkan/SecondaryCommandBuffer.h
    src/libANGLE/renderer/vulkan/SemaphoreVk.cpp
    src/libANGLE/renderer/vulkan/SemaphoreVk.h
    src/libANGLE/renderer/vulkan/ShaderVk.cpp
    src/libANGLE/renderer/vulkan/ShaderVk.h
    src/libANGLE/renderer/vulkan/SurfaceVk.cpp
    src/libANGLE/renderer/vulkan/SurfaceVk.h
    src/libANGLE/renderer/vulkan/SyncVk.cpp
    src/libANGLE/renderer/vulkan/SyncVk.h
    src/libANGLE/renderer/vulkan/TextureVk.cpp
    src/libANGLE/renderer/vulkan/TextureVk.h
    src/libANGLE/renderer/vulkan/TransformFeedbackVk.cpp
    src/libANGLE/renderer/vulkan/TransformFeedbackVk.h
    src/libANGLE/renderer/vulkan/UtilsVk.cpp
    src/libANGLE/renderer/vulkan/UtilsVk.h
    src/libANGLE/renderer/vulkan/VertexArrayVk.cpp
    src/libANGLE/renderer/vulkan/VertexArrayVk.h
    src/libANGLE/renderer/vulkan/vk_cache_utils.cpp
    src/libANGLE/renderer/vulkan/vk_cache_utils.h
    src/libANGLE/renderer/vulkan/vk_caps_utils.cpp
    src/libANGLE/renderer/vulkan/vk_caps_utils.h
    src/libANGLE/renderer/vulkan/vk_format_table_autogen.cpp
    src/libANGLE/renderer/vulkan/vk_format_utils.h
    src/libANGLE/renderer/vulkan/vk_format_utils.cpp
    src/libANGLE/renderer/vulkan/vk_helpers.cpp
    src/libANGLE/renderer/vulkan/vk_helpers.h
    src/libANGLE/renderer/vulkan/vk_internal_shaders_autogen.h
    src/libANGLE/renderer/vulkan/vk_internal_shaders_autogen.cpp
    src/libANGLE/renderer/vulkan/vk_mandatory_format_support_table_autogen.cpp
    src/libANGLE/renderer/vulkan/vk_utils.cpp
    src/libANGLE/renderer/vulkan/vk_utils.h
    src/libANGLE/renderer/vulkan/vk_wrapper.h
)

set(libangle_capture_sources
    # If frame capture support is desired, uncomment this, comment out
    # FrameCapture_mock.cpp, and set ANGLE_CAPTURE_ENABLED=1 in
    # ANGLE_DEFINITIONS.
    # src/libANGLE/FrameCapture.cpp
    src/libANGLE/FrameCapture_mock.cpp
    src/libANGLE/capture_gles_1_0_autogen.cpp
    src/libANGLE/capture_gles_1_0_params.cpp
    src/libANGLE/capture_gles_2_0_autogen.cpp
    src/libANGLE/capture_gles_2_0_params.cpp
    src/libANGLE/capture_gles_3_0_autogen.cpp
    src/libANGLE/capture_gles_3_0_params.cpp
    src/libANGLE/capture_gles_3_1_autogen.cpp
    src/libANGLE/capture_gles_3_1_params.cpp
    src/libANGLE/capture_gles_ext_autogen.cpp
    src/libANGLE/capture_gles_ext_params.cpp
    src/libANGLE/frame_capture_utils_autogen.cpp
    src/libANGLE/gl_enum_utils_autogen.cpp
)

set(libangle_vulkan_android_sources
    src/libANGLE/renderer/vulkan/android/DisplayVkAndroid.cpp
    src/libANGLE/renderer/vulkan/android/DisplayVkAndroid.h
    src/libANGLE/renderer/vulkan/android/HardwareBufferImageSiblingVkAndroid.cpp
    src/libANGLE/renderer/vulkan/android/HardwareBufferImageSiblingVkAndroid.h
    src/libANGLE/renderer/vulkan/android/WindowSurfaceVkAndroid.cpp
    src/libANGLE/renderer/vulkan/android/WindowSurfaceVkAndroid.h
)

set(libangle_vulkan_win32_sources
    src/libANGLE/renderer/vulkan/win32/DisplayVkWin32.cpp
    src/libANGLE/renderer/vulkan/win32/DisplayVkWin32.h
    src/libANGLE/renderer/vulkan/win32/WindowSurfaceVkWin32.cpp
    src/libANGLE/renderer/vulkan/win32/WindowSurfaceVkWin32.h
)

set(libangle_vulkan_xcb_sources
    src/libANGLE/renderer/vulkan/xcb/DisplayVkXcb.cpp
    src/libANGLE/renderer/vulkan/xcb/DisplayVkXcb.h
    src/libANGLE/renderer/vulkan/xcb/WindowSurfaceVkXcb.cpp
    src/libANGLE/renderer/vulkan/xcb/WindowSurfaceVkXcb.h
)

set(libangle_vulkan_fuchsia_sources
    src/libANGLE/renderer/vulkan/fuchsia/DisplayVkFuchsia.cpp
    src/libANGLE/renderer/vulkan/fuchsia/DisplayVkFuchsia.h
    src/libANGLE/renderer/vulkan/fuchsia/WindowSurfaceVkFuchsia.cpp
    src/libANGLE/renderer/vulkan/fuchsia/WindowSurfaceVkFuchsia.h
)

set(libangle_null_sources
    src/libANGLE/renderer/null/BufferNULL.cpp
    src/libANGLE/renderer/null/BufferNULL.h
    src/libANGLE/renderer/null/CompilerNULL.cpp
    src/libANGLE/renderer/null/CompilerNULL.h
    src/libANGLE/renderer/null/ContextNULL.cpp
    src/libANGLE/renderer/null/ContextNULL.h
    src/libANGLE/renderer/null/DeviceNULL.cpp
    src/libANGLE/renderer/null/DeviceNULL.h
    src/libANGLE/renderer/null/DisplayNULL.cpp
    src/libANGLE/renderer/null/DisplayNULL.h
    src/libANGLE/renderer/null/FenceNVNULL.cpp
    src/libANGLE/renderer/null/FenceNVNULL.h
    src/libANGLE/renderer/null/FramebufferNULL.cpp
    src/libANGLE/renderer/null/FramebufferNULL.h
    src/libANGLE/renderer/null/ImageNULL.cpp
    src/libANGLE/renderer/null/ImageNULL.h
    src/libANGLE/renderer/null/PathNULL.cpp
    src/libANGLE/renderer/null/PathNULL.h
    src/libANGLE/renderer/null/ProgramNULL.cpp
    src/libANGLE/renderer/null/ProgramNULL.h
    src/libANGLE/renderer/null/ProgramPipelineNULL.cpp
    src/libANGLE/renderer/null/ProgramPipelineNULL.h
    src/libANGLE/renderer/null/QueryNULL.cpp
    src/libANGLE/renderer/null/QueryNULL.h
    src/libANGLE/renderer/null/RenderbufferNULL.cpp
    src/libANGLE/renderer/null/RenderbufferNULL.h
    src/libANGLE/renderer/null/SamplerNULL.cpp
    src/libANGLE/renderer/null/SamplerNULL.h
    src/libANGLE/renderer/null/ShaderNULL.cpp
    src/libANGLE/renderer/null/ShaderNULL.h
    src/libANGLE/renderer/null/SurfaceNULL.cpp
    src/libANGLE/renderer/null/SurfaceNULL.h
    src/libANGLE/renderer/null/SyncNULL.cpp
    src/libANGLE/renderer/null/SyncNULL.h
    src/libANGLE/renderer/null/TextureNULL.cpp
    src/libANGLE/renderer/null/TextureNULL.h
    src/libANGLE/renderer/null/TransformFeedbackNULL.cpp
    src/libANGLE/renderer/null/TransformFeedbackNULL.h
    src/libANGLE/renderer/null/VertexArrayNULL.cpp
    src/libANGLE/renderer/null/VertexArrayNULL.h
)

set(libgl_sources
    src/common/angleutils.h
    src/common/debug.h
    src/libGLESv2/global_state.cpp
    src/libGLESv2/global_state.h
    src/libGL/entry_points_gl_1_0_autogen.cpp
    src/libGL/entry_points_gl_1_0_autogen.h
    src/libGL/entry_points_gl_1_1_autogen.cpp
    src/libGL/entry_points_gl_1_1_autogen.h
    src/libGL/entry_points_gl_1_2_autogen.cpp
    src/libGL/entry_points_gl_1_2_autogen.h
    src/libGL/entry_points_gl_1_3_autogen.cpp
    src/libGL/entry_points_gl_1_3_autogen.h
    src/libGL/entry_points_gl_1_4_autogen.cpp
    src/libGL/entry_points_gl_1_4_autogen.h
    src/libGL/entry_points_gl_1_5_autogen.cpp
    src/libGL/entry_points_gl_1_5_autogen.h
    src/libGL/entry_points_gl_2_0_autogen.cpp
    src/libGL/entry_points_gl_2_0_autogen.h
    src/libGL/entry_points_gl_2_1_autogen.cpp
    src/libGL/entry_points_gl_2_1_autogen.h
    src/libGL/entry_points_gl_3_0_autogen.cpp
    src/libGL/entry_points_gl_3_0_autogen.h
    src/libGL/entry_points_gl_3_1_autogen.cpp
    src/libGL/entry_points_gl_3_1_autogen.h
    src/libGL/entry_points_gl_3_2_autogen.cpp
    src/libGL/entry_points_gl_3_2_autogen.h
    src/libGL/entry_points_gl_3_3_autogen.cpp
    src/libGL/entry_points_gl_3_3_autogen.h
    src/libGL/entry_points_gl_4_0_autogen.cpp
    src/libGL/entry_points_gl_4_0_autogen.h
    src/libGL/entry_points_gl_4_1_autogen.cpp
    src/libGL/entry_points_gl_4_1_autogen.h
    src/libGL/entry_points_gl_4_2_autogen.cpp
    src/libGL/entry_points_gl_4_2_autogen.h
    src/libGL/entry_points_gl_4_3_autogen.cpp
    src/libGL/entry_points_gl_4_3_autogen.h
    src/libGL/entry_points_gl_4_4_autogen.cpp
    src/libGL/entry_points_gl_4_6_autogen.cpp
    src/libGL/entry_points_gl_4_4_autogen.h
    src/libGL/entry_points_gl_4_5_autogen.cpp
    src/libGL/entry_points_gl_4_5_autogen.h
    src/libGL/entry_points_gl_4_6_autogen.h
    src/libGL/entry_points_wgl.cpp
    src/libGL/entry_points_wgl.h
    src/libGL/libGL_autogen.cpp
    src/libGL/libGL_autogen.def
    src/libGL/libGL.rc
    src/libGL/proc_table_wgl.h
    src/libGL/proc_table_wgl_autogen.cpp
    src/libGL/resource.h
)

set(libglesv2_sources
    src/common/angleutils.h
    src/common/debug.h
    src/libANGLE/entry_points_enum_autogen.h
    src/libANGLE/entry_points_utils.h
    src/libGLESv2/entry_points_egl.cpp
    src/libGLESv2/entry_points_egl.h
    src/libGLESv2/entry_points_egl_ext.cpp
    src/libGLESv2/entry_points_egl_ext.h
    src/libGLESv2/entry_points_gles_1_0_autogen.cpp
    src/libGLESv2/entry_points_gles_1_0_autogen.h
    src/libGLESv2/entry_points_gles_2_0_autogen.cpp
    src/libGLESv2/entry_points_gles_2_0_autogen.h
    src/libGLESv2/entry_points_gles_3_0_autogen.cpp
    src/libGLESv2/entry_points_gles_3_0_autogen.h
    src/libGLESv2/entry_points_gles_3_1_autogen.cpp
    src/libGLESv2/entry_points_gles_3_1_autogen.h
    src/libGLESv2/entry_points_gles_ext_autogen.cpp
    src/libGLESv2/entry_points_gles_ext_autogen.h
    src/libGLESv2/global_state.cpp
    src/libGLESv2/global_state.h
    src/libGLESv2/libGLESv2_autogen.cpp
    src/libGLESv2/libGLESv2.rc
    src/libGLESv2/proc_table_egl.h
    src/libGLESv2/proc_table_egl_autogen.cpp
    src/libGLESv2/resource.h
)

set(libglesv2_entry_points_headers
    src/libGLESv2/entry_points_egl.h
    src/libGLESv2/entry_points_gles_2_0_autogen.h
    src/libGLESv2/entry_points_gles_3_0_autogen.h
    src/libGLESv2/entry_points_gles_ext_autogen.h
)

set(libglesv1_cm_sources
    src/libGLESv1_CM/libGLESv1_CM.cpp
    src/libGLESv1_CM/libGLESv1_CM.def
    src/libGLESv1_CM/libGLESv1_CM.rc
    src/libGLESv1_CM/resource.h
)

set(libegl_sources
    src/libEGL/libEGL.cpp
    src/libEGL/libEGL.rc
    src/libEGL/resource.h
    src/libGLESv2/entry_points_egl.h
    src/libGLESv2/entry_points_egl_ext.h
    src/libEGL/egl_loader_autogen.h
)
