/************************************************************************/
/* File		file.h							*/
/*									*/
/* Purpose	This C++ header file defines the File class. The File	*/
/*		class provides a C++ interface to the physical file	*/
/*		routines. These physical file routines include routines	*/
/*		for creating, removing, opening, closing, reading,	*/
/*		writing, and positioning a file.			*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	00.00.00						*/
/*									*/
/* Date		Thursday, May 2, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef FILE_H			// If not defined...
#define FILE_H			// Then process the header file.

/* Headers	The following headers are required by file.h.		*/

#include "string++.h"			// String class.
#include "os.h"				// Physical operating physicalos.
#include "utilitymodule.h"		// UtilityModule class.

/* Constants	The following constants are used to open a file.	*/

const int FileRead		= 0;	// Read only.
const int FileWrite		= 1;	// Write only.
const int FileReadWrite		= 2;	// Read and write.

/* Constant	The following constant defines the default file mode	*/
/*		that will be used to create a file.			*/

const int FileMode		= PhysicalOSOwnRWX | PhysicalOSGrpRWX;

/* Constant	The following constant defines the default file flag	*/
/*		that will be used to open a file.			*/

const int FileFlag		= FileReadWrite;

/* Type		The following type defines a file pointer. The file	*/
/*		pointer is used to position a file.			*/

typedef unsigned long int	FilePointer;

/* Constants	These are the File class error constants.		*/

const int FileMaxError		= 9;	// Number of error messages.
const int FileNoError		= 0;	// No error.
const int FileNoStats		= 1;	// Could not obtain file stats.
const int FileNoMake		= 2;	// Could not create file.
const int FileNoDel		= 3;	// Could not delete file.
const int FileNoOpen		= 4;	// Could not open file.
const int FileNoClose		= 5;	// Could not close file.
const int FileNoRead		= 6;	// Could not read from file.
const int FileNoWrite		= 7;	// Could not write to file.
const int FileNoSeek		= 8;	// Could not position file.

/* Class	This is the File class. The File class provides a C++	*/
/*		interface to the physical file physicalos. Also, the File	*/
/*		class inherits from UtilityModule. UtilityModule	*/
/*		provides common program module functions such as	*/
/*		Report_Error.						*/

class File : public UtilityModule
   {
      public:
	 File();
	 ~File();
	 condition Does_File_Exist(const char*);
	 condition Does_File_Exist(const String&);
	 status Create_File(const char*, int*,
	    const int = FileMode);
	 status Create_File(const String&, int*,
	    const int = FileMode);
	 status Remove_File(const char*);
	 status Remove_File(const String&);
	 status Open_File(const char*, int*,
	    const int = FileFlag);
	 status Open_File(const String&, int*,
	    const int = FileFlag);
	 status Close_File(const int filehandle);
	 status Read_File(const int, void*, const int);
	 status Write_File(const int, void*, const int);
	 status Position_File(const int, const FilePointer);
   };


#endif					// FILE_H
