/************************************************************************/
/* File		webpublish.h						*/
/*									*/
/* Purpose	This C++ header file contains the definition for the	*/
/*		WebPublish class. The WebPublish class can be used to	*/
/*		publish one or more websites to one or more servers.	*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	0.1.0 (Prototype)					*/
/*									*/
/* Date		Sunday, July 7, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef WEBPUBLISH_H
#define WEBPUBLISH_H

/* Headers	The following headers are required by webpublish.h.	*/

#include <iostream>			// cout.
#include "ftp.h"			// FTP class.
#include "database.h"			// DataBase class.

/* Constants	These are the general WebPublish constants.		*/

const char WebPublishVersion[]	= "0.1.0";
const char WebPublishDir[]	= ".webpublish/";
const char WebPublishTempFile[]	= "transferoutput";
const int WebPublishDirMode	= PhysicalOSOwnRWX | PhysicalOSGrpRWX;

/* Constants	These are the WebPublish database file constants. Each	*/
/*		constant represents one of the database files.		*/

const int WebPublishFiles	= 5;	// Number of files.
const int WebPublishAccounts	= 0;	// Account data file.
const int WebPublishShell	= 1;	// Shell command data file.
const int WebPublishSynch	= 2;	// Synchronize data file.
const int WebPublishPublish	= 3;	// Publish data file.
const int WebPublishModes	= 4;	// Transfer modes.

/* Constants	These are the WebPublish command constants. Each	*/
/*		constant represents an operation to perform.		*/

const int WebPublishNoCommand	= 0;	// No command requested.
const int WebPublishDoPublish	= 1;	// Publish account.
const int WebPublishDoSynch	= 2;	// Synchronize account.
const int WebPublishDoAdd	= 3;	// Add a record.
const int WebPublishDoChange	= 4;	// Change a record.
const int WebPublishDoRemove	= 5;	// Remove a record.
const int WebPublishDoList	= 6;	// List a record.

/* Constants	These are the WebPublish error code constants. Each	*/
/*		constant represents a WebPublish error.			*/

const int WebPublishErrors	= 38;	// Max error messages.
const int WebPublishNoError	= 0;	// No error
const int WebPublishDefault	= 1;	// Default constructor used.
const int WebPublishBadCmd	= 2;	// Bad command line option.
const int WebPublishRepeatCmd	= 3;	// Repeated command line option.
const int WebPublishOneAct	= 4;	// Only one action at a time.
const int WebPublishNoAct	= 5;	// No action requested.
const int WebPublishMissingCmd	= 6;	// Missing command line argument.
const int WebPublishNoHome	= 7;	// Unknown $HOME directory.
const int WebPublishNoDir	= 8;	// Could not make WebPublish dir.
const int WebPublishDataMake	= 9;	// Could not make DataBase files.
const int WebPublishDataOpen	= 10;	// Could not open DataBase files.
const int WebPublishDataClose	= 11;	// Could not close files.
const int WebPublishBadInit	= 12;	// Error initializing object.
const int WebPublishNotInit	= 13;	// WebPublish is not init.
const int WebPublishBadGet	= 14;	// Could not get database rec.
const int WebPublishRequire	= 15;	// Required info missing.
const int WebPublishExist	= 16;	// Record already exits.
const int WebPublishNoExist	= 17;	// Record does not exist.
const int WebPublishBadStore	= 18;	// Could not store record.
const int WebPublishBadDel	= 19;	// Could not remove record.
const int WebPublishBadAccount	= 20;	// Account does not exist.
const int WebPublishBadHost	= 21;	// Could not establish connect.
const int WebPublishBadLogon	= 22;	// Could not logon.
const int WebPublishFTPClose	= 23;	// Could not close connect.
const int WebPublishBadCase	= 24;	// Unknown action requested.
const int WebPublishNotMode	= 25;	// Illegal file transfer mode.
const int WebPublishBadShell	= 26;	// Shell program crashed.
const int WebPublishShellVal	= 27;	// Shell program returned error.
const int WebPublishNotShell	= 28;	// Unknown shell return value.
const int WebPublishChangeDir	= 29;	// Could not change server dir.
const int WebPublishPutFile	= 30;	// Could not transfer file.
const int WebPublishBadStat	= 31;	// Could not get stats.
const int WebPublishNoMod	= 32;	// Could not get server mod time.
const int WebPublishDirOpen	= 33;	// Could not open directory.
const int WebPublishDirRead	= 34;	// Could not read directory.
const int WebPublishDirMake	= 35;	// Could not create server dir.
const int WebPublishBadDBFile	= 36;	// Unknown database file.
const int WebPublishBadChange	= 37;	// Cannot change database record.

class WebPublish : public UtilityModule
   {
      public:
         WebPublish();
         WebPublish(int argc, char** argv);
         ~WebPublish();

	 status Process(void);

      private:
         unsigned int		itshelpflag:1;
         unsigned int		itsversionflag:1;
         unsigned int		itsverboseflag:1;
	 unsigned int		itsinitflag:1;
	 unsigned int		itsdbopenflag:1;
	 unsigned int		itsloggedonflag:1;
	 unsigned int		itsforceflag:1;
	 unsigned int		itspromptflag:1;

         unsigned int		itsoperation;
	 String			itsaccount;
         String			itswebsite;
	 String			itsserver;
         String			itsuser;
         String			itspassword;
	 String			itsdirectory;
	 String			itsextension;
	 String			itspath;
	 int			itsdepth;
	 String			itsdepthtext;
	 FTPMode		itsmode;
	 String			itsmodetext;
	 String			itsdbfile;
	 int			itsfileitem;

         String			itshomedirectory;
         String			itsworkdirectory;
	 String			itstempfile;

	 int			itssinglecount;
	 String*		itssingles;

	 Dir			itsdir;
	 File			itsfile;
	 FTP			itsftp;
	 DataBase		itsdatabase;

         // These member functions are located in webpublishutility.cpp.

         status initialize_webpublish_database(void);
	 char response(void);
	 status does_record_exist(const int, const String&, condition&);
         void print_webpublish_version(void) const;
         void print_webpublish_help(void) const;
         void print_webpublish_copyright(void) const;

         // These member functions are located in webpublishparse.cpp.

         status store_parse_option(String&, char*);
         status parse_command_line_arguments(int, char**);

	 // These member function are located in webpublishpublish.cpp.

	 status remove_shells(void);
	 status remove_synchronize(void);
	 status remove_publish(void);
	 condition is_publish_path_excluded(const String&);
	 status transfer_file(DataRecord&, const String&, const String&);
	 status publish_file(DataRecord&, const String&, const String&);
	 status publish_files(DataRecord&);
	 status publish_directory(DataRecord&, const String&, const int);
	 status publish_account(DataRecord&);
	 status publish(void);

	 // These member functions are located in webpublishsynch.cpp.

	 condition is_synchronize_path_excluded(const String&);
	 status synchronize_directory(DataRecord&, const String&, const int);
	 status synchronize(void);

         // These member functions are located in webpublishactions.cpp.

	 status add_account(void);
	 status delete_account(void);
	 status list_account(void);
	 status change_account(void);
	 status add_shell(void);
	 status delete_shell(void);
	 status list_shell(void);
	 status change_shell(void);
	 status add_synch(void);
	 status delete_synch(void);
	 status list_synch(void);
	 status add_publish(void);
	 status delete_publish(void);
	 status list_publish(void);
	 status add_mode(void);
	 status delete_mode(void);
	 status list_mode(void);
	 status change_mode(void);
   };

#endif
