/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "asa" locale.
 */
public class LocalizedNamesImpl_asa extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AZ",
        "ZA",
        "AF",
        "IS",
        "AR",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AM",
        "AW",
        "AU",
        "AT",
        "AX",
        "IE",
        "BB",
        "BS",
        "BH",
        "BD",
        "BY",
        "BZ",
        "BJ",
        "BM",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BF",
        "MG",
        "BG",
        "BI",
        "BT",
        "BV",
        "CC",
        "TD",
        "CL",
        "CN",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "ZM",
        "ZW",
        "DM",
        "EA",
        "EH",
        "EC",
        "SV",
        "ER",
        "EE",
        "EU",
        "EZ",
        "AE",
        "FJ",
        "PH",
        "FO",
        "GA",
        "GM",
        "GG",
        "GH",
        "GN",
        "GW",
        "GQ",
        "GD",
        "GL",
        "GS",
        "GY",
        "GP",
        "GU",
        "GT",
        "GF",
        "HT",
        "ES",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IO",
        "IM",
        "IN",
        "ID",
        "IQ",
        "IT",
        "IL",
        "JM",
        "CF",
        "CZ",
        "DO",
        "CD",
        "JP",
        "JE",
        "GI",
        "DJ",
        "GE",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CV",
        "KI",
        "KG",
        "NF",
        "CI",
        "CO",
        "KM",
        "CG",
        "HR",
        "KP",
        "KR",
        "CR",
        "CU",
        "CY",
        "KW",
        "LA",
        "LU",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "MW",
        "MY",
        "ML",
        "MT",
        "US",
        "MQ",
        "MK",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "EG",
        "MO",
        "MV",
        "MD",
        "MC",
        "MN",
        "MS",
        "MR",
        "MU",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NZ",
        "NC",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PF",
        "PR",
        "QO",
        "RE",
        "RO",
        "RS",
        "RW",
        "SC",
        "SJ",
        "SS",
        "SX",
        "TA",
        "TZ",
        "TH",
        "TW",
        "TJ",
        "TF",
        "SM",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "ST",
        "SA",
        "SN",
        "SL",
        "SG",
        "SY",
        "LK",
        "SI",
        "SK",
        "SO",
        "SD",
        "SR",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TM",
        "TV",
        "UA",
        "IR",
        "BE",
        "UZ",
        "FR",
        "FI",
        "UG",
        "GR",
        "ET",
        "NL",
        "GB",
        "DE",
        "UM",
        "UN",
        "PT",
        "UY",
        "RU",
        "SZ",
        "SE",
        "CH",
        "TR",
        "VU",
        "VA",
        "VE",
        "VN",
        "CK",
        "FK",
        "KY",
        "MP",
        "MH",
        "SB",
        "TC",
        "VI",
        "VG",
        "WF",
        "XA",
        "XB",
        "XK",
        "YE",
        "JO",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Falme dha Kiarabu");
    namesMap.put("AF", "Afuganistani");
    namesMap.put("AG", "Antigua na Barbuda");
    namesMap.put("AR", "Ajentina");
    namesMap.put("AS", "Thamoa ya Marekani");
    namesMap.put("AT", "Authtria");
    namesMap.put("AU", "Authtralia");
    namesMap.put("AZ", "Adhabajani");
    namesMap.put("BA", "Bothnia na Hedhegovina");
    namesMap.put("BB", "Babadothi");
    namesMap.put("BD", "Bangladeshi");
    namesMap.put("BE", "Ubelgiji");
    namesMap.put("BF", "Bukinafatho");
    namesMap.put("BH", "Bahareni");
    namesMap.put("BJ", "Benini");
    namesMap.put("BR", "Brazili");
    namesMap.put("BS", "Bahama");
    namesMap.put("BT", "Butani");
    namesMap.put("BW", "Botthwana");
    namesMap.put("BY", "Belaruthi");
    namesMap.put("BZ", "Belidhe");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Jamhuri ya Kidemokrathia ya Kongo");
    namesMap.put("CF", "Jamhuri ya Afrika ya Kati");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Uthwithi");
    namesMap.put("CI", "Kodivaa");
    namesMap.put("CK", "Vithiwa vya Cook");
    namesMap.put("CM", "Kameruni");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CR", "Kothtarika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kepuvede");
    namesMap.put("CY", "Kuprothi");
    namesMap.put("CZ", "Jamhuri ya Cheki");
    namesMap.put("DE", "Ujerumani");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Denmaki");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Jamhuri ya Dominika");
    namesMap.put("DZ", "Aljeria");
    namesMap.put("EC", "Ekwado");
    namesMap.put("EE", "Ethtonia");
    namesMap.put("EG", "Mithri");
    namesMap.put("ES", "Hithpania");
    namesMap.put("ET", "Uhabeshi");
    namesMap.put("FI", "Ufini");
    namesMap.put("FK", "Vithiwa vya Falkland");
    namesMap.put("FM", "Mikronethia");
    namesMap.put("FR", "Ufarantha");
    namesMap.put("GA", "Gaboni");
    namesMap.put("GB", "Uingeredha");
    namesMap.put("GE", "Jojia");
    namesMap.put("GF", "Gwiyana ya Ufarantha");
    namesMap.put("GI", "Jibralta");
    namesMap.put("GL", "Grinlandi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Gwadelupe");
    namesMap.put("GQ", "Ginekweta");
    namesMap.put("GR", "Ugiriki");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Ginebisau");
    namesMap.put("HN", "Hondurathi");
    namesMap.put("HR", "Korathia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("ID", "Indonethia");
    namesMap.put("IE", "Ayalandi");
    namesMap.put("IL", "Ithraeli");
    namesMap.put("IO", "Ieneo la Uingeredha katika Bahari Hindi");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IR", "Uajemi");
    namesMap.put("IS", "Aithlandi");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Yordani");
    namesMap.put("JP", "Japani");
    namesMap.put("KG", "Kirigizithtani");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KM", "Komoro");
    namesMap.put("KN", "Thantakitdhi na Nevith");
    namesMap.put("KP", "Korea Kathkazini");
    namesMap.put("KR", "Korea Kuthini");
    namesMap.put("KW", "Kuwaiti");
    namesMap.put("KY", "Vithiwa vya Kayman");
    namesMap.put("KZ", "Kazakithtani");
    namesMap.put("LA", "Laothi");
    namesMap.put("LB", "Lebanoni");
    namesMap.put("LC", "Thantaluthia");
    namesMap.put("LI", "Lishenteni");
    namesMap.put("LK", "Thirilanka");
    namesMap.put("LS", "Lethoto");
    namesMap.put("LT", "Litwania");
    namesMap.put("LU", "Lathembagi");
    namesMap.put("LV", "Lativia");
    namesMap.put("MA", "Moroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MG", "Bukini");
    namesMap.put("MH", "Vithiwa vya Marshal");
    namesMap.put("MK", "Mathedonia");
    namesMap.put("MM", "Myama");
    namesMap.put("MP", "Vithiwa vya Mariana vya Kathkazini");
    namesMap.put("MQ", "Martiniki");
    namesMap.put("MR", "Moritania");
    namesMap.put("MS", "Monttherrati");
    namesMap.put("MU", "Morithi");
    namesMap.put("MV", "Modivu");
    namesMap.put("MX", "Mekthiko");
    namesMap.put("MY", "Malethia");
    namesMap.put("MZ", "Mthumbiji");
    namesMap.put("NC", "Nyukaledonia");
    namesMap.put("NE", "Nijeri");
    namesMap.put("NF", "Kithiwa cha Norfok");
    namesMap.put("NG", "Nijeria");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Uholandhi");
    namesMap.put("NO", "Norwe");
    namesMap.put("NP", "Nepali");
    namesMap.put("NZ", "Nyudhilandi");
    namesMap.put("OM", "Omani");
    namesMap.put("PF", "Polinesia ya Ufarantha");
    namesMap.put("PG", "Papua");
    namesMap.put("PH", "Filipino");
    namesMap.put("PK", "Pakithtani");
    namesMap.put("PL", "Polandi");
    namesMap.put("PM", "Thantapieri na Mikeloni");
    namesMap.put("PN", "Pitkairni");
    namesMap.put("PR", "Pwetoriko");
    namesMap.put("PS", "Palestina");
    namesMap.put("PT", "Ureno");
    namesMap.put("PY", "Paragwai");
    namesMap.put("QA", "Katari");
    namesMap.put("RE", "Riyunioni");
    namesMap.put("RU", "Uruthi");
    namesMap.put("SA", "Thaudi");
    namesMap.put("SB", "Vithiwa vya Tholomon");
    namesMap.put("SC", "Shelisheli");
    namesMap.put("SD", "Thudani");
    namesMap.put("SE", "Uthwidi");
    namesMap.put("SG", "Thingapoo");
    namesMap.put("SH", "Thantahelena");
    namesMap.put("SI", "Thlovenia");
    namesMap.put("SK", "Tholvakia");
    namesMap.put("SL", "Thiera Leoni");
    namesMap.put("SM", "Thamarino");
    namesMap.put("SN", "Thenegali");
    namesMap.put("SO", "Thomalia");
    namesMap.put("SR", "Thurinamu");
    namesMap.put("ST", "Thao Tome na Principe");
    namesMap.put("SV", "Elsavado");
    namesMap.put("SY", "Thiria");
    namesMap.put("SZ", "Uthwadhi");
    namesMap.put("TC", "Vithiwa vya Turki na Kaiko");
    namesMap.put("TD", "Chadi");
    namesMap.put("TH", "Tailandi");
    namesMap.put("TJ", "Tajikithtani");
    namesMap.put("TL", "Timori ya Mashariki");
    namesMap.put("TM", "Turukimenithtani");
    namesMap.put("TN", "Tunithia");
    namesMap.put("TR", "Uturuki");
    namesMap.put("TT", "Trinidad na Tobago");
    namesMap.put("TW", "Taiwani");
    namesMap.put("TZ", "Tadhania");
    namesMap.put("US", "Marekani");
    namesMap.put("UY", "Urugwai");
    namesMap.put("UZ", "Udhibekithtani");
    namesMap.put("VA", "Vatikani");
    namesMap.put("VC", "Thantavithenti na Grenadini");
    namesMap.put("VG", "Vithiwa vya Virgin vya Uingeredha");
    namesMap.put("VI", "Vithiwa vya Virgin vya Marekani");
    namesMap.put("VN", "Vietinamu");
    namesMap.put("WF", "Walith na Futuna");
    namesMap.put("WS", "Thamoa");
    namesMap.put("YE", "Yemeni");
    namesMap.put("ZA", "Afrika Kuthini");
    namesMap.put("ZM", "Dhambia");
    namesMap.put("ZW", "Dhimbabwe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andora",
        "AE": "Falme dha Kiarabu",
        "AF": "Afuganistani",
        "AG": "Antigua na Barbuda",
        "AR": "Ajentina",
        "AS": "Thamoa ya Marekani",
        "AT": "Authtria",
        "AU": "Authtralia",
        "AZ": "Adhabajani",
        "BA": "Bothnia na Hedhegovina",
        "BB": "Babadothi",
        "BD": "Bangladeshi",
        "BE": "Ubelgiji",
        "BF": "Bukinafatho",
        "BH": "Bahareni",
        "BJ": "Benini",
        "BR": "Brazili",
        "BS": "Bahama",
        "BT": "Butani",
        "BW": "Botthwana",
        "BY": "Belaruthi",
        "BZ": "Belidhe",
        "CA": "Kanada",
        "CD": "Jamhuri ya Kidemokrathia ya Kongo",
        "CF": "Jamhuri ya Afrika ya Kati",
        "CG": "Kongo",
        "CH": "Uthwithi",
        "CI": "Kodivaa",
        "CK": "Vithiwa vya Cook",
        "CM": "Kameruni",
        "CO": "Kolombia",
        "CR": "Kothtarika",
        "CU": "Kuba",
        "CV": "Kepuvede",
        "CY": "Kuprothi",
        "CZ": "Jamhuri ya Cheki",
        "DE": "Ujerumani",
        "DJ": "Jibuti",
        "DK": "Denmaki",
        "DM": "Dominika",
        "DO": "Jamhuri ya Dominika",
        "DZ": "Aljeria",
        "EC": "Ekwado",
        "EE": "Ethtonia",
        "EG": "Mithri",
        "ES": "Hithpania",
        "ET": "Uhabeshi",
        "FI": "Ufini",
        "FK": "Vithiwa vya Falkland",
        "FM": "Mikronethia",
        "FR": "Ufarantha",
        "GA": "Gaboni",
        "GB": "Uingeredha",
        "GE": "Jojia",
        "GF": "Gwiyana ya Ufarantha",
        "GI": "Jibralta",
        "GL": "Grinlandi",
        "GN": "Gine",
        "GP": "Gwadelupe",
        "GQ": "Ginekweta",
        "GR": "Ugiriki",
        "GT": "Gwatemala",
        "GU": "Gwam",
        "GW": "Ginebisau",
        "HN": "Hondurathi",
        "HR": "Korathia",
        "HU": "Hungaria",
        "ID": "Indonethia",
        "IE": "Ayalandi",
        "IL": "Ithraeli",
        "IO": "Ieneo la Uingeredha katika Bahari Hindi",
        "IQ": "Iraki",
        "IR": "Uajemi",
        "IS": "Aithlandi",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Yordani",
        "JP": "Japani",
        "KG": "Kirigizithtani",
        "KH": "Kambodia",
        "KM": "Komoro",
        "KN": "Thantakitdhi na Nevith",
        "KP": "Korea Kathkazini",
        "KR": "Korea Kuthini",
        "KW": "Kuwaiti",
        "KY": "Vithiwa vya Kayman",
        "KZ": "Kazakithtani",
        "LA": "Laothi",
        "LB": "Lebanoni",
        "LC": "Thantaluthia",
        "LI": "Lishenteni",
        "LK": "Thirilanka",
        "LS": "Lethoto",
        "LT": "Litwania",
        "LU": "Lathembagi",
        "LV": "Lativia",
        "MA": "Moroko",
        "MC": "Monako",
        "MG": "Bukini",
        "MH": "Vithiwa vya Marshal",
        "MK": "Mathedonia",
        "MM": "Myama",
        "MP": "Vithiwa vya Mariana vya Kathkazini",
        "MQ": "Martiniki",
        "MR": "Moritania",
        "MS": "Monttherrati",
        "MU": "Morithi",
        "MV": "Modivu",
        "MX": "Mekthiko",
        "MY": "Malethia",
        "MZ": "Mthumbiji",
        "NC": "Nyukaledonia",
        "NE": "Nijeri",
        "NF": "Kithiwa cha Norfok",
        "NG": "Nijeria",
        "NI": "Nikaragwa",
        "NL": "Uholandhi",
        "NO": "Norwe",
        "NP": "Nepali",
        "NZ": "Nyudhilandi",
        "OM": "Omani",
        "PF": "Polinesia ya Ufarantha",
        "PG": "Papua",
        "PH": "Filipino",
        "PK": "Pakithtani",
        "PL": "Polandi",
        "PM": "Thantapieri na Mikeloni",
        "PN": "Pitkairni",
        "PR": "Pwetoriko",
        "PS": "Palestina",
        "PT": "Ureno",
        "PY": "Paragwai",
        "QA": "Katari",
        "RE": "Riyunioni",
        "RU": "Uruthi",
        "SA": "Thaudi",
        "SB": "Vithiwa vya Tholomon",
        "SC": "Shelisheli",
        "SD": "Thudani",
        "SE": "Uthwidi",
        "SG": "Thingapoo",
        "SH": "Thantahelena",
        "SI": "Thlovenia",
        "SK": "Tholvakia",
        "SL": "Thiera Leoni",
        "SM": "Thamarino",
        "SN": "Thenegali",
        "SO": "Thomalia",
        "SR": "Thurinamu",
        "ST": "Thao Tome na Principe",
        "SV": "Elsavado",
        "SY": "Thiria",
        "SZ": "Uthwadhi",
        "TC": "Vithiwa vya Turki na Kaiko",
        "TD": "Chadi",
        "TH": "Tailandi",
        "TJ": "Tajikithtani",
        "TL": "Timori ya Mashariki",
        "TM": "Turukimenithtani",
        "TN": "Tunithia",
        "TR": "Uturuki",
        "TT": "Trinidad na Tobago",
        "TW": "Taiwani",
        "TZ": "Tadhania",
        "US": "Marekani",
        "UY": "Urugwai",
        "UZ": "Udhibekithtani",
        "VA": "Vatikani",
        "VC": "Thantavithenti na Grenadini",
        "VG": "Vithiwa vya Virgin vya Uingeredha",
        "VI": "Vithiwa vya Virgin vya Marekani",
        "VN": "Vietinamu",
        "WF": "Walith na Futuna",
        "WS": "Thamoa",
        "YE": "Yemeni",
        "ZA": "Afrika Kuthini",
        "ZM": "Dhambia",
        "ZW": "Dhimbabwe"
    };
  }-*/;
}
