/*******************************************************************************
 *
 *	Font metric data for Times-BoldItalic
 *
 *	Copyright 2001 Ian Pilcher
 *
 *
 *	See dlls/wineps/data/COPYRIGHTS for font copyright information.
 *
 */

#include "psdrv.h"


/*
 *  Glyph metrics
 */

static const AFMMETRICS metrics[228] =
{
    { 0x0020,  250 },
    { 0x0021,  389 },
    { 0x0022,  555 },
    { 0x0023,  500 },
    { 0x0024,  500 },
    { 0x0025,  833 },
    { 0x0026,  778 },
    { 0x0027,  278 },
    { 0x0028,  333 },
    { 0x0029,  333 },
    { 0x002a,  500 },
    { 0x002b,  570 },
    { 0x002c,  250 },
    { 0x002d,  333 },
    { 0x002e,  250 },
    { 0x002f,  278 },
    { 0x0030,  500 },
    { 0x0031,  500 },
    { 0x0032,  500 },
    { 0x0033,  500 },
    { 0x0034,  500 },
    { 0x0035,  500 },
    { 0x0036,  500 },
    { 0x0037,  500 },
    { 0x0038,  500 },
    { 0x0039,  500 },
    { 0x003a,  333 },
    { 0x003b,  333 },
    { 0x003c,  570 },
    { 0x003d,  570 },
    { 0x003e,  570 },
    { 0x003f,  500 },
    { 0x0040,  832 },
    { 0x0041,  667 },
    { 0x0042,  667 },
    { 0x0043,  667 },
    { 0x0044,  722 },
    { 0x0045,  667 },
    { 0x0046,  667 },
    { 0x0047,  722 },
    { 0x0048,  778 },
    { 0x0049,  389 },
    { 0x004a,  500 },
    { 0x004b,  667 },
    { 0x004c,  611 },
    { 0x004d,  889 },
    { 0x004e,  722 },
    { 0x004f,  722 },
    { 0x0050,  611 },
    { 0x0051,  722 },
    { 0x0052,  667 },
    { 0x0053,  556 },
    { 0x0054,  611 },
    { 0x0055,  722 },
    { 0x0056,  667 },
    { 0x0057,  889 },
    { 0x0058,  667 },
    { 0x0059,  611 },
    { 0x005a,  611 },
    { 0x005b,  333 },
    { 0x005c,  278 },
    { 0x005d,  333 },
    { 0x005e,  570 },
    { 0x005f,  500 },
    { 0x0060,  333 },
    { 0x0061,  500 },
    { 0x0062,  500 },
    { 0x0063,  444 },
    { 0x0064,  500 },
    { 0x0065,  444 },
    { 0x0066,  333 },
    { 0x0067,  500 },
    { 0x0068,  556 },
    { 0x0069,  278 },
    { 0x006a,  278 },
    { 0x006b,  500 },
    { 0x006c,  278 },
    { 0x006d,  778 },
    { 0x006e,  556 },
    { 0x006f,  500 },
    { 0x0070,  500 },
    { 0x0071,  500 },
    { 0x0072,  389 },
    { 0x0073,  389 },
    { 0x0074,  278 },
    { 0x0075,  556 },
    { 0x0076,  444 },
    { 0x0077,  667 },
    { 0x0078,  500 },
    { 0x0079,  444 },
    { 0x007a,  389 },
    { 0x007b,  348 },
    { 0x007c,  220 },
    { 0x007d,  348 },
    { 0x007e,  570 },
    { 0x00a1,  389 },
    { 0x00a2,  500 },
    { 0x00a3,  500 },
    { 0x00a4,  500 },
    { 0x00a5,  500 },
    { 0x00a6,  220 },
    { 0x00a7,  500 },
    { 0x00a8,  333 },
    { 0x00a9,  747 },
    { 0x00aa,  266 },
    { 0x00ab,  500 },
    { 0x00ac,  606 },
    { 0x00ae,  747 },
    { 0x00b0,  400 },
    { 0x00b1,  570 },
    { 0x00b2,  300 },
    { 0x00b3,  300 },
    { 0x00b4,  333 },
    { 0x00b6,  500 },
    { 0x00b7,  250 },
    { 0x00b8,  333 },
    { 0x00b9,  300 },
    { 0x00ba,  300 },
    { 0x00bb,  500 },
    { 0x00bc,  750 },
    { 0x00bd,  750 },
    { 0x00be,  750 },
    { 0x00bf,  500 },
    { 0x00c0,  667 },
    { 0x00c1,  667 },
    { 0x00c2,  667 },
    { 0x00c3,  667 },
    { 0x00c4,  667 },
    { 0x00c5,  667 },
    { 0x00c6,  944 },
    { 0x00c7,  667 },
    { 0x00c8,  667 },
    { 0x00c9,  667 },
    { 0x00ca,  667 },
    { 0x00cb,  667 },
    { 0x00cc,  389 },
    { 0x00cd,  389 },
    { 0x00ce,  389 },
    { 0x00cf,  389 },
    { 0x00d0,  722 },
    { 0x00d1,  722 },
    { 0x00d2,  722 },
    { 0x00d3,  722 },
    { 0x00d4,  722 },
    { 0x00d5,  722 },
    { 0x00d6,  722 },
    { 0x00d7,  570 },
    { 0x00d8,  722 },
    { 0x00d9,  722 },
    { 0x00da,  722 },
    { 0x00db,  722 },
    { 0x00dc,  722 },
    { 0x00dd,  611 },
    { 0x00de,  611 },
    { 0x00df,  500 },
    { 0x00e0,  500 },
    { 0x00e1,  500 },
    { 0x00e2,  500 },
    { 0x00e3,  500 },
    { 0x00e4,  500 },
    { 0x00e5,  500 },
    { 0x00e6,  722 },
    { 0x00e7,  444 },
    { 0x00e8,  444 },
    { 0x00e9,  444 },
    { 0x00ea,  444 },
    { 0x00eb,  444 },
    { 0x00ec,  278 },
    { 0x00ed,  278 },
    { 0x00ee,  278 },
    { 0x00ef,  278 },
    { 0x00f0,  500 },
    { 0x00f1,  556 },
    { 0x00f2,  500 },
    { 0x00f3,  500 },
    { 0x00f4,  500 },
    { 0x00f5,  500 },
    { 0x00f6,  500 },
    { 0x00f7,  570 },
    { 0x00f8,  500 },
    { 0x00f9,  556 },
    { 0x00fa,  556 },
    { 0x00fb,  556 },
    { 0x00fc,  556 },
    { 0x00fd,  444 },
    { 0x00fe,  500 },
    { 0x00ff,  444 },
    { 0x0131,  278 },
    { 0x0141,  611 },
    { 0x0142,  278 },
    { 0x0152,  944 },
    { 0x0153,  722 },
    { 0x0160,  556 },
    { 0x0161,  389 },
    { 0x0178,  611 },
    { 0x017d,  611 },
    { 0x017e,  389 },
    { 0x0192,  500 },
    { 0x02c6,  333 },
    { 0x02c7,  333 },
    { 0x02c9,  333 },
    { 0x02d8,  333 },
    { 0x02d9,  333 },
    { 0x02da,  333 },
    { 0x02db,  333 },
    { 0x02dc,  333 },
    { 0x02dd,  333 },
    { 0x03bc,  576 },
    { 0x2013,  500 },
    { 0x2014, 1000 },
    { 0x2018,  333 },
    { 0x2019,  333 },
    { 0x201a,  333 },
    { 0x201c,  500 },
    { 0x201d,  500 },
    { 0x201e,  500 },
    { 0x2020,  500 },
    { 0x2021,  500 },
    { 0x2022,  350 },
    { 0x2026, 1000 },
    { 0x2030, 1000 },
    { 0x2039,  333 },
    { 0x203a,  333 },
    { 0x2122, 1000 },
    { 0x2212,  606 },
    { 0x2215,  167 },
    { 0xfb01,  556 },
    { 0xfb02,  556 },
};


/*
 *  Font metrics
 */

const AFM PSDRV_Times_BoldItalic =
{
    "Times-BoldItalic",			    /* FontName */
    L"Times",				    /* FamilyName */
    L"AdobeStandardEncoding",		    /* EncodingScheme */
    FW_BOLD,				    /* Weight */
    -15,				    /* ItalicAngle */
    FALSE,				    /* IsFixedPitch */
    { -200, -218, 996, 921 },		    /* FontBBox */
    {
	1000,				    /* WinMetrics.usUnitsPerEm */
	891,				    /* WinMetrics.sAscender */
	-216,				    /* WinMetrics.sDescender */
	42,				    /* WinMetrics.sLineGap */
	412,				    /* WinMetrics.sAvgCharWidth */
	891,				    /* WinMetrics.usWinAscent */
	216				    /* WinMetrics.usWinDescent */
    },
    228,				    /* NumofMetrics */
    metrics				    /* Metrics */
};
