/*******************************************************************************
 *
 *	Font metric data for Bookman-DemiItalic
 *
 *	Copyright 2001 Ian Pilcher
 *
 *
 *	See dlls/wineps/data/COPYRIGHTS for font copyright information.
 *
 */

#include "psdrv.h"


/*
 *  Glyph metrics
 */

static const AFMMETRICS metrics[228] =
{
    { 0x0020,  340 },
    { 0x0021,  320 },
    { 0x0022,  380 },
    { 0x0023,  680 },
    { 0x0024,  680 },
    { 0x0025,  880 },
    { 0x0026,  980 },
    { 0x0027,  180 },
    { 0x0028,  260 },
    { 0x0029,  260 },
    { 0x002a,  460 },
    { 0x002b,  600 },
    { 0x002c,  340 },
    { 0x002d,  280 },
    { 0x002e,  340 },
    { 0x002f,  360 },
    { 0x0030,  680 },
    { 0x0031,  680 },
    { 0x0032,  680 },
    { 0x0033,  680 },
    { 0x0034,  680 },
    { 0x0035,  680 },
    { 0x0036,  680 },
    { 0x0037,  680 },
    { 0x0038,  680 },
    { 0x0039,  680 },
    { 0x003a,  340 },
    { 0x003b,  340 },
    { 0x003c,  620 },
    { 0x003d,  600 },
    { 0x003e,  620 },
    { 0x003f,  620 },
    { 0x0040,  780 },
    { 0x0041,  720 },
    { 0x0042,  720 },
    { 0x0043,  700 },
    { 0x0044,  760 },
    { 0x0045,  720 },
    { 0x0046,  660 },
    { 0x0047,  760 },
    { 0x0048,  800 },
    { 0x0049,  380 },
    { 0x004a,  620 },
    { 0x004b,  780 },
    { 0x004c,  640 },
    { 0x004d,  860 },
    { 0x004e,  740 },
    { 0x004f,  760 },
    { 0x0050,  640 },
    { 0x0051,  760 },
    { 0x0052,  740 },
    { 0x0053,  700 },
    { 0x0054,  700 },
    { 0x0055,  740 },
    { 0x0056,  660 },
    { 0x0057, 1000 },
    { 0x0058,  740 },
    { 0x0059,  660 },
    { 0x005a,  680 },
    { 0x005b,  260 },
    { 0x005c,  580 },
    { 0x005d,  260 },
    { 0x005e,  620 },
    { 0x005f,  500 },
    { 0x0060,  380 },
    { 0x0061,  680 },
    { 0x0062,  600 },
    { 0x0063,  560 },
    { 0x0064,  680 },
    { 0x0065,  560 },
    { 0x0066,  420 },
    { 0x0067,  620 },
    { 0x0068,  700 },
    { 0x0069,  380 },
    { 0x006a,  320 },
    { 0x006b,  700 },
    { 0x006c,  380 },
    { 0x006d,  960 },
    { 0x006e,  680 },
    { 0x006f,  600 },
    { 0x0070,  660 },
    { 0x0071,  620 },
    { 0x0072,  500 },
    { 0x0073,  540 },
    { 0x0074,  440 },
    { 0x0075,  680 },
    { 0x0076,  540 },
    { 0x0077,  860 },
    { 0x0078,  620 },
    { 0x0079,  600 },
    { 0x007a,  560 },
    { 0x007b,  300 },
    { 0x007c,  620 },
    { 0x007d,  300 },
    { 0x007e,  620 },
    { 0x00a1,  320 },
    { 0x00a2,  680 },
    { 0x00a3,  680 },
    { 0x00a4,  680 },
    { 0x00a5,  680 },
    { 0x00a6,  620 },
    { 0x00a7,  620 },
    { 0x00a8,  520 },
    { 0x00a9,  780 },
    { 0x00aa,  440 },
    { 0x00ab,  380 },
    { 0x00ac,  620 },
    { 0x00ae,  780 },
    { 0x00b0,  400 },
    { 0x00b1,  600 },
    { 0x00b2,  408 },
    { 0x00b3,  408 },
    { 0x00b4,  340 },
    { 0x00b6,  680 },
    { 0x00b7,  340 },
    { 0x00b8,  360 },
    { 0x00b9,  408 },
    { 0x00ba,  440 },
    { 0x00bb,  380 },
    { 0x00bc, 1020 },
    { 0x00bd, 1020 },
    { 0x00be, 1020 },
    { 0x00bf,  620 },
    { 0x00c0,  720 },
    { 0x00c1,  720 },
    { 0x00c2,  720 },
    { 0x00c3,  720 },
    { 0x00c4,  720 },
    { 0x00c5,  720 },
    { 0x00c6, 1140 },
    { 0x00c7,  700 },
    { 0x00c8,  720 },
    { 0x00c9,  720 },
    { 0x00ca,  720 },
    { 0x00cb,  720 },
    { 0x00cc,  380 },
    { 0x00cd,  380 },
    { 0x00ce,  380 },
    { 0x00cf,  380 },
    { 0x00d0,  760 },
    { 0x00d1,  740 },
    { 0x00d2,  760 },
    { 0x00d3,  760 },
    { 0x00d4,  760 },
    { 0x00d5,  760 },
    { 0x00d6,  760 },
    { 0x00d7,  600 },
    { 0x00d8,  760 },
    { 0x00d9,  740 },
    { 0x00da,  740 },
    { 0x00db,  740 },
    { 0x00dc,  740 },
    { 0x00dd,  660 },
    { 0x00de,  640 },
    { 0x00df,  660 },
    { 0x00e0,  680 },
    { 0x00e1,  680 },
    { 0x00e2,  680 },
    { 0x00e3,  680 },
    { 0x00e4,  680 },
    { 0x00e5,  680 },
    { 0x00e6,  880 },
    { 0x00e7,  560 },
    { 0x00e8,  560 },
    { 0x00e9,  560 },
    { 0x00ea,  560 },
    { 0x00eb,  560 },
    { 0x00ec,  380 },
    { 0x00ed,  380 },
    { 0x00ee,  380 },
    { 0x00ef,  380 },
    { 0x00f0,  600 },
    { 0x00f1,  680 },
    { 0x00f2,  600 },
    { 0x00f3,  600 },
    { 0x00f4,  600 },
    { 0x00f5,  600 },
    { 0x00f6,  600 },
    { 0x00f7,  600 },
    { 0x00f8,  600 },
    { 0x00f9,  680 },
    { 0x00fa,  680 },
    { 0x00fb,  680 },
    { 0x00fc,  680 },
    { 0x00fd,  600 },
    { 0x00fe,  660 },
    { 0x00ff,  600 },
    { 0x0131,  380 },
    { 0x0141,  640 },
    { 0x0142,  380 },
    { 0x0152, 1180 },
    { 0x0153,  920 },
    { 0x0160,  700 },
    { 0x0161,  540 },
    { 0x0178,  660 },
    { 0x017d,  680 },
    { 0x017e,  560 },
    { 0x0192,  680 },
    { 0x02c6,  480 },
    { 0x02c7,  480 },
    { 0x02c9,  480 },
    { 0x02d8,  460 },
    { 0x02d9,  380 },
    { 0x02da,  360 },
    { 0x02db,  320 },
    { 0x02dc,  480 },
    { 0x02dd,  560 },
    { 0x03bc,  680 },
    { 0x2013,  500 },
    { 0x2014, 1000 },
    { 0x2018,  320 },
    { 0x2019,  320 },
    { 0x201a,  300 },
    { 0x201c,  520 },
    { 0x201d,  520 },
    { 0x201e,  520 },
    { 0x2020,  420 },
    { 0x2021,  420 },
    { 0x2022,  360 },
    { 0x2026, 1000 },
    { 0x2030, 1360 },
    { 0x2039,  220 },
    { 0x203a,  220 },
    { 0x2122,  940 },
    { 0x2212,  600 },
    { 0x2215,  120 },
    { 0xfb01,  820 },
    { 0xfb02,  820 },
};


/*
 *  Font metrics
 */

const AFM PSDRV_Bookman_DemiItalic =
{
    "Bookman-DemiItalic",		    /* FontName */
    L"ITC Bookman",			    /* FamilyName */
    L"AdobeStandardEncoding",		    /* EncodingScheme */
    FW_BOLD,				    /* Weight */
    -10,				    /* ItalicAngle */
    FALSE,				    /* IsFixedPitch */
    { -231, -250, 1333, 941 },		    /* FontBBox */
    {
	1000,				    /* WinMetrics.usUnitsPerEm */
	942,				    /* WinMetrics.sAscender */
	-232,				    /* WinMetrics.sDescender */
	0,				    /* WinMetrics.sLineGap */
	538,				    /* WinMetrics.sAvgCharWidth */
	942,				    /* WinMetrics.usWinAscent */
	231				    /* WinMetrics.usWinDescent */
    },
    228,				    /* NumofMetrics */
    metrics				    /* Metrics */
};
