# encoding: utf-8
Given(/^I have a file to compile$/) do
  add_run_input SAMPLE_COMPILE
end

Given(/^I have a xib to compile$/) do
  add_run_input SAMPLE_COMPILE_XIB
end

Given(/^I have a storyboard to compile$/) do
  add_run_input SAMPLE_COMPILE_STORYBOARD
end

Given(/^I have a precompiled header$/) do
  add_run_input SAMPLE_PRECOMPILE
end

Given(/^I have an aggregate target to build$/) do
  add_run_input SAMPLE_AGGREGATE_TARGET
end

Given(/^I have a file to analyze$/) do
  add_run_input SAMPLE_ANALYZE
end

Given(/^I have a file to shallow analyze$/) do
  add_run_input SAMPLE_ANALYZE_SHALLOW
end

Given(/^I have a failing test in my suite$/) do
  add_run_input SAMPLE_OLD_SPECTA_FAILURE
end

Given(/^all of my tests will pass in my suite$/) do
  3.times { add_run_input SAMPLE_OCUNIT_TEST }
end

Given(/^I have a passing test in my suite$/) do
  add_run_input SAMPLE_OCUNIT_TEST
end

Given(/^I have a slow\-ish test in my suite$/) do
  add_run_input SAMPLE_SLOWISH_TEST
end

Given(/^I have a slow test in my suite$/) do
  add_run_input SAMPLE_SLOW_TEST
end

Given(/^the tests have started running$/) do
  add_run_input SAMPLE_OCUNIT_TEST_RUN_BEGINNING
end

Given(/^I start a test suite$/) do
  add_run_input SAMPLE_OCUNIT_SUITE_BEGINNING
end

Given(/^the test suite has finished$/) do
  add_run_input SAMPLE_OCUNIT_SUITE_COMPLETION
  add_run_input SAMPLE_EXECUTED_TESTS
end

Given(/^I have a file to code sign$/) do
  add_run_input SAMPLE_CODESIGN
end

Given(/^I have a framework to code sign$/) do
  add_run_input SAMPLE_CODESIGN_FRAMEWORK
end

Given(/^I have a target which will not be code signed$/) do
  add_run_input SAMPLE_WILL_NOT_BE_CODE_SIGNED
end

Given(/^I have a file to preprocess$/) do
  add_run_input SAMPLE_PREPROCESS
end

Given(/^I have a file to copy with PBXCp/) do
  add_run_input SAMPLE_PBXCP
end

Given(/^podfile.lock wasn't in sync$/) do
  add_run_input SAMPLE_PODS_ERROR
end

Given(/^there was a syntax error$/) do
  add_run_input SAMPLE_COMPILE_ERROR
end

Given(/^there was a missing file$/) do
  add_run_input SAMPLE_FILE_MISSING_ERROR
end

Given(/^there were warnings in the code$/) do
  add_run_input SAMPLE_FORMAT_WARNING
end

Given(/^the linker has failed with undefined symbols$/) do
  add_run_input SAMPLE_UNDEFINED_SYMBOLS
end

Given(/^I have a pending test in my suite$/) do
  add_run_input SAMPLE_PENDING_KIWI_TEST
end

Given(/^I have a measuring test in my suite$/) do
  add_run_input SAMPLE_MEASURING_TEST
end

Given(/^I have a tiff file to validate$/) do
  add_run_input SAMPLE_TIFFUTIL
end

Given(/^I have a file to touch$/) do
  add_run_input SAMPLE_TOUCH
end

Given(/^I have a screenshot in the output folder/) do
  copy_file_to_screenshot_dir(SAMPLE_SCREENSHOT_FILE)
end

Given(/^I have an unrelated image in the output folder/) do
  copy_file_to_screenshot_dir(SAMPLE_UNRELATED_IMAGE_FILE)
end

Given(/^I have completed a build$/) do
  add_run_input SAMPLE_BUILD_SUCCEEDED
end

Given(/^I have completed a clean$/) do
  add_run_input SAMPLE_CLEAN_SUCCEEDED
end

Given(/^the provisioning profile doesn't support capability$/) do
  add_run_input SAMPLE_PROFILE_DOESNT_SUPPORT_CAPABILITY_ERROR
end

Given(/^the provisioning profile doesn't include entitlement$/) do
  add_run_input SAMPLE_PROFILE_DOESNT_INCLUDE_ENTITLEMENT_ERROR
end

Given(/^the target requires code signing$/) do
  add_run_input SAMPLE_CODE_SIGNING_IS_REQUIRED_ERROR
end

Given(/^the matching profile is missing$/) do
  add_run_input SAMPLE_NO_PROFILE_MATCHING_ERROR
end

Then(/^I should see a "(\w+)" completion message$/) do |phase|
  run_output.should start_with("▸ #{phase.capitalize} Succeeded")
end

Then(/^I should see text beginning with "(.*?)"$/) do |text|
  run_output.lines.to_a.detect { |line| line.start_with? text }.should_not be_nil
end

Then(/^I should see text containing "(.*?)" and beginning with "(.*?)"$/) do |inner, start|
  run_output.lines.to_a.detect { |line| line.start_with?(start) && line.include?(inner) }.should_not be_nil
end

Then(/^I should (green|red) text beginning with "(.*?)"$/) do |color, text|
  run_output.should start_with(send(color.to_sym, text))
end

Then(/^I should see a successful tiff validation message$/) do
  run_output.should start_with("▸ Validating")
end

Then(/^I should see a successful touch message$/) do
  run_output.should start_with("▸ Touching")
end

When(/^I pipe to xcpretty with "(.*?)"$/) do |flags|
  run_xcpretty(flags)
end

When(/^I pipe to xcpretty with a custom formatter$/) do
  formatter_path = File.expand_path('../../../spec/fixtures/custom_formatter.rb', __FILE__)
  run_xcpretty("-f #{formatter_path}")
end

Then(/^I should see a custom compilation message$/) do
  run_output.should start_with("😎 Compilation party time")
end

Then(/^I should see a successful compilation message$/) do
  run_output.should start_with("▸ Compiling")
end

Then(/^I should see a successful precompilation message$/) do
  run_output.should start_with("▸ Precompiling")
end

Then(/^I should see an aggregate target message$/) do
  run_output.should start_with("▸ Aggregate")
end

Then(/^I should see a successful analyze message$/) do
  run_output.should start_with("▸ Analyzing")
end

Then(/^I should see a successful code signing message$/) do
  run_output.should start_with("▸ Signing")
end

Then(/^I should see a target will not be code signed warning$/) do
  run_output.should include(yellow("⚠️  FrameworkName will not be code signed because its settings don't specify a development team."))
end

Then(/^I should see a successful preprocessing message$/) do
  run_output.should start_with("▸ Preprocessing")
end

Then(/^I should see a successful copying message$/) do
  run_output.should start_with("▸ Copying")
end

Then(/^I should see a yellow completion icon$/) do
  run_output.should start_with(yellow("▸"))
end

Then(/^I should see a failed test icon$/) do
  run_output.should start_with("F")
end

Then(/^I should see a passing test icon in ASCII$/) do
  run_output.should start_with(".")
end

Then(/^I should see a red failed test icon$/) do
  run_output.should include(red("F"))
end

Then(/^I should see a pending test icon in ASCII$/) do
  run_output.should start_with("P")
end

Then(/^I should see a yellow pending test icon$/) do
  run_output.should start_with(yellow("P"))
end

Then(/^I should see a measuring test icon in ASCII$/) do
  run_output.should start_with('T')
end

Then(/^I should see a yellow measuring test icon$/) do
  run_output.should start_with(yellow('T'))
end

Then(/^the final execution message should be (red|green)$/) do |color|
  last_line = run_output.lines.to_a.last
  last_line.should be_colored(color.to_sym)
end

Then(/^I should see a green passing test icon$/) do
  run_output.should include(green("."))
end

Then(/^I should see the name of a failed test$/) do
  run_output.should =~ FAILING_TEST_NAME_MATCHER
end

Then(/^I should see the path of a failed test$/) do
  run_output.should =~ TEST_PATH_MATCHER
end

Then(/^I should see the name of a passing test$/) do
  run_output.should =~ PASSING_TEST_NAME_MATCHER
end

Then(/^I should not see the path of a passing test$/) do
  run_output.should_not =~ TEST_PATH_MATCHER
end

Then(/^I should see that test suite has started$/) do
  run_output.should =~ TEST_RUN_START_MATCHER
end

Then(/^I should see the name of suite only$/) do
  run_output.should =~ TEST_SUITE_START_MATCHER
end

Then(/^I should see that the test suite finished$/) do
  run_output.strip.should =~ TEST_SUITE_COMPLETION_MATCHER
end

Then(/^I should see a red failed test mark$/) do
  run_output.should include(red("✗"))
end

Then(/^I should see a green passing test mark$/) do
  run_output.should include(green("✓"))
end

Then(/^I should see a non-utf prefixed output$/) do
  run_output.should start_with("    " + green("."))
end

Then(/^I should not see the name of the test group$/) do
  run_output.should_not include("RACTupleSpec")
end

Then(/^I should see a red error message$/) do
  run_output.should include(red("❌  error: ")[0..-5]) # trim \e[0m
end

Then(/^I should see that sandbox is not in sync with Podfile.lock$/) do
  run_output.should include("The sandbox is not in sync with the Podfile.lock")
end

Then(/^I should see which file is missing$/) do
  run_output.should include(SAMPLE_FILE_MISSING_ERROR.split('directory: ')[1].delete("'"))
end

Then(/^I should see a yellow warning message$/) do
  run_output.should include("#{yellow('⚠️  ')}/Users/supermarin/code/oss/ObjectiveSugar/Example/ObjectiveSugar/AppDelegate.m:19:31:")
  run_output.should include(yellow("format specifies type 'id' but the argument has type 'int' [-Wformat]"))
end

Then(/^I should see a red compilation error$/) do
  run_output.should include(red("expected identifier"))
end

Then(/^I should see a failed line$/) do
  run_output.should include("[[thread.lastMessage should] equal:thread.];")
end

Then(/^I should see a cyan cursor$/) do
  run_output.should include(cyan("                                                          ^"))
end

Then(/^I should see the undefined symbold message$/) do
  run_output.should include(red("❌  Undefined symbols for architecture x86_64"))
end

Then(/^I should see the symbol and reference that caused failure$/) do
  run_output.should include("_OBJC_CLASS_$_CABasicAnimation")
  run_output.should include("objc-class-ref in ATZRadialProgressControl.o")
end

Then(/^I should see the name of a pending test$/) do
  run_output.should =~ PENDING_TEST_NAME_MATCHER
end

Then(/^I should see the name of a measuring test$/) do
  run_output.should =~ MEASURING_TEST_NAME_MATCHER
end

Then(/^I should see the test time in yellow$/) do
  run_output.should include("#{yellow("0.026")}")
end

Then(/^I should see the test time in red$/) do
  run_output.should include("#{red("0.101")}")
end

Then(/^I should see text matching "(.*?)"$/) do |text|
  run_output.lines.to_a.last.strip.should == text
end

Then(/^I should see the profile doesn't support capability message$/) do
  run_output.should include("Provisioning profile \"Profile Name\" doesn't support the Push Notifications capability.")
end

Then(/^I should see the profile doesn't include entitlement message$/) do
  run_output.should include("Provisioning profile \"Profile Name\" doesn't include the aps-environment entitlement.")
end

Then(/^I should see the code signing is requried message$/) do
  run_output.should include("Code signing is required for product type 'Application' in SDK 'iOS 10.0'")
end

Then(/^I should see the no profile matching message$/) do
  run_output.should include("No profile matching 'TargetName' found:  Xcode couldn't find a profile matching 'TargetName'. Install the profile (by dragging and dropping it onto Xcode's dock item) or select a different one in the General tab of the target editor.")
end

