# This code sets the following variables:
# 
#  LIBUUID_FOUND               True if libuuid got found
#  LIBUUID_INCLUDE_DIRS        Location of libuuid headers
#  LIBUUID_LIBRARIES           List of libraries to use libuuid 

FIND_PATH(LIBUUID_INCLUDE_DIRS uuid/uuid.h)
FIND_LIBRARY(LIBUUID_LIBRARIES uuid)

IF (LIBUUID_LIBRARIES AND LIBUUID_INCLUDE_DIRS)       
	SET(LIBUUID_FOUND 1)
	IF (NOT LibUuid_FIND_QUIETLY)
		MESSAGE(STATUS "Found libuuid: ${LIBUUID_LIBRARIES}")
	ENDIF ( NOT LibUuid_FIND_QUIETLY )
ELSE (LIBUUID_LIBRARIES AND LIBUUID_INCLUDE_DIRS)     
	IF (LibUuid_FIND_REQUIRED)
		MESSAGE(SEND_ERROR "Could NOT find libuuid")
	ELSE (LibUuid_FIND_REQUIRED)
		IF (NOT LIBUUID_FIND_QUIETLY)
			MESSAGE(STATUS "Could NOT find libuuid")     
		ENDIF (NOT LIBUUID_FIND_QUIETLY)
	ENDIF (LibUuid_FIND_REQUIRED)
ENDIF (LIBUUID_LIBRARIES AND LIBUUID_INCLUDE_DIRS)

MARK_AS_ADVANCED(LIBUUID_LIBRARIES LIBUUID_INCLUDE_DIRS)
