/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class TraceDebugFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private final Logger log;
    private boolean logHttp;

    TraceDebugFilter(boolean logHttp, Logger log) {
        this.logHttp = logHttp;
        this.log = log;
    }

    public TraceDebugFilter(boolean logHttp) {
        this(logHttp, LoggerFactory.getLogger(TraceDebugFilter.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPayloadAsString(ClientResponseContext response) {
        ByteArrayInputStream entityInputStream = null;
        try {
            entityInputStream = (ByteArrayInputStream)response.getEntityStream();
            int available = entityInputStream.available();
            byte[] data = new byte[available];
            entityInputStream.read(data);
            String string = new String(data, 0, available, Charsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            this.log.warn("can't read response payload");
            String string = "[error reading response]";
            return string;
        }
        finally {
            if (entityInputStream != null) {
                entityInputStream.reset();
            }
        }
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"})
    void log(String formattedMessage) {
        if (this.logHttp) {
            this.log.info(formattedMessage);
        } else {
            this.log.trace(formattedMessage);
        }
    }

    private String maskHeaderValues(List<Object> headerValues) {
        ArrayList<String> maskedList = new ArrayList<String>(headerValues.size());
        for (Object actualValue : headerValues) {
            maskedList.add(actualValue.toString().replaceAll(".", "*"));
        }
        return ((Object)maskedList).toString();
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (!this.logHttp && !this.log.isTraceEnabled()) {
            return;
        }
        this.log(">> REST Request: " + requestContext.getMethod() + " => " + requestContext.getUri());
        for (String key : requestContext.getHeaders().keySet()) {
            String headerVal = ((List)requestContext.getHeaders().get((Object)key)).toString();
            if (key.equals("X-Auth-Token")) {
                headerVal = this.maskHeaderValues((List)requestContext.getHeaders().get((Object)key));
            }
            this.log(">> Header: " + key + " = " + headerVal);
        }
        this.log(">> body: " + requestContext.getEntity());
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (!this.logHttp && !this.log.isTraceEnabled()) {
            return;
        }
        this.log("<< REST Response: " + responseContext.getStatus() + ":" + responseContext.getStatusInfo());
        for (String key : responseContext.getHeaders().keySet()) {
            this.log("<< Header: " + key + " = " + responseContext.getHeaders().get((Object)key));
        }
        this.log(">> Body: " + this.getPayloadAsString(responseContext));
    }
}

