/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.glossary;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.adapter.glossary.AbstractGlossaryPullWriter;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.GlossaryTerm;

public class GlossaryCSVWriter
extends AbstractGlossaryPullWriter {
    private static final Logger log = LoggerFactory.getLogger(GlossaryCSVWriter.class);
    private static final String NEW_LINE_SEPARATOR = "\n";

    public void write(@Nonnull OutputStream stream, @Nonnull List<GlossaryEntry> entries, @Nonnull LocaleId srcLocale, @Nonnull List<LocaleId> transLocales) throws IOException {
        OutputStreamWriter osWriter = new OutputStreamWriter(stream, Charsets.UTF_8);
        this.write(osWriter, entries, srcLocale, transLocales);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nonnull Writer fileWriter, @Nonnull List<GlossaryEntry> entries, @Nonnull LocaleId srcLocale, @Nonnull List<LocaleId> transLocales) throws IOException {
        if (fileWriter == null) {
            log.warn("Missing fileWriter.");
            return;
        }
        if (entries == null) {
            log.warn("No glossary entries to process.");
            return;
        }
        if (srcLocale == null || transLocales == null) {
            log.warn("Missing source locale and translation locales.");
            return;
        }
        CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.DEFAULT.withRecordSeparator(NEW_LINE_SEPARATOR));
        try {
            List<String> header = this.generateHeader(srcLocale, transLocales);
            log.debug("Writing header-{}", header);
            csvPrinter.printRecord(header);
            for (GlossaryEntry entry : entries) {
                GlossaryTerm srcTerm = this.getGlossaryTerm(entry.getGlossaryTerms(), srcLocale);
                ArrayList row = Lists.newArrayList();
                row.add(srcTerm != null ? srcTerm.getContent() : "");
                for (LocaleId transLocale : transLocales) {
                    GlossaryTerm transTerm = this.getGlossaryTerm(entry.getGlossaryTerms(), transLocale);
                    row.add(transTerm != null ? transTerm.getContent() : "");
                }
                int totalSize = header.size();
                row.add(this.getPosColumn(totalSize), entry.getPos());
                row.add(this.getDescColumn(totalSize), entry.getDescription());
                log.debug("Writing row-{}", (Object)row);
                csvPrinter.printRecord((Iterable)row);
            }
        }
        finally {
            csvPrinter.flush();
            csvPrinter.close();
        }
    }

    private List<String> generateHeader(LocaleId srcLocale, List<LocaleId> transLocales) {
        int size = transLocales.size() + 3;
        ArrayList result = Lists.newArrayList();
        result.add(0, srcLocale.toString());
        int index = 1;
        for (LocaleId transLocale : transLocales) {
            result.add(index, transLocale.toString());
            ++index;
        }
        String pos = "pos";
        String desc = "description";
        result.add(this.getPosColumn(size), pos);
        result.add(this.getDescColumn(size), desc);
        return result;
    }

    private int getPosColumn(int totalSize) {
        return totalSize - 2;
    }

    private int getDescColumn(int totalSize) {
        return totalSize - 1;
    }
}

