/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Project;

public class ProjectClient {
    private final RestClientFactory factory;
    private final String projectSlug;

    ProjectClient(RestClientFactory factory, String projectSlug) {
        this.factory = factory;
        this.projectSlug = projectSlug;
    }

    public Project get() {
        try {
            return (Project)this.webResource().get(Project.class);
        }
        catch (ResponseProcessingException rpe) {
            if (rpe.getResponse().getStatus() == 404) {
                return null;
            }
            throw rpe;
        }
    }

    private Invocation.Builder webResource() {
        return this.factory.getClient().target(this.factory.getBaseUri()).path("projects").path("p").path(this.projectSlug).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
    }

    public Response put(Project project) {
        Response response = this.webResource().put(Entity.xml((Object)project));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new RuntimeException(response.getStatusInfo().toString());
        }
        response.close();
        return response;
    }
}

